# Atari 2600 (TIA)

help me! I can't even get this character in where I want!
I've spent hours debugging the issue, counting every possible cycle and I still cannot get it right!

only 2 channels and 31 frequencies?!

Furnace isn't complete without this one...

## effects

- `10xx`: **select shape.**
  - `0`: nothing
  - `1`: buzzy
  - `2`: low buzzy
  - `3`: flangy
  - `4`: square
  - `5`: square
  - `6`: pure buzzy
  - `7`: reedy
  - `8`: noise
  - `9`: reedy
  - `A`: pure buzzy
  - `B`: nothing
  - `C`: low square
  - `D`: low square
  - `E`: low pure buzzy
  - `F`: low reedy

## ROM export

a song can be exported to assembly code for use with the TIunA software driver for the Atari 2600. see [TIunA on GitHub](https://github.com/AYCEdemo/twin-tiuna) for explanations of the export options.

## chip config

the following options are available in the Chip Manager window:

- **Software pitch driver**: use TIunA, a software pitch driver similar to TIATune. it increases pitch precision by rapidly switching between two pitches. pitches are still limited to their original range; see pitch tables below.
- **Old pitch table**: use an older method to calculate pitch. only for compatibility.
- **Mixing mode**: changes mixing mode.
  - **Mono**: normal output.
  - **Mono (no distortion)**: process each channel separately to eliminate distortion.
  - **Stereo**: output two channels on left and right.
- **PAL**: runs at a slightly different clock rate, affecting pitch.

## info

this chip uses the [TIA](../4-instrument/tia.md) instrument editor.

the arp macro's fixed mode operates differently, writing the direct pitch to the chip. here's a list of pitches.

### shape 1

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |  2096.0 |  C-7 |   +2 |  2080.0 |  C-7 |   -1
|     1 |  1048.0 |  C-6 |   +2 |  1040.0 |  C-6 |   -1
|     2 |   698.7 |  F-5 |   0.0|   693.3 |  F-5 |   -1
|     3 |   524.0 |  C-5 |   +2 |   520.0 |  C-5 |   -1
|     4 |   419.2 |  G#4 |  +16 |   416.0 |  G#4 |   +3
|     5 |   349.3 |  F-4 |   0.0|   346.7 |  F-4 |  -13
|     6 |   299.4 |  D-4 |  +33 |   297.1 |  D-4 |  +20
|     7 |   262.0 |  C-4 |   +3 |   260.0 |  C-4 |  -11
|     8 |   232.9 |  A#3 |   -2 |   231.1 |  A#3 |  -15
|     9 |   209.6 |  G#3 |  +15 |   208.0 |  G#3 |   +2
|    10 |   190.5 |  F#3 |  +50 |   189.1 |  F#3 |  +37
|    11 |   174.7 |  F-3 |   +1 |   173.3 |  F-3 |  -13
|    12 |   161.2 |  E-3 |  -39 |   160.0 |  D#3 |  +48
|    13 |   149.7 |  D-3 |  +33 |   148.6 |  D-3 |  +20
|    14 |   139.7 |  C#3 |  +13 |   138.7 |  C#3 |   +1
|    15 |   131.0 |  C-3 |   +3 |   130.0 |  C-3 |  -11
|    16 |   123.3 |  B-2 |   -3 |   122.4 |  B-2 |  -16
|    17 |   116.4 |  A#2 |   0.0|   115.6 |  A#2 |  -14
|    18 |   110.3 |  A-2 |   +5 |   109.5 |  A-2 |   -8
|    19 |   104.8 |  G#2 |  +16 |   104.0 |  G#2 |   +3
|    20 |    99.8 |  G-2 |  +31 |    99.0 |  G-2 |  +17
|    21 |    95.3 |  G-2 |  -49 |    94.5 |  F#2 |  +36
|    22 |    91.1 |  F#2 |  -27 |    90.4 |  F#2 |  -40
|    23 |    87.3 |  F-2 |   0.0|    86.7 |  F-2 |  -12
|    24 |    83.8 |  E-2 |  +29 |    83.2 |  E-2 |  +16
|    25 |    80.6 |  E-2 |  -39 |    80.0 |  D#2 |  +48
|    26 |    77.6 |  D#2 |   -5 |    77.0 |  D#2 |  -18
|    27 |    74.9 |  D-2 |  +34 |    74.3 |  D-2 |  +20
|    28 |    72.3 |  D-2 |  -27 |    71.7 |  D-2 |  -41
|    29 |    69.9 |  C#2 |  +15 |    69.3 |  C#2 |   0
|    30 |    67.6 |  C#2 |  -44 |    67.1 |  C-2 |  +44
|    31 |    65.5 |  C-2 |   +3 |    65.0 |  C-2 |  -11

### shapes 2 and 3

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |    67.6 |  C#2 |  -44 |    67.1 |  C-2 |  +44
|     1 |    33.8 |  C#1 |  -42 |    33.5 |  C-1 |  +42
|     2 |    22.5 |  F#0 |  -46 |    22.4 |  F-0 |  +46
|     3 |    16.9 |  C#0 |  -44 |    16.8 |  C-0 |  +44
|     4 |    13.5 |      |      |    13.4
|     5 |    11.3 |      |      |    11.2
|     6 |     9.7 |      |      |     9.6
|     7 |     8.5 |      |      |     8.4
|     8 |     7.5 |      |      |     7.5
|     9 |     6.8 |      |      |     6.7
|    10 |     6.1 |      |      |     6.1
|    11 |     5.6 |      |      |     5.6
|    12 |     5.2 |      |      |     5.2
|    13 |     4.8 |      |      |     4.8
|    14 |     4.5 |      |      |     4.5
|    15 |     4.2 |      |      |     4.2
|    16 |     4.0 |      |      |     4.0
|    17 |     3.8 |      |      |     3.7
|    18 |     3.6 |      |      |     3.5
|    19 |     3.4 |      |      |     3.4
|    20 |     3.2 |      |      |     3.2
|    21 |     3.1 |      |      |     3.0
|    22 |     3.0 |      |      |     2.9
|    23 |     2.8 |      |      |     2.8
|    24 |     2.7 |      |      |     2.7
|    25 |     2.6 |      |      |     2.6
|    26 |     2.5 |      |      |     2.5
|    27 |     2.4 |      |      |     2.4
|    28 |     2.3 |      |      |     2.3
|    29 |     2.3 |      |      |     2.2
|    30 |     2.2 |      |      |     2.2
|    31 |     2.1 |      |      |     2.1

### shapes 4 and 5

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 | 15720.0 |  B-9 |   -9 | 15600.0 | B-9  |  -23
|     1 |  7860.0 |  B-8 |   -9 |  7800.0 | B-8  |  -23
|     2 |  5240.0 |  E-8 |  -11 |  5200.0 | E-8  |  -25
|     3 |  3930.0 |  B-7 |  -10 |  3900.0 | B-7  |  -23
|     4 |  3144.0 |  G-7 |   +4 |  3120.0 | G-7  |   -9
|     5 |  2620.0 |  E-7 |  -11 |  2600.0 | E-7  |  -25
|     6 |  2245.7 |  C#7 |  +21 |  2228.6 | C#7  |   +8
|     7 |  1965.0 |  B-6 |   -9 |  1950.0 | B-6  |  -23
|     8 |  1746.7 |  A-6 |  -13 |  1733.3 | A-6  |  -27
|     9 |  1572.0 |  G-6 |   +4 |  1560.0 | G-6  |   -9
|    10 |  1429.1 |  F-6 |  +39 |  1418.2 | F-6  |  +25
|    11 |  1310.0 |  E-6 |  -11 |  1300.0 | E-6  |  -25
|    12 |  1209.2 |  D-6 |  +49 |  1200.0 | D-6  |  +36
|    13 |  1122.9 |  C#6 |  +22 |  1114.3 | C#6  |   +8
|    14 |  1048.0 |  C-6 |   +2 |  1040.0 | C-6  |  -11
|    15 |   982.5 |  B-5 |  -10 |   975.0 | B-5  |  -23
|    16 |   924.7 |  A#5 |  -15 |   917.6 | A#5  |  -28
|    17 |   873.3 |  A-5 |  -14 |   866.7 | A-5  |  -27
|    18 |   827.4 |  G#5 |   -7 |   821.1 | G#5  |  -20
|    19 |   786.0 |  G-5 |   +4 |   780.0 | G-5  |   -9
|    20 |   748.6 |  F#5 |  +20 |   742.9 | F#5  |   +7
|    21 |   714.5 |  F-5 |  +39 |  709.1  | F-5  |  +26
|    22 |   683.5 |  F-5 |  -38 |   678.3 | E-5  |  +48
|    23 |   655.0 |  E-5 |  -12 |   650.0 | E-5  |  -25
|    24 |   628.8 |  D#5 |  +18 |   624.0 | D#5  |   +5
|    25 |   604.6 |  D-5 |  +49 |   600.0 | D-5  |  +36
|    26 |   582.2 |  D-5 |  -16 |   577.8 | D-5  |  -29
|    27 |   561.4 |  C#5 |  +21 |   557.1 | C#5  |   +8
|    28 |   542.1 |  C#5 |  -40 |   537.9 | C-5  |  +47
|    29 |   524.0 |  C-5 |   +2 |   520.0 | C-5  |  -11
|    30 |   507.1 |  B-4 |  +45 |   503.2 | B-4  |  +32
|    31 |   491.3 |  B-4 |   -9 |   487.5 | B-4  |  -23

### shapes 6, 7, 9 and 10

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |  1014.2 |  B-5 |  +45 |  1006.5 |  B-5 |  +32
|     1 |   507.1 |  B-4 |  +45 |   503.2 |  B-4 |  +32
|     2 |   338.1 |  E-4 |  +43 |   335.5 |  E-4 |  +30
|     3 |   253.5 |  B-3 |  +45 |   251.6 |  B-3 |  +32
|     4 |   202.8 |  G#3 |  -42 |   201.3 |  G-3 |  +45
|     5 |   169.0 |  E-3 |  +43 |   167.7 |  E-3 |  +30
|     6 |   144.9 |  D-3 |  -23 |   143.8 |  D-3 |  -37
|     7 |   126.8 |  B-2 |  +42 |   125.8 |  B-2 |  +32
|     8 |   112.7 |  A-2 |  +42 |   111.8 |  A-2 |  +28
|     9 |   101.4 |  G#2 |  -41 |   100.6 |  G-2 |  +45
|    10 |    92.2 |  F#2 |   -6 |    91.5 |  F#2 |  -19
|    11 |    84.5 |  E-2 |  +43 |    83.9 |  E-2 |  +31
|    12 |    78.0 |  D#2 |   +4 |    77.4 |  D#2 |   -9
|    13 |    72.4 |  D-2 |  -24 |    71.9 |  D-2 |  -37
|    14 |    67.6 |  C#2 |  -44 |    67.1 |  C-2 |  +44
|    15 |    63.4 |  B-1 |  +46 |    62.9 |  B-1 |  +32
|    16 |    59.7 |  A#1 |  +41 |    59.2 |  A#1 |  +26
|    17 |    56.3 |  A-1 |  +39 |    55.9 |  A-1 |  +27
|    18 |    53.4 |  G#1 |  +48 |    53.0 |  G#1 |  +35
|    19 |    50.7 |  G#1 |  -41 |    50.3 |  G-1 |  +45
|    20 |    48.3 |  G-1 |  -25 |    47.9 |  G-1 |  -39
|    21 |    46.1 |  F#1 |   -4 |    45.7 |  F#1 |  -20
|    22 |    44.1 |  F-1 |  +16 |    43.8 |  F-1 |   +4
|    23 |    42.3 |  E-1 |  +44 |    41.9 |  E-1 |  +28
|    24 |    40.6 |  E-1 |  -26 |    40.3 |  E-1 |  -39
|    25 |    39.0 |  D#1 |   +4 |    38.7 |  D#1 |   -9
|    26 |    37.6 |  D-1 |  +41 |    37.3 |  D-1 |  +27
|    27 |    36.2 |  D-1 |  -24 |    35.9 |  D-1 |  -38
|    28 |    35.0 |  C#1 |  +19 |    34.7 |  C#1 |   +5
|    29 |    33.8 |  C#1 |  -42 |    33.5 |  C-1 |  +42
|    30 |    32.7 |  C-1 |  0.0 |    32.5 |  C-1 |  -11
|    31 |    31.7 |  B-0 |  +44 |    31.5 |  B-0 |  +33

### shape 8

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |    61.5 |  B-1 |    -6|    61.1 |  B-1 |  -18
|     1 |    30.8 |  B-0 |    -6|    30.5 |  B-0 |  -22
|     2 |    20.5 |  E-0 |    -8|    20.4 |  E-0 |  -17
|     3 |    15.4 |      |      |    15.3
|     4 |    12.3 |      |      |    12.2
|     5 |    10.3 |      |      |    10.2
|     6 |     8.8 |      |      |     8.7
|     7 |     7.7 |      |      |     7.6
|     8 |     6.8 |      |      |     6.8
|     9 |     6.2 |      |      |     6.1
|    10 |     5.6 |      |      |     5.6
|    11 |     5.1 |      |      |     5.1
|    12 |     4.7 |      |      |     4.7
|    13 |     4.4 |      |      |     4.4
|    14 |     4.1 |      |      |     4.1
|    15 |     3.8 |      |      |     3.8
|    16 |     3.6 |      |      |     3.6
|    17 |     3.4 |      |      |     3.4
|    18 |     3.2 |      |      |     3.2
|    19 |     3.1 |      |      |     3.1
|    20 |     2.9 |      |      |     2.9
|    21 |     2.8 |      |      |     2.8
|    22 |     2.7 |      |      |     2.7
|    23 |     2.6 |      |      |     2.5
|    24 |     2.5 |      |      |     2.4
|    25 |     2.4 |      |      |     2.3
|    26 |     2.3 |      |      |     2.3
|    27 |     2.2 |      |      |     2.2
|    28 |     2.1 |      |      |     2.1
|    29 |     2.0 |      |      |     2.0
|    30 |     2.0 |      |      |     2.0
|    31 |     1.9 |      |      |     1.9

### shapes 12 and 13

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |  5240.0 |  E-8 |  -11 |  5200.0 |  E-8 |  -25
|     1 |  2620.0 |  E-7 |  -11 |  2600.0 |  E-7 |  -25
|     2 |  1746.6 |  A-6 |  -14 |  1733.3 |  A-6 |  -27
|     3 |  1310.0 |  E-6 |  -11 |  1300.0 |  E-6 |  -25
|     4 |  1048.0 |  C-6 |   +2 |  1040.0 |  C-6 |  -11
|     5 |   873.3 |  A-5 |  -14 |  866.7  |  A-5 |  -27
|     6 |   748.6 |  F#5 |  +20 |  742.9  |  F#5 |   +7
|     7 |   655.0 |  E-5 |  -12 |  650.0  |  E-5 |  -25
|     8 |   582.2 |  D-5 |  -16 |  577.8  |  D-5 |  -29
|     9 |   524.0 |  C-5 |   +2 |  520.0  |  C-5 |  -11
|    10 |   476.4 |  A#4 |  +39 |  472.7  |  A#4 |  +23
|    11 |   436.7 |  A-4 |  -13 |  433.3  |  A-4 |  -27
|    12 |   403.1 |  G-4 |  +48 |  400.0  |  G-4 |  +34
|    13 |   374.3 |  F#4 |  +20 |  371.4  |  F#4 |   +6
|    14 |   349.3 |  F-4 |  0.0 |  346.7  |  F-4 |  -13
|    15 |   327.5 |  E-4 |  -11 |  325.0  |  E-4 |  -25
|    16 |   308.2 |  D#4 |  -17 |  305.9  |  D#4 |  -30
|    17 |   291.1 |  D-4 |  -16 |  288.9  |  D-4 |  -29
|    18 |   275.8 |  C#4 |   -9 |  273.7  |  C#4 |  -22
|    19 |   262.0 |  C-4 |   +3 |  260.0  |  C-4 |  -11
|    20 |   249.5 |  B-3 |  +18 |  247.6  |  B-3 |   +5
|    21 |   238.2 |  A#3 |  +37 |  236.4  |  A#3 |  +24
|    22 |   227.8 |  A#3 |  -40 |  226.1  |  A-3 |  +47
|    23 |   218.3 |  A-3 |  -14 |  216.7  |  A-3 |  -27
|    24 |   209.6 |  G#3 |  +15 |  208.0  |  G#3 |   +2
|    25 |   201.5 |  G-3 |  +47 |  200.0  |  G-3 |  +34
|    26 |   194.1 |  G-3 |  -17 |  192.6  |  G-3 |  -31
|    27 |   187.1 |  F#3 |  +19 |  185.7  |  F#3 |   +6
|    28 |   180.7 |  F#3 |  -41 |  179.3  |  F-3 |  +45
|    29 |   174.7 |  F-3 |   +1 |  173.3  |  F-3 |  -13
|    30 |   169.0 |  E-3 |  +43 |  167.7  |  E-3 |  +30
|    31 |   163.8 |  E-3 |  -11 |  162.5  |  E-3 |  -25

### shapes 14 and 15

| pitch |    NTSC | note | cent |    PAL  | note | cent
|------:|--------:|:----:|-----:|--------:|:----:|-----:
|     0 |   338.1 |  E-4 |  +43 |   335.5 |  E-4 |  +30
|     1 |   169.0 |  E-3 |  +43 |   167.7 |  E-3 |  +30
|     2 |   112.7 |  A-2 |  +42 |   111.8 |  A-2 |  +28
|     3 |    84.5 |  E-2 |  +43 |    83.9 |  E-2 |  +31
|     4 |    67.6 |  C#2 |  -44 |    67.1 |  C-2 |  +44
|     5 |    56.3 |  A-1 |  +39 |    55.9 |  A-1 |  +27
|     6 |    48.3 |  G-1 |  -25 |    47.9 |  G-1 |  -39
|     7 |    42.3 |  E-1 |  +44 |    41.9 |  E-1 |  +28
|     8 |    37.6 |  D-1 |  +41 |    37.3 |  D-1 |  +27
|     9 |    33.8 |  C#1 |  -42 |    33.5 |  C-1 |  +42
|    10 |    30.7 |  B-0 |  -11 |    30.5 |  B-0 |  -22
|    11 |    28.2 |  A-0 |  +44 |    28.0 |  A-0 |  +31
|    12 |    26.0 |  G#0 |  0.0 |    25.8 |  G#0 |  -13
|    13 |    24.1 |  G-0 |  -29 |    24.0 |  G-0 |  -36
|    14 |    22.5 |  F#0 |  -46 |    22.4 |  F-0 |  +46
|    15 |    21.1 |  E-0 |  +42 |    21.0 |  E-0 |  +33
|    16 |    19.9 |  D#0 |  +42 |    19.7 |  D#0 |  +25
|    17 |    18.8 |  D-0 |  +40 |    18.6 |  D-0 |  +20
|    18 |    17.8 |  C#0 |  +45 |    17.7 |  C#0 |  +36
|    19 |    16.9 |  C#0 |  -44 |    16.8 |  C-0 |  +44
|    20 |    16.1 |  C-0 |  -30 |    16.0 |  C-0 |  -40
|    21 |    15.4 |      |      |    15.2
|    22 |    14.7 |      |      |    14.6
|    23 |    14.1 |      |      |    14
|    24 |    13.5 |      |      |    13.4
|    25 |    13.0 |      |      |    12.9
|    26 |    12.5 |      |      |    12.4
|    27 |    12.1 |      |      |    12
|    28 |    11.7 |      |      |    11.6
|    29 |    11.3 |      |      |    11.2
|    30 |    10.9 |      |      |    10.8
|    31 |    10.6 |      |      |    10.5

reference: [Atari 2600 VCS Sound Frequency and Waveform Guide](http://7800.8bitdev.org/index.php/Atari_2600_VCS_Sound_Frequency_and_Waveform_Guide)
