/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.BuiltinDatatypeLibrary;
import com.thaiopensource.relaxng.impl.CompatibilityDatatypeLibrary;
import java.util.Hashtable;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

class BuiltinDatatypeLibraryFactory
implements DatatypeLibraryFactory {
    private final Hashtable cache = new Hashtable();
    private final DatatypeLibraryFactory factory;
    private final DatatypeLibrary builtinDatatypeLibrary = new BuiltinDatatypeLibrary();
    private DatatypeLibrary lastDatatypeLibrary = null;
    private String lastDatatypeLibraryUri = null;

    BuiltinDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.factory = datatypeLibraryFactory;
        this.cache.put("http://relaxng.org/ns/compatibility/datatypes/1.0", new CompatibilityDatatypeLibrary(this));
    }

    public DatatypeLibrary createDatatypeLibrary(String string) {
        if (string.equals("")) {
            return this.builtinDatatypeLibrary;
        }
        if (string.equals(this.lastDatatypeLibraryUri)) {
            return this.lastDatatypeLibrary;
        }
        DatatypeLibrary datatypeLibrary = (DatatypeLibrary)this.cache.get(string);
        if (datatypeLibrary == null) {
            if (this.factory == null) {
                return null;
            }
            datatypeLibrary = this.factory.createDatatypeLibrary(string);
            if (datatypeLibrary == null) {
                return null;
            }
            this.cache.put(string, datatypeLibrary);
        }
        this.lastDatatypeLibraryUri = string;
        this.lastDatatypeLibrary = datatypeLibrary;
        return this.lastDatatypeLibrary;
    }
}

