/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

// This implements the "Action Dialog" pattern from the HIG.
// Used for getting extra info after clicking an action button
// (like Print - or Restore in our case).

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/ActionDialog.ui")]
class ActionDialog : Adw.Dialog
{
  public bool accept_enabled {get; set; default=true;}
  public string accept_label {get; set;}
  public Gtk.Widget content {get; set;}

  public signal void accepted();

  protected virtual void accept() {}

  ~ActionDialog()
  {
    debug("Finalizing ActionDialog\n");
  }

  [GtkCallback]
  void handle_cancel()
  {
    close();
  }

  [GtkCallback]
  void handle_accept()
  {
    accepted();
    accept();
    close();
  }
}
