/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 15924 script list

   Written by Moritz Bunkus <mo@bunkus.online>.
*/

// -------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso15924_list" rake target.
// -------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso15924.h"

namespace mtx::iso15924 {

std::vector<script_t> g_scripts;

struct script_init_t {
  char const *code;
  unsigned int number;
  char const *english_name;
  bool is_deprecated;
};

static script_init_t const s_scripts_init[] = {
  { "Adlm", 166, "Adlam",                                                                                           false },
  { "Afak", 439, "Afaka",                                                                                           false },
  { "Aghb", 239, "Caucasian Albanian",                                                                              false },
  { "Ahom", 338, "Ahom, Tai Ahom",                                                                                  false },
  { "Arab", 160, "Arabic",                                                                                          false },
  { "Aran", 161, "Arabic (Nastaliq variant)",                                                                       false },
  { "Armi", 124, "Imperial Aramaic",                                                                                false },
  { "Armn", 230, "Armenian",                                                                                        false },
  { "Avst", 134, "Avestan",                                                                                         false },
  { "Bali", 360, "Balinese",                                                                                        false },
  { "Bamu", 435, "Bamum",                                                                                           false },
  { "Bass", 259, "Bassa Vah",                                                                                       false },
  { "Batk", 365, "Batak",                                                                                           false },
  { "Beng", 325, "Bengali (Bangla)",                                                                                false },
  { "Berf", 258, "Beria Erfe",                                                                                      false },
  { "Bhks", 334, "Bhaiksuki",                                                                                       false },
  { "Blis", 550, "Blissymbols",                                                                                     false },
  { "Bopo", 285, "Bopomofo",                                                                                        false },
  { "Brah", 300, "Brahmi",                                                                                          false },
  { "Brai", 570, "Braille",                                                                                         false },
  { "Bugi", 367, "Buginese",                                                                                        false },
  { "Buhd", 372, "Buhid",                                                                                           false },
  { "Cakm", 349, "Chakma",                                                                                          false },
  { "Cans", 440, "Unified Canadian Aboriginal Syllabics",                                                           false },
  { "Cari", 201, "Carian",                                                                                          false },
  { "Cham", 358, "Cham",                                                                                            false },
  { "Cher", 445, "Cherokee",                                                                                        false },
  { "Chis", 298, "Chisoi",                                                                                          false },
  { "Chrs", 109, "Chorasmian",                                                                                      false },
  { "Cirt", 291, "Cirth",                                                                                           false },
  { "Copt", 204, "Coptic",                                                                                          false },
  { "Cpmn", 402, "Cypro-Minoan",                                                                                    false },
  { "Cprt", 403, "Cypriot syllabary",                                                                               false },
  { "Cyrl", 220, "Cyrillic",                                                                                        false },
  { "Cyrs", 221, "Cyrillic (Old Church Slavonic variant)",                                                          false },
  { "Deva", 315, "Devanagari (Nagari)",                                                                             false },
  { "Diak", 342, "Dives Akuru",                                                                                     false },
  { "Dogr", 328, "Dogra",                                                                                           false },
  { "Dsrt", 250, "Deseret (Mormon)",                                                                                false },
  { "Dupl", 755, "Duployan shorthand, Duployan stenography",                                                        false },
  { "Egyd",  70, "Egyptian demotic",                                                                                false },
  { "Egyh",  60, "Egyptian hieratic",                                                                               false },
  { "Egyp",  50, "Egyptian hieroglyphs",                                                                            false },
  { "Elba", 226, "Elbasan",                                                                                         false },
  { "Elym", 128, "Elymaic",                                                                                         false },
  { "Ethi", 430, "Ethiopic (Geʻez)",                                                                                false },
  { "Gara", 164, "Garay",                                                                                           false },
  { "Geok", 241, "Khutsuri (Asomtavruli and Nuskhuri)",                                                             false },
  { "Geor", 240, "Georgian (Mkhedruli and Mtavruli)",                                                               false },
  { "Glag", 225, "Glagolitic",                                                                                      false },
  { "Gong", 312, "Gunjala Gondi",                                                                                   false },
  { "Gonm", 313, "Masaram Gondi",                                                                                   false },
  { "Goth", 206, "Gothic",                                                                                          false },
  { "Gran", 343, "Grantha",                                                                                         false },
  { "Grek", 200, "Greek",                                                                                           false },
  { "Gujr", 320, "Gujarati",                                                                                        false },
  { "Gukh", 397, "Gurung Khema",                                                                                    false },
  { "Guru", 310, "Gurmukhi",                                                                                        false },
  { "Hanb", 503, "Han with Bopomofo (alias for Han + Bopomofo)",                                                    false },
  { "Hang", 286, "Hangul (Hangŭl, Hangeul)",                                                                        false },
  { "Hani", 500, "Han (Hanzi, Kanji, Hanja)",                                                                       false },
  { "Hano", 371, "Hanunoo (Hanunóo)",                                                                               false },
  { "Hans", 501, "Han (Simplified variant)",                                                                        false },
  { "Hant", 502, "Han (Traditional variant)",                                                                       false },
  { "Hatr", 127, "Hatran",                                                                                          false },
  { "Hebr", 125, "Hebrew",                                                                                          false },
  { "Hira", 410, "Hiragana",                                                                                        false },
  { "Hluw",  80, "Anatolian Hieroglyphs (Luwian Hieroglyphs, Hittite Hieroglyphs)",                                 false },
  { "Hmng", 450, "Pahawh Hmong",                                                                                    false },
  { "Hmnp", 451, "Nyiakeng Puachue Hmong",                                                                          false },
  { "Hntl", 504, "Han (Traditional variant) with Latin (alias for Hant + Latn)",                                    false },
  { "Hrkt", 412, "Japanese syllabaries (alias for Hiragana + Katakana)",                                            false },
  { "Hung", 176, "Old Hungarian (Hungarian Runic)",                                                                 false },
  { "Inds", 610, "Indus (Harappan)",                                                                                false },
  { "Ital", 210, "Old Italic (Etruscan, Oscan, etc.)",                                                              false },
  { "Jamo", 284, "Jamo (alias for Jamo subset of Hangul)",                                                          false },
  { "Java", 361, "Javanese",                                                                                        false },
  { "Jpan", 413, "Japanese (alias for Han + Hiragana + Katakana)",                                                  false },
  { "Jurc", 510, "Jurchen",                                                                                         false },
  { "Kali", 357, "Kayah Li",                                                                                        false },
  { "Kana", 411, "Katakana",                                                                                        false },
  { "Kawi", 368, "Kawi",                                                                                            false },
  { "Khar", 305, "Kharoshthi",                                                                                      false },
  { "Khmr", 355, "Khmer",                                                                                           false },
  { "Khoj", 322, "Khojki",                                                                                          false },
  { "Kitl", 505, "Khitan large script",                                                                             false },
  { "Kits", 288, "Khitan small script",                                                                             false },
  { "Knda", 345, "Kannada",                                                                                         false },
  { "Kore", 287, "Korean (alias for Hangul + Han)",                                                                 false },
  { "Kpel", 436, "Kpelle",                                                                                          false },
  { "Krai", 396, "Kirat Rai",                                                                                       false },
  { "Kthi", 317, "Kaithi",                                                                                          false },
  { "Lana", 351, "Tai Tham (Lanna)",                                                                                false },
  { "Laoo", 356, "Lao",                                                                                             false },
  { "Latf", 217, "Latin (Fraktur variant)",                                                                         false },
  { "Latg", 216, "Latin (Gaelic variant)",                                                                          false },
  { "Latn", 215, "Latin",                                                                                           false },
  { "Leke", 364, "Leke",                                                                                            false },
  { "Lepc", 335, "Lepcha (Róng)",                                                                                   false },
  { "Limb", 336, "Limbu",                                                                                           false },
  { "Lina", 400, "Linear A",                                                                                        false },
  { "Linb", 401, "Linear B",                                                                                        false },
  { "Lisu", 399, "Lisu (Fraser)",                                                                                   false },
  { "Loma", 437, "Loma",                                                                                            false },
  { "Lyci", 202, "Lycian",                                                                                          false },
  { "Lydi", 116, "Lydian",                                                                                          false },
  { "Mahj", 314, "Mahajani",                                                                                        false },
  { "Maka", 366, "Makasar",                                                                                         false },
  { "Mand", 140, "Mandaic, Mandaean",                                                                               false },
  { "Mani", 139, "Manichaean",                                                                                      false },
  { "Marc", 332, "Marchen",                                                                                         false },
  { "Maya",  90, "Mayan hieroglyphs",                                                                               false },
  { "Medf", 265, "Medefaidrin (Oberi Okaime, Oberi Ɔkaimɛ)",                                                        false },
  { "Mend", 438, "Mende Kikakui",                                                                                   false },
  { "Merc", 101, "Meroitic Cursive",                                                                                false },
  { "Mero", 100, "Meroitic Hieroglyphs",                                                                            false },
  { "Mlym", 347, "Malayalam",                                                                                       false },
  { "Modi", 324, "Modi, Moḍī",                                                                                      false },
  { "Mong", 145, "Mongolian",                                                                                       false },
  { "Moon", 218, "Moon (Moon code, Moon script, Moon type)",                                                        false },
  { "Mroo", 264, "Mro, Mru",                                                                                        false },
  { "Mtei", 337, "Meitei Mayek (Meithei, Meetei)",                                                                  false },
  { "Mult", 323, "Multani",                                                                                         false },
  { "Mymr", 350, "Myanmar (Burmese)",                                                                               false },
  { "Nagm", 295, "Nag Mundari",                                                                                     false },
  { "Nand", 311, "Nandinagari",                                                                                     false },
  { "Narb", 106, "Old North Arabian (Ancient North Arabian)",                                                       false },
  { "Nbat", 159, "Nabataean",                                                                                       false },
  { "Newa", 333, "Newa, Newar, Newari, Nepāla lipi",                                                                false },
  { "Nkdb",  85, "Naxi Dongba (na²¹ɕi³³ to³³ba²¹, Nakhi Tomba)",                                                    false },
  { "Nkgb", 420, "Naxi Geba (na²¹ɕi³³ gʌ²¹ba²¹, 'Na-'Khi ²Ggŏ-¹baw, Nakhi Geba)",                                   false },
  { "Nkoo", 165, "N’Ko",                                                                                            false },
  { "Nshu", 499, "Nüshu",                                                                                           false },
  { "Ogam", 212, "Ogham",                                                                                           false },
  { "Olck", 261, "Ol Chiki (Ol Cemet’, Ol, Santali)",                                                               false },
  { "Onao", 296, "Ol Onal",                                                                                         false },
  { "Orkh", 175, "Old Turkic, Orkhon Runic",                                                                        false },
  { "Orya", 327, "Oriya (Odia)",                                                                                    false },
  { "Osge", 219, "Osage",                                                                                           false },
  { "Osma", 260, "Osmanya",                                                                                         false },
  { "Ougr", 143, "Old Uyghur",                                                                                      false },
  { "Palm", 126, "Palmyrene",                                                                                       false },
  { "Pauc", 263, "Pau Cin Hau",                                                                                     false },
  { "Pcun",  15, "Proto-Cuneiform",                                                                                 false },
  { "Pelm",  16, "Proto-Elamite",                                                                                   false },
  { "Perm", 227, "Old Permic",                                                                                      false },
  { "Phag", 331, "Phags-pa",                                                                                        false },
  { "Phli", 131, "Inscriptional Pahlavi",                                                                           false },
  { "Phlp", 132, "Psalter Pahlavi",                                                                                 false },
  { "Phlv", 133, "Book Pahlavi",                                                                                    false },
  { "Phnx", 115, "Phoenician",                                                                                      false },
  { "Piqd", 293, "Klingon (KLI pIqaD)",                                                                             false },
  { "Plrd", 282, "Miao (Pollard)",                                                                                  false },
  { "Prti", 130, "Inscriptional Parthian",                                                                          false },
  { "Psin", 103, "Proto-Sinaitic",                                                                                  false },
  { "Qaaa", 900, "Reserved for private use",                                                                        false },
  { "Qaab", 901, "Reserved for private use",                                                                        false },
  { "Qaac", 902, "Reserved for private use",                                                                        false },
  { "Qaad", 903, "Reserved for private use",                                                                        false },
  { "Qaae", 904, "Reserved for private use",                                                                        false },
  { "Qaaf", 905, "Reserved for private use",                                                                        false },
  { "Qaag", 906, "Reserved for private use",                                                                        false },
  { "Qaah", 907, "Reserved for private use",                                                                        false },
  { "Qaai", 908, "Reserved for private use",                                                                        false },
  { "Qaaj", 909, "Reserved for private use",                                                                        false },
  { "Qaak", 910, "Reserved for private use",                                                                        false },
  { "Qaal", 911, "Reserved for private use",                                                                        false },
  { "Qaam", 912, "Reserved for private use",                                                                        false },
  { "Qaan", 913, "Reserved for private use",                                                                        false },
  { "Qaao", 914, "Reserved for private use",                                                                        false },
  { "Qaap", 915, "Reserved for private use",                                                                        false },
  { "Qaaq", 916, "Reserved for private use",                                                                        false },
  { "Qaar", 917, "Reserved for private use",                                                                        false },
  { "Qaas", 918, "Reserved for private use",                                                                        false },
  { "Qaat", 919, "Reserved for private use",                                                                        false },
  { "Qaau", 920, "Reserved for private use",                                                                        false },
  { "Qaav", 921, "Reserved for private use",                                                                        false },
  { "Qaaw", 922, "Reserved for private use",                                                                        false },
  { "Qaax", 923, "Reserved for private use",                                                                        false },
  { "Qaay", 924, "Reserved for private use",                                                                        false },
  { "Qaaz", 925, "Reserved for private use",                                                                        false },
  { "Qaba", 926, "Reserved for private use",                                                                        false },
  { "Qabb", 927, "Reserved for private use",                                                                        false },
  { "Qabc", 928, "Reserved for private use",                                                                        false },
  { "Qabd", 929, "Reserved for private use",                                                                        false },
  { "Qabe", 930, "Reserved for private use",                                                                        false },
  { "Qabf", 931, "Reserved for private use",                                                                        false },
  { "Qabg", 932, "Reserved for private use",                                                                        false },
  { "Qabh", 933, "Reserved for private use",                                                                        false },
  { "Qabi", 934, "Reserved for private use",                                                                        false },
  { "Qabj", 935, "Reserved for private use",                                                                        false },
  { "Qabk", 936, "Reserved for private use",                                                                        false },
  { "Qabl", 937, "Reserved for private use",                                                                        false },
  { "Qabm", 938, "Reserved for private use",                                                                        false },
  { "Qabn", 939, "Reserved for private use",                                                                        false },
  { "Qabo", 940, "Reserved for private use",                                                                        false },
  { "Qabp", 941, "Reserved for private use",                                                                        false },
  { "Qabq", 942, "Reserved for private use",                                                                        false },
  { "Qabr", 943, "Reserved for private use",                                                                        false },
  { "Qabs", 944, "Reserved for private use",                                                                        false },
  { "Qabt", 945, "Reserved for private use",                                                                        false },
  { "Qabu", 946, "Reserved for private use",                                                                        false },
  { "Qabv", 947, "Reserved for private use",                                                                        false },
  { "Qabw", 948, "Reserved for private use",                                                                        false },
  { "Qabx", 949, "Reserved for private use",                                                                        false },
  { "Ranj", 303, "Ranjana",                                                                                         false },
  { "Rjng", 363, "Rejang (Redjang, Kaganga)",                                                                       false },
  { "Rohg", 167, "Hanifi Rohingya",                                                                                 false },
  { "Roro", 620, "Rongorongo",                                                                                      false },
  { "Runr", 211, "Runic",                                                                                           false },
  { "Samr", 123, "Samaritan",                                                                                       false },
  { "Sara", 292, "Sarati",                                                                                          false },
  { "Sarb", 105, "Old South Arabian",                                                                               false },
  { "Saur", 344, "Saurashtra",                                                                                      false },
  { "Seal", 590, "(Small) Seal",                                                                                    false },
  { "Sgnw",  95, "SignWriting",                                                                                     false },
  { "Shaw", 281, "Shavian (Shaw)",                                                                                  false },
  { "Shrd", 319, "Sharada, Śāradā",                                                                                 false },
  { "Shui", 530, "Shuishu",                                                                                         false },
  { "Sidd", 302, "Siddham, Siddhaṃ, Siddhamātṛkā",                                                                  false },
  { "Sidt", 180, "Sidetic",                                                                                         false },
  { "Sind", 318, "Khudawadi, Sindhi",                                                                               false },
  { "Sinh", 348, "Sinhala",                                                                                         false },
  { "Sogd", 141, "Sogdian",                                                                                         false },
  { "Sogo", 142, "Old Sogdian",                                                                                     false },
  { "Sora", 398, "Sora Sompeng",                                                                                    false },
  { "Soyo", 329, "Soyombo",                                                                                         false },
  { "Sund", 362, "Sundanese",                                                                                       false },
  { "Sunu", 274, "Sunuwar",                                                                                         false },
  { "Sylo", 316, "Syloti Nagri",                                                                                    false },
  { "Syrc", 135, "Syriac",                                                                                          false },
  { "Syre", 138, "Syriac (Estrangelo variant)",                                                                     false },
  { "Syrj", 137, "Syriac (Western variant)",                                                                        false },
  { "Syrn", 136, "Syriac (Eastern variant)",                                                                        false },
  { "Tagb", 373, "Tagbanwa",                                                                                        false },
  { "Takr", 321, "Takri, Ṭākrī, Ṭāṅkrī",                                                                            false },
  { "Tale", 353, "Tai Le",                                                                                          false },
  { "Talu", 354, "New Tai Lue",                                                                                     false },
  { "Taml", 346, "Tamil",                                                                                           false },
  { "Tang", 520, "Tangut",                                                                                          false },
  { "Tavt", 359, "Tai Viet",                                                                                        false },
  { "Tayo", 380, "Tai Yo",                                                                                          false },
  { "Telu", 340, "Telugu",                                                                                          false },
  { "Teng", 290, "Tengwar",                                                                                         false },
  { "Tfng", 120, "Tifinagh (Berber)",                                                                               false },
  { "Tglg", 370, "Tagalog (Baybayin, Alibata)",                                                                     false },
  { "Thaa", 170, "Thaana",                                                                                          false },
  { "Thai", 352, "Thai",                                                                                            false },
  { "Tibt", 330, "Tibetan",                                                                                         false },
  { "Tirh", 326, "Tirhuta",                                                                                         false },
  { "Tnsa", 275, "Tangsa",                                                                                          false },
  { "Todr", 229, "Todhri",                                                                                          false },
  { "Tols", 299, "Tolong Siki",                                                                                     false },
  { "Toto", 294, "Toto",                                                                                            false },
  { "Tutg", 341, "Tulu-Tigalari",                                                                                   false },
  { "Ugar",  40, "Ugaritic",                                                                                        false },
  { "Vaii", 470, "Vai",                                                                                             false },
  { "Visp", 280, "Visible Speech",                                                                                  false },
  { "Vith", 228, "Vithkuqi",                                                                                        false },
  { "Wara", 262, "Warang Citi (Varang Kshiti)",                                                                     false },
  { "Wcho", 283, "Wancho",                                                                                          false },
  { "Wole", 480, "Woleai",                                                                                          false },
  { "Xpeo",  30, "Old Persian",                                                                                     false },
  { "Xsux",  20, "Cuneiform, Sumero-Akkadian",                                                                      false },
  { "Yezi", 192, "Yezidi",                                                                                          false },
  { "Yiii", 460, "Yi",                                                                                              false },
  { "Zanb", 339, "Zanabazar Square (Zanabazarin Dörböljin Useg, Xewtee Dörböljin Bicig, Horizontal Square Script)", false },
  { "Zinh", 994, "Code for inherited script",                                                                       false },
  { "Zmth", 995, "Mathematical notation",                                                                           false },
  { "Zsye", 993, "Symbols (Emoji variant)",                                                                         false },
  { "Zsym", 996, "Symbols",                                                                                         false },
  { "Zxxx", 997, "Code for unwritten documents",                                                                    false },
  { "Zyyy", 998, "Code for undetermined script",                                                                    false },
  { "Zzzz", 999, "Code for uncoded script",                                                                         false },
};

void
init() {
  g_scripts.reserve(274);

  for (script_init_t const *script = s_scripts_init, *end = script + 274; script < end; ++script)
    g_scripts.emplace_back(script->code, script->number, script->english_name, script->is_deprecated);
}

} // namespace mtx::iso15924
