# (C) Copyright 1996-2016 ECMWF.
# 
# This software is licensed under the terms of the Apache Licence Version 2.0
# which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
# In applying this licence, ECMWF does not waive the privileges and immunities 
# granted to it by virtue of its status as an intergovernmental organisation nor
# does it submit to any jurisdiction.


#importing Magics module
from Magics.macro import *


ref = 'axis2'
#Setting of the output file name
output = output(output_formats = ['png'], 
		output_name_first_page_number = "off",
		output_name = ref)

#Setting the cartesian view
projection = mmap(subpage_y_position= 2., 
			subpage_map_projection = 'cartesian',
			subpage_x_axis_type = 'date',
			subpage_y_axis_type = 'regular',
			subpage_x_date_min = "2012-04-10",
			subpage_x_date_max = "2012-05-10",
			subpage_y_min = -20.,
			subpage_y_max = 20.)

#Vertical axis
vertical = maxis(axis_orientation = "vertical",
				 axis_grid =  "on",
				 axis_type =  "regular",
				 axis_grid_colour = "grey",
				 axis_grid_thickness = 1,
				 axis_grid_reference_level = 0.,
				 axis_grid_reference_line_style='solid',
				 axis_grid_reference_thickness=2,
				 axis_grid_line_style = "dot")

#Horizontal axis
horizontal = maxis(axis_orientation = "horizontal",
				 axis_type =  "date",
				 axis_grid =  "on",
				 axis_days_label_height =  0.4,
				 axis_months_label_height =  0.4,
				 axis_years_label_height =  0.4,
				 axis_grid_colour = "grey",
				 axis_grid_thickness = 1,
				 axis_grid_line_style = "dot")




lines =["Using time series..."]

title = mtext({
           "text_lines" : lines,
           "text_html" : "true",
		   "text_justification": "left",
		   "text_font_size": 1.,
           "text_colour" : "charcoal"})


#To the plot
plot(output, projection, vertical, horizontal, title)

#For documentation only
tofortran(ref, output, projection, vertical, horizontal, title)
tomv4(ref, vertical)
tohtml(ref, projection, vertical, horizontal)














