; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=thumbv7-apple-ios7.0.0 < %s | FileCheck %s

define { half, half } @test_sincospi_f16(half %a) #0 {
; CHECK-LABEL: test_sincospi_f16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl ___extendhfsf2
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    mov r1, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r4, pc}
  %result = call { half, half } @llvm.sincospi.f16(half %a)
  ret { half, half } %result
}

define half @test_sincospi_f16_only_use_sin(half %a) #0 {
; CHECK-LABEL: test_sincospi_f16_only_use_sin:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    str lr, [sp, #-4]!
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl ___extendhfsf2
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    ldr lr, [sp], #4
; CHECK-NEXT:    bx lr
  %result = call { half, half } @llvm.sincospi.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincospi_f16_only_use_cos(half %a) #0 {
; CHECK-LABEL: test_sincospi_f16_only_use_cos:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    str lr, [sp, #-4]!
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl ___extendhfsf2
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    ldr lr, [sp], #4
; CHECK-NEXT:    bx lr
  %result = call { half, half } @llvm.sincospi.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincospi_v2f16(<2 x half> %a) #0 {
; CHECK-LABEL: test_sincospi_v2f16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #24
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bl ___extendhfsf2
; CHECK-NEXT:    add r1, sp, #12
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl ___extendhfsf2
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    ldr r1, [sp, #4]
; CHECK-NEXT:    strh.w r0, [sp, #22]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    strh.w r0, [sp, #20]
; CHECK-NEXT:    add r0, sp, #20
; CHECK-NEXT:    vld1.32 {d8[0]}, [r0:32]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    ldr r1, [sp]
; CHECK-NEXT:    strh.w r0, [sp, #18]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bl ___truncsfhf2
; CHECK-NEXT:    strh.w r0, [sp, #16]
; CHECK-NEXT:    add r0, sp, #16
; CHECK-NEXT:    vmovl.u16 q9, d8
; CHECK-NEXT:    vld1.32 {d16[0]}, [r0:32]
; CHECK-NEXT:    vmovl.u16 q8, d16
; CHECK-NEXT:    vmov.32 r0, d18[0]
; CHECK-NEXT:    vmov.32 r1, d18[1]
; CHECK-NEXT:    vmov.32 r2, d16[0]
; CHECK-NEXT:    vmov.32 r3, d16[1]
; CHECK-NEXT:    add sp, #24
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    pop {r4, pc}
  %result = call { <2 x half>, <2 x half> } @llvm.sincospi.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincospi_f32(float %a) #0 {
; CHECK-LABEL: test_sincospi_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    str lr, [sp, #-4]!
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldrd r1, r0, [sp], #8
; CHECK-NEXT:    ldr lr, [sp], #4
; CHECK-NEXT:    bx lr
  %result = call { float, float } @llvm.sincospi.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincospi_v2f32(<2 x float> %a) #0 {
; CHECK-LABEL: test_sincospi_v2f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    str lr, [sp, #-4]!
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vmov d8, r0, r1
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    vmov r0, s17
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    add r1, sp, #12
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    vldr s1, [sp, #4]
; CHECK-NEXT:    vldr s3, [sp]
; CHECK-NEXT:    vldr s0, [sp, #12]
; CHECK-NEXT:    vldr s2, [sp, #8]
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    ldr lr, [sp], #4
; CHECK-NEXT:    bx lr
  %result = call { <2 x float>, <2 x float> } @llvm.sincospi.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { <3 x float>, <3 x float> } @test_sincospi_v3f32(<3 x float> %a) #0 {
; CHECK-LABEL: test_sincospi_v3f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    mov r6, r2
; CHECK-NEXT:    mov r7, r1
; CHECK-NEXT:    add r1, sp, #12
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    mov r5, r3
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    mov r0, r7
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    ldr r0, [sp, #36]
; CHECK-NEXT:    vmov d0, r7, r6
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    add.w r2, r4, #16
; CHECK-NEXT:    vmov d1, r5, r0
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vldr s1, [sp, #8]
; CHECK-NEXT:    vldr s3, [sp, #12]
; CHECK-NEXT:    vldr s2, [sp, #4]
; CHECK-NEXT:    vldr s0, [sp]
; CHECK-NEXT:    vst1.32 {d1}, [r1:64]!
; CHECK-NEXT:    vst1.32 {d0}, [r2:64]!
; CHECK-NEXT:    bl ___sincospif
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
  %result = call { <3 x float>, <3 x float> } @llvm.sincospi.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { double, double } @test_sincospi_f64(double %a) #0 {
; CHECK-LABEL: test_sincospi_f64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r7, lr}
; CHECK-NEXT:    add r7, sp, #4
; CHECK-NEXT:    sub sp, #20
; CHECK-NEXT:    mov r4, sp
; CHECK-NEXT:    bfc r4, #0, #3
; CHECK-NEXT:    mov sp, r4
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    mov r3, sp
; CHECK-NEXT:    bl ___sincospi
; CHECK-NEXT:    subs r4, r7, #4
; CHECK-NEXT:    ldrd r0, r1, [sp, #8]
; CHECK-NEXT:    ldrd r2, r3, [sp]
; CHECK-NEXT:    mov sp, r4
; CHECK-NEXT:    pop {r4, r7, pc}
  %result = call { double, double } @llvm.sincospi.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincospi_v2f64(<2 x double> %a) #0 {
; CHECK-LABEL: test_sincospi_v2f64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    add r7, sp, #16
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    mov r4, sp
; CHECK-NEXT:    bfc r4, #0, #3
; CHECK-NEXT:    mov sp, r4
; CHECK-NEXT:    mov r6, r1
; CHECK-NEXT:    ldr r1, [r7, #8]
; CHECK-NEXT:    mov r5, r3
; CHECK-NEXT:    mov r8, r2
; CHECK-NEXT:    add r2, sp, #24
; CHECK-NEXT:    add r3, sp, #16
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl ___sincospi
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    mov r3, sp
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    mov r1, r8
; CHECK-NEXT:    bl ___sincospi
; CHECK-NEXT:    vldr d19, [sp, #24]
; CHECK-NEXT:    vldr d18, [sp, #8]
; CHECK-NEXT:    vldr d17, [sp, #16]
; CHECK-NEXT:    vldr d16, [sp]
; CHECK-NEXT:    vst1.32 {d18, d19}, [r4]!
; CHECK-NEXT:    vst1.32 {d16, d17}, [r4]
; CHECK-NEXT:    sub.w r4, r7, #16
; CHECK-NEXT:    mov sp, r4
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
  %result = call { <2 x double>, <2 x double> } @llvm.sincospi.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

attributes #0 = { nounwind }
