# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr3-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr3-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV32

lw a0, 0(s0)
lw a1, 0(s0)
lw a2, 0(s0)
lw a3, 0(s0)

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      4
# CHECK-NEXT: Total Cycles:      6
# CHECK-NEXT: Total uOps:        4

# CHECK:      Dispatch Width:    1
# CHECK-NEXT: uOps Per Cycle:    0.67
# CHECK-NEXT: IPC:               0.67
# CHECK-NEXT: Block RThroughput: 4.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      2     1.00    *                   lw	a0, 0(s0)
# CHECK-NEXT:  1      2     1.00    *                   lw	a1, 0(s0)
# CHECK-NEXT:  1      2     1.00    *                   lw	a2, 0(s0)
# CHECK-NEXT:  1      2     1.00    *                   lw	a3, 0(s0)

# CHECK:      Resources:

# RV32-NEXT:  [0]   - SCR3RV32_ALU
# RV32-NEXT:  [1]   - SCR3RV32_CFU
# RV32-NEXT:  [2]   - SCR3RV32_DIV
# RV32-NEXT:  [3]   - SCR3RV32_LSU
# RV32-NEXT:  [4]   - SCR3RV32_MUL

# RV64-NEXT:  [0]   - SCR3RV64_ALU
# RV64-NEXT:  [1]   - SCR3RV64_CFU
# RV64-NEXT:  [2]   - SCR3RV64_DIV
# RV64-NEXT:  [3]   - SCR3RV64_LSU
# RV64-NEXT:  [4]   - SCR3RV64_MUL

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]
# CHECK-NEXT:  -      -      -     4.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -     lw	a0, 0(s0)
# CHECK-NEXT:  -      -      -     1.00    -     lw	a1, 0(s0)
# CHECK-NEXT:  -      -      -     1.00    -     lw	a2, 0(s0)
# CHECK-NEXT:  -      -      -     1.00    -     lw	a3, 0(s0)
