# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M5

crc32w	w0, w1, w2
crc32w	w0, w0, w3

crc32cx	w0, w1, x2
crc32cx	w0, w0, x3

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      400

# M3-NEXT:  Total Cycles:      204
# M4-NEXT:  Total Cycles:      404
# M5-NEXT:  Total Cycles:      204

# ALL-NEXT: Total uOps:        400

# ALL:      Dispatch Width:    6

# M3-NEXT:  uOps Per Cycle:    1.96
# M3-NEXT:  IPC:               1.96
# M3-NEXT:  Block RThroughput: 2.0

# M4-NEXT:  uOps Per Cycle:    0.99
# M4-NEXT:  IPC:               0.99
# M4-NEXT:  Block RThroughput: 4.0

# M5-NEXT:  uOps Per Cycle:    1.96
# M5-NEXT:  IPC:               1.96
# M5-NEXT:  Block RThroughput: 2.0

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:

# M3-NEXT:   1      2     0.50                        crc32w	w0, w1, w2
# M3-NEXT:   1      2     0.50                        crc32w	w0, w0, w3
# M3-NEXT:   1      2     0.50                        crc32cx	w0, w1, x2
# M3-NEXT:   1      2     0.50                        crc32cx	w0, w0, x3

# M4-NEXT:   1      2     1.00                        crc32w	w0, w1, w2
# M4-NEXT:   1      2     1.00                        crc32w	w0, w0, w3
# M4-NEXT:   1      2     1.00                        crc32cx	w0, w1, x2
# M4-NEXT:   1      2     1.00                        crc32cx	w0, w0, x3

# M5-NEXT:   1      2     0.50                        crc32w	w0, w1, w2
# M5-NEXT:   1      2     0.50                        crc32w	w0, w0, w3
# M5-NEXT:   1      2     0.50                        crc32cx	w0, w1, x2
# M5-NEXT:   1      2     0.50                        crc32cx	w0, w0, x3
