/*
 * Copyright (C) 2023-2026 Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>

G_BEGIN_DECLS

#define LIVI_TYPE_URL_INFO livi_url_info_get_type ()
GType livi_url_info_get_type (void) G_GNUC_CONST;

typedef struct {
  char *url;
  char *artist;
  char *title;
  char *thumbnail_url;
} LiviUrlInfo;

LiviUrlInfo *livi_url_info_new (const char *url, const char *title, const char *author);
void         livi_url_info_free (LiviUrlInfo *info);
LiviUrlInfo *livi_url_info_copy (LiviUrlInfo *info);

G_DEFINE_AUTOPTR_CLEANUP_FUNC (LiviUrlInfo, livi_url_info_free)

#define LIVI_TYPE_APPLICATION (livi_application_get_type ())

G_DECLARE_FINAL_TYPE (LiviApplication, livi_application, LIVI, APPLICATION, AdwApplication)

LiviApplication *livi_application_new (void);
gboolean         livi_application_get_resume (LiviApplication *self);

G_END_DECLS
