// tan.testdata
// copyright (C) 2005 F. de Dinechin, Ch. Q. Lauter  and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Some special cases. Much to do here
T(RN,                  0x0p+0,                  0x0p+0,                  0x1p+0,          0x0p+0, 0)
T(RN,                  0x1p+1,            -0x1.0ccp+10,                  0x0p+0,         -0x1p-1, INEXACT|UNDERFLOW) // 2^-1075
T(RN,                  0x1p+1,            -0x1.0c8p+10,               0x1p-1074,          0x0p+0, 0) // 2^-1074
// Some exact mid-point cases. Subnormal cases are missing.
T(RN,           0x1.cfdd8p+17,                0x1.8p+1,   0x1.7cbf0571d6e62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.927a0f5b2p+35,                0x1.8p+0,   0x1.64d79ee5e5b8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8568p+17,                0x1.8p+1,   0x1.bc3e67c3bf8bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f88aea02p+35,                0x1.8p+0,    0x1.7658ea332c7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0e88p+17,                0x1.8p+1,   0x1.a84632a08b838p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a05b8p+17,                0x1.8p+1,   0x1.13555e5e9a1b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af6e8p+17,                0x1.8p+1,   0x1.3255a87dd8ec2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8548p+17,                0x1.8p+1,   0x1.bc38f27aa0b5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f25b8p+17,                0x1.8p+1,   0x1.d8273344677b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c6a1e722p+35,                0x1.8p+0,   0x1.47e82fbcd2e5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb1a8p+17,                0x1.8p+1,   0x1.7124050547bc6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e39f8p+17,                0x1.8p+1,    0x1.af800feb0d2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c418p+17,                0x1.8p+1,   0x1.0b46c12d89acep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e86646782p+35,                0x1.8p+0,    0x1.dd02a9e9f163p+53,          0x1p-1, INEXACT)
T(RN,       0x1.94d965c42p+35,                0x1.8p+0,   0x1.680085b873758p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1c98p+17,                0x1.8p+1,   0x1.162df661474a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a01d8p+17,                0x1.8p+1,   0x1.12da70a4b7122p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c5d01f1c2p+35,                0x1.8p+0,   0x1.ab3f9315eec98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9c64d1412p+35,                0x1.8p+0,   0x1.721cb017cf68ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.bfcf1f322p+35,                0x1.8p+0,   0x1.a2cc39d67e6dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a9ca6442p+35,                0x1.8p+0,   0x1.45943b9116a58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e34d8p+17,                0x1.8p+1,   0x1.aea4b867faa32p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4bee39e02p+35,                0x1.8p+0,    0x1.0b42dd5e074cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.67e5a6662p+35,                0x1.8p+0,   0x1.2dbd5e7341c6cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d851d5632p+35,                0x1.8p+0,   0x1.c5a5e738df17ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.feeb25772p+35,                0x1.8p+0,   0x1.fe60f05b3d86ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba5e2afd2p+35,                0x1.8p+0,   0x1.9b301b53f0206p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ca677642p+35,                0x1.8p+0,   0x1.483639b01b2e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f3d1c5102p+35,                0x1.8p+0,    0x1.edd695b02d5ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f30a43cf2p+35,                0x1.8p+0,   0x1.ecaf0616845e6p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.9d4p+10,                0x1.4p+2,   0x1.5ec37856a61b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a15f766f2p+35,                0x1.8p+0,   0x1.78d5cb939975ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba388p+17,                0x1.8p+1,   0x1.49e56c3be7028p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b92b32d2p+35,                0x1.8p+0,   0x1.5bb346737c366p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fddc8p+17,                0x1.8p+1,   0x1.f99c59f051ef4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d18419622p+35,                0x1.8p+0,   0x1.bbe1a3fd20cfcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cef12c3f2p+35,                0x1.8p+0,   0x1.b8347d6c0d506p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3508p+17,                0x1.8p+1,    0x1.854d8f7768ffp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aece8p+17,                0x1.8p+1,   0x1.310154dc54de2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5054579c2p+35,                0x1.8p+0,   0x1.10976fc6c3668p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6108p+17,                0x1.8p+1,    0x1.e2c49d65ea83p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db96e2772p+35,                0x1.8p+0,   0x1.ca5dedf02d26ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee2f8p+17,                0x1.8p+1,    0x1.cc6502d84d49p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7684aa5f2p+35,                0x1.8p+0,   0x1.40501b618ef3ap+53,          0x1p-1, INEXACT)
T(RN,               0x1.f7p+8,                0x1.8p+2,   0x1.cc5172b7a17f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afa28p+17,                0x1.8p+1,   0x1.32c47a154ac1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a95a68722p+35,                0x1.8p+0,   0x1.83b1c3185b5a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5978p+17,                0x1.8p+1,   0x1.3fa50f3b0bb48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd978p+17,                0x1.8p+1,   0x1.517f931efd348p+53,          0x1p-1, INEXACT)
T(RN,       0x1.523191d12p+35,                0x1.8p+0,   0x1.12dc6bedd9b52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f88aea02p+35,                0x1.8p+0,    0x1.7658ea332c7cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.970deecf2p+35,                0x1.8p+0,   0x1.6af28b927d01ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5bae8fe72p+35,                0x1.8p+0,   0x1.1e824706f46b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c954037a2p+35,                0x1.8p+0,   0x1.b038db064270cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4cac3d22p+35,                0x1.8p+0,   0x1.c0934849c1764p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45787a042p+35,                0x1.8p+0,   0x1.037f490a83728p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f07d88682p+35,                0x1.8p+0,    0x1.e8e9a1ebe729p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b86a8p+17,                0x1.8p+1,   0x1.45dfae997a236p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b1f67122p+35,                0x1.8p+0,   0x1.463cf26f3881cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4648p+17,                0x1.8p+1,   0x1.1b6aa2a5ea08cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e55ffe432p+35,                0x1.8p+0,   0x1.d8961506d8bbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5cd2843a2p+35,                0x1.8p+0,   0x1.1feb73eb91074p+53,          0x1p-1, INEXACT)
T(RN,       0x1.da7f8bfa2p+35,                0x1.8p+0,   0x1.c8ca53ee9320cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdfe8p+17,                0x1.8p+1,   0x1.5269d3de709f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7cfe9632p+35,                0x1.8p+0,   0x1.dc2671b18497ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a7cb8d682p+35,                0x1.8p+0,    0x1.8190f29166b7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c98f8p+17,                0x1.8p+1,    0x1.6d6e6c3b2f6bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf408p+17,                0x1.8p+1,    0x1.7b3cee008cdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9068p+17,                0x1.8p+1,   0x1.6c268f937174ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e5dcc9f2p+35,                0x1.8p+0,   0x1.74c54fa4f5c46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7d18p+17,                0x1.8p+1,   0x1.bad3d19af54fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f09d0be02p+35,                0x1.8p+0,    0x1.e9182f2ad88cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6208p+17,                0x1.8p+1,    0x1.b63cb53d8ca6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f96e6da22p+35,                0x1.8p+0,   0x1.f62dbff50227cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffff8p+17,                0x1.8p+1,       0x1.fffe80006p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c7d8p+17,                0x1.8p+1,   0x1.0bbb850c95942p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51412af72p+35,                0x1.8p+0,   0x1.11b78d342dc96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9c38p+17,                0x1.8p+1,   0x1.48dfd901649ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7038p+17,                0x1.8p+1,   0x1.b8a3bdba1a5acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b0ced6e2p+35,                0x1.8p+0,   0x1.0a32f060240bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.483dfb4e2p+35,                0x1.8p+0,   0x1.06d19eba2cf7cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.569d51322p+35,                0x1.8p+0,   0x1.1844a214df2dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f2c8p+17,                0x1.8p+1,   0x1.10fdf65156de4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6868p+17,                0x1.8p+1,   0x1.663516963a3cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.841dd9752p+35,                0x1.8p+0,   0x1.51ea6a12daf8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c4fd54542p+35,                0x1.8p+0,   0x1.aa1607aebbf48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6088p+17,                0x1.8p+1,   0x1.b5fbd03c5fb98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dae59cc52p+35,                0x1.8p+0,   0x1.c95dbe635e216p+53,          0x1p-1, INEXACT)
T(RN,       0x1.937990432p+35,                0x1.8p+0,   0x1.662ba1a78a7bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9eaec7bc2p+35,                0x1.8p+0,   0x1.75329c0d584d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef5450ec2p+35,                0x1.8p+0,   0x1.e732de5d13c48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd988p+17,                0x1.8p+1,   0x1.772f559077e48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe3367c52p+35,                0x1.8p+0,   0x1.fd4db720a8816p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdfb8p+17,                0x1.8p+1,   0x1.f9f89910c1894p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2a68p+17,                0x1.8p+1,   0x1.d8fc7eab6ff2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.776329ec2p+35,                0x1.8p+0,   0x1.416db728b8db8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.855cc3c32p+35,                0x1.8p+0,   0x1.538b3f03f4f42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cf88p+17,                0x1.8p+1,   0x1.0cab4da96f068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70a94df72p+35,                0x1.8p+0,   0x1.38d41df11e96ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f06e8p+17,                0x1.8p+1,   0x1.d2b360342a9c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.82414da22p+35,                0x1.8p+0,   0x1.4f7cccd83627cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9be08p+17,                0x1.8p+1,    0x1.0a8a43d38ebap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dec98p+17,                0x1.8p+1,   0x1.a2af5da6b83a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8428p+17,                0x1.8p+1,   0x1.91cb239c43afep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed37ebcf2p+35,                0x1.8p+0,   0x1.e4166e88d0a1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3798p+17,                0x1.8p+1,   0x1.af1a613c20a36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f284084d2p+35,                0x1.8p+0,   0x1.ebe84abdf445ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa9b8p+17,                0x1.8p+1,   0x1.282c424eedc74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72073b662p+35,                0x1.8p+0,   0x1.3a91ed6b58e6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cde48p+17,                0x1.8p+1,   0x1.77e8c5950450cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.620bb0632p+35,                0x1.8p+0,   0x1.266932db09b7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aab38p+17,                0x1.8p+1,   0x1.285e4190f1dbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bffc8p+17,                0x1.8p+1,   0x1.56f7f61013f54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8c18p+17,                0x1.8p+1,   0x1.6b81b94824c4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c42c8p+17,                0x1.8p+1,   0x1.60ad25949ece4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97a036b42p+35,                0x1.8p+0,   0x1.6bb6426772d08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d41ac3b82p+35,                0x1.8p+0,    0x1.bf96c26db56bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dded2a722p+35,                0x1.8p+0,   0x1.cdbfea25149a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cad08p+17,                0x1.8p+1,    0x1.7071a2330167p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c458p+17,                0x1.8p+1,   0x1.0b4e88e98b15ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.459d28092p+35,                0x1.8p+0,   0x1.03ab283fa8e62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcfa8p+17,                0x1.8p+1,   0x1.9df54f2d25c66p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6530c1ff2p+35,                0x1.8p+0,   0x1.2a579f4cfa67ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc188p+17,                0x1.8p+1,   0x1.738a073efc9c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc2c8p+17,                0x1.8p+1,   0x1.4e495ee6354e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3988p+17,                0x1.8p+1,   0x1.3b4a5c04ff048p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9d88p+17,                0x1.8p+1,   0x1.490ec1d9aab08p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3898p+13,                  0x1p+2,   0x1.1c8eed4b5d888p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.80f5ca372p+35,                0x1.8p+0,   0x1.4dcd4051681eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e02f8p+17,                0x1.8p+1,    0x1.a65d4ae542a9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7f58p+17,                0x1.8p+1,   0x1.bb35e2e59e5eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.46915cac2p+35,                0x1.8p+0,   0x1.04cf7e12d0538p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9d58p+17,                0x1.8p+1,   0x1.95d32d007ee8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e7a5c552p+35,                0x1.8p+0,   0x1.4a941b5a3dfcap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2bc8p+17,                0x1.8p+1,   0x1.83dc2324e6394p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab5b8p+17,                0x1.8p+1,   0x1.29bcd9f4092b4p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3908p+13,                  0x1p+2,    0x1.1e279ab619a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0fe8p+17,                0x1.8p+1,   0x1.7f88660df0af2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb4e8p+17,                0x1.8p+1,   0x1.c4652b4df8f62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd7c8p+17,                0x1.8p+1,   0x1.f87ef659e0fd4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed7e8p+17,                0x1.8p+1,   0x1.ca7702da38c72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fa1f57db2p+35,                0x1.8p+0,   0x1.f735812ae8572p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2120deb2p+35,                0x1.8p+0,   0x1.8fac712a45f92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.98b5001b2p+35,                0x1.8p+0,   0x1.6d28f5127c20ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7338p+17,                0x1.8p+1,   0x1.432f3c9c4ab3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2f08p+17,                0x1.8p+1,    0x1.39de1b3589edp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c7c3a2082p+35,                0x1.8p+0,    0x1.ae01bd68a2f3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af8547372p+35,                0x1.8p+0,   0x1.8c2831db50416p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.de808p+17,                0x1.8p+1,    0x1.a1eff88d31b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc708p+17,                0x1.8p+1,    0x1.4ee2fe5a71b5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d357c8dd2p+35,                0x1.8p+0,   0x1.be7f38b4b8fc6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5d68p+17,                0x1.8p+1,   0x1.8ba4c5caaf53ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7bf8p+17,                0x1.8p+1,    0x1.baa2ce62d574p+53,          0x1p-1, INEXACT)
T(RN,       0x1.58c240762p+35,                0x1.8p+0,   0x1.1ae74058de70cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fab8807f2p+35,                0x1.8p+0,   0x1.f819fcdb17c86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1eeeafe2p+35,                0x1.8p+0,   0x1.bc7a74db82da4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5178p+17,                0x1.8p+1,   0x1.62d42245979c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa098p+17,                0x1.8p+1,   0x1.ee51a0864ab66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a5eaa512p+35,                0x1.8p+0,   0x1.1ce3792f5a252p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8458p+17,                0x1.8p+1,   0x1.91d2cbe09c55ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.daeb8p+17,                0x1.8p+1,   0x1.989f1c5069a64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.673904f62p+35,                0x1.8p+0,   0x1.2ce45e7421bf4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.82f7c9332p+35,                0x1.8p+0,   0x1.506aa825c7022p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e47e8p+17,                0x1.8p+1,   0x1.b1d6093869972p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9e183b92p+35,                0x1.8p+0,   0x1.df2eada96f3fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6dfceb512p+35,                0x1.8p+0,   0x1.356e97b116faep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9f8fdd32p+35,                0x1.8p+0,   0x1.df512057fc562p+53,          0x1p-1, INEXACT)
T(RN,       0x1.be4c450f2p+35,                0x1.8p+0,   0x1.a0adffcadcc9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab8b8p+17,                0x1.8p+1,   0x1.2a21382e4c244p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4bb8p+17,                0x1.8p+1,   0x1.b279fb7d9c0d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.61339ca02p+35,                0x1.8p+0,    0x1.255bd64365bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8714c3552p+35,                0x1.8p+0,   0x1.55cb6eb62be36p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4678p+17,                0x1.8p+1,   0x1.61374507977b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7cdda8542p+35,                0x1.8p+0,   0x1.487d9e1304748p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51e6d0782p+35,                0x1.8p+0,    0x1.12814ea4ca5dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5e6442f2p+35,                0x1.8p+0,   0x1.7efb6c5d822dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c67b87f32p+35,                0x1.8p+0,   0x1.ac31ba3fc8a5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4078p+17,                0x1.8p+1,   0x1.3c3ba131da298p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef4e6a272p+35,                0x1.8p+0,   0x1.e72a296eeedcap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e659e4f2p+35,                0x1.8p+0,   0x1.4a79377a6f0e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b04c8p+17,                0x1.8p+1,   0x1.342f7f5076344p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c814c96a2p+35,                0x1.8p+0,   0x1.ae749c6c05454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7d58p+17,                0x1.8p+1,   0x1.90b52e896988ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.64b02ccc2p+35,                0x1.8p+0,   0x1.29b694cffaf88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.961f1c002p+35,                0x1.8p+0,     0x1.69b34f68558p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad358p+17,                0x1.8p+1,   0x1.2d9fd993167aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5cf8p+17,                0x1.8p+1,    0x1.401fd6b47ab7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.82010a382p+35,                0x1.8p+0,    0x1.4f2916a748fbp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7bc669b72p+35,                0x1.8p+0,   0x1.47149c3c900eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bcb18p+17,                0x1.8p+1,   0x1.4f7602be1289ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.696b14b22p+35,                0x1.8p+0,   0x1.2fa7a33a9b024p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7813a2492p+35,                0x1.8p+0,   0x1.425079bfc25e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7fd7da282p+35,                0x1.8p+0,    0x1.4c599cf1c47fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fecd8p+17,                0x1.8p+1,   0x1.fc6aa603898b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1e98p+17,                0x1.8p+1,   0x1.166de6f86a406p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8738p+17,                0x1.8p+1,   0x1.bc8d916e442fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a02483f2p+35,                0x1.8p+0,   0x1.59a3dc06262fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9628p+17,                0x1.8p+1,   0x1.bf1b60b72175ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db7a8p+17,                0x1.8p+1,   0x1.9a10a82a9bbe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe774b6a2p+35,                0x1.8p+0,   0x1.fdb362216e854p+53,          0x1p-1, INEXACT)
T(RN,       0x1.671c8ae22p+35,                0x1.8p+0,   0x1.2cc097b13a204p+53,          0x1p-1, INEXACT)
T(RN,       0x1.78b841b92p+35,                0x1.8p+0,   0x1.4324331633002p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.beeb0aff2p+35,                0x1.8p+0,   0x1.a18c6e4fe0786p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7242da72p+35,                0x1.8p+0,   0x1.db2b16c4e0b36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb088p+17,                0x1.8p+1,   0x1.f13e624ab1a98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afb18p+17,                0x1.8p+1,   0x1.32e476954099ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dcea5fbf2p+35,                0x1.8p+0,   0x1.cc49108beb1fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6258p+17,                0x1.8p+1,   0x1.e3013410e09fap+53,          0x1p-1, INEXACT)
T(RN,       0x1.767dd2d12p+35,                0x1.8p+0,   0x1.4047545a176aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c2dca492p+35,                0x1.8p+0,   0x1.479a32294aa1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4988p+17,                0x1.8p+1,   0x1.61aa16bfe4348p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2588p+17,                0x1.8p+1,   0x1.174bfd7397488p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba4f4bd12p+35,                0x1.8p+0,   0x1.9b1b5f43278aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd64092d2p+35,                0x1.8p+0,   0x1.b5fe845100f66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.916929cc2p+35,                0x1.8p+0,   0x1.636cede893d88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9375f4f2p+35,                0x1.8p+0,   0x1.de351f92d2ee6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9eb094842p+35,                0x1.8p+0,   0x1.75350a14dd7d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3d28p+17,                0x1.8p+1,   0x1.5fdab8d31ac2ep+53,         -0x1p-1, INEXACT)
T(RN,     0x1.169eebaf902p+43,                0x1.4p+0,    0x1.de9b7d5ad3d3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b29a5e442p+35,                0x1.8p+0,   0x1.9068c48af45a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e4cdfd042p+35,                0x1.8p+0,   0x1.d7c0e86d30528p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8dad596a2p+35,                0x1.8p+0,   0x1.5e7a69281f454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6f38p+17,                0x1.8p+1,   0x1.67370914e667cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbde8p+17,                0x1.8p+1,   0x1.f3b506f414892p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61e71a9e2p+35,                0x1.8p+0,   0x1.263b91b4f9564p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9468p+17,                0x1.8p+1,   0x1.becea6d4ad60ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e90a69562p+35,                0x1.8p+0,   0x1.ddf334a413bccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8cd123e12p+35,                0x1.8p+0,   0x1.5d57755976a32p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7458p+17,                0x1.8p+1,   0x1.4356fa93bfa5ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f05c0dd12p+35,                0x1.8p+0,   0x1.e8b82f15ae352p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc3d8p+17,                0x1.8p+1,   0x1.9c09fc1d5a682p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6a808be82p+35,                0x1.8p+0,    0x1.31059458ec27p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed76be7f2p+35,                0x1.8p+0,   0x1.e472eee8b7f7ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8a88p+17,                0x1.8p+1,   0x1.2421b4aebf778p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.adea60072p+35,                0x1.8p+0,   0x1.89f2e0aaff676p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b022c332p+35,                0x1.8p+0,   0x1.31a93e9515622p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecb88p+17,                0x1.8p+1,   0x1.c85009f7c97a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73f4f21f2p+35,                0x1.8p+0,   0x1.3d0852fd80ebap+53,          0x1p-1, INEXACT)
T(RN,       0x1.89807e1a2p+35,                0x1.8p+0,   0x1.58f9212cebb34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b44bcf932p+35,                0x1.8p+0,   0x1.92c05c6b42f1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce9b8p+17,                0x1.8p+1,   0x1.79a843d130874p+53,          0x1p-1, INEXACT)
T(RN,       0x1.da6497dd2p+35,                0x1.8p+0,   0x1.c8a368931c23ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be888p+17,                0x1.8p+1,   0x1.53a4581cdb518p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7bc63fc2p+35,                0x1.8p+0,   0x1.dc09dd1540ca8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2eb8p+17,                0x1.8p+1,   0x1.39d348412a264p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ec768p+17,                0x1.8p+1,   0x1.c798c3f4ef41ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc628p+17,                0x1.8p+1,   0x1.9c6a0cdbbc85ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab2f679e2p+35,                0x1.8p+0,   0x1.8633a9bb63364p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.92dd62872p+35,                0x1.8p+0,   0x1.655bbf3e3f176p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd318p+17,                0x1.8p+1,   0x1.763465dfdc61ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f65e8p+17,                0x1.8p+1,   0x1.e3a5c20077412p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4f68p+17,                0x1.8p+1,   0x1.896ff1c5e099ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1898p+17,                0x1.8p+1,   0x1.a9f0dffb585e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c348p+17,                0x1.8p+1,   0x1.0b2d79156e8fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b2494e822p+35,                0x1.8p+0,   0x1.8ff8c331d8644p+53,          0x1p-1, INEXACT)
T(RN,            0x1.6908p+13,                  0x1p+2,    0x1.fa532cdde264p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bafc3da12p+35,                0x1.8p+0,   0x1.9c0c949651ab2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe794aa62p+35,                0x1.8p+0,   0x1.fdb65fd5df114p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bfb3112f2p+35,                0x1.8p+0,   0x1.a2a4df5ddfcdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5c98p+17,                0x1.8p+1,   0x1.b5519595020a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb1ffc292p+35,                0x1.8p+0,   0x1.f8b470d5d0c22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f97c56aa2p+35,                0x1.8p+0,   0x1.f6427b45888d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7c78p+17,                0x1.8p+1,   0x1.90918465985d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95c7d8c92p+35,                0x1.8p+0,   0x1.693ec200eb0e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f111494f2p+35,                0x1.8p+0,   0x1.e9c3f18cadae6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef118p+17,                0x1.8p+1,   0x1.ceddc7cd448bep+53,          0x1p-1, INEXACT)
T(RN,            0x1.3ca8p+13,                  0x1p+2,   0x1.2ba44b93e1ed8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a70c8p+17,                0x1.8p+1,   0x1.20d2a71504384p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8bad122c2p+35,                0x1.8p+0,   0x1.5bd60c00e6bc8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea5ccb082p+35,                0x1.8p+0,    0x1.dfe39a28fe53p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5948e0f72p+35,                0x1.8p+0,   0x1.1b8d060458f6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2a68p+17,                0x1.8p+1,   0x1.393e027d83f2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e03f1a312p+35,                0x1.8p+0,   0x1.d11db53ea0492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce5914772p+35,                0x1.8p+0,   0x1.b75ba005dc996p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed8b8p+17,                0x1.8p+1,   0x1.ca9b3f1f1e844p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c69224d92p+35,                0x1.8p+0,   0x1.ac51afbadafc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eaca6cc42p+35,                0x1.8p+0,   0x1.e0849297d0158p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.75d2da432p+35,                0x1.8p+0,   0x1.3f6c18b94ac42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b90e60c2p+35,                0x1.8p+0,   0x1.1e5d9d2e3ef08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c7837c192p+35,                0x1.8p+0,   0x1.ada6f7d335d42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0148p+17,                0x1.8p+1,   0x1.33b7ca73e969cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.75c52e772p+35,                0x1.8p+0,   0x1.3f5a932916a6ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.aabc57eb2p+35,                0x1.8p+0,   0x1.85960df8c3392p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5118p+17,                0x1.8p+1,   0x1.b36164d34babep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8283533f2p+35,                0x1.8p+0,   0x1.4fd2d4bc04706p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5ed8p+17,                0x1.8p+1,   0x1.64cbd473b1f12p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c944e4762p+35,                0x1.8p+0,   0x1.b0236b70d30f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0d18p+17,                0x1.8p+1,   0x1.58e21329077fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.be4889062p+35,                0x1.8p+0,   0x1.a0a8c4eba7aacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6c3c2362p+35,                0x1.8p+0,   0x1.f235adae6ef74p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e69c8p+17,                0x1.8p+1,   0x1.b78c6538e0534p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c98b8p+17,                0x1.8p+1,   0x1.6d64d6dbabc44p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cebfbb602p+35,                0x1.8p+0,    0x1.b7edfa727144p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af368p+17,                0x1.8p+1,   0x1.31de6e7c0365ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae178p+17,                0x1.8p+1,   0x1.2f7d4aa6414c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.672ef7dd2p+35,                0x1.8p+0,   0x1.2cd7bda03023ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eeba8p+17,                0x1.8p+1,   0x1.cde9ecc3667a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd8e8p+17,                0x1.8p+1,   0x1.f8b470d5d0c22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aadb62c12p+35,                0x1.8p+0,   0x1.85c091474ce72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bf2e52412p+35,                0x1.8p+0,   0x1.a1eabafc9f772p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b88b8p+17,                0x1.8p+1,   0x1.4628f4afd5944p+53,          0x1p-1, INEXACT)
T(RN,       0x1.beddf69e2p+35,                0x1.8p+0,   0x1.a17a19f09829cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9ad8p+17,                0x1.8p+1,   0x1.6db651def6852p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3fb8p+17,                0x1.8p+1,   0x1.86f98895c3a94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9738p+17,                0x1.8p+1,   0x1.bf49fa6df95fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2398p+17,                0x1.8p+1,   0x1.d7c696dcfe076p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac428p+17,                0x1.8p+1,   0x1.2ba0ae58356fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62ee03d72p+35,                0x1.8p+0,   0x1.2783ae540cad6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed538p+17,                0x1.8p+1,   0x1.c9ff35681df9cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e77f81f2p+35,                0x1.8p+0,   0x1.21f5df3156546p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d7ab15b2p+35,                0x1.8p+0,   0x1.4948dc1f7d78ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc538p+17,                0x1.8p+1,   0x1.f50eb274e3c9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3d98p+17,                0x1.8p+1,   0x1.3bd795e720056p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f19f35e32p+35,                0x1.8p+0,   0x1.ea95c2c6cc07ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a03a8p+17,                0x1.8p+1,   0x1.1313ebcba1826p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0e41cd42p+35,                0x1.8p+0,   0x1.a4510787563b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4658p+17,                0x1.8p+1,   0x1.ddf8efc92cebap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc838p+17,                0x1.8p+1,   0x1.748d7acaaee2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.58c240762p+35,                0x1.8p+0,   0x1.1ae74058de70cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee438p+17,                0x1.8p+1,   0x1.cc9cead5c6f6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0348p+17,                0x1.8p+1,   0x1.5778a422214fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff6d0a8d2p+35,                0x1.8p+0,   0x1.ff239fa5dc3dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cf2ff08a2p+35,                0x1.8p+0,   0x1.b88e071f84394p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f79bdfcd2p+35,                0x1.8p+0,   0x1.f3770cb5f32a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d96c8p+17,                0x1.8p+1,   0x1.94c59ef98d0a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af93f7ab2p+35,                0x1.8p+0,   0x1.8c3c6c72c94eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6add209c2p+35,                0x1.8p+0,   0x1.317a75b0a7398p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad1f0aaa2p+35,                0x1.8p+0,   0x1.88db85dda90d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a66c8p+17,                0x1.8p+1,   0x1.1f8b6ea0bc7a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.557570f02p+35,                0x1.8p+0,    0x1.16d9e32dbce6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.acfa8p+17,                0x1.8p+1,   0x1.2d2387e4e4c66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7658p+17,                0x1.8p+1,   0x1.8f9818aa02fbap+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb45d15c2p+35,                0x1.8p+0,   0x1.e139d516cd718p+53,          0x1p-1, INEXACT)
T(RN,       0x1.488943532p+35,                0x1.8p+0,   0x1.072c0e2959f9ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc588p+17,                0x1.8p+1,   0x1.f51d7bb13c288p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af7a430a2p+35,                0x1.8p+0,   0x1.8c19065d6236cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.acb58p+17,                0x1.8p+1,   0x1.2c924f634d22ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3648p+17,                0x1.8p+1,   0x1.3ad97f3e25d8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc6726d12p+35,                0x1.8p+0,   0x1.cb8b254eb5eaep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c405f9b2p+35,                0x1.8p+0,   0x1.0ba61a543530ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c477a312p+35,                0x1.8p+0,   0x1.3344796c34492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45ad1b4c2p+35,                0x1.8p+0,   0x1.03be3ceca1688p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6968p+13,                  0x1p+2,   0x1.fc6e8d5766b08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46464e7c2p+35,                0x1.8p+0,   0x1.04759960b1ba8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a07ddd042p+35,                0x1.8p+0,   0x1.77a46cca03ad8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee0c8p+17,                0x1.8p+1,   0x1.cc0337bfa4884p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7e28p+17,                0x1.8p+1,   0x1.696e5182806dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b6883692p+35,                0x1.8p+0,   0x1.5b7ba8c9ac65ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff111be42p+35,                0x1.8p+0,   0x1.fe99d3a5dd818p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.61d8p+13,                  0x1p+2,   0x1.d331613537ab8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc938p+17,                0x1.8p+1,   0x1.4f3222c25d15cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9988p+17,                0x1.8p+1,   0x1.ed06c41958248p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8828p+17,                0x1.8p+1,   0x1.bcb6875c69dbep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d72e8p+17,                0x1.8p+1,   0x1.8f0c4ae8e9002p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5603986d2p+35,                0x1.8p+0,   0x1.178817c61e61ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51d1b1962p+35,                0x1.8p+0,   0x1.1267925dd764cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.aadf09c02p+35,                0x1.8p+0,    0x1.85c591deefa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.911b425e2p+35,                0x1.8p+0,   0x1.63057ad6cbfe4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ff706732p+35,                0x1.8p+0,   0x1.4c821a5a99d5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.babd8p+17,                0x1.8p+1,   0x1.4b0f6d1b6d602p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b46d8p+17,                0x1.8p+1,   0x1.3d19c2caade92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0b18p+17,                0x1.8p+1,   0x1.14001e939349ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4458p+17,                0x1.8p+1,   0x1.3cc29a2d2b95ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.afa82ab32p+35,                0x1.8p+0,   0x1.8c583e22e4322p+53,          0x1p-1, INEXACT)
T(RN,       0x1.54492c6c2p+35,                0x1.8p+0,   0x1.156a6278caeb8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51889a8d2p+35,                0x1.8p+0,   0x1.120e89367a3dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6738p+17,                0x1.8p+1,   0x1.8d31e9ad46cfcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7c18p+17,                0x1.8p+1,   0x1.e7a9e6cee414ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb958p+17,                0x1.8p+1,   0x1.c529690a2e9cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bde98p+17,                0x1.8p+1,   0x1.523a0871f1806p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5cd2843a2p+35,                0x1.8p+0,   0x1.1feb73eb91074p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe0d79952p+35,                0x1.8p+0,   0x1.fd14ec842094ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd181ad12p+35,                0x1.8p+0,   0x1.b59269c4e86aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b10adfb12p+35,                0x1.8p+0,   0x1.8e412b514e192p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3bf8p+17,                0x1.8p+1,    0x1.afd5bce414b4p+53,          0x1p-1, INEXACT)
T(RN,     0x1.155b136e3a2p+43,                0x1.4p+0,   0x1.dbe48516e13b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a99a8p+17,                0x1.8p+1,   0x1.26163fe933b46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a78c8p+17,                0x1.8p+1,   0x1.21d9204d36d04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc978p+17,                0x1.8p+1,   0x1.f5d7e296ab048p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5e814f52p+35,                0x1.8p+0,   0x1.7efde5384508ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6efc6cdc2p+35,                0x1.8p+0,   0x1.36b2d8f8c7de8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce108p+17,                0x1.8p+1,    0x1.78543d4a0303p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c42f42a2p+35,                0x1.8p+0,   0x1.1f39c733e302cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dae68p+17,                0x1.8p+1,   0x1.98923482b35eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5408p+17,                0x1.8p+1,    0x1.1d287f9da4fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8283533f2p+35,                0x1.8p+0,   0x1.4fd2d4bc04706p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1496b802p+35,                0x1.8p+0,     0x1.8e9776b6b85p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86ee4fd62p+35,                0x1.8p+0,   0x1.5599078374cccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.eff1bd142p+35,                0x1.8p+0,   0x1.e81b32c761d38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.defdc5bc2p+35,                0x1.8p+0,   0x1.cf4b342c72f28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aafb8p+17,                0x1.8p+1,   0x1.28f46118f4f94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f46ed142p+35,                0x1.8p+0,   0x1.22f6dbd60c2c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f22f8p+17,                0x1.8p+1,    0x1.d7aa2f22be09p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6987a6262p+35,                0x1.8p+0,   0x1.2fcba4d166e14p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0ed79eb2p+35,                0x1.8p+0,   0x1.a45e2e594b792p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1ec8p+17,                0x1.8p+1,   0x1.81d67e249a224p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d05c8p+17,                0x1.8p+1,   0x1.7df815d22be74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a3369e12p+35,                0x1.8p+0,   0x1.59e4846db81cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0b36d892p+35,                0x1.8p+0,   0x1.a40ca87c54b62p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e1168362p+35,                0x1.8p+0,   0x1.2176a03dcb374p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1d7b0e72p+35,                0x1.8p+0,   0x1.a5a7520a004b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf098p+17,                0x1.8p+1,   0x1.7ab5ea8d8c266p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df8f8p+17,                0x1.8p+1,    0x1.a4b7a4006b8bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.97418p+17,                0x1.8p+1,   0x1.01ab40dfd13cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8c08p+17,                0x1.8p+1,    0x1.bd5fefe611a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f83e8p+17,                0x1.8p+1,   0x1.e9154640c0eb2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.784034942p+35,                0x1.8p+0,   0x1.4289c82297a38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d79d553a2p+35,                0x1.8p+0,   0x1.c4a1f3dd3858cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4df8p+17,                0x1.8p+1,    0x1.8936115dce6ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad4afd5e2p+35,                0x1.8p+0,   0x1.8917e15232e1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c183f632p+35,                0x1.8p+0,   0x1.3308b99205d7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ba18p+17,                0x1.8p+1,   0x1.0a100789df1eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d41e96d92p+35,                0x1.8p+0,   0x1.bf9c3ec3bd43ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.63499fc12p+35,                0x1.8p+0,   0x1.27f61ecad7b8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.af0df6cd2p+35,                0x1.8p+0,   0x1.8b83ef51c70a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e97d8p+17,                0x1.8p+1,   0x1.bf65656bbe842p+53,          0x1p-1, INEXACT)
T(RN,            0x1.6278p+13,                  0x1p+2,    0x1.d680a2fe3526p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8d48p+17,                0x1.8p+1,   0x1.93403c273b4dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc7f8p+17,                0x1.8p+1,    0x1.9cb562afc158p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5ed8p+17,                0x1.8p+1,   0x1.8bdee33bbcf12p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5808p+13,                  0x1p+2,     0x1.a17c5bbab56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.607305ae2p+35,                0x1.8p+0,   0x1.246c06a5374c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e8ef0c472p+35,                0x1.8p+0,   0x1.ddcb17e8c220ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9b38p+17,                0x1.8p+1,   0x1.264a15ecacabcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb058p+17,                0x1.8p+1,   0x1.4bb10b1e62b9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1558p+17,                0x1.8p+1,   0x1.805fd4fd4c10ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba95f21c2p+35,                0x1.8p+0,   0x1.9b7de2c871a98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.caf28p+17,                0x1.8p+1,   0x1.70c3911bf128ep+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4c48p+13,                  0x1p+2,    0x1.6b4e8647727dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.77a5f6a92p+35,                0x1.8p+0,   0x1.41c386f394f22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d90c8p+17,                0x1.8p+1,   0x1.93cf944be7984p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4599f76e2p+35,                0x1.8p+0,   0x1.03a7576cf9b44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cde58p+17,                0x1.8p+1,   0x1.77eb369eef73ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.446b35292p+35,                0x1.8p+0,   0x1.023d8398bca22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61f7bb8d2p+35,                0x1.8p+0,   0x1.26504ebc3f1dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf578p+17,                0x1.8p+1,   0x1.7b756d5177088p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa688p+17,                0x1.8p+1,   0x1.ef683b46454b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f33b8p+17,                0x1.8p+1,   0x1.daa4fbedf8454p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fad27132p+35,                0x1.8p+0,   0x1.611fd95dc4fe2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1b68p+17,                0x1.8p+1,   0x1.81506629529dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94b40dae2p+35,                0x1.8p+0,   0x1.67ceb7449db3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebdd8p+17,                0x1.8p+1,   0x1.c5f0a4457a262p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1818p+17,                0x1.8p+1,   0x1.a9dba5b1b488ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b54297d2p+35,                0x1.8p+0,   0x1.70addfbed9706p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d678p+17,                0x1.8p+1,   0x1.0d842c48422b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.59db1d492p+35,                0x1.8p+0,   0x1.1c413ba58bfe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0998p+17,                0x1.8p+1,   0x1.58610adb40096p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c5218c32p+35,                0x1.8p+0,   0x1.0bbb850c95942p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b3938362p+35,                0x1.8p+0,   0x1.465e45d436c8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3418p+17,                0x1.8p+1,   0x1.dab6192f2c7cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a934213d2p+35,                0x1.8p+0,   0x1.837d6ed36757ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b78d8p+17,                0x1.8p+1,   0x1.43f61306348f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5830c122p+35,                0x1.8p+0,   0x1.d8c947ffe161cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.835238792p+35,                0x1.8p+0,   0x1.50e09d6bc397ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f68653e32p+35,                0x1.8p+0,   0x1.f1da60b3fbb82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1ba8p+17,                0x1.8p+1,   0x1.d65e2c9d7a8a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7018p+17,                0x1.8p+1,   0x1.8e9a00a63ad0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8c3f0d922p+35,                0x1.8p+0,   0x1.5c969d2a878e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a627a27d2p+35,                0x1.8p+0,   0x1.7f5471d4bf906p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd9bb77b2p+35,                0x1.8p+0,   0x1.fc6aa603898b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f10442d2p+35,                0x1.8p+0,   0x1.22b2f4e81aa9ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3608p+13,                  0x1p+2,    0x1.135779d30fd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bccfa9f52p+35,                0x1.8p+0,   0x1.9e996c2934976p+53,          0x1p-1, INEXACT)
T(RN,       0x1.492ff6772p+35,                0x1.8p+0,   0x1.07f47496d0596p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d33b8p+17,                0x1.8p+1,   0x1.8519162a12454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bda48p+17,                0x1.8p+1,   0x1.519d1e061984cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0a473352p+35,                0x1.8p+0,   0x1.a3f7a06d1080ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97f0888a2p+35,                0x1.8p+0,   0x1.6c21c7bc7cc6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a3e7d092p+35,                0x1.8p+0,   0x1.6f38cbedd5462p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e788p+17,                0x1.8p+1,   0x1.0f9b7e4ba64e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4088p+17,                0x1.8p+1,   0x1.b09959ec73598p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca778p+17,                0x1.8p+1,   0x1.6f9b62c2345e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c9f59462p+35,                0x1.8p+0,   0x1.1fac1c5441ad4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f28e8p+17,                0x1.8p+1,   0x1.d8b836990a322p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fee78p+17,                0x1.8p+1,   0x1.fcb84cb02f738p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da848p+17,                0x1.8p+1,   0x1.979578ce3e8ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb178p+17,                0x1.8p+1,   0x1.f16a852cf5bc8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b39105d2p+35,                0x1.8p+0,   0x1.5b3d1e81c593ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c842181e2p+35,                0x1.8p+0,   0x1.aeb4c287da19cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dfd18p+17,                0x1.8p+1,   0x1.a565706047cfep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5ef58172p+35,                0x1.8p+0,   0x1.7f07c8be8c256p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e73e8p+17,                0x1.8p+1,   0x1.b943f677143b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7928p+17,                0x1.8p+1,   0x1.ba2856294d56ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f40f09012p+35,                0x1.8p+0,   0x1.ee3164dad5df2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f08e8p+17,                0x1.8p+1,   0x1.d30da62e8ed22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ebcf9872p+35,                0x1.8p+0,   0x1.5fe1bb1993c8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.673c5eb12p+35,                0x1.8p+0,   0x1.2ce8942437392p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.973b8p+17,                0x1.8p+1,   0x1.019fdd94c3054p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3008p+17,                0x1.8p+1,     0x1.189cffebae9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f252b3332p+35,                0x1.8p+0,   0x1.eb9f4803c0422p+53,          0x1p-1, INEXACT)
T(RN,       0x1.60cff88a2p+35,                0x1.8p+0,   0x1.24dfbba296c6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1b78p+17,                0x1.8p+1,   0x1.aa6afcd3723a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4752beb02p+35,                0x1.8p+0,    0x1.05b74aac2242p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bae28p+17,                0x1.8p+1,   0x1.4b6274303b7dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8dfcaed42p+35,                0x1.8p+0,   0x1.5ee34ed288fb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47e120b52p+35,                0x1.8p+0,   0x1.0662217149af6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fead381d2p+35,                0x1.8p+0,   0x1.fe042844cc5bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bab08p+17,                0x1.8p+1,    0x1.4af244663461p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e65193812p+35,                0x1.8p+0,   0x1.d9f714852a0f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eac0a2662p+35,                0x1.8p+0,   0x1.e07631ce5746cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b4181f552p+35,                0x1.8p+0,   0x1.9278cc38b49cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca828p+17,                0x1.8p+1,   0x1.6fb5d9271d3bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6978p+17,                0x1.8p+1,   0x1.8d8d1f73efe48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dcc98fd22p+35,                0x1.8p+0,   0x1.cc1990d5bf09cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ae38p+17,                0x1.8p+1,   0x1.08a044539174cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c99bda372p+35,                0x1.8p+0,   0x1.b09eb6ba55e16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5768p+17,                0x1.8p+1,   0x1.3f5cc3d22471ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d37a8p+17,                0x1.8p+1,   0x1.85b69038e63e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.481126342p+35,                0x1.8p+0,   0x1.069bc83c78008p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e754f4462p+35,                0x1.8p+0,   0x1.db7276241532cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5e28p+17,                0x1.8p+1,   0x1.b5951d6a7d0dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d72c3182p+35,                0x1.8p+0,    0x1.0d18a87df0d9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f65cb8b42p+35,                0x1.8p+0,   0x1.f19c8dbbf9ef8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d372efe2p+35,                0x1.8p+0,   0x1.3473f498205a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.83d2fcba2p+35,                0x1.8p+0,   0x1.5188a9fc06574p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1478p+17,                0x1.8p+1,   0x1.a941d43319258p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0e38p+17,                0x1.8p+1,   0x1.7f459aa11194cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dffe8p+17,                0x1.8p+1,   0x1.a5dc0b8329ff2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.858f599f2p+35,                0x1.8p+0,   0x1.53cd6c9368246p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3278p+17,                0x1.8p+1,   0x1.5e4bd0e866bf8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d2a5a882p+35,                0x1.8p+0,    0x1.7326bcb8e1ddp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0037ff82p+35,                0x1.8p+0,    0x1.a315b61d822dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d65d9b42p+35,                0x1.8p+0,   0x1.0d09076a444f8p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.9f4p+10,                0x1.4p+2,   0x1.6755837dd63c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62c60dfb2p+35,                0x1.8p+0,   0x1.2751c7aad2a4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a7269922p+35,                0x1.8p+0,   0x1.6f7e85f5610e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98188p+17,                0x1.8p+1,   0x1.03442f258adc8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8858p+17,                0x1.8p+1,   0x1.92763e15e801ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca668p+17,                0x1.8p+1,   0x1.6f727fbcdc86ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d01bf0642p+35,                0x1.8p+0,   0x1.b9dee5ac97ce8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f0b990b2p+35,                0x1.8p+0,   0x1.0f082707d89d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d885b4532p+35,                0x1.8p+0,   0x1.c5f0a4457a262p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3b88p+17,                0x1.8p+1,   0x1.1a0f519711ca8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58d796982p+35,                0x1.8p+0,    0x1.1b0183f4ce29p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3528p+17,                0x1.8p+1,   0x1.aeb21626206aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8e38p+17,                0x1.8p+1,   0x1.249b88b7e214cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9f6da8492p+35,                0x1.8p+0,   0x1.763465dfdc61ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f414f7012p+35,                0x1.8p+0,   0x1.ee3a2f2bd5e0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ad1da3a2p+35,                0x1.8p+0,   0x1.1d71a1a1e138cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d8d856242p+35,                0x1.8p+0,   0x1.c667bc5e24d98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea168p+17,                0x1.8p+1,   0x1.c1096fbe49ffap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bf4d54b2p+35,                0x1.8p+0,   0x1.32dbeec404a52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.abdc8p+17,                0x1.8p+1,   0x1.2acaca52108f4p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4e88p+13,                  0x1p+2,    0x1.753f5ab3e4eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9dae8p+17,                0x1.8p+1,   0x1.0e0f2151c1f82p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b42d8p+17,                0x1.8p+1,   0x1.3c8e5646c7bd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9acf8cb02p+35,                0x1.8p+0,    0x1.6ffba301a07ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea5a8p+17,                0x1.8p+1,   0x1.c1c47343d0b86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d29e8p+17,                0x1.8p+1,   0x1.83915d9c72ed2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49e0759c2p+35,                0x1.8p+0,   0x1.08c8d95f1aa68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b09f8p+17,                0x1.8p+1,    0x1.34e124754b9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e45a4ce2p+35,                0x1.8p+0,   0x1.35cad71398184p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3e68p+17,                0x1.8p+1,   0x1.3bf3d9bc878eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.943cf3f82p+35,                0x1.8p+0,    0x1.672fedf69dadp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.664498d72p+35,                0x1.8p+0,   0x1.2bb1793f120d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cacb8p+17,                0x1.8p+1,   0x1.706596ad79c04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b729f7682p+35,                0x1.8p+0,    0x1.96ba98301989p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7de8p+17,                0x1.8p+1,   0x1.44a94cde81c92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bcb8p+17,                0x1.8p+1,   0x1.0a6180e853f04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c04e58ac2p+35,                0x1.8p+0,   0x1.a37ebfb4c62c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d58f8402p+35,                0x1.8p+0,    0x1.349ec30a6918p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7168p+17,                0x1.8p+1,   0x1.8ecf53c97befap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8b48p+17,                0x1.8p+1,   0x1.92ee622acf67cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c6d239c82p+35,                0x1.8p+0,    0x1.acac453a34dbp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bad709872p+35,                0x1.8p+0,   0x1.9bd8ad352a376p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.85657c432p+35,                0x1.8p+0,   0x1.5396a75c64fbep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf908p+17,                0x1.8p+1,    0x1.7c01895ecd4bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be0b8p+17,                0x1.8p+1,   0x1.52876c6f4f1c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0ac8p+17,                0x1.8p+1,   0x1.7ebda2757ba64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e37b966d2p+35,                0x1.8p+0,   0x1.d5d34ef5935e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8688f9dd2p+35,                0x1.8p+0,   0x1.55143dbece1c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e91df56b2p+35,                0x1.8p+0,   0x1.de0fdcd2d9e92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2328p+17,                0x1.8p+1,   0x1.d7b2b488c424ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5cc8p+17,                0x1.8p+1,   0x1.401942145abc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.452594062p+35,                0x1.8p+0,   0x1.031c2af6a48acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae3b071d2p+35,                0x1.8p+0,   0x1.8a61c17d217bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aac1d2382p+35,                0x1.8p+0,    0x1.859d8e54a205p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e67e69672p+35,                0x1.8p+0,   0x1.da38a188eec4ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bb58p+17,                0x1.8p+1,   0x1.0a36d18bbf72ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8698p+17,                0x1.8p+1,   0x1.e9926ffefd386p+53,          0x1p-1, INEXACT)
T(RN,       0x1.706dea4b2p+35,                0x1.8p+0,   0x1.3888894faebaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.656ce7cd2p+35,                0x1.8p+0,   0x1.2aa2fdedcc2a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.febf32502p+35,                0x1.8p+0,    0x1.fe1f16e09a62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2898p+17,                0x1.8p+1,   0x1.5cdc48e3a60e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.47292c352p+35,                0x1.8p+0,   0x1.0585703bc660ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9448p+17,                0x1.8p+1,   0x1.25641d8d0092cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea5ec0192p+35,                0x1.8p+0,   0x1.dfe679b5a6abep+53,          0x1p-1, INEXACT)
T(RN,       0x1.60ea89522p+35,                0x1.8p+0,   0x1.2500d060ab19cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bce8p+17,                0x1.8p+1,   0x1.0a67535b10ce2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b16c8p+17,                0x1.8p+1,   0x1.36990beffd8a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd2d8p+17,                0x1.8p+1,   0x1.508ef0ae7ded2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.520a90152p+35,                0x1.8p+0,   0x1.12acdfb37e44ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee7e8p+17,                0x1.8p+1,   0x1.cd41f192ba772p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a538p+17,                0x1.8p+1,   0x1.078a6cd79769cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eeb88p+17,                0x1.8p+1,   0x1.cde452aabdda8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b31c8p+17,                0x1.8p+1,   0x1.3a3d66579b2b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dbebb6712p+35,                0x1.8p+0,   0x1.cad895c5b97eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.64e3ee642p+35,                0x1.8p+0,   0x1.29f76383648e8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd6b8p+17,                0x1.8p+1,   0x1.76c1a5e6129e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9299fb0a2p+35,                0x1.8p+0,   0x1.650213746f36cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9fa583282p+35,                0x1.8p+0,    0x1.767fe05d7fdfp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce3c92ca2p+35,                0x1.8p+0,   0x1.b732fe7244a14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7438p+17,                0x1.8p+1,   0x1.21435bb82aa6cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e21b7432p+35,                0x1.8p+0,   0x1.5f1449b14c642p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3fc2b402p+35,                0x1.8p+0,    0x1.bf6ae15a83c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd498p+17,                0x1.8p+1,   0x1.f7e7852988b26p+53,          0x1p-1, INEXACT)
T(RN,       0x1.719dd88f2p+35,                0x1.8p+0,   0x1.3a0b93efad39ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7a46acfd2p+35,                0x1.8p+0,   0x1.45255c44a19fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2988p+17,                0x1.8p+1,   0x1.d8d4a92988d48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af6d8p+17,                0x1.8p+1,   0x1.3253872f2a792p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c23931d12p+35,                0x1.8p+0,   0x1.a630709c45b52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5098p+17,                0x1.8p+1,   0x1.899fc5b222466p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b18d8p+17,                0x1.8p+1,   0x1.36e00338406f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9f8e16662p+35,                0x1.8p+0,   0x1.7660382667c6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fecb8p+17,                0x1.8p+1,   0x1.fc64ad365f804p+53,          0x1p-1, INEXACT)
T(RN,       0x1.808c07fc2p+35,                0x1.8p+0,   0x1.4d43bb5e864a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.78e6950d2p+35,                0x1.8p+0,   0x1.435fcfe6a6926p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a246b92f2p+35,                0x1.8p+0,   0x1.7a0f29e174cdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4c78p+17,                0x1.8p+1,   0x1.6218501886cd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a03a8p+17,                0x1.8p+1,   0x1.1313ebcba1826p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca7e8p+17,                0x1.8p+1,   0x1.6fac3996fdb72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c345c052p+35,                0x1.8p+0,   0x1.71db75fa0436ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c26e58b2p+35,                0x1.8p+0,   0x1.4791492b3b2d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e36635c12p+35,                0x1.8p+0,   0x1.d5b4262ebf872p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e61b01332p+35,                0x1.8p+0,   0x1.d9a74f9d01fdep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b71d8p+17,                0x1.8p+1,   0x1.42feae2f7ae22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d0d1be92p+35,                0x1.8p+0,   0x1.0c9da46481f5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e87a8p+17,                0x1.8p+1,   0x1.bca0ae8d42ae6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b189d2f62p+35,                0x1.8p+0,   0x1.8ef058dfcb00cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1d08p+17,                0x1.8p+1,    0x1.d69c8e94ecb7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9008p+17,                0x1.8p+1,     0x1.eb4a9fd2bebp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c57b8p+17,                0x1.8p+1,   0x1.63bf4654cf714p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4888p+13,                  0x1p+2,    0x1.5b2e85539552p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed858p+17,                0x1.8p+1,   0x1.ca8a85878471ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d42e8p+17,                0x1.8p+1,   0x1.8779695307f02p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45140c1c2p+35,                0x1.8p+0,   0x1.0307369b3c168p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af4e33be2p+35,                0x1.8p+0,   0x1.8bdc5c450ee24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9878p+17,                0x1.8p+1,   0x1.bf80d18853318p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95525e0e2p+35,                0x1.8p+0,   0x1.68a1ec6fdcd04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.629ac62c2p+35,                0x1.8p+0,   0x1.271bbecab23c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97352b3a2p+35,                0x1.8p+0,   0x1.6b2706e5a5674p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdb68p+17,                0x1.8p+1,   0x1.7778813a03ddap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ec18p+17,                0x1.8p+1,   0x1.102b1af57de4ep+53,          0x1p-1, INEXACT)
T(RN,            0x1.47a8p+13,                  0x1p+2,   0x1.577f6e7f0c698p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2c88p+17,                0x1.8p+1,   0x1.5d6eb61e9f9d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a00ecdf2p+35,                0x1.8p+0,   0x1.1c6fda393543ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.45ecec402p+35,                0x1.8p+0,    0x1.040a98f96498p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.788f167d2p+35,                0x1.8p+0,   0x1.42ef3c1205efap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4e38p+17,                0x1.8p+1,   0x1.b2e59363a954cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7e48p+17,                0x1.8p+1,   0x1.e80f93349230cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4bf97fb52p+35,                0x1.8p+0,   0x1.0b507ade9570ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6aca9b862p+35,                0x1.8p+0,   0x1.31631308d7c54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bba98p+17,                0x1.8p+1,   0x1.4d21f0344d346p+53,          0x1p-1, INEXACT)
T(RN,       0x1.db0849322p+35,                0x1.8p+0,   0x1.c98fd66efbd24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1a48p+17,                0x1.8p+1,   0x1.aa3889e91c44cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce9c8p+17,                0x1.8p+1,   0x1.79aab6cac3d34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0e3f5f02p+35,                0x1.8p+0,    0x1.bafcac627cfap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45e9bb412p+35,                0x1.8p+0,   0x1.0406c73769572p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.98bfb8dc2p+35,                0x1.8p+0,   0x1.6d37539fbc5e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.731adf5f2p+35,                0x1.8p+0,   0x1.3bf1ad12f193ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1468p+17,                0x1.8p+1,   0x1.a93f2d9a2fe0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ace4753a2p+35,                0x1.8p+0,   0x1.888b1589bba74p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2768p+17,                0x1.8p+1,   0x1.178817c61e61ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0f88p+17,                0x1.8p+1,   0x1.d439012046c68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0088p+17,                0x1.8p+1,   0x1.5713865ed4998p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb2940f62p+35,                0x1.8p+0,   0x1.b2d2bdece43f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4328p+17,                0x1.8p+1,   0x1.1b058e807e84ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab0390922p+35,                0x1.8p+0,   0x1.85f79a25f691cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6af8p+17,                0x1.8p+1,    0x1.b7bfe3f561e1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cbe8p+17,                0x1.8p+1,   0x1.0c3a2a43d6832p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3848p+17,                0x1.8p+1,   0x1.85cf932f143ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f12a8p+17,                0x1.8p+1,   0x1.d4c6620a2aa76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5fdc15292p+35,                0x1.8p+0,   0x1.23b0418fbf5dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d23b1802p+35,                0x1.8p+0,     0x1.0cb8f764ed7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5d58p+17,                0x1.8p+1,   0x1.64933f86a928ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.9254d3532p+35,                0x1.8p+0,   0x1.64a61b2b78062p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a57cfe022p+35,                0x1.8p+0,   0x1.7e6c1d0022144p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8830217a2p+35,                0x1.8p+0,   0x1.573f2de0a84f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc708p+17,                0x1.8p+1,    0x1.f56478df7db5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9adc8p+17,                0x1.8p+1,   0x1.0892be3bac5f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9658p+17,                0x1.8p+1,   0x1.25a86f9d9f5bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f48f8p+17,                0x1.8p+1,    0x1.de715469b37bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7518p+17,                0x1.8p+1,   0x1.e664ead56d77ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.be968p+17,                0x1.8p+1,   0x1.53c44b4c3d97ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60a9ca2b2p+35,                0x1.8p+0,   0x1.24b0322e3e012p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a8a25eb52p+35,                0x1.8p+0,   0x1.82b6408e6490ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4288p+17,                0x1.8p+1,   0x1.60a3c9a24d9f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f01b14032p+35,                0x1.8p+0,   0x1.e8583b913a7c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7048p+17,                0x1.8p+1,   0x1.e585d16f3766cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa7e8p+17,                0x1.8p+1,   0x1.efa8cf094eb72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af4a8p+17,                0x1.8p+1,   0x1.3208ffa5ba1d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8768p+17,                0x1.8p+1,   0x1.e9b84b3c9b81ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.96ca2dd02p+35,                0x1.8p+0,    0x1.6a97f1036812p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f48f8ae02p+35,                0x1.8p+0,    0x1.eeeff10cf8ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba868p+17,                0x1.8p+1,   0x1.4a941b5a3dfcap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63d8f5b42p+35,                0x1.8p+0,   0x1.28a94b0049308p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0438p+17,                0x1.8p+1,   0x1.579b215d4056cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.94ceba232p+35,                0x1.8p+0,   0x1.67f24a43e3ffep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ec78p+17,                0x1.8p+1,   0x1.1036eaf623ad8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb348p+17,                0x1.8p+1,   0x1.4c1aa782215fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dce0b9102p+35,                0x1.8p+0,    0x1.cc3b17d24e26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d8e0064e2p+35,                0x1.8p+0,   0x1.c672d1873a284p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.888ceca82p+35,                0x1.8p+0,    0x1.57b9073b516fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ec65f85f2p+35,                0x1.8p+0,   0x1.e2e176cc5f4c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d74a8p+17,                0x1.8p+1,   0x1.8f537312259d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74cbdb162p+35,                0x1.8p+0,   0x1.3e1b3e257054cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b37a8p+17,                0x1.8p+1,   0x1.3b093bd2103e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6b08p+17,                0x1.8p+1,    0x1.b7c299e5eca1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b0d23a32p+35,                0x1.8p+0,   0x1.5b033cdd7e302p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ea6e68c52p+35,                0x1.8p+0,   0x1.dffd76849ba16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3308p+17,                0x1.8p+1,    0x1.18fd7b7749f9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d7facbc2p+35,                0x1.8p+0,   0x1.0d284a2c8f928p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f80506012p+35,                0x1.8p+0,   0x1.f41381f1593f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e57f8p+17,                0x1.8p+1,    0x1.b489da510308p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc748p+17,                0x1.8p+1,   0x1.f5704e635b5bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c697cc292p+35,                0x1.8p+0,   0x1.ac59ad59393dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b90c13ae2p+35,                0x1.8p+0,   0x1.995911390573cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3d48p+17,                0x1.8p+1,   0x1.1a47c86e0a5dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a88f6072p+35,                0x1.8p+0,   0x1.3110333c9358ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cebbede12p+35,                0x1.8p+0,   0x1.b7e88e38f3632p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f37ec9d72p+35,                0x1.8p+0,   0x1.ed5b9f46bc12ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.630a535a2p+35,                0x1.8p+0,   0x1.27a70a7261fb4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f6b600b2p+35,                0x1.8p+0,   0x1.23242653ff7d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9f08p+17,                0x1.8p+1,    0x1.ee0860c1a33dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc0b8p+17,                0x1.8p+1,   0x1.736a89cc3bbc4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4b98p+17,                0x1.8p+1,   0x1.88d67e86073f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c6d7da92p+35,                0x1.8p+0,   0x1.0bdca09751122p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bfdb8p+17,                0x1.8p+1,   0x1.56ac30d464834p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9c18p+17,                0x1.8p+1,   0x1.6de64588f674ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.90b661ce2p+35,                0x1.8p+0,   0x1.627f9514fc07cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5b28p+17,                0x1.8p+1,   0x1.e1b5a6cb228cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1ff8p+17,                0x1.8p+1,     0x1.ab2a4daeda6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.989869732p+35,                0x1.8p+0,   0x1.6d02a5718b75ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5c783482p+35,                0x1.8p+0,    0x1.c1fe3ed6dd95p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a33f8p+17,                0x1.8p+1,    0x1.191ba69b589cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c00d8p+17,                0x1.8p+1,   0x1.571f02ef36672p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7326cabe2p+35,                0x1.8p+0,   0x1.3c00e5ebae824p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ceb38p+17,                0x1.8p+1,   0x1.79e30e232c9bcp+53,          0x1p-1, INEXACT)
T(RN,            0x1.3e98p+13,                  0x1p+2,   0x1.330afe1a2b908p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3c28p+17,                0x1.8p+1,   0x1.5fb558eda397ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d1b2abc2p+35,                0x1.8p+0,   0x1.20456b8ef52d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c699ae9b2p+35,                0x1.8p+0,   0x1.ac5c573e5550ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba888p+17,                0x1.8p+1,   0x1.4a9896ce82918p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfe98p+17,                0x1.8p+1,   0x1.a5a4af47dee06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0666a2a2p+35,                0x1.8p+0,   0x1.7784b4184ebd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a260085e2p+35,                0x1.8p+0,   0x1.7a317ab863c1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.57770c252p+35,                0x1.8p+0,   0x1.194ff67fc12d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b43a8p+17,                0x1.8p+1,   0x1.3caaa50227426p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff091dca2p+35,                0x1.8p+0,   0x1.fe8dd957307ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6fe11192p+35,                0x1.8p+0,   0x1.c3bcbe94adcbep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ddf8c2892p+35,                0x1.8p+0,   0x1.cdd0b7afbee9ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2d88p+17,                0x1.8p+1,   0x1.5d93ecb2ae608p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd098p+17,                0x1.8p+1,   0x1.9e1c5e563fc66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d209a14f2p+35,                0x1.8p+0,   0x1.bca0ae8d42ae6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cec1a2212p+35,                0x1.8p+0,   0x1.b7f0b0937764ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d26ec8282p+35,                0x1.8p+0,    0x1.bd31783f5a41p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8e4849d2p+35,                0x1.8p+0,   0x1.af9ad4c120b46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e78e8p+17,                0x1.8p+1,   0x1.ba1d746403a22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4b78p+17,                0x1.8p+1,   0x1.1c12a22a38ca8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.959b56d72p+35,                0x1.8p+0,   0x1.6903547d35b2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5ad8p+17,                0x1.8p+1,   0x1.8b3d3b3e3ec52p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4f68p+13,                  0x1p+2,   0x1.792afadc26288p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a8747322p+35,                0x1.8p+0,   0x1.310e1370656dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef914e442p+35,                0x1.8p+0,   0x1.e78cdcb7ba5a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.91a1d6dc2p+35,                0x1.8p+0,   0x1.63b836f0939e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8bb41a962p+35,                0x1.8p+0,   0x1.5bdf52246cfb4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.98e8d3b82p+35,                0x1.8p+0,    0x1.6d6e6c3b2f6bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f43f8p+17,                0x1.8p+1,    0x1.dd8c13dd97ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bab68p+17,                0x1.8p+1,   0x1.4affb96fadcdap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b75a8p+17,                0x1.8p+1,   0x1.43855c5273a86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f3d5b8d12p+35,                0x1.8p+0,   0x1.eddc712b6a2aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fac88p+17,                0x1.8p+1,   0x1.f0822f0dfa1d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab788p+17,                0x1.8p+1,   0x1.29f97ada8abe8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf638p+17,                0x1.8p+1,   0x1.5599078374cccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c99021d2p+35,                0x1.8p+0,   0x1.0c113b5ae2e46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97d48p+17,                0x1.8p+1,   0x1.02c2aa6d841dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2898p+17,                0x1.8p+1,   0x1.38ff53c56b0e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5b88p+17,                0x1.8p+1,   0x1.b523add3122a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f4be55f2p+35,                0x1.8p+0,   0x1.22fd08a065ac6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2a18p+17,                0x1.8p+1,   0x1.8398d754f3eeep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c6f063502p+35,                0x1.8p+0,    0x1.acd6ea598ffep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49bd25332p+35,                0x1.8p+0,   0x1.089e55b6a57dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b66ef6972p+35,                0x1.8p+0,   0x1.95b6ea31a4556p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1608p+17,                0x1.8p+1,    0x1.155c6db463c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a35d8p+17,                0x1.8p+1,   0x1.1958035db24e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef928p+17,                0x1.8p+1,   0x1.d047f9ea52d6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c12b8p+17,                0x1.8p+1,   0x1.59b1b64a0f924p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca568p+17,                0x1.8p+1,   0x1.6f4c0731a0ebap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c46c8p+17,                0x1.8p+1,   0x1.6142fb3fe81a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2b78p+17,                0x1.8p+1,   0x1.5d472f06326a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.996430b22p+35,                0x1.8p+0,   0x1.6e13d74c337dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc57b7e52p+35,                0x1.8p+0,   0x1.cb74d0d57de56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4556fe532p+35,                0x1.8p+0,   0x1.03573ec6e099ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa588p+17,                0x1.8p+1,   0x1.ef3947b2d7c88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9435d83e2p+35,                0x1.8p+0,   0x1.6726749e39124p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fce48p+17,                0x1.8p+1,   0x1.f6bbf46e0620cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0c6d4352p+35,                0x1.8p+0,   0x1.8de350d6269f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3fb8p+17,                0x1.8p+1,   0x1.1a967a82eaa94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9bcde512p+35,                0x1.8p+0,   0x1.84386846c05aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.429c93922p+35,                0x1.8p+0,   0x1.0015e564db4e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44b2dd2a2p+35,                0x1.8p+0,   0x1.0293174f7a9d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cef12c3f2p+35,                0x1.8p+0,   0x1.b8347d6c0d506p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b124a03e2p+35,                0x1.8p+0,   0x1.8e64b2440c124p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7668p+17,                0x1.8p+1,   0x1.b9b0ac80db76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc56869c2p+35,                0x1.8p+0,   0x1.9df01a23fb068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.44f8f52c2p+35,                0x1.8p+0,   0x1.02e6d6756e238p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b49b8p+17,                0x1.8p+1,   0x1.3d7e120ed5a74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c44aaebc2p+35,                0x1.8p+0,   0x1.a91a126584528p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd64092d2p+35,                0x1.8p+0,   0x1.b5fe845100f66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.df03936a2p+35,                0x1.8p+0,   0x1.cf539faf7b854p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0c447742p+35,                0x1.8p+0,   0x1.a42452645a088p+53,          0x1p-1, INEXACT)
T(RN,       0x1.477454772p+35,                0x1.8p+0,   0x1.05df936b8b66ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.793219772p+35,                0x1.8p+0,   0x1.43c10514fc06ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d91e8p+17,                0x1.8p+1,   0x1.93fdaeb211e52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e69b8p+17,                0x1.8p+1,   0x1.b789af815d074p+53,          0x1p-1, INEXACT)
T(RN,       0x1.556d465f2p+35,                0x1.8p+0,   0x1.16cfe25b8d8c6p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.7569c8p+21,                0x1.4p+1,   0x1.d1281acda83a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b50b8p+17,                0x1.8p+1,   0x1.3e72a5ecf26c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c58a8p+17,                0x1.8p+1,   0x1.63e294b0b3e96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd6b8p+17,                0x1.8p+1,   0x1.511ba2645f9e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0738p+17,                0x1.8p+1,   0x1.58098e6af4afcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.aef88p+17,                0x1.8p+1,   0x1.315a925d66668p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6288775b2p+35,                0x1.8p+0,   0x1.2704e467f7472p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f932d23d2p+35,                0x1.8p+0,   0x1.f5d4ecc8f237ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1668p+17,                0x1.8p+1,   0x1.5a3a019d3756ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db64c5da2p+35,                0x1.8p+0,   0x1.ca157dc4e38b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7f08p+17,                0x1.8p+1,    0x1.90f9fca434ddp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd618p+17,                0x1.8p+1,   0x1.76a948e0ab12ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.57a4eb772p+35,                0x1.8p+0,   0x1.198853cb0646ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b48d8p+17,                0x1.8p+1,   0x1.3d5f88641a7f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a598p+17,                0x1.8p+1,   0x1.0795fc98ebfd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fda48p+17,                0x1.8p+1,   0x1.f8f5d2c7e584cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98fe8p+17,                0x1.8p+1,   0x1.04fb8323922f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbc0d25e2p+35,                0x1.8p+0,   0x1.b3aa1cc871fe4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e200e4f52p+35,                0x1.8p+0,   0x1.d3abbca63b08ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0888p+17,                0x1.8p+1,   0x1.5839e59087b18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.730b8c762p+35,                0x1.8p+0,   0x1.3bde1b8f9a0f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86c99d892p+35,                0x1.8p+0,   0x1.5568ef729eb62p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce405fc32p+35,                0x1.8p+0,   0x1.b738692db0742p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb6b0b1f2p+35,                0x1.8p+0,   0x1.e170886f0ff46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7a08p+17,                0x1.8p+1,    0x1.ba4e6dc3c8eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4bf485f2p+35,                0x1.8p+0,   0x1.c082cd5c8ab3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.902558f12p+35,                0x1.8p+0,   0x1.61bf304cac4eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e90d8p+17,                0x1.8p+1,   0x1.be3290b13a972p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c74720492p+35,                0x1.8p+0,   0x1.ad5194d49c9e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bacc8p+17,                0x1.8p+1,   0x1.4b31145c14ac4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b20f8p+17,                0x1.8p+1,    0x1.37f7fc77fd03p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5d58p+17,                0x1.8p+1,   0x1.8ba23f135428ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7593a1cc2p+35,                0x1.8p+0,   0x1.3f1b145d70d88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3a18p+17,                0x1.8p+1,   0x1.19e0f59b2c9eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4d68p+17,                0x1.8p+1,   0x1.1c517239d2a3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8cbc033b2p+35,                0x1.8p+0,   0x1.5d3b8f63177cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f21198862p+35,                0x1.8p+0,   0x1.eb3ef3517fa54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.938437642p+35,                0x1.8p+0,   0x1.6639d11d8cd18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dda98b642p+35,                0x1.8p+0,   0x1.cd5dedf104518p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdaa8p+17,                0x1.8p+1,   0x1.775b3b6ba73f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a57de102p+35,                0x1.8p+0,    0x1.453b86e9b406p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e4f2f7d72p+35,                0x1.8p+0,   0x1.d7f6e36ace2d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7218p+17,                0x1.8p+1,   0x1.67a409f73c86ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed178p+17,                0x1.8p+1,   0x1.c9582db84f1c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdd18p+17,                0x1.8p+1,   0x1.f97ba112d26fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff9a8p+17,                0x1.8p+1,   0x1.fecfbc5962d46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.802cb9412p+35,                0x1.8p+0,   0x1.4cc7dd99b468ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a20a8p+17,                0x1.8p+1,   0x1.16afe15684816p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c887f5dc2p+35,                0x1.8p+0,   0x1.af17b46ec53e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c477cd282p+35,                0x1.8p+0,    0x1.a959b012339fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af7a8p+17,                0x1.8p+1,   0x1.326f38f3357e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7ef324e2p+35,                0x1.8p+0,   0x1.f3f306528957cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.be0ea87a2p+35,                0x1.8p+0,   0x1.a057ba007750cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4798p+17,                0x1.8p+1,   0x1.de3241c13b536p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8518p+17,                0x1.8p+1,   0x1.bc30c2a26827ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.82b7769c2p+35,                0x1.8p+0,   0x1.5016ca66b5068p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f12d8p+17,                0x1.8p+1,   0x1.d4cede84e1ad2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.75a302112p+35,                0x1.8p+0,   0x1.3f2ec80e4292ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe6b50172p+35,                0x1.8p+0,   0x1.fda17025b2daap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3e78p+17,                0x1.8p+1,   0x1.dc903b1937638p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5d6d6e42p+35,                0x1.8p+0,   0x1.c214448cfa5e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f615698a2p+35,                0x1.8p+0,   0x1.f1329db27426cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e4e8p+17,                0x1.8p+1,   0x1.0f48f4ef7b062p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd148p+17,                0x1.8p+1,   0x1.9e39049db0d9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9368p+17,                0x1.8p+1,   0x1.bea2d2d6b945ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8f68p+17,                0x1.8p+1,   0x1.93973fe7ef59ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5ce8p+17,                0x1.8p+1,   0x1.6482bfe20fae2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eeea1c732p+35,                0x1.8p+0,   0x1.e696357d1315ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a43faa762p+35,                0x1.8p+0,   0x1.7cbc8f10fb4f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba708p+17,                0x1.8p+1,    0x1.4a62d007c955p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a708f19f2p+35,                0x1.8p+0,   0x1.80877c76eadbap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ea89d08c2p+35,                0x1.8p+0,   0x1.e025b2b2f41f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be248p+17,                0x1.8p+1,   0x1.52c05b9a751ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8879a96f2p+35,                0x1.8p+0,   0x1.579fbac4fbd5ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.685cbdf72p+35,                0x1.8p+0,   0x1.2e533041f3696p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd7b2fb82p+35,                0x1.8p+0,    0x1.cd1ac55be315p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7c08p+17,                0x1.8p+1,    0x1.4466e3e4d874p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b936c6572p+35,                0x1.8p+0,   0x1.9994843a305d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e56b8p+17,                0x1.8p+1,   0x1.b453e9809f1e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ac38p+17,                0x1.8p+1,   0x1.0862756017cecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f87c1caf2p+35,                0x1.8p+0,   0x1.f4c4c8a408c26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdff8p+17,                0x1.8p+1,     0x1.782ab556d6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3548p+17,                0x1.8p+1,   0x1.5eb4ad4702c5cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.903c55792p+35,                0x1.8p+0,   0x1.61ddac050fc82p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a73837402p+35,                0x1.8p+0,    0x1.80c7f26d7f48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5380bd3e2p+35,                0x1.8p+0,   0x1.14756bf9e3f24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0658p+17,                0x1.8p+1,   0x1.1369358fdb2bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.66035c762p+35,                0x1.8p+0,   0x1.2b5fa20667f0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf6e8p+17,                0x1.8p+1,   0x1.7badf23e8eec2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a458p+17,                0x1.8p+1,   0x1.076f740fbdb5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9af78p+17,                0x1.8p+1,   0x1.08c6ea8f9e768p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b5218312p+35,                0x1.8p+0,   0x1.0a8661d872892p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d708p+17,                0x1.8p+1,    0x1.0d95c6e65fe5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4c78p+17,                0x1.8p+1,   0x1.88f9b2d229cd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c47d8p+17,                0x1.8p+1,   0x1.616acf2251142p+53,          0x1p-1, INEXACT)
T(RN,           0x1.edfc8p+17,                0x1.8p+1,   0x1.cbd687bf3a954p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ebdac0de2p+35,                0x1.8p+0,   0x1.e214bb568611cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6278p+17,                0x1.8p+1,   0x1.e306f989664f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de9177802p+35,                0x1.8p+0,     0x1.ceae1aacbcdp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a8427c82p+35,                0x1.8p+0,    0x1.5a4ecf2aa9e5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ccc2b6222p+35,                0x1.8p+0,   0x1.b518e12c08d7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aebd8p+17,                0x1.8p+1,   0x1.30dd3ad0f5202p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ba98p+17,                0x1.8p+1,   0x1.0a1f8b16d7346p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8da8p+17,                0x1.8p+1,   0x1.6bbd6cc474b06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1408p+17,                0x1.8p+1,    0x1.59e23521ea3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8f0ff20a2p+35,                0x1.8p+0,   0x1.604f9590d0d6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c77464c52p+35,                0x1.8p+0,   0x1.ad919e03f0deap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a73dabc32p+35,                0x1.8p+0,   0x1.80cf62f6be0bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c6a8p+17,                0x1.8p+1,   0x1.0b96879d0ee36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d95d8p+17,                0x1.8p+1,   0x1.949f26b9bf6e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0268p+17,                0x1.8p+1,   0x1.d1e86d4a1cbaap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.44ef65d12p+35,                0x1.8p+0,   0x1.02db69dfd4caep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d998p+17,                0x1.8p+1,   0x1.0de602bf52f96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee988p+17,                0x1.8p+1,   0x1.cd8ab74900148p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.80b3e6982p+35,                0x1.8p+0,    0x1.4d7790ed53d7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca628p+17,                0x1.8p+1,   0x1.6f68e1599825ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4dc8p+17,                0x1.8p+1,   0x1.1c5d9b90983f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd1269312p+35,                0x1.8p+0,   0x1.b58a4ee53f692p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.510edb122p+35,                0x1.8p+0,   0x1.117a4f6faffe4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7cc73bf72p+35,                0x1.8p+0,   0x1.48609c0b53a96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2d48p+17,                0x1.8p+1,   0x1.1844a214df2dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7618p+17,                0x1.8p+1,   0x1.683bd6d290f2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f90f104a2p+35,                0x1.8p+0,   0x1.f59fa64f82eecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eae1ec722p+35,                0x1.8p+0,   0x1.e0a715a6f225cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee148p+17,                0x1.8p+1,   0x1.cc1990d5bf09cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4c28p+17,                0x1.8p+1,   0x1.88ed1fe6e347ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73d48f4b2p+35,                0x1.8p+0,   0x1.3cdeec06101aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5404b4e32p+35,                0x1.8p+0,   0x1.1516ace3b5d82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b6f0e782p+35,                0x1.8p+0,    0x1.0aa95507f99dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4678p+17,                0x1.8p+1,   0x1.8808766dba7b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.69d4f9272p+35,                0x1.8p+0,   0x1.302d20ccaf436p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3ab8p+17,                0x1.8p+1,   0x1.3b739fb8408a4p+53,          0x1p-1, INEXACT)
T(RN,          0x1.670948p+21,                0x1.4p+1,   0x1.a5ab0d0dbc9b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0898p+17,                0x1.8p+1,   0x1.583c32f85eae6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf44dd952p+35,                0x1.8p+0,   0x1.b8abe2632814ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db5b8p+17,                0x1.8p+1,   0x1.99c078c1622b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d42e8p+17,                0x1.8p+1,   0x1.8779695307f02p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c66e575a2p+35,                0x1.8p+0,   0x1.ac1f1673f47b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.feb934362p+35,                0x1.8p+0,   0x1.fe161c91b3b74p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7cf8p+17,                0x1.8p+1,    0x1.bace5f4a8c17p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba1ef83c2p+35,                0x1.8p+0,   0x1.9ad800dd011d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e04d8p+17,                0x1.8p+1,   0x1.a6ac798010932p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c25734392p+35,                0x1.8p+0,   0x1.a65aa7610c302p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4728p+17,                0x1.8p+1,   0x1.b1b5cda1a6b0ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f65eb3dd2p+35,                0x1.8p+0,   0x1.f19f7f488b5c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95c610fb2p+35,                0x1.8p+0,   0x1.693c61567bbb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.671784842p+35,                0x1.8p+0,   0x1.2cba47bc177d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd3d8p+17,                0x1.8p+1,   0x1.f7c3e76825182p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f80c8p+17,                0x1.8p+1,   0x1.e883d73eb8684p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7f68p+17,                0x1.8p+1,   0x1.22b2f4e81aa9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6708p+17,                0x1.8p+1,    0x1.4181834b7895p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9cd48672p+35,                0x1.8p+0,   0x1.844edc2b455b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9c68p+17,                0x1.8p+1,   0x1.95aca3ae1238ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cce98p+17,                0x1.8p+1,   0x1.75853ef7d0d06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6753d33e2p+35,                0x1.8p+0,   0x1.2d060d0e42324p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da258p+17,                0x1.8p+1,   0x1.96a0dd45855fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4948p+17,                0x1.8p+1,   0x1.b2112547e4c1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e37f8p+17,                0x1.8p+1,    0x1.af2a6e47c2a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1258p+17,                0x1.8p+1,   0x1.a8e7ba11fc2fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf308p+17,                0x1.8p+1,    0x1.7b15a3df8239p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6038p+13,                  0x1p+2,    0x1.caab6d825ecbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5ef8p+17,                0x1.8p+1,    0x1.40660da7d5bdp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddee8p+17,                0x1.8p+1,   0x1.a071dd6859642p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c26275622p+35,                0x1.8p+0,   0x1.a66a7ca4874fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5aa07a352p+35,                0x1.8p+0,   0x1.1d34af1582a0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6ab98c52p+35,                0x1.8p+0,   0x1.c3461df52e5eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae308p+17,                0x1.8p+1,    0x1.2fb239fd3809p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec4d8p+17,                0x1.8p+1,   0x1.c72702a538d32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dabb8p+17,                0x1.8p+1,   0x1.98234304242d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb6d8p+17,                0x1.8p+1,   0x1.71ec5e61bdb92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5a18p+17,                0x1.8p+1,   0x1.8b1ef0a5d0feep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c808p+17,                0x1.8p+1,    0x1.0bc15c88e558p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.acbe05552p+35,                0x1.8p+0,   0x1.885651cab5dcap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d63891c72p+35,                0x1.8p+0,   0x1.c2a0b9da1d2f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4ed8p+17,                0x1.8p+1,   0x1.62717edb51412p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a98d74bc2p+35,                0x1.8p+0,   0x1.83f7901d756d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd048p+17,                0x1.8p+1,   0x1.5031fc08c686cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.953d03c02p+35,                0x1.8p+0,    0x1.68856d656d68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f00a8p+17,                0x1.8p+1,   0x1.d199908036216p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c32961112p+35,                0x1.8p+0,   0x1.a782758f5a8d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ea0d9d22p+35,                0x1.8p+0,   0x1.0e86aa302f364p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2928p+17,                0x1.8p+1,   0x1.837377b07ee6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6198f8432p+35,                0x1.8p+0,   0x1.25da265292842p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6bc8p+17,                0x1.8p+1,   0x1.66b4d177b7f94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.767545762p+35,                0x1.8p+0,   0x1.403c5bca7c6f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1284e192p+35,                0x1.8p+0,   0x1.8e69c5b771942p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7f68p+17,                0x1.8p+1,   0x1.910947f4cba9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bee98p+17,                0x1.8p+1,   0x1.5481df560d306p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba988p+17,                0x1.8p+1,   0x1.4abc73e60e548p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd14d7ea2p+35,                0x1.8p+0,   0x1.cc868d7efc554p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6414fe8a2p+35,                0x1.8p+0,   0x1.28f46118f4f94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.871682cf2p+35,                0x1.8p+0,   0x1.55cdb956a07e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a47098242p+35,                0x1.8p+0,   0x1.7cff0f0236668p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe7f48602p+35,                0x1.8p+0,    0x1.fdbf590529dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ced0d84d2p+35,                0x1.8p+0,   0x1.b806620255ba6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.959ee6442p+35,                0x1.8p+0,   0x1.69081554915a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7cf3ec12p+35,                0x1.8p+0,   0x1.c4e9d0a275672p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.85673ac62p+35,                0x1.8p+0,   0x1.5398ef75ee42cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7128p+17,                0x1.8p+1,   0x1.b8cc760834feep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d738p+17,                0x1.8p+1,   0x1.0d9ba546af1fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dcaaaf0a2p+35,                0x1.8p+0,   0x1.cbecdf62ceb6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ec8b3d0b2p+35,                0x1.8p+0,   0x1.e3184a39951d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aaa58p+17,                0x1.8p+1,   0x1.284116a61bb7ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.83a3fec02p+35,                0x1.8p+0,    0x1.514b52d2ab88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6ef8p+17,                0x1.8p+1,    0x1.42993703c1edp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc7f8p+17,                0x1.8p+1,    0x1.7483c5a5be58p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb21f9b82p+35,                0x1.8p+0,    0x1.f8b76987492bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2bc8p+17,                0x1.8p+1,   0x1.ad21921e79394p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6d38p+17,                0x1.8p+1,   0x1.e4f7fc167341cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddc78p+17,                0x1.8p+1,   0x1.a00bf31c357d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8c28p+17,                0x1.8p+1,   0x1.46a32c91a007ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8be8p+17,                0x1.8p+1,   0x1.9307f518fbc32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a01ec992p+35,                0x1.8p+0,   0x1.44ccbbc2c1442p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8378p+17,                0x1.8p+1,   0x1.456e866b49728p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ead88p+17,                0x1.8p+1,   0x1.c31f82fb85e08p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4718p+13,                  0x1p+2,   0x1.552522e8c4b68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a00d8p+17,                0x1.8p+1,   0x1.12babd5e20672p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb068p+17,                0x1.8p+1,   0x1.4bb34a20b5d4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.501522b92p+35,                0x1.8p+0,   0x1.104a9bb9a61fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9378p+17,                0x1.8p+1,   0x1.2549366f8ca28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa68ed7b2p+35,                0x1.8p+0,   0x1.f7a342f053b4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c4a6cf3d2p+35,                0x1.8p+0,   0x1.a99bfb1020686p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c84e8p+17,                0x1.8p+1,   0x1.6a6f6d6239e62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bbdb8p+17,                0x1.8p+1,   0x1.4d929e4ec7c34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.738994e52p+35,                0x1.8p+0,   0x1.3c7f18e38f7aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b80e8p+17,                0x1.8p+1,   0x1.4513a147097a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c77beba2p+35,                0x1.8p+0,   0x1.1f7b18b49868cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0fe8p+17,                0x1.8p+1,   0x1.d449f6c626af2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a59f79112p+35,                0x1.8p+0,   0x1.7e9b0b55bf8d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf1b8p+17,                0x1.8p+1,   0x1.7ae216b2841f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7ae8p+17,                0x1.8p+1,   0x1.443f0fa835d82p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3678p+13,                  0x1p+2,    0x1.14e631218cd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9eb98p+17,                0x1.8p+1,   0x1.101b5b7cb81f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b34b8p+17,                0x1.8p+1,   0x1.3aa34613bed84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fbc73cb32p+35,                0x1.8p+0,   0x1.f9ae33bbad8dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d7a8p+17,                0x1.8p+1,   0x1.0da95726dd1e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd0d8p+17,                0x1.8p+1,   0x1.75dccb9547572p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad7e46082p+35,                0x1.8p+0,    0x1.895e53d4af8dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac178p+17,                0x1.8p+1,   0x1.2b46767e84ec8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.500b69e22p+35,                0x1.8p+0,   0x1.103ecb272d804p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9008p+17,                0x1.8p+1,     0x1.93b0d9fab8bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9cb766a82p+35,                0x1.8p+0,    0x1.728be26528d1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d446c0a52p+35,                0x1.8p+0,   0x1.bfd5daffdac2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb1d8p+17,                0x1.8p+1,   0x1.f17c2d75d9a22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ce2bf842p+35,                0x1.8p+0,   0x1.5d6eb61e9f9d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5f88p+17,                0x1.8p+1,   0x1.1e9ecd4b0ab68p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.465248p+21,                0x1.4p+1,   0x1.4c13bf733076ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.edc78p+17,                0x1.8p+1,   0x1.cb429569d87d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8cb8p+17,                0x1.8p+1,   0x1.46b72f4f20604p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6f08p+17,                0x1.8p+1,    0x1.e54be9f466adp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bec78p+17,                0x1.8p+1,   0x1.54342e3969ad8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1878p+17,                0x1.8p+1,   0x1.5a864cb6bbb18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9d48p+17,                0x1.8p+1,   0x1.4905d21b807dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9a88p+17,                0x1.8p+1,   0x1.2633465e4da78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9998p+17,                0x1.8p+1,   0x1.bfb2308e9b396p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa368p+17,                0x1.8p+1,   0x1.275a186320f5ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd538p+17,                0x1.8p+1,   0x1.f8053492f0f9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9378p+17,                0x1.8p+1,   0x1.2549366f8ca28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fed92a7e2p+35,                0x1.8p+0,   0x1.fe45ff6e222a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b3a8p+17,                0x1.8p+1,   0x1.09487faa60126p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4df0b3c12p+35,                0x1.8p+0,   0x1.0db12ab7b1c72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc3fd5c82p+35,                0x1.8p+0,    0x1.b45eb2e8e0a5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7b98p+17,                0x1.8p+1,   0x1.ba9278c8914f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6bf175f22p+35,                0x1.8p+0,   0x1.32d7aaea93ca4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d25137b2p+35,                0x1.8p+0,   0x1.2051b1b00d0b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6ce8p+17,                0x1.8p+1,   0x1.2053bd68e75e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c42335f62p+35,                0x1.8p+0,   0x1.a8e26da2b6e0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1008p+17,                0x1.8p+1,     0x1.a885bb28ba3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64e097772p+35,                0x1.8p+0,   0x1.29f334dc9bc6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8d78p+17,                0x1.8p+1,   0x1.2482bea5acd08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fead381d2p+35,                0x1.8p+0,   0x1.fe042844cc5bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5169c0b62p+35,                0x1.8p+0,   0x1.11e8f738e918cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd1c8p+17,                0x1.8p+1,   0x1.76014a357a0b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b84a8p+17,                0x1.8p+1,   0x1.4598ab6c324d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8cafb0722p+35,                0x1.8p+0,   0x1.5d2b49eda85a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e204c6842p+35,                0x1.8p+0,   0x1.d3b162aebc3d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.962d5c1c2p+35,                0x1.8p+0,   0x1.69c6593325e98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2b28p+17,                0x1.8p+1,   0x1.ad06e77e2d7cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9ff608d2p+35,                0x1.8p+0,   0x1.9aabf85a177dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4598p+17,                0x1.8p+1,   0x1.3cee2c7c93dd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ecfb13852p+35,                0x1.8p+0,   0x1.e3bcdd672ec6ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.705cf3442p+35,                0x1.8p+0,   0x1.3872f35e31858p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aefd72e02p+35,                0x1.8p+0,    0x1.8b6d3484be14p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ee3f18c22p+35,                0x1.8p+0,   0x1.e59a16bd84cc4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ba23e702p+35,                0x1.8p+0,    0x1.46e5e38c3c2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fd2009382p+35,                0x1.8p+0,    0x1.fbb19ae97d5bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6ea616ef2p+35,                0x1.8p+0,   0x1.36453b70d785ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5dd0ec172p+35,                0x1.8p+0,   0x1.2126a8a1c65aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d6986bf62p+35,                0x1.8p+0,   0x1.c32a8a770b5f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a973ee352p+35,                0x1.8p+0,   0x1.83d4a88ee7df6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f71b8p+17,                0x1.8p+1,   0x1.e5c86e21239f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3b650f92p+35,                0x1.8p+0,   0x1.91f16deb0d27ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a91e8p+17,                0x1.8p+1,   0x1.25157e9b40e52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a47a3082p+35,                0x1.8p+0,    0x1.1cc7105d2f53p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.845910142p+35,                0x1.8p+0,   0x1.5237c1eb0af38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c43d8p+17,                0x1.8p+1,   0x1.60d4ee3369e82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.58f035e02p+35,                0x1.8p+0,    0x1.1b1fd3fc88ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e88d58762p+35,                0x1.8p+0,   0x1.dd3be8303d70cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.873eb7d92p+35,                0x1.8p+0,   0x1.56027094ce63ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e7118472p+35,                0x1.8p+0,   0x1.5f7d4e0bfc5f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab488p+17,                0x1.8p+1,   0x1.2995258c46358p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a84751d22p+35,                0x1.8p+0,   0x1.8239e65345c9cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b156df52p+35,                0x1.8p+0,   0x1.70598b6b26e8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e35cb1b2p+35,                0x1.8p+0,   0x1.21a3c2d494c0ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ccadd79d2p+35,                0x1.8p+0,   0x1.b4fb2f4b78146p+53,          0x1p-1, INEXACT)
T(RN,       0x1.71fb54a62p+35,                0x1.8p+0,   0x1.3a82c05de4d14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4df8p+17,                0x1.8p+1,    0x1.8936115dce6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8818p+17,                0x1.8p+1,   0x1.bcb3cc388058ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d928p+17,                0x1.8p+1,   0x1.0dd84ed15a76ep+53,         -0x1p-1, INEXACT)
T(RN,            0x1.54f8p+13,                  0x1p+2,    0x1.92d14d0e556cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2e58p+17,                0x1.8p+1,   0x1.ad8ef2d6c3e3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c54e3c632p+35,                0x1.8p+0,   0x1.aa8833b39037ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aabf8p+17,                0x1.8p+1,    0x1.2877434dfa04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ca9d23eb2p+35,                0x1.8p+0,   0x1.b20bc56acb46ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0f68p+17,                0x1.8p+1,   0x1.359ba27f5bd9ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9c1e6b12p+35,                0x1.8p+0,   0x1.f6aa2c673e392p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e88970312p+35,                0x1.8p+0,   0x1.dd362e8e1076ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.73f4f21f2p+35,                0x1.8p+0,   0x1.3d0852fd80ebap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9db8p+17,                0x1.8p+1,   0x1.491575c379634p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc1f99f12p+35,                0x1.8p+0,   0x1.b430dc2812912p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7266784a2p+35,                0x1.8p+0,   0x1.3b0b676a7e114p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8f903452p+35,                0x1.8p+0,   0x1.c696d78b56716p+53,          0x1p-1, INEXACT)
T(RN,       0x1.901c81d62p+35,                0x1.8p+0,   0x1.61b37755b7f34p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.984p+10,                0x1.4p+2,    0x1.4a0d119dec3fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3a98p+17,                0x1.8p+1,   0x1.af9ad4c120b46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b188p+17,                0x1.8p+1,   0x1.0906b846316c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7629cf72p+35,                0x1.8p+0,   0x1.db867367cf896p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9d454e012p+35,                0x1.8p+0,   0x1.734b0e21083f2p+53,         -0x1p-1, INEXACT)
T(RN,     0x1.599d45b3784p+42,                0x1.4p+0,   0x1.076dffc06b07cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3bbd9f22p+35,                0x1.8p+0,   0x1.91f916abedb5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3f48p+17,                0x1.8p+1,   0x1.86e7fd7b5243cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0e617172p+35,                0x1.8p+0,   0x1.8e0e6e32dc456p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3d78p+17,                0x1.8p+1,   0x1.5fe66755cbe08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aedf8p+17,                0x1.8p+1,    0x1.312571c1374ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e78a1cf2p+35,                0x1.8p+0,   0x1.4a91dda3ff61ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dff68p+17,                0x1.8p+1,   0x1.a5c6f3fee929ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc648p+17,                0x1.8p+1,   0x1.4ec7decc1688cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4868p+17,                0x1.8p+1,   0x1.3d50444abfdcap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dad88p+17,                0x1.8p+1,   0x1.986e134e62e08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97568p+17,                0x1.8p+1,   0x1.01d31f0b0cdbap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5c58p+17,                0x1.8p+1,   0x1.8b79d514039dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.55708a962p+35,                0x1.8p+0,   0x1.16d3e2a846fb4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f3ac3a2e2p+35,                0x1.8p+0,   0x1.ed9ef2ecbb7c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0b08p+17,                0x1.8p+1,    0x1.13fe21e3c781p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8878p+17,                0x1.8p+1,   0x1.4620126500018p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9eb88p+17,                0x1.8p+1,   0x1.101963988eda8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8010e062p+35,                0x1.8p+0,   0x1.f40d99e83b354p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c082c0e22p+35,                0x1.8p+0,   0x1.a3c850dbd41fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffc78p+17,                0x1.8p+1,   0x1.ff5692b3afdd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb03379f2p+35,                0x1.8p+0,   0x1.e0d7fcd07b9bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6d28p+17,                0x1.8p+1,   0x1.42594a4a21d2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a1f14702p+35,                0x1.8p+0,    0x1.091442518396p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9588p+17,                0x1.8p+1,   0x1.ec4ba1bac5988p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dda1d14a2p+35,                0x1.8p+0,   0x1.cd52bc0eee4ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.459396442p+35,                0x1.8p+0,   0x1.039fb5e450a58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.42f581362p+35,                0x1.8p+0,   0x1.007fcf5bee68cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c21c3d02p+35,                0x1.8p+0,    0x1.0b811eddbfd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3d38p+17,                0x1.8p+1,   0x1.dc570a8e6bb1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.74f9f0812p+35,                0x1.8p+0,   0x1.3e563c0ac16f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca9d23eb2p+35,                0x1.8p+0,   0x1.b20bc56acb46ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8978p+17,                0x1.8p+1,   0x1.92a43e2fec448p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8f68p+17,                0x1.8p+1,   0x1.24c2cb873e59ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8e38p+17,                0x1.8p+1,   0x1.93669e261b14cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef3cb60e2p+35,                0x1.8p+0,   0x1.e7100b43d5d04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99a65f152p+35,                0x1.8p+0,   0x1.6e6c9fb1309b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3ab8p+17,                0x1.8p+1,   0x1.3b739fb8408a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.934d2ebd2p+35,                0x1.8p+0,   0x1.65f08a9914d86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a646828f2p+35,                0x1.8p+0,   0x1.7f7e805115866p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cc7bb872p+35,                0x1.8p+0,   0x1.33e6cdce53f76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.690b535b2p+35,                0x1.8p+0,   0x1.2f2efdf51538ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5b086562p+35,                0x1.8p+0,   0x1.c1dd379e87dccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1d8f9892p+35,                0x1.8p+0,   0x1.8f5d9e11e7362p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f3e18p+17,                0x1.8p+1,   0x1.dc7f1274900aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6508p+17,                0x1.8p+1,    0x1.8cd949e27d8fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.848121002p+35,                0x1.8p+0,     0x1.526c1a9ed3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce828p+17,                0x1.8p+1,   0x1.796b0ce2affbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.823c17892p+35,                0x1.8p+0,   0x1.4f7602be1289ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.afb159532p+35,                0x1.8p+0,   0x1.8c64e3b29339ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3cd8p+17,                0x1.8p+1,   0x1.5fcf0a9298fb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b06ae8dc2p+35,                0x1.8p+0,   0x1.8d64940d31a18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ca14b022p+35,                0x1.8p+0,   0x1.482f88cea5cbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dee28p+17,                0x1.8p+1,   0x1.a2f0f6e7043dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb7b8p+17,                0x1.8p+1,   0x1.720e30bcea914p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83787e6c2p+35,                0x1.8p+0,   0x1.51128d7c882b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d32432e92p+35,                0x1.8p+0,   0x1.be354d66182a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5118p+17,                0x1.8p+1,   0x1.89b3ea30f0abep+53,          0x1p-1, INEXACT)
T(RN,       0x1.460674c82p+35,                0x1.8p+0,    0x1.04292861eefbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7598p+17,                0x1.8p+1,   0x1.438326ce1aed6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a75d8p+17,                0x1.8p+1,   0x1.2178ad59250e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fcc08p+17,                0x1.8p+1,    0x1.f6514a8f5564p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b7a8p+17,                0x1.8p+1,   0x1.09c46edcefbe6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef1d8p+17,                0x1.8p+1,   0x1.ceff712841622p+53,          0x1p-1, INEXACT)
T(RN,               0x1.cdp+8,                0x1.8p+2,   0x1.10cea1565b39cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9da9f3cd2p+35,                0x1.8p+0,   0x1.73d2b9617e55ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc408p+17,                0x1.8p+1,    0x1.4e7688ea994cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f99855e2p+35,                0x1.8p+0,   0x1.4c08abfcc81e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bb576a482p+35,                0x1.8p+0,    0x1.9c8bd11872f5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d09f5ce62p+35,                0x1.8p+0,   0x1.ba9aa388d7294p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9a28p+17,                0x1.8p+1,   0x1.6d9bf40ab4a1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95e456312p+35,                0x1.8p+0,   0x1.6964ce131cc92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1b68p+17,                0x1.8p+1,   0x1.d652d593c89dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d4da4c52p+35,                0x1.8p+0,   0x1.0cebbb06f7216p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2748p+17,                0x1.8p+1,   0x1.5cab82e8a27bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2508p+17,                0x1.8p+1,    0x1.3884380b06cfp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.708ac2562p+35,                0x1.8p+0,   0x1.38ad3db2455ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc46bd532p+35,                0x1.8p+0,   0x1.fa6cb65a0eb9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a92ea97e2p+35,                0x1.8p+0,   0x1.8375f5751f35cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee1d8p+17,                0x1.8p+1,   0x1.cc32b5ec14b22p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fcca8p+17,                0x1.8p+1,   0x1.f66eea0282656p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1df8p+17,                0x1.8p+1,    0x1.1659eabbdcdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc848p+17,                0x1.8p+1,   0x1.748fe81aa9eecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b87030b2p+35,                0x1.8p+0,   0x1.1e516542a622ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c84b8p+17,                0x1.8p+1,   0x1.6a684768d1c84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b145bd812p+35,                0x1.8p+0,   0x1.8e9262dffacf2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0cb8p+17,                0x1.8p+1,   0x1.1433cbc753e04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3e68p+17,                0x1.8p+1,   0x1.b03e3707f88eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c3a552702p+35,                0x1.8p+0,    0x1.a831068683aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f42c8p+17,                0x1.8p+1,   0x1.dd55ac1b17ce4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7780475c2p+35,                0x1.8p+0,   0x1.41931cfc9ace8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84bc5f312p+35,                0x1.8p+0,   0x1.52b9863f0556ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8ef48822p+35,                0x1.8p+0,   0x1.f5704e635b5bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c99bda372p+35,                0x1.8p+0,   0x1.b09eb6ba55e16p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.54fafcb22p+35,                0x1.8p+0,   0x1.1643effa73fdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9648p+17,                0x1.8p+1,   0x1.25a65d753df8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9253a982p+35,                0x1.8p+0,    0x1.c6d69814fba9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50662c862p+35,                0x1.8p+0,   0x1.10ad1dc984dacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c14e8p+17,                0x1.8p+1,   0x1.5a028c36ba162p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60d34a952p+35,                0x1.8p+0,   0x1.24e3de177b74ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74e729ce2p+35,                0x1.8p+0,   0x1.3e3e3289a907cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.bbee36602p+35,                0x1.8p+0,    0x1.9d5e5edd4f64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0348p+17,                0x1.8p+1,   0x1.33fc2e00ee4fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7e86761b2p+35,                0x1.8p+0,   0x1.4aa3cb9e8e9f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a50372442p+35,                0x1.8p+0,   0x1.7dc6bd4aab258p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a39b8p+17,                0x1.8p+1,   0x1.19d4de722b774p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8aaac84f2p+35,                0x1.8p+0,   0x1.5a81acb11e31ap+53,          0x1p-1, INEXACT)
T(RN,             0x1.aa4p+10,                0x1.4p+2,   0x1.998465086c1e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbd1e1172p+35,                0x1.8p+0,   0x1.b3c25be6acfaap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d77cb41e2p+35,                0x1.8p+0,   0x1.c472fb514399cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f7c17fa2p+35,                0x1.8p+0,   0x1.4be277a9345f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fdc79e162p+35,                0x1.8p+0,   0x1.fcac59ea8834cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7fa8p+17,                0x1.8p+1,   0x1.bb4382e33f566p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6adecfa42p+35,                0x1.8p+0,   0x1.317c95fd9b698p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4538p+17,                0x1.8p+1,   0x1.ddc55d217a49cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7cf4155a2p+35,                0x1.8p+0,   0x1.489aa1cffcc4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6c486ce2p+35,                0x1.8p+0,   0x1.c369f8fa6127cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.90d4768a2p+35,                0x1.8p+0,   0x1.62a780bf4006cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5d38p+17,                0x1.8p+1,   0x1.648e88b80d11cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c3964b8c2p+35,                0x1.8p+0,   0x1.a81bdb20d0008p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5294c05a2p+35,                0x1.8p+0,   0x1.13555e5e9a1b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9dc28p+17,                0x1.8p+1,   0x1.0e364e821177ep+53,         -0x1p-1, INEXACT)
T(RN,          0x1.50c848p+21,                0x1.4p+1,   0x1.6755837dd63c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd038p+17,                0x1.8p+1,   0x1.9e0cbe60be7acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.52c3ec5c2p+35,                0x1.8p+0,   0x1.138eeaa73aae8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b7fb5f502p+35,                0x1.8p+0,    0x1.97dda3c9ce7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bcaa623f2p+35,                0x1.8p+0,   0x1.9e654e02816fap+53,          0x1p-1, INEXACT)
T(RN,       0x1.80b3e6982p+35,                0x1.8p+0,    0x1.4d7790ed53d7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f52fc5c82p+35,                0x1.8p+0,    0x1.efdda932595bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d39e8p+17,                0x1.8p+1,   0x1.86109fe46c9d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e61ee6fa2p+35,                0x1.8p+0,   0x1.d9ad01f3de40cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9de58p+17,                0x1.8p+1,   0x1.0e7ae6b42e73ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8cf0d5e82p+35,                0x1.8p+0,    0x1.5d8151141fe7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1228p+17,                0x1.8p+1,   0x1.14e0e5a022c9ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f3198p+17,                0x1.8p+1,   0x1.da440896cc416p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b21f97b2p+35,                0x1.8p+0,   0x1.706a680e05cb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d71ad7902p+35,                0x1.8p+0,    0x1.c3e6252ce596p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da838p+17,                0x1.8p+1,   0x1.9792e5246f82cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff75096f2p+35,                0x1.8p+0,   0x1.ff2f9c4c182a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aced9c502p+35,                0x1.8p+0,    0x1.8897a65d7d5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff3f12302p+35,                0x1.8p+0,    0x1.fedeb68cf26ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.84ed2c632p+35,                0x1.8p+0,   0x1.52f951276dc82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a69be4dd2p+35,                0x1.8p+0,   0x1.7ff2d67da07c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.98d8bdd52p+35,                0x1.8p+0,   0x1.6d58dc60994cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fbdf8p+17,                0x1.8p+1,    0x1.f3b7fa9dddbap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c3bab342p+35,                0x1.8p+0,   0x1.333588bbb0208p+53,          0x1p-1, INEXACT)
T(RN,       0x1.858a1dd42p+35,                0x1.8p+0,   0x1.53c6939a1b648p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f56f19d82p+35,                0x1.8p+0,    0x1.f03ba8174061p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f83b8p+17,                0x1.8p+1,   0x1.e90c8b9434354p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bb39a3d02p+35,                0x1.8p+0,    0x1.9c62424bcbd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca4f8p+17,                0x1.8p+1,    0x1.6f3b334ce88fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab288p+17,                0x1.8p+1,   0x1.29524e878aef8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5a28p+17,                0x1.8p+1,   0x1.8b2176ce0ce1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b8fafa92p+35,                0x1.8p+0,   0x1.325c0c790f2dep+53,          0x1p-1, INEXACT)
T(RN,            0x1.4cf8p+13,                  0x1p+2,    0x1.6e52a668098cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5008p+17,                0x1.8p+1,     0x1.b3339fd1bafp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b061cb52p+35,                0x1.8p+0,   0x1.5af9faa3bd2f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.df1ea90d2p+35,                0x1.8p+0,   0x1.cf7aec16f5126p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c05c8p+17,                0x1.8p+1,   0x1.57d4a1e118e74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f52dcb382p+35,                0x1.8p+0,    0x1.efdab96c2c9bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3ab8p+17,                0x1.8p+1,   0x1.863128f5a68a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d19ce4612p+35,                0x1.8p+0,   0x1.bc051a7ec9ecep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd888p+17,                0x1.8p+1,   0x1.7708533b88218p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49e210952p+35,                0x1.8p+0,   0x1.08cac830ff4b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e1beecda2p+35,                0x1.8p+0,   0x1.d34bbd0ae814cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eee62db02p+35,                0x1.8p+0,    0x1.e69068c4a3e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6188598e2p+35,                0x1.8p+0,   0x1.25c56ed8ad5fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a18d8p+17,                0x1.8p+1,   0x1.15b62da9b56f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9dd8p+17,                0x1.8p+1,   0x1.c06cd4c100c62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c44e8p+17,                0x1.8p+1,   0x1.60fcb9d003262p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ecb94b42p+35,                0x1.8p+0,   0x1.75597dc9ab908p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1ab8p+17,                0x1.8p+1,   0x1.8135193c502a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b592d51e2p+35,                0x1.8p+0,   0x1.948582949639cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa568p+17,                0x1.8p+1,   0x1.279ca3c42aebap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7bcb949c2p+35,                0x1.8p+0,   0x1.471b49450c468p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99406ce02p+35,                0x1.8p+0,    0x1.6de3dfa6fbd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9c3e3902p+35,                0x1.8p+0,    0x1.f6ad230b95eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4068p+17,                0x1.8p+1,   0x1.1aacaf61fd04ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf588p+17,                0x1.8p+1,   0x1.7b77e24909b88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0278p+17,                0x1.8p+1,   0x1.12ee41edca2f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e14a8p+17,                0x1.8p+1,   0x1.a949c80ec07d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8318p+17,                0x1.8p+1,   0x1.232c62ec21f1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b43a8p+17,                0x1.8p+1,   0x1.3caaa50227426p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62214f982p+35,                0x1.8p+0,    0x1.26842b91c877p+53,          0x1p-1, INEXACT)
T(RN,       0x1.56d9dc952p+35,                0x1.8p+0,   0x1.188eefbffccb6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba548p+17,                0x1.8p+1,   0x1.4a241a29de15cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60285db02p+35,                0x1.8p+0,    0x1.240f22290a1ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b4d4793e2p+35,                0x1.8p+0,   0x1.937da6ea46724p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5df01212p+35,                0x1.8p+0,   0x1.7ef1890db244ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fda78p+17,                0x1.8p+1,   0x1.f8febdaa56b78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6178p+17,                0x1.8p+1,   0x1.1eddfd554fcc8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3178p+17,                0x1.8p+1,   0x1.da3e550a043c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0188p+17,                0x1.8p+1,   0x1.d1c0fdc84b5c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7747c3f42p+35,                0x1.8p+0,   0x1.414a872594588p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fcd08p+17,                0x1.8p+1,    0x1.f680b0a382c7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe4161902p+35,                0x1.8p+0,    0x1.fd62a485c956p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bea68p+17,                0x1.8p+1,   0x1.53e8d1642032ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.92af43882p+35,                0x1.8p+0,    0x1.651e6307a183p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64fcfad52p+35,                0x1.8p+0,   0x1.2a16c2a5a2acap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b89729c22p+35,                0x1.8p+0,   0x1.98b657d86893cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b1c8p+17,                0x1.8p+1,   0x1.090e74d07eab4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6348p+17,                0x1.8p+1,   0x1.1f192229ae6fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9158p+17,                0x1.8p+1,   0x1.eb87ec820ee4ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2778p+17,                0x1.8p+1,   0x1.178a18ccbcde8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2e88p+17,                0x1.8p+1,   0x1.d9b866c4aae38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1c78p+17,                0x1.8p+1,   0x1.817a99c3fb3d8p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5d78p+13,                  0x1p+2,    0x1.bc8312c5d93ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4d18p+13,                  0x1p+2,   0x1.6edf8d24d13e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da6b8p+17,                0x1.8p+1,   0x1.9755107b140e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6348p+17,                0x1.8p+1,   0x1.65735abc146fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb028p+17,                0x1.8p+1,   0x1.70ea23db4793ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f2e2c7052p+35,                0x1.8p+0,   0x1.ec748d32e5d6ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f21f67862p+35,                0x1.8p+0,   0x1.eb536152bfbacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6308p+17,                0x1.8p+1,    0x1.6569e9369c89p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbc58p+17,                0x1.8p+1,   0x1.72c1189540bdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.971b8p+17,                0x1.8p+1,   0x1.01632704719f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0b18e3b2p+35,                0x1.8p+0,   0x1.a40a077097e32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96fc8p+17,                0x1.8p+1,   0x1.01285f41fb454p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.598f84502p+35,                0x1.8p+0,    0x1.1be40dc6f45ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7948p+17,                0x1.8p+1,   0x1.ba2dc71d1651cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e55e8p+17,                0x1.8p+1,   0x1.b430dc2812912p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bce071232p+35,                0x1.8p+0,   0x1.9eb0e18deb1fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73d7f7f22p+35,                0x1.8p+0,   0x1.3ce34788daf5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efc08p+17,                0x1.8p+1,    0x1.d0c94f4262f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c63c8p+17,                0x1.8p+1,   0x1.65863e46c3614p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.efe7e5962p+35,                0x1.8p+0,   0x1.e80cab573fe4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6ea103232p+35,                0x1.8p+0,   0x1.363ec990dcdfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.463657792p+35,                0x1.8p+0,   0x1.04627bb9d5882p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50c917a02p+35,                0x1.8p+0,    0x1.11256bfb83dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2358p+17,                0x1.8p+1,   0x1.3849f2d063eaap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d32432e92p+35,                0x1.8p+0,   0x1.be354d66182a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6438p+17,                0x1.8p+1,   0x1.8cb862596a76cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.449c914b2p+35,                0x1.8p+0,   0x1.0278758d74252p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e47d8p+17,                0x1.8p+1,   0x1.b1d35986e7142p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d13d8c782p+35,                0x1.8p+0,    0x1.bb7cbf7f7f23p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9a48p+17,                0x1.8p+1,   0x1.262afb2f89c4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c5a6b3692p+35,                0x1.8p+0,   0x1.ab0515ed6265ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb6ef6562p+35,                0x1.8p+0,   0x1.e1764ab612234p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.69ff02c62p+35,                0x1.8p+0,   0x1.306224935b42cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6f58p+17,                0x1.8p+1,   0x1.b87dbea36baeap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2b78p+17,                0x1.8p+1,   0x1.5d472f06326a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.afa47e7a2p+35,                0x1.8p+0,   0x1.8c532f2fe66f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ae8a1cb2p+35,                0x1.8p+0,   0x1.701d570f87352p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98b08p+17,                0x1.8p+1,    0x1.04664e61a601p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4d455782p+35,                0x1.8p+0,    0x1.c0a1045e603dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5428p+17,                0x1.8p+1,   0x1.633931dcfa9fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f5e5e23e2p+35,                0x1.8p+0,   0x1.f0ec060726d24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7fc8p+17,                0x1.8p+1,   0x1.69ac2be85d754p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f5e1ebf2p+35,                0x1.8p+0,   0x1.2313ad9b06ffap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5968p+17,                0x1.8p+1,   0x1.8b032da0da67ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8706c7a92p+35,                0x1.8p+0,   0x1.55b91a10ea2dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.be10865f2p+35,                0x1.8p+0,   0x1.a05a5717da73ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca9d8p+17,                0x1.8p+1,   0x1.6ff6d2985a4a2p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4018p+13,                  0x1p+2,   0x1.38ddca8c87028p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6818p+17,                0x1.8p+1,   0x1.8d55607ca1f8ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff358p+17,                0x1.8p+1,   0x1.fda17025b2daap+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb8386e02p+35,                0x1.8p+0,    0x1.f94911c94594p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb248p+17,                0x1.8p+1,   0x1.c3f12fe4f88ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b1903842p+35,                0x1.8p+0,   0x1.705e5cb0d11d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a14e8p+17,                0x1.8p+1,   0x1.15388cbd04162p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9fe8p+17,                0x1.8p+1,   0x1.6e78a03284df2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb8f8p+17,                0x1.8p+1,    0x1.4ce7624394cbp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e60b8p+17,                0x1.8p+1,   0x1.b603ec82ce9c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c5859142p+35,                0x1.8p+0,   0x1.3359d21ae4538p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.82d503ad2p+35,                0x1.8p+0,   0x1.503d5125c9c66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc708p+17,                0x1.8p+1,    0x1.f56478df7db5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.484c65062p+35,                0x1.8p+0,   0x1.06e2ee6036d54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe128p+17,                0x1.8p+1,   0x1.fa3d1136e4ceep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e80694312p+35,                0x1.8p+0,   0x1.dc767e49c7092p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce1a5ebd2p+35,                0x1.8p+0,   0x1.b7023fdc8ad86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0c607782p+35,                0x1.8p+0,    0x1.780612beaafdp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa738p+17,                0x1.8p+1,   0x1.27d8fab5a28fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a299e4ce2p+35,                0x1.8p+0,   0x1.7a7ff2268fe7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c81c8p+17,                0x1.8p+1,   0x1.69f85615341b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a14c8p+17,                0x1.8p+1,   0x1.15349060a8644p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d33d3ad2p+35,                0x1.8p+0,   0x1.0ccc7cf553c66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6051d67c2p+35,                0x1.8p+0,   0x1.2442bb1c54ba8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff378p+17,                0x1.8p+1,   0x1.fda76b6da0c28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a02cb4ba2p+35,                0x1.8p+0,   0x1.7736a64d79574p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c36396232p+35,                0x1.8p+0,   0x1.a7d46ddcbf802p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1838p+17,                0x1.8p+1,   0x1.15a23a38e3d2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e28e97f82p+35,                0x1.8p+0,    0x1.d47a065574d3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf738p+17,                0x1.8p+1,   0x1.55bdaf2a7f7fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.abb48p+17,                0x1.8p+1,   0x1.2a77052feff7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f23c8p+17,                0x1.8p+1,   0x1.d7cf1c9a97a14p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d778dd792p+35,                0x1.8p+0,   0x1.c46d74e0e937ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dea2dead2p+35,                0x1.8p+0,   0x1.cec757ce02266p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5b78p+17,                0x1.8p+1,   0x1.b520faa50afa8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5258p+17,                0x1.8p+1,   0x1.3eab7ec3b5efap+53,          0x1p-1, INEXACT)
T(RN,       0x1.932b759d2p+35,                0x1.8p+0,   0x1.65c3a661f22bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1498p+17,                0x1.8p+1,   0x1.364dd369b0726p+53,          0x1p-1, INEXACT)
T(RN,       0x1.49466a6c2p+35,                0x1.8p+0,   0x1.080f7671c8548p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.85fd49652p+35,                0x1.8p+0,   0x1.545d4e4804956p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9e18p+17,                0x1.8p+1,   0x1.6e330750992aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dd906eca2p+35,                0x1.8p+0,   0x1.cd398c7bbe214p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a47709e2p+35,                0x1.8p+0,   0x1.6f44d0e41069cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.45787a042p+35,                0x1.8p+0,   0x1.037f490a83728p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cccd8p+17,                0x1.8p+1,   0x1.75413062f72b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6576c812p+35,                0x1.8p+0,   0x1.d9ffa1016a10ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f21391832p+35,                0x1.8p+0,   0x1.eb41de6d5f2c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8df8p+17,                0x1.8p+1,    0x1.24934534a62ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f414f7012p+35,                0x1.8p+0,   0x1.ee3a2f2bd5e0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.af32ab532p+35,                0x1.8p+0,   0x1.8bb6751b43062p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51d8312c2p+35,                0x1.8p+0,   0x1.126f7d5b7fa38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4406f0d82p+35,                0x1.8p+0,    0x1.01c5d487b2ffp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a838c14e2p+35,                0x1.8p+0,   0x1.82260352d3484p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1878p+17,                0x1.8p+1,   0x1.15aa351575b18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5948p+17,                0x1.8p+1,   0x1.3f9e7c49c6f1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99fa8p+17,                0x1.8p+1,   0x1.06df157fd5b66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8378p+17,                0x1.8p+1,   0x1.e900e82cd5728p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6108p+17,                0x1.8p+1,    0x1.e2c49d65ea83p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2138p+17,                0x1.8p+1,   0x1.5bca748fd59dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fcad8p+17,                0x1.8p+1,   0x1.f619053689952p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc2cdf9f2p+35,                0x1.8p+0,   0x1.b443bbb9909bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c6c98422p+35,                0x1.8p+0,   0x1.337371075f83cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8fb8p+17,                0x1.8p+1,   0x1.24cd210fd6994p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea628p+17,                0x1.8p+1,   0x1.c1da77172e25ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3cb8p+17,                0x1.8p+1,   0x1.aff5e0adb9704p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f26a8p+17,                0x1.8p+1,   0x1.d851d6d046036p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b85a8p+17,                0x1.8p+1,   0x1.45bc2bb892586p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2568p+17,                0x1.8p+1,   0x1.ac11c65bb96bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e2774b862p+35,                0x1.8p+0,   0x1.d4581920763acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c47a4a02p+35,                0x1.8p+0,    0x1.47bb9d5268bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1d19c572p+35,                0x1.8p+0,   0x1.8f537312259d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f6667872p+35,                0x1.8p+0,   0x1.231df8fbfe776p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aebb8p+17,                0x1.8p+1,   0x1.30d8fbb447ed4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a48c8p+17,                0x1.8p+1,   0x1.1bbb90e257404p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9368p+17,                0x1.8p+1,   0x1.254724b9cd45ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2d88p+17,                0x1.8p+1,   0x1.d98ad49a17608p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.93d25aa22p+35,                0x1.8p+0,   0x1.66a1e3463607cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7b9a10c2p+35,                0x1.8p+0,   0x1.f3a35137db108p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9ec8p+17,                0x1.8p+1,   0x1.edfca92529a24p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5278p+13,                  0x1p+2,    0x1.872209e47966p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6af8p+17,                0x1.8p+1,    0x1.420c2f0218e1p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3d88p+13,                  0x1p+2,    0x1.2ef7ac20e7a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ee905f52p+35,                0x1.8p+0,   0x1.4b239dfc2be8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b52e8p+17,                0x1.8p+1,   0x1.3ebf2ddc87a02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aac28p+17,                0x1.8p+1,   0x1.287d83f57e67ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3c98p+17,                0x1.8p+1,   0x1.867c44c9dfaa6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c66a8p+17,                0x1.8p+1,   0x1.65f2e78e2fc36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b798p+17,                0x1.8p+1,   0x1.09c27ed437236p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d15a8p+17,                0x1.8p+1,   0x1.806c390851886p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd648p+17,                0x1.8p+1,   0x1.510bbdea0db8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a23e8p+17,                0x1.8p+1,   0x1.1717ed9c0fcb2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3a02d6f2p+35,                0x1.8p+0,   0x1.91d2cbe09c55ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f77e1f6f2p+35,                0x1.8p+0,   0x1.f34acad17d6a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7326cabe2p+35,                0x1.8p+0,   0x1.3c00e5ebae824p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ebefae82p+35,                0x1.8p+0,    0x1.75487ab239c7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb908p+17,                0x1.8p+1,    0x1.f2ceed07658bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8558p+17,                0x1.8p+1,   0x1.91fba44716e0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.bb3f38f32p+35,                0x1.8p+0,   0x1.9c6a0cdbbc85ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac74d3712p+35,                0x1.8p+0,   0x1.87f1ddd56de12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aed08p+17,                0x1.8p+1,    0x1.31059458ec27p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6ca8p+17,                0x1.8p+1,   0x1.8e0e6e32dc456p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84c1999a2p+35,                0x1.8p+0,   0x1.52c05b9a751ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b83c45a62p+35,                0x1.8p+0,   0x1.9837e57e63cecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9cf80dde2p+35,                0x1.8p+0,   0x1.72e2f7e65c31cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c2c7c6272p+35,                0x1.8p+0,   0x1.a6f90dd2a5a36p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.43cf435e2p+35,                0x1.8p+0,   0x1.018366d0ed5e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.971e8p+17,                0x1.8p+1,   0x1.0168d7ba32852p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3128p+13,                  0x1p+2,   0x1.026d828d7e878p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0468p+17,                0x1.8p+1,   0x1.3422aa73cf30ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79ac04e62p+35,                0x1.8p+0,   0x1.445e09c81e294p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe7f8p+17,                0x1.8p+1,    0x1.fb81e16787b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cfc644572p+35,                0x1.8p+0,   0x1.b964919a509d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9b0a6e72p+35,                0x1.8p+0,   0x1.b0bc35f17e74ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa828p+17,                0x1.8p+1,   0x1.efb48d69fe3bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2bf8p+17,                0x1.8p+1,    0x1.83e39dd38184p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b07de6f2p+35,                0x1.8p+0,   0x1.5afc4b2e398a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac0e64e52p+35,                0x1.8p+0,   0x1.8765584e857aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8718p+17,                0x1.8p+1,   0x1.6ac2da07755dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4378p+17,                0x1.8p+1,   0x1.3ca41c8930b28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eed68p+17,                0x1.8p+1,   0x1.ce385ede3383ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0d48p+17,                0x1.8p+1,   0x1.d3d347d647cdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8098p+17,                0x1.8p+1,   0x1.bb6c648908566p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb6c8p+17,                0x1.8p+1,   0x1.c4b80f995a6a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.761c59f42p+35,                0x1.8p+0,   0x1.3fca519b77e78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c31b8p+17,                0x1.8p+1,   0x1.5e2fddf0eddf4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0e18p+17,                0x1.8p+1,   0x1.356e97b116faep+53,          0x1p-1, INEXACT)
T(RN,           0x1.deab8p+17,                0x1.8p+1,   0x1.a260aeca619a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.966b8p+17,                0x1.8p+1,   0x1.0015e564db4e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba818p+17,                0x1.8p+1,   0x1.4a88e6e4f2b8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad60f7902p+35,                0x1.8p+0,    0x1.8936115dce6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebf28p+17,                0x1.8p+1,   0x1.c62acb34afd8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5831e3622p+35,                0x1.8p+0,   0x1.1a35a168ed704p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc928p+17,                0x1.8p+1,   0x1.74b1e395bac6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9dcfb5222p+35,                0x1.8p+0,   0x1.7405a21d9e884p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bec48p+17,                0x1.8p+1,   0x1.542d53dec71acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d22458642p+35,                0x1.8p+0,   0x1.bcc6ea6fff318p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1518p+17,                0x1.8p+1,   0x1.8055eb8bf557ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4488p+17,                0x1.8p+1,   0x1.60eeadd7e0e58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa888p+17,                0x1.8p+1,   0x1.efc62b540e918p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7e49f7272p+35,                0x1.8p+0,   0x1.4a555f3f6f836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4df8c7462p+35,                0x1.8p+0,   0x1.0dbaf3633f12cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa99a77f2p+35,                0x1.8p+0,   0x1.85668def4ee86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4b28p+17,                0x1.8p+1,   0x1.3db0419ebddcep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4dd8p+17,                0x1.8p+1,   0x1.df512057fc562p+53,          0x1p-1, INEXACT)
T(RN,       0x1.73d2daf92p+35,                0x1.8p+0,   0x1.3cdcbe488067ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3488p+17,                0x1.8p+1,   0x1.192dc18714b58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.586316fd2p+35,                0x1.8p+0,   0x1.1a722680e1a06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb558p+17,                0x1.8p+1,   0x1.c47881cd21f0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbc68p+17,                0x1.8p+1,   0x1.4d6347d9fb98ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c66126f22p+35,                0x1.8p+0,   0x1.ac0c73329d95cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8078p+17,                0x1.8p+1,   0x1.45041e3082e98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1e48p+17,                0x1.8p+1,   0x1.1663e8bb8810cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9118p+17,                0x1.8p+1,   0x1.4752eebed16bep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0f38p+17,                0x1.8p+1,   0x1.d42adf662047cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f4c064c2p+35,                0x1.8p+0,   0x1.3717f47270778p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6648p+17,                0x1.8p+1,   0x1.65e4b9f77e68cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b865c8f2p+35,                0x1.8p+0,   0x1.70f15fabcdb9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2018p+17,                0x1.8p+1,   0x1.169de1d74160ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.aabc57eb2p+35,                0x1.8p+0,   0x1.85960df8c3392p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2a68d8f2p+35,                0x1.8p+0,   0x1.7a911db8e8266p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbf034ef2p+35,                0x1.8p+0,   0x1.b3ed78ffb345ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf228p+17,                0x1.8p+1,   0x1.7af3453c8a69ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba928p+17,                0x1.8p+1,   0x1.4aaf00af6e66ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49c05afa2p+35,                0x1.8p+0,   0x1.08a232f2e5c0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a72d4e552p+35,                0x1.8p+0,   0x1.80b911a4a6436p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9c8fe6852p+35,                0x1.8p+0,   0x1.7256b14cb4996p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad6e8p+17,                0x1.8p+1,   0x1.2e1814e54d8c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bba08p+17,                0x1.8p+1,    0x1.4d0daa9a20aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6832cca92p+35,                0x1.8p+0,   0x1.2e1e69be93cdep+53,          0x1p-1, INEXACT)
T(RN,       0x1.98b5001b2p+35,                0x1.8p+0,   0x1.6d28f5127c20ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fada8p+17,                0x1.8p+1,   0x1.f0b718a973106p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf178p+17,                0x1.8p+1,   0x1.54eb0ef4e27c8p+53,          0x1p-1, INEXACT)
T(RN,     0x1.b8ed0d341c4p+42,                0x1.4p+0,   0x1.652d069216626p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5ce8p+17,                0x1.8p+1,   0x1.e2065292a0ae2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce5914772p+35,                0x1.8p+0,   0x1.b75ba005dc996p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6add209c2p+35,                0x1.8p+0,   0x1.317a75b0a7398p+53,          0x1p-1, INEXACT)
T(RN,       0x1.add462512p+35,                0x1.8p+0,   0x1.89d4a6f62b252p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.653fcaf92p+35,                0x1.8p+0,   0x1.2a6a75c4b1982p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edcf8p+17,                0x1.8p+1,    0x1.cb58e8426537p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3df8p+13,                  0x1p+2,    0x1.30a40240be08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a0fdf9782p+35,                0x1.8p+0,    0x1.7851cbcbb243p+53,          0x1p-1, INEXACT)
T(RN,       0x1.452d8c242p+35,                0x1.8p+0,   0x1.0325b1ae5d198p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48f4a31f2p+35,                0x1.8p+0,   0x1.07ad1d1f430bap+53,          0x1p-1, INEXACT)
T(RN,               0x1.9cp+6,                  0x1p+3,    0x1.6809a7790e5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bf55937e2p+35,                0x1.8p+0,   0x1.a221c399fd75cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e03f8p+17,                0x1.8p+1,    0x1.a68784a7540cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f683fcd2p+35,                0x1.8p+0,   0x1.60c48c2be0d5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a1ad1fb82p+35,                0x1.8p+0,    0x1.793efde95d15p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e60977652p+35,                0x1.8p+0,   0x1.d98dada6d4556p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8d856242p+35,                0x1.8p+0,   0x1.c667bc5e24d98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.717bdce92p+35,                0x1.8p+0,   0x1.39e0456e0f15ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5afd8722p+35,                0x1.8p+0,   0x1.d90ab92dc15a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f35a8p+17,                0x1.8p+1,   0x1.dafd6cd724e86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fac273502p+35,                0x1.8p+0,    0x1.f828d5682a02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2ad8p+17,                0x1.8p+1,   0x1.5d2ff00201b52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3d68p+17,                0x1.8p+1,   0x1.5fe411365cf3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce608p+17,                0x1.8p+1,    0x1.7917d7093432p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.735d4a4e2p+35,                0x1.8p+0,   0x1.3c46824d97a84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b665b5af2p+35,                0x1.8p+0,   0x1.95aa12141e5dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.98ca71c12p+35,                0x1.8p+0,   0x1.6d45b28d7c072p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d77ac802p+35,                0x1.8p+0,     0x1.20b807a5ef5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cde713092p+35,                0x1.8p+0,   0x1.b6b928bf54862p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc6726d12p+35,                0x1.8p+0,   0x1.cb8b254eb5eaep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c19076ea2p+35,                0x1.8p+0,   0x1.a54330f1ac4acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b99a21a2p+35,                0x1.8p+0,   0x1.46dac46bb2334p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bdd38p+17,                0x1.8p+1,   0x1.5207fb35a391cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6998p+17,                0x1.8p+1,   0x1.b784441ae4296p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f79ddb972p+35,                0x1.8p+0,   0x1.f37a00213fb56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad7c71192p+35,                0x1.8p+0,   0x1.895bcf98a6342p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed908p+17,                0x1.8p+1,    0x1.caa92f6cfaebp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0a28p+17,                0x1.8p+1,   0x1.d34617d3f371ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5d18p+17,                0x1.8p+1,   0x1.e20ef7cc24efep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce3d8p+17,                0x1.8p+1,   0x1.78c23b70b8c82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6c88p+17,                0x1.8p+1,   0x1.e4d828cee15d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d8a198c2p+35,                0x1.8p+0,   0x1.5e4bd0e866bf8p+53,          0x1p-1, INEXACT)
T(RN,          0x1.748f48p+21,                0x1.4p+1,   0x1.ce80d03035302p+53,          0x1p-1, INEXACT)
T(RN,       0x1.493995c82p+35,                0x1.8p+0,    0x1.08000771c75bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a8a603442p+35,                0x1.8p+0,   0x1.82bb3a7af7858p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5acb8112p+35,                0x1.8p+0,   0x1.94a968afdf52ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9cf0de982p+35,                0x1.8p+0,    0x1.72d94a2b96d7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbe18p+17,                0x1.8p+1,   0x1.9b1b5f43278aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac7a8p+17,                0x1.8p+1,   0x1.2c1647d5716e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bee88p+17,                0x1.8p+1,   0x1.547f963189238p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f3dcaa42p+35,                0x1.8p+0,   0x1.4b919a0e64768p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bff488942p+35,                0x1.8p+0,   0x1.a300b64d4f238p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4408p+17,                0x1.8p+1,    0x1.dd8ef10523ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bae5eafb2p+35,                0x1.8p+0,   0x1.9bed6fa2e504ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c798p+17,                0x1.8p+1,   0x1.0bb3bb3356d36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8adbf9e2p+35,                0x1.8p+0,   0x1.f50eb274e3c9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bb78p+17,                0x1.8p+1,   0x1.0a3ab2c1011a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd438p+17,                0x1.8p+1,   0x1.f7d5b61320c6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7858p+17,                0x1.8p+1,   0x1.68914cd06651ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8a4ca682p+35,                0x1.8p+0,    0x1.dd5e42f37669p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5c68p+17,                0x1.8p+1,   0x1.1e38f6766278ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.707b7cff2p+35,                0x1.8p+0,   0x1.3899cec81a386p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d48e7832p+35,                0x1.8p+0,   0x1.5df5a8892213ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f473dbc92p+35,                0x1.8p+0,   0x1.eec6e2694451ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.86e911b02p+35,                0x1.8p+0,    0x1.5592285ed962p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b58b6fd82p+35,                0x1.8p+0,    0x1.947b4139c75fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecc48p+17,                0x1.8p+1,   0x1.c87161cae1bacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b03cf6d92p+35,                0x1.8p+0,   0x1.8d253fc196bc2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7a88p+17,                0x1.8p+1,   0x1.68e47009b7478p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e99b18cb2p+35,                0x1.8p+0,   0x1.dec75f8504152p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6b48p+17,                0x1.8p+1,   0x1.66a1e3463607cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c23751b32p+35,                0x1.8p+0,   0x1.a62dcd47e3122p+53,          0x1p-1, INEXACT)
T(RN,       0x1.635549642p+35,                0x1.8p+0,   0x1.2804b18d1f918p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db008p+17,                0x1.8p+1,     0x1.98d55341b91p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84eb6e262p+35,                0x1.8p+0,   0x1.52f709c4f9e14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.de858p+17,                0x1.8p+1,   0x1.a1fd12a7b021ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe488p+17,                0x1.8p+1,   0x1.faddea8887c58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.540313a62p+35,                0x1.8p+0,   0x1.1514aedddf714p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f523e6772p+35,                0x1.8p+0,   0x1.efcc0ab9d2596p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb818p+17,                0x1.8p+1,   0x1.f2a2b5122068ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ccd795202p+35,                0x1.8p+0,    0x1.b5369464f514p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9234ea622p+35,                0x1.8p+0,   0x1.647bade7f9d04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4858p+17,                0x1.8p+1,   0x1.de54a855e341ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6c08p+17,                0x1.8p+1,    0x1.20371a2e6544p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90bf3a9c2p+35,                0x1.8p+0,   0x1.628b528e06868p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4da808792p+35,                0x1.8p+0,   0x1.0d5927550d97ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9e56d5e2p+35,                0x1.8p+0,   0x1.df346b53d8e1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb4d3e082p+35,                0x1.8p+0,    0x1.b305de05728dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.84e2b7042p+35,                0x1.8p+0,   0x1.52eba4ffee928p+53,          0x1p-1, INEXACT)
T(RN,           0x1.afda8p+17,                0x1.8p+1,   0x1.333befd395806p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe7b49e32p+35,                0x1.8p+0,   0x1.fdb95d8d4e782p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0288p+17,                0x1.8p+1,   0x1.a64ad282dadf8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0018p+17,                0x1.8p+1,   0x1.d18039234500ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa2a8p+17,                0x1.8p+1,   0x1.274126b213d76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1168p+17,                0x1.8p+1,   0x1.a8bffde250cfap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf528p+17,                0x1.8p+1,   0x1.5572184147aaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a16fb7092p+35,                0x1.8p+0,   0x1.78ebce8a0c062p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4828p+17,                0x1.8p+1,   0x1.b1e0c81ad71bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4954d9f12p+35,                0x1.8p+0,   0x1.0820d409d56eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.af4b8p+17,                0x1.8p+1,   0x1.320b209bf2184p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c55a8p+17,                0x1.8p+1,   0x1.6371a22961486p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4848p+17,                0x1.8p+1,   0x1.de51ca64096ecp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5498p+13,                  0x1p+2,   0x1.910c64fef2588p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8808p+17,                0x1.8p+1,    0x1.461086c56a98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f1c89eb42p+35,                0x1.8p+0,   0x1.ead3006a1bd08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2755a832p+35,                0x1.8p+0,   0x1.d455456ef9b3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a784999d2p+35,                0x1.8p+0,   0x1.813022a90e546p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5cb58292p+35,                0x1.8p+0,   0x1.c203c03326bdep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6f48p+17,                0x1.8p+1,   0x1.b87b07ee0ed3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a2b505832p+35,                0x1.8p+0,   0x1.7aa4bdde5a53ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e39e8p+17,                0x1.8p+1,   0x1.af7d62b2079d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac3f8p+17,                0x1.8p+1,    0x1.2b9a626b0a4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6231f1e52p+35,                0x1.8p+0,   0x1.2698ec0233256p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9df013132p+35,                0x1.8p+0,   0x1.743148baaa7e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ab787db22p+35,                0x1.8p+0,   0x1.8697d168235dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f378p+17,                0x1.8p+1,   0x1.1113a9c34ec28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98cb8p+17,                0x1.8p+1,   0x1.0499ede4ba604p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6805c7d2p+35,                0x1.8p+0,   0x1.da3b7b48032fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed638p+17,                0x1.8p+1,   0x1.ca2bc6daab6ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8b28p+17,                0x1.8p+1,   0x1.bd39ab3ec19cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5b18p+17,                0x1.8p+1,   0x1.e1b2c5657eb9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e4ab7f82p+35,                0x1.8p+0,    0x1.35d1475868d3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ddd5fab02p+35,                0x1.8p+0,    0x1.cd9e5048c73ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d9980c42p+35,                0x1.8p+0,   0x1.0d478f5aaf958p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be0375312p+35,                0x1.8p+0,   0x1.a0480baef1e92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e184bb552p+35,                0x1.8p+0,   0x1.d2f71398ad1cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e38e8p+17,                0x1.8p+1,   0x1.af5290a30ce22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d74c8p+17,                0x1.8p+1,   0x1.8f58888c80844p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5158p+17,                0x1.8p+1,   0x1.1cd135954d24ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e02f8p+17,                0x1.8p+1,    0x1.a65d4ae542a9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c72e8p+17,                0x1.8p+1,   0x1.67c2dc1f8e002p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99698e342p+35,                0x1.8p+0,   0x1.6e1b099b21008p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9fd8a862p+35,                0x1.8p+0,   0x1.f70318baa4654p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb528p+17,                0x1.8p+1,   0x1.71ab29f18feaep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca3a8p+17,                0x1.8p+1,   0x1.6f08bab43a626p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc288p+17,                0x1.8p+1,   0x1.73b0cb78bf1f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4f5ba812p+35,                0x1.8p+0,   0x1.93abbb13fe2f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a7dbede52p+35,                0x1.8p+0,   0x1.81a74c3be6a56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bac88p+17,                0x1.8p+1,   0x1.4b281abc6e1d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8c38p+17,                0x1.8p+1,   0x1.46a565b8cb6ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.435e5fdf2p+35,                0x1.8p+0,   0x1.00fcc89367a3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.dd4ec4a52p+35,                0x1.8p+0,   0x1.ccda6f4031bd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.822582da2p+35,                0x1.8p+0,   0x1.4f5898067254cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.538740f82p+35,                0x1.8p+0,    0x1.147d6111de8dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a06da1202p+35,                0x1.8p+0,    0x1.778e76947094p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc788p+17,                0x1.8p+1,   0x1.f57c2416e3ee8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ed6374e2p+35,                0x1.8p+0,   0x1.0ec7637305884p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.993ea3202p+35,                0x1.8p+0,    0x1.6de179c7afd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.57c754f72p+35,                0x1.8p+0,   0x1.19b29eb3f8896p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3a38p+17,                0x1.8p+1,   0x1.af8ac4eb79d8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8428p+17,                0x1.8p+1,   0x1.4586ec3dadafep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8549949b2p+35,                0x1.8p+0,   0x1.537227279c90ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c883ed92p+35,                0x1.8p+0,   0x1.1f8f843485bc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db94f5022p+35,                0x1.8p+0,   0x1.ca5b248f4b8bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5bb833d2p+35,                0x1.8p+0,   0x1.94bded2142e86p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a38e8p+17,                0x1.8p+1,   0x1.19baad73a0e22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b2df6842p+35,                0x1.8p+0,   0x1.31e08f3fb1c28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6ac8p+17,                0x1.8p+1,   0x1.8dc25a9a0ac64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6aaa9f7d2p+35,                0x1.8p+0,   0x1.313ab14252306p+53,          0x1p-1, INEXACT)
T(RN,           0x1.adbd8p+17,                0x1.8p+1,   0x1.2ebeecc260702p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df638p+17,                0x1.8p+1,   0x1.a443e0fb9acccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a7dec492p+35,                0x1.8p+0,   0x1.1d0a0a76b8e1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e39b8p+17,                0x1.8p+1,   0x1.af755b17f7774p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7988p+17,                0x1.8p+1,   0x1.68be6cfaaac48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.834ebdd82p+35,                0x1.8p+0,    0x1.50dc137a521fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8691b5b92p+35,                0x1.8p+0,   0x1.551faee2e0802p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5ee8p+17,                0x1.8p+1,   0x1.1e8a6d321ae42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9e58p+17,                0x1.8p+1,   0x1.6e3ca04ab4b3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bebe8p+17,                0x1.8p+1,   0x1.541f9f702fe32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60a4cf672p+35,                0x1.8p+0,   0x1.24a9ff3d647b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48aae9042p+35,                0x1.8p+0,   0x1.07547d1f0fd28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd8a8p+17,                0x1.8p+1,   0x1.9f6cac8f74696p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.524513872p+35,                0x1.8p+0,   0x1.12f43419a8f76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2188p+17,                0x1.8p+1,   0x1.d768de7d4fbc8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79b49ba12p+35,                0x1.8p+0,   0x1.44691a727814ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ead88p+17,                0x1.8p+1,   0x1.c31f82fb85e08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46dada672p+35,                0x1.8p+0,   0x1.05278d280ce4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.eae3e1c72p+35,                0x1.8p+0,   0x1.e0a9f5fb4cd0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e7a6eb4b2p+35,                0x1.8p+0,   0x1.dbea6e21f3652p+53,          0x1p-1, INEXACT)
T(RN,           0x1.afac8p+17,                0x1.8p+1,   0x1.32d9ccd608764p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cebfbb602p+35,                0x1.8p+0,    0x1.b7edfa727144p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b78e031f2p+35,                0x1.8p+0,   0x1.97459c4aef0bap+53,          0x1p-1, INEXACT)
T(RN,            0x1.5388p+13,                  0x1p+2,    0x1.8c114257287ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ac230a42p+35,                0x1.8p+0,   0x1.31587238da368p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e97dc3112p+35,                0x1.8p+0,   0x1.de9c58ad5c4d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1dd8p+17,                0x1.8p+1,   0x1.5b4d549985462p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8328p+17,                0x1.8p+1,   0x1.45636fcfec44ep+53,         -0x1p-1, INEXACT)
T(RN,             0x1.95cp+10,                0x1.4p+2,   0x1.40118270c6e9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ead68p+17,                0x1.8p+1,   0x1.c319ff4f04c3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d92dd002p+35,                0x1.8p+0,     0x1.4968282dd2ep+53,         -0x1p-1, INEXACT)
T(RN,     0x1.ae63fddff04p+42,                0x1.4p+0,   0x1.5a8a42c9ef518p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1bd8p+17,                0x1.8p+1,   0x1.d666ae035f302p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdd58p+17,                0x1.8p+1,   0x1.77c42744fea8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc9d2d032p+35,                0x1.8p+0,   0x1.cbd952a98b9c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de49ef1a2p+35,                0x1.8p+0,   0x1.ce4661e476534p+53,          0x1p-1, INEXACT)
T(RN,       0x1.be1264452p+35,                0x1.8p+0,   0x1.a05cf4320a6eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5cf8p+17,                0x1.8p+1,    0x1.64851b3abdb7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1838p+17,                0x1.8p+1,   0x1.5a7d0cb609d2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6a18p+17,                0x1.8p+1,   0x1.8da677fa9aaeep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8d6de7942p+35,                0x1.8p+0,   0x1.5e268d485b3c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.539faf802p+35,                0x1.8p+0,     0x1.149b3987ee3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be0b8p+17,                0x1.8p+1,   0x1.52876c6f4f1c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb028p+17,                0x1.8p+1,   0x1.70ea23db4793ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.56b296512p+35,                0x1.8p+0,   0x1.185ebbdfef5aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d218e5432p+35,                0x1.8p+0,   0x1.bcb6875c69dbep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97a38p+17,                0x1.8p+1,   0x1.026570d85f98cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3e68p+17,                0x1.8p+1,   0x1.86c4e8d97d8eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d86ace982p+35,                0x1.8p+0,    0x1.c5c9e2681cd7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bbf962f52p+35,                0x1.8p+0,   0x1.9d6dfa6f8148ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.53fe2ff52p+35,                0x1.8p+0,   0x1.150eb4db07576p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f130d1772p+35,                0x1.8p+0,   0x1.e9f28ca5ecf96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1cc8p+17,                0x1.8p+1,   0x1.1633f484f2fc4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2318p+17,                0x1.8p+1,   0x1.828202ee20d1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a53c8p+17,                0x1.8p+1,   0x1.1d206029c4314p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf868p+17,                0x1.8p+1,   0x1.7be8f23c976cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fd4de9252p+35,                0x1.8p+0,   0x1.fbf63ad20c32ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb938p+17,                0x1.8p+1,   0x1.c523e11db8e5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd4fe7cc2p+35,                0x1.8p+0,   0x1.fbf936c868e78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8cb8p+17,                0x1.8p+1,   0x1.6b9999e453604p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5dc20b5e2p+35,                0x1.8p+0,   0x1.21143681c05e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4b5b6f02p+35,                0x1.8p+0,    0x1.c07511e5cd5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.454a3d5f2p+35,                0x1.8p+0,   0x1.0347feff7aac6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.979ca5072p+35,                0x1.8p+0,   0x1.6bb17b8c2938ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a232d6ef2p+35,                0x1.8p+0,   0x1.79f434f6907a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3f29bcf2p+35,                0x1.8p+0,   0x1.bf5d2b9b195e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a838c14e2p+35,                0x1.8p+0,   0x1.82260352d3484p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af288p+17,                0x1.8p+1,   0x1.31c0a4d1c3af8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3ef8p+17,                0x1.8p+1,    0x1.601e7d62805dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8178p+17,                0x1.8p+1,   0x1.452793afef2c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a3c8p+17,                0x1.8p+1,   0x1.075e1e3eef214p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6668p+13,                  0x1p+2,   0x1.ebc2546fb7f48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7b68p+17,                0x1.8p+1,   0x1.ba8a4e2203bdap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eee23ef12p+35,                0x1.8p+0,   0x1.e68a9c1800f12p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ea064d62p+35,                0x1.8p+0,   0x1.4ac56b93ac134p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6a857fd2p+35,                0x1.8p+0,   0x1.9606928f78c06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b128p+17,                0x1.8p+1,   0x1.08fb1dbf00beep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b9a82422p+35,                0x1.8p+0,   0x1.0addc789a2bc4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd1269312p+35,                0x1.8p+0,   0x1.b58a4ee53f692p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.599ff2c72p+35,                0x1.8p+0,   0x1.1bf84daaf10f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d23f103d2p+35,                0x1.8p+0,   0x1.bced2883c877ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7748p+17,                0x1.8p+1,   0x1.b9d6bd3bb86bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cfc45d0d2p+35,                0x1.8p+0,   0x1.b961d9f257926p+53,          0x1p-1, INEXACT)
T(RN,       0x1.76098bf32p+35,                0x1.8p+0,   0x1.3fb23562cfda2p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4e78p+13,                  0x1p+2,    0x1.74f7f7a8c676p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3fc8p+17,                0x1.8p+1,   0x1.3c23b2d5a5b54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ff135cf2p+35,                0x1.8p+0,   0x1.76e633691e1e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a66e3f62p+35,                0x1.8p+0,   0x1.1ced9f142fa0cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9982985f2p+35,                0x1.8p+0,   0x1.6e3ca04ab4b3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.db508p+17,                0x1.8p+1,    0x1.99a407594a7fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9d2b10c2p+35,                0x1.8p+0,   0x1.b0ec7d5e9eef8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4313b00d2p+35,                0x1.8p+0,   0x1.00a3c55ee90dap+53,         -0x1p-1, INEXACT)
T(RN,     0x1.5ef573bfe04p+42,                0x1.4p+0,    0x1.0c880df06fb5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af948p+17,                0x1.8p+1,   0x1.32a6a17d23d1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d3f8p+17,                0x1.8p+1,    0x1.0d35f824777cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5fb8p+17,                0x1.8p+1,   0x1.8c0245da62094p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df4d8p+17,                0x1.8p+1,   0x1.a40a077097e32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.caa68p+17,                0x1.8p+1,   0x1.700c7cc6bc72ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef908p+17,                0x1.8p+1,    0x1.d0425aec534bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2068p+17,                0x1.8p+1,   0x1.5bac526b33a4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab0390922p+35,                0x1.8p+0,   0x1.85f79a25f691cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4658p+17,                0x1.8p+1,   0x1.1b6ca86a95ebap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f97e53662p+35,                0x1.8p+0,   0x1.f645718188194p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5bcde1032p+35,                0x1.8p+0,   0x1.1ea8fdb43a1c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2298p+17,                0x1.8p+1,   0x1.16ede589db2c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7f28p+17,                0x1.8p+1,   0x1.e83842851818ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99768p+17,                0x1.8p+1,   0x1.05e17e9b3d31ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6808p+13,                  0x1p+2,     0x1.f4bd081bb5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76d35dbe2p+35,                0x1.8p+0,   0x1.40b517be775dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5558p+17,                0x1.8p+1,   0x1.3f148350a0d0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c4b99d8e2p+35,                0x1.8p+0,   0x1.a9b681634fdfcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f98843212p+35,                0x1.8p+0,   0x1.f65440da3c84ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc538p+17,                0x1.8p+1,   0x1.4ea1749997c9cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.82cfcc952p+35,                0x1.8p+0,   0x1.50368472f534ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f72e8p+17,                0x1.8p+1,   0x1.e5ff79bb9f002p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc2cdf9f2p+35,                0x1.8p+0,   0x1.b443bbb9909bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa218p+17,                0x1.8p+1,   0x1.ee97f9084a96ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.afa654962p+35,                0x1.8p+0,   0x1.8c55b6a804bb4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8708p+17,                0x1.8p+1,    0x1.23ae31c6ddf5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce948p+17,                0x1.8p+1,   0x1.79971f4a0ea1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ceee8p+17,                0x1.8p+1,   0x1.7a73aec644142p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9b86f662p+35,                0x1.8p+0,   0x1.def268f0be994p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5598p+17,                0x1.8p+1,   0x1.3f1d44bc2b8d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e565d5cf2p+35,                0x1.8p+0,   0x1.d89e9d43f5e1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c3b459942p+35,                0x1.8p+0,   0x1.a84632a08b838p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca758p+17,                0x1.8p+1,   0x1.6f96932fdf16ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfcb8p+17,                0x1.8p+1,   0x1.7c92b44239b04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1728p+17,                0x1.8p+1,   0x1.36a5f246aba0ep+53,         -0x1p-1, INEXACT)
T(RN,          0x1.465248p+21,                0x1.4p+1,   0x1.4c13bf733076ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f10d585c2p+35,                0x1.8p+0,   0x1.e9be1e5ebb2e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e27369812p+35,                0x1.8p+0,   0x1.d45271c066b0ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a548p+17,                0x1.8p+1,   0x1.078c5a1c7815cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8f8483b52p+35,                0x1.8p+0,   0x1.60e9ff4508f0ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4188p+17,                0x1.8p+1,   0x1.3c609f94c81c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a0a8p+17,                0x1.8p+1,   0x1.06fddd8fef016p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4d8295b2p+35,                0x1.8p+0,   0x1.c0a682e11e78ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59caad6a2p+35,                0x1.8p+0,   0x1.1c2cf84a1c3acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc3a947d2p+35,                0x1.8p+0,   0x1.9dc90dc38bd06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8328p+17,                0x1.8p+1,   0x1.6a2cb9477744ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af238p+17,                0x1.8p+1,   0x1.31b601d61b80cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4a48p+17,                0x1.8p+1,   0x1.88a1b4051ed4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0f38p+17,                0x1.8p+1,   0x1.d42adf662047cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bacb8p+17,                0x1.8p+1,   0x1.4b2ed5f046c04p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4408p+13,                  0x1p+2,     0x1.488c1177911p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aacf8p+17,                0x1.8p+1,    0x1.28989d24cca7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff75096f2p+35,                0x1.8p+0,   0x1.ff2f9c4c182a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4a68p+17,                0x1.8p+1,   0x1.88a6bae96952ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c6f60b362p+35,                0x1.8p+0,   0x1.acdee9a008a8cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d28982232p+35,                0x1.8p+0,   0x1.bd57bc6e65002p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d0b8p+17,                0x1.8p+1,   0x1.0cd06495a5ec4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6888p+17,                0x1.8p+1,   0x1.b756350052d18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4df8p+17,                0x1.8p+1,    0x1.8936115dce6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c03d8p+17,                0x1.8p+1,   0x1.578d556517282p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7d28p+17,                0x1.8p+1,   0x1.e7db47687e82ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9df8p+17,                0x1.8p+1,    0x1.edd695b02d5ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ee74b2f2p+35,                0x1.8p+0,   0x1.4b215f9fef0dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c438p+17,                0x1.8p+1,   0x1.0b4aa506b596cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d1aff7222p+35,                0x1.8p+0,   0x1.bc20633f37c84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3b88p+17,                0x1.8p+1,   0x1.dc09dd1540ca8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1178p+17,                0x1.8p+1,   0x1.a8c2a3f3e4dc8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9aa28p+17,                0x1.8p+1,   0x1.0822c20a5051ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7d98p+17,                0x1.8p+1,   0x1.bae99b4eefc56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6188p+17,                0x1.8p+1,   0x1.e2dbb1a0587c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5118p+17,                0x1.8p+1,   0x1.b36164d34babep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1338p+17,                0x1.8p+1,   0x1.a90cd258a493cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8cd9f1a62p+35,                0x1.8p+0,   0x1.5d63159b074ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.84eb6e262p+35,                0x1.8p+0,   0x1.52f709c4f9e14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4f58p+17,                0x1.8p+1,   0x1.6284473d704eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae178p+17,                0x1.8p+1,   0x1.2f7d4aa6414c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6468p+17,                0x1.8p+1,   0x1.e36074369950ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c6bff4f2p+35,                0x1.8p+0,   0x1.72265a8a4111ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4af669ff2p+35,                0x1.8p+0,   0x1.0a17c93d0f67ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf248p+17,                0x1.8p+1,   0x1.7af82e0eaf4ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed72d1362p+35,                0x1.8p+0,   0x1.e46d268a6068cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8e668472p+35,                0x1.8p+0,   0x1.af9d8219525f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed998p+17,                0x1.8p+1,   0x1.cac24715b9f96p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b92435a02p+35,                0x1.8p+0,    0x1.997aaa8fcf1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae188p+17,                0x1.8p+1,   0x1.2f7f6895bafc8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3ea8p+17,                0x1.8p+1,   0x1.6012cda2150b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad55fa652p+35,                0x1.8p+0,   0x1.8926f9268db56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4008p+17,                0x1.8p+1,     0x1.dcd7be365dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5fda6cb82p+35,                0x1.8p+0,    0x1.23ae31c6ddf5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6578p+17,                0x1.8p+1,   0x1.8ceb02635a588p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a8c6ccff2p+35,                0x1.8p+0,   0x1.82e805b7f0386p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4fa8p+17,                0x1.8p+1,   0x1.3e4d7e439a466p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55ba0d8d2p+35,                0x1.8p+0,   0x1.172df385a9226p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e95c19e2p+35,                0x1.8p+0,   0x1.221ad76a9ef64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b24c8p+17,                0x1.8p+1,   0x1.387b95a040944p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64e745552p+35,                0x1.8p+0,   0x1.29fb923432236p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a36487d62p+35,                0x1.8p+0,   0x1.7b92e99f87cccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7218p+17,                0x1.8p+1,   0x1.e5d9cfa90d86ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d61fa7732p+35,                0x1.8p+0,   0x1.c27ce97df04a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f188c0a2p+35,                0x1.8p+0,   0x1.22bd3e0127694p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3da8p+17,                0x1.8p+1,   0x1.86a6d8d5e6406p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc0b8p+17,                0x1.8p+1,   0x1.736a89cc3bbc4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6f38p+17,                0x1.8p+1,   0x1.e554992edf67cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b9abc56d2p+35,                0x1.8p+0,   0x1.9a37788a023e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c13866272p+35,                0x1.8p+0,   0x1.a4c76ec96e5cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.db948p+17,                0x1.8p+1,   0x1.9a53f0c4d011cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e30ae3d82p+35,                0x1.8p+0,    0x1.d52f131c2bdfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.585e2b452p+35,                0x1.8p+0,   0x1.1a6c18ce0c8eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97772c602p+35,                0x1.8p+0,    0x1.6b7f56140ba4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4bf7e36f2p+35,                0x1.8p+0,   0x1.0b4e88e98b15ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f439ce72p+35,                0x1.8p+0,   0x1.22f2be063d34ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.fffb00032p+35,                0x1.8p+0,   0x1.fff880095ffc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7628p+17,                0x1.8p+1,   0x1.2182ef071c15ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb828p+17,                0x1.8p+1,   0x1.721f1ab061ebep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0968p+17,                0x1.8p+1,   0x1.d324397ea5f7ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab41ac8d2p+35,                0x1.8p+0,   0x1.864cb20b79fdap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.75e911f72p+35,                0x1.8p+0,   0x1.3f88932188e96p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95341e4a2p+35,                0x1.8p+0,   0x1.68798e3d2dd14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee688p+17,                0x1.8p+1,   0x1.cd0463f25b0b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.698e5f202p+35,                0x1.8p+0,    0x1.2fd41e1376acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86803e1a2p+35,                0x1.8p+0,   0x1.5508ccdc3c4ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e02a8p+17,                0x1.8p+1,   0x1.a650196c54f76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d46eec2a2p+35,                0x1.8p+0,   0x1.c00f7c2d37fd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0688p+17,                0x1.8p+1,   0x1.57f03e012e6b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4e28p+17,                0x1.8p+1,   0x1.1c69c540245dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b03773922p+35,                0x1.8p+0,   0x1.8d1da6bba74e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb1dfe9b2p+35,                0x1.8p+0,   0x1.f8b1782754af2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dad68p+17,                0x1.8p+1,   0x1.9868ea2a49c3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce0d11f32p+35,                0x1.8p+0,   0x1.b6ef4c0d7b65ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d89d8p+17,                0x1.8p+1,   0x1.92b394554bea2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f1d84012p+35,                0x1.8p+0,   0x1.22c369facb7f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.857c29382p+35,                0x1.8p+0,    0x1.53b45174715bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c9e77efb2p+35,                0x1.8p+0,   0x1.b10a001eaa84ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba3c8p+17,                0x1.8p+1,   0x1.49ee600615214p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db248p+17,                0x1.8p+1,   0x1.99324ee2858ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98c78p+17,                0x1.8p+1,   0x1.0492479c068d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee9b8p+17,                0x1.8p+1,   0x1.cd931d5c16874p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e46691b2p+35,                0x1.8p+0,   0x1.74a5c063eaff2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd5a8p+17,                0x1.8p+1,   0x1.9eef744341c86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e282f1ad2p+35,                0x1.8p+0,   0x1.d4690f8689866p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb7c9aa42p+35,                0x1.8p+0,   0x1.b349294e09898p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2b38p+17,                0x1.8p+1,   0x1.ad09921b145bcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fecb8p+17,                0x1.8p+1,   0x1.fc64ad365f804p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ebf247102p+35,                0x1.8p+0,    0x1.e237518bcc9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.efa4fba12p+35,                0x1.8p+0,   0x1.e7a9e6cee414ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6308p+17,                0x1.8p+1,    0x1.40f4cce05989p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9a23b292p+35,                0x1.8p+0,   0x1.c78ae390221dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e8d536f2p+35,                0x1.8p+0,   0x1.5fa2a9f906ea6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1f88p+17,                0x1.8p+1,   0x1.81f44ece4af68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8248p+17,                0x1.8p+1,   0x1.917e964a6ffccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cf58p+17,                0x1.8p+1,   0x1.0ca572c684ceap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d509ed4e2p+35,                0x1.8p+0,   0x1.c0edf399cfc84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d0b8p+17,                0x1.8p+1,   0x1.0cd06495a5ec4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c1b5ede2p+35,                0x1.8p+0,   0x1.1f08d092132e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c988p+17,                0x1.8p+1,   0x1.0bf01b7a8cb48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e5cd10ef2p+35,                0x1.8p+0,   0x1.d9356a6b013a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60f7d2162p+35,                0x1.8p+0,   0x1.25115baecf4b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.434688dd2p+35,                0x1.8p+0,   0x1.00e05dd42f03ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5cd8p+13,                  0x1p+2,   0x1.b957326d3f2f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.580dd0d72p+35,                0x1.8p+0,   0x1.1a09454dd4f2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6dd8p+17,                0x1.8p+1,   0x1.e514ebe9f5b62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7098p+17,                0x1.8p+1,   0x1.8eae5085a9a66p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5da8p+13,                  0x1p+2,   0x1.bd777cba5de18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a01a8p+17,                0x1.8p+1,   0x1.12d47ed7f02c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d5a85ce2p+35,                0x1.8p+0,   0x1.5e0cf052d5784p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aee98p+17,                0x1.8p+1,   0x1.313ab14252306p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5aec31022p+35,                0x1.8p+0,   0x1.1d92268a660bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0d78p+17,                0x1.8p+1,   0x1.d3dbc161aa508p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eae58p+17,                0x1.8p+1,   0x1.c3435bf53963ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.610371f62p+35,                0x1.8p+0,   0x1.251fd615f460cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.63cb9f182p+35,                0x1.8p+0,    0x1.28989d24cca7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8e0064e2p+35,                0x1.8p+0,   0x1.c672d1873a284p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.785ba39c2p+35,                0x1.8p+0,   0x1.42ad0f70b7e68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d19172ea2p+35,                0x1.8p+0,   0x1.bbf4bc2e41354p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce2f8p+17,                0x1.8p+1,    0x1.78a000d4c749p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9187453d2p+35,                0x1.8p+0,   0x1.6394eb6219286p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e98595932p+35,                0x1.8p+0,   0x1.dea7d1b76631ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7f08p+17,                0x1.8p+1,    0x1.698f9ed8f1ddp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48412f372p+35,                0x1.8p+0,   0x1.06d57778ecbeap+53,          0x1p-1, INEXACT)
T(RN,       0x1.716e457d2p+35,                0x1.8p+0,   0x1.39cef3f140f06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c307968e2p+35,                0x1.8p+0,   0x1.a752e1fa4e804p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98678p+17,                0x1.8p+1,   0x1.03daddb0b73b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aed88p+17,                0x1.8p+1,   0x1.311692b042a08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd7c8p+17,                0x1.8p+1,   0x1.76eb134227fd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60eddb7d2p+35,                0x1.8p+0,   0x1.2504f325424fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9e38p+17,                0x1.8p+1,   0x1.26adad6c2344cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1428p+17,                0x1.8p+1,   0x1.59e6d3bc27dfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7d16f7a2p+35,                0x1.8p+0,   0x1.f3c6bd1b6ef0cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d05b8p+17,                0x1.8p+1,   0x1.7df59e17f31b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2b8a38a2p+35,                0x1.8p+0,   0x1.7aa9a602d7e6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c42c8p+17,                0x1.8p+1,   0x1.60ad25949ece4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f50243d52p+35,                0x1.8p+0,   0x1.ef9a215339736p+53,          0x1p-1, INEXACT)
T(RN,       0x1.daa234ad2p+35,                0x1.8p+0,   0x1.c8fc61363919ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be6de2142p+35,                0x1.8p+0,   0x1.a0dd139bea4c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9638p+17,                0x1.8p+1,   0x1.94ae89bb93accp+53,          0x1p-1, INEXACT)
T(RN,            0x1.3e28p+13,                  0x1p+2,   0x1.315c1fa6782b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8f68p+17,                0x1.8p+1,   0x1.24c2cb873e59ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.792b3ba92p+35,                0x1.8p+0,   0x1.43b82dfcfcadep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa058p+17,                0x1.8p+1,   0x1.ee45e7c15809ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.baf98p+17,                0x1.8p+1,   0x1.4b9617ccf54b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1b98p+17,                0x1.8p+1,   0x1.373eb312c22f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bd795d922p+35,                0x1.8p+0,   0x1.9f86c6200671cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd048p+17,                0x1.8p+1,   0x1.f71ad0fc9286cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bda08b9d2p+35,                0x1.8p+0,   0x1.9fbd98f81a946p+53,          0x1p-1, INEXACT)
T(RN,     0x1.24d2cc94a62p+43,                0x1.4p+0,   0x1.fd4ba25189ef2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b8c50c82p+35,                0x1.8p+0,    0x1.3257c9cf0e85p+53,          0x1p-1, INEXACT)
T(RN,       0x1.837bf93d2p+35,                0x1.8p+0,   0x1.511717eb3ba86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.96e4ebd92p+35,                0x1.8p+0,   0x1.6abbb2f5471c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6fe8p+17,                0x1.8p+1,   0x1.8e9262dffacf2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c350ceee2p+35,                0x1.8p+0,   0x1.a7b9fb93c9fbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed7d8p+17,                0x1.8p+1,   0x1.ca74395f51442p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b37a8p+17,                0x1.8p+1,   0x1.3b093bd2103e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96b88p+17,                0x1.8p+1,   0x1.00a78e9ebd5a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aec28p+17,                0x1.8p+1,   0x1.30e7d8c4d127ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0408p+17,                0x1.8p+1,    0x1.131fd14f540cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e97e8p+17,                0x1.8p+1,   0x1.bf682361b2072p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5788p+17,                0x1.8p+1,   0x1.3f61252bf09e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4ea8p+17,                0x1.8p+1,   0x1.626a73e24fbb6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97fd8p+17,                0x1.8p+1,   0x1.0310bccf787c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96af8p+17,                0x1.8p+1,    0x1.0096854a92e1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b6b00a12p+35,                0x1.8p+0,   0x1.1e2ec8b4f9b4ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4374a0ce2p+35,                0x1.8p+0,   0x1.0117503aed67cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.55f9c9b82p+35,                0x1.8p+0,    0x1.177c11d1e4d5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6817f6112p+35,                0x1.8p+0,   0x1.2dfca63d7512ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.abd78p+17,                0x1.8p+1,   0x1.2ac050d277608p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0a98p+17,                0x1.8p+1,   0x1.34f6903c4ca46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2a78p+17,                0x1.8p+1,   0x1.39402bf982a78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d694963f2p+35,                0x1.8p+0,   0x1.c32506b388106p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d6231db2p+35,                0x1.8p+0,   0x1.209d69d9b868ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c18358a32p+35,                0x1.8p+0,   0x1.a530c0c9aad02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9c88p+17,                0x1.8p+1,   0x1.48eb03d987ed8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5af7b74a2p+35,                0x1.8p+0,   0x1.1da06176e9714p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8dc8p+17,                0x1.8p+1,   0x1.248d12ac5cff4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eb10ed7e2p+35,                0x1.8p+0,   0x1.e0ec20ba3e4a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4278p+17,                0x1.8p+1,   0x1.dd475b97c1ef8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa254f082p+35,                0x1.8p+0,    0x1.f73e66c55fd3p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdde8p+17,                0x1.8p+1,   0x1.52210135bbe92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc3d8p+17,                0x1.8p+1,   0x1.f4cda6dff0682p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd7e8p+17,                0x1.8p+1,   0x1.f884e75453c72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f93cc13a2p+35,                0x1.8p+0,   0x1.f5e3b9eb5b274p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c32f5e22p+35,                0x1.8p+0,   0x1.47a0e102faffcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d43c8p+17,                0x1.8p+1,   0x1.879c88c164014p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5af2c6dc2p+35,                0x1.8p+0,   0x1.1d9a48274d9e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90cf27812p+35,                0x1.8p+0,   0x1.62a0750f1c70ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eca68p+17,                0x1.8p+1,   0x1.c81e0946a1d2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8985c0b12p+35,                0x1.8p+0,   0x1.59000bfaf8f92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f06fe9c2p+35,                0x1.8p+0,   0x1.75a9b7e558068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ecb083202p+35,                0x1.8p+0,    0x1.e34f21cd042cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a981bb12p+35,                0x1.8p+0,   0x1.312351dbca992p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ceba07232p+35,                0x1.8p+0,   0x1.b7e5d8207ba02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6488p+17,                0x1.8p+1,   0x1.b6a8ebd2f3458p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e15a8p+17,                0x1.8p+1,   0x1.a97433a43c886p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc938p+17,                0x1.8p+1,   0x1.f5cc0b71a915cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f20f8p+17,                0x1.8p+1,    0x1.d74f51450903p+53,          0x1p-1, INEXACT)
T(RN,       0x1.87a5e52e2p+35,                0x1.8p+0,   0x1.5689c3988e9c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb9cd0c52p+35,                0x1.8p+0,   0x1.b376efd220a16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c6a1386d2p+35,                0x1.8p+0,   0x1.ac66feef0a61ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3968p+17,                0x1.8p+1,   0x1.5f4e9edc6807ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.433e96b92p+35,                0x1.8p+0,   0x1.00d6e560f89fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd6c8p+17,                0x1.8p+1,   0x1.9f1e666c81ca4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c94c8p+17,                0x1.8p+1,   0x1.6ccdfc5477e44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4f68p+17,                0x1.8p+1,   0x1.3e44c0a56a99ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3b600482p+35,                0x1.8p+0,    0x1.7c01895ecd4bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4918p+17,                0x1.8p+1,   0x1.3d6841cf6fd3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4258p+17,                0x1.8p+1,   0x1.b0e71fec383fap+53,          0x1p-1, INEXACT)
T(RN,     0x1.24d2cc94a62p+43,                0x1.4p+0,   0x1.fd4ba25189ef2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.514fc6fe2p+35,                0x1.8p+0,   0x1.11c956868ea5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e3e10642p+35,                0x1.8p+0,   0x1.21ae05870bce8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dfc98p+17,                0x1.8p+1,   0x1.a5505cd04bea6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.593bbd6b2p+35,                0x1.8p+0,   0x1.1b7cd6e8a2e92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c082c0e22p+35,                0x1.8p+0,   0x1.a3c850dbd41fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe4360b12p+35,                0x1.8p+0,   0x1.fd65a1e95b06ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2328p+17,                0x1.8p+1,   0x1.d7b2b488c424ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b94be022p+35,                0x1.8p+0,   0x1.3262708b05ebcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c78d8p+17,                0x1.8p+1,   0x1.68a44c6cbf8f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8668p+17,                0x1.8p+1,   0x1.e989b3d53e26ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ebda8p+17,                0x1.8p+1,   0x1.c5e855f8c6c06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fadb8p+17,                0x1.8p+1,   0x1.f0ba094e4c934p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c51206132p+35,                0x1.8p+0,   0x1.aa333aad6521ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4678p+17,                0x1.8p+1,   0x1.ddfeaafa007b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8298p+17,                0x1.8p+1,   0x1.231be9e3a14c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9278p+17,                0x1.8p+1,   0x1.25281c3e8ddf8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a63288082p+35,                0x1.8p+0,    0x1.7f63496a7ecdp+53,          0x1p-1, INEXACT)
T(RN,       0x1.56f40cad2p+35,                0x1.8p+0,   0x1.18af1566e9e66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d9e58a22p+35,                0x1.8p+0,   0x1.0d4d6c9858b84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb6c8p+17,                0x1.8p+1,   0x1.f264d1852d6a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6038p+17,                0x1.8p+1,   0x1.8c167f275e2acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4d18p+17,                0x1.8p+1,   0x1.1c47500aa83fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5048fee92p+35,                0x1.8p+0,   0x1.1089a48cbd55ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.feab38c72p+35,                0x1.8p+0,   0x1.fe012a4277b0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.855cc3c32p+35,                0x1.8p+0,   0x1.538b3f03f4f42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c19f8p+17,                0x1.8p+1,    0x1.5abdd02ff6cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dcb267242p+35,                0x1.8p+0,   0x1.cbf80b7a11398p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.451274242p+35,                0x1.8p+0,   0x1.03054efe5be68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4b38p+17,                0x1.8p+1,   0x1.ded8962db1bbcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c9718e42p+35,                0x1.8p+0,   0x1.1fa1e5c8159e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a902ecca2p+35,                0x1.8p+0,   0x1.833a2df894e14p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac1b320b2p+35,                0x1.8p+0,   0x1.8776e728ddbd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2228p+17,                0x1.8p+1,   0x1.5bed3ba8d579ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0eb8p+17,                0x1.8p+1,   0x1.d41443a07fc64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5dc8p+17,                0x1.8p+1,   0x1.e22eabd6c86f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eccd8p+17,                0x1.8p+1,   0x1.c88a64ba0d2b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.476abbc82p+35,                0x1.8p+0,    0x1.05d4107fc265p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e1eb8caa2p+35,                0x1.8p+0,   0x1.d38cac47924d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b45b8p+17,                0x1.8p+1,   0x1.3cf2882329db4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc508p+17,                0x1.8p+1,    0x1.7411c1d523afp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b06cbf642p+35,                0x1.8p+0,   0x1.8d671caeefd18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4901766b2p+35,                0x1.8p+0,   0x1.07bc88e3dc092p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8918p+17,                0x1.8p+1,   0x1.4636486d8693ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.56ef23952p+35,                0x1.8p+0,   0x1.18a90e27bd54ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bac56c32p+35,                0x1.8p+0,   0x1.328044b65eabep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea338p+17,                0x1.8p+1,   0x1.c1592ae67343cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7bb2d3c2p+35,                0x1.8p+0,   0x1.817a99c3fb3d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8718424a2p+35,                0x1.8p+0,   0x1.55d003f9b4514p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d44e8p+17,                0x1.8p+1,   0x1.87c9b440de262p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd4ae7f42p+35,                0x1.8p+0,   0x1.ccd4d759aed88p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d65c8p+17,                0x1.8p+1,   0x1.8cf7ab1213074p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f118p+17,                0x1.8p+1,   0x1.10c8b7197d8bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f402ad02p+35,                0x1.8p+0,    0x1.3708e4126ecep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9b68p+17,                0x1.8p+1,   0x1.c001c3112b1dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8e58p+17,                0x1.8p+1,   0x1.46f102ed5b03ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.55de00d02p+35,                0x1.8p+0,    0x1.175a02d290f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e50d8p+17,                0x1.8p+1,   0x1.b3569f9817d72p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aeb064bd2p+35,                0x1.8p+0,   0x1.8b032da0da67ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe198p+17,                0x1.8p+1,   0x1.fa51e91820d16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4e08p+17,                0x1.8p+1,    0x1.89389570a16ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.edb39e6a2p+35,                0x1.8p+0,   0x1.e4cc9681999acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a79155582p+35,                0x1.8p+0,    0x1.814181dc34b1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c52c5d582p+35,                0x1.8p+0,    0x1.aa58663c77b1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfad8p+17,                0x1.8p+1,   0x1.7c48df421aa52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a21a8p+17,                0x1.8p+1,   0x1.16cfe25b8d8c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6bbd4cc2p+35,                0x1.8p+0,   0x1.f229e52fa9f88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2bd8p+17,                0x1.8p+1,   0x1.83dea15c5de02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98c48p+17,                0x1.8p+1,   0x1.048c8afea5facp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfd98p+17,                0x1.8p+1,   0x1.7cb52bfeb7456p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db0c8p+17,                0x1.8p+1,   0x1.98f4503bd1f84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6868p+17,                0x1.8p+1,   0x1.8d620b6e353cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac958p+17,                0x1.8p+1,   0x1.2c4f05f7dd4cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8058p+17,                0x1.8p+1,   0x1.69c196b069a9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1f38p+17,                0x1.8p+1,   0x1.ab0a66e72277cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa1b5dc22p+35,                0x1.8p+0,   0x1.f72f92d2d7ec4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.584c209a2p+35,                0x1.8p+0,   0x1.1a55e7511b434p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ca098b2a2p+35,                0x1.8p+0,   0x1.b13a4d54b0a2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9beacbe32p+35,                0x1.8p+0,   0x1.7178783c1ab82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f88015262p+35,                0x1.8p+0,   0x1.f4cab21e53814p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8e10148e2p+35,                0x1.8p+0,   0x1.5efcf63bd43fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1098p+17,                0x1.8p+1,   0x1.35c466e59d866p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa878p+17,                0x1.8p+1,   0x1.28029c8e71618p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0718p+17,                0x1.8p+1,   0x1.d2bbd64518ddep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf3c8p+17,                0x1.8p+1,   0x1.7b331b3726114p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5318p+17,                0x1.8p+1,   0x1.8a04830b49e1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4d48p+17,                0x1.8p+1,   0x1.b2bd3858c18dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9d3d2172p+35,                0x1.8p+0,   0x1.df1a96316ce56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c946c8532p+35,                0x1.8p+0,   0x1.b026195994a62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ada8p+17,                0x1.8p+1,   0x1.088ee125f1106p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0288p+17,                0x1.8p+1,   0x1.a64ad282dadf8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f6eb0682p+35,                0x1.8p+0,    0x1.2328449b1829p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2fa781b2p+35,                0x1.8p+0,   0x1.ec97a1fa1d20ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef7f8p+17,                0x1.8p+1,    0x1.d012955244e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e79d28f42p+35,                0x1.8p+0,   0x1.dbdc24e2a7878p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9000388e2p+35,                0x1.8p+0,   0x1.618df5fcfd404p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3c0e6b02p+35,                0x1.8p+0,    0x1.bf15e56eb142p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cf8b1fc2p+35,                0x1.8p+0,   0x1.3424cde795f58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2208p+17,                0x1.8p+1,    0x1.d77f95aeaee6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af7c8p+17,                0x1.8p+1,   0x1.32737bd4d45d4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcb18p+17,                0x1.8p+1,   0x1.4f7602be1289ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd7e8p+17,                0x1.8p+1,   0x1.5146c7ebe7c72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5e0d1e32p+35,                0x1.8p+0,   0x1.7ef401dd9087ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fbe31f782p+35,                0x1.8p+0,    0x1.f9d7dc3873fdp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3f78p+17,                0x1.8p+1,   0x1.3c18d28649268p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7458p+17,                0x1.8p+1,   0x1.e642218d6ba5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0bd8p+17,                0x1.8p+1,   0x1.58b3fa3629802p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4728p+17,                0x1.8p+1,   0x1.3d24a8fe05b0ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e086c8062p+35,                0x1.8p+0,   0x1.d185dab1cd0acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e20d8p+17,                0x1.8p+1,   0x1.ab4f8799ddc72p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ba38p+17,                0x1.8p+1,   0x1.0a13e85ea458cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e0a1e8992p+35,                0x1.8p+0,   0x1.d1ad46dd0a3bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.860ebe162p+35,                0x1.8p+0,   0x1.547428a23c34cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0538p+17,                0x1.8p+1,   0x1.57bfedc14c89cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9378p+17,                0x1.8p+1,   0x1.ebeb36857ba28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.caac8p+17,                0x1.8p+1,   0x1.701aeeb3ec864p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.998b89e72p+35,                0x1.8p+0,   0x1.6e489fbfb52b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e7d8p+17,                0x1.8p+1,   0x1.0fa552cf5ef42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1d58p+17,                0x1.8p+1,   0x1.1645ef742868ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4859350a2p+35,                0x1.8p+0,   0x1.06f25241d2f6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6848p+17,                0x1.8p+1,   0x1.1fbc741ba8cecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98c68p+17,                0x1.8p+1,   0x1.04905e0fd688ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba8d8p+17,                0x1.8p+1,   0x1.4aa3cb9e8e9f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7858p+17,                0x1.8p+1,   0x1.8fe97ecfd151ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5c88p+17,                0x1.8p+1,   0x1.e1f5086efb2d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c4631eef2p+35,                0x1.8p+0,   0x1.a93c87041885ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.973a85112p+35,                0x1.8p+0,   0x1.6b2e2f60f20d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cc28p+17,                0x1.8p+1,   0x1.0c41f6b85cc7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc7e8p+17,                0x1.8p+1,   0x1.f58de4fd92172p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4c68p+17,                0x1.8p+1,   0x1.3ddbe9b60dc8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0a98p+17,                0x1.8p+1,   0x1.13f0395991a46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0b58p+17,                0x1.8p+1,   0x1.a7bf458bd8e2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.83ed19472p+35,                0x1.8p+0,   0x1.51aac12cfc3f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c7bc8032p+35,                0x1.8p+0,   0x1.3386a927e8fc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3ee8p+17,                0x1.8p+1,   0x1.dca4405e96842p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bac293f02p+35,                0x1.8p+0,    0x1.9bbc2301d7c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab0e8p+17,                0x1.8p+1,   0x1.291c0732e78a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d17d8p+17,                0x1.8p+1,   0x1.80c2fcca4e042p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3728p+17,                0x1.8p+1,   0x1.db41ecd4a900ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b802c9da2p+35,                0x1.8p+0,   0x1.97e7f3c449f4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7f78p+17,                0x1.8p+1,   0x1.44e0ab4521e68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4ce8p+17,                0x1.8p+1,   0x1.890b4dc21cfe2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.522490fd2p+35,                0x1.8p+0,   0x1.12cc91e9091fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2c18p+17,                0x1.8p+1,   0x1.83e89a5595a4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4798p+17,                0x1.8p+1,   0x1.de3241c13b536p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8e98p+17,                0x1.8p+1,   0x1.9375f93a9d106p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3ff8p+17,                0x1.8p+1,     0x1.87038f2a57cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8a68p+17,                0x1.8p+1,   0x1.bd18dfdbc312ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1428p+17,                0x1.8p+1,   0x1.d50a48be08dfep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1528p+17,                0x1.8p+1,   0x1.5a0bca09290aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee158p+17,                0x1.8p+1,   0x1.cc1c5c058954ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.686d85922p+35,                0x1.8p+0,   0x1.2e684e2eed71cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df538p+17,                0x1.8p+1,   0x1.a419cde12559cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.bac0b7d12p+35,                0x1.8p+0,   0x1.9bb98adf5ef52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8869e7262p+35,                0x1.8p+0,   0x1.578b08c4ec414p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed8e8p+17,                0x1.8p+1,   0x1.caa39c11f5c22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f35c8p+17,                0x1.8p+1,   0x1.db0321ebe5774p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6419ff812p+35,                0x1.8p+0,   0x1.28faa382b08f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1188p+17,                0x1.8p+1,   0x1.5985d9b8048c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecef8p+17,                0x1.8p+1,    0x1.c8e8e9d5d40dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.42babe412p+35,                0x1.8p+0,   0x1.0039d18125f72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed1b8p+17,                0x1.8p+1,   0x1.c9634f19fbbf4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf9a7dae2p+35,                0x1.8p+0,   0x1.b926145543b3cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e1cc81722p+35,                0x1.8p+0,   0x1.d35f7fa6eafa4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.55ae9da32p+35,                0x1.8p+0,   0x1.171fefa0268fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fbf70b0f2p+35,                0x1.8p+0,   0x1.f9f59f1cb2766p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3b08p+17,                0x1.8p+1,    0x1.19ff3104f411p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f6da8492p+35,                0x1.8p+0,   0x1.763465dfdc61ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5fd29022p+35,                0x1.8p+0,   0x1.c24b55f8f4f44p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cca88p+17,                0x1.8p+1,   0x1.74e74e5f3e378p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4238p+13,                  0x1p+2,    0x1.4141eec69103p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6708p+17,                0x1.8p+1,    0x1.b71534374195p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2198p+17,                0x1.8p+1,   0x1.5bd85d85d3916p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa258p+17,                0x1.8p+1,   0x1.2736c267c45fap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c3518922p+35,                0x1.8p+0,   0x1.0b9879eb7e6e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d932b0042p+35,                0x1.8p+0,   0x1.c6ea00628b328p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f412fd002p+35,                0x1.8p+0,     0x1.ee37410ddeep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa8c8p+17,                0x1.8p+1,   0x1.efd1ea2b75604p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d039c4b2p+35,                0x1.8p+0,   0x1.48aeb917eb852p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96858p+17,                0x1.8p+1,   0x1.00470e644ea1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1408p+17,                0x1.8p+1,    0x1.151ca703e43cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b2924b92p+35,                0x1.8p+0,   0x1.70740aef605fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbcb8p+17,                0x1.8p+1,   0x1.4d6e8ccab9f04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f55c8p+17,                0x1.8p+1,   0x1.e0be189c07d74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6008da8e2p+35,                0x1.8p+0,   0x1.23e7ef6bac004p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9ab8p+17,                0x1.8p+1,   0x1.ed3e5b6d0faa4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d26eb812p+35,                0x1.8p+0,   0x1.0cbcded4d8f0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a36ec662p+35,                0x1.8p+0,   0x1.59e9230d3986cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a18c8p+17,                0x1.8p+1,   0x1.15b42ee037b04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99408p+17,                0x1.8p+1,    0x1.0579eff462bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1db8p+17,                0x1.8p+1,   0x1.81ac43d525e34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2078p+17,                0x1.8p+1,   0x1.d7389ba091c98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5a48p+17,                0x1.8p+1,   0x1.3fc18d05e004cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db678p+17,                0x1.8p+1,   0x1.99df819c09cb8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c50f8p+17,                0x1.8p+1,    0x1.62c157117c93p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a6f14fcc2p+35,                0x1.8p+0,   0x1.8067442eee188p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee188p+17,                0x1.8p+1,   0x1.cc24bda646fc8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1268p+17,                0x1.8p+1,   0x1.a8ea604dd96aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6b58p+17,                0x1.8p+1,   0x1.e4a133839402ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.9001fd1b2p+35,                0x1.8p+0,   0x1.61904dfea57f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c85aa3b02p+35,                0x1.8p+0,    0x1.aed784800022p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9ee8p+17,                0x1.8p+1,   0x1.6e52391a67a42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9a08p+17,                0x1.8p+1,    0x1.954b0e73364ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ede4b8d32p+35,                0x1.8p+0,   0x1.e514ebe9f5b62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3438p+17,                0x1.8p+1,   0x1.1923b279c5e6cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae2e31d82p+35,                0x1.8p+0,    0x1.8a501c54b69fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1538p+17,                0x1.8p+1,   0x1.5a0e198459b9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d92c8p+17,                0x1.8p+1,   0x1.94218cc3d3be4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2bb8p+17,                0x1.8p+1,   0x1.5d507bb837ad4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e058p+17,                0x1.8p+1,   0x1.0eb9a7e530c9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e827c6882p+35,                0x1.8p+0,    0x1.dca71c98c95dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8f58p+17,                0x1.8p+1,   0x1.eb2a85e13c0eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b6d87b062p+35,                0x1.8p+0,   0x1.964969df82eacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad838p+17,                0x1.8p+1,   0x1.2e4468b1d212cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b1ace4d2p+35,                0x1.8p+0,   0x1.7060c557ae7a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0c78p+17,                0x1.8p+1,   0x1.142bd818d80d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d08b8p+17,                0x1.8p+1,   0x1.7e6c1d0022144p+53,          0x1p-1, INEXACT)
T(RN,       0x1.552f39422p+35,                0x1.8p+0,   0x1.1683e3ef72e3cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0f68p+17,                0x1.8p+1,   0x1.359ba27f5bd9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c71b8p+17,                0x1.8p+1,   0x1.6795d0f2ca9f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.50a708322p+35,                0x1.8p+0,   0x1.10fbfd5593324p+53,          0x1p-1, INEXACT)
T(RN,       0x1.be8f805d2p+35,                0x1.8p+0,   0x1.a10c2af8986c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bc88p+17,                0x1.8p+1,   0x1.0a5bae8b4e4d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b2689f562p+35,                0x1.8p+0,   0x1.9024070e6e834p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97d3f8c22p+35,                0x1.8p+0,   0x1.6bfb8a866f33cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8df8p+17,                0x1.8p+1,    0x1.935c61a52f2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf238p+17,                0x1.8p+1,   0x1.5506831d2e80cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7e28p+17,                0x1.8p+1,   0x1.2289d2f0ea6dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a568p+17,                0x1.8p+1,   0x1.079034ad6febap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.512c11432p+35,                0x1.8p+0,   0x1.119ddd8b23a42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa8eb8ef2p+35,                0x1.8p+0,   0x1.f7dba5b953c5ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.4e88p+13,                  0x1p+2,    0x1.753f5ab3e4eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50372ac52p+35,                0x1.8p+0,   0x1.1073f86b661eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be2d8p+17,                0x1.8p+1,   0x1.52d4dc39ee9d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.672191492p+35,                0x1.8p+0,   0x1.2cc6e7bcf97e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe1973ce2p+35,                0x1.8p+0,   0x1.fd26db334cb84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7780475c2p+35,                0x1.8p+0,   0x1.41931cfc9ace8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.efb6b1972p+35,                0x1.8p+0,   0x1.e7c40a79b4f56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ede4d992p+35,                0x1.8p+0,   0x1.0ed132d7f7dbep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cccffe2a2p+35,                0x1.8p+0,   0x1.b52bc76e3b3d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e470971c2p+35,                0x1.8p+0,   0x1.d7389ba091c98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9108p+17,                0x1.8p+1,    0x1.4750b4ce2313p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1e22e1e2p+35,                0x1.8p+0,   0x1.8f6a540fbbd9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee878p+17,                0x1.8p+1,   0x1.cd5b217426218p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d735b3b92p+35,                0x1.8p+0,   0x1.c40ccb7a9ac02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0538p+17,                0x1.8p+1,   0x1.343e781a7989cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7e0865c2p+35,                0x1.8p+0,   0x1.c502b284e7918p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c25c8p+17,                0x1.8p+1,   0x1.5c73cac8bb474p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f28de66a2p+35,                0x1.8p+0,   0x1.ebf6e5c133654p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7278p+17,                0x1.8p+1,   0x1.2109f771697f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec6bdab32p+35,                0x1.8p+0,   0x1.e2ea1ea47a322p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a63a8p+17,                0x1.8p+1,   0x1.1f255fc349a26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df958p+17,                0x1.8p+1,   0x1.a4c76ec96e5cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.561f62dc2p+35,                0x1.8p+0,   0x1.17aa2a841fe18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9f2e9ce92p+35,                0x1.8p+0,   0x1.75df3a59d8ea2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab918p+17,                0x1.8p+1,   0x1.2a2dc58b5ca3ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9b1ffdd2p+35,                0x1.8p+0,   0x1.f69277afd723ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f44b8p+17,                0x1.8p+1,   0x1.ddae72799e084p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7d039c4b2p+35,                0x1.8p+0,   0x1.48aeb917eb852p+53,          0x1p-1, INEXACT)
T(RN,       0x1.676641a42p+35,                0x1.8p+0,   0x1.2d1d368d6dd68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfda8p+17,                0x1.8p+1,   0x1.7cb7a2576b806p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc008p+17,                0x1.8p+1,     0x1.9b6bbbe6594p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d7fd4d42p+35,                0x1.8p+0,   0x1.34d0022634c48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6ce46eea2p+35,                0x1.8p+0,   0x1.340b25216eb54p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3cd8p+17,                0x1.8p+1,   0x1.affb3c21aefb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72792ed52p+35,                0x1.8p+0,   0x1.3b23479fa02cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.757f21ee2p+35,                0x1.8p+0,   0x1.3f00d0b490244p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.521e10ab2p+35,                0x1.8p+0,   0x1.12c4a521242eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce828p+17,                0x1.8p+1,   0x1.796b0ce2affbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a37ddfa92p+35,                0x1.8p+0,   0x1.7bb551e8c52dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.703b06622p+35,                0x1.8p+0,   0x1.3847ca7694afcp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.32f8p+13,                  0x1p+2,    0x1.089f5c49e9f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecc68p+17,                0x1.8p+1,   0x1.c876f0967c48ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1a88p+17,                0x1.8p+1,   0x1.15ec1086dc278p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0c9e57f2p+35,                0x1.8p+0,   0x1.a42c35e43f286p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4698p+17,                0x1.8p+1,   0x1.613bf4495d786p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9f5d71b42p+35,                0x1.8p+0,   0x1.761e7e04ed4f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a7d28292p+35,                0x1.8p+0,   0x1.6f8cf42b70bdep+53,          0x1p-1, INEXACT)
T(RN,           0x1.dce08p+17,                0x1.8p+1,    0x1.9db1a11de2eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76d6c9e72p+35,                0x1.8p+0,   0x1.40b97c3db2d4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d975fdff2p+35,                0x1.8p+0,   0x1.c74b122e4e186p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6daf26ee2p+35,                0x1.8p+0,   0x1.350bfd00d0fbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9828p+17,                0x1.8p+1,   0x1.bf731b562e8bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa8b8p+17,                0x1.8p+1,   0x1.efcefa7127f44p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a90db462p+35,                0x1.8p+0,   0x1.6fa769df0c6d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b081a582p+35,                0x1.8p+0,    0x1.0a2d1eb0d291p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6378p+17,                0x1.8p+1,   0x1.b67aec0ce6128p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa7f8p+17,                0x1.8p+1,    0x1.efabbe9d06f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.66ca7c9f2p+35,                0x1.8p+0,   0x1.2c5988c71fc46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d74b8p+17,                0x1.8p+1,   0x1.8f55fdcdf1984p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e4cf3c02p+35,                0x1.8p+0,    0x1.21c07e316768p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7e58p+17,                0x1.8p+1,   0x1.44b8cd112c53ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0c862472p+35,                0x1.8p+0,   0x1.e95836346ce0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a93a8p+17,                0x1.8p+1,   0x1.254f6b9fbdb26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.462cc3742p+35,                0x1.8p+0,   0x1.045703fbdc778p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.939b4ca72p+35,                0x1.8p+0,   0x1.66588e90d32cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6d68p+17,                0x1.8p+1,   0x1.66f25c326003ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffc68p+17,                0x1.8p+1,   0x1.ff53935ea658ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9b48p+17,                0x1.8p+1,   0x1.957e6883a297cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efb58p+17,                0x1.8p+1,   0x1.d0aa5f9fa132ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e483cbd2p+35,                0x1.8p+0,   0x1.4a5321d1c8986p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc30d2142p+35,                0x1.8p+0,   0x1.fa4bf47fb04c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4fd8p+17,                0x1.8p+1,   0x1.1ca08520d56c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c584d1102p+35,                0x1.8p+0,    0x1.aad53f21e8dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3e68p+17,                0x1.8p+1,   0x1.3bf3d9bc878eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd7b8p+17,                0x1.8p+1,   0x1.9f4588433bf14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efa38p+17,                0x1.8p+1,   0x1.d077c32e4818cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eec98p+17,                0x1.8p+1,   0x1.ce13f1edf33a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.99af8p+17,                0x1.8p+1,    0x1.064eebb86771p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f54f6f502p+35,                0x1.8p+0,    0x1.f00ca728d47ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8dfcaed42p+35,                0x1.8p+0,   0x1.5ee34ed288fb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4a98p+17,                0x1.8p+1,   0x1.61d1f261b6646p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee098p+17,                0x1.8p+1,   0x1.cbfad6871e766p+53,          0x1p-1, INEXACT)
T(RN,       0x1.989bfc3a2p+35,                0x1.8p+0,   0x1.6d076f4023f8cp+53,         -0x1p-1, INEXACT)
T(RN,     0x1.119627dc442p+43,                0x1.4p+0,   0x1.d3d282a8e57dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3c58p+17,                0x1.8p+1,   0x1.3bac1d24a03dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a166af8d2p+35,                0x1.8p+0,   0x1.78df93e60b626p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdec8p+17,                0x1.8p+1,   0x1.77fc4e3025624p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4d28p+17,                0x1.8p+1,   0x1.3df61d490072ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7528p+17,                0x1.8p+1,   0x1.e667d103ee2aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb8b8p+17,                0x1.8p+1,   0x1.7234da86b2244p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a6b8f7f52p+35,                0x1.8p+0,   0x1.801a7677f8576p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4877a4142p+35,                0x1.8p+0,   0x1.0716e1e1e58c8p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5b48p+13,                  0x1p+2,    0x1.b17c83214019p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e2f585aa2p+35,                0x1.8p+0,   0x1.d50ff198c612cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9028e2362p+35,                0x1.8p+0,   0x1.61c3e0c20508cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a331da7c2p+35,                0x1.8p+0,   0x1.7b4e1f4981c58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3528p+17,                0x1.8p+1,   0x1.3ab2742cff6aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba208p+17,                0x1.8p+1,    0x1.49afb8e56466p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a2dcd0ac2p+35,                0x1.8p+0,   0x1.7adab9c4a32c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79185a052p+35,                0x1.8p+0,   0x1.439fdf4f6a76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b967fe92p+35,                0x1.8p+0,   0x1.710713ae9d8a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8b18p+17,                0x1.8p+1,   0x1.ea64331647c9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d9029fd12p+35,                0x1.8p+0,   0x1.c6a4b2faf9f52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d1b8p+17,                0x1.8p+1,   0x1.0cefa2f4bcbf4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af878p+17,                0x1.8p+1,   0x1.328aec6284518p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aae88p+17,                0x1.8p+1,   0x1.28ccbe862d638p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5daf3cf2p+35,                0x1.8p+0,   0x1.94e988dfae5e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5978p+17,                0x1.8p+1,   0x1.e167e51a97b48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3c88c3a2p+35,                0x1.8p+0,   0x1.bf20dc0b09f8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.462196f12p+35,                0x1.8p+0,   0x1.0449a360820eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.75dd1b462p+35,                0x1.8p+0,   0x1.3f793d511b92cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.441ba0362p+35,                0x1.8p+0,   0x1.01de83d8b8374p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.975b8p+17,                0x1.8p+1,   0x1.01dc9db0796b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbc58p+17,                0x1.8p+1,   0x1.4d6106e4d5bdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cb58p+17,                0x1.8p+1,   0x1.0c289ecb2222ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.66fe65352p+35,                0x1.8p+0,   0x1.2c9ab94593bf6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96758p+17,                0x1.8p+1,   0x1.0028cd089356ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.569bae5e2p+35,                0x1.8p+0,   0x1.1842a02a1f81cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7684aa5f2p+35,                0x1.8p+0,   0x1.40501b618ef3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6195a54a2p+35,                0x1.8p+0,   0x1.25d6018ca6314p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c55b68cd2p+35,                0x1.8p+0,   0x1.aa9acbae334a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3bd8p+17,                0x1.8p+1,   0x1.3b9abac19c902p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e0337b0c2p+35,                0x1.8p+0,   0x1.d10cd33b00d08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.78ea03a22p+35,                0x1.8p+0,   0x1.43643a9f8b984p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0e58p+17,                0x1.8p+1,   0x1.d4034f469183ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7678p+17,                0x1.8p+1,   0x1.684a14375e0b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3bd3e922p+35,                0x1.8p+0,   0x1.7c0b5fb889d1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.daa7fb952p+35,                0x1.8p+0,   0x1.c904b91d25ab6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eda98p+17,                0x1.8p+1,   0x1.caeee52ed5946p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c91f18042p+35,                0x1.8p+0,   0x1.afedd7950bcd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e756e7ca2p+35,                0x1.8p+0,   0x1.db755124fa3ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7688p+17,                0x1.8p+1,   0x1.43a44a9d9ebb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c15bfef42p+35,                0x1.8p+0,   0x1.a4f9738c0bc78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a62f8p+17,                0x1.8p+1,    0x1.1f0eef185fc9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.64510c702p+35,                0x1.8p+0,    0x1.293f83dc0696p+53,          0x1p-1, INEXACT)
T(RN,       0x1.add462512p+35,                0x1.8p+0,   0x1.89d4a6f62b252p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d64411d82p+35,                0x1.8p+0,    0x1.c2b1420afd61p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c602f7532p+35,                0x1.8p+0,   0x1.ab8762886b79ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca8e8p+17,                0x1.8p+1,   0x1.6fd2b8d966b22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aadd8p+17,                0x1.8p+1,   0x1.28b5cdcdf1762p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e3fdd62e2p+35,                0x1.8p+0,   0x1.d691368a91fc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5be4f5422p+35,                0x1.8p+0,   0x1.1ec5868a029c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff5f8p+17,                0x1.8p+1,    0x1.fe1f16e09a62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.717d8fdb2p+35,                0x1.8p+0,   0x1.39e26fa920a8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab4553fc2p+35,                0x1.8p+0,   0x1.8651b3d5faca8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0618p+17,                0x1.8p+1,   0x1.a6e148bbb322ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.edb5952f2p+35,                0x1.8p+0,   0x1.e4cf7b10804dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e64bba8a2p+35,                0x1.8p+0,   0x1.d9ee88233a794p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44b93c202p+35,                0x1.8p+0,    0x1.029ab393c674p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dcbf8p+17,                0x1.8p+1,    0x1.9d5bc4f96364p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6d08p+17,                0x1.8p+1,    0x1.e4ef4df6d9a7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe578p+17,                0x1.8p+1,   0x1.fb0a9eb891d88p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3578p+17,                0x1.8p+1,   0x1.aebf742b12c88p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c01098a42p+35,                0x1.8p+0,   0x1.a328168703368p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa5cfe5e2p+35,                0x1.8p+0,   0x1.f7917575ae7e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9fd8p+17,                0x1.8p+1,   0x1.4961732497dc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bb38p+17,                0x1.8p+1,   0x1.0a32f060240bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e048c9962p+35,                0x1.8p+0,   0x1.d12bc73c3664cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9af98p+17,                0x1.8p+1,   0x1.08cac830ff4b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b71e8p+17,                0x1.8p+1,   0x1.4300e31968852p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8526cbf2p+35,                0x1.8p+0,   0x1.f486b7ef18bfap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b68178b22p+35,                0x1.8p+0,   0x1.95d09b3ce67dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8558p+17,                0x1.8p+1,   0x1.6a801bb06be0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1dd8p+17,                0x1.8p+1,   0x1.5b4d549985462p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b95f8p+17,                0x1.8p+1,    0x1.4800b5303d42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7717d3ea2p+35,                0x1.8p+0,   0x1.410cf94e29d54p+53,          0x1p-1, INEXACT)
T(RN,       0x1.934288562p+35,                0x1.8p+0,   0x1.65e25d125d1ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee038p+17,                0x1.8p+1,   0x1.cbea14643aaacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5deeae7c2p+35,                0x1.8p+0,   0x1.214b8f3c6a458p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9db8p+17,                0x1.8p+1,   0x1.95e297d05f634p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9be38p+17,                0x1.8p+1,   0x1.0a9016de52a4cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.deae8p+17,                0x1.8p+1,   0x1.a2688ca203a82p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5528p+13,                  0x1p+2,   0x1.93b450b9d6d78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb6f57812p+35,                0x1.8p+0,   0x1.b33650f75270ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d357c8dd2p+35,                0x1.8p+0,   0x1.be7f38b4b8fc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ab2e3382p+35,                0x1.8p+0,    0x1.6fd520e4639bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd1014dc2p+35,                0x1.8p+0,   0x1.fb99bdc8c9218p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1658p+17,                0x1.8p+1,   0x1.d56d5a44c0dbap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fedf8p+17,                0x1.8p+1,    0x1.fca06754c64ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5338p+17,                0x1.8p+1,   0x1.b3bcf876b953cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.498695602p+35,                0x1.8p+0,    0x1.085caa77a304p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bcf8p+17,                0x1.8p+1,    0x1.0a694430cdd7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.81aa3b132p+35,                0x1.8p+0,   0x1.4eb80d10df7e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2d98p+17,                0x1.8p+1,   0x1.ad6eed9559556p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd8d8p+17,                0x1.8p+1,   0x1.9f7480ea3eaf2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9618p+17,                0x1.8p+1,   0x1.ec65efb31552ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d778p+17,                0x1.8p+1,   0x1.0da37893adee8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3fa8p+17,                0x1.8p+1,   0x1.86f706f779966p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdb18p+17,                0x1.8p+1,   0x1.776c4e9f5b39ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6cd8p+17,                0x1.8p+1,   0x1.2051b1b00d0b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d71cc2b12p+35,                0x1.8p+0,   0x1.c3e8e7d69946ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0f68p+17,                0x1.8p+1,   0x1.359ba27f5bd9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9faf8p+17,                0x1.8p+1,    0x1.1200b157d091p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df728p+17,                0x1.8p+1,   0x1.a46b55717b40ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2008p+17,                0x1.8p+1,     0x1.5b9e6aa1d46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fa0b75862p+35,                0x1.8p+0,   0x1.f717d9e9e47acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.deed8p+17,                0x1.8p+1,   0x1.a30dd61a63212p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1938p+17,                0x1.8p+1,   0x1.aa0b69d55505cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.687e4d912p+35,                0x1.8p+0,   0x1.2e7d6d179c7d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fb58p+17,                0x1.8p+1,   0x1.120c8eeaca32ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3d28p+17,                0x1.8p+1,   0x1.dc542ea63bc2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7968p+17,                0x1.8p+1,   0x1.4409f9bf1bc7ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1b68p+17,                0x1.8p+1,   0x1.d652d593c89dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d15a8p+17,                0x1.8p+1,   0x1.806c390851886p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2938p+17,                0x1.8p+1,   0x1.d8c66fbcc535cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a86817e52p+35,                0x1.8p+0,   0x1.8266a793561aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b19c8p+17,                0x1.8p+1,   0x1.370048a5c1634p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b977c3eb2p+35,                0x1.8p+0,   0x1.99ef069fc8b92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b1e9e612p+35,                0x1.8p+0,   0x1.0a48474764d32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1f5b00f2p+35,                0x1.8p+0,   0x1.a5d17faa89d66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab548p+17,                0x1.8p+1,   0x1.29ae38c2f645cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4ba8p+17,                0x1.8p+1,   0x1.61f9d1020d9a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5bd8p+17,                0x1.8p+1,   0x1.3ff85c4e05f02p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5988f1d62p+35,                0x1.8p+0,   0x1.1bdbf47d91f34p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac588p+17,                0x1.8p+1,   0x1.2bceddd58d288p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f374e9582p+35,                0x1.8p+0,    0x1.ed4cfd34dc31p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6e3cf0d2p+35,                0x1.8p+0,   0x1.dacceb7f43d26p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb0ef8122p+35,                0x1.8p+0,   0x1.e0e94022521e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4278p+17,                0x1.8p+1,   0x1.3c81463335ef8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4b18p+17,                0x1.8p+1,   0x1.b25f184a3609ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c82d53c42p+35,                0x1.8p+0,   0x1.ae975af0a0b58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e2f1a3232p+35,                0x1.8p+0,   0x1.d50a48be08dfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c90f2da2p+35,                0x1.8p+0,   0x1.0c077cfd8c54cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8018p+17,                0x1.8p+1,   0x1.44f6d2cae680ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f43f8p+17,                0x1.8p+1,    0x1.dd8c13dd97ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f5e5e23e2p+35,                0x1.8p+0,   0x1.f0ec060726d24p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cc2ab0c2p+35,                0x1.8p+0,   0x1.33e06456ed2f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4008p+17,                0x1.8p+1,     0x1.dcd7be365dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.66d7e1932p+35,                0x1.8p+0,   0x1.2c6a5a9554b1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5698p+17,                0x1.8p+1,   0x1.b44e84dd8f286p+53,          0x1p-1, INEXACT)
T(RN,       0x1.559b02cd2p+35,                0x1.8p+0,   0x1.1707ea098375ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f12ed8ed2p+35,                0x1.8p+0,   0x1.e9efa2de2d2e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac1f8p+17,                0x1.8p+1,    0x1.2b573e064ec6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fef58p+17,                0x1.8p+1,   0x1.fce21fdd2c2eap+53,          0x1p-1, INEXACT)
T(RN,            0x1.47c8p+13,                  0x1p+2,    0x1.5805b26d526bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0b88p+17,                0x1.8p+1,   0x1.58a8749dc93a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b03c8p+17,                0x1.8p+1,   0x1.340d487959414p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aab08p+17,                0x1.8p+1,    0x1.28580159f161p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bbec59a02p+35,                0x1.8p+0,    0x1.9d5bc4f96364p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0078p+17,                0x1.8p+1,   0x1.12aedac48e698p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a1a07abd2p+35,                0x1.8p+0,   0x1.792ddc91f2586p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b100da62p+35,                0x1.8p+0,   0x1.70525196d0cecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac0714532p+35,                0x1.8p+0,   0x1.875b500e19d9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cdecc5f92p+35,                0x1.8p+0,   0x1.b6c1475bfcc7ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3a5b6442p+35,                0x1.8p+0,   0x1.91da743ddca58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6358p+17,                0x1.8p+1,   0x1.b67582e06faaap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4f48p+17,                0x1.8p+1,   0x1.b31352ec4873cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.990e5d5a2p+35,                0x1.8p+0,   0x1.6da0bf306fc4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.620509612p+35,                0x1.8p+0,   0x1.2660e6a8dc732p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4a48p+17,                0x1.8p+1,   0x1.61c63900abd4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.785310ce2p+35,                0x1.8p+0,   0x1.42a208e19367cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc618p+17,                0x1.8p+1,   0x1.9c6773fe4c62ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ca792dc02p+35,                0x1.8p+0,    0x1.b1d8b8ecc2d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5d4ec6d2p+35,                0x1.8p+0,   0x1.c21183cc27e1ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8eb8p+17,                0x1.8p+1,   0x1.eb0d583c59464p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4318p+17,                0x1.8p+1,   0x1.8780efe1fc31ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4a574c232p+35,                0x1.8p+0,   0x1.0957fb74d5bfep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fffd8p+17,                0x1.8p+1,   0x1.fff880095ffc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.abf69f452p+35,                0x1.8p+0,   0x1.8744be1d9df16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c74d8p+17,                0x1.8p+1,   0x1.680c623847632p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e63649f82p+35,                0x1.8p+0,    0x1.d9cf30f295edp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0f2f6b92p+35,                0x1.8p+0,   0x1.8e202fe6649fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.54aca95a2p+35,                0x1.8p+0,   0x1.15e414675044cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58b37b5f2p+35,                0x1.8p+0,   0x1.1ad5127e2aec6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7358p+17,                0x1.8p+1,   0x1.4333a6e3f15aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e828d182p+35,                0x1.8p+0,    0x1.36182030c499p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90eb78192p+35,                0x1.8p+0,   0x1.62c609ce95abep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0c68p+17,                0x1.8p+1,   0x1.58c8b8214a08ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dcc1d7882p+35,                0x1.8p+0,    0x1.cc0e64338903p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b83b8p+17,                0x1.8p+1,   0x1.4577657c68354p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad8b18ad2p+35,                0x1.8p+0,   0x1.896ff1c5e099ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6198p+17,                0x1.8p+1,   0x1.1ee211447c516p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a918p+17,                0x1.8p+1,   0x1.0801f5495bf3ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.841c1baf2p+35,                0x1.8p+0,   0x1.51e823e7631dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.994ebb042p+35,                0x1.8p+0,   0x1.6df70f01eaed8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c358p+17,                0x1.8p+1,   0x1.0b2f6ae168caap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf0c8p+17,                0x1.8p+1,   0x1.7abd470153b84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b4d59a82p+35,                0x1.8p+0,    0x1.1e0a25fc39b1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5dc8p+17,                0x1.8p+1,   0x1.e22eabd6c86f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1496b802p+35,                0x1.8p+0,     0x1.8e9776b6b85p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97e38p+17,                0x1.8p+1,   0x1.02df38b2cde4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3f5636e2p+35,                0x1.8p+0,   0x1.7c57a2b1b1cbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fcdc8p+17,                0x1.8p+1,   0x1.f6a43f2780bf4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8aa8p+17,                0x1.8p+1,   0x1.bd23ce2447cf6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.702f270b2p+35,                0x1.8p+0,   0x1.3838b049265d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7728p+17,                0x1.8p+1,   0x1.b9d14cfec0c0ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6e38p+17,                0x1.8p+1,   0x1.e52649297eb4cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2b78p+17,                0x1.8p+1,   0x1.180a6e616c6a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9dba8p+17,                0x1.8p+1,   0x1.0e26a260c8ca6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8fb334f2p+35,                0x1.8p+0,   0x1.f5820f02886e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c88612642p+35,                0x1.8p+0,   0x1.af1507a43f0e8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddab8p+17,                0x1.8p+1,   0x1.9fc2d1df566a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b784bf302p+35,                0x1.8p+0,    0x1.9738bbc49672p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.519c17632p+35,                0x1.8p+0,   0x1.12264580bad7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b1811072p+35,                0x1.8p+0,   0x1.31c4e614e9476p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c36684d2p+35,                0x1.8p+0,   0x1.47a555a10845ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.683e8adc2p+35,                0x1.8p+0,   0x1.2e2d30119f1e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0e98p+17,                0x1.8p+1,   0x1.a848d8307a906p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb3a8p+17,                0x1.8p+1,   0x1.4c28249336126p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.85a0cbda2p+35,                0x1.8p+0,   0x1.53e4407c80b4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc3f8p+17,                0x1.8p+1,    0x1.9c0f2d12134cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5228p+17,                0x1.8p+1,   0x1.e01753ce0c89ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5418p+17,                0x1.8p+1,   0x1.6336d7fafedcep+53,          0x1p-1, INEXACT)
T(RN,           0x1.db118p+17,                0x1.8p+1,   0x1.99013a1a52cbep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5cd42ad62p+35,                0x1.8p+0,   0x1.1fed7f2894534p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94b2467b2p+35,                0x1.8p+0,   0x1.67cc5837de94ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac508p+17,                0x1.8p+1,    0x1.2bbe11d59dafp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7598p+17,                0x1.8p+1,   0x1.e67c1c9c06ed6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5858p+17,                0x1.8p+1,   0x1.63d6cfa4f8f1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa6c8p+17,                0x1.8p+1,   0x1.ef73f8a1d03a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fad28p+17,                0x1.8p+1,   0x1.f09f93ed9092ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59825f6c2p+35,                0x1.8p+0,   0x1.1bd3db5b9e348p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.77a2898e2p+35,                0x1.8p+0,   0x1.41bf2006d4a04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c643022a2p+35,                0x1.8p+0,   0x1.abe1db80b242cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49419aa72p+35,                0x1.8p+0,   0x1.0809acbfbcecap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ec58p+17,                0x1.8p+1,   0x1.1032faec33cdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2e88p+17,                0x1.8p+1,   0x1.ad96f466c7e38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed9a8p+17,                0x1.8p+1,   0x1.cac510e19a746p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea9a8p+17,                0x1.8p+1,   0x1.c274a5fc6e646p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97c98p+17,                0x1.8p+1,   0x1.02adbae5c26a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa468p+17,                0x1.8p+1,   0x1.277b5cd3f110ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.548a67b82p+35,                0x1.8p+0,    0x1.15ba2b4407ebp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4ec131002p+35,                0x1.8p+0,     0x1.0eade2eecdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c848p+17,                0x1.8p+1,   0x1.0bc926a5d0eecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1e056cb2p+35,                0x1.8p+0,   0x1.8f67c93dd82aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfe68p+17,                0x1.8p+1,   0x1.a59cc71259ceap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6ce1d9c2p+35,                0x1.8p+0,   0x1.c377c3e049a68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb998p+17,                0x1.8p+1,   0x1.7256b14cb4996p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95a6052a2p+35,                0x1.8p+0,   0x1.69119723539d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.87f6600f2p+35,                0x1.8p+0,   0x1.56f35e27b3d66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a558p+17,                0x1.8p+1,   0x1.078e4763c040ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99b28p+17,                0x1.8p+1,   0x1.0654aef0434cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a58e7662p+35,                0x1.8p+0,   0x1.0959eaf8fc66cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7a18p+17,                0x1.8p+1,   0x1.9030c141a45eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0918p+17,                0x1.8p+1,   0x1.a76018d66a13ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2d2fbf12p+35,                0x1.8p+0,   0x1.ec5d2af054512p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.b7cp+10,                0x1.4p+2,    0x1.de9b7d5ad3d3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.defdc5bc2p+35,                0x1.8p+0,   0x1.cf4b342c72f28p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6728p+13,                  0x1p+2,   0x1.efe364a7f3ff8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9d62c8e2p+35,                0x1.8p+0,   0x1.c7d5d5d64cc04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a420dd622p+35,                0x1.8p+0,   0x1.7c92b44239b04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5028p+17,                0x1.8p+1,   0x1.898e26537673ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ccd28p+17,                0x1.8p+1,   0x1.754d56f490f2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d20016f72p+35,                0x1.8p+0,   0x1.bc930768cfb6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1078p+17,                0x1.8p+1,   0x1.35c01c28fb998p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf908p+17,                0x1.8p+1,    0x1.560025b80a4bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b736eecd2p+35,                0x1.8p+0,   0x1.96cc9bacd1f5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff2716fe2p+35,                0x1.8p+0,   0x1.febac4f580a5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f124fe4a2p+35,                0x1.8p+0,   0x1.e9e11223c62ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1b68p+17,                0x1.8p+1,   0x1.16080429a19dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7baadadf2p+35,                0x1.8p+0,   0x1.46f102ed5b03ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8bf5a0a2p+35,                0x1.8p+0,   0x1.c643b8d730294p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51baf3872p+35,                0x1.8p+0,   0x1.124bdd191308ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4d68p+17,                0x1.8p+1,   0x1.b2c299acbea3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d02b2c402p+35,                0x1.8p+0,    0x1.b9f4a7574368p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efbe8p+17,                0x1.8p+1,   0x1.d0c3af3932932p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ace98p+17,                0x1.8p+1,   0x1.2cffbc205ad06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e10a8p+17,                0x1.8p+1,   0x1.a8a035eb3dd16p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e21f2052p+35,                0x1.8p+0,   0x1.218b23beef76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da28ebc42p+35,                0x1.8p+0,   0x1.c84d42b8f64a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.975e8p+17,                0x1.8p+1,   0x1.01e250305ef12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a31b8p+17,                0x1.8p+1,   0x1.18d342b207df4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9805f5082p+35,                0x1.8p+0,    0x1.6c3e7766e613p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b507c532p+35,                0x1.8p+0,   0x1.0a8470de83262p+53,          0x1p-1, INEXACT)
T(RN,       0x1.afdf43ea2p+35,                0x1.8p+0,   0x1.8ca4238a0fd54p+53,          0x1p-1, INEXACT)
T(RN,            0x1.46c8p+13,                  0x1p+2,    0x1.53d7de25c087p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea8e8p+17,                0x1.8p+1,   0x1.c25398f91cb22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e80e8p+17,                0x1.8p+1,   0x1.bb7a05a49a7a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4dd5d2e2p+35,                0x1.8p+0,   0x1.7d92f1b5ec63cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.558c4f0b2p+35,                0x1.8p+0,   0x1.16f5e6c01b5d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c5c8p+17,                0x1.8p+1,   0x1.0b7b4850ae274p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6d78p+17,                0x1.8p+1,   0x1.8e2f68a2b9708p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f111494f2p+35,                0x1.8p+0,   0x1.e9c3f18cadae6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2eb8p+17,                0x1.8p+1,   0x1.84515ae090264p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f4b51e4b2p+35,                0x1.8p+0,   0x1.ef27ad1f603aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b525e942p+35,                0x1.8p+0,   0x1.70ab76c1f3638p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd828p+17,                0x1.8p+1,   0x1.514fddc3e04bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e01f8p+17,                0x1.8p+1,    0x1.a63313f37886p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cde08p+17,                0x1.8p+1,    0x1.77df0188681ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5c28p+17,                0x1.8p+1,   0x1.646678894cf7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb0e124f2p+35,                0x1.8p+0,   0x1.f899b31eef71ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecfe8p+17,                0x1.8p+1,   0x1.c912a12d1fef2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.605a22232p+35,                0x1.8p+0,   0x1.244d0da139002p+53,          0x1p-1, INEXACT)
T(RN,       0x1.499d0c492p+35,                0x1.8p+0,   0x1.0877b36dc31e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f07d88682p+35,                0x1.8p+0,    0x1.e8e9a1ebe729p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2cc8p+17,                0x1.8p+1,   0x1.ad4c3f04e42c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8be1d2cd2p+35,                0x1.8p+0,   0x1.5c1b9e0ff975ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4bfff0d72p+35,                0x1.8p+0,   0x1.0b5842cae70d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecb28p+17,                0x1.8p+1,   0x1.c83f5eaa245cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1388p+17,                0x1.8p+1,   0x1.59cfbb223e528p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a9d28512p+35,                0x1.8p+0,   0x1.3129b193a39aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba198p+17,                0x1.8p+1,   0x1.49a0105a96116p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de11e1e12p+35,                0x1.8p+0,   0x1.cdf5211780e32p+53,         -0x1p-1, INEXACT)
T(RN,               0x1.f1p+8,                0x1.8p+2,    0x1.ac570376f0d5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aefe8p+17,                0x1.8p+1,   0x1.3167536db74f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70bdabc12p+35,                0x1.8p+0,   0x1.38ee0a8fe538ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e53ee4292p+35,                0x1.8p+0,   0x1.d865bd9d143dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7d8daf032p+35,                0x1.8p+0,   0x1.4961732497dc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f10ced32p+35,                0x1.8p+0,   0x1.4b573b11bc762p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b43779d2p+35,                0x1.8p+0,   0x1.1dfdf0708c146p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fce8330e2p+35,                0x1.8p+0,   0x1.fb5e183c964fcp+53,          0x1p-1, INEXACT)
T(RN,            0x1.3f38p+13,                  0x1p+2,    0x1.35759b3b02afp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b82c8p+17,                0x1.8p+1,   0x1.455621d1008e4p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.5eb608p+21,                0x1.4p+1,    0x1.8da5dda5d1c9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8a48p+17,                0x1.8p+1,   0x1.ea3e4efd2194cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d73b8p+17,                0x1.8p+1,   0x1.8f2d535c8f054p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a97d8p+17,                0x1.8p+1,   0x1.25da265292842p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed288p+17,                0x1.8p+1,   0x1.c9877cd6b34f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.489948de2p+35,                0x1.8p+0,   0x1.073f4eac74ee4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f32d8p+17,                0x1.8p+1,   0x1.da7d0e9a030d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.abad8p+17,                0x1.8p+1,   0x1.2a685de641e52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d6a8p+17,                0x1.8p+1,   0x1.0d8a0a6729936p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef138p+17,                0x1.8p+1,   0x1.cee363ea170dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd7c8p+17,                0x1.8p+1,   0x1.51423d0f94fd4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4fd8p+17,                0x1.8p+1,   0x1.8981903db66c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1f78p+17,                0x1.8p+1,   0x1.81f1d2b122c68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.47e120b52p+35,                0x1.8p+0,   0x1.0662217149af6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e5b8p+17,                0x1.8p+1,   0x1.0f627f300bbb4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7d3c8dc92p+35,                0x1.8p+0,   0x1.48f86acbeb6e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc08d9cb2p+35,                0x1.8p+0,   0x1.b41082bc01caep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47345d3b2p+35,                0x1.8p+0,   0x1.0592dba6d7c32p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e624bfac2p+35,                0x1.8p+0,   0x1.d9b58d8c15338p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e65d8p+17,                0x1.8p+1,   0x1.b6e1c2cf145e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0848p+17,                0x1.8p+1,   0x1.a73dbdf959aecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5485830e2p+35,                0x1.8p+0,   0x1.15b42ee037b04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59ed32652p+35,                0x1.8p+0,   0x1.1c5786da1cb56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8758p+17,                0x1.8p+1,   0x1.23b880cc23b6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac2c8p+17,                0x1.8p+1,   0x1.2b728399624e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7448p+17,                0x1.8p+1,   0x1.214568958232cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9d7ecfd12p+35,                0x1.8p+0,   0x1.73989083c3f52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9c48p+17,                0x1.8p+1,   0x1.48e214c10b2acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7158p+17,                0x1.8p+1,   0x1.20e5166b0284ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a72f8p+17,                0x1.8p+1,    0x1.211a5c761bf9p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4498p+13,                  0x1p+2,   0x1.4ad59e441f988p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7498p+17,                0x1.8p+1,   0x1.435fcfe6a6926p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9278p+17,                0x1.8p+1,   0x1.9414bd35f6df8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0ee8p+17,                0x1.8p+1,   0x1.d41cbdf4c5742p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64a628cb2p+35,                0x1.8p+0,   0x1.29aa0acb79eaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ae32d292p+35,                0x1.8p+0,   0x1.45ef38ab9a5dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6b3e7722p+35,                0x1.8p+0,   0x1.f21e1ce07545cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0b4523c2p+35,                0x1.8p+0,   0x1.bab8967b3b5d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df208p+17,                0x1.8p+1,    0x1.a393c3bac356p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c028eb8a2p+35,                0x1.8p+0,   0x1.a34a38b7cae6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5788p+17,                0x1.8p+1,   0x1.8ab77d75369e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46e60a162p+35,                0x1.8p+0,   0x1.0534f55cbc4b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb268p+17,                0x1.8p+1,   0x1.7140f7df504aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f3368e92p+35,                0x1.8p+0,   0x1.4b842110fc95ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce2b8p+17,                0x1.8p+1,   0x1.7896399c01024p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a368p+17,                0x1.8p+1,   0x1.0752901fe5f5ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fc68p+17,                0x1.8p+1,   0x1.122e2f3cc458ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea7f8p+17,                0x1.8p+1,    0x1.c22a4afb03f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1078p+17,                0x1.8p+1,   0x1.14ab255258998p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d24c8p+17,                0x1.8p+1,   0x1.82c52e74e6944p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b291d852p+35,                0x1.8p+0,   0x1.1ddd635990796p+53,          0x1p-1, INEXACT)
T(RN,           0x1.967e8p+17,                0x1.8p+1,   0x1.0039d18125f72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b8119f1e2p+35,                0x1.8p+0,   0x1.97fc943ebf864p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f639107d2p+35,                0x1.8p+0,   0x1.f16793d5e0afap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef458p+17,                0x1.8p+1,   0x1.cf6fb1763625ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ffaeaed2p+35,                0x1.8p+0,   0x1.6186ee07ed6e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6bc8p+17,                0x1.8p+1,   0x1.8deaec614af94p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f37e8p+17,                0x1.8p+1,   0x1.db642f4b82e72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b16e38522p+35,                0x1.8p+0,   0x1.8eca3f794db9cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d4662f72p+35,                0x1.8p+0,   0x1.34873767b936ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7e0865c2p+35,                0x1.8p+0,   0x1.c502b284e7918p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9b592d32p+35,                0x1.8p+0,   0x1.842e6def6cf62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3c64c852p+35,                0x1.8p+0,   0x1.7c17abe5d3596p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d964aef92p+35,                0x1.8p+0,   0x1.c7321aea3ee7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9598p+17,                0x1.8p+1,   0x1.47f354f90a4d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e87c8p+17,                0x1.8p+1,   0x1.bca624afe00d4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea228p+17,                0x1.8p+1,   0x1.c12a6c9850f9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eaf96cb02p+35,                0x1.8p+0,    0x1.e0c99a5d1382p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aee28p+17,                0x1.8p+1,   0x1.312bd180a33dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d78b8p+17,                0x1.8p+1,   0x1.8ff8c331d8644p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cbaa14902p+35,                0x1.8p+0,    0x1.b389ca065476p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84505a962p+35,                0x1.8p+0,   0x1.522c616fbb04cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb438p+17,                0x1.8p+1,   0x1.c446c910db66cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.915aff282p+35,                0x1.8p+0,    0x1.635a1d4f9e5fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b49c8p+17,                0x1.8p+1,   0x1.3d804089a4f34p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4fa8p+17,                0x1.8p+1,   0x1.3e4d7e439a466p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab958p+17,                0x1.8p+1,   0x1.2a3623fb829cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2b48p+17,                0x1.8p+1,   0x1.395c482d3647cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ddfe8ea22p+35,                0x1.8p+0,   0x1.cdd91e9c3587cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c41b8p+17,                0x1.8p+1,   0x1.60855ff3850f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0668p+17,                0x1.8p+1,   0x1.a6ee7d3a85a6ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.865653ce2p+35,                0x1.8p+0,   0x1.54d1e5c600b84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1a08p+17,                0x1.8p+1,    0x1.aa2deb7cf7cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c088p+17,                0x1.8p+1,   0x1.0ad7f35d35d98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a13d27fb2p+35,                0x1.8p+0,   0x1.78a7565bcb64ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.efefc52c2p+35,                0x1.8p+0,   0x1.e8184ade40238p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8b3b49d2p+35,                0x1.8p+0,   0x1.f5179190294bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9eac8p+17,                0x1.8p+1,   0x1.1001c5a428464p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c388p+17,                0x1.8p+1,   0x1.0b354053d5628p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5808p+13,                  0x1p+2,     0x1.a17c5bbab56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7888p+17,                0x1.8p+1,   0x1.e7046fef2c018p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9e98p+17,                0x1.8p+1,   0x1.c08dc9ef33c06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1398p+17,                0x1.8p+1,   0x1.362b747a02576p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72a8d3132p+35,                0x1.8p+0,   0x1.3b601369bd81ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1ba8p+17,                0x1.8p+1,   0x1.aa72f4630f8a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffd300fd2p+35,                0x1.8p+0,   0x1.ffbc82f754e06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.686a2a6b2p+35,                0x1.8p+0,   0x1.2e6414eb6576ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ceb639aa2p+35,                0x1.8p+0,   0x1.b7e06bf81a6d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3448p+17,                0x1.8p+1,   0x1.1925b5778572cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d66db3e2p+35,                0x1.8p+0,   0x1.5e1d3cca12cdcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.df1ea90d2p+35,                0x1.8p+0,   0x1.cf7aec16f5126p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b80fc4722p+35,                0x1.8p+0,   0x1.97fa0025b4da4p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5228p+13,                  0x1p+2,   0x1.85b0c2888f3b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a2f9c2b42p+35,                0x1.8p+0,   0x1.7b01ffd389af8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e49c8p+17,                0x1.8p+1,   0x1.b226a52dddf34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6beab74c2p+35,                0x1.8p+0,   0x1.32cf23560c178p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6638p+17,                0x1.8p+1,   0x1.b6f20122831ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4562275d2p+35,                0x1.8p+0,   0x1.03649712e64c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddd08p+17,                0x1.8p+1,    0x1.a0237678b8f7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7048p+17,                0x1.8p+1,   0x1.675f4f305e66cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dff9616f2p+35,                0x1.8p+0,   0x1.d0b86f49ad2a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.467e321a2p+35,                0x1.8p+0,   0x1.04b88886cc334p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efab8p+17,                0x1.8p+1,   0x1.d08e41255fca4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d472bfa32p+35,                0x1.8p+0,   0x1.c014f97fb9b02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.976a8p+17,                0x1.8p+1,   0x1.01f91b06c9736p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97a48p+17,                0x1.8p+1,   0x1.026757ac8864cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cef48p+17,                0x1.8p+1,   0x1.7a82660ec253cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4745f3cc2p+35,                0x1.8p+0,   0x1.05a7f317f3988p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da288p+17,                0x1.8p+1,   0x1.96a8953b85bf8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9bf8p+17,                0x1.8p+1,    0x1.ed78e448b8d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f81f8p+17,                0x1.8p+1,    0x1.e8bb17a13d06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b33042f2p+35,                0x1.8p+0,   0x1.31e6f199e5d26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c497c4112p+35,                0x1.8p+0,   0x1.a986c398acd2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f2b8p+17,                0x1.8p+1,   0x1.10fbfd5593324p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8d02723f2p+35,                0x1.8p+0,   0x1.5d9893b4bc906p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c495e2b02p+35,                0x1.8p+0,    0x1.a9841cb66fc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4d63f692p+35,                0x1.8p+0,   0x1.c0a3c39e4fe5ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.54fe405d2p+35,                0x1.8p+0,   0x1.1647eef04f93ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9613ed22p+35,                0x1.8p+0,   0x1.b04b9d3dde564p+53,          0x1p-1, INEXACT)
T(RN,       0x1.593bbd6b2p+35,                0x1.8p+0,   0x1.1b7cd6e8a2e92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9638p+17,                0x1.8p+1,   0x1.ec6bc843b9accp+53,          0x1p-1, INEXACT)
T(RN,       0x1.52a363ba2p+35,                0x1.8p+0,   0x1.136739998d48cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0088p+17,                0x1.8p+1,   0x1.339e27bb71998p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f53e8p+17,                0x1.8p+1,   0x1.e067d14e4bdb2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca1e8p+17,                0x1.8p+1,   0x1.6ec5766fd0952p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d62c8p+17,                0x1.8p+1,   0x1.8c7e2fa08c2e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecc68p+17,                0x1.8p+1,   0x1.c876f0967c48ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5c28p+13,                  0x1p+2,   0x1.b5df28b493c38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d8ceba062p+35,                0x1.8p+0,   0x1.c659e22ba84acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.caa18p+17,                0x1.8p+1,   0x1.70007375a66eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6582a15d2p+35,                0x1.8p+0,   0x1.2abe388d4473ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6da8p+17,                0x1.8p+1,   0x1.66fbd4a037506p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e4133a342p+35,                0x1.8p+0,   0x1.d6b0691758808p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7728p+17,                0x1.8p+1,   0x1.b9d14cfec0c0ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8f28p+17,                0x1.8p+1,   0x1.938d02946ac8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5848p+17,                0x1.8p+1,   0x1.1db2adeb199ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c466e17c2p+35,                0x1.8p+0,   0x1.a941d43319258p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d928p+17,                0x1.8p+1,   0x1.0dd84ed15a76ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9d0ee3e2p+35,                0x1.8p+0,   0x1.8453d99897524p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbc88p+17,                0x1.8p+1,   0x1.72c85a8c774d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecbe8p+17,                0x1.8p+1,   0x1.c860b5ad5d832p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f97c8p+17,                0x1.8p+1,   0x1.ecb4df3b3c3d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f76f9622p+35,                0x1.8p+0,   0x1.2332907854cfcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bf58p+17,                0x1.8p+1,   0x1.0ab30ae7121eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc228p+17,                0x1.8p+1,   0x1.9bc3eb79ff59ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd2e8p+17,                0x1.8p+1,   0x1.9e7cc16feb202p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4f793802p+35,                0x1.8p+0,     0x1.93ae4a85f8bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6195f952p+35,                0x1.8p+0,   0x1.f1387ff8a1d4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cea336892p+35,                0x1.8p+0,   0x1.b7c54fd95169ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c53a8p+17,                0x1.8p+1,   0x1.6326631778f26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe9f8p+17,                0x1.8p+1,    0x1.fbe157694a3ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f7625b9e2p+35,                0x1.8p+0,   0x1.f3217e9c72b64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ced2bf172p+35,                0x1.8p+0,   0x1.b809183d07456p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dba98p+17,                0x1.8p+1,   0x1.9a8a4e51c3346p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7f58p+17,                0x1.8p+1,   0x1.22b0e650f25eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d30f2f862p+35,                0x1.8p+0,   0x1.be17323e2cbacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3a68p+17,                0x1.8p+1,   0x1.19eb092ba0a2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ee18p+17,                0x1.8p+1,   0x1.106a1eec089aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.db018p+17,                0x1.8p+1,   0x1.98d7e8474190ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c7bdf8db2p+35,                0x1.8p+0,   0x1.adf9ba8506772p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c53f8p+17,                0x1.8p+1,    0x1.6332243efefcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.99bda1152p+35,                0x1.8p+0,   0x1.6e8bd4c03124ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fc98p+17,                0x1.8p+1,   0x1.12341ea35fea6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ef366ae2p+35,                0x1.8p+0,   0x1.4b31145c14ac4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a7673172p+35,                0x1.8p+0,   0x1.30f8d60170c56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3908p+17,                0x1.8p+1,    0x1.3b38fd38f80bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a74c8p+17,                0x1.8p+1,   0x1.2155cfd987844p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe8a8p+17,                0x1.8p+1,   0x1.fba2b09e9d196p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f820ce4e2p+35,                0x1.8p+0,   0x1.f43cdb7e8d284p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8108p+17,                0x1.8p+1,    0x1.914b92d07ce3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7e5eb46d2p+35,                0x1.8p+0,   0x1.4a70412d76e1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6195f952p+35,                0x1.8p+0,   0x1.f1387ff8a1d4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc2cdf9f2p+35,                0x1.8p+0,   0x1.b443bbb9909bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.9bfaf1352p+35,                0x1.8p+0,   0x1.718e318ad6c0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe0b7a8f2p+35,                0x1.8p+0,   0x1.fd11ef716979ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.edfe8p+17,                0x1.8p+1,   0x1.cbdc1d96c19f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49835fe12p+35,                0x1.8p+0,   0x1.0858cde8b3232p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.80511bbd2p+35,                0x1.8p+0,   0x1.4cf725578a87ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c333c0b2p+35,                0x1.8p+0,   0x1.332add1bcd02ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7d58p+17,                0x1.8p+1,   0x1.44955fa01388ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b63f8p+17,                0x1.8p+1,    0x1.4115c3f1ac2cp+53,          0x1p-1, INEXACT)
T(RN,            0x1.39a8p+13,                  0x1p+2,   0x1.207268ba82918p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5af8p+17,                0x1.8p+1,    0x1.b50b619b45b1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5d18p+17,                0x1.8p+1,   0x1.1e4f5bf95defep+53,          0x1p-1, INEXACT)
T(RN,       0x1.add462512p+35,                0x1.8p+0,   0x1.89d4a6f62b252p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ac3026c2p+35,                0x1.8p+0,   0x1.6feac9c031548p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.525074c92p+35,                0x1.8p+0,   0x1.1302142ab471ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.990e5d5a2p+35,                0x1.8p+0,   0x1.6da0bf306fc4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6c5bd932p+35,                0x1.8p+0,   0x1.f2389fd58ece2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5888d2002p+35,                0x1.8p+0,     0x1.1aa092664ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5da8p+17,                0x1.8p+1,   0x1.649f08b9b8a06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fa1763ad2p+35,                0x1.8p+0,   0x1.f729a486b5c66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7ad8p+17,                0x1.8p+1,   0x1.e76fd3c7b6252p+53,          0x1p-1, INEXACT)
T(RN,          0x1.6e9cc8p+21,                0x1.4p+1,   0x1.bc4413f41c8fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c49d8p+17,                0x1.8p+1,   0x1.61b5cf81ce2a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b07b8p+17,                0x1.8p+1,   0x1.34940f0ed0814p+53,          0x1p-1, INEXACT)
T(RN,       0x1.43c0f2f62p+35,                0x1.8p+0,   0x1.017253c37f00cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7837a2162p+35,                0x1.8p+0,   0x1.427ec26132b4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.87ff20002p+35,                0x1.8p+0,      0x1.56feda0054p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a23674662p+35,                0x1.8p+0,   0x1.79f91b9481794p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1f48p+17,                0x1.8p+1,   0x1.ab0d0f683ee3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba5e2afd2p+35,                0x1.8p+0,   0x1.9b301b53f0206p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1628p+17,                0x1.8p+1,   0x1.36838cd55af5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.988b8p+17,                0x1.8p+1,   0x1.041f9b4f6f944p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb458p+17,                0x1.8p+1,   0x1.718bc793c565ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c7234baa2p+35,                0x1.8p+0,   0x1.ad1ee7681dad4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.66d634f12p+35,                0x1.8p+0,   0x1.2c684052c3ceep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef708p+17,                0x1.8p+1,    0x1.cfe87137d745p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fec331112p+35,                0x1.8p+0,   0x1.fe2513242f72ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f8304702p+35,                0x1.8p+0,    0x1.4beb74a68996p+53,          0x1p-1, INEXACT)
T(RN,       0x1.42cc35ed2p+35,                0x1.8p+0,   0x1.004e9f1a83ce6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d4e5ec52p+35,                0x1.8p+0,   0x1.2084d9a4a39eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c739ecbc2p+35,                0x1.8p+0,   0x1.ad3ee8af186d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3f6e6822p+35,                0x1.8p+0,   0x1.924acf6de89bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99698e342p+35,                0x1.8p+0,   0x1.6e1b099b21008p+53,          0x1p-1, INEXACT)
T(RN,       0x1.db4403572p+35,                0x1.8p+0,   0x1.c9e624dce0bd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb318p+17,                0x1.8p+1,   0x1.715b827b8101ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd968p+17,                0x1.8p+1,   0x1.f8cc36b52de7ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0ba8p+17,                0x1.8p+1,   0x1.7ee03baaddda6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbc88p+17,                0x1.8p+1,   0x1.72c85a8c774d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.801b66642p+35,                0x1.8p+0,   0x1.4cb15b7cc78e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.499b717b2p+35,                0x1.8p+0,   0x1.0875c50364cb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0a0fc612p+35,                0x1.8p+0,   0x1.e91e0107e4ecep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5b19f742p+35,                0x1.8p+0,   0x1.7eb3c035f6f78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab53f1e02p+35,                0x1.8p+0,    0x1.8665bb6d9db4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86e214362p+35,                0x1.8p+0,   0x1.5588fefd67b74p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fed68p+17,                0x1.8p+1,   0x1.fc858632ee83ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fab485cc2p+35,                0x1.8p+0,   0x1.f8140cb78e588p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8148p+17,                0x1.8p+1,   0x1.e89b1a448ee9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fda18p+17,                0x1.8p+1,   0x1.f8ece800547eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad168p+17,                0x1.8p+1,   0x1.2d5e8358310fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd328p+17,                0x1.8p+1,   0x1.9e872de93db4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa948p+17,                0x1.8p+1,   0x1.281dae403be1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91d8c2542p+35,                0x1.8p+0,   0x1.64012fd2eeb48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc2d8p+17,                0x1.8p+1,   0x1.f49e5c2b793d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e075580f2p+35,                0x1.8p+0,   0x1.d16c840bf4d66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdc48p+17,                0x1.8p+1,   0x1.f954f6f653eacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.470f984d2p+35,                0x1.8p+0,   0x1.0566c5929245ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc308p+17,                0x1.8p+1,    0x1.9be83ef6b8a9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8696f3492p+35,                0x1.8p+0,   0x1.55268c7e5cc1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f10b8p+17,                0x1.8p+1,   0x1.d46eb71531ac4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2abfa832p+35,                0x1.8p+0,   0x1.7a9879b29a4c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c1f010242p+35,                0x1.8p+0,   0x1.a5c996e599668p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aea88p+17,                0x1.8p+1,   0x1.30b0a61b54978p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b958p+17,                0x1.8p+1,   0x1.09f8c357d79cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0056c5b2p+35,                0x1.8p+0,   0x1.e83842851818ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86c2a0572p+35,                0x1.8p+0,   0x1.555fc6cde51d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.940417e82p+35,                0x1.8p+0,    0x1.66e427dd90a7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c2435932p+35,                0x1.8p+0,   0x1.71c5b9a42dce2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e1cfbd62p+35,                0x1.8p+0,   0x1.2184fc31584ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f44a56962p+35,                0x1.8p+0,   0x1.ee8950b5af7b4p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3e98p+13,                  0x1p+2,   0x1.330afe1a2b908p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1f48p+17,                0x1.8p+1,   0x1.d702af2671e3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.67e24be12p+35,                0x1.8p+0,   0x1.2db926c7565cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2ed8p+17,                0x1.8p+1,   0x1.ada44c8f65e12p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2d594522p+35,                0x1.8p+0,   0x1.7ad0e8ad7439cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4f68p+17,                0x1.8p+1,   0x1.1c9252b52f99ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c31e8p+17,                0x1.8p+1,   0x1.5e36da8b1cc52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48f972542p+35,                0x1.8p+0,   0x1.07b2e576f34b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1118p+17,                0x1.8p+1,   0x1.7fb76ba259ebep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b81f8p+17,                0x1.8p+1,    0x1.45394f673106p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3d38p+17,                0x1.8p+1,   0x1.dc570a8e6bb1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc3ac8972p+35,                0x1.8p+0,   0x1.cb4af4655a156p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.771eace02p+35,                0x1.8p+0,    0x1.4115c3f1ac2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.752edd332p+35,                0x1.8p+0,   0x1.3e9a003f61822p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9878p+17,                0x1.8p+1,   0x1.950ae3f7b0318p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d6726b72p+35,                0x1.8p+0,   0x1.20a38e1ebfaeap+53,          0x1p-1, INEXACT)
T(RN,       0x1.91d1abfe2p+35,                0x1.8p+0,   0x1.63f7c4d3a3c5cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ffaf8p+17,                0x1.8p+1,    0x1.ff0ea5f66291p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9809872b2p+35,                0x1.8p+0,   0x1.6c433f7e205eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.630a535a2p+35,                0x1.8p+0,   0x1.27a70a7261fb4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df858p+17,                0x1.8p+1,   0x1.a49d52e786d1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e6913462p+35,                0x1.8p+0,   0x1.4a7db2b0796d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8a3d2092p+35,                0x1.8p+0,   0x1.f4ffe98301a62p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c3bab342p+35,                0x1.8p+0,   0x1.333588bbb0208p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a638p+17,                0x1.8p+1,   0x1.07a9424628dccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b622f142p+35,                0x1.8p+0,   0x1.0a99cc2088938p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1598p+17,                0x1.8p+1,   0x1.a9718cd5bdcd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9068p+17,                0x1.8p+1,   0x1.93c036f16c74ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9af48p+17,                0x1.8p+1,   0x1.08c11e2f9c93cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9c88p+17,                0x1.8p+1,   0x1.c0332b92b0ed8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b929c7662p+35,                0x1.8p+0,   0x1.99826bbf4866cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc3b8p+17,                0x1.8p+1,   0x1.f4c7bd5fb0f54p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2df8p+17,                0x1.8p+1,    0x1.5da435681b0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.79750f562p+35,                0x1.8p+0,   0x1.44173eae48834p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7052c5a32p+35,                0x1.8p+0,   0x1.38660047718fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e977e53a2p+35,                0x1.8p+0,   0x1.de93be04a1a74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.98ee306b2p+35,                0x1.8p+0,   0x1.6d759c5ef8b6ep+53,         -0x1p-1, INEXACT)
T(RN,             0x1.aa4p+10,                0x1.4p+2,   0x1.998465086c1e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a56f8p+17,                0x1.8p+1,    0x1.1d87fcbdd4a5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.df6fee8e2p+35,                0x1.8p+0,   0x1.cff0dea2787fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4878p+17,                0x1.8p+1,   0x1.b1ee36f5c0418p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c4fb72bd2p+35,                0x1.8p+0,   0x1.aa13603426a7ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c44a8p+17,                0x1.8p+1,   0x1.60f35c75528d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a10a8p+17,                0x1.8p+1,   0x1.14b11de691d16p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d09b8d6f2p+35,                0x1.8p+0,   0x1.ba9531b077aa6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7684aa5f2p+35,                0x1.8p+0,   0x1.40501b618ef3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6a38p+17,                0x1.8p+1,   0x1.1ffbce190168cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba0c8p+17,                0x1.8p+1,   0x1.4982fd3bd6c84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.624ae6142p+35,                0x1.8p+0,   0x1.26b80e7eaf338p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b2f2d52c2p+35,                0x1.8p+0,   0x1.90e30c65fa238p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b530a3b2p+35,                0x1.8p+0,   0x1.467f9b7e209cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea1c8p+17,                0x1.8p+1,   0x1.c119edf79c7b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d30793c2p+35,                0x1.8p+0,   0x1.48e8c80f86bd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce088p+17,                0x1.8p+1,   0x1.7840b1a34b398p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5bca950a2p+35,                0x1.8p+0,   0x1.1ea4ea4f89094p+53,          0x1p-1, INEXACT)
T(RN,       0x1.736e52fd2p+35,                0x1.8p+0,   0x1.3c5c4544b2dfap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.561c1dcf2p+35,                0x1.8p+0,   0x1.17a6282adee1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf3d41832p+35,                0x1.8p+0,   0x1.b8a106dccad3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7a98p+17,                0x1.8p+1,   0x1.2214add3e3746p+53,          0x1p-1, INEXACT)
T(RN,           0x1.970e8p+17,                0x1.8p+1,   0x1.014a7f9395ca2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6458p+17,                0x1.8p+1,   0x1.1f3bd1998df5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad7e8p+17,                0x1.8p+1,   0x1.2e39da71ccc72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d7e45d6d2p+35,                0x1.8p+0,   0x1.c5083a2c3d3e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ffe58p+17,                0x1.8p+1,   0x1.ffb0841d4dd3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.702bc2b22p+35,                0x1.8p+0,   0x1.38345fc0c7c24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1688p+17,                0x1.8p+1,   0x1.36907293a99b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da8c8p+17,                0x1.8p+1,   0x1.97aa1680cf604p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf528p+17,                0x1.8p+1,   0x1.5572184147aaep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8a78p+17,                0x1.8p+1,   0x1.bd1b9b6998c78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f28aaab2p+35,                0x1.8p+0,   0x1.607052e33ceeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f84487d12p+35,                0x1.8p+0,   0x1.f47208d694f52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb498p+17,                0x1.8p+1,   0x1.4c49ded6f5526p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9031b9742p+35,                0x1.8p+0,   0x1.61cf9a15ccb78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0d18p+17,                0x1.8p+1,   0x1.d3cace65187fep+53,          0x1p-1, INEXACT)
T(RN,             0x1.a04p+10,                0x1.4p+2,    0x1.6bae805f3504p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcb08p+17,                0x1.8p+1,    0x1.f621e77648c1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a7b95b752p+35,                0x1.8p+0,   0x1.81781e2c94b8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6718p+17,                0x1.8p+1,   0x1.4183b6789efdep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f68458a62p+35,                0x1.8p+0,   0x1.f1d76eebfa514p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3408p+17,                0x1.8p+1,    0x1.852594244d9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9618p+17,                0x1.8p+1,   0x1.94a968afdf52ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dbeda4132p+35,                0x1.8p+0,   0x1.cadb5fa8bd61ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb9d8p+17,                0x1.8p+1,   0x1.c53f892f3cfa2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2028p+17,                0x1.8p+1,   0x1.37dbf5977263ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba998p+17,                0x1.8p+1,   0x1.4abeb1cd91e96p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef4a7afe2p+35,                0x1.8p+0,   0x1.e7245b899725cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee4a8p+17,                0x1.8p+1,   0x1.ccb07d19c36d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3708p+17,                0x1.8p+1,    0x1.5ef5f6ff5f05p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5e48p+17,                0x1.8p+1,   0x1.1e760e1064d0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c14942912p+35,                0x1.8p+0,   0x1.a4df1fb4a0dd2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.83639dda2p+35,                0x1.8p+0,   0x1.50f74fbf8a8b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.769931692p+35,                0x1.8p+0,   0x1.406a716e4825ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d46c8p+17,                0x1.8p+1,   0x1.88150477bb1a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6808p+17,                0x1.8p+1,    0x1.1fb448242738p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf178p+17,                0x1.8p+1,   0x1.7ad8457ac57c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5aabff3b2p+35,                0x1.8p+0,   0x1.1d42e6e700032p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb2483ed2p+35,                0x1.8p+0,   0x1.e108e74b1071ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4eb4d062p+35,                0x1.8p+0,   0x1.c0c1fc1b15d54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97158p+17,                0x1.8p+1,   0x1.0157c5d95784ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4788p+17,                0x1.8p+1,   0x1.3d31bd90066e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f66b8p+17,                0x1.8p+1,   0x1.e3cb4ee70d4e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b79392542p+35,                0x1.8p+0,   0x1.974d56567f4b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62c463c92p+35,                0x1.8p+0,   0x1.274fb382fd51ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ceeb8p+17,                0x1.8p+1,   0x1.7a6c5346a3664p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5373b5fa2p+35,                0x1.8p+0,   0x1.1465823f30e0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.831e0aae2p+35,                0x1.8p+0,   0x1.509c8c8de9d3cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb9eb5df2p+35,                0x1.8p+0,   0x1.b379a13ec59c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7738p+17,                0x1.8p+1,   0x1.e6c7837921ffcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7e58p+17,                0x1.8p+1,   0x1.44b8cd112c53ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.662323cd2p+35,                0x1.8p+0,   0x1.2b877f2b0855ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aafb8p+17,                0x1.8p+1,   0x1.28f46118f4f94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff6d8p+17,                0x1.8p+1,   0x1.fe48fdb561792p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8adbf4712p+35,                0x1.8p+0,   0x1.5ac270be8f3eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8e352582p+35,                0x1.8p+0,    0x1.ddb9e7b6186fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.86a16e842p+35,                0x1.8p+0,   0x1.553447fc14c28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae8bb5c32p+35,                0x1.8p+0,   0x1.8ad0b71b50cbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0638ec62p+35,                0x1.8p+0,   0x1.8d5a71a1cac2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa828p+17,                0x1.8p+1,   0x1.27f833ba873bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4bf6472a2p+35,                0x1.8p+0,   0x1.0b4c96f6eb22cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf048p+17,                0x1.8p+1,   0x1.7aa9a602d7e6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59753ac82p+35,                0x1.8p+0,    0x1.1bc3a98e013bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b92a8p+17,                0x1.8p+1,   0x1.478a9a87d4276p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf6c8p+17,                0x1.8p+1,   0x1.7ba907daa92a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9b1ed1a2p+35,                0x1.8p+0,   0x1.842970d42d134p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fedf28c82p+35,                0x1.8p+0,    0x1.fe4efa4cdd85p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96f28p+17,                0x1.8p+1,   0x1.01156b0d2d68ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76cff1992p+35,                0x1.8p+0,   0x1.40b0b349805bep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c38a8p+17,                0x1.8p+1,   0x1.5f329e224e896p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d0759aa2p+35,                0x1.8p+0,   0x1.202ce0584e6d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0938p+17,                0x1.8p+1,   0x1.34c7713b7ed5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.892556cc2p+35,                0x1.8p+0,   0x1.588149e9c1478p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6b78p+17,                0x1.8p+1,   0x1.e4a6fc4bf42a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3ea854b2p+35,                0x1.8p+0,   0x1.7c48df421aa52p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c81c56602p+35,                0x1.8p+0,    0x1.ae7f4cff649cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebd58p+17,                0x1.8p+1,   0x1.c5da7e5d3f48ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ece78p+17,                0x1.8p+1,   0x1.c8d2ab3988138p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6348p+17,                0x1.8p+1,   0x1.e32c7e37ad6fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca938p+17,                0x1.8p+1,   0x1.6fdec12b35b5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6769d192p+35,                0x1.8p+0,   0x1.da2d3aa9db4bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d645fc892p+35,                0x1.8p+0,   0x1.c2b403728829ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c188p+17,                0x1.8p+1,   0x1.0af70a9a939c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f793f0af2p+35,                0x1.8p+0,   0x1.f36b3f2681bdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8b08p+17,                0x1.8p+1,    0x1.bd3433e6f501p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.775c50562p+35,                0x1.8p+0,   0x1.4164eaea4a1ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4a6f65792p+35,                0x1.8p+0,   0x1.097505302237ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c34b2cd82p+35,                0x1.8p+0,    0x1.a7b20cb4d381p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.68c171752p+35,                0x1.8p+0,   0x1.2ed1f28fdff8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a11006452p+35,                0x1.8p+0,   0x1.786a3b34afd16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb158p+17,                0x1.8p+1,   0x1.7117f59cc344ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eccd8p+17,                0x1.8p+1,   0x1.c88a64ba0d2b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec583dbe2p+35,                0x1.8p+0,   0x1.e2cd44e5c35dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4f08p+17,                0x1.8p+1,    0x1.627889ec354dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a8351d372p+35,                0x1.8p+0,   0x1.82210aae05816p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4a28p+13,                  0x1p+2,   0x1.621a131b179b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bf38p+17,                0x1.8p+1,   0x1.0aaf28869757cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e392e9272p+35,                0x1.8p+0,   0x1.d5f54e780ebcap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f54d8p+17,                0x1.8p+1,   0x1.e092f3aab7032p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb008p+17,                0x1.8p+1,     0x1.f126d949bf1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bdc8p+17,                0x1.8p+1,   0x1.0a827fe6fd8f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1ad8p+17,                0x1.8p+1,   0x1.d639526892052p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5768p+13,                  0x1p+2,   0x1.9e75d3323cc88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.baa38p+17,                0x1.8p+1,   0x1.4ad51d675928cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.95196e7e2p+35,                0x1.8p+0,   0x1.6855f254bfaa4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdad8p+17,                0x1.8p+1,   0x1.f91093bfda452p+53,          0x1p-1, INEXACT)
T(RN,       0x1.610d68dd2p+35,                0x1.8p+0,   0x1.252c3f61ccfc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb4f22f82p+35,                0x1.8p+0,    0x1.b3088efabb4dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a746c35c2p+35,                0x1.8p+0,   0x1.80dbc9675eb18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc618p+17,                0x1.8p+1,   0x1.743afc70b162ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e39d8p+17,                0x1.8p+1,   0x1.af7ab57bd77a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4387b4802p+35,                0x1.8p+0,     0x1.012e0f19ec5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.99ec27102p+35,                0x1.8p+0,    0x1.6eca442ee766p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2488p+17,                0x1.8p+1,   0x1.3872f35e31858p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d567be632p+35,                0x1.8p+0,   0x1.c174ab6afc082p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95bd2a042p+35,                0x1.8p+0,   0x1.69307e2a5e8d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.729e9d562p+35,                0x1.8p+0,   0x1.3b530ba843c34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cf34d512p+35,                0x1.8p+0,   0x1.0c7e6c5f953aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a52efa302p+35,                0x1.8p+0,    0x1.7e01f4d64492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.77bc3c3a2p+35,                0x1.8p+0,   0x1.41e024f104074p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b0d1dca02p+35,                0x1.8p+0,    0x1.8df288054244p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc9b3f062p+35,                0x1.8p+0,   0x1.cbd687bf3a954p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8e10148e2p+35,                0x1.8p+0,   0x1.5efcf63bd43fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.442b8a052p+35,                0x1.8p+0,   0x1.01f181ee7476ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.deed8p+17,                0x1.8p+1,   0x1.a30dd61a63212p+53,          0x1p-1, INEXACT)
T(RN,       0x1.739fbb2e2p+35,                0x1.8p+0,   0x1.3c9b66b65b23cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ace881f2p+35,                0x1.8p+0,   0x1.45d4956c3babap+53,          0x1p-1, INEXACT)
T(RN,       0x1.60502dc42p+35,                0x1.8p+0,   0x1.2440aaa2d18a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd898p+17,                0x1.8p+1,   0x1.9f6a1076c99e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b46d8p+17,                0x1.8p+1,   0x1.3d19c2caade92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db508p+17,                0x1.8p+1,    0x1.99a407594a7fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b74e8p+17,                0x1.8p+1,   0x1.436adac831362p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a93a8p+17,                0x1.8p+1,   0x1.254f6b9fbdb26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ca14b022p+35,                0x1.8p+0,   0x1.482f88cea5cbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eaf98p+17,                0x1.8p+1,   0x1.c37a8616e64b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4df0b3c12p+35,                0x1.8p+0,   0x1.0db12ab7b1c72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.675de0db2p+35,                0x1.8p+0,   0x1.2d12af2dec88ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.69d4f9272p+35,                0x1.8p+0,   0x1.302d20ccaf436p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46517ba02p+35,                0x1.8p+0,    0x1.0482fb7d96a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d598p+17,                0x1.8p+1,   0x1.0d68cb82f30d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4533ec4e2p+35,                0x1.8p+0,   0x1.032d50d2c6684p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55b03fe62p+35,                0x1.8p+0,   0x1.1721f0274cb6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f56d8p+17,                0x1.8p+1,   0x1.e0ef01551a992p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c00fc962p+35,                0x1.8p+0,   0x1.1ee82f3dcbbb4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97868p+17,                0x1.8p+1,   0x1.022e4edea8ecap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dffb512a2p+35,                0x1.8p+0,   0x1.d0bb3f41331d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97dc8p+17,                0x1.8p+1,   0x1.02d1e4fa38cf4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bea78p+17,                0x1.8p+1,   0x1.53eb19dbdce78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9629cc0f2p+35,                0x1.8p+0,   0x1.69c196b069a9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a006d7d52p+35,                0x1.8p+0,   0x1.77037321980cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec648p+17,                0x1.8p+1,   0x1.c766d0a86f88cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.776173852p+35,                0x1.8p+0,   0x1.416b841542c6ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.35b8p+13,                  0x1p+2,    0x1.123bb5d1b0b5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca3a8p+17,                0x1.8p+1,   0x1.6f08bab43a626p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c3043542p+35,                0x1.8p+0,   0x1.0b92a3076fab8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8378p+17,                0x1.8p+1,   0x1.91af10cc0f728p+53,          0x1p-1, INEXACT)
T(RN,       0x1.85d366212p+35,                0x1.8p+0,   0x1.5426799bb3e4ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.442395112p+35,                0x1.8p+0,   0x1.01e802c5bff2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e760a96d2p+35,                0x1.8p+0,   0x1.db8398555abe6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fba75f0b2p+35,                0x1.8p+0,   0x1.f97e9a8c62a2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d1983f52p+35,                0x1.8p+0,   0x1.20435fe77228ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e2e8p+17,                0x1.8p+1,   0x1.0f0a1d9a74d02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.de798p+17,                0x1.8p+1,   0x1.a1dda14442336p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3f08p+17,                0x1.8p+1,    0x1.6020d3c4211dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e636baf2p+35,                0x1.8p+0,   0x1.0e3c2f368d1dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad468p+17,                0x1.8p+1,   0x1.2dc3b2080020ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7c68p+17,                0x1.8p+1,   0x1.e7b86c4928d8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.958b519e2p+35,                0x1.8p+0,   0x1.68edf13844f64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.567fdee32p+35,                0x1.8p+0,   0x1.1820810ad8e7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed5d8p+17,                0x1.8p+1,   0x1.ca1b0ff8fd2e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6b48p+17,                0x1.8p+1,   0x1.8dd6a3256907cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6e3d2f9c2p+35,                0x1.8p+0,   0x1.35c01c28fb998p+53,          0x1p-1, INEXACT)
T(RN,       0x1.71f9a16a2p+35,                0x1.8p+0,   0x1.3a8095662c454p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c5e899d22p+35,                0x1.8p+0,   0x1.ab62255ef8c9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4a18p+17,                0x1.8p+1,   0x1.1be6141f764eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.665553f22p+35,                0x1.8p+0,   0x1.2bc677c18175cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5a08p+17,                0x1.8p+1,    0x1.8b1c6a80558ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9dbdba612p+35,                0x1.8p+0,   0x1.73ed6378daacep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc148p+17,                0x1.8p+1,   0x1.7380569c62a9cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e08ee9b2p+35,                0x1.8p+0,   0x1.0dce857012af2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.981e8p+17,                0x1.8p+1,   0x1.034f9ed00c352p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dac104952p+35,                0x1.8p+0,   0x1.c928e1dce634ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4523fc032p+35,                0x1.8p+0,   0x1.031a433f7883ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cadb8p+17,                0x1.8p+1,   0x1.708c22def3934p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f05d8p+17,                0x1.8p+1,   0x1.d2836fc2b33e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6da8p+17,                0x1.8p+1,   0x1.426aebda4c506p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ee0df9db2p+35,                0x1.8p+0,   0x1.e551b4186f68ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5bd96b0a2p+35,                0x1.8p+0,   0x1.1eb741e28936cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.deb257192p+35,                0x1.8p+0,   0x1.ceddc7cd448bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8526b4712p+35,                0x1.8p+0,   0x1.53448a9358c12p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.50c848p+21,                0x1.4p+1,   0x1.6755837dd63c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fd65d93b2p+35,                0x1.8p+0,   0x1.fc1a0b23e0bcep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f28a8p+17,                0x1.8p+1,   0x1.d8acd5e43cd96p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc8601922p+35,                0x1.8p+0,   0x1.b4c2825adff1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a200e632p+35,                0x1.8p+0,   0x1.6f0ff03866082p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aee78p+17,                0x1.8p+1,   0x1.3136714780738p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff008p+17,                0x1.8p+1,     0x1.fd02fe40bfdp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.89e0f32b2p+35,                0x1.8p+0,   0x1.597800a01adeep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3468p+17,                0x1.8p+1,   0x1.5e940b745940ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd5b8p+17,                0x1.8p+1,   0x1.50f74fbf8a8b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.781a7d8b2p+35,                0x1.8p+0,   0x1.42594a4a21d2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea47438f2p+35,                0x1.8p+0,   0x1.dfc3ffdf8699ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f768p+17,                0x1.8p+1,   0x1.119009781351ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8408p+17,                0x1.8p+1,    0x1.234b4788d58cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7668p+17,                0x1.8p+1,   0x1.218b23beef76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f87c1caf2p+35,                0x1.8p+0,   0x1.f4c4c8a408c26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.563e739f2p+35,                0x1.8p+0,   0x1.17d042bd4ce46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4aa136382p+35,                0x1.8p+0,    0x1.09b10ef23785p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5a98p+13,                  0x1p+2,   0x1.ae105d861c608p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbce8p+17,                0x1.8p+1,   0x1.72d6dec3a1ce2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5161a2912p+35,                0x1.8p+0,   0x1.11df14be34dd2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9998p+17,                0x1.8p+1,   0x1.26142d3caf396p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2498p+17,                0x1.8p+1,   0x1.abef2a9a95226p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5f28p+17,                0x1.8p+1,   0x1.8beb863670b8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea0c8p+17,                0x1.8p+1,   0x1.c0edf399cfc84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aee88p+17,                0x1.8p+1,   0x1.31389143a6238p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3688p+17,                0x1.8p+1,   0x1.3ae22ccea5fb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0558p+17,                0x1.8p+1,   0x1.1349774fc060ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ded08p+17,                0x1.8p+1,    0x1.a2c1bb123527p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4468060e2p+35,                0x1.8p+0,   0x1.0239b65be3d04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73a323972p+35,                0x1.8p+0,   0x1.3c9fc19aa94aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad140e572p+35,                0x1.8p+0,   0x1.88cc6ff7b8a2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b811f002p+35,                0x1.8p+0,     0x1.5b9c195ed46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0118p+17,                0x1.8p+1,   0x1.33b161a39e3bep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2e18p+17,                0x1.8p+1,   0x1.d9a47675f65aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.be0730f02p+35,                0x1.8p+0,    0x1.a04d45beeb1ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98a18p+17,                0x1.8p+1,   0x1.0449a360820eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f6a8p+17,                0x1.8p+1,   0x1.117855da9ef36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d01c8p+17,                0x1.8p+1,   0x1.7d5a3cb03d9b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efd38p+17,                0x1.8p+1,   0x1.d0fec1dd36f1cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.afde8p+17,                0x1.8p+1,   0x1.3344796c34492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f4a3518d2p+35,                0x1.8p+0,   0x1.ef0d460a6da26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf8e8p+17,                0x1.8p+1,   0x1.55fb900660222p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe8944aa2p+35,                0x1.8p+0,   0x1.fdce4de53ab2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c348p+17,                0x1.8p+1,   0x1.0b2d79156e8fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6288p+17,                0x1.8p+1,   0x1.1f00a801a3ff8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f80506012p+35,                0x1.8p+0,   0x1.f41381f1593f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ad306812p+35,                0x1.8p+0,   0x1.316db417f750ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7eb1af252p+35,                0x1.8p+0,   0x1.4adbd77b4172ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a33e85892p+35,                0x1.8p+0,   0x1.7b5f511779b62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb828p+17,                0x1.8p+1,   0x1.f2a5a7a742ebep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8ee8p+17,                0x1.8p+1,   0x1.470508d886f42p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5183bb6e2p+35,                0x1.8p+0,   0x1.12089a5ab8cbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9d68p+17,                0x1.8p+1,   0x1.490a49f56813ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2718p+17,                0x1.8p+1,   0x1.832147555e3dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9308p+17,                0x1.8p+1,    0x1.942bcc9a6c19p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0e026312p+35,                0x1.8p+0,   0x1.baf739bc52c92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9d9c1672p+35,                0x1.8p+0,   0x1.f6cdbce0263b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffe5005b2p+35,                0x1.8p+0,   0x1.ffd781115d98ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db4a8p+17,                0x1.8p+1,   0x1.9994843a305d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.851c3e4c2p+35,                0x1.8p+0,   0x1.5336dc6614888p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.498d006a2p+35,                0x1.8p+0,   0x1.086463b2645acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e739a3772p+35,                0x1.8p+0,   0x1.db4a7d4add46ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cec388e32p+35,                0x1.8p+0,   0x1.b7f366b757a7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b713bd762p+35,                0x1.8p+0,   0x1.969bb804be90cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b9fba9222p+35,                0x1.8p+0,   0x1.9aa6ca6188f7cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ee89c7492p+35,                0x1.8p+0,   0x1.e6082b1a5b41ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e0035a72p+35,                0x1.8p+0,   0x1.5ee7f8cddfb36p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6eba66792p+35,                0x1.8p+0,   0x1.365f03d53f57ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6d18p+17,                0x1.8p+1,   0x1.8e202fe6649fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.767f88b32p+35,                0x1.8p+0,   0x1.404986181c0dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e4f1058d2p+35,                0x1.8p+0,   0x1.d7f40bffd0226p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b26c4e912p+35,                0x1.8p+0,   0x1.90291e4dd35d2p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.663308p+21,                0x1.4p+1,   0x1.a33716a5c1db8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.697529c92p+35,                0x1.8p+0,   0x1.2fb4582bb411ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d86e8p+17,                0x1.8p+1,   0x1.923b7bf1a21c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d89e8p+17,                0x1.8p+1,   0x1.92b622ba8d0d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c4ec66292p+35,                0x1.8p+0,   0x1.a9fe24c511822p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4228p+17,                0x1.8p+1,   0x1.6095c0064ed9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af97a3d22p+35,                0x1.8p+0,   0x1.8c417b343289cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e206b74d2p+35,                0x1.8p+0,   0x1.d3b435b75a9a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.854617b82p+35,                0x1.8p+0,    0x1.536d97501a15p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9598p+17,                0x1.8p+1,   0x1.9494e4f0004d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a30bda7b2p+35,                0x1.8p+0,   0x1.7b1a8cfda414ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d099a5b52p+35,                0x1.8p+0,   0x1.ba9278c8914f6p+53,          0x1p-1, INEXACT)
T(RN,            0x1.50f8p+13,                  0x1p+2,    0x1.803ecefe237cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94540e832p+35,                0x1.8p+0,   0x1.674eb97c74cc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db3c8p+17,                0x1.8p+1,   0x1.997053ccd4514p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a2899e672p+35,                0x1.8p+0,   0x1.7a69df76da9b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a76cf4562p+35,                0x1.8p+0,   0x1.810fe0f5e7634p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d63d8ce2p+35,                0x1.8p+0,   0x1.209f75ee4067cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.97568p+17,                0x1.8p+1,   0x1.01d31f0b0cdbap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49b1e91a2p+35,                0x1.8p+0,   0x1.0890cfaf9a934p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0968p+17,                0x1.8p+1,   0x1.13ca7b61fef7ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a87a4d982p+35,                0x1.8p+0,    0x1.827f86354ec9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9aea6c792p+35,                0x1.8p+0,   0x1.701fbf6dd1e82p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4578p+17,                0x1.8p+1,   0x1.1b50588954f88p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf737d362p+35,                0x1.8p+0,   0x1.a24bb506c3e8cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fee8b432p+35,                0x1.8p+0,   0x1.6176867e411bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4528p+17,                0x1.8p+1,   0x1.87d3be64261aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fdabae072p+35,                0x1.8p+0,   0x1.fc8289afea58ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1d48p+17,                0x1.8p+1,   0x1.5b387cdbd9fdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2778p+17,                0x1.8p+1,   0x1.5cb27a5782de8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac328p+17,                0x1.8p+1,   0x1.2b7f1a6c4404ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6b88p+17,                0x1.8p+1,   0x1.66ab5a49a65a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.82baf08f2p+35,                0x1.8p+0,   0x1.501b52924fc66p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f3161cc02p+35,                0x1.8p+0,    0x1.ecc091a836c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6608p+17,                0x1.8p+1,    0x1.b6e9e1ebf8b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.916214722p+35,                0x1.8p+0,   0x1.63638586d925cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.765f09982p+35,                0x1.8p+0,    0x1.401fd6b47ab7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2c08p+17,                0x1.8p+1,    0x1.39763c512784p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef3cb60e2p+35,                0x1.8p+0,   0x1.e7100b43d5d04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de9744862p+35,                0x1.8p+0,   0x1.ceb6844863dacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f56d1f282p+35,                0x1.8p+0,    0x1.f038b7f215a1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8608p+17,                0x1.8p+1,    0x1.9217baa88612p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad76f2522p+35,                0x1.8p+0,   0x1.895442f506864p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e70ad1932p+35,                0x1.8p+0,   0x1.db05fc7aa94e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98758p+17,                0x1.8p+1,   0x1.03f597c4f8b6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bdd78p+17,                0x1.8p+1,   0x1.5211148576c08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2098p+17,                0x1.8p+1,   0x1.821e8e5fb7366p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0358p+17,                0x1.8p+1,   0x1.130a0220f38aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1ea8p+17,                0x1.8p+1,   0x1.aaf27adc35ab6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9b67aaa2p+35,                0x1.8p+0,   0x1.deef8a5d8f0d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f02a8p+17,                0x1.8p+1,   0x1.d1f3b220fff76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6228p+17,                0x1.8p+1,   0x1.e2f88bf22939ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0bd8p+17,                0x1.8p+1,   0x1.35216ac2de802p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8946a3ef2p+35,                0x1.8p+0,   0x1.58ad106c72da6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b37f8p+17,                0x1.8p+1,    0x1.3b1415e5b9a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.864d989c2p+35,                0x1.8p+0,   0x1.54c6765f4a398p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9ca8p+17,                0x1.8p+1,   0x1.48ef7b754e556p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.88b6f5542p+35,                0x1.8p+0,   0x1.57f03e012e6b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3cb8p+17,                0x1.8p+1,   0x1.868146fc86704p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed6d8p+17,                0x1.8p+1,   0x1.ca47a33a15192p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d75a8p+17,                0x1.8p+1,   0x1.8f7c201a49a86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca9a8p+17,                0x1.8p+1,   0x1.6fef9a0e98646p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.607b51b92p+35,                0x1.8p+0,   0x1.24765a22feffep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8483aa32p+35,                0x1.8p+0,   0x1.c59810f723102p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4fb8p+17,                0x1.8p+1,   0x1.897c877b72d94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97e28p+17,                0x1.8p+1,   0x1.02dd51481f6dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8c48p+17,                0x1.8p+1,   0x1.6b88e2f47efacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b50dbfc22p+35,                0x1.8p+0,   0x1.93cd04b5e52c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d258p+17,                0x1.8p+1,   0x1.0d032b2ad56fap+53,          0x1p-1, INEXACT)
T(RN,       0x1.bdffb9762p+35,                0x1.8p+0,   0x1.a042d1aa2bef4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.579489122p+35,                0x1.8p+0,   0x1.1974319c1cbe4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff7d8p+17,                0x1.8p+1,   0x1.fe78e3c0e5a42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1b68p+17,                0x1.8p+1,   0x1.81506629529dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1745ad72p+35,                0x1.8p+0,   0x1.a51baefb7632ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.de598p+17,                0x1.8p+1,   0x1.a189cff0b6bd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae278p+17,                0x1.8p+1,   0x1.2f9f2acc48cf8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec292d0a2p+35,                0x1.8p+0,   0x1.e2880bcc48094p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9398p+17,                0x1.8p+1,   0x1.ebf10e1d6bd76p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c3275af2p+35,                0x1.8p+0,   0x1.1f255fc349a26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab408p+17,                0x1.8p+1,    0x1.29846edac61cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.797a36302p+35,                0x1.8p+0,    0x1.441de148a4eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f235e782p+35,                0x1.8p+0,    0x1.60694eb82863p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cbadded32p+35,                0x1.8p+0,   0x1.b38f2d0a4189ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d396d9572p+35,                0x1.8p+0,   0x1.bed99c46d5fd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2788p+17,                0x1.8p+1,   0x1.38da98f6720e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3916b632p+35,                0x1.8p+0,   0x1.91be60b707a82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b7f30812p+35,                0x1.8p+0,   0x1.70e7ba9b2690ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.84e633752p+35,                0x1.8p+0,   0x1.52f033ad4e476p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a52989132p+35,                0x1.8p+0,   0x1.7dfa8d8f1d3e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0ab8p+17,                0x1.8p+1,   0x1.a7a4d42437fa4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8e28p+17,                0x1.8p+1,   0x1.bdbce8e6831dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8f48p+17,                0x1.8p+1,   0x1.eb279add0833cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1288p+17,                0x1.8p+1,   0x1.a8efacce090f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.990900712p+35,                0x1.8p+0,   0x1.6d998e7bdcbeep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2f28p+17,                0x1.8p+1,   0x1.adb1a4fec1a8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99418p+17,                0x1.8p+1,   0x1.057bdaa4f49cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc8d97ec2p+35,                0x1.8p+0,   0x1.b4cd4d95ac648p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea828p+17,                0x1.8p+1,   0x1.c2328d93b33bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad4cd2322p+35,                0x1.8p+0,   0x1.891a65440e8dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2388p+17,                0x1.8p+1,   0x1.170beadf72828p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f5f5b9c22p+35,                0x1.8p+0,   0x1.f1038d2cce93cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3a18p+17,                0x1.8p+1,   0x1.5f684b80629eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.73fbc3bd2p+35,                0x1.8p+0,   0x1.3d110acfa2786p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c75b8p+17,                0x1.8p+1,   0x1.682d99cdd26b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f82c8p+17,                0x1.8p+1,   0x1.e8e0e7c44c8e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4f58p+17,                0x1.8p+1,   0x1.3e429144454eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.738994e52p+35,                0x1.8p+0,   0x1.3c7f18e38f7aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.713eb57b2p+35,                0x1.8p+0,   0x1.39925bc0b54b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.988a8p+17,                0x1.8p+1,   0x1.041db252eaf96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d21d8p+17,                0x1.8p+1,   0x1.82504684b1722p+53,          0x1p-1, INEXACT)
T(RN,       0x1.88a0305a2p+35,                0x1.8p+0,   0x1.57d254ef801b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb1c8p+17,                0x1.8p+1,   0x1.c3db1aa2ddab4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad088p+17,                0x1.8p+1,   0x1.2d4104a82f098p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df3c8p+17,                0x1.8p+1,   0x1.a3dd5756b9114p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6088p+17,                0x1.8p+1,   0x1.1ebf690ed3b98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.876ded9e2p+35,                0x1.8p+0,   0x1.564059bcdb764p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d57151a32p+35,                0x1.8p+0,   0x1.c1826c18f80fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a95d8p+17,                0x1.8p+1,   0x1.2597dea05e6e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9cf2aa682p+35,                0x1.8p+0,    0x1.72dbb5963d97p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.effb8p+17,                0x1.8p+1,   0x1.d16f54bd6ce94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f0c8p+17,                0x1.8p+1,   0x1.10bedb8f5ab84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f5cf0ad2p+35,                0x1.8p+0,   0x1.4bba073742666p+53,          0x1p-1, INEXACT)
T(RN,       0x1.99c693422p+35,                0x1.8p+0,   0x1.6e97d5eff55c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa0978832p+35,                0x1.8p+0,   0x1.f714e2da31f3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.53fe2ff52p+35,                0x1.8p+0,   0x1.150eb4db07576p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0278p+17,                0x1.8p+1,   0x1.7d755ae9332f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.649221352p+35,                0x1.8p+0,   0x1.2990f7d0e0c0ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a9d8p+17,                0x1.8p+1,   0x1.08191c1ff94a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d66a686a2p+35,                0x1.8p+0,   0x1.c2e86044235acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c23d8p+17,                0x1.8p+1,   0x1.5c2bdb13c0882p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a8af1ebb2p+35,                0x1.8p+0,   0x1.82c7ab7a36f32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3f68p+17,                0x1.8p+1,   0x1.602eda4581e9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab4f8p+17,                0x1.8p+1,    0x1.29a3c5eb06bfp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3208p+17,                0x1.8p+1,    0x1.5e3b82ff1e16p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef8190a82p+35,                0x1.8p+0,    0x1.e775a2468111p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53a150802p+35,                0x1.8p+0,     0x1.149d36f8ae3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a168e592p+35,                0x1.8p+0,   0x1.307fd775cdb3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4fb8p+17,                0x1.8p+1,   0x1.b3262a4065d94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6a1331382p+35,                0x1.8p+0,    0x1.307b99372e5bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.efefc52c2p+35,                0x1.8p+0,   0x1.e8184ade40238p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b061cb52p+35,                0x1.8p+0,   0x1.5af9faa3bd2f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef818p+17,                0x1.8p+1,   0x1.d01833ed8c28ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5e815402p+35,                0x1.8p+0,    0x1.c22d0bd5b3f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0988p+17,                0x1.8p+1,   0x1.d329de6fc4748p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa458p+17,                0x1.8p+1,   0x1.2779487a28b5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.af668p+17,                0x1.8p+1,   0x1.32449e4f2cf6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edda8p+17,                0x1.8p+1,   0x1.cb779b5a84206p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfec8p+17,                0x1.8p+1,   0x1.7ce3f664dfc24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb6e8p+17,                0x1.8p+1,   0x1.71eec8c4782c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e71e536c2p+35,                0x1.8p+0,   0x1.db2286af3e4b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0608p+17,                0x1.8p+1,    0x1.57ddd5c1c192p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7ea8p+17,                0x1.8p+1,   0x1.90eab1b72acb6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3c28p+17,                0x1.8p+1,   0x1.866abd6eee97ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1e28p+17,                0x1.8p+1,   0x1.81bda6c37f4dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.515306272p+35,                0x1.8p+0,   0x1.11cd4a7ac25cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.96ef8p+17,                0x1.8p+1,    0x1.010fbb923bedp+53,          0x1p-1, INEXACT)
T(RN,            0x1.50e8p+13,                  0x1p+2,   0x1.7ff5d98540968p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6db8ad42p+35,                0x1.8p+0,   0x1.f2590848237b8p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5e58p+13,                  0x1p+2,   0x1.c0fb0a983bb18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ea28p+17,                0x1.8p+1,   0x1.0fee1863c311ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.931629d72p+35,                0x1.8p+0,   0x1.65a74e1357ed6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e758db4f2p+35,                0x1.8p+0,   0x1.db782c28cc91ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b938p+17,                0x1.8p+1,   0x1.09f4e2c699e5cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc378p+17,                0x1.8p+1,   0x1.f4bbea82ee328p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4dd8p+17,                0x1.8p+1,   0x1.3e0e2328d0562p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a17a8p+17,                0x1.8p+1,   0x1.15904657b7de6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.498695602p+35,                0x1.8p+0,    0x1.085caa77a304p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58f522a32p+35,                0x1.8p+0,   0x1.1b25e4408fefep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.501383e82p+35,                0x1.8p+0,    0x1.1048a39b2927p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9f08p+17,                0x1.8p+1,    0x1.c0a1045e603dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.587bb21c2p+35,                0x1.8p+0,   0x1.1a906c4b36568p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ebe48p+17,                0x1.8p+1,   0x1.c6040607fbf0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e53527fe2p+35,                0x1.8p+0,   0x1.d8578669e6ba4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b3ad2342p+35,                0x1.8p+0,   0x1.5b3f6f58af808p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e3835c9b2p+35,                0x1.8p+0,   0x1.d5dea3f26c6f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fcb45ca52p+35,                0x1.8p+0,   0x1.fb1094cfacbd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c7c7682b2p+35,                0x1.8p+0,   0x1.ae0714b9323eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab098p+17,                0x1.8p+1,   0x1.291197c707666p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96cf8p+17,                0x1.8p+1,    0x1.00d31ba9f8e7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f11e8p+17,                0x1.8p+1,   0x1.d4a471257a652p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9dca8p+17,                0x1.8p+1,   0x1.0e45fb3e83156p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6d98p+17,                0x1.8p+1,   0x1.8e347ba23d156p+53,          0x1p-1, INEXACT)
T(RN,       0x1.457edaea2p+35,                0x1.8p+0,   0x1.0386e9f082354p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a83b8p+17,                0x1.8p+1,   0x1.2340fb1675354p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6e98p+17,                0x1.8p+1,   0x1.e537a6d31bb06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0d9e10a2p+35,                0x1.8p+0,   0x1.7820f025e8894p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f29e8p+17,                0x1.8p+1,   0x1.d8e5bb3fa8ed2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1c48p+17,                0x1.8p+1,   0x1.aa8d83a3eaaacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.679f3cc52p+35,                0x1.8p+0,   0x1.2d64d59972216p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bfe28p+17,                0x1.8p+1,   0x1.56bc42761aedep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec768p+17,                0x1.8p+1,   0x1.c798c3f4ef41ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d11c8p+17,                0x1.8p+1,   0x1.7fd2a683fecb4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5508p+17,                0x1.8p+1,    0x1.3f0991c3db5fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df9e8p+17,                0x1.8p+1,   0x1.a4df1fb4a0dd2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5fcd29542p+35,                0x1.8p+0,   0x1.239db3d959eb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba0c62a32p+35,                0x1.8p+0,   0x1.9abe1997d8102p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e7e301e2p+35,                0x1.8p+0,   0x1.74f1053ec6e64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb5d8p+17,                0x1.8p+1,   0x1.71c5b9a42dce2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad908p+17,                0x1.8p+1,    0x1.2e5fdbb1eeebp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a45738fd2p+35,                0x1.8p+0,   0x1.7cdc92d023e06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1058p+17,                0x1.8p+1,   0x1.35bbd1767fd9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c15e8p+17,                0x1.8p+1,   0x1.5a27847d35d12p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e2f585aa2p+35,                0x1.8p+0,   0x1.d50ff198c612cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f27c237b2p+35,                0x1.8p+0,   0x1.ebdc9bbd70f4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6718p+17,                0x1.8p+1,   0x1.e3dca4480afdep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6bdd0252p+35,                0x1.8p+0,   0x1.f22cd74ae5ad6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a6f8p+17,                0x1.8p+1,    0x1.07c063ed0e95p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9a18p+17,                0x1.8p+1,   0x1.4893ef9141beep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b92435a02p+35,                0x1.8p+0,    0x1.997aaa8fcf1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef978p+17,                0x1.8p+1,   0x1.d056079822948p+53,          0x1p-1, INEXACT)
T(RN,       0x1.af0c21042p+35,                0x1.8p+0,   0x1.8b8168be352d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7dd8p+17,                0x1.8p+1,   0x1.44a7160626662p+53,          0x1p-1, INEXACT)
T(RN,           0x1.981e8p+17,                0x1.8p+1,   0x1.034f9ed00c352p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0d162f12p+35,                0x1.8p+0,   0x1.a436bab618712p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca7cf6c12p+35,                0x1.8p+0,   0x1.b1de185df998ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ef5c5452p+35,                0x1.8p+0,   0x1.22920c9fab4eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9183ba6c2p+35,                0x1.8p+0,   0x1.639036d199ab8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6719314d2p+35,                0x1.8p+0,   0x1.2cbc62609fda6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8488p+17,                0x1.8p+1,   0x1.235bc25ab3a58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fef68p+17,                0x1.8p+1,   0x1.fce51cbffb79ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de5399702p+35,                0x1.8p+0,    0x1.ce546533364ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50eb28c72p+35,                0x1.8p+0,   0x1.114eded275b0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5763643b2p+35,                0x1.8p+0,   0x1.1937d0d1cea32p+53,          0x1p-1, INEXACT)
T(RN,       0x1.747d5e572p+35,                0x1.8p+0,   0x1.3db6cdc762a2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ccf0402e2p+35,                0x1.8p+0,   0x1.b559afc153bc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d49903392p+35,                0x1.8p+0,   0x1.c04be13020afep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0d58p+17,                0x1.8p+1,   0x1.a813eb0929b8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.69a438bb2p+35,                0x1.8p+0,   0x1.2fefa940be332p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9848p+17,                0x1.8p+1,   0x1.bf789761a25ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7740ea9e2p+35,                0x1.8p+0,   0x1.4141bb8b88a9cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d08c4fbb2p+35,                0x1.8p+0,   0x1.ba7f6ac148ecep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.df03936a2p+35,                0x1.8p+0,   0x1.cf539faf7b854p+53,          0x1p-1, INEXACT)
T(RN,       0x1.514948b82p+35,                0x1.8p+0,    0x1.11c16ebb5f8bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7283640e2p+35,                0x1.8p+0,   0x1.3b304e1035104p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f256a5702p+35,                0x1.8p+0,    0x1.eba51f01c536p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad457ee82p+35,                0x1.8p+0,    0x1.8910558d1b47p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3098p+17,                0x1.8p+1,   0x1.18af1566e9e66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1809f512p+35,                0x1.8p+0,   0x1.8ee3a5789e852p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfd68p+17,                0x1.8p+1,   0x1.7cadc904e933ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da8c8p+17,                0x1.8p+1,   0x1.97aa1680cf604p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.44d8p+13,                  0x1p+2,   0x1.4bdad77b2a0f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6ca8p+17,                0x1.8p+1,   0x1.4247a95e86456p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2d78p+17,                0x1.8p+1,   0x1.ad69978763b08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5108p+17,                0x1.8p+1,    0x1.89b165977853p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.438ae2812p+35,                0x1.8p+0,   0x1.0131d9b5ced0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b3662a62p+35,                0x1.8p+0,   0x1.31eb333800114p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c69a8p+17,                0x1.8p+1,   0x1.666461bedda46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f41e8p+17,                0x1.8p+1,   0x1.dd2d9830c7752p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.563cd1052p+35,                0x1.8p+0,   0x1.17ce4160d9696p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e647d4952p+35,                0x1.8p+0,   0x1.d9e8d545e3cb6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c67d6a562p+35,                0x1.8p+0,   0x1.ac3463fa7e5ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8158aa392p+35,                0x1.8p+0,   0x1.4e4de2eaff702p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5f68p+17,                0x1.8p+1,   0x1.64e10dd78949ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64455eac2p+35,                0x1.8p+0,   0x1.2930e6c6546c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e086c8062p+35,                0x1.8p+0,   0x1.d185dab1cd0acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9e58p+17,                0x1.8p+1,   0x1.ede8284575b3ap+53,          0x1p-1, INEXACT)
T(RN,     0x1.ca2ef639cc4p+42,                0x1.4p+0,   0x1.76bc28a1856cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e66ed0db2p+35,                0x1.8p+0,   0x1.da21d3f991772p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9878p+17,                0x1.8p+1,   0x1.ecd50a58f6318p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ea1c36082p+35,                0x1.8p+0,    0x1.df84cf76358dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a73665c12p+35,                0x1.8p+0,   0x1.80c5779a89872p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eacc8p+17,                0x1.8p+1,   0x1.c2fe6d9d0dac4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.813ea3f02p+35,                0x1.8p+0,    0x1.4e2c05c4d1c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f48f8p+17,                0x1.8p+1,    0x1.de715469b37bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.49419aa72p+35,                0x1.8p+0,   0x1.0809acbfbcecap+53,          0x1p-1, INEXACT)
T(RN,       0x1.76098bf32p+35,                0x1.8p+0,   0x1.3fb23562cfda2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c19b8p+17,                0x1.8p+1,   0x1.5ab48f3263174p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3ff8p+17,                0x1.8p+1,     0x1.87038f2a57cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8488p+17,                0x1.8p+1,   0x1.6a61218779a58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5a905502p+35,                0x1.8p+0,    0x1.94a447af4342p+53,          0x1p-1, INEXACT)
T(RN,           0x1.baed8p+17,                0x1.8p+1,   0x1.4b7b25f14a612p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8905cba72p+35,                0x1.8p+0,   0x1.5857d4a3730cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bddf8p+17,                0x1.8p+1,    0x1.522347a2821ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.540656212p+35,                0x1.8p+0,   0x1.1518aaebfe1b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c7253592p+35,                0x1.8p+0,   0x1.0be2788ee753ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6dd0f5bc2p+35,                0x1.8p+0,   0x1.3536d9827b0d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.991917472p+35,                0x1.8p+0,   0x1.6daf20e1fc7f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5df8p+17,                0x1.8p+1,    0x1.e237518bcc9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6ef5a7022p+35,                0x1.8p+0,   0x1.36aa3f228c4bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edd28p+17,                0x1.8p+1,   0x1.cb61478357a2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4828p+17,                0x1.8p+1,   0x1.de4c0e89221bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcaa8p+17,                0x1.8p+1,   0x1.9d2527cc478f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3ec8p+17,                0x1.8p+1,   0x1.b04e4b5127824p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4c28p+17,                0x1.8p+1,   0x1.620c95299847ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c73bcf842p+35,                0x1.8p+0,   0x1.ad419387659d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9bf8p+17,                0x1.8p+1,    0x1.c01a76ddb5d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8f98p+17,                0x1.8p+1,   0x1.24c8fed1baeb6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd5a8p+17,                0x1.8p+1,   0x1.50f50aab6bc86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9da38p+17,                0x1.8p+1,   0x1.0df996e146b8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc288p+17,                0x1.8p+1,   0x1.9bd37cb5a21f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc82366b2p+35,                0x1.8p+0,   0x1.b4bd1cce8bf6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ddd21d732p+35,                0x1.8p+0,   0x1.cd98b6cca30a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45e4f1ca2p+35,                0x1.8p+0,   0x1.04010ca664014p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7ec8p+17,                0x1.8p+1,   0x1.44c84dc223424p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd0f0dda2p+35,                0x1.8p+0,   0x1.9ef20fd8708b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0598p+17,                0x1.8p+1,   0x1.d278289aa11d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac3d8p+17,                0x1.8p+1,   0x1.2b962fd979682p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83e622a52p+35,                0x1.8p+0,   0x1.51a1a9b34882ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9640f4ab2p+35,                0x1.8p+0,   0x1.69e087c13faeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3720fde2p+35,                0x1.8p+0,   0x1.9192ff4aa68e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4387b4802p+35,                0x1.8p+0,     0x1.012e0f19ec5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c93f8p+17,                0x1.8p+1,    0x1.6caee0993fbcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e827c6882p+35,                0x1.8p+0,    0x1.dca71c98c95dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9e58p+17,                0x1.8p+1,   0x1.6e3ca04ab4b3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d649d1ee2p+35,                0x1.8p+0,   0x1.c2b9864a3ddbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3078p+17,                0x1.8p+1,   0x1.5e014c4cf2f98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1b68p+17,                0x1.8p+1,   0x1.aa6854fe8d9dap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.30f8p+13,                  0x1p+2,    0x1.01cb0f87f3fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2528p+17,                0x1.8p+1,   0x1.5c5c9526b9baep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adbb8p+17,                0x1.8p+1,   0x1.2ebab2b068bd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e7bae582p+35,                0x1.8p+0,    0x1.5f8b50357a11p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d1696fc2p+35,                0x1.8p+0,   0x1.48c7487011ea8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f25d8p+17,                0x1.8p+1,   0x1.d82ce2866c9e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5ab8p+17,                0x1.8p+1,   0x1.6430494d49ea4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3122c1c2p+35,                0x1.8p+0,   0x1.910e6125c8168p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9faf2b12p+35,                0x1.8p+0,   0x1.df53ff4ef0b92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6268p+17,                0x1.8p+1,   0x1.1efc93c843daap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f928p+17,                0x1.8p+1,   0x1.11c75c901bd6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6439b1192p+35,                0x1.8p+0,   0x1.29224a2b41cbep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f67f8p+17,                0x1.8p+1,    0x1.e40517c68638p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e78b8p+17,                0x1.8p+1,   0x1.ba154b2e0b644p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7da7954e2p+35,                0x1.8p+0,   0x1.4982fd3bd6c84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1f98p+17,                0x1.8p+1,   0x1.ab1a5a18291b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d22e8p+17,                0x1.8p+1,   0x1.827a8ccbdc902p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4ec8p+17,                0x1.8p+1,   0x1.626f25dafeb24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fa98p+17,                0x1.8p+1,   0x1.11f4d41c85f46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4ef4f2f02p+35,                0x1.8p+0,    0x1.0eecac021c26p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7caf16c62p+35,                0x1.8p+0,   0x1.484160b0f03d4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffd08p+17,                0x1.8p+1,    0x1.ff718d37f757p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d13a8p+17,                0x1.8p+1,   0x1.801cf08ec9326p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.df2098572p+35,                0x1.8p+0,   0x1.cf7dbac6661d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aae48p+17,                0x1.8p+1,   0x1.28c466da58c0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c334a4da2p+35,                0x1.8p+0,   0x1.a79252367514cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1f38p+17,                0x1.8p+1,   0x1.81e7e257cf77cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6278p+17,                0x1.8p+1,   0x1.6554aa65fd4f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb658p+17,                0x1.8p+1,   0x1.4c88da3de7bbap+53,          0x1p-1, INEXACT)
T(RN,       0x1.530d257f2p+35,                0x1.8p+0,   0x1.13e846f728d7ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a67b30942p+35,                0x1.8p+0,   0x1.7fc645c601dc8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e75cc25c2p+35,                0x1.8p+0,   0x1.db7de23939118p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac5b36a82p+35,                0x1.8p+0,    0x1.87ceb94d052fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3dc8p+17,                0x1.8p+1,   0x1.86abdb65c00f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b81909d82p+35,                0x1.8p+0,    0x1.9806e4beba61p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3738p+13,                  0x1p+2,    0x1.1795a338d3cfp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fa66f0492p+35,                0x1.8p+0,   0x1.f7a04b546d61ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1548p+17,                0x1.8p+1,   0x1.a9644af79265cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8448p+17,                0x1.8p+1,   0x1.bc0d49cdad62cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dbad8p+17,                0x1.8p+1,   0x1.9a94a9d362e52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f18c8p+17,                0x1.8p+1,   0x1.d5dbceaed6b04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff3114ec2p+35,                0x1.8p+0,   0x1.fec9bec025448p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe9d8p+17,                0x1.8p+1,   0x1.fbdb5faf6e0a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6688p+17,                0x1.8p+1,   0x1.8d160dce868b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e129ffe2p+35,                0x1.8p+0,   0x1.0dda43ec1445cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a980b1602p+35,                0x1.8p+0,    0x1.83e61c132d84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5d38ded2p+35,                0x1.8p+0,   0x1.94df45d42931ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa6e8p+17,                0x1.8p+1,   0x1.27ce92db9c7c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d348p+17,                0x1.8p+1,   0x1.0d207941e1bfcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2208p+17,                0x1.8p+1,    0x1.16dbe35f1fe6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffd08p+17,                0x1.8p+1,    0x1.ff718d37f757p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64f2f5c02p+35,                0x1.8p+0,    0x1.2a0a35ede828p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c240dcd2p+35,                0x1.8p+0,   0x1.3317a8ce9aea6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96a48p+17,                0x1.8p+1,   0x1.0081b3cd6134cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d37e8p+17,                0x1.8p+1,   0x1.85c091474ce72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98af8p+17,                0x1.8p+1,    0x1.0464650c8b41p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a4dbd282p+35,                0x1.8p+0,    0x1.5a072b1aad9fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7591ec742p+35,                0x1.8p+0,   0x1.3f18e40146288p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0468p+17,                0x1.8p+1,   0x1.a699fecec030ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e8db81222p+35,                0x1.8p+0,   0x1.ddae72799e084p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de6121ac2p+35,                0x1.8p+0,   0x1.ce6803e80c738p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a1da49ed2p+35,                0x1.8p+0,   0x1.797c3014524e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8c6786432p+35,                0x1.8p+0,   0x1.5ccc0663f7bbep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5068p+17,                0x1.8p+1,   0x1.8998382fedb4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.81c7bdd92p+35,                0x1.8p+0,   0x1.4ede78fe02dc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d851d5632p+35,                0x1.8p+0,   0x1.c5a5e738df17ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb978p+17,                0x1.8p+1,   0x1.c52ef10229d48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.802942402p+35,                0x1.8p+0,    0x1.4cc35d18bb28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4218p+17,                0x1.8p+1,   0x1.3c74367ba476ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f93ebdd62p+35,                0x1.8p+0,   0x1.f5e6afc7fa734p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f63e8p+17,                0x1.8p+1,   0x1.e3495bc15d8b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd7375fe2p+35,                0x1.8p+0,   0x1.cd0f948ff1fa4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.440888282p+35,                0x1.8p+0,    0x1.01c7ba934dbfp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae9f8p+17,                0x1.8p+1,    0x1.309d8c46bb3ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8af9d0bb2p+35,                0x1.8p+0,   0x1.5ae9c7241eccep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9eba5ce2p+35,                0x1.8p+0,   0x1.f6e86a549e87cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.86ada9212p+35,                0x1.8p+0,   0x1.55444ddb50bb2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff908p+17,                0x1.8p+1,    0x1.feb1c8d3164bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3d21b3d2p+35,                0x1.8p+0,   0x1.bf2e908efde86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c4f991272p+35,                0x1.8p+0,   0x1.aa10b8bc63bcap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a05d658d2p+35,                0x1.8p+0,   0x1.7778813a03ddap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2aa8p+17,                0x1.8p+1,   0x1.acf192fcc7af6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.955b43d92p+35,                0x1.8p+0,   0x1.68adcc7afbe3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bce48p+17,                0x1.8p+1,   0x1.4fe97af03a20cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f126f6cf2p+35,                0x1.8p+0,   0x1.e9e3fbdcbe01ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd718p+17,                0x1.8p+1,   0x1.76d0449e49cdep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0ab8p+17,                0x1.8p+1,   0x1.d35f7fa6eafa4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0278p+17,                0x1.8p+1,   0x1.7d755ae9332f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.636af2a72p+35,                0x1.8p+0,   0x1.281fc35f67ecap+53,          0x1p-1, INEXACT)
T(RN,           0x1.96a68p+17,                0x1.8p+1,   0x1.00857cb76cb2ap+53,         -0x1p-1, INEXACT)
T(RN,     0x1.1056b642d62p+43,                0x1.4p+0,   0x1.d1281acda83a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bac56c32p+35,                0x1.8p+0,   0x1.328044b65eabep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.faed8p+17,                0x1.8p+1,   0x1.f0eef6e176612p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdd88p+17,                0x1.8p+1,   0x1.f99073a47f708p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a82117002p+35,                0x1.8p+0,     0x1.8205b3e6d76p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1778p+17,                0x1.8p+1,   0x1.158a4a8e06ae8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d5d3d082p+35,                0x1.8p+0,    0x1.209745aafeedp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5088p+17,                0x1.8p+1,   0x1.dfcc9e2d6c898p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60b06de92p+35,                0x1.8p+0,   0x1.24b8763ce635ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6aa8p+17,                0x1.8p+1,   0x1.e48164081d6f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.abad7e692p+35,                0x1.8p+0,   0x1.86e078e242c5ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9cc5c4442p+35,                0x1.8p+0,   0x1.729f3b542a1a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4fd8p+17,                0x1.8p+1,   0x1.3e540c95206c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.781c345e2p+35,                0x1.8p+0,   0x1.425b7e732741cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.55651be72p+35,                0x1.8p+0,   0x1.16c5e1c69d14ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d08c4fbb2p+35,                0x1.8p+0,   0x1.ba7f6ac148ecep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a95c52a2p+35,                0x1.8p+0,   0x1.458b5bf9d462cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.610d68dd2p+35,                0x1.8p+0,   0x1.252c3f61ccfc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.539faf802p+35,                0x1.8p+0,     0x1.149b3987ee3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9da65b622p+35,                0x1.8p+0,   0x1.73cde069078fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3018p+17,                0x1.8p+1,   0x1.3a02ea50fe10ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b19c8p+17,                0x1.8p+1,   0x1.370048a5c1634p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7788p+17,                0x1.8p+1,   0x1.21b012e561fe8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6610bdb22p+35,                0x1.8p+0,   0x1.2b706a7f04a24p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f0f0d462p+35,                0x1.8p+0,   0x1.36ca80d776d2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5bc2572d2p+35,                0x1.8p+0,   0x1.1e9ab9ff1349ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e99c8p+17,                0x1.8p+1,   0x1.bfba6b6a03e34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c2fc53552p+35,                0x1.8p+0,   0x1.a74306e8b21cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9380aa552p+35,                0x1.8p+0,   0x1.663516963a3cap+53,         -0x1p-1, INEXACT)
T(RN,        0x1.671765c4p+30,                0x1.cp+0,   0x1.47469527bd836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7e9b35052p+35,                0x1.8p+0,   0x1.4abeb1cd91e96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa008p+17,                0x1.8p+1,     0x1.ee37410ddeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e8e73af92p+35,                0x1.8p+0,   0x1.ddbfa265ec67ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7998p+17,                0x1.8p+1,   0x1.901c644410d96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa148p+17,                0x1.8p+1,   0x1.27136f3e0649cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bffd8p+17,                0x1.8p+1,   0x1.56fa420833fc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.695f519a2p+35,                0x1.8p+0,   0x1.2f98d094021ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d21acdc62p+35,                0x1.8p+0,   0x1.bcb942833022cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ebf43cf02p+35,                0x1.8p+0,    0x1.e23a3378af9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d61a8p+17,                0x1.8p+1,   0x1.8c50a7ba894c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94540e832p+35,                0x1.8p+0,   0x1.674eb97c74cc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d355dfb42p+35,                0x1.8p+0,   0x1.be7c7bb27a8f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90633d6a2p+35,                0x1.8p+0,   0x1.6211464e023acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d769830d2p+35,                0x1.8p+0,   0x1.c4575b92a6526p+53,          0x1p-1, INEXACT)
T(RN,       0x1.712389232p+35,                0x1.8p+0,   0x1.396fbf25c7e02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a38b8p+17,                0x1.8p+1,   0x1.19b4a26032a44p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3cb8p+17,                0x1.8p+1,   0x1.aff5e0adb9704p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b79f8p+17,                0x1.8p+1,    0x1.441de148a4eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf64883a2p+35,                0x1.8p+0,   0x1.a236bbf6a3874p+53,          0x1p-1, INEXACT)
T(RN,       0x1.522ff1b32p+35,                0x1.8p+0,   0x1.12da70a4b7122p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1348p+17,                0x1.8p+1,   0x1.1504bf072e7fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daac8p+17,                0x1.8p+1,   0x1.97fc943ebf864p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd848p+17,                0x1.8p+1,   0x1.f896ba8b521ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5c58p+17,                0x1.8p+1,   0x1.646d8a3b989dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99678p+17,                0x1.8p+1,   0x1.05c4b7cbb96b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9a8cedd2p+35,                0x1.8p+0,   0x1.841cf83fec43ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.defa8p+17,                0x1.8p+1,   0x1.a32ff6de53266p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b4ee0762p+35,                0x1.8p+0,   0x1.0a827fe6fd8f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed847d1e2p+35,                0x1.8p+0,   0x1.e4872c8fb0c64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a2e1ab02p+35,                0x1.8p+0,    0x1.309d8c46bb3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d7a8p+17,                0x1.8p+1,   0x1.0da95726dd1e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fac08p+17,                0x1.8p+1,    0x1.f06aabfdb504p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.898e85162p+35,                0x1.8p+0,   0x1.590b9386fe94cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.df9a836d2p+35,                0x1.8p+0,   0x1.d02eaececbfe6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5e38p+17,                0x1.8p+1,   0x1.e242d950fd84cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.48fe41922p+35,                0x1.8p+0,   0x1.07b8ade4480e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9508p+17,                0x1.8p+1,    0x1.ec3440c3d81fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0c68p+17,                0x1.8p+1,   0x1.1429db335408ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af3e8p+17,                0x1.8p+1,   0x1.31ef74e035bb2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9078p+17,                0x1.8p+1,   0x1.be2224b036198p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a9afac62p+35,                0x1.8p+0,   0x1.5a6cdd1a39bd4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9048p+17,                0x1.8p+1,   0x1.6c21c7bc7cc6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d4e308f2p+35,                0x1.8p+0,   0x1.5dfca45d1839ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99358p+17,                0x1.8p+1,   0x1.0564dafc60baap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb648p+17,                0x1.8p+1,   0x1.f24d3f3aab58cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b941ea282p+35,                0x1.8p+0,    0x1.99a407594a7fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce95e7c72p+35,                0x1.8p+0,   0x1.b7b2566d726f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70c475cf2p+35,                0x1.8p+0,   0x1.38f6af1649e1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5848p+17,                0x1.8p+1,   0x1.63d47510ff9ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c25f8p+17,                0x1.8p+1,    0x1.5c7ac17996f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2d48p+17,                0x1.8p+1,   0x1.ad619687ab2dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f74e8p+17,                0x1.8p+1,   0x1.e65c385b9d362p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4588p+17,                0x1.8p+1,   0x1.1b525e2dfba88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb698p+17,                0x1.8p+1,   0x1.f25bfa92f0486p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e9d8p+17,                0x1.8p+1,   0x1.0fe4421eac0a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e00310202p+35,                0x1.8p+0,    0x1.d0c67f3c56f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ab784722p+35,                0x1.8p+0,   0x1.1d511f317325cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48c2f2b52p+35,                0x1.8p+0,   0x1.07716132f610ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.52813c582p+35,                0x1.8p+0,    0x1.133d9098b8afp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6438p+17,                0x1.8p+1,   0x1.411e8ebe4476cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb548p+17,                0x1.8p+1,   0x1.f21e1ce07545cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50bf5c2f2p+35,                0x1.8p+0,   0x1.111995157ad26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5ec769972p+35,                0x1.8p+0,   0x1.22587c1addf56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c9549562p+35,                0x1.8p+0,   0x1.725df1e060434p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.acebc7b02p+35,                0x1.8p+0,    0x1.889522fa725ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.dad28p+17,                0x1.8p+1,   0x1.985e98037a92ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48679f5b2p+35,                0x1.8p+0,   0x1.0703a3576c472p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2648p+17,                0x1.8p+1,   0x1.176406f23ba8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca2d8p+17,                0x1.8p+1,   0x1.6ee97e8eb6dd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb7d8da32p+35,                0x1.8p+0,   0x1.f9402606d7702p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d90baf12p+35,                0x1.8p+0,   0x1.34e56d226a8eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b90c8p+17,                0x1.8p+1,   0x1.4747cd2541984p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de30ce492p+35,                0x1.8p+0,   0x1.ce21f437c0de2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46bfb08a2p+35,                0x1.8p+0,   0x1.0506ffb5a3c6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bbe68p+17,                0x1.8p+1,   0x1.4dab6bdbc50eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f250ba162p+35,                0x1.8p+0,   0x1.eb9c5c892e4b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1d58p+17,                0x1.8p+1,   0x1.1645ef742868ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1798p+17,                0x1.8p+1,   0x1.36b4ff74b0436p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af428p+17,                0x1.8p+1,   0x1.31f7f84ef37fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.baef8p+17,                0x1.8p+1,    0x1.4b7fa37bf2adp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab478p+17,                0x1.8p+1,   0x1.29930ead53058p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a88c83af2p+35,                0x1.8p+0,   0x1.829865e86fe26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e46ea5152p+35,                0x1.8p+0,   0x1.d735c4f924a4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eaff4cd62p+35,                0x1.8p+0,   0x1.e0d23bccb4eccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac108p+17,                0x1.8p+1,    0x1.2b37c86b64a3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50207a8c2p+35,                0x1.8p+0,   0x1.105864d31fa08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5539050f2p+35,                0x1.8p+0,   0x1.168fe2c48b366p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de68dd522p+35,                0x1.8p+0,   0x1.ce733a4609664p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d8af9602p+35,                0x1.8p+0,    0x1.0d35f824777cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2f88p+17,                0x1.8p+1,   0x1.8471cb0e55268p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b7b8a3462p+35,                0x1.8p+0,   0x1.9780dbcd9f6d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45c370852p+35,                0x1.8p+0,   0x1.03d8f50a5c26ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fc58p+17,                0x1.8p+1,   0x1.122c34ca1a7dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dfb38p+17,                0x1.8p+1,   0x1.a5166aa404cbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0488p+17,                0x1.8p+1,   0x1.57a6a0f448258p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.528c9e9d2p+35,                0x1.8p+0,   0x1.134b7321760bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79ed4db32p+35,                0x1.8p+0,   0x1.44b22859b56dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4618p+17,                0x1.8p+1,   0x1.61293781e3e2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a75b25e2p+35,                0x1.8p+0,   0x1.1cffe3e525fe4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.491983462p+35,                0x1.8p+0,   0x1.07d97493536d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad751d672p+35,                0x1.8p+0,   0x1.8951bec3fabb6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5275da442p+35,                0x1.8p+0,   0x1.132fae8782258p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7148p+17,                0x1.8p+1,   0x1.e5b42788b3b9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1498p+17,                0x1.8p+1,   0x1.152e95e875726p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3a48p+17,                0x1.8p+1,   0x1.dbd0b74b1da4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fc24dd992p+35,                0x1.8p+0,   0x1.fa3a16fe19dbep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1fd8p+17,                0x1.8p+1,   0x1.5b9776e0bd5c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2818p+17,                0x1.8p+1,   0x1.5cc9b3ca0038ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.62d00b3c2p+35,                0x1.8p+0,   0x1.275e40ce44028p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd538p+17,                0x1.8p+1,   0x1.9edd337d4af9cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6fcccf4e2p+35,                0x1.8p+0,   0x1.37bba0f92977cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9e78p+17,                0x1.8p+1,   0x1.c0884ba021838p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d59d5ea52p+35,                0x1.8p+0,   0x1.c1c1b2d652fd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bffe8p+17,                0x1.8p+1,   0x1.56fc8e02f3ff2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c88068022p+35,                0x1.8p+0,   0x1.af0d0155ababcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe008p+17,                0x1.8p+1,     0x1.fa077b01dfap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96fb8p+17,                0x1.8p+1,   0x1.012679fec5394p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd91bd842p+35,                0x1.8p+0,   0x1.fc5bb81912dd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a44f6a22p+35,                0x1.8p+0,   0x1.59fb9df48b784p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c80e8p+17,                0x1.8p+1,   0x1.69d70250e47a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.43ebe5212p+35,                0x1.8p+0,   0x1.01a58f2f8d3b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af4e8p+17,                0x1.8p+1,   0x1.3211838dc3b62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee208p+17,                0x1.8p+1,    0x1.cc3b17d24e26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0818p+17,                0x1.8p+1,   0x1.34a0e71121d8ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbae8p+17,                0x1.8p+1,   0x1.4d2d33ac0c982p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.656135632p+35,                0x1.8p+0,   0x1.2a945533b317ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac1d06392p+35,                0x1.8p+0,   0x1.8779695307f02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3e18p+17,                0x1.8p+1,   0x1.86b861fd5a0aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c5f18be2p+35,                0x1.8p+0,   0x1.33625c4139c24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f74a8p+17,                0x1.8p+1,   0x1.e6509fe27b9d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2b18p+17,                0x1.8p+1,   0x1.83c0b7773fa9ep+53,          0x1p-1, INEXACT)
T(RN,            0x1.4168p+13,                  0x1p+2,   0x1.3e078c01bd908p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea898p+17,                0x1.8p+1,   0x1.c245d407398e6p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3b18p+13,                  0x1p+2,   0x1.25c56f6ddda68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d342c4512p+35,                0x1.8p+0,   0x1.be611a39ace52p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5a08p+13,                  0x1p+2,    0x1.ab4762a14068p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f07f8p+17,                0x1.8p+1,    0x1.d2e353ee4518p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8156ee0b2p+35,                0x1.8p+0,   0x1.4e4ba0e74d3d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83d2fcba2p+35,                0x1.8p+0,   0x1.5188a9fc06574p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5918p+17,                0x1.8p+1,   0x1.e1569ec10183ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4958p+17,                0x1.8p+1,   0x1.61a30e6b5dccap+53,          0x1p-1, INEXACT)
T(RN,           0x1.afdc8p+17,                0x1.8p+1,   0x1.3340349ad54f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8638p+17,                0x1.8p+1,   0x1.bc61e336057ccp+53,          0x1p-1, INEXACT)
T(RN,               0x1.c9p+8,                0x1.8p+2,   0x1.02e8bdec0fd38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ba28e882p+35,                0x1.8p+0,    0x1.0ae77eaea1a3p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd408p+17,                0x1.8p+1,    0x1.50ba0a34297cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f36dece2p+35,                0x1.8p+0,   0x1.4b889eb06827cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.65bb761c2p+35,                0x1.8p+0,   0x1.2b05773c87d68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58fd57fc2p+35,                0x1.8p+0,   0x1.1b2fff8ddbb58p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5ade5c72p+35,                0x1.8p+0,   0x1.d907e0a772af6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac2d8p+17,                0x1.8p+1,   0x1.2b749cb6423d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.526257262p+35,                0x1.8p+0,   0x1.1317e2edc6414p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b60a8p+17,                0x1.8p+1,   0x1.40a15400fa416p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5588p+17,                0x1.8p+1,   0x1.1d593f924dd88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a92d8p+17,                0x1.8p+1,   0x1.253485c6302d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbd88p+17,                0x1.8p+1,   0x1.4d8bdad34f108p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4ea8p+17,                0x1.8p+1,   0x1.b2f86965a5bb6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbee4faa2p+35,                0x1.8p+0,   0x1.b3eac718cfd2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9dd9a182p+35,                0x1.8p+0,    0x1.df28f00ac287p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df308p+17,                0x1.8p+1,    0x1.a3bdcde1c539p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfbd8p+17,                0x1.8p+1,   0x1.a530c0c9aad02p+53,          0x1p-1, INEXACT)
T(RN,       0x1.674312332p+35,                0x1.8p+0,   0x1.2cf0ffa289ddep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e1905e8e2p+35,                0x1.8p+0,   0x1.d3080177a1804p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cdf5e3c2p+35,                0x1.8p+0,   0x1.3404bb28e1228p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2c48p+17,                0x1.8p+1,   0x1.83f0152d36dacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a7537e292p+35,                0x1.8p+0,   0x1.80ed261136822p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0688p+17,                0x1.8p+1,   0x1.57f03e012e6b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.72792ed52p+35,                0x1.8p+0,   0x1.3b23479fa02cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daa88p+17,                0x1.8p+1,   0x1.97f243eb44d78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3c98p+17,                0x1.8p+1,   0x1.aff085451aaa6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.701252962p+35,                0x1.8p+0,   0x1.3814050659fb4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f21c8p+17,                0x1.8p+1,   0x1.d77439fea5fb4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cad98p+17,                0x1.8p+1,   0x1.7087513320d56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5cb090d2p+35,                0x1.8p+0,   0x1.7ed658d2deedap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7dd9aa5d2p+35,                0x1.8p+0,   0x1.49c3db76f3ac6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3648p+17,                0x1.8p+1,   0x1.3ad97f3e25d8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5db8p+17,                0x1.8p+1,   0x1.b582341f35a34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6e88p+17,                0x1.8p+1,   0x1.2088f194b4a38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cc2ab0c2p+35,                0x1.8p+0,   0x1.33e06456ed2f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc178p+17,                0x1.8p+1,   0x1.73879b124aec8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9678p+17,                0x1.8p+1,   0x1.6d0e9e0a226b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbce8p+17,                0x1.8p+1,   0x1.9aea23667cce2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96cf8p+17,                0x1.8p+1,    0x1.00d31ba9f8e7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7407b2b82p+35,                0x1.8p+0,    0x1.3d204ce1d035p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb788p+17,                0x1.8p+1,   0x1.c4d93a8d16be8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8288p+17,                0x1.8p+1,   0x1.e8d5450e2f5f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5fd8p+17,                0x1.8p+1,   0x1.e28dd04db11c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7dc336962p+35,                0x1.8p+0,   0x1.49a6c63d637b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcb18p+17,                0x1.8p+1,   0x1.4f7602be1289ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3eb8p+17,                0x1.8p+1,   0x1.b04b9d3dde564p+53,          0x1p-1, INEXACT)
T(RN,       0x1.658ca8762p+35,                0x1.8p+0,   0x1.2acaca52108f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c77d8p+17,                0x1.8p+1,   0x1.687e4ddedf242p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc728p+17,                0x1.8p+1,   0x1.4ee783c14b30ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e871fee72p+35,                0x1.8p+0,   0x1.dd13d5b72974ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbd88p+17,                0x1.8p+1,   0x1.4d8bdad34f108p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.943966192p+35,                0x1.8p+0,   0x1.672b314516942p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b704ea62p+35,                0x1.8p+0,   0x1.46a565b8cb6ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e165b36d2p+35,                0x1.8p+0,   0x1.d2c9f09b7e01ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7407b2b82p+35,                0x1.8p+0,    0x1.3d204ce1d035p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab197bd02p+35,                0x1.8p+0,    0x1.8615a12b652ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5cc89ca72p+35,                0x1.8p+0,   0x1.1fdf30b17d2cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf8b8p+17,                0x1.8p+1,   0x1.7bf53dabbee44p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac645c472p+35,                0x1.8p+0,   0x1.87db461b6c20ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e40d8p+17,                0x1.8p+1,   0x1.b0a6c2046f272p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6c38p+17,                0x1.8p+1,   0x1.e4c9b1f5a50ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ad3b1542p+35,                0x1.8p+0,   0x1.45db3e193ceb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca14e4d72p+35,                0x1.8p+0,   0x1.b14a67dda88d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.850e4ba82p+35,                0x1.8p+0,    0x1.53249f66d90fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0288p+17,                0x1.8p+1,   0x1.7d77d215f7df8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d06dd5132p+35,                0x1.8p+0,   0x1.ba53df079141ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6060c5212p+35,                0x1.8p+0,   0x1.24554fd1eec4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8ca8p+17,                0x1.8p+1,   0x1.46b4f6134ba56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9a08p+17,                0x1.8p+1,    0x1.6d9728efb34ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fefd8p+17,                0x1.8p+1,   0x1.fcfa07477b4c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de32bd182p+35,                0x1.8p+0,    0x1.ce24c1826967p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efc08p+17,                0x1.8p+1,    0x1.d0c94f4262f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4ee568f2p+35,                0x1.8p+0,   0x1.93a17d67cb066p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f7dd3162p+35,                0x1.8p+0,   0x1.4be4b6e4a4ab4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb6c8p+17,                0x1.8p+1,   0x1.4c989a55e16a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.817ed72a2p+35,                0x1.8p+0,   0x1.4e7f91ced122cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8c32bcba2p+35,                0x1.8p+0,   0x1.5c865cd521a8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5838p+17,                0x1.8p+1,   0x1.8ad33cee4192cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6df8p+17,                0x1.8p+1,    0x1.6707ab657bcap+53,          0x1p-1, INEXACT)
T(RN,       0x1.92eb93fb2p+35,                0x1.8p+0,   0x1.656ea1f405e4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9741a7932p+35,                0x1.8p+0,   0x1.6b37bad577f1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70b017d52p+35,                0x1.8p+0,   0x1.38dcc1fd4ff36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4ddbb4a92p+35,                0x1.8p+0,   0x1.0d97bbaeb8cdep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3778p+17,                0x1.8p+1,   0x1.5f064ab1790e8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bede8p+17,                0x1.8p+1,   0x1.5468bb5465992p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94ceba232p+35,                0x1.8p+0,   0x1.67f24a43e3ffep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eda3e8662p+35,                0x1.8p+0,   0x1.e4b5727470f94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74b9158c2p+35,                0x1.8p+0,   0x1.3e03379cafc08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7438p+17,                0x1.8p+1,   0x1.b9518c3e76a6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce648p+17,                0x1.8p+1,   0x1.7921a08037e8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b981ced2p+35,                0x1.8p+0,   0x1.3266b34e4e51ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0368p+17,                0x1.8p+1,   0x1.130bfda49c15ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4386b0c2p+35,                0x1.8p+0,   0x1.7cb2b5a8bad08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c6fbb3252p+35,                0x1.8p+0,   0x1.ace6e8fff4f2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d73d8p+17,                0x1.8p+1,   0x1.8f32688412f82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da0e8p+17,                0x1.8p+1,   0x1.9665b37b7ada2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b87e8p+17,                0x1.8p+1,   0x1.460c15d39f572p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fdafabb42p+35,                0x1.8p+0,   0x1.fc8882b8f0f08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa9b8p+17,                0x1.8p+1,   0x1.effdf77a2cc74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8bd583682p+35,                0x1.8p+0,    0x1.5c0b618d7509p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec7f780c2p+35,                0x1.8p+0,   0x1.e306f989664f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aaa0f4f12p+35,                0x1.8p+0,   0x1.85708d9f24312p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdee8p+17,                0x1.8p+1,   0x1.78013071fe642p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f1b8p+17,                0x1.8p+1,   0x1.10dc6ee42b1f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba188p+17,                0x1.8p+1,   0x1.499dd3bed53c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6d78p+17,                0x1.8p+1,   0x1.42644f30f3708p+53,          0x1p-1, INEXACT)
T(RN,       0x1.94740cf82p+35,                0x1.8p+0,    0x1.67796009e4f3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1218p+17,                0x1.8p+1,   0x1.d4aced375366ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.efd48p+17,                0x1.8p+1,   0x1.d101921d5c9dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0448p+17,                0x1.8p+1,   0x1.579d6e0fcde2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c89711c02p+35,                0x1.8p+0,    0x1.af2d1b28f2a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db68a0932p+35,                0x1.8p+0,   0x1.ca1b0ff8fd2e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4755f1732p+35,                0x1.8p+0,   0x1.05bb20a92a75ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e79c8p+17,                0x1.8p+1,   0x1.ba438b5e81834p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bfed0cfa2p+35,                0x1.8p+0,   0x1.a2f636a88e80cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.724ea7eb2p+35,                0x1.8p+0,   0x1.3aed05fcad392p+53,          0x1p-1, INEXACT)
T(RN,       0x1.800f46382p+35,                0x1.8p+0,    0x1.4ca19a9cbd85p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa1d8p+17,                0x1.8p+1,   0x1.ee8c3f26acf22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b6ff5e2c2p+35,                0x1.8p+0,   0x1.967f6be71b3c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.acfb8p+17,                0x1.8p+1,   0x1.2d25a30713594p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb718p+17,                0x1.8p+1,   0x1.71f607fcce6dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd7e8p+17,                0x1.8p+1,   0x1.f884e75453c72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1998p+17,                0x1.8p+1,   0x1.d600a400d8b96p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bfd4bbb42p+35,                0x1.8p+0,   0x1.a2d419072af08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef6e8p+17,                0x1.8p+1,   0x1.cfe2d2ff44ec2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7138p+17,                0x1.8p+1,   0x1.20e0fd9be18dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6638p+17,                0x1.8p+1,   0x1.1f790e02371ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f605a6e2p+35,                0x1.8p+0,   0x1.3731c881d62bcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bca98p+17,                0x1.8p+1,   0x1.4f63e84058e46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.af3f847a2p+35,                0x1.8p+0,   0x1.8bc824f2bdd0cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcad8p+17,                0x1.8p+1,   0x1.f619053689952p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7054ed62p+35,                0x1.8p+0,   0x1.808287618a2ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c1e8b132p+35,                0x1.8p+0,   0x1.0b7d3a7d497e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c92e8p+17,                0x1.8p+1,   0x1.6c86352839602p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb18355e2p+35,                0x1.8p+0,   0x1.b2ba87b305e1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f4c0fc4c2p+35,                0x1.8p+0,   0x1.ef3947b2d7c88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.431219572p+35,                0x1.8p+0,   0x1.00a1e0c29202ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.882220be2p+35,                0x1.8p+0,   0x1.572ccbf31b3dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4538p+17,                0x1.8p+1,   0x1.3ce119c62e49cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e98e8p+17,                0x1.8p+1,   0x1.bf940446ff022p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c88f8p+17,                0x1.8p+1,    0x1.6b0a65e93b3bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a68d5bb12p+35,                0x1.8p+0,   0x1.7fdf07861d66ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1458p+17,                0x1.8p+1,   0x1.15269d6a6c85ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e32616932p+35,                0x1.8p+0,   0x1.d556b41e6fee2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9e18p+17,                0x1.8p+1,   0x1.eddc712b6a2aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5248p+17,                0x1.8p+1,   0x1.3ea94eea346ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc9404c52p+35,                0x1.8p+0,   0x1.9e460ad0e3216p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5e857842p+35,                0x1.8p+0,   0x1.d95d455bc89d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c96e7a5b2p+35,                0x1.8p+0,   0x1.b05e60006a58ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a06a8p+17,                0x1.8p+1,   0x1.13732183f9a36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8d88p+17,                0x1.8p+1,   0x1.ead5eb1884808p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffd98p+17,                0x1.8p+1,   0x1.ff8c88af28456p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f734c0272p+35,                0x1.8p+0,   0x1.f2ddaaedd99cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f02e8p+17,                0x1.8p+1,   0x1.d1fef72667302p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6158p+17,                0x1.8p+1,   0x1.40b97c3db2d4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2bd451e2p+35,                0x1.8p+0,   0x1.ec3d050a3c39cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8c48p+17,                0x1.8p+1,   0x1.46a79ee28bfacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8810a02d2p+35,                0x1.8p+0,   0x1.5715d27674d66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d342c4512p+35,                0x1.8p+0,   0x1.be611a39ace52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5485fd92p+35,                0x1.8p+0,   0x1.7e2482bb749c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e27e8p+17,                0x1.8p+1,   0x1.ac7c4ed826372p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.521790692p+35,                0x1.8p+0,   0x1.12bcb88040fa2p+53,         -0x1p-1, INEXACT)
T(RN,     0x1.b4b05ae3e84p+42,                0x1.4p+0,   0x1.60e40372ec4ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2168p+17,                0x1.8p+1,   0x1.5bd168fef67fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5e98p+17,                0x1.8p+1,   0x1.4058e29214006p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad9c8p+17,                0x1.8p+1,   0x1.2e7933a1bca34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e144bc1f2p+35,                0x1.8p+0,   0x1.d299fe9e722bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbdb8p+17,                0x1.8p+1,   0x1.9b0bd2abadc34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b5b72cb2p+35,                0x1.8p+0,   0x1.321a079e3caaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b208d8d42p+35,                0x1.8p+0,   0x1.8f9fb9c564bb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ebd4df682p+35,                0x1.8p+0,    0x1.e20c160b5d77p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6fdf75012p+35,                0x1.8p+0,   0x1.37d356465c5f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0f08p+17,                0x1.8p+1,    0x1.7f65c2b7a78dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da328b662p+35,                0x1.8p+0,   0x1.c85b270ff5194p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ef6ca082p+35,                0x1.8p+0,    0x1.7593d5744e0dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.af7def152p+35,                0x1.8p+0,   0x1.8c1e14d1ad64ap+53,         -0x1p-1, INEXACT)
T(RN,     0x1.e2bbcc5ca04p+42,                0x1.4p+0,    0x1.8fffdcb64049p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5d48p+17,                0x1.8p+1,   0x1.402ace9d53bdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad388p+17,                0x1.8p+1,   0x1.2da62cbe32928p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d37e00e32p+35,                0x1.8p+0,   0x1.beb5ff3b87582p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8748p+17,                0x1.8p+1,   0x1.bc904c6a1b9bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e25b8p+17,                0x1.8p+1,   0x1.ac1f1673f47b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98678p+17,                0x1.8p+1,   0x1.03daddb0b73b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7a88p+17,                0x1.8p+1,   0x1.e7614fbe60478p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3868p+17,                0x1.8p+1,   0x1.19aa901ba52cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6e48p+17,                0x1.8p+1,   0x1.4280f6b5ef00cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.840c6fe62p+35,                0x1.8p+0,   0x1.51d3acd5b5494p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffe58p+17,                0x1.8p+1,   0x1.ffb0841d4dd3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6960ffbf2p+35,                0x1.8p+0,   0x1.2f9aeea43f1fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa418p+17,                0x1.8p+1,   0x1.eef5cec1884cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae498p+17,                0x1.8p+1,   0x1.2fe72f7b95626p+53,          0x1p-1, INEXACT)
T(RN,       0x1.59fda3162p+35,                0x1.8p+0,   0x1.1c6bcc3b5d54cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e97694b2p+35,                0x1.8p+0,   0x1.221ce54c7f252p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9928p+17,                0x1.8p+1,   0x1.6d759c5ef8b6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b39a8p+17,                0x1.8p+1,   0x1.3b4eb3d186946p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4498p+17,                0x1.8p+1,   0x1.1b340a8ad0826p+53,          0x1p-1, INEXACT)
T(RN,       0x1.97ecf6832p+35,                0x1.8p+0,   0x1.6c1cfff03e33ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e088b80a2p+35,                0x1.8p+0,   0x1.d188ab7d6d16cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e51d8p+17,                0x1.8p+1,   0x1.b381b595c2822p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa028p+17,                0x1.8p+1,   0x1.ee3d1d4cc3e3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd328p+17,                0x1.8p+1,   0x1.509a47e227b4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be788p+17,                0x1.8p+1,   0x1.537fd6ecec4e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf978p+17,                0x1.8p+1,   0x1.561031f879948p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7408p+17,                0x1.8p+1,    0x1.e633a382145cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be628p+17,                0x1.8p+1,   0x1.534da9907fe5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e45177242p+35,                0x1.8p+0,   0x1.d70b3287e8c68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3ce486c2p+35,                0x1.8p+0,   0x1.bf29151e686b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.732516d22p+35,                0x1.8p+0,   0x1.3bfeb932c5564p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e22f8p+17,                0x1.8p+1,    0x1.aba9f8b0fb09p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa0401a42p+35,                0x1.8p+0,   0x1.8499ba103a298p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.682059052p+35,                0x1.8p+0,   0x1.2e0733109d96ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee738p+17,                0x1.8p+1,   0x1.cd232a13434fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.80a97fcd2p+35,                0x1.8p+0,   0x1.4d6a0ac9072a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b45b8p+17,                0x1.8p+1,   0x1.3cf2882329db4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.de0a8p+17,                0x1.8p+1,   0x1.a0bb1329e5c16p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7776009b2p+35,                0x1.8p+0,   0x1.4185e9a85710ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.754d99e82p+35,                0x1.8p+0,    0x1.3ec15dcfa699p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b19fe8e82p+35,                0x1.8p+0,    0x1.8f0ed55764f9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff9a8p+17,                0x1.8p+1,   0x1.fecfbc5962d46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9874d562p+35,                0x1.8p+0,   0x1.c7640a5c0a3ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b401f94f2p+35,                0x1.8p+0,   0x1.925a234dd7ae6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c20e8p+17,                0x1.8p+1,   0x1.5bbedd60b25a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f597a9c2p+35,                0x1.8p+0,   0x1.4bb58925a1798p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8498p+17,                0x1.8p+1,   0x1.e93548f246426p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bdef8p+17,                0x1.8p+1,    0x1.5247afd2373dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9b08p+17,                0x1.8p+1,    0x1.48b56bb3d031p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb098p+17,                0x1.8p+1,   0x1.4bba073742666p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6a94bdf62p+35,                0x1.8p+0,   0x1.311f1218841f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4118p+17,                0x1.8p+1,   0x1.3c5163a934fbep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b65e8p+17,                0x1.8p+1,   0x1.4159ebd60b412p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4ce8p+13,                  0x1p+2,   0x1.6e0c4243d8468p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.df8538c12p+35,                0x1.8p+0,   0x1.d00fc608fc272p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4198p+17,                0x1.8p+1,   0x1.dd1f487a93f16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9cd48672p+35,                0x1.8p+0,   0x1.844edc2b455b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb4f8p+17,                0x1.8p+1,    0x1.4c575d2f49bfp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8ac8p+17,                0x1.8p+1,   0x1.6b4f983412264p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa518p+17,                0x1.8p+1,   0x1.27923d546787ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb2b8p+17,                0x1.8p+1,   0x1.c4048315e5724p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2928p+17,                0x1.8p+1,   0x1.5cf1316a73e6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6c98p+17,                0x1.8p+1,   0x1.e4db0d6990ba6p+53,          0x1p-1, INEXACT)
T(RN,        0x1.75e5b984p+30,                0x1.cp+0,   0x1.5f411e120fd1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b82074a22p+35,                0x1.8p+0,   0x1.9811356b35c7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f8b8p+17,                0x1.8p+1,   0x1.11b9871725e44p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea9e8p+17,                0x1.8p+1,   0x1.c27faaaedb6d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1b4282f2p+35,                0x1.8p+0,   0x1.8f2ac8ccf1526p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb65de862p+35,                0x1.8p+0,   0x1.b328db57c7e54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b60f8p+17,                0x1.8p+1,    0x1.40ac4edecdc3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc4a8p+17,                0x1.8p+1,   0x1.9c2bbb1b930d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba406ce52p+35,                0x1.8p+0,   0x1.9b06a3e4d3856p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af7b8p+17,                0x1.8p+1,   0x1.32715a62c1514p+53,          0x1p-1, INEXACT)
T(RN,       0x1.583bba392p+35,                0x1.8p+0,   0x1.1a41bb56328fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6cd8p+17,                0x1.8p+1,   0x1.66dd0dd7230b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b567ba22p+35,                0x1.8p+0,   0x1.46840d7c6967cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b84918a2p+35,                0x1.8p+0,   0x1.70eef6639b26cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60d69ca42p+35,                0x1.8p+0,   0x1.24e8009656498p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2308p+17,                0x1.8p+1,    0x1.d7ad0641d4c9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5419e5572p+35,                0x1.8p+0,   0x1.1530940e147d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b88a2d2b2p+35,                0x1.8p+0,   0x1.98a445e960612p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2ded43a2p+35,                0x1.8p+0,   0x1.ec6eb4907cf8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac1f8p+17,                0x1.8p+1,    0x1.2b573e064ec6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c70a8p+17,                0x1.8p+1,   0x1.676d86c4d7f16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd9a8p+17,                0x1.8p+1,   0x1.7734360bc4746p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99628p+17,                0x1.8p+1,   0x1.05bb20a92a75ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e17346c32p+35,                0x1.8p+0,   0x1.d2ddaf8e9f542p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b43b8p+17,                0x1.8p+1,   0x1.3cacd284eb754p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc6b8p+17,                0x1.8p+1,   0x1.4ed7b106e46e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2d1a7872p+35,                0x1.8p+0,   0x1.90b52e896988ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1c08p+17,                0x1.8p+1,    0x1.aa82e3ce8054p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e52d5e542p+35,                0x1.8p+0,   0x1.d84c274253cb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3878p+17,                0x1.8p+1,   0x1.af3fd5a096118p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fcbc56132p+35,                0x1.8p+0,   0x1.fb1c8121c4de2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b08bff052p+35,                0x1.8p+0,   0x1.8d92311269296p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1cb8p+17,                0x1.8p+1,   0x1.8184883ce0104p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc42c1102p+35,                0x1.8p+0,    0x1.fa66c18bd126p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea328p+17,                0x1.8p+1,   0x1.c1566ae8fea4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dee18p+17,                0x1.8p+1,   0x1.a2ee570a749aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb6b0b1f2p+35,                0x1.8p+0,   0x1.e170886f0ff46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aeac8p+17,                0x1.8p+1,   0x1.30b9239efb464p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0e88p+17,                0x1.8p+1,   0x1.357d9acee2838p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9a916992p+35,                0x1.8p+0,   0x1.b0b17be445fbep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4108p+17,                0x1.8p+1,    0x1.1ac0e0750323p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc8050d92p+35,                0x1.8p+0,   0x1.b4ba6a0ca683ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2ca48392p+35,                0x1.8p+0,   0x1.90aafdb59a4fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b13357c22p+35,                0x1.8p+0,   0x1.8e790053dbd3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51ff30002p+35,                0x1.8p+0,      0x1.129f02804ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f1d473d32p+35,                0x1.8p+0,   0x1.eae480acef162p+53,          0x1p-1, INEXACT)
T(RN,       0x1.535ce9dd2p+35,                0x1.8p+0,   0x1.1449aab0a3e3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e22b8p+17,                0x1.8p+1,   0x1.ab9f5422e0c24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97158p+17,                0x1.8p+1,   0x1.0157c5d95784ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.db66b3362p+35,                0x1.8p+0,   0x1.ca1846dd7e574p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b3387622p+35,                0x1.8p+0,   0x1.0a6180e853f04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8c397712p+35,                0x1.8p+0,   0x1.f52f3a5bf1612p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0b36d892p+35,                0x1.8p+0,   0x1.a40ca87c54b62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6a48p+17,                0x1.8p+1,   0x1.667c08e2ba34cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b697aef02p+35,                0x1.8p+0,    0x1.95ef711f4a5ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab038p+17,                0x1.8p+1,   0x1.29051264f31acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc588p+17,                0x1.8p+1,   0x1.9c5014b2f6288p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a20a5d42p+35,                0x1.8p+0,   0x1.308c926e38648p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db838p+17,                0x1.8p+1,   0x1.9a27f1b238b2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2a78p+17,                0x1.8p+1,   0x1.ace9937aeba78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f5e1ebf2p+35,                0x1.8p+0,   0x1.2313ad9b06ffap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb998p+17,                0x1.8p+1,   0x1.f2e9764225996p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7638p+17,                0x1.8p+1,   0x1.e6991bddb74ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9018p+17,                0x1.8p+1,   0x1.472f50ea0830ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c128p+17,                0x1.8p+1,   0x1.0aeb619b216eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d15655962p+35,                0x1.8p+0,   0x1.bba030a15a1b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f48f8p+17,                0x1.8p+1,    0x1.de715469b37bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f86c8p+17,                0x1.8p+1,   0x1.e99b2c4355da4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5e6442f2p+35,                0x1.8p+0,   0x1.7efb6c5d822dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd398p+17,                0x1.8p+1,   0x1.7647df5a39976p+53,          0x1p-1, INEXACT)
T(RN,       0x1.81421c312p+35,                0x1.8p+0,   0x1.4e308985f1f6ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1a91ce22p+35,                0x1.8p+0,   0x1.8f1b89a93a9fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.525d76752p+35,                0x1.8p+0,   0x1.1311f03e37a76p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c1a514982p+35,                0x1.8p+0,    0x1.a5602b6b6a97p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6d78p+17,                0x1.8p+1,   0x1.b82c5a3b9c708p+53,          0x1p-1, INEXACT)
T(RN,       0x1.acd3fbeb2p+35,                0x1.8p+0,   0x1.887477ecc046ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5915f89d2p+35,                0x1.8p+0,   0x1.1b4e52e724cbap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7f5262d2p+35,                0x1.8p+0,   0x1.f3fbe2145069ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc6ede5f2p+35,                0x1.8p+0,   0x1.cb964fd0c573ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6bd8p+17,                0x1.8p+1,   0x1.e4b856ebc6a02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5918p+17,                0x1.8p+1,   0x1.63f30f63f083ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4078p+17,                0x1.8p+1,   0x1.605699647d298p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52777a8d2p+35,                0x1.8p+0,   0x1.1331aa3981c26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf0c8p+17,                0x1.8p+1,   0x1.54d1e5c600b84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e29a8p+17,                0x1.8p+1,   0x1.acc6ec18f8e46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5a08p+17,                0x1.8p+1,    0x1.e181cf675b8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed847d1e2p+35,                0x1.8p+0,   0x1.e4872c8fb0c64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6c18p+17,                0x1.8p+1,   0x1.e4c3e8e69264ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7180f5c22p+35,                0x1.8p+0,   0x1.39e6c426e913cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1a28p+17,                0x1.8p+1,   0x1.5ac4c109cf21ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.899749942p+35,                0x1.8p+0,   0x1.59171b54c5838p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8438p+17,                0x1.8p+1,   0x1.e923d2f0c2d6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d658p+17,                0x1.8p+1,   0x1.0d8042ea6f1bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a35a8p+17,                0x1.8p+1,   0x1.1951f9b38de86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.922dd33c2p+35,                0x1.8p+0,   0x1.647240bfc0fd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.82f60c162p+35,                0x1.8p+0,   0x1.506863b3670b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e51d8p+17,                0x1.8p+1,   0x1.b381b595c2822p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f82d8p+17,                0x1.8p+1,   0x1.e8e3d079367d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4198p+17,                0x1.8p+1,   0x1.1ad30d722cf16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f4dc10c2p+35,                0x1.8p+0,   0x1.60a172ac58ef8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea488p+17,                0x1.8p+1,   0x1.c192ed488c058p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8238p+17,                0x1.8p+1,   0x1.e8c6b9ed0230cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.daf68p+17,                0x1.8p+1,   0x1.98bb81a376b9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a40f8p+17,                0x1.8p+1,    0x1.1abedb81a263p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a918cadc2p+35,                0x1.8p+0,   0x1.835810f208e18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f7f8e332p+35,                0x1.8p+0,   0x1.4be6f622ada22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bd71e7482p+35,                0x1.8p+0,    0x1.9f7c555e37ebp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eac08p+17,                0x1.8p+1,    0x1.c2dd59dcb204p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef8f568d2p+35,                0x1.8p+0,   0x1.e789f55f3ebdap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d05e8p+17,                0x1.8p+1,   0x1.7dfd054ec7212p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c28e8p+17,                0x1.8p+1,   0x1.5ce7e66979322p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.96b3014b2p+35,                0x1.8p+0,   0x1.6a78f57edddaep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6968p+17,                0x1.8p+1,   0x1.665aebfb1b17ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a7b5db82p+35,                0x1.8p+0,    0x1.6f8a8c710c55p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4808p+17,                0x1.8p+1,    0x1.6171d6b7ecd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d39e7e892p+35,                0x1.8p+0,   0x1.bee491e6dd962p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7083f8d02p+35,                0x1.8p+0,    0x1.38a49a8613f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c937a9872p+35,                0x1.8p+0,   0x1.b010aa62e9c8ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8d58p+17,                0x1.8p+1,   0x1.247e9d1ad338ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2758p+17,                0x1.8p+1,   0x1.5cadd5604996ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a4fe016f2p+35,                0x1.8p+0,   0x1.7dbf56c766d5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5ff8p+17,                0x1.8p+1,     0x1.64f64812d52p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4c78p+13,                  0x1p+2,    0x1.6c20a129d5fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.673fb8702p+35,                0x1.8p+0,    0x1.2cecc9de59eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96938p+17,                0x1.8p+1,   0x1.00618988c7f5cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.df648p+17,                0x1.8p+1,   0x1.a44682452218cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9efa8p+17,                0x1.8p+1,   0x1.109b60c8a7266p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bae056682p+35,                0x1.8p+0,    0x1.9be5a6a4d1e9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f5e8p+17,                0x1.8p+1,   0x1.1160a39bac712p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9918p+17,                0x1.8p+1,   0x1.95248dbf6243ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b8d8p+17,                0x1.8p+1,   0x1.09e9414cc14f2p+53,          0x1p-1, INEXACT)
T(RN,             0x1.abcp+10,                0x1.4p+2,   0x1.a0c60d427e3b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bcdf8p+17,                0x1.8p+1,    0x1.4fde27b589eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0808p+17,                0x1.8p+1,    0x1.58277ab06c18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ee38p+17,                0x1.8p+1,   0x1.106e0f7e1634cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.afa2a85f2p+35,                0x1.8p+0,   0x1.8c50a7ba894c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bfad74e32p+35,                0x1.8p+0,   0x1.a29d00c4b227ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1cf8p+17,                0x1.8p+1,    0x1.5b2ce8eb2cf7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d187e9cd2p+35,                0x1.8p+0,   0x1.bbe7188f2595ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5408p+17,                0x1.8p+1,    0x1.63347e1baafcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c5810d532p+35,                0x1.8p+0,   0x1.aacfee991b462p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7788p+17,                0x1.8p+1,   0x1.e6d6047490fe8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb6c8p+17,                0x1.8p+1,   0x1.71e9f401b46a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a6b3844d2p+35,                0x1.8p+0,   0x1.80130843e0c5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61c430542p+35,                0x1.8p+0,   0x1.261007eb21748p+53,          0x1p-1, INEXACT)
T(RN,       0x1.89040b122p+35,                0x1.8p+0,   0x1.5855871c1201cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e44b8p+17,                0x1.8p+1,   0x1.b14d16fe6b084p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aafe15d92p+35,                0x1.8p+0,   0x1.85f018a24023ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cedd8p+17,                0x1.8p+1,   0x1.7a49fee07a362p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f47bc4972p+35,                0x1.8p+0,   0x1.eed29d38256aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6b78p+17,                0x1.8p+1,   0x1.66a8fc84cb2a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb7ab8132p+35,                0x1.8p+0,   0x1.e18791d1a2e1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fffc8p+17,                0x1.8p+1,   0x1.fff580125ff54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be4889062p+35,                0x1.8p+0,   0x1.a0a8c4eba7aacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecb48p+17,                0x1.8p+1,   0x1.c844ed0dcf27cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dcf2185d2p+35,                0x1.8p+0,   0x1.cc543e21536c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6ed57c112p+35,                0x1.8p+0,   0x1.36816693dbd2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0588p+17,                0x1.8p+1,   0x1.34492a1b55e88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63324d0e2p+35,                0x1.8p+0,   0x1.27d8fab5a28fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.759557252p+35,                0x1.8p+0,   0x1.3f1d44bc2b8d6p+53,          0x1p-1, INEXACT)
T(RN,             0x1.954p+10,                0x1.4p+2,   0x1.3e19e66a66662p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfff8p+17,                0x1.8p+1,      0x1.a5deae805ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7a38p+17,                0x1.8p+1,   0x1.4426ba3a8598cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb47cc132p+35,                0x1.8p+0,   0x1.f8efe0ea8861ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7448p+17,                0x1.8p+1,   0x1.e63f3b854132cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ee21ae32p+35,                0x1.8p+0,   0x1.4b1aa49ac967ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d59f8p+17,                0x1.8p+1,    0x1.8b19e45d9a8ep+53,          0x1p-1, INEXACT)
T(RN,          0x1.40c1c8p+21,                0x1.4p+1,   0x1.3e19e66a66662p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e108a1b52p+35,                0x1.8p+0,   0x1.d2429917bb30ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f12f8p+17,                0x1.8p+1,    0x1.d4d486e541d9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef248p+17,                0x1.8p+1,   0x1.cf1314b3954ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84786b0f2p+35,                0x1.8p+0,   0x1.5260b8f706766p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3f78p+13,                  0x1p+2,    0x1.366e124c1532p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb5a8p+17,                0x1.8p+1,   0x1.c48652352f686p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c847c21d2p+35,                0x1.8p+0,   0x1.aebcc7be051bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5de4c2e12p+35,                0x1.8p+0,   0x1.213f4204ec3cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9153e9ee2p+35,                0x1.8p+0,   0x1.6350b542e3244p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3bf8p+17,                0x1.8p+1,    0x1.1a1d6e9808b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.67bd69322p+35,                0x1.8p+0,   0x1.2d8ac4fc2fd24p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f19168aa2p+35,                0x1.8p+0,   0x1.ea815a078bcd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d3fa1292p+35,                0x1.8p+0,   0x1.347ea7d5acddep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a05ca8c2p+35,                0x1.8p+0,   0x1.59a87a12425f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f05c0dd12p+35,                0x1.8p+0,   0x1.e8b82f15ae352p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0c48p+17,                0x1.8p+1,   0x1.58c41c13857acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.def88p+17,                0x1.8p+1,   0x1.a32ab6a14f668p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1478p+17,                0x1.8p+1,   0x1.3649876830258p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1da8p+17,                0x1.8p+1,   0x1.164fecf967e06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.740e84822p+35,                0x1.8p+0,   0x1.3d29052475dbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c918p+17,                0x1.8p+1,   0x1.0be2788ee753ep+53,          0x1p-1, INEXACT)
T(RN,     0x1.86201feaa84p+42,                0x1.4p+0,   0x1.327ffd133b6f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db838p+17,                0x1.8p+1,   0x1.9a27f1b238b2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.569a0b8b2p+35,                0x1.8p+0,   0x1.18409e41d412ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df078p+17,                0x1.8p+1,   0x1.a352197c90398p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd178p+17,                0x1.8p+1,   0x1.f7532996321c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b0fea022p+35,                0x1.8p+0,   0x1.4628f4afd5944p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dffc8p+17,                0x1.8p+1,   0x1.a5d6c59139f54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8698p+17,                0x1.8p+1,   0x1.45dd765811386p+53,          0x1p-1, INEXACT)
T(RN,       0x1.76bb690f2p+35,                0x1.8p+0,   0x1.409659635149ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2128p+17,                0x1.8p+1,   0x1.5bc8231abb8eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec888p+17,                0x1.8p+1,   0x1.c7cabae857f18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4827905f2p+35,                0x1.8p+0,   0x1.06b6b28ff3b3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa358p+17,                0x1.8p+1,   0x1.eed29d38256aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef038p+17,                0x1.8p+1,   0x1.ceb6844863dacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5bf8p+17,                0x1.8p+1,    0x1.8b6aae09f214p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d90d8p+17,                0x1.8p+1,   0x1.93d223e4af972p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9748p+17,                0x1.8p+1,   0x1.bf4cb8473ecbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e94d8p+17,                0x1.8p+1,   0x1.bee1d47a8ec32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9f28p+17,                0x1.8p+1,   0x1.4948dc1f7d78ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3e472272p+35,                0x1.8p+0,   0x1.92314480d0236p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c26d8p+17,                0x1.8p+1,   0x1.5c9b41ecf7892p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6608p+17,                0x1.8p+1,    0x1.1f72edf9ecb2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57cf86b82p+35,                0x1.8p+0,    0x1.19bcb129b04bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbd28p+17,                0x1.8p+1,   0x1.9af48084ab42ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7938p+17,                0x1.8p+1,   0x1.68b28c921e25cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.61db76ff2p+35,                0x1.8p+0,   0x1.262d0df77d07ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6526bc302p+35,                0x1.8p+0,    0x1.2a4b10c342aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9d68p+17,                0x1.8p+1,   0x1.edbc3a985413ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6872a5e2p+35,                0x1.8p+0,   0x1.c311b9e1d501cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5498p+17,                0x1.8p+1,   0x1.1d3ac6f2c4326p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3d18p+17,                0x1.8p+1,   0x1.86904dd6438fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb808p+17,                0x1.8p+1,    0x1.4cc59d57eb28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96a68p+17,                0x1.8p+1,   0x1.00857cb76cb2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e45b8p+17,                0x1.8p+1,   0x1.b1780a8c82db4p+53,          0x1p-1, INEXACT)
T(RN,            0x1.41f8p+13,                  0x1p+2,    0x1.4042fe473df8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ec42ab242p+35,                0x1.8p+0,   0x1.e2ad89e7c2b98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce878p+17,                0x1.8p+1,   0x1.79774a8ae0218p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2748p+17,                0x1.8p+1,   0x1.ac61ab11087bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0c78p+17,                0x1.8p+1,   0x1.3536d9827b0d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d0f8ecd22p+35,                0x1.8p+0,   0x1.bb1aa3c0cb164p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db2d8p+17,                0x1.8p+1,   0x1.99498ffe728d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.91be2ee42p+35,                0x1.8p+0,   0x1.63dddf70d6a18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc558p+17,                0x1.8p+1,   0x1.4ea5f9696ba0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e532d522p+35,                0x1.8p+0,   0x1.35dc02a88499cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a751ac9b2p+35,                0x1.8p+0,   0x1.80eaab15566f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f271aa12p+35,                0x1.8p+0,   0x1.0f29880e490b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9528p+17,                0x1.8p+1,   0x1.47e3ba83a38aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd6a8p+17,                0x1.8p+1,   0x1.76bf36262a936p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.acbe8p+17,                0x1.8p+1,   0x1.2ca53dd8f1832p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e90e521f2p+35,                0x1.8p+0,   0x1.ddf8efc92cebap+53,          0x1p-1, INEXACT)
T(RN,       0x1.801d21dc2p+35,                0x1.8p+0,   0x1.4cb39ba72dbe8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d793bc502p+35,                0x1.8p+0,    0x1.c49422e536a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d41a8p+17,                0x1.8p+1,   0x1.87474010ebec6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1b98p+17,                0x1.8p+1,   0x1.160e01c1c72f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e3f22b752p+35,                0x1.8p+0,   0x1.d68032d28ab8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5435c872p+35,                0x1.8p+0,   0x1.c1406b64bfd76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9cc8p+17,                0x1.8p+1,   0x1.c03e26d8687c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8258p+17,                0x1.8p+1,   0x1.91812360c7ffap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd54d9012p+35,                0x1.8p+0,   0x1.b5e8e3fbb420ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.add68p+17,                0x1.8p+1,   0x1.2ef3c5f4dbd3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.740cd00e2p+35,                0x1.8p+0,   0x1.3d26d70ff66fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2bf39622p+35,                0x1.8p+0,   0x1.909bb4cad3304p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72c40dbb2p+35,                0x1.8p+0,   0x1.3b82d484452cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6b68p+17,                0x1.8p+1,   0x1.2022a6c0240dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3108p+17,                0x1.8p+1,    0x1.ae01bd68a2f3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73ca556e2p+35,                0x1.8p+0,   0x1.3cd1d9bb0af44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae238p+17,                0x1.8p+1,   0x1.2f96b2864a50cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9338p+17,                0x1.8p+1,   0x1.6c922b082813cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5176bdf22p+35,                0x1.8p+0,   0x1.11f8c87be0ca4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a19e8p+17,                0x1.8p+1,   0x1.15d81a81683d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.69cae2ba2p+35,                0x1.8p+0,   0x1.3020687d51e8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.627e7b1c2p+35,                0x1.8p+0,   0x1.26f86dc8b4498p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd0a8p+17,                0x1.8p+1,   0x1.9e1ef908f3116p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa678p+17,                0x1.8p+1,   0x1.ef654bf6cd9b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9388p+17,                0x1.8p+1,   0x1.47a9ca496cd28p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef5c2f562p+35,                0x1.8p+0,   0x1.e73e7a6e94834p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fff88p+17,                0x1.8p+1,   0x1.ffe980545f968p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d93d8p+17,                0x1.8p+1,   0x1.944d1d463c582p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e48bd3e72p+35,                0x1.8p+0,   0x1.d76059faf414ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ffd500e72p+35,                0x1.8p+0,   0x1.ffbf82b5564b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.81c288922p+35,                0x1.8p+0,   0x1.4ed7b106e46e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b14f8p+17,                0x1.8p+1,    0x1.365ab7ab1fdfp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b66d8p+17,                0x1.8p+1,   0x1.417ae9d36f492p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eae3e1c72p+35,                0x1.8p+0,   0x1.e0a9f5fb4cd0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2858p+17,                0x1.8p+1,   0x1.ac8ef5588ae1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa9086c72p+35,                0x1.8p+0,   0x1.855a0e912170ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd178p+17,                0x1.8p+1,   0x1.f7532996321c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.abe282692p+35,                0x1.8p+0,   0x1.8729295e48ba2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.afc763392p+35,                0x1.8p+0,   0x1.8c833ef133502p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee258p+17,                0x1.8p+1,   0x1.cc49108beb1fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a35e8p+17,                0x1.8p+1,   0x1.195a069b53312p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7480c7c42p+35,                0x1.8p+0,   0x1.3dbb2b449bca8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3f66ec62p+35,                0x1.8p+0,   0x1.bf62a778a93d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.66afb3772p+35,                0x1.8p+0,   0x1.2c37e70ce0b96p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51c4b29a2p+35,                0x1.8p+0,   0x1.1257bcd77e834p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5af8p+13,                  0x1p+2,    0x1.afed9e2f0d54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.93c097c72p+35,                0x1.8p+0,   0x1.668a3a781c6f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b22d83d2p+35,                0x1.8p+0,   0x1.464163d29777ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed248p+17,                0x1.8p+1,   0x1.c97c5adec6eccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b62c3e62p+35,                0x1.8p+0,   0x1.1e249b3158c94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b18f58652p+35,                0x1.8p+0,   0x1.8ef7f7d86c8aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ce9af622p+35,                0x1.8p+0,   0x1.72cf9c9becf04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72b823f22p+35,                0x1.8p+0,   0x1.3b739fb8408a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd5e8p+17,                0x1.8p+1,   0x1.9ef9e2a8c5112p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff7f8p+17,                0x1.8p+1,    0x1.fe7ee0b847e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c2051682p+35,                0x1.8p+0,    0x1.1f0eef185fc9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.afa47e7a2p+35,                0x1.8p+0,   0x1.8c532f2fe66f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f37e8p+17,                0x1.8p+1,   0x1.db642f4b82e72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57b54e402p+35,                0x1.8p+0,    0x1.199c76efb6a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb868p+17,                0x1.8p+1,   0x1.7228c52d98acap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e6030262p+35,                0x1.8p+0,   0x1.0e384411235ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6ac8p+17,                0x1.8p+1,   0x1.e4872c8fb0c64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab168p+17,                0x1.8p+1,   0x1.292cb9fb39afap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc2e8p+17,                0x1.8p+1,   0x1.f4a150c06b702p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ed661d32p+35,                0x1.8p+0,   0x1.7568132280d62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0958p+17,                0x1.8p+1,   0x1.7e84cfdb1e0cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a8c89f5a2p+35,                0x1.8p+0,   0x1.82ea82e3817b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7e28p+17,                0x1.8p+1,   0x1.44b22859b56dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.742d35552p+35,                0x1.8p+0,   0x1.3d50444abfdcap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bac58p+17,                0x1.8p+1,   0x1.4b215f9fef0dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc898p+17,                0x1.8p+1,   0x1.f5ae7265bbee6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4958p+17,                0x1.8p+1,   0x1.de8289025eccap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b159faad2p+35,                0x1.8p+0,   0x1.8eae5085a9a66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8658p+17,                0x1.8p+1,   0x1.e986ca77e7abap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff268p+17,                0x1.8p+1,   0x1.fd749508200aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0d08p+17,                0x1.8p+1,    0x1.58dfc503e787p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb1ffc292p+35,                0x1.8p+0,   0x1.f8b470d5d0c22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3d38p+17,                0x1.8p+1,   0x1.5fdd0ee7f2b1cp+53,          0x1p-1, INEXACT)
T(RN,               0x1.d9p+8,                0x1.8p+2,   0x1.3e491f6f63868p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99d4e3be2p+35,                0x1.8p+0,   0x1.6eab0b94bf1dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4ae655ba2p+35,                0x1.8p+0,   0x1.0a04654571f74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e86fb9a2p+35,                0x1.8p+0,   0x1.0e674c5230234p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b607586b2p+35,                0x1.8p+0,   0x1.95271ec903b6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.adcb38c52p+35,                0x1.8p+0,   0x1.89c80f5fa5a16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5dc964f2p+35,                0x1.8p+0,   0x1.c21c86e0b00e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49701f3b2p+35,                0x1.8p+0,   0x1.0841a3593bfcep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97758p+17,                0x1.8p+1,   0x1.020e00cea606ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.df2a44d82p+35,                0x1.8p+0,    0x1.cf8bc45f237fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.79aa4d2a2p+35,                0x1.8p+0,   0x1.445bd347609d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7354c61c2p+35,                0x1.8p+0,   0x1.3c3ba131da298p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd1083532p+35,                0x1.8p+0,   0x1.b5879b4b0e062p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbf28p+17,                0x1.8p+1,   0x1.f3f0126d3ad8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d958p+17,                0x1.8p+1,   0x1.0dde2e28ccfcap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5c08p+17,                0x1.8p+1,    0x1.b53947a9c114p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9768p+17,                0x1.8p+1,   0x1.94df45d42931ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca188p+17,                0x1.8p+1,   0x1.6eb70d72f83c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b046270e2p+35,                0x1.8p+0,   0x1.8d31e9ad46cfcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1fa8p+17,                0x1.8p+1,   0x1.ab1d02aa37366p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2d88p+17,                0x1.8p+1,   0x1.ad6c428cf4608p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9708p+17,                0x1.8p+1,    0x1.ec91c910a125p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6878p+17,                0x1.8p+1,   0x1.8d64940d31a18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0938p+17,                0x1.8p+1,   0x1.34c7713b7ed5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b28d78582p+35,                0x1.8p+0,    0x1.9056f179cdd1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdd08p+17,                0x1.8p+1,    0x1.f978a79c3ef7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb078p+17,                0x1.8p+1,   0x1.4bb58925a1798p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f80fb2a2p+35,                0x1.8p+0,   0x1.60e550bccaa2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c3d55122p+35,                0x1.8p+0,   0x1.71e789a45c3e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9ef8p+17,                0x1.8p+1,    0x1.9615feac8c7dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a238p+17,                0x1.8p+1,   0x1.072dfaf87290cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b847664d2p+35,                0x1.8p+0,   0x1.98475fcee97a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0eb8p+17,                0x1.8p+1,   0x1.d41443a07fc64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6ad8p+17,                0x1.8p+1,   0x1.66915366c4752p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e51347e2p+35,                0x1.8p+0,   0x1.74b4510e3015cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1ab8p+17,                0x1.8p+1,   0x1.aa4b1f93032a4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.94debba22p+35,                0x1.8p+0,   0x1.6807a396be984p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d270b0d82p+35,                0x1.8p+0,    0x1.bd3433e6f501p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7aa53fbb2p+35,                0x1.8p+0,   0x1.459f534835132p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9dd9a182p+35,                0x1.8p+0,    0x1.df28f00ac287p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4278p+17,                0x1.8p+1,   0x1.1aef54fa12ef8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd128p+17,                0x1.8p+1,   0x1.5051b7cb181eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.562fbc592p+35,                0x1.8p+0,   0x1.17be36d58973ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7378p+17,                0x1.8p+1,   0x1.b930f20b0c428p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f04e45142p+35,                0x1.8p+0,   0x1.e8a3d3977b2c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c196163c2p+35,                0x1.8p+0,   0x1.a54b180869dd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2f968352p+35,                0x1.8p+0,   0x1.d5159a7f2ae0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9b38b4f2p+35,                0x1.8p+0,   0x1.c7a3de131d6e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c088p+17,                0x1.8p+1,   0x1.0ad7f35d35d98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c202d0012p+35,                0x1.8p+0,   0x1.a5e3f4832a00ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ae69e0e2p+35,                0x1.8p+0,   0x1.45f3a95a4b2fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.79dc1f0c2p+35,                0x1.8p+0,   0x1.449c03f306508p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.433b69182p+35,                0x1.8p+0,    0x1.00d31ba9f8e7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc3ec4d12p+35,                0x1.8p+0,   0x1.fa60ccc988552p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9758d8282p+35,                0x1.8p+0,    0x1.6b56c137d441p+53,          0x1p-1, INEXACT)
T(RN,       0x1.86bba3352p+35,                0x1.8p+0,   0x1.55569e531a80ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc54b1cf2p+35,                0x1.8p+0,   0x1.b47c5db23e9e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f376e3092p+35,                0x1.8p+0,   0x1.ed4fea65b579ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.99648p+17,                0x1.8p+1,   0x1.05bef6afcaf8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c3821842p+35,                0x1.8p+0,   0x1.47a78ff3efa28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf7d8p+17,                0x1.8p+1,   0x1.7bd2d18604a42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bee18p+17,                0x1.8p+1,   0x1.546f967b3e9aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c19256af2p+35,                0x1.8p+0,   0x1.a545d34bc67dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce9b9bcb2p+35,                0x1.8p+0,   0x1.b7ba781cda752p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b6f8b372p+35,                0x1.8p+0,   0x1.5b84ed51d83eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3538p+17,                0x1.8p+1,   0x1.5eb258823419cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe428p+17,                0x1.8p+1,   0x1.facc099815cfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50d950572p+35,                0x1.8p+0,   0x1.1139283d8f1d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdfb8p+17,                0x1.8p+1,   0x1.7820f025e8894p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d53bb3e52p+35,                0x1.8p+0,   0x1.c1356be78e9aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.df3012cb2p+35,                0x1.8p+0,   0x1.cf9430aa68aaep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf458p+17,                0x1.8p+1,   0x1.7b4935b96025ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd237e2c2p+35,                0x1.8p+0,   0x1.b5a29fd118c38p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8598p+17,                0x1.8p+1,   0x1.e963dafe5e9d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8588p+17,                0x1.8p+1,   0x1.45b7bb8ae7688p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5b08p+13,                  0x1p+2,    0x1.b03d4f83782cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2258p+17,                0x1.8p+1,   0x1.d78dc88c65dfap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cffd796c2p+35,                0x1.8p+0,   0x1.b9b3647ba40b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da008p+17,                0x1.8p+1,     0x1.9641b31dd8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c99b8p+17,                0x1.8p+1,   0x1.6d8b2d5b1c974p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e03aedf2p+35,                0x1.8p+0,   0x1.35772bb2e583ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9788p+17,                0x1.8p+1,   0x1.483874ab195e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a0d9e10a2p+35,                0x1.8p+0,   0x1.7820f025e8894p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b33abc692p+35,                0x1.8p+0,   0x1.9146791abf7a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.840578fc2p+35,                0x1.8p+0,   0x1.51ca949ffaaa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.560f09c32p+35,                0x1.8p+0,   0x1.17961f27f1b42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2338p+17,                0x1.8p+1,   0x1.d7b58bb09cc3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cca08p+17,                0x1.8p+1,    0x1.74d3e121bbdep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1858p+17,                0x1.8p+1,   0x1.80d6d3988931ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e2e175a2p+35,                0x1.8p+0,   0x1.0dfb8c253384cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de2b01e22p+35,                0x1.8p+0,   0x1.ce198c692c804p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9810ab7d2p+35,                0x1.8p+0,   0x1.6c4ccfccb84fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da5b8p+17,                0x1.8p+1,   0x1.972bdb83bafb4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf658p+17,                0x1.8p+1,   0x1.7b97d3d28d7bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e749f9e2p+35,                0x1.8p+0,   0x1.5f81f96490364p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daf88p+17,                0x1.8p+1,   0x1.98c0ab79a6a68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf3c8p+17,                0x1.8p+1,   0x1.7b331b3726114p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fbb54fe52p+35,                0x1.8p+0,   0x1.f9936d32f8e56p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3808p+13,                  0x1p+2,     0x1.1a83fffd34ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c99021d2p+35,                0x1.8p+0,   0x1.0c113b5ae2e46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c9521f962p+35,                0x1.8p+0,   0x1.b0362d09a824cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb8d8p+17,                0x1.8p+1,   0x1.4ce2e179d74f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1958p+17,                0x1.8p+1,   0x1.36f1390962bcap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7378p+17,                0x1.8p+1,   0x1.43381135e3428p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc078p+17,                0x1.8p+1,   0x1.7360d9b5cea98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1e08p+17,                0x1.8p+1,    0x1.5b54475d85dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7a98p+17,                0x1.8p+1,   0x1.e76436ed8a746p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab4f8p+17,                0x1.8p+1,    0x1.29a3c5eb06bfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.851009f92p+35,                0x1.8p+0,   0x1.5326e6fd9947ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec40b51c2p+35,                0x1.8p+0,   0x1.e2aaa7853a898p+53,          0x1p-1, INEXACT)
T(RN,           0x1.adad8p+17,                0x1.8p+1,   0x1.2e9d1d4ca3452p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d688p+17,                0x1.8p+1,   0x1.0d8620facddb8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e68635c52p+35,                0x1.8p+0,   0x1.da440896cc416p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bd2b06a72p+35,                0x1.8p+0,   0x1.9f192ee5d5936p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9abd96d2p+35,                0x1.8p+0,   0x1.c798c3f4ef41ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eca68p+17,                0x1.8p+1,   0x1.c81e0946a1d2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e127a69d2p+35,                0x1.8p+0,   0x1.d26fb35b1d0bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5340b532p+35,                0x1.8p+0,   0x1.c12a6c9850f9ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.967e8p+17,                0x1.8p+1,   0x1.0039d18125f72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ac0c5132p+35,                0x1.8p+0,   0x1.45c2d4106cbe2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.85fb8a8c2p+35,                0x1.8p+0,   0x1.545b054d65a08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae4b8p+17,                0x1.8p+1,   0x1.2feb6c591ee84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbba8p+17,                0x1.8p+1,   0x1.9ab6546ca76a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8fb8p+17,                0x1.8p+1,   0x1.4721f664c9994p+53,          0x1p-1, INEXACT)
T(RN,       0x1.84cdccb22p+35,                0x1.8p+0,   0x1.52d04dcb4e024p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e335a19f2p+35,                0x1.8p+0,   0x1.d56d5a44c0dbap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd828p+17,                0x1.8p+1,   0x1.514fddc3e04bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c6a4fd5c2p+35,                0x1.8p+0,   0x1.ac6c52d85b0e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e85c8p+17,                0x1.8p+1,   0x1.bc4ec7e3c8674p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e59b8p+17,                0x1.8p+1,   0x1.b4d5661fa5d74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.574c76602p+35,                0x1.8p+0,    0x1.191ba69b589cp+53,          0x1p-1, INEXACT)
T(RN,            0x1.4898p+13,                  0x1p+2,   0x1.5b722c6010488p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3508p+13,                  0x1p+2,    0x1.0fce71390f94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a477d80a2p+35,                0x1.8p+0,   0x1.7d08e9bb86e94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c47b8p+17,                0x1.8p+1,   0x1.61661f7680414p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2ae8p+17,                0x1.8p+1,   0x1.17f85ff96e682p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8328p+17,                0x1.8p+1,   0x1.bbdc2f768d44ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b888p+17,                0x1.8p+1,   0x1.09df905432c18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0fc8p+17,                0x1.8p+1,   0x1.59453d1d7d254p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd478p+17,                0x1.8p+1,   0x1.f7e1956b76658p+53,          0x1p-1, INEXACT)
T(RN,       0x1.567126352p+35,                0x1.8p+0,   0x1.180e71aff6df6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b03db512p+35,                0x1.8p+0,   0x1.31ab5f199b052p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ecf339f32p+35,                0x1.8p+0,   0x1.e3b14f9c4665ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6e98p+17,                0x1.8p+1,   0x1.671f59b7eab06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c3ab4e02p+35,                0x1.8p+0,    0x1.1f2f935ca92cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb0221402p+35,                0x1.8p+0,    0x1.f887dfd60788p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac808p+17,                0x1.8p+1,    0x1.2c22e33ee858p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdba8p+17,                0x1.8p+1,   0x1.7782438009ca6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9d78p+17,                0x1.8p+1,   0x1.95d8509004008p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96ed8p+17,                0x1.8p+1,   0x1.010bf14c31a12p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e66cbb02p+35,                0x1.8p+0,    0x1.74d1738630dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d02efb412p+35,                0x1.8p+0,   0x1.b9fa17de7ea8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e766840e2p+35,                0x1.8p+0,   0x1.db8c299581104p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d62a8p+17,                0x1.8p+1,   0x1.8c79205aea176p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cadc8p+17,                0x1.8p+1,   0x1.708e8bb8e55f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8148p+17,                0x1.8p+1,   0x1.e89b1a448ee9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be498p+17,                0x1.8p+1,   0x1.5314aa90d0626p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6003e0ed2p+35,                0x1.8p+0,   0x1.23e1bf4f062e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.624ae6142p+35,                0x1.8p+0,   0x1.26b80e7eaf338p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.440559892p+35,                0x1.8p+0,   0x1.01c3ee7e7b362p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3b78p+17,                0x1.8p+1,   0x1.afc05095be9a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d236cae2p+35,                0x1.8p+0,   0x1.204fa5f9acec4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5db820652p+35,                0x1.8p+0,   0x1.2107eadbfb8aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97873b4d2p+35,                0x1.8p+0,   0x1.6b94d349471a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5a58p+17,                0x1.8p+1,   0x1.6422279f5847ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d1008c882p+35,                0x1.8p+0,    0x1.bb2589ad371dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b67f8p+17,                0x1.8p+1,    0x1.41a283fe7a38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45c839bd2p+35,                0x1.8p+0,   0x1.03deaf049b386p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f330c422p+35,                0x1.8p+0,   0x1.22de298c48fc4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c2b6e2912p+35,                0x1.8p+0,   0x1.a6e148bbb322ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebd38p+17,                0x1.8p+1,   0x1.c5d4f5000231cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad2b8p+17,                0x1.8p+1,   0x1.2d8ac4fc2fd24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7738p+17,                0x1.8p+1,   0x1.21a5d02682ffcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3958p+17,                0x1.8p+1,   0x1.19c8c7a1ad1cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3bf8p+17,                0x1.8p+1,    0x1.86633a7111b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1b28p+17,                0x1.8p+1,   0x1.1600078108ccep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab4a8p+17,                0x1.8p+1,   0x1.29995351af5d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f708p+17,                0x1.8p+1,    0x1.11842f7d8845p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8f962ea82p+35,                0x1.8p+0,    0x1.6101688d422fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd028p+17,                0x1.8p+1,   0x1.9e0a23c19bf3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3aa8p+17,                0x1.8p+1,   0x1.3b7173a5515f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dbe88p+17,                0x1.8p+1,   0x1.9b2d83c814938p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff608p+17,                0x1.8p+1,    0x1.fe221500e562p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8776ac092p+35,                0x1.8p+0,   0x1.564bd1961b99ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae375c722p+35,                0x1.8p+0,   0x1.8a5cb6d18c25cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff538p+17,                0x1.8p+1,   0x1.fdfb2e46cb59cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf738p+17,                0x1.8p+1,   0x1.55bdaf2a7f7fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf1ba1822p+35,                0x1.8p+0,   0x1.a1d087d1fbbbcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.741c28462p+35,                0x1.8p+0,   0x1.3d3a7624824d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0f138c82p+35,                0x1.8p+0,    0x1.a46371275785p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fcf22b5c2p+35,                0x1.8p+0,   0x1.fb6d012f784e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63ad9d232p+35,                0x1.8p+0,   0x1.2873184022602p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc078p+17,                0x1.8p+1,   0x1.7360d9b5cea98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.640951c22p+35,                0x1.8p+0,   0x1.28e5c679cf93cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5592d7c92p+35,                0x1.8p+0,   0x1.16fde81d8fd1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4c38p+17,                0x1.8p+1,   0x1.b28f7ed99faecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9e48p+17,                0x1.8p+1,   0x1.26afc0d14190cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edf88p+17,                0x1.8p+1,   0x1.cbcb5c32e8368p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60d69ca42p+35,                0x1.8p+0,   0x1.24e8009656498p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51b474392p+35,                0x1.8p+0,   0x1.1243f2cadbcfep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cc98p+17,                0x1.8p+1,   0x1.0c4f9ce164da6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ec728p+17,                0x1.8p+1,   0x1.c78daa04ec30ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c90082d2p+35,                0x1.8p+0,   0x1.33a04a9239d66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f308p+17,                0x1.8p+1,    0x1.1105da58b939p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a29bb3c22p+35,                0x1.8p+0,   0x1.7a82660ec253cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7026ac342p+35,                0x1.8p+0,   0x1.382de7074e3f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.544c6f3d2p+35,                0x1.8p+0,   0x1.156e5f5934686p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83fe82222p+35,                0x1.8p+0,   0x1.51c17c940957cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9d5c7942p+35,                0x1.8p+0,   0x1.f6c7cf58d8c38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae738p+17,                0x1.8p+1,   0x1.304035edf74fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fabe78932p+35,                0x1.8p+0,   0x1.f822e526c82e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4398p+17,                0x1.8p+1,   0x1.60cb918cec676p+53,          0x1p-1, INEXACT)
T(RN,       0x1.479ab89b2p+35,                0x1.8p+0,   0x1.060da27a6fef2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9938p+17,                0x1.8p+1,   0x1.ecf823b51185cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf2d8p+17,                0x1.8p+1,   0x1.551d65099f4d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52e6171b2p+35,                0x1.8p+0,   0x1.13b89bdcecbf2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c4ee47b82p+35,                0x1.8p+0,    0x1.aa00cc2913ebp+53,          0x1p-1, INEXACT)
T(RN,           0x1.abfb8p+17,                0x1.8p+1,   0x1.2b0bc11364294p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e9ef8ea2p+35,                0x1.8p+0,   0x1.5fba04c5430acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eeef8p+17,                0x1.8p+1,    0x1.ce7e70d26c6dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4bb77bb32p+35,                0x1.8p+0,   0x1.0b00c25c84522p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e3ca24b2p+35,                0x1.8p+0,   0x1.0e0d2bf598452p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd3679692p+35,                0x1.8p+0,   0x1.b5bda573d925ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2a88p+17,                0x1.8p+1,   0x1.394255780d578p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd5a8p+17,                0x1.8p+1,   0x1.9eef744341c86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98058p+17,                0x1.8p+1,   0x1.031ffa6c28a9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a47b78032p+35,                0x1.8p+0,   0x1.7d0dd7287efc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd6f6d782p+35,                0x1.8p+0,    0x1.b60ebd0896c3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bce28p+17,                0x1.8p+1,   0x1.4fe4f33754ddep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f801ff72p+35,                0x1.8p+0,   0x1.0f95988028d6ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.62f4ad092p+35,                0x1.8p+0,   0x1.278bfffc1f462p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b2a744612p+35,                0x1.8p+0,   0x1.907a98238a132p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1bf399e2p+35,                0x1.8p+0,   0x1.bc3637da5c09cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4748p+17,                0x1.8p+1,   0x1.de23ecd541dbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2d88p+17,                0x1.8p+1,   0x1.ad6c428cf4608p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5b08p+17,                0x1.8p+1,    0x1.3fdbdb41bf71p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a34d001d2p+35,                0x1.8p+0,   0x1.7b72f85c9b5bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4cd8p+17,                0x1.8p+1,   0x1.1c3f34de1bab2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4358p+17,                0x1.8p+1,   0x1.b1120cbd2a4aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0278p+17,                0x1.8p+1,   0x1.575ac200102f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca928p+17,                0x1.8p+1,   0x1.6fdc59157966ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcd48p+17,                0x1.8p+1,   0x1.9d9266f6680dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be4889062p+35,                0x1.8p+0,   0x1.a0a8c4eba7aacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab208p+17,                0x1.8p+1,    0x1.29419a56d996p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf3a8p+17,                0x1.8p+1,   0x1.7b2e31e2bbd26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c06e8p+17,                0x1.8p+1,   0x1.57fe0c9f199c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c98b8p+17,                0x1.8p+1,   0x1.6d64d6dbabc44p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb978p+17,                0x1.8p+1,   0x1.c52ef10229d48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce3c92ca2p+35,                0x1.8p+0,   0x1.b732fe7244a14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4ab8p+17,                0x1.8p+1,   0x1.dec1a2b997ba4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2528p+17,                0x1.8p+1,   0x1.173ff938a3baep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.637847732p+35,                0x1.8p+0,   0x1.28306cb2c44a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8cf8p+17,                0x1.8p+1,    0x1.bd88f2bf1047p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6b28p+17,                0x1.8p+1,   0x1.669d27d47a3cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb6e8p+17,                0x1.8p+1,   0x1.4c9d1a741d2c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d664a8212p+35,                0x1.8p+0,   0x1.c2e01b723e24ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fae88p+17,                0x1.8p+1,   0x1.f0e042bb9c638p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce898p+17,                0x1.8p+1,   0x1.797c3014524e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c9dd81e2p+35,                0x1.8p+0,   0x1.0c1714164de64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0658p+17,                0x1.8p+1,   0x1.3464fa12c62bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c32f02f12p+35,                0x1.8p+0,   0x1.a78a63d63b8eep+53,          0x1p-1, INEXACT)
T(RN,            0x1.3228p+13,                  0x1p+2,   0x1.05d4fa2af0bb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad588p+17,                0x1.8p+1,   0x1.2de9a95fdf588p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90e9b3082p+35,                0x1.8p+0,    0x1.62c3b06eb553p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5aa5cda2p+35,                0x1.8p+0,   0x1.7ea9de220214cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b32b8p+17,                0x1.8p+1,   0x1.3a5de74572f24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7d68p+17,                0x1.8p+1,   0x1.6951c7b48bb3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98198p+17,                0x1.8p+1,   0x1.0346171150b16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2878p+17,                0x1.8p+1,   0x1.5cd7a38d65e18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4e88p+17,                0x1.8p+1,   0x1.6265c1f43e438p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0ba8p+17,                0x1.8p+1,   0x1.7ee03baaddda6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5308p+17,                0x1.8p+1,    0x1.8a01fe19db59p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2238p+17,                0x1.8p+1,   0x1.38231e050f10cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e188p+17,                0x1.8p+1,   0x1.0edeef3197fc8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c0a8p+17,                0x1.8p+1,   0x1.0adbd62314616p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6b52f522p+35,                0x1.8p+0,   0x1.c353e8201ca64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb208p+17,                0x1.8p+1,    0x1.c3e6252ce596p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6f6de82a2p+35,                0x1.8p+0,   0x1.37430157657d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf9b8p+17,                0x1.8p+1,   0x1.56195dc4b4b74p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1488p+17,                0x1.8p+1,   0x1.152c97c548558p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.43c4213f2p+35,                0x1.8p+0,   0x1.01761f0b1d4fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.98898p+17,                0x1.8p+1,   0x1.041bc958cb2e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5538p+17,                0x1.8p+1,   0x1.b41334cab479cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c50e42d02p+35,                0x1.8p+0,    0x1.aa2deb7cf7cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba8aca012p+35,                0x1.8p+0,   0x1.9b6e53b52340ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7a3aa4782p+35,                0x1.8p+0,    0x1.4515d89db623p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bfb28p+17,                0x1.8p+1,   0x1.564e1cc96d6cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fd7fc8a02p+35,                0x1.8p+0,    0x1.fc40d962c9c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b42e8p+17,                0x1.8p+1,   0x1.3c9083a851f02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcc18p+17,                0x1.8p+1,   0x1.4f9a39add084ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a038p+17,                0x1.8p+1,   0x1.06f065bd36eacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f51c8p+17,                0x1.8p+1,   0x1.e0061582a98b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be7cd2f02p+35,                0x1.8p+0,    0x1.a0f2011c2826p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac60b39e2p+35,                0x1.8p+0,   0x1.87d640f3d449cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5121cff2p+35,                0x1.8p+0,   0x1.d8245ba7c6386p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2018p+17,                0x1.8p+1,   0x1.d72793dfc860ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eeff8p+17,                0x1.8p+1,     0x1.ceab4cd3fcdp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f4c4f0ff2p+35,                0x1.8p+0,   0x1.ef3f25fbbbb86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.899c8c522p+35,                0x1.8p+0,   0x1.591e068966c64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.676ea2862p+35,                0x1.8p+0,   0x1.2d27be2bc5654p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db198p+17,                0x1.8p+1,   0x1.9915e40f13c16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.caba8p+17,                0x1.8p+1,   0x1.703ca4aaf5ba6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7708p+17,                0x1.8p+1,    0x1.b9cbdccd35c5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc048p+17,                0x1.8p+1,   0x1.f4253a542356cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d96a8p+17,                0x1.8p+1,   0x1.94c07dbbead36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f448p+17,                0x1.8p+1,   0x1.112d50c588b2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6de8p+17,                0x1.8p+1,   0x1.8e412b514e192p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79f2755f2p+35,                0x1.8p+0,   0x1.44b8cd112c53ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.4548p+13,                  0x1p+2,    0x1.4da56fb29581p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.de2d8p+17,                0x1.8p+1,   0x1.a116a26c049d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be618p+17,                0x1.8p+1,   0x1.534b61cd49c2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c41bb1702p+35,                0x1.8p+0,    0x1.a8d7d4e600b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd548p+17,                0x1.8p+1,   0x1.9edfcefee5a5cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac6d81ff2p+35,                0x1.8p+0,   0x1.87e7d32e6d986p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cda18p+17,                0x1.8p+1,   0x1.77454810837eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eeb28p+17,                0x1.8p+1,   0x1.cdd384a655bcep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb5f8p+17,                0x1.8p+1,    0x1.c49422e536a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1dc8p+17,                0x1.8p+1,   0x1.5b4b03b2caaf4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1028p+17,                0x1.8p+1,   0x1.35b5617dcdb3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d62192112p+35,                0x1.8p+0,   0x1.c27faaaedb6d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99377c2a2p+35,                0x1.8p+0,   0x1.6dd7e26551fd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c16afc582p+35,                0x1.8p+0,    0x1.a50e8435ef51p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c288p+17,                0x1.8p+1,   0x1.0b162442161f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c22850e72p+35,                0x1.8p+0,   0x1.a618b30a13b4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3fe71fc2p+35,                0x1.8p+0,   0x1.7c63f084120a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd0e8p+17,                0x1.8p+1,   0x1.9e2963efb3ea2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.576507892p+35,                0x1.8p+0,   0x1.1939d3e81f762p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.885f65cd2p+35,                0x1.8p+0,   0x1.577d3d3b1215ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5ec8p+17,                0x1.8p+1,   0x1.e25ccb78b4e24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad1e8p+17,                0x1.8p+1,   0x1.2d6f5ee327a52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc758p+17,                0x1.8p+1,   0x1.746b81864476ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9add8p+17,                0x1.8p+1,   0x1.0894acca26762p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc398p+17,                0x1.8p+1,   0x1.4e66b9bf6ee76p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0ff8d292p+35,                0x1.8p+0,   0x1.e9a9bb9b065dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed458p+17,                0x1.8p+1,   0x1.c9d83882e8c5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9aa58p+17,                0x1.8p+1,   0x1.08288c1a30b7ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.78ef29892p+35,                0x1.8p+0,   0x1.436adac831362p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4e58p+17,                0x1.8p+1,   0x1.1c6fda393543ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea2c8p+17,                0x1.8p+1,   0x1.c145eb3493ee4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ada38p+17,                0x1.8p+1,   0x1.2e87fcea59b8cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6459641a2p+35,                0x1.8p+0,   0x1.2949f45b2c8ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d42826bd2p+35,                0x1.8p+0,   0x1.bfa9f5cd0427ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce1d8p+17,                0x1.8p+1,   0x1.787401aa7eb22p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8df8p+17,                0x1.8p+1,    0x1.935c61a52f2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.bc43e5192p+35,                0x1.8p+0,   0x1.9dd6119dd3b42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c828p+17,                0x1.8p+1,   0x1.0bc54192859bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da3e17e32p+35,                0x1.8p+0,   0x1.c86bd30ad3c7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0548p+17,                0x1.8p+1,   0x1.a6bef4bb4735cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1cb8p+17,                0x1.8p+1,   0x1.aaa01bc613104p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8e1616b2p+35,                0x1.8p+0,   0x1.f55b98dbdf692p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7058p+17,                0x1.8p+1,   0x1.6761adc272f9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0d88p+17,                0x1.8p+1,   0x1.144da4cc44008p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d2f8p+17,                0x1.8p+1,    0x1.0d16b4530219p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3d88p+17,                0x1.8p+1,   0x1.3bd5695ebd908p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eaf197362p+35,                0x1.8p+0,   0x1.e0be189c07d74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.954421ca2p+35,                0x1.8p+0,   0x1.688eece8ddfecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eaee8p+17,                0x1.8p+1,   0x1.c35c2e5c63542p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.53e27bb42p+35,                0x1.8p+0,   0x1.14ecd86a7d0f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a16fb7092p+35,                0x1.8p+0,   0x1.78ebce8a0c062p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d088p+17,                0x1.8p+1,   0x1.0cca8928cc098p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b7b7a622p+35,                0x1.8p+0,   0x1.1e43247593d04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa005b952p+35,                0x1.8p+0,   0x1.8494bc09ae54ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdba8p+17,                0x1.8p+1,   0x1.51cf20b59eca6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4ae8p+17,                0x1.8p+1,   0x1.1c00677e59c82p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e65579802p+35,                0x1.8p+0,     0x1.d9fcc77fbd9p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e47f8p+17,                0x1.8p+1,    0x1.b1d8b8ecc2d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.551ee5e72p+35,                0x1.8p+0,   0x1.166fe6a589ab6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b0739902p+35,                0x1.8p+0,    0x1.31afa02a3a56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63aa47aa2p+35,                0x1.8p+0,   0x1.286eed3c4b2d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1348p+17,                0x1.8p+1,   0x1.3620b754617fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed9e8p+17,                0x1.8p+1,   0x1.cad0382e087d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfc78p+17,                0x1.8p+1,   0x1.a54b180869dd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8c8c7bd42p+35,                0x1.8p+0,   0x1.5cfccf6714248p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a3dc4b72p+35,                0x1.8p+0,   0x1.1cbae404dc916p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd058p+17,                0x1.8p+1,   0x1.f71dc8123c19ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.43a7813e2p+35,                0x1.8p+0,   0x1.0153fade0e8dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.801d21dc2p+35,                0x1.8p+0,   0x1.4cb39ba72dbe8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60eddb7d2p+35,                0x1.8p+0,   0x1.2504f325424fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e51ea462p+35,                0x1.8p+0,   0x1.21c6a696daf2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0c08p+17,                0x1.8p+1,    0x1.3527d8ae8724p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94f9697f2p+35,                0x1.8p+0,   0x1.682b3a565ea86p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a46b28422p+35,                0x1.8p+0,   0x1.7cf7ab13c583cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.998a8p+17,                0x1.8p+1,   0x1.0607e04cfda96p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fdc3a0512p+35,                0x1.8p+0,   0x1.fca66099aa9aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.710d75d82p+35,                0x1.8p+0,    0x1.3953a1c812e1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d318p+17,                0x1.8p+1,   0x1.0d1a9cab4b61ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5a98p+17,                0x1.8p+1,   0x1.b4fb2f4b78146p+53,          0x1p-1, INEXACT)
T(RN,       0x1.97be8d942p+35,                0x1.8p+0,   0x1.6bdede5fb7038p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.93a267052p+35,                0x1.8p+0,   0x1.66620449ee296p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c60e44342p+35,                0x1.8p+0,   0x1.ab9758d5f73f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5ce15fda2p+35,                0x1.8p+0,   0x1.1ffdd969d434cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4598p+17,                0x1.8p+1,   0x1.ddd68d9a7fdd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4bb5df962p+35,                0x1.8p+0,   0x1.0afed0ca7fdb4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da7211d32p+35,                0x1.8p+0,   0x1.c8b6ddfa16d62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf895d072p+35,                0x1.8p+0,   0x1.b90da2233fc76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4a28p+17,                0x1.8p+1,   0x1.61c188860531ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d8d9fdd2p+35,                0x1.8p+0,   0x1.5e50798bfcdc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5416a2c42p+35,                0x1.8p+0,   0x1.152c97c548558p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c13e8p+17,                0x1.8p+1,   0x1.59dd9692341b2p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.43ee48p+21,                0x1.4p+1,   0x1.46074e4660e76p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4898p+13,                  0x1p+2,   0x1.5b722c6010488p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3c78p+17,                0x1.8p+1,   0x1.5fc1069c8c9d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.511897a92p+35,                0x1.8p+0,   0x1.11862921342dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.469fbcf82p+35,                0x1.8p+0,    0x1.04e0b71e3d0dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62d35faf2p+35,                0x1.8p+0,   0x1.2762694364626p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aa50a47b2p+35,                0x1.8p+0,   0x1.85029a7a86d4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4460105c2p+35,                0x1.8p+0,   0x1.0230356d8fd18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f13affb2p+35,                0x1.8p+0,   0x1.0f11f7fd2a64ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86485b8a2p+35,                0x1.8p+0,   0x1.54bf9a0de4e6cp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.47a8p+13,                  0x1p+2,   0x1.577f6e7f0c698p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0ac8p+17,                0x1.8p+1,   0x1.13f62f3d02a64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ed28a352p+35,                0x1.8p+0,   0x1.4b0674176f5f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.440d4e1e2p+35,                0x1.8p+0,   0x1.01cd6cc46fd9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.af0c8p+17,                0x1.8p+1,   0x1.3185174aadb84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b26496c2p+35,                0x1.8p+0,   0x1.4645d54049f48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be4111002p+35,                0x1.8p+0,     0x1.a09e4f4ed9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdf98p+17,                0x1.8p+1,   0x1.f9f2a52ba05b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1038p+17,                0x1.8p+1,   0x1.7f94c577503acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.89ca258f2p+35,                0x1.8p+0,   0x1.595a00dbead9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e7b0adbb2p+35,                0x1.8p+0,   0x1.dbf8b7aa712cep+53,         -0x1p-1, INEXACT)
T(RN,          0x1.764488p+21,                0x1.4p+1,   0x1.d3d282a8e57dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e02d8p+17,                0x1.8p+1,   0x1.a65803dfa5fd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6145e2a22p+35,                0x1.8p+0,   0x1.25729aadbef84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e49f48f02p+35,                0x1.8p+0,    0x1.d77cbebe4be6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae2e31d82p+35,                0x1.8p+0,    0x1.8a501c54b69fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8d68p+17,                0x1.8p+1,   0x1.93455a253263ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf658p+17,                0x1.8p+1,   0x1.559d9c53a27bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e26d8p+17,                0x1.8p+1,   0x1.ac4f05e10d892p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2e28p+17,                0x1.8p+1,   0x1.d9a74f9d01fdep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d2a25862p+35,                0x1.8p+0,   0x1.0cc0c64e727acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f94a8p+17,                0x1.8p+1,   0x1.ec22b88700fd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5e58p+17,                0x1.8p+1,   0x1.1e781788a3f3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7bc2f7ce2p+35,                0x1.8p+0,   0x1.471028ee7dc7cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e70cc4f12p+35,                0x1.8p+0,   0x1.db08d70c5a312p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb268p+17,                0x1.8p+1,   0x1.f196aaabc14aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2868p+17,                0x1.8p+1,   0x1.17a82956457cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6358p+17,                0x1.8p+1,   0x1.e32f611e9aaaap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a234a5aa2p+35,                0x1.8p+0,   0x1.79f6a8442ded4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4de8p+17,                0x1.8p+1,   0x1.1c61a96be9b92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7cdda8542p+35,                0x1.8p+0,   0x1.487d9e1304748p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7927ccc82p+35,                0x1.8p+0,    0x1.43b3c2807005p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8aa906ca2p+35,                0x1.8p+0,   0x1.5a7f5cb242decp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8502178d2p+35,                0x1.8p+0,   0x1.5314aa90d0626p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f59c8p+17,                0x1.8p+1,   0x1.e1764ab612234p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c6235dc2p+35,                0x1.8p+0,   0x1.0bcefe54e2c18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.584249872p+35,                0x1.8p+0,   0x1.1a49ccd03dc8ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.98de8p+17,                0x1.8p+1,   0x1.04be45c975792p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8218p+17,                0x1.8p+1,   0x1.230b717a3036ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.84347cde2p+35,                0x1.8p+0,   0x1.5207fb35a391cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.da1d8p+17,                0x1.8p+1,   0x1.968c488516f22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dec79d162p+35,                0x1.8p+0,   0x1.cefca2fb626b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6cc8p+17,                0x1.8p+1,   0x1.b80e84baf8ec4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e44e8p+17,                0x1.8p+1,   0x1.b1552471b9262p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c08a8p+17,                0x1.8p+1,   0x1.583e8062d6796p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc8b8p+17,                0x1.8p+1,   0x1.f5b45db6ae544p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8448p+17,                0x1.8p+1,   0x1.91d03e71ba62cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fdc59f332p+35,                0x1.8p+0,   0x1.fca95d409a3dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7278p+17,                0x1.8p+1,   0x1.e5eb319b187f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6728p+17,                0x1.8p+1,   0x1.b71a9eb3f810ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc2f35ea2p+35,                0x1.8p+0,   0x1.cb3a368860eacp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5308p+17,                0x1.8p+1,    0x1.630ee18f9859p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f86e1602p+35,                0x1.8p+0,    0x1.76567ae7807cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cea78p+17,                0x1.8p+1,   0x1.79c5a836ffe78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8f38p+17,                0x1.8p+1,   0x1.6bf926c9d0c7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8918p+17,                0x1.8p+1,   0x1.23f23fcd2b93ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3cf8p+17,                0x1.8p+1,    0x1.868b4b82b857p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1ca8p+17,                0x1.8p+1,   0x1.aa9d73b8b9d56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3f18p+17,                0x1.8p+1,   0x1.3c0bc5ae8cc5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d19d8p+17,                0x1.8p+1,   0x1.81125c1ab31a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c5bb8e72p+35,                0x1.8p+0,   0x1.335e1728ff4b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8628p+17,                0x1.8p+1,   0x1.45cdecd673c5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ddb711382p+35,                0x1.8p+0,    0x1.cd7185ac3a5bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.920fb18d2p+35,                0x1.8p+0,   0x1.644a32af665dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9a632d52p+35,                0x1.8p+0,   0x1.9a2fb51193acap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fc64a1c92p+35,                0x1.8p+0,   0x1.fa9963e1fb11ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b67483fb2p+35,                0x1.8p+0,   0x1.95be9f31781b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bba58p+17,                0x1.8p+1,   0x1.4d18ed9ce567ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb8c8p+17,                0x1.8p+1,   0x1.c51085bcd7904p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5491b0b2p+35,                0x1.8p+0,   0x1.c148ab20ccdd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fac78p+17,                0x1.8p+1,   0x1.f07f3ea18ced8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c3476b792p+35,                0x1.8p+0,   0x1.a7acc2d8ef082p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8786696f2p+35,                0x1.8p+0,   0x1.566076c26c2a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eb8679f42p+35,                0x1.8p+0,   0x1.e198d95703e78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f3368e92p+35,                0x1.8p+0,   0x1.4b842110fc95ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0d4771c2p+35,                0x1.8p+0,   0x1.78199c5da2368p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d06636912p+35,                0x1.8p+0,   0x1.ba48fc8b6e5d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1c48p+17,                0x1.8p+1,   0x1.5b13712804aacp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3898p+17,                0x1.8p+1,   0x1.af452f931fbe6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9cc78ffc2p+35,                0x1.8p+0,   0x1.72a1a67e294a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b89cbaa42p+35,                0x1.8p+0,   0x1.98be168d2a768p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f86646682p+35,                0x1.8p+0,    0x1.f4a4455857e9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a7dec492p+35,                0x1.8p+0,   0x1.1d0a0a76b8e1ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9989bffd2p+35,                0x1.8p+0,   0x1.6e46396fbdc06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c0e6f9e2p+35,                0x1.8p+0,   0x1.0b69c52bf1c9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.97c58p+17,                0x1.8p+1,   0x1.02a61e41e4fdap+53,          0x1p-1, INEXACT)
T(RN,       0x1.564ecdda2p+35,                0x1.8p+0,   0x1.17e450e0b774cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eb613f272p+35,                0x1.8p+0,   0x1.e16222f0f97cap+53,          0x1p-1, INEXACT)
T(RN,            0x1.3968p+13,                  0x1p+2,   0x1.1f874409eef08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a38ec692p+35,                0x1.8p+0,   0x1.4513a147097a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ae75b3ed2p+35,                0x1.8p+0,   0x1.8ab2720e9a71ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f1ee17672p+35,                0x1.8p+0,   0x1.eb0a6d55bb7b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2378p+17,                0x1.8p+1,   0x1.5c1defe407528p+53,          0x1p-1, INEXACT)
T(RN,       0x1.89f7c1702p+35,                0x1.8p+0,    0x1.59960220fab6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7e08p+17,                0x1.8p+1,    0x1.44adba96f3fap+53,         -0x1p-1, INEXACT)
T(RN,             0x1.864p+10,                0x1.4p+2,   0x1.076dffc06b07cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.496349c72p+35,                0x1.8p+0,   0x1.08323264c62f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0078p+17,                0x1.8p+1,   0x1.d1911df1bd698p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef0b8p+17,                0x1.8p+1,   0x1.ceccf3bc6b4c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52efda7e2p+35,                0x1.8p+0,   0x1.13c4861fabd5cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9038p+17,                0x1.8p+1,   0x1.4733c48073bacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9a98p+17,                0x1.8p+1,   0x1.48a5cb16f5d46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae738p+17,                0x1.8p+1,   0x1.304035edf74fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.edf18p+17,                0x1.8p+1,   0x1.cbb7d06cc6a5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.998c8p+17,                0x1.8p+1,   0x1.060bb7138e304p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdc88p+17,                0x1.8p+1,   0x1.77a46cca03ad8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9e28p+17,                0x1.8p+1,   0x1.c07a900cafcdep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b7f260f2p+35,                0x1.8p+0,   0x1.0abcc10283166p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59b6f47c2p+35,                0x1.8p+0,   0x1.1c14a8bb6bfa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9bc7d6b2p+35,                0x1.8p+0,   0x1.9a4ec389c516ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5e080432p+35,                0x1.8p+0,   0x1.94f13b4573842p+53,          0x1p-1, INEXACT)
T(RN,       0x1.acb30a402p+35,                0x1.8p+0,    0x1.88473f4defd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5725298c2p+35,                0x1.8p+0,   0x1.18eb629e20bf8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f32e8p+17,                0x1.8p+1,   0x1.da7fe89f48402p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6fae4cd12p+35,                0x1.8p+0,   0x1.3794d7fb30aaep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4ee8p+17,                0x1.8p+1,   0x1.df81f04d5c342p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d296df6a2p+35,                0x1.8p+0,   0x1.bd6adf5864facp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d13b8p+17,                0x1.8p+1,   0x1.801f6aa853e54p+53,          0x1p-1, INEXACT)
T(RN,       0x1.af0a4b3c2p+35,                0x1.8p+0,   0x1.8b7ee22d63fd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5d58p+17,                0x1.8p+1,   0x1.64933f86a928ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c278f8202p+35,                0x1.8p+0,    0x1.a68a285b600cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adb58p+17,                0x1.8p+1,   0x1.2eae04b6efd2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff228p+17,                0x1.8p+1,   0x1.fd689f4feb69ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddf98p+17,                0x1.8p+1,   0x1.a08e9f37aa5b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5559ad692p+35,                0x1.8p+0,   0x1.16b7e15cfc5a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ccd68p+17,                0x1.8p+1,   0x1.75570f99a623ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9abbd8122p+35,                0x1.8p+0,   0x1.6fe12943a1e1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.619df4c02p+35,                0x1.8p+0,    0x1.25e05d8e27c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a84751d22p+35,                0x1.8p+0,   0x1.8239e65345c9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4378p+17,                0x1.8p+1,   0x1.3ca41c8930b28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ab60bc3c2p+35,                0x1.8p+0,   0x1.867742a22f9d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e74c8p+17,                0x1.8p+1,   0x1.b96a00f2d3844p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f61a8p+17,                0x1.8p+1,   0x1.e2e176cc5f4c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac818p+17,                0x1.8p+1,   0x1.2c24fd2e9b18ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4028p+17,                0x1.8p+1,   0x1.b08943c6dcc3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5ab929c72p+35,                0x1.8p+0,   0x1.1d532745f5d0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.996266de2p+35,                0x1.8p+0,   0x1.6e11713741d1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.64f7f8462p+35,                0x1.8p+0,   0x1.2a107c3e7fb2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8c219a12p+35,                0x1.8p+0,   0x1.dd8936b8fa2b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97998p+17,                0x1.8p+1,   0x1.02526d1224d96p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bba1ded42p+35,                0x1.8p+0,   0x1.9cf3c24ee5048p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b89adfad2p+35,                0x1.8p+0,   0x1.98bb81a376b9ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3a067d82p+35,                0x1.8p+0,    0x1.bee74f560a5fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b6afbfab2p+35,                0x1.8p+0,   0x1.9610da97bfb12p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc44bf312p+35,                0x1.8p+0,   0x1.fa69bbf17156ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dfafce922p+35,                0x1.8p+0,   0x1.d04d98f3efd1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d48f722e2p+35,                0x1.8p+0,   0x1.c03e26d8687c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea7252fa2p+35,                0x1.8p+0,   0x1.e00335d5b53f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3508p+17,                0x1.8p+1,    0x1.193dda1c1fffp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8b38p+17,                0x1.8p+1,   0x1.92ebd388a07bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.81e541c02p+35,                0x1.8p+0,    0x1.4f04e7dbbb58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fab28p+17,                0x1.8p+1,   0x1.f041886a7dfcep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c05993512p+35,                0x1.8p+0,   0x1.a38e82a86c052p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f40b8p+17,                0x1.8p+1,   0x1.dcf7379bbb3c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d344ad702p+35,                0x1.8p+0,    0x1.be63d71f4236p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7d68p+17,                0x1.8p+1,   0x1.227126d315b3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc9f8p+17,                0x1.8p+1,    0x1.f5ef916fb9dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9378p+17,                0x1.8p+1,   0x1.47a78ff3efa28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d77d8p+17,                0x1.8p+1,   0x1.8fd5243d2a242p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad0b8p+17,                0x1.8p+1,   0x1.2d47567fd8ec4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ed847d1e2p+35,                0x1.8p+0,   0x1.e4872c8fb0c64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5a18p+17,                0x1.8p+1,   0x1.8b1ef0a5d0feep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c87ca11b2p+35,                0x1.8p+0,   0x1.af07a7da1e00ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.caf255a02p+35,                0x1.8p+0,    0x1.b284bd14e4e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1cc8p+17,                0x1.8p+1,   0x1.5b25f6ad98fc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9de37c9d2p+35,                0x1.8p+0,   0x1.74204ea3f84bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef388p+17,                0x1.8p+1,   0x1.cf4b342c72f28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c78c8p+17,                0x1.8p+1,   0x1.68a1ec6fdcd04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f701344a2p+35,                0x1.8p+0,   0x1.f29105d1c3914p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bc56869c2p+35,                0x1.8p+0,   0x1.9df01a23fb068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47a2b86b2p+35,                0x1.8p+0,   0x1.06173ba0d7b6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57fa249d2p+35,                0x1.8p+0,   0x1.19f1150634b46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed098p+17,                0x1.8p+1,   0x1.c9313a4e7ac66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97c68p+17,                0x1.8p+1,   0x1.02a8056746d8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e66c8p+17,                0x1.8p+1,   0x1.b70a5f60087a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ef3b2422p+35,                0x1.8p+0,   0x1.602a2d651f43cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.697be2972p+35,                0x1.8p+0,   0x1.2fbcd0fed92aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe8d43352p+35,                0x1.8p+0,   0x1.fdd449870680ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6968p+17,                0x1.8p+1,   0x1.e44791444c17ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.608898652p+35,                0x1.8p+0,   0x1.2486e03a7b756p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e64c8p+17,                0x1.8p+1,   0x1.b6b3bf0fce544p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.92cf31532p+35,                0x1.8p+0,   0x1.6548dd32c839ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6978p+17,                0x1.8p+1,   0x1.1fe3471046e48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.def48p+17,                0x1.8p+1,   0x1.a3203648f553cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8b58p+17,                0x1.8p+1,   0x1.243c89b74262ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.6058p+13,                  0x1p+2,   0x1.cb5233af9a498p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.beba77202p+35,                0x1.8p+0,    0x1.a1485c347facp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1c312102p+35,                0x1.8p+0,    0x1.a58a544d387ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d9afb25c2p+35,                0x1.8p+0,   0x1.c79e50fe40ee8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afee8p+17,                0x1.8p+1,   0x1.3366a16393c42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2488p+17,                0x1.8p+1,   0x1.d7f13497bd858p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d73c8p+17,                0x1.8p+1,   0x1.8f2fddeeef914p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.75c379022p+35,                0x1.8p+0,   0x1.3f586282990bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d50619372p+35,                0x1.8p+0,   0x1.c0e87481c6016p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6788p+17,                0x1.8p+1,   0x1.1fa3f0abf7ce8p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.ab4p+10,                0x1.4p+2,   0x1.9e57ee451aabep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2a28p+17,                0x1.8p+1,   0x1.d8f11cde2cd1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c05216df2p+35,                0x1.8p+0,   0x1.a38400a56d7c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9df85c22p+35,                0x1.8p+0,   0x1.8467cfbb4f13cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd1a8p+17,                0x1.8p+1,   0x1.f75c0f8a261c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d89a8p+17,                0x1.8p+1,   0x1.92abe93626046p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef290ac32p+35,                0x1.8p+0,   0x1.e6f30748b02bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4bd94afb2p+35,                0x1.8p+0,   0x1.0b299584b904ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2b38p+17,                0x1.8p+1,   0x1.ad09921b145bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb5d53fe2p+35,                0x1.8p+0,   0x1.e15c60d31cc5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9e3b2082p+35,                0x1.8p+0,    0x1.f6dc8ee6970dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4cf8p+17,                0x1.8p+1,    0x1.b2afc5387f87p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4ac8p+17,                0x1.8p+1,   0x1.1bfc5a8fb7664p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97ecf6832p+35,                0x1.8p+0,   0x1.6c1cfff03e33ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3d78p+17,                0x1.8p+1,   0x1.b016060f91e08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ccab8p+17,                0x1.8p+1,   0x1.74ee9782d83a4p+53,          0x1p-1, INEXACT)
T(RN,            0x1.68d8p+13,                  0x1p+2,   0x1.f9461dc8edbf8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5d28p+17,                0x1.8p+1,   0x1.40266b6bb122ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e06d982d2p+35,                0x1.8p+0,   0x1.d16141632429ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99158p+17,                0x1.8p+1,   0x1.05278d280ce4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.502a33b12p+35,                0x1.8p+0,   0x1.106436232f992p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3598p+17,                0x1.8p+1,   0x1.3ac1a2c33c2d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.75c6e3ed2p+35,                0x1.8p+0,   0x1.3f5cc3d22471ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8f48749a2p+35,                0x1.8p+0,   0x1.609a6dda603ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3678p+17,                0x1.8p+1,   0x1.196c24348f4b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1b88p+17,                0x1.8p+1,   0x1.aa6da4ab296a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab01bcfe2p+35,                0x1.8p+0,   0x1.85f519a1fc65cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce4246412p+35,                0x1.8p+0,   0x1.b73b1e8facf72p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca82a44a2p+35,                0x1.8p+0,   0x1.b1e6279d166ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8dc8p+17,                0x1.8p+1,   0x1.9354b46195ff4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.72792ed52p+35,                0x1.8p+0,   0x1.3b23479fa02cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd368p+17,                0x1.8p+1,   0x1.f7af217dc305ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bbd247892p+35,                0x1.8p+0,   0x1.9d375ba7c889ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.89319b792p+35,                0x1.8p+0,   0x1.58916a3239082p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cb469ef2p+35,                0x1.8p+0,   0x1.0c325df6021a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9acb8p+17,                0x1.8p+1,   0x1.0871e835e0c04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aadd8p+17,                0x1.8p+1,   0x1.28b5cdcdf1762p+53,          0x1p-1, INEXACT)
T(RN,       0x1.645cba652p+35,                0x1.8p+0,   0x1.294e216c5a4aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2318p+17,                0x1.8p+1,   0x1.5c10051345d1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.faa68p+17,                0x1.8p+1,   0x1.f01e47292d72ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a81c8p+17,                0x1.8p+1,   0x1.230126890e1b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9639d4692p+35,                0x1.8p+0,   0x1.69d70250e47a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3a58p+17,                0x1.8p+1,   0x1.af901f7cb0e7ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3528p+17,                0x1.8p+1,   0x1.1941e059f46aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe888p+17,                0x1.8p+1,   0x1.fb9cb96267518p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5203a672p+35,                0x1.8p+0,   0x1.93e6a10eb8e4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.57eeab132p+35,                0x1.8p+0,   0x1.19e2f97ff281ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.743e42c82p+35,                0x1.8p+0,    0x1.3d661370c43bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b178p+17,                0x1.8p+1,   0x1.0904c929a3bc8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8b083972p+35,                0x1.8p+0,   0x1.dd6f70f3554aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6235459a2p+35,                0x1.8p+0,   0x1.269d129d06634p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b0e7ede22p+35,                0x1.8p+0,   0x1.8e10f78d60004p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c92e8p+17,                0x1.8p+1,   0x1.6c86352839602p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a935f3d42p+35,                0x1.8p+0,   0x1.837feca2f7248p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed168p+17,                0x1.8p+1,   0x1.c95565671d0fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ada2e9862p+35,                0x1.8p+0,   0x1.8990aac674facp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5d48p+17,                0x1.8p+1,   0x1.8b9fb85eb9bdcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daea8p+17,                0x1.8p+1,   0x1.989c87881adb6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9d99c60b2p+35,                0x1.8p+0,   0x1.73bce958583d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7768p+17,                0x1.8p+1,   0x1.21abf82b30d1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac7a50912p+35,                0x1.8p+0,   0x1.87f965ef7ee2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1858p+17,                0x1.8p+1,   0x1.36cece09b331ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.65b81e2d2p+35,                0x1.8p+0,   0x1.2b01460f2969ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.54373d362p+35,                0x1.8p+0,   0x1.1554745564174p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a10531be2p+35,                0x1.8p+0,   0x1.785b91d533ddcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d16977a2p+35,                0x1.8p+0,   0x1.730c1c2115f0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9d4a4302p+35,                0x1.8p+0,    0x1.9a706a50cbaep+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc718p+17,                0x1.8p+1,   0x1.9c910324471dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.abf78p+17,                0x1.8p+1,   0x1.2b035ea497a68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dac98p+17,                0x1.8p+1,   0x1.98475fcee97a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9a6d4ee2p+35,                0x1.8p+0,   0x1.ded8962db1bbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b62f8p+17,                0x1.8p+1,    0x1.40f29a5a22c9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc1254742p+35,                0x1.8p+0,   0x1.b41dfd21ef288p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c0cd34b2p+35,                0x1.8p+0,   0x1.0b67d3177f9aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5508p+17,                0x1.8p+1,    0x1.3f0991c3db5fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0238p+17,                0x1.8p+1,   0x1.12e6548019b0cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b49784e22p+35,                0x1.8p+0,   0x1.932935b986604p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3318p+17,                0x1.8p+1,   0x1.3a6ae8453881ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.da6e8p+17,                0x1.8p+1,   0x1.975ccab8ad7c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e13729712p+35,                0x1.8p+0,   0x1.d2864193fd212p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca008p+17,                0x1.8p+1,     0x1.6e7d6d45d5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fada8p+17,                0x1.8p+1,   0x1.f0b718a973106p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5198p+17,                0x1.8p+1,   0x1.89c80f5fa5a16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a62400ac2p+35,                0x1.8p+0,   0x1.7f4f7f634ad38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.685962e42p+35,                0x1.8p+0,   0x1.2e4ef730c2218p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5c48p+17,                0x1.8p+1,   0x1.646b2efd816acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb87f8e92p+35,                0x1.8p+0,   0x1.b35950e2a16a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76c2412d2p+35,                0x1.8p+0,   0x1.409f21dc4ff66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db1a8p+17,                0x1.8p+1,   0x1.9918795a32bc6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab6bb2fb2p+35,                0x1.8p+0,   0x1.8686493a23fb2p+53,          0x1p-1, INEXACT)
T(RN,            0x1.60d8p+13,                  0x1p+2,   0x1.cdef135a215f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc458p+17,                0x1.8p+1,   0x1.9c1ec0333715ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cba38p+17,                0x1.8p+1,   0x1.726ede41dd58cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.afd7eb042p+35,                0x1.8p+0,   0x1.8c9a046483128p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac478p+17,                0x1.8p+1,   0x1.2bab2d15ad358p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9658p+17,                0x1.8p+1,   0x1.94b3aad2605bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2e18p+17,                0x1.8p+1,   0x1.84386846c05aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.939432592p+35,                0x1.8p+0,   0x1.664f19025633ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f5ba52dd2p+35,                0x1.8p+0,   0x1.f0ab5633bfc3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9ff8p+17,                0x1.8p+1,     0x1.26e7d02acfep+53,          0x1p-1, INEXACT)
T(RN,            0x1.4fd8p+13,                  0x1p+2,   0x1.7b23bf4a2fd38p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.2bbe08p+21,                0x1.4p+1,    0x1.0c880df06fb5p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d1f4a4482p+35,                0x1.8p+0,    0x1.bc82a59b8535p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d11b3c032p+35,                0x1.8p+0,   0x1.bb4bafd0ef7c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.49fa25a42p+35,                0x1.8p+0,   0x1.08e7c79e5fa98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9367cf5c2p+35,                0x1.8p+0,   0x1.6613fe0d3dce8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb2a8p+17,                0x1.8p+1,   0x1.714a9e7e14876p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d1d3d8a2p+35,                0x1.8p+0,   0x1.0cb128a220594p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8cc8p+17,                0x1.8p+1,   0x1.6b9bfd35dd4c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b2924b92p+35,                0x1.8p+0,   0x1.70740aef605fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.88bfb76b2p+35,                0x1.8p+0,   0x1.57fbbf7e36292p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca9d8p+17,                0x1.8p+1,   0x1.6ff6d2985a4a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c016358f2p+35,                0x1.8p+0,   0x1.a32ff6de53266p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ffb36212p+35,                0x1.8p+0,   0x1.102b1af57de4ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.629e1a5f2p+35,                0x1.8p+0,   0x1.271fe6a0030c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.52ddf4642p+35,                0x1.8p+0,   0x1.13aeae3dc1b18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4e58p+17,                0x1.8p+1,   0x1.894529f7f643ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4c48p+17,                0x1.8p+1,   0x1.6211464e023acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0a78p+17,                0x1.8p+1,   0x1.a79a40b007478p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe1973ce2p+35,                0x1.8p+0,   0x1.fd26db334cb84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5d07b352p+35,                0x1.8p+0,   0x1.7eddc2f0c87f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4448p+17,                0x1.8p+1,   0x1.3cc06c90d7a2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c695e9b82p+35,                0x1.8p+0,    0x1.ac570376f0d5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a0a3bf532p+35,                0x1.8p+0,   0x1.77d7ae9b5d862p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee958p+17,                0x1.8p+1,   0x1.cd82514ffeacap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7758p+17,                0x1.8p+1,   0x1.8fc0ca5b5206ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c75bdf652p+35,                0x1.8p+0,   0x1.ad6eed9559556p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbc38p+17,                0x1.8p+1,   0x1.f3655870a2fecp+53,          0x1p-1, INEXACT)
T(RN,             0x1.a54p+10,                0x1.4p+2,   0x1.820e33e9a6502p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79c259cd2p+35,                0x1.8p+0,   0x1.447acf3c386a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c62d8p+17,                0x1.8p+1,   0x1.6562d42e741d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.800a13eb2p+35,                0x1.8p+0,   0x1.4c9ada63b2b92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44107cc72p+35,                0x1.8p+0,   0x1.01d138f12030ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a488280a2p+35,                0x1.8p+0,   0x1.7d1f167b8716cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4048p+17,                0x1.8p+1,   0x1.871017a1c3d6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a860cf532p+35,                0x1.8p+0,   0x1.825cb538a079ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df208p+17,                0x1.8p+1,    0x1.a393c3bac356p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6222f9682p+35,                0x1.8p+0,    0x1.26863ec4ff37p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9ee8p+17,                0x1.8p+1,   0x1.6e52391a67a42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7e58p+17,                0x1.8p+1,   0x1.e8127b14d853ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.3bf8p+13,                  0x1p+2,     0x1.290c49e8871p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f418eb062p+35,                0x1.8p+0,   0x1.ee400b70a8eacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7d84a342p+35,                0x1.8p+0,   0x1.81a254ad92808p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4db8p+17,                0x1.8p+1,   0x1.892c012dfb734p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44e43ebf2p+35,                0x1.8p+0,   0x1.02ce1648b5006p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a87cb842p+35,                0x1.8p+0,   0x1.1d16391073e28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7028p+17,                0x1.8p+1,   0x1.42c31d4fe9d3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.590f674b2p+35,                0x1.8p+0,   0x1.1b463c77051aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5720401a2p+35,                0x1.8p+0,   0x1.18e55a81f30ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ccf28p+17,                0x1.8p+1,   0x1.759b20d70288ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2f78p+17,                0x1.8p+1,   0x1.188aeb374ff68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1808p+17,                0x1.8p+1,    0x1.159c3e2d2648p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b229fecf2p+35,                0x1.8p+0,   0x1.8fcd8273c0fe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.98362b322p+35,                0x1.8p+0,   0x1.6c7f082869124p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a80225992p+35,                0x1.8p+0,   0x1.81db762595242p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5da0fcac2p+35,                0x1.8p+0,   0x1.20eb3bb44bac8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6c9ab0a2p+35,                0x1.8p+0,   0x1.9634d8129ec94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4f28p+17,                0x1.8p+1,   0x1.8965e0994808ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9388p+17,                0x1.8p+1,   0x1.ebee224ff8d28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3788p+17,                0x1.8p+1,   0x1.85b18fc2223e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f0581d962p+35,                0x1.8p+0,   0x1.e8b25e076d1b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3238p+17,                0x1.8p+1,   0x1.ae347caf1940cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd878p+17,                0x1.8p+1,   0x1.f89fa44f1ef18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb7e8p+17,                0x1.8p+1,   0x1.4cc11cdc24672p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c7ab1a862p+35,                0x1.8p+0,   0x1.addf06f0f59acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2d08p+17,                0x1.8p+1,    0x1.5d8151141fe7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2ce8p+17,                0x1.8p+1,   0x1.840904adc19e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4c28p+17,                0x1.8p+1,   0x1.620c95299847ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dccd8p+17,                0x1.8p+1,   0x1.9d80306e822b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.afc38p+17,                0x1.8p+1,   0x1.330adbb7a8becp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2b56df62p+35,                0x1.8p+0,   0x1.d4b29551c9e0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0018p+17,                0x1.8p+1,   0x1.d18039234500ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cac8p+17,                0x1.8p+1,   0x1.0c1714164de64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4fc8p+17,                0x1.8p+1,   0x1.6294b71ea1e54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55d2904c2p+35,                0x1.8p+0,   0x1.174bfd7397488p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6c98p+17,                0x1.8p+1,   0x1.204982e569ba6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3528p+17,                0x1.8p+1,   0x1.85528f13156aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba8e82062p+35,                0x1.8p+0,   0x1.9b73835b154acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bab58p+17,                0x1.8p+1,   0x1.4afd7b3cf2c2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.dfa620b82p+35,                0x1.8p+0,    0x1.d03f8b71ae8bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd64092d2p+35,                0x1.8p+0,   0x1.b5fe845100f66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7c58p+17,                0x1.8p+1,   0x1.bab32463fbfdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d69e8p+17,                0x1.8p+1,   0x1.8d9edd4ed9ad2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b10adfb12p+35,                0x1.8p+0,   0x1.8e412b514e192p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9324ea72p+35,                0x1.8p+0,   0x1.837af106936cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.db1f8p+17,                0x1.8p+1,    0x1.992563fb8f96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4288p+17,                0x1.8p+1,   0x1.876a5c7f309f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a89eba2a2p+35,                0x1.8p+0,   0x1.82b146acbf42cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f55169f12p+35,                0x1.8p+0,   0x1.f00f9721776eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e643eea42p+35,                0x1.8p+0,   0x1.d9e322743ef68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e7a8def92p+35,                0x1.8p+0,   0x1.dbed499dcb182p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e71d8p+17,                0x1.8p+1,   0x1.b8ea541ddbe22p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c70a8p+17,                0x1.8p+1,   0x1.676d86c4d7f16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.feb28p+17,                0x1.8p+1,   0x1.fc1a0b23e0bcep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f6b8p+17,                0x1.8p+1,   0x1.117a4f6faffe4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3af8p+17,                0x1.8p+1,    0x1.afaae4fccd51p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f068p+17,                0x1.8p+1,   0x1.10b307a03e94ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.adefdf8b2p+35,                0x1.8p+0,   0x1.89fa6f560e6d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b8a6a012p+35,                0x1.8p+0,   0x1.0aca59f4b740ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7db8p+17,                0x1.8p+1,   0x1.44a2a85d2b034p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a99d8p+17,                0x1.8p+1,   0x1.261c77fdb79a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bfa98p+17,                0x1.8p+1,   0x1.56397859fbf46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1a58p+17,                0x1.8p+1,   0x1.15e6136b8787ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4cfcfaac2p+35,                0x1.8p+0,   0x1.0c8a2118d9138p+53,          0x1p-1, INEXACT)
T(RN,       0x1.efbe90c92p+35,                0x1.8p+0,   0x1.e7cfa8d97c0e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45ce9b6b2p+35,                0x1.8p+0,   0x1.03e651c91aa92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.502bd2902p+35,                0x1.8p+0,    0x1.10662e63b44ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.57fbc8472p+35,                0x1.8p+0,   0x1.19f318fea65f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd309eeb2p+35,                0x1.8p+0,   0x1.9f2102340a192p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d45bcb092p+35,                0x1.8p+0,   0x1.bff40a3cda79ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5e38p+17,                0x1.8p+1,   0x1.e242d950fd84cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8de786362p+35,                0x1.8p+0,   0x1.5ec753ccac774p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9a732882p+35,                0x1.8p+0,    0x1.b0aecd680f23p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5a88p+17,                0x1.8p+1,   0x1.e198d95703e78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.543f64112p+35,                0x1.8p+0,   0x1.155e6c1240d2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4a68p+17,                0x1.8p+1,   0x1.deb34af05f52ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8921d57f2p+35,                0x1.8p+0,   0x1.587cae7efed7ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eff68p+17,                0x1.8p+1,   0x1.d16141632429ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.937990432p+35,                0x1.8p+0,   0x1.662ba1a78a7bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cecd9d32p+35,                0x1.8p+0,   0x1.0c769ebf1fd62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5868p+17,                0x1.8p+1,   0x1.3f7fcfbf9f8cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96ff8p+17,                0x1.8p+1,     0x1.012e0f19ec5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6478p+17,                0x1.8p+1,   0x1.8cc2820339158p+53,          0x1p-1, INEXACT)
T(RN,           0x1.addc8p+17,                0x1.8p+1,   0x1.2f0075e0f2ef4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c13200c2p+35,                0x1.8p+0,   0x1.1efe9de3b74f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a018p+17,                0x1.8p+1,   0x1.06ec8cbb33e0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd1a00b32p+35,                0x1.8p+0,   0x1.b5951d6a7d0dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ec2948b2p+35,                0x1.8p+0,   0x1.754d56f490f2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b578f2ef2p+35,                0x1.8p+0,   0x1.94619e98e305ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb8a8p+17,                0x1.8p+1,   0x1.4cdc205eb9096p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce908p+17,                0x1.8p+1,    0x1.798d53cac11bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.991caa9e2p+35,                0x1.8p+0,   0x1.6db3ec329f564p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49a041e82p+35,                0x1.8p+0,    0x1.087b9049b867p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.44d917de2p+35,                0x1.8p+0,   0x1.02c0c326ae71cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dff18p+17,                0x1.8p+1,   0x1.a5b9c5a7a705ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2414ce32p+35,                0x1.8p+0,   0x1.7a07cfaf6727ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4028p+17,                0x1.8p+1,   0x1.870b143691c3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1008p+17,                0x1.8p+1,     0x1.594e7790b43p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a011a90e2p+35,                0x1.8p+0,   0x1.7712138fdbf04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff868p+17,                0x1.8p+1,   0x1.fe93d678886cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea0d8p+17,                0x1.8p+1,   0x1.c0f0b32a23472p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5d68p+17,                0x1.8p+1,   0x1.1e598a807e53ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.941415652p+35,                0x1.8p+0,   0x1.66f97680c2156p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e488p+17,                0x1.8p+1,   0x1.0f3d2bd235c58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8fb334f2p+35,                0x1.8p+0,   0x1.f5820f02886e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d56c8p+17,                0x1.8p+1,   0x1.8a9939b2984a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efd98p+17,                0x1.8p+1,   0x1.d10fa389ad456p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7778p+17,                0x1.8p+1,   0x1.b9dee5ac97ce8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f1c0bb5e2p+35,                0x1.8p+0,   0x1.eac755ce0da1cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4af8p+17,                0x1.8p+1,    0x1.decd1c5c2c81p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9058p+17,                0x1.8p+1,   0x1.be1cab717659ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99378p+17,                0x1.8p+1,   0x1.0568b02b29a28p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4888p+13,                  0x1p+2,    0x1.5b2e85539552p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd838p+17,                0x1.8p+1,   0x1.76fc230ef812cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f76d8p+17,                0x1.8p+1,   0x1.e6b61c465bf92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98a48p+17,                0x1.8p+1,   0x1.044f5f026f94cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7acc6582p+35,                0x1.8p+0,    0x1.dbf3009e4311p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef2713412p+35,                0x1.8p+0,   0x1.e6f0208c99a8ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bca88p+17,                0x1.8p+1,   0x1.4f61a4fc5b378p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edf08p+17,                0x1.8p+1,    0x1.cbb505a530fdp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bbbb8p+17,                0x1.8p+1,   0x1.4d4a7de05d5d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a551720e2p+35,                0x1.8p+0,   0x1.7e30da7c47afcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e65d8p+17,                0x1.8p+1,   0x1.b6e1c2cf145e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.59594dc02p+35,                0x1.8p+0,    0x1.1ba141c4b6d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6878p+17,                0x1.8p+1,   0x1.1fc2952f48a18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bb0b1fb52p+35,                0x1.8p+0,   0x1.9c2158c28170ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eab48p+17,                0x1.8p+1,   0x1.c2bc47ba68c7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0998p+17,                0x1.8p+1,   0x1.d32cb0ecb1096p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3058p+17,                0x1.8p+1,   0x1.5dfca45d1839ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.df0b8p+17,                0x1.8p+1,   0x1.a35c9aaa384c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2bb89cd2p+35,                0x1.8p+0,   0x1.90969c92ae6a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0448p+17,                0x1.8p+1,   0x1.a694b747b3e2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e00e8p+17,                0x1.8p+1,   0x1.a6063ca7acfa2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a6bd3652p+35,                0x1.8p+0,   0x1.1cf3b5ee4c2aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa378p+17,                0x1.8p+1,   0x1.eed87ab161d28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d53ae152p+35,                0x1.8p+0,   0x1.735e6db6f084ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e82bae692p+35,                0x1.8p+0,   0x1.dcacd515f8c5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.be888p+17,                0x1.8p+1,   0x1.53a4581cdb518p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3628p+17,                0x1.8p+1,   0x1.857a8d7aca55ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57aec04a2p+35,                0x1.8p+0,   0x1.199468c38b114p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e0d8p+17,                0x1.8p+1,   0x1.0ec959b58f072p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5a68p+17,                0x1.8p+1,   0x1.e19316c97702ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba8e8p+17,                0x1.8p+1,   0x1.4aa609698bb22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2cf8p+17,                0x1.8p+1,    0x1.183a9897ab27p+53,          0x1p-1, INEXACT)
T(RN,       0x1.88b1b41f2p+35,                0x1.8p+0,   0x1.57e956d5b12bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e99f8p+17,                0x1.8p+1,    0x1.bfc2a65f3e4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9baa8p+17,                0x1.8p+1,   0x1.0a217b9350df6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0ec8p+17,                0x1.8p+1,   0x1.35862f17b6f24p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c225e042p+35,                0x1.8p+0,   0x1.33158699ca0d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f33d9b922p+35,                0x1.8p+0,   0x1.ecfb108fffb1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4da8p+17,                0x1.8p+1,   0x1.89297d28e4f06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd237e2c2p+35,                0x1.8p+0,   0x1.b5a29fd118c38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ccabf1f42p+35,                0x1.8p+0,   0x1.b4f87c4820e78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cabf36da2p+35,                0x1.8p+0,   0x1.b23c25c991d4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.71b23d192p+35,                0x1.8p+0,   0x1.3a2591c06f4bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b929c7662p+35,                0x1.8p+0,   0x1.99826bbf4866cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5260b6ea2p+35,                0x1.8p+0,   0x1.1315e75b7bb54p+53,          0x1p-1, INEXACT)
T(RN,       0x1.94c2476a2p+35,                0x1.8p+0,   0x1.67e1b00a9c054p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fe93dc02p+35,                0x1.8p+0,    0x1.616f7ed8bcd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc418p+17,                0x1.8p+1,   0x1.f4d97a042bacep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f528p+17,                0x1.8p+1,   0x1.1148f2bb31aaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.644f61512p+35,                0x1.8p+0,   0x1.293d6d63b4452p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.867cbfd32p+35,                0x1.8p+0,   0x1.55043960bf69ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6c3c2362p+35,                0x1.8p+0,   0x1.f235adae6ef74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be4e23152p+35,                0x1.8p+0,   0x1.a0b09d3eaae4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7704ff982p+35,                0x1.8p+0,    0x1.40f4cce05989p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4808p+17,                0x1.8p+1,    0x1.b1db68a3f2d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a50c83bb2p+35,                0x1.8p+0,   0x1.7dd3130685932p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97208p+17,                0x1.8p+1,    0x1.016ca2e9f5d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6e5ba2c52p+35,                0x1.8p+0,   0x1.35e6be3810e16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dbfefef22p+35,                0x1.8p+0,   0x1.caf47926096a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9c38p+17,                0x1.8p+1,   0x1.c02571bc1d9ecp+53,          0x1p-1, INEXACT)
T(RN,            0x1.4328p+13,                  0x1p+2,   0x1.45034118afaf8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdb08p+17,                0x1.8p+1,    0x1.51b864b1e0f1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6c38p+17,                0x1.8p+1,   0x1.66c5626eec0ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a403e12a2p+35,                0x1.8p+0,   0x1.7c6b52894d1d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4d58p+17,                0x1.8p+1,   0x1.3dfcaa675378ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b22f85432p+35,                0x1.8p+0,   0x1.8fd5243d2a242p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e63e3d52p+35,                0x1.8p+0,   0x1.4a76f9e34d736p+53,          0x1p-1, INEXACT)
T(RN,       0x1.56f5afb72p+35,                0x1.8p+0,   0x1.18b117d637316p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.972d8p+17,                0x1.8p+1,   0x1.01854c8903cd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac878p+17,                0x1.8p+1,   0x1.2c31990185c18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cebd8p+17,                0x1.8p+1,   0x1.79fb8ee78b202p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5cf8p+17,                0x1.8p+1,    0x1.8b93170100b7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.834d00892p+35,                0x1.8p+0,   0x1.50d9ce8583562p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aacc8p+17,                0x1.8p+1,   0x1.28925c1bc1ac4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db6d8p+17,                0x1.8p+1,   0x1.99ef069fc8b92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b7a170a2p+35,                0x1.8p+0,   0x1.5b92d46d32494p+53,          0x1p-1, INEXACT)
T(RN,           0x1.deb98p+17,                0x1.8p+1,   0x1.a2856590a41f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b8e163162p+35,                0x1.8p+0,   0x1.991da3f8caab4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8bb8p+17,                0x1.8p+1,   0x1.ea815a078bcd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f93e8p+17,                0x1.8p+1,   0x1.ebffa94d129b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.edd1145e2p+35,                0x1.8p+0,   0x1.e4f7fc167341cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e0d25b872p+35,                0x1.8p+0,   0x1.d1f3b220fff76p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6898p+13,                  0x1p+2,   0x1.f7e005e1f5c88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eca68p+17,                0x1.8p+1,   0x1.c81e0946a1d2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6d98p+17,                0x1.8p+1,   0x1.e50958a533156p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7f78p+17,                0x1.8p+1,   0x1.69a0464884e68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3dc8p+17,                0x1.8p+1,   0x1.b0236b70d30f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9cae6c472p+35,                0x1.8p+0,   0x1.727fcb2751df6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4633261e2p+35,                0x1.8p+0,   0x1.045ea91b99264p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1ce8p+17,                0x1.8p+1,   0x1.818bfb3433ee2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64d83e382p+35,                0x1.8p+0,    0x1.29e8c0677a85p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea7832512p+35,                0x1.8p+0,   0x1.e00bd4e561252p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed8f8p+17,                0x1.8p+1,    0x1.caa665be062bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f32f8p+17,                0x1.8p+1,    0x1.da82c2a77a39p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db898p+17,                0x1.8p+1,   0x1.9a37788a023e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4008p+17,                0x1.8p+1,     0x1.dcd7be365dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a90864412p+35,                0x1.8p+0,   0x1.8341a6920b372p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9be08p+17,                0x1.8p+1,    0x1.0a8a43d38ebap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eddae68c2p+35,                0x1.8p+0,   0x1.e50673db60208p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63f54e942p+35,                0x1.8p+0,   0x1.28ccbe862d638p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5128p+17,                0x1.8p+1,   0x1.3e81f355129eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97e38p+17,                0x1.8p+1,   0x1.02df38b2cde4cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9598p+17,                0x1.8p+1,   0x1.ec4e8de6f64d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4558p+17,                0x1.8p+1,   0x1.87db461b6c20ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.53f468ae2p+35,                0x1.8p+0,   0x1.1502c1175893cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eaf18p+17,                0x1.8p+1,   0x1.c36474b28d95ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b24f8p+17,                0x1.8p+1,    0x1.38820f6c840fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4768p+17,                0x1.8p+1,   0x1.b1c08bfbd1c1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea89d08c2p+35,                0x1.8p+0,   0x1.e025b2b2f41f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb338p+17,                0x1.8p+1,   0x1.f1bcef69ab73cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.de9744862p+35,                0x1.8p+0,   0x1.ceb6844863dacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a59a8p+17,                0x1.8p+1,   0x1.1ddf6c1878f46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b1bf5eb2p+35,                0x1.8p+0,   0x1.463881162d06ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b40d0c402p+35,                0x1.8p+0,    0x1.926977917098p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c712533b2p+35,                0x1.8p+0,   0x1.ad06e77e2d7cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b33c94782p+35,                0x1.8p+0,    0x1.914905f43c23p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53a7d48a2p+35,                0x1.8p+0,   0x1.14a52cd41d46cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef408p+17,                0x1.8p+1,    0x1.cf61a86e92dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97128p+17,                0x1.8p+1,   0x1.01521563fdfeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e90680912p+35,                0x1.8p+0,   0x1.dded798ab4e2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8877c102p+35,                0x1.8p+0,    0x1.dd3351c15f46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e71e8p+17,                0x1.8p+1,   0x1.b8ed0b4839852p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7dded8de2p+35,                0x1.8p+0,   0x1.49ca91d61aee4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.759f97502p+35,                0x1.8p+0,    0x1.3f2a672a5c82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.876a6e472p+35,                0x1.8p+0,   0x1.563bc378519f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bacf98e52p+35,                0x1.8p+0,   0x1.9bce4c4142faap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc0a8p+17,                0x1.8p+1,   0x1.4dfca0cd6a616p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffb902762p+35,                0x1.8p+0,   0x1.ff958762344f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ee592be2p+35,                0x1.8p+0,   0x1.60177a4d81824p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f7a8p+17,                0x1.8p+1,   0x1.1197f04fca7e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cc88p+17,                0x1.8p+1,   0x1.0c4da9afb47d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4c68p+17,                0x1.8p+1,   0x1.df0f1b51f9c8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bff846672p+35,                0x1.8p+0,   0x1.a305f630859b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98898p+17,                0x1.8p+1,   0x1.041bc958cb2e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c09ed5662p+35,                0x1.8p+0,   0x1.a3efbd95ad26cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.af958p+17,                0x1.8p+1,   0x1.32a8c32e6d5cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.88b8b5bd2p+35,                0x1.8p+0,   0x1.57f28b14eeb86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4599f76e2p+35,                0x1.8p+0,   0x1.03a7576cf9b44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9b38p+17,                0x1.8p+1,   0x1.bff98755f8abcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e98a8p+17,                0x1.8p+1,   0x1.bf890bc8d4a96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4828p+17,                0x1.8p+1,   0x1.884c456c8c1bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1f48p+17,                0x1.8p+1,   0x1.1683e3ef72e3cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1e98p+17,                0x1.8p+1,   0x1.81cf0a379b406p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebf78p+17,                0x1.8p+1,   0x1.c638a47223a68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53e9005e2p+35,                0x1.8p+0,   0x1.14f4cfccf13e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6035a2cc2p+35,                0x1.8p+0,   0x1.241fa45d0cc78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bffc8p+17,                0x1.8p+1,   0x1.56f7f61013f54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51703f4c2p+35,                0x1.8p+0,   0x1.11f0dfc6e9178p+53,          0x1p-1, INEXACT)
T(RN,       0x1.deb4462b2p+35,                0x1.8p+0,   0x1.cee095da3a7eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b90da0f2p+35,                0x1.8p+0,   0x1.0ad21f468369ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cef18p+17,                0x1.8p+1,   0x1.7a7b0a5e4e55ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.972a77a72p+35,                0x1.8p+0,   0x1.6b18b637488cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a664ff12p+35,                0x1.8p+0,   0x1.5a27847d35d12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6cb8p+17,                0x1.8p+1,   0x1.b80bce7a93004p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de4bddf62p+35,                0x1.8p+0,   0x1.ce492f54d01f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e06d982d2p+35,                0x1.8p+0,   0x1.d16141632429ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfd18p+17,                0x1.8p+1,   0x1.a565706047cfep+53,          0x1p-1, INEXACT)
T(RN,           0x1.adb08p+17,                0x1.8p+1,    0x1.2ea374019df1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6548p+17,                0x1.8p+1,   0x1.65beece4e455cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2098p+17,                0x1.8p+1,   0x1.ab44e48bf2366p+53,          0x1p-1, INEXACT)
T(RN,       0x1.78883a2b2p+35,                0x1.8p+0,   0x1.42e668cc13feep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba8712002p+35,                0x1.8p+0,     0x1.9b69241a594p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aeee8p+17,                0x1.8p+1,   0x1.314551618e142p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d71e8p+17,                0x1.8p+1,   0x1.8ee3a5789e852p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9575f5d02p+35,                0x1.8p+0,    0x1.68d16e2cc2eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f2d8e8112p+35,                0x1.8p+0,   0x1.ec65efb31552ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.90200b112p+35,                0x1.8p+0,   0x1.61b827b08b4d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ec7f780c2p+35,                0x1.8p+0,   0x1.e306f989664f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7e8aaf02p+35,                0x1.8p+0,    0x1.81b8af0408dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5154a5bd2p+35,                0x1.8p+0,   0x1.11cf44788347ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6f72fd612p+35,                0x1.8p+0,   0x1.374976d169f32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a2d594522p+35,                0x1.8p+0,   0x1.7ad0e8ad7439cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f22f2fc22p+35,                0x1.8p+0,   0x1.eb6abb2a4b2c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e38d8p+17,                0x1.8p+1,   0x1.af4fe39a32cf2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ecd618c2p+35,                0x1.8p+0,   0x1.755bebfc64408p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6508p+17,                0x1.8p+1,    0x1.b6be927a408fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef4494482p+35,                0x1.8p+0,    0x1.e71ba6c7b4cbp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57a348022p+35,                0x1.8p+0,   0x1.19865054dfabcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3028p+17,                0x1.8p+1,   0x1.3a0514b4d713ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b00401582p+35,                0x1.8p+0,    0x1.8cd6c1db1acfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4beb01632p+35,                0x1.8p+0,   0x1.0b3ef9982e682p+53,          0x1p-1, INEXACT)
T(RN,               0x1.7ep+7,                0x1.cp+2,    0x1.079005ddc1aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee1a8p+17,                0x1.8p+1,   0x1.cc2a541fe9cc6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c8842eed2p+35,                0x1.8p+0,   0x1.af125adc8e11ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef158p+17,                0x1.8p+1,   0x1.cee900128404ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cccc32b52p+35,                0x1.8p+0,   0x1.b5266103f1ef6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce6a8p+17,                0x1.8p+1,   0x1.79304f0405436p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45a058a82p+35,                0x1.8p+0,    0x1.03aef91be9efp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eef7e03d2p+35,                0x1.8p+0,   0x1.e6aa825f81886p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ff69e432p+35,                0x1.8p+0,   0x1.76ed8332bb442p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b54b5892p+35,                0x1.8p+0,   0x1.3211838dc3b62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a37d8p+17,                0x1.8p+1,   0x1.19986fd4b6642p+53,          0x1p-1, INEXACT)
T(RN,       0x1.85f2d05e2p+35,                0x1.8p+0,   0x1.544f988f90c1cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5aa8p+17,                0x1.8p+1,   0x1.b4fde251a7bf6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2af8p+17,                0x1.8p+1,    0x1.acfee7b87121p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce7597052p+35,                0x1.8p+0,   0x1.b784441ae4296p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6181b3c82p+35,                0x1.8p+0,    0x1.25bd25ba8565p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1708p+17,                0x1.8p+1,    0x1.a9ae8c2cbca5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6f94e10b2p+35,                0x1.8p+0,   0x1.377488476e62ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1a58p+17,                0x1.8p+1,   0x1.15e6136b8787ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cfb522e12p+35,                0x1.8p+0,   0x1.b94c1d19583cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c4ba6d52p+35,                0x1.8p+0,   0x1.0bb3bb3356d36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.71399d172p+35,                0x1.8p+0,   0x1.398bde31fb856p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2578p+17,                0x1.8p+1,   0x1.1749fcb8f8988p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab3f8p+17,                0x1.8p+1,    0x1.2982580fda1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b5f2ff5c2p+35,                0x1.8p+0,   0x1.950ae3f7b0318p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9197361b2p+35,                0x1.8p+0,   0x1.63aa186fd960ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a546dd12p+35,                0x1.8p+0,   0x1.453717e742352p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9f28p+17,                0x1.8p+1,   0x1.6e5bd2a00878ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6fe9a10a2p+35,                0x1.8p+0,   0x1.37e0454f3f76cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed7f8p+17,                0x1.8p+1,    0x1.ca79cc580488p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4198p+17,                0x1.8p+1,   0x1.8744be1d9df16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac868p+17,                0x1.8p+1,   0x1.2c2f7f02c25cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f4a9406e2p+35,                0x1.8p+0,   0x1.ef1612f6b6144p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9d68p+17,                0x1.8p+1,   0x1.c0599bcf9913ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e86a8p+17,                0x1.8p+1,   0x1.bc74ff147b236p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8c607c412p+35,                0x1.8p+0,   0x1.5cc2bc0bf0372p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f1de50332p+35,                0x1.8p+0,   0x1.eaf3168b4e1dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf648p+17,                0x1.8p+1,   0x1.559b51ea3c18cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8768p+17,                0x1.8p+1,   0x1.bc95c26a6081ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc3d8p+17,                0x1.8p+1,   0x1.f4cda6dff0682p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2048p+17,                0x1.8p+1,   0x1.ab3798fa1876cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5cc3a8eb2p+35,                0x1.8p+0,   0x1.1fd90f35e0a6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9cb20762p+35,                0x1.8p+0,   0x1.b0e1c2852a70cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd538p+17,                0x1.8p+1,   0x1.76872ed277f9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4bd8p+17,                0x1.8p+1,   0x1.88e08d4047402p+53,          0x1p-1, INEXACT)
T(RN,       0x1.68a33a222p+35,                0x1.8p+0,   0x1.2eabe7c0d657cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6daa14d82p+35,                0x1.8p+0,    0x1.35058f780a81p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.acb135c02p+35,                0x1.8p+0,    0x1.8844bc42bfd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9967c45d2p+35,                0x1.8p+0,   0x1.6e18a37e2313ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f39484e02p+35,                0x1.8p+0,    0x1.ed7bd1a604d4p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4b88p+13,                  0x1p+2,    0x1.6809a7790e5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2338p+17,                0x1.8p+1,   0x1.d7b58bb09cc3cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e21e01072p+35,                0x1.8p+0,   0x1.d3d61b01d4b8ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3f88p+17,                0x1.8p+1,   0x1.86f203c31f568p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1d98p+17,                0x1.8p+1,   0x1.d6b61556dca56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.61e71a9e2p+35,                0x1.8p+0,   0x1.263b91b4f9564p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.775fbd1f2p+35,                0x1.8p+0,   0x1.416951045e4bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.85b3fd282p+35,                0x1.8p+0,    0x1.53fd5df7fa61p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c51ccbb2p+35,                0x1.8p+0,   0x1.1f4c251ff8b32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5a98p+17,                0x1.8p+1,   0x1.b4fb2f4b78146p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e25a8p+17,                0x1.8p+1,   0x1.ac1c6ccfdb386p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cebd8p+17,                0x1.8p+1,   0x1.79fb8ee78b202p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc788p+17,                0x1.8p+1,   0x1.9ca332a59dee8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b64f8p+17,                0x1.8p+1,    0x1.4138f01a94cfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.472c5ec42p+35,                0x1.8p+0,   0x1.058945bc16d58p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9affecef2p+35,                0x1.8p+0,   0x1.703ca4aaf5ba6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae5d8p+17,                0x1.8p+1,   0x1.301191e8cdde2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e979d9d62p+35,                0x1.8p+0,   0x1.de969c39f0f34p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1b98p+17,                0x1.8p+1,   0x1.d65b56d6ae2f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.43f707ef2p+35,                0x1.8p+0,   0x1.01b2d896e9a5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf418p+17,                0x1.8p+1,   0x1.554b2bf494bcep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad038p+17,                0x1.8p+1,   0x1.2d367c73057acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.aac74c8e2p+35,                0x1.8p+0,   0x1.85a50ec9273fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.da948p+17,                0x1.8p+1,   0x1.97beb4e554e1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f3e1942c2p+35,                0x1.8p+0,   0x1.edee03e444838p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e26c8p+17,                0x1.8p+1,   0x1.ac4c5c0a13ba4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff798p+17,                0x1.8p+1,   0x1.fe6ce9f617e36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f07b90392p+35,                0x1.8p+0,   0x1.e8e6b93114b02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5918p+17,                0x1.8p+1,   0x1.1dcd1dbb3a83ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b850ac492p+35,                0x1.8p+0,   0x1.985446092f1e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2e88p+17,                0x1.8p+1,   0x1.5db925eb01e38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ee6278332p+35,                0x1.8p+0,   0x1.e5ce3942a6e22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.655a86612p+35,                0x1.8p+0,   0x1.2a8bf5007fd32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8815e04e2p+35,                0x1.8p+0,   0x1.571cb6cd15e84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c50c8p+17,                0x1.8p+1,   0x1.62ba4b09bfd84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be46ab032p+35,                0x1.8p+0,   0x1.a0a6278040a3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb408p+17,                0x1.8p+1,    0x1.f1e3361dd51cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed7ca2742p+35,                0x1.8p+0,   0x1.e47b9b8c52178p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61f7bb8d2p+35,                0x1.8p+0,   0x1.26504ebc3f1dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d08a68092p+35,                0x1.8p+0,   0x1.ba7cb1f03f19ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8a58p+17,                0x1.8p+1,   0x1.4662b7850957ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0448p+17,                0x1.8p+1,   0x1.579d6e0fcde2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fba68p+17,                0x1.8p+1,   0x1.f30fcc5cc522ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b38e8p+17,                0x1.8p+1,   0x1.3b34a59f7be22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bae06462p+35,                0x1.8p+0,   0x1.3282663a2472cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4abfc0462p+35,                0x1.8p+0,   0x1.09d5df97ecb2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b9fd84d72p+35,                0x1.8p+0,   0x1.9aa9615c6b72ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6de8a1072p+35,                0x1.8p+0,   0x1.3554dc9f28b8ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6bd8p+17,                0x1.8p+1,   0x1.422b053e9aa02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa8b8p+17,                0x1.8p+1,   0x1.280af09828f44p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f78ff9262p+35,                0x1.8p+0,   0x1.f3655870a2fecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b33e8p+17,                0x1.8p+1,   0x1.3a871654fc7b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dea98p+17,                0x1.8p+1,   0x1.a25b7048a6446p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7048p+17,                0x1.8p+1,   0x1.42c7869b6b66cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f07a8p+17,                0x1.8p+1,   0x1.d2d53914f82e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b13b8p+17,                0x1.8p+1,   0x1.362fc0346de54p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca5c8p+17,                0x1.8p+1,   0x1.6f5a741544c74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad6a1ffa2p+35,                0x1.8p+0,   0x1.8942a5d766a0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91aab2432p+35,                0x1.8p+0,   0x1.63c3fb4f95c42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c4c304dc2p+35,                0x1.8p+0,   0x1.a9c3c4f6b0de8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea2fc7952p+35,                0x1.8p+0,   0x1.dfa187b0232b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.431d38662p+35,                0x1.8p+0,   0x1.00af213afef94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eeb6fdc42p+35,                0x1.8p+0,   0x1.e64ad3b79c758p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.431874352p+35,                0x1.8p+0,   0x1.00a973423a9f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.76b2db002p+35,                0x1.8p+0,     0x1.408b5f05d22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9f28p+17,                0x1.8p+1,   0x1.26ccd15ef278ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f1db8p+17,                0x1.8p+1,   0x1.d6bbc1a20be34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6e38p+17,                0x1.8p+1,   0x1.207eb5cf1fb4cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc128p+17,                0x1.8p+1,   0x1.9b9a6a1b4d6eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.678ccce92p+35,                0x1.8p+0,   0x1.2d4da86e22ea2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec018p+17,                0x1.8p+1,   0x1.c65457c53e40ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eda78p+17,                0x1.8p+1,   0x1.cae9514333b78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae428p+17,                0x1.8p+1,   0x1.2fd85ac39ecfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de2157f52p+35,                0x1.8p+0,   0x1.ce0b8a4adba8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5718p+17,                0x1.8p+1,   0x1.1d8c0d6ea64dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1368p+17,                0x1.8p+1,   0x1.1508baee2fc5ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5918p+13,                  0x1p+2,   0x1.a6aac9991c4e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc9227ac2p+35,                0x1.8p+0,   0x1.9e436ff441cc8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f326e6f2p+35,                0x1.8p+0,   0x1.0f3747645875ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfcb8p+17,                0x1.8p+1,   0x1.7c92b44239b04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2788p+17,                0x1.8p+1,   0x1.d879a4f8fe0e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcf88p+17,                0x1.8p+1,   0x1.5016ca66b5068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.52fcdf3a2p+35,                0x1.8p+0,   0x1.13d469ac05e74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a31c236a2p+35,                0x1.8p+0,   0x1.7b30a68b95854p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b0f8p+17,                0x1.8p+1,    0x1.08f5509becb3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c495de12p+35,                0x1.8p+0,   0x1.47bdd7bf2a9cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5e98p+17,                0x1.8p+1,   0x1.e254255100006p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc3d8p+17,                0x1.8p+1,   0x1.9c09fc1d5a682p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ceb452ef2p+35,                0x1.8p+0,   0x1.b7ddb5e830fa6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9138p+17,                0x1.8p+1,   0x1.be42fd1967edcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.42e8cc3a2p+35,                0x1.8p+0,   0x1.0070ac261e074p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c59e8p+17,                0x1.8p+1,   0x1.6411ab7804fd2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47079a492p+35,                0x1.8p+0,   0x1.055d30bb94a1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf288p+17,                0x1.8p+1,   0x1.7b01ffd389af8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bb88p+17,                0x1.8p+1,   0x1.0a3ca35f404a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3e28p+17,                0x1.8p+1,   0x1.60001b5e4dadep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86d09acb2p+35,                0x1.8p+0,   0x1.5572184147aaep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b06e8p+17,                0x1.8p+1,   0x1.34783c42be9c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2128p+17,                0x1.8p+1,   0x1.d757d592dc8eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c8a44a5c2p+35,                0x1.8p+0,   0x1.af3fd5a096118p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d708p+17,                0x1.8p+1,    0x1.0d95c6e65fe5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d261ea12p+35,                0x1.8p+0,   0x1.48db6189db74ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ff18p+17,                0x1.8p+1,   0x1.128349803b05ep+53,          0x1p-1, INEXACT)
T(RN,          0x1.38e408p+21,                0x1.4p+1,    0x1.2af4a97f75fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.605879662p+35,                0x1.8p+0,   0x1.244afd1b44594p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3ee8p+13,                  0x1p+2,   0x1.343fd847502e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8ce8p+17,                0x1.8p+1,   0x1.46bddb121dbe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5a78p+17,                0x1.8p+1,   0x1.6426dd795c378p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9f9e4dee2p+35,                0x1.8p+0,   0x1.767622920ca44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfd58p+17,                0x1.8p+1,   0x1.7cab52b71408ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb628p+17,                0x1.8p+1,   0x1.71d1ccd564d5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.88b374852p+35,                0x1.8p+0,   0x1.57eba3e18fa6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d54c8p+17,                0x1.8p+1,   0x1.8a488c9136244p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e624bfac2p+35,                0x1.8p+0,   0x1.d9b58d8c15338p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b27ce34c2p+35,                0x1.8p+0,   0x1.90400773e3978p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea3b8p+17,                0x1.8p+1,   0x1.c16f2b397f954p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc08d9cb2p+35,                0x1.8p+0,   0x1.b41082bc01caep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc93871c2p+35,                0x1.8p+0,   0x1.cbcb5c32e8368p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b09b8p+17,                0x1.8p+1,   0x1.34d8933978e74p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb488p+17,                0x1.8p+1,   0x1.719305810c358p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6538p+17,                0x1.8p+1,   0x1.65bc902a5ba9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0518p+17,                0x1.8p+1,   0x1.134188214ea7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.edd78p+17,                0x1.8p+1,   0x1.cb6f3bd41fc08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cdb1e3fb2p+35,                0x1.8p+0,   0x1.b66d65331be4ep+53,         -0x1p-1, INEXACT)
T(RN,               0x1.d3p+8,                0x1.8p+2,   0x1.26d0f8768c63cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1bd8p+17,                0x1.8p+1,   0x1.37474fa633302p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c6235dc2p+35,                0x1.8p+0,   0x1.0bcefe54e2c18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf0f9a672p+35,                0x1.8p+0,   0x1.b85fe5755b1b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6c98p+17,                0x1.8p+1,   0x1.e4db0d6990ba6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6b28p+17,                0x1.8p+1,   0x1.201a78d9643cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b848p+17,                0x1.8p+1,   0x1.09d7cfb8c1becp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f0045e52p+35,                0x1.8p+0,   0x1.0efa6949865aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6537709d2p+35,                0x1.8p+0,   0x1.2a5ffe8592346p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c13f0d32p+35,                0x1.8p+0,   0x1.4778c945d349ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8048p+17,                0x1.8p+1,   0x1.bb5ec3b4f396cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a60d8p+17,                0x1.8p+1,   0x1.1ec99a3dd4872p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7a14d4152p+35,                0x1.8p+0,   0x1.44e5197e763b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a39e76462p+35,                0x1.8p+0,   0x1.7be191e74a72cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3338p+17,                0x1.8p+1,   0x1.850519f4dbf3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbcf8p+17,                0x1.8p+1,    0x1.9aecbaa9d9d7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5d08p+17,                0x1.8p+1,    0x1.e20c160b5d77p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cf8b1fc2p+35,                0x1.8p+0,   0x1.3424cde795f58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be518p+17,                0x1.8p+1,   0x1.5326e6fd9947ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7d78p+17,                0x1.8p+1,   0x1.bae428d0caa08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f7661a12p+35,                0x1.8p+0,   0x1.60d74563a92b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6d18p+17,                0x1.8p+1,   0x1.2059e0a2539fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7408p+17,                0x1.8p+1,    0x1.434bf026085cp+53,         -0x1p-1, INEXACT)
T(RN,          0x1.40c1c8p+21,                0x1.4p+1,   0x1.3e19e66a66662p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3e6e5f22p+35,                0x1.8p+0,   0x1.7c43f387f9ca4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b22b8p+17,                0x1.8p+1,   0x1.38345fc0c7c24p+53,          0x1p-1, INEXACT)
T(RN,       0x1.542f16742p+35,                0x1.8p+0,   0x1.154a7cd5aa688p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6068p+17,                0x1.8p+1,   0x1.b5f6681ba864ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee6f8p+17,                0x1.8p+1,    0x1.cd17f9248e55p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4ab8p+17,                0x1.8p+1,   0x1.dec1a2b997ba4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.948245942p+35,                0x1.8p+0,   0x1.678c55cfd3fc8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f82c8p+17,                0x1.8p+1,   0x1.e8e0e7c44c8e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.912257182p+35,                0x1.8p+0,    0x1.630ee18f9859p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1c88p+17,                0x1.8p+1,   0x1.375eff0d566d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdb98p+17,                0x1.8p+1,   0x1.f934412d6a6f6p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5ee8p+13,                  0x1p+2,   0x1.c3defd6a92ae8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7f1b30162p+35,                0x1.8p+0,   0x1.4b64b2d7b774cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3fb8p+17,                0x1.8p+1,   0x1.603a8aa4d0a94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf9525572p+35,                0x1.8p+0,   0x1.a27ae7fb5382ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac658p+17,                0x1.8p+1,   0x1.2bea2aac0b6bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f97e8p+17,                0x1.8p+1,   0x1.ecbab86bcd072p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6cb8p+17,                0x1.8p+1,   0x1.204d9a45c7004p+53,          0x1p-1, INEXACT)
T(RN,       0x1.751540e92p+35,                0x1.8p+0,   0x1.3e7934c1106a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce9033cc2p+35,                0x1.8p+0,   0x1.b7aa34d7b4678p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fedf8p+17,                0x1.8p+1,    0x1.fca06754c64ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f41e8p+17,                0x1.8p+1,   0x1.dd2d9830c7752p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.485467012p+35,                0x1.8p+0,   0x1.06ec8cbb33e0ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.902aa6da2p+35,                0x1.8p+0,   0x1.61c63900abd4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afd18p+17,                0x1.8p+1,   0x1.3328bad036cfep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0198p+17,                0x1.8p+1,   0x1.d1c3ced0f5316p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0c26b992p+35,                0x1.8p+0,   0x1.78013071fe642p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f26c8p+17,                0x1.8p+1,   0x1.d8578669e6ba4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7aa8b0582p+35,                0x1.8p+0,    0x1.45a3c33d1d2fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae1a07aa2p+35,                0x1.8p+0,   0x1.8a346300dcd2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b74a8p+17,                0x1.8p+1,   0x1.43620541cf9d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4298p+17,                0x1.8p+1,   0x1.3c85a0da2d8c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cab98p+17,                0x1.8p+1,   0x1.703a3c2c6a5f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1de8p+17,                0x1.8p+1,   0x1.aad296dc18a92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.846007be2p+35,                0x1.8p+0,   0x1.5240dc1652624p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.981e8p+17,                0x1.8p+1,   0x1.034f9ed00c352p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a1e5b172p+35,                0x1.8p+0,   0x1.59c8cd8dcc3aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.492cc1642p+35,                0x1.8p+0,   0x1.07f0990bbc918p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf8a8p+17,                0x1.8p+1,   0x1.7bf2c829aec96p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e45b8p+17,                0x1.8p+1,   0x1.b1780a8c82db4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b6a857fd2p+35,                0x1.8p+0,   0x1.9606928f78c06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb1de3dd2p+35,                0x1.8p+0,   0x1.b2c299acbea3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7a28p+17,                0x1.8p+1,   0x1.22064d206541ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f0ce4b4c2p+35,                0x1.8p+0,   0x1.e960f1c773688p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4fd8p+17,                0x1.8p+1,   0x1.dfad04e64c6c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6767ee9c2p+35,                0x1.8p+0,   0x1.2d1f51a812068p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dab88p+17,                0x1.8p+1,   0x1.981b8644321a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2ac8p+17,                0x1.8p+1,   0x1.acf6e80c29064p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1e2f0782p+35,                0x1.8p+0,    0x1.a5b722d1d65dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4108f632p+35,                0x1.8p+0,   0x1.7c7c8cf49bd7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2fd8p+17,                0x1.8p+1,   0x1.847e4573ad0c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c608p+17,                0x1.8p+1,    0x1.0b8311119ad2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.42aadd822p+35,                0x1.8p+0,   0x1.0026e907163bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c9db2ca2p+35,                0x1.8p+0,   0x1.1faa116678a14p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d4cb7df2p+35,                0x1.8p+0,   0x1.2082cdb052a3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff668p+17,                0x1.8p+1,   0x1.fe340a0193f6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da978p+17,                0x1.8p+1,   0x1.97c67078e8a48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7638p+17,                0x1.8p+1,   0x1.b9a884a1a44ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0958p+17,                0x1.8p+1,   0x1.13c87ef41d0cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a52d29d02p+35,                0x1.8p+0,    0x1.7dff7d112992p+53,          0x1p-1, INEXACT)
T(RN,       0x1.57e18e1f2p+35,                0x1.8p+0,   0x1.19d2da9e9b946p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.908bec1a2p+35,                0x1.8p+0,   0x1.62473e6b88734p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ec3a8p+17,                0x1.8p+1,   0x1.c6f251d39dc26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7788p+17,                0x1.8p+1,   0x1.68726edea7fe8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3068p+17,                0x1.8p+1,   0x1.8494bc09ae54ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7493f432p+35,                0x1.8p+0,   0x1.db61545c2d642p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cfbad8aa2p+35,                0x1.8p+0,   0x1.b95443d54e32cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5938p+17,                0x1.8p+1,   0x1.1dd12f13fdc5cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5908p+17,                0x1.8p+1,    0x1.8af4099ed66bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c2698f32p+35,                0x1.8p+0,   0x1.0b86f5809085ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edbb8p+17,                0x1.8p+1,   0x1.cb211a8034bd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac7a50912p+35,                0x1.8p+0,   0x1.87f965ef7ee2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a87132b22p+35,                0x1.8p+0,   0x1.827316c22dc24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1bf8p+17,                0x1.8p+1,    0x1.1619fd342854p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c495de12p+35,                0x1.8p+0,   0x1.47bdd7bf2a9cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5f2157b2p+35,                0x1.8p+0,   0x1.d96b81cee14b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.57dca3542p+35,                0x1.8p+0,   0x1.19cccf32ac548p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3538p+17,                0x1.8p+1,   0x1.dae9736aad19cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba3e910c2p+35,                0x1.8p+0,   0x1.9b040c8595108p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c9e8p+17,                0x1.8p+1,   0x1.0bfbcc1087cd2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f57c8p+17,                0x1.8p+1,   0x1.e11a2bc8977d4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a97f8p+17,                0x1.8p+1,    0x1.25de4b2277c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3b48p+17,                0x1.8p+1,   0x1.dbfe6ec25577cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5e2a2a62p+35,                0x1.8p+0,   0x1.7ef67ab027eecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3c58p+17,                0x1.8p+1,   0x1.5fbc5ab50b3dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4a18a7fa2p+35,                0x1.8p+0,   0x1.090c85aa4e5f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b7f7aa112p+35,                0x1.8p+0,   0x1.97d87bdd406d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de13d0a02p+35,                0x1.8p+0,    0x1.cdf7ee33c6c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad8f8p+17,                0x1.8p+1,    0x1.2e5dbf18fa2bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.57ab79552p+35,                0x1.8p+0,   0x1.199061bc34a36p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52fcdf3a2p+35,                0x1.8p+0,   0x1.13d469ac05e74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf8f893b2p+35,                0x1.8p+0,   0x1.a27309e8cabcep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61c92d1f2p+35,                0x1.8p+0,   0x1.26163fe933b46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c657bb582p+35,                0x1.8p+0,    0x1.abff237d4d0fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b4601ecb2p+35,                0x1.8p+0,   0x1.92dc7bf5b0d52p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d575262a2p+35,                0x1.8p+0,   0x1.c187ec72abc2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a16b8p+17,                0x1.8p+1,   0x1.15725c43665e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ee91a992p+35,                0x1.8p+0,   0x1.601c270385842p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6678f752p+35,                0x1.8p+0,   0x1.95aca3ae1238ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3948p+17,                0x1.8p+1,   0x1.5f49f3f84391cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c05a8p+17,                0x1.8p+1,   0x1.57d0080087d86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb378p+17,                0x1.8p+1,   0x1.f1c8b63088028p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0098p+17,                0x1.8p+1,   0x1.a5f90cfeead66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.78c969bc2p+35,                0x1.8p+0,   0x1.433a4662b8728p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3228p+13,                  0x1p+2,   0x1.05d4fa2af0bb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f67f8p+17,                0x1.8p+1,    0x1.e40517c68638p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5bca950a2p+35,                0x1.8p+0,   0x1.1ea4ea4f89094p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c1709b6e2p+35,                0x1.8p+0,   0x1.a5166aa404cbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3ea8p+17,                0x1.8p+1,   0x1.b048ef2d6b0b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.805d3cf32p+35,                0x1.8p+0,   0x1.4d06e8eadbfa2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b21d8p+17,                0x1.8p+1,   0x1.38162d231b722p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a57b8p+17,                0x1.8p+1,   0x1.1da06176e9714p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3ed8p+17,                0x1.8p+1,   0x1.b050f96746912p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4c88p+17,                0x1.8p+1,   0x1.621aa8b6abfd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e47fd432p+35,                0x1.8p+0,   0x1.21ba55e249242p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4752beb02p+35,                0x1.8p+0,    0x1.05b74aac2242p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d763c1352p+35,                0x1.8p+0,   0x1.c44f1244ccc0ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7c38p+17,                0x1.8p+1,   0x1.e7afb5c3be3ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c94b8p+17,                0x1.8p+1,   0x1.6ccb97ac24f84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.86f1ce9f2p+35,                0x1.8p+0,   0x1.559d9c53a27bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8e15e092p+35,                0x1.8p+0,   0x1.ddb70a6294262p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4eadc94e2p+35,                0x1.8p+0,   0x1.0e965a0801b7cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7835eb332p+35,                0x1.8p+0,   0x1.427c8e0f08bdep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ed494f62p+35,                0x1.8p+0,   0x1.7565a4e247bf4p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.86cp+10,                0x1.4p+2,   0x1.091f201ac9836p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecec8p+17,                0x1.8p+1,   0x1.c8e092458e324p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a06e8p+17,                0x1.8p+1,   0x1.137b11a6639c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f97c8p+17,                0x1.8p+1,   0x1.ecb4df3b3c3d4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1b1df6e2p+35,                0x1.8p+0,   0x1.bc231dc898b44p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da6497dd2p+35,                0x1.8p+0,   0x1.c8a368931c23ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9298p+17,                0x1.8p+1,   0x1.ebc252a973fc6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f698p+17,                0x1.8p+1,   0x1.11765c47fd086p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f72fd612p+35,                0x1.8p+0,   0x1.374976d169f32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0d701112p+35,                0x1.8p+0,   0x1.a43e9e70f972ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b426e3a92p+35,                0x1.8p+0,   0x1.928d3db2c6522p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4c68p+17,                0x1.8p+1,   0x1.3ddbe9b60dc8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60d4f39c2p+35,                0x1.8p+0,   0x1.24e5ef55aa198p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9642bcbe2p+35,                0x1.8p+0,   0x1.69e2e92404bdcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2438p+17,                0x1.8p+1,   0x1.386828c4dfb6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc828p+17,                0x1.8p+1,   0x1.9cbd2e4bb19bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4802bdc92p+35,                0x1.8p+0,   0x1.068a7bb6356e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aad414cf2p+35,                0x1.8p+0,   0x1.85b69038e63e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.738eb15d2p+35,                0x1.8p+0,   0x1.3c85a0da2d8c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2a78ec42p+35,                0x1.8p+0,   0x1.ec1ce08a68d58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6148p+17,                0x1.8p+1,   0x1.1ed7df811989cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2b38p+17,                0x1.8p+1,   0x1.83c5b3acc15bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ebc531042p+35,                0x1.8p+0,   0x1.e1f5086efb2d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd598p+17,                0x1.8p+1,   0x1.7695cc05640d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bec78afc2p+35,                0x1.8p+0,   0x1.a15aaf1f0a958p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7c38p+17,                0x1.8p+1,   0x1.e7afb5c3be3ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.95d7df342p+35,                0x1.8p+0,   0x1.6954287704a08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a99f8p+17,                0x1.8p+1,    0x1.26209d6d324ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2728p+17,                0x1.8p+1,   0x1.d868957ce050ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4b3a9962p+35,                0x1.8p+0,   0x1.7d5a3cb03d9b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eced56d02p+35,                0x1.8p+0,    0x1.e3a8a56300b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1298p+17,                0x1.8p+1,   0x1.a8f253125b7c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe6154182p+35,                0x1.8p+0,    0x1.fd927c264b39p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.458073262p+35,                0x1.8p+0,   0x1.0388d22ffcc14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4a58p+17,                0x1.8p+1,   0x1.61c89141f997ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3c88p+17,                0x1.8p+1,   0x1.5fc35c9445cd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.896ef5b92p+35,                0x1.8p+0,   0x1.58e21329077fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac828p+17,                0x1.8p+1,   0x1.2c271720d09bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.623d96f02p+35,                0x1.8p+0,    0x1.26a7734bc15ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f981e442p+35,                0x1.8p+0,   0x1.235bc25ab3a58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fddc8p+17,                0x1.8p+1,   0x1.f99c59f051ef4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99288p+17,                0x1.8p+1,   0x1.054bf2360b8f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6668p+17,                0x1.8p+1,   0x1.8d10fd3e38c6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eda68p+17,                0x1.8p+1,   0x1.cae68751b982ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6048p+17,                0x1.8p+1,   0x1.b5f100065536cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4af8p+17,                0x1.8p+1,    0x1.3da9b58d2081p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bed78p+17,                0x1.8p+1,   0x1.5458bc5564f08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa59c4842p+35,                0x1.8p+0,   0x1.850f17f990828p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7458p+17,                0x1.8p+1,   0x1.b956fb6f00a5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9b08p+17,                0x1.8p+1,    0x1.bff14bb49931p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5db32af62p+35,                0x1.8p+0,   0x1.2101c52a9200cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6881a8d02p+35,                0x1.8p+0,    0x1.2e81a6978e0ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e567da32p+35,                0x1.8p+0,   0x1.0e2c82db15702p+53,          0x1p-1, INEXACT)
T(RN,       0x1.535324e82p+35,                0x1.8p+0,    0x1.143dbc986187p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c7e58542p+35,                0x1.8p+0,   0x1.1f834396dd8b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1b08p+17,                0x1.8p+1,    0x1.372b535baeb1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bba98p+17,                0x1.8p+1,   0x1.4d21f0344d346p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0be8p+17,                0x1.8p+1,   0x1.d39524f8a4432p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7b88p+17,                0x1.8p+1,   0x1.e78fc413298a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1c78p+17,                0x1.8p+1,   0x1.1629f7ab123d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44e10f0c2p+35,                0x1.8p+0,   0x1.02ca47a0c0508p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5358p+17,                0x1.8p+1,   0x1.b3c25be6acfaap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c6d5feeb2p+35,                0x1.8p+0,   0x1.acb199b689e6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.53e0da8c2p+35,                0x1.8p+0,   0x1.14eada97fc5f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7734ee6e2p+35,                0x1.8p+0,   0x1.413257a0d5544p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a93a8p+17,                0x1.8p+1,   0x1.254f6b9fbdb26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6728p+17,                0x1.8p+1,   0x1.6605cf96e210ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b834daa02p+35,                0x1.8p+0,    0x1.982d942b0304p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba5b8p+17,                0x1.8p+1,   0x1.4a33c6e2d4fb4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5f28p+17,                0x1.8p+1,   0x1.b5c05946fbb8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc328p+17,                0x1.8p+1,   0x1.73c9077b5a04ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.affa8p+17,                0x1.8p+1,   0x1.3380410648d66p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f27a2a492p+35,                0x1.8p+0,   0x1.ebd9b004b6a1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2698p+17,                0x1.8p+1,   0x1.830d5c6461186p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd86367a2p+35,                0x1.8p+0,   0x1.b62f2fab596f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.584249872p+35,                0x1.8p+0,   0x1.1a49ccd03dc8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e7fadd0c2p+35,                0x1.8p+0,   0x1.dc65564349908p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b10731f62p+35,                0x1.8p+0,   0x1.8e3c1836339f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4e49e042p+35,                0x1.8p+0,   0x1.7d9ccefbddf28p+53,          0x1p-1, INEXACT)
T(RN,       0x1.55c3db582p+35,                0x1.8p+0,    0x1.1739f73c410fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c10f8p+17,                0x1.8p+1,    0x1.59711437abd3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f5a1e392p+35,                0x1.8p+0,   0x1.60b1d39dacf02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4858p+17,                0x1.8p+1,   0x1.617d8e3ba241ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6dbe5d662p+35,                0x1.8p+0,   0x1.351f46240dd94p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9208p+17,                0x1.8p+1,    0x1.eba80a853836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fde18ff82p+35,                0x1.8p+0,    0x1.fcd32f9c082dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.932295f92p+35,                0x1.8p+0,   0x1.65b7d6bd46c7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.aeee8p+17,                0x1.8p+1,   0x1.314551618e142p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af278p+17,                0x1.8p+1,   0x1.31be8433faff8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0d78p+17,                0x1.8p+1,   0x1.144ba7bd3b508p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4fc8p+17,                0x1.8p+1,   0x1.dfaa25945ae54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b12bfbf82p+35,                0x1.8p+0,    0x1.8e6ed935e0adp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fbeb17422p+35,                0x1.8p+0,   0x1.f9e3c3a31823cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef118p+17,                0x1.8p+1,   0x1.ceddc7cd448bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a02483f2p+35,                0x1.8p+0,   0x1.59a3dc06262fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc8f8p+17,                0x1.8p+1,    0x1.74aa9b3c8bfbp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d1c28b62p+35,                0x1.8p+0,   0x1.3451b8b005e74p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be548p+17,                0x1.8p+1,   0x1.532dbdd18ad5cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6fe11192p+35,                0x1.8p+0,   0x1.c3bcbe94adcbep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bea18p+17,                0x1.8p+1,   0x1.53dd6734b22eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.77ec36c42p+35,                0x1.8p+0,   0x1.421dcdc2682a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3f58p+17,                0x1.8p+1,   0x1.602c83d3fd9eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b211fa72p+35,                0x1.8p+0,   0x1.463f2b1f9d8cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.519258e62p+35,                0x1.8p+0,   0x1.121a672fc1a94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aab6dda72p+35,                0x1.8p+0,   0x1.858e8db58ab36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1bc8p+17,                0x1.8p+1,   0x1.5b00ec4b1a094p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f724e39b2p+35,                0x1.8p+0,   0x1.f2c614d4034f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b439d872p+35,                0x1.8p+0,   0x1.0a74e965e848ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8d18p+17,                0x1.8p+1,   0x1.eac18091c5ffep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ff28p+17,                0x1.8p+1,   0x1.1285445e1b98ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f21b75812p+35,                0x1.8p+0,   0x1.eb4d8afa7430ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8ef8p+17,                0x1.8p+1,    0x1.bde078b3a34dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa7ad46a2p+35,                0x1.8p+0,   0x1.f7bdf7f1b0254p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9a612e82p+35,                0x1.8p+0,    0x1.f680b0a382c7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6808ddcc2p+35,                0x1.8p+0,   0x1.2de9a95fdf588p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61a6444f2p+35,                0x1.8p+0,   0x1.25eab9cdfdb1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8848p+17,                0x1.8p+1,   0x1.6af028feed2ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e61e8p+17,                0x1.8p+1,   0x1.b6374c941fd52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4db8p+17,                0x1.8p+1,   0x1.b2d00d306e734p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8558p+17,                0x1.8p+1,   0x1.23768b4315e0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb21ad8c2p+35,                0x1.8p+0,   0x1.b2c7fb0c18c08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d75fd7b2p+35,                0x1.8p+0,   0x1.0d1c90db11b4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6e12e7192p+35,                0x1.8p+0,   0x1.358a794b59742p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9eab2e2f2p+35,                0x1.8p+0,   0x1.752dc006676dap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc6c8p+17,                0x1.8p+1,   0x1.7455ab83d19a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5db8p+17,                0x1.8p+1,   0x1.1e63b94569a34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6a98p+17,                0x1.8p+1,   0x1.41fef85dd2c46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9672b3b2p+35,                0x1.8p+0,   0x1.83c33590a27cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c0ec5702p+35,                0x1.8p+0,    0x1.47721af7b936p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3e98p+17,                0x1.8p+1,   0x1.dc95f36788a06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1468p+17,                0x1.8p+1,   0x1.59f0111039e0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bbdd73c42p+35,                0x1.8p+0,   0x1.9d46f63e934a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0df8p+17,                0x1.8p+1,    0x1.d3f25b5573aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ccfd8p+17,                0x1.8p+1,   0x1.75b5e0bb90ec2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb698p+17,                0x1.8p+1,   0x1.f25bfa92f0486p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6273cdb2p+35,                0x1.8p+0,   0x1.f14d184bd6f72p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e15db272p+35,                0x1.8p+0,   0x1.0dde2e28ccfcap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f96e8p+17,                0x1.8p+1,   0x1.ec8bf032fdcc2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1b48p+17,                0x1.8p+1,   0x1.aa63055d3c17cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.980262e92p+35,                0x1.8p+0,   0x1.6c39af5a622a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4798p+17,                0x1.8p+1,   0x1.61616fd54a536p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b558p+17,                0x1.8p+1,   0x1.097cc3dfcaf0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ae3f5c82p+35,                0x1.8p+0,    0x1.1d87fcbdd4a5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f93f8p+17,                0x1.8p+1,    0x1.ec02952c48bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f4dc10c2p+35,                0x1.8p+0,   0x1.60a172ac58ef8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb058p+17,                0x1.8p+1,   0x1.c39ba186a3b9ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e8d8p+17,                0x1.8p+1,   0x1.0fc4c9401b5f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6877971f2p+35,                0x1.8p+0,   0x1.2e74fa35ee746p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eadc0c792p+35,                0x1.8p+0,   0x1.e09e74bb8217ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd99b8ae2p+35,                0x1.8p+0,   0x1.fc67a99b756c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe468p+17,                0x1.8p+1,   0x1.fad7f4d716d0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f1ab0a842p+35,                0x1.8p+0,   0x1.eaa74194edbd8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3818p+17,                0x1.8p+1,   0x1.5f1d9e90c1e8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.bec011e62p+35,                0x1.8p+0,   0x1.a150368833f6cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae1487e12p+35,                0x1.8p+0,   0x1.8a2cd39819dcep+53,          0x1p-1, INEXACT)
T(RN,       0x1.57478ca62p+35,                0x1.8p+0,   0x1.19159dce51d14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3788p+17,                0x1.8p+1,   0x1.85b18fc2223e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f85c8p+17,                0x1.8p+1,   0x1.e96c96b4db674p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4403c23b2p+35,                0x1.8p+0,   0x1.01c20877a6632p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bed49f092p+35,                0x1.8p+0,   0x1.a16d0292e7062p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9238p+17,                0x1.8p+1,   0x1.6c6be5f41a60cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed358p+17,                0x1.8p+1,   0x1.c9abac7bc27aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbda8p+17,                0x1.8p+1,   0x1.f3a9386ab1c06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4de8p+17,                0x1.8p+1,   0x1.624e48ed1fb92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cecd9d32p+35,                0x1.8p+0,   0x1.0c769ebf1fd62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1038p+17,                0x1.8p+1,   0x1.14a32f59973acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.75391bf62p+35,                0x1.8p+0,   0x1.3ea71f1342a0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6048p+17,                0x1.8p+1,   0x1.1eb741e28936cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.891ad2f12p+35,                0x1.8p+0,   0x1.587377c9058eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5f88p+17,                0x1.8p+1,   0x1.4079cef5adb68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c07e0fa2p+35,                0x1.8p+0,   0x1.476932b3c5ff4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfca8p+17,                0x1.8p+1,   0x1.7c903e1249756p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c75bdf652p+35,                0x1.8p+0,   0x1.ad6eed9559556p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6788p+17,                0x1.8p+1,   0x1.8d3e93dde0ce8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95e9add12p+35,                0x1.8p+0,   0x1.696bf0a2a5caep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc4b8p+17,                0x1.8p+1,   0x1.7405a21d9e884p+53,          0x1p-1, INEXACT)
T(RN,          0x1.266908p+21,                0x1.4p+1,   0x1.00bf8c99ca428p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a61579902p+35,                0x1.8p+0,    0x1.7f3bb60a6daap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae5d8p+17,                0x1.8p+1,   0x1.301191e8cdde2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb558p+17,                0x1.8p+1,   0x1.71b26847cbf0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd828p+17,                0x1.8p+1,   0x1.9f57cc18764bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0638p+17,                0x1.8p+1,   0x1.7e095c35e8fccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1fbf5112p+35,                0x1.8p+0,   0x1.8f8decac2bf2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a28f8p+17,                0x1.8p+1,    0x1.17ba344b3c1bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5498p+17,                0x1.8p+1,   0x1.e08772c8eb326p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5ea4a4d2p+35,                0x1.8p+0,   0x1.d9601e39c1fa6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c0ae1532p+35,                0x1.8p+0,   0x1.1ef46b733239ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee2f8p+17,                0x1.8p+1,    0x1.cc6502d84d49p+53,          0x1p-1, INEXACT)
T(RN,       0x1.87e8605b2p+35,                0x1.8p+0,   0x1.56e0feef3198ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6a68p+17,                0x1.8p+1,   0x1.2001f012e7b2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8668p+17,                0x1.8p+1,   0x1.45d6cda35226ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55c096bb2p+35,                0x1.8p+0,   0x1.1735f5f595f32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6108p+17,                0x1.8p+1,    0x1.e2c49d65ea83p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3ac8p+17,                0x1.8p+1,   0x1.afa2dcd236364p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb068p+17,                0x1.8p+1,   0x1.c39e63e2a6d4ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db478p+17,                0x1.8p+1,   0x1.998cc2d03c058p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b40b33c02p+35,                0x1.8p+0,    0x1.9266e97f4098p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbc18p+17,                0x1.8p+1,   0x1.4d58032a3ed4ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c2dc6af72p+35,                0x1.8p+0,   0x1.a7161c5d3a36ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.45985f222p+35,                0x1.8p+0,   0x1.03a56f0738c84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e143d922p+35,                0x1.8p+0,   0x1.0ddc39093a71cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9738bc732p+35,                0x1.8p+0,   0x1.6b2bcc8a80ea2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.50cf94aa2p+35,                0x1.8p+0,   0x1.112d50c588b2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c28f7b6e2p+35,                0x1.8p+0,   0x1.a6a9d5a76f344p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48292a452p+35,                0x1.8p+0,   0x1.06b89ecc7faeap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5698p+17,                0x1.8p+1,   0x1.b44e84dd8f286p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98138p+17,                0x1.8p+1,   0x1.033aa7ae8bbdcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.45f01d432p+35,                0x1.8p+0,   0x1.040e6ac4f2dbep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d36c8p+17,                0x1.8p+1,   0x1.85938ddf9dea4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec8f8p+17,                0x1.8p+1,    0x1.c7de2a2711fbp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d0163a022p+35,                0x1.8p+0,   0x1.b9d6bd3bb86bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efa08p+17,                0x1.8p+1,    0x1.d06f54218a6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0838p+17,                0x1.8p+1,   0x1.13a4c0db9aa2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8afbbf22p+35,                0x1.8p+0,   0x1.f511a77b0075cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc748p+17,                0x1.8p+1,   0x1.7469145ec25bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba588p+17,                0x1.8p+1,   0x1.4a2d0f164bc88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d779aae2p+35,                0x1.8p+0,   0x1.0d1e850d43d3cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.eec6b8282p+35,                0x1.8p+0,    0x1.e66204a9dfbfp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1eb8p+17,                0x1.8p+1,   0x1.5b6dc24c81f64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d5caa422p+35,                0x1.8p+0,   0x1.736a89cc3bbc4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea848p+17,                0x1.8p+1,   0x1.c2380f5d318ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3bb8p+17,                0x1.8p+1,   0x1.8659369a49dd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbf38p+17,                0x1.8p+1,   0x1.9b4a0763e357cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5fd8p+17,                0x1.8p+1,   0x1.4084c8ec851c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e21f8p+17,                0x1.8p+1,    0x1.ab7f6787c8e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d86a8p+17,                0x1.8p+1,   0x1.92314480d0236p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfca8p+17,                0x1.8p+1,   0x1.a552ff3874756p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.930b842a2p+35,                0x1.8p+0,   0x1.6599227bc902cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcac8p+17,                0x1.8p+1,   0x1.f6160f273fe64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99cb8p+17,                0x1.8p+1,   0x1.0684b7b4ad904p+53,          0x1p-1, INEXACT)
T(RN,       0x1.51d011b32p+35,                0x1.8p+0,   0x1.126597a484edep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be988p+17,                0x1.8p+1,   0x1.53c8dbea97148p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bec969442p+35,                0x1.8p+0,   0x1.a15d4d4bc1c58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c49b8p+17,                0x1.8p+1,   0x1.61b11f2c48a74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b01b7aa2p+35,                0x1.8p+0,   0x1.703f0d2c312d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1ba8p+17,                0x1.8p+1,   0x1.3740da33ce8a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c78b07db2p+35,                0x1.8p+0,   0x1.adb1a4fec1a8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dbd48p+17,                0x1.8p+1,   0x1.9af9af247cddcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.652364f32p+35,                0x1.8p+0,   0x1.2a46e15410fa2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6938p+17,                0x1.8p+1,   0x1.1fdb1a5c9af5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2ded43a2p+35,                0x1.8p+0,   0x1.ec6eb4907cf8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9898p+17,                0x1.8p+1,   0x1.ecdae3cab0de6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d43f63e2p+35,                0x1.8p+0,   0x1.0ce00377bdadcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.90200b112p+35,                0x1.8p+0,   0x1.61b827b08b4d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c82f370d2p+35,                0x1.8p+0,   0x1.ae9a073608d26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff3d8p+17,                0x1.8p+1,   0x1.fdb95d8d4e782p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3da385a2p+35,                0x1.8p+0,   0x1.7c32bad21ae4cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f4af2f582p+35,                0x1.8p+0,    0x1.ef1edffdb18fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d53e6c32p+35,                0x1.8p+0,   0x1.3498570573542p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f4dea7ec2p+35,                0x1.8p+0,   0x1.ef654bf6cd9b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53684fd32p+35,                0x1.8p+0,   0x1.1457963c12962p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5b78p+13,                  0x1p+2,    0x1.b26c5dc3fbc2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecb18p+17,                0x1.8p+1,   0x1.c83c977ca389ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.912ebb842p+35,                0x1.8p+0,   0x1.631f55b939e28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8de8p+17,                0x1.8p+1,   0x1.bdb1f81c7c792p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c3476b792p+35,                0x1.8p+0,   0x1.a7acc2d8ef082p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f85e55b22p+35,                0x1.8p+0,   0x1.f498730a83a24p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7d08p+17,                0x1.8p+1,    0x1.448a4df409d7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1db8p+17,                0x1.8p+1,   0x1.81ac43d525e34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.97deae8f2p+35,                0x1.8p+0,   0x1.6c09e12a60066p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a49fb8992p+35,                0x1.8p+0,   0x1.7d3f1fc0543bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.68d5970b2p+35,                0x1.8p+0,   0x1.2eeb50df2ba2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a37d8p+17,                0x1.8p+1,   0x1.19986fd4b6642p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a4f4f0202p+35,                0x1.8p+0,    0x1.7db301785d0cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0b38p+17,                0x1.8p+1,   0x1.a7b9fb93c9fbcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.71b5a33e2p+35,                0x1.8p+0,   0x1.3a29e6dc3fcdcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.903e1a282p+35,                0x1.8p+0,    0x1.61e00460e381p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6978p+17,                0x1.8p+1,   0x1.665d49680ce48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1628p+17,                0x1.8p+1,   0x1.5a30c2f825f5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf7b8p+17,                0x1.8p+1,   0x1.7bcde6d0a7514p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3eb8p+17,                0x1.8p+1,   0x1.86d16ffa2b564p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d8af9602p+35,                0x1.8p+0,    0x1.0d35f824777cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0218p+17,                0x1.8p+1,   0x1.12e25dd7e2b6ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb058p+17,                0x1.8p+1,   0x1.70f15fabcdb9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c3b63a7d2p+35,                0x1.8p+0,   0x1.a848d8307a906p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac368p+17,                0x1.8p+1,   0x1.2b877f2b0855ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c78924e92p+35,                0x1.8p+0,   0x1.adaef9afa015ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb988p+17,                0x1.8p+1,   0x1.7254467633848p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2018p+17,                0x1.8p+1,   0x1.820aac4f9260ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5dd8p+17,                0x1.8p+1,   0x1.b5879b4b0e062p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab2e8p+17,                0x1.8p+1,   0x1.295ed6152ec02p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5e28p+17,                0x1.8p+1,   0x1.8bc31739b20dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f4ad35092p+35,                0x1.8p+0,   0x1.ef1bf0f866462p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd0200722p+35,                0x1.8p+0,   0x1.9edfcefee5a5cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.53ca0ac52p+35,                0x1.8p+0,   0x1.14cefa1595e16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.71399d172p+35,                0x1.8p+0,   0x1.398bde31fb856p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fbe38p+17,                0x1.8p+1,   0x1.f3c3c962c4a4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6cc7bb872p+35,                0x1.8p+0,   0x1.33e6cdce53f76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7b38p+17,                0x1.8p+1,   0x1.68fe93b0884bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c931fe0b2p+35,                0x1.8p+0,   0x1.b008a0f530c2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d29c8p+17,                0x1.8p+1,   0x1.838c61d9c8934p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b42b8p+17,                0x1.8p+1,   0x1.3c89fb8b5e224p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b79c73a2p+35,                0x1.8p+0,   0x1.32405bdcc918cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4c5b1fa2p+35,                0x1.8p+0,   0x1.93692d4d4360cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1ae8p+17,                0x1.8p+1,   0x1.3727054ef3b82p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.abcd8p+17,                0x1.8p+1,   0x1.2aab5e8f487b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad748p+17,                0x1.8p+1,   0x1.2e24beae7f8bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cd30c7b2p+35,                0x1.8p+0,   0x1.0c5769c0562b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf671cac2p+35,                0x1.8p+0,   0x1.b8dcc074d7ac8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3638p+17,                0x1.8p+1,   0x1.857d0d788c8ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c30b57a92p+35,                0x1.8p+0,   0x1.a7582b16b3d22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4e167ce2p+35,                0x1.8p+0,   0x1.938f91e523c7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2da8p+17,                0x1.8p+1,   0x1.8426f24aa7906p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.849609422p+35,                0x1.8p+0,   0x1.52876c6f4f1c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f2907522p+35,                0x1.8p+0,   0x1.4b76a87103a64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f51a01cf2p+35,                0x1.8p+0,   0x1.efbd5c51ab61ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1358p+17,                0x1.8p+1,   0x1.d4e5804c4d3aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e43b8p+17,                0x1.8p+1,   0x1.b1222646c4754p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3fd8p+17,                0x1.8p+1,   0x1.dccf28fb27bc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2b18p+17,                0x1.8p+1,   0x1.5d393c4a64a9ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bb98p+17,                0x1.8p+1,   0x1.0a3e93ffe90f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd4c8p+17,                0x1.8p+1,   0x1.767622920ca44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cac8p+17,                0x1.8p+1,   0x1.0c1714164de64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79b9c2ea2p+35,                0x1.8p+0,   0x1.446fbe2acccacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c417ef332p+35,                0x1.8p+0,   0x1.a8d288988fc22p+53,          0x1p-1, INEXACT)
T(RN,           0x1.addd8p+17,                0x1.8p+1,   0x1.2f02933bc7862p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae618p+17,                0x1.8p+1,   0x1.301a0c77aec2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5840a5b22p+35,                0x1.8p+0,   0x1.1a47c86e0a5dcp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5568p+13,                  0x1p+2,   0x1.94e3957b86208p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b32f8p+17,                0x1.8p+1,    0x1.3a6692906e39p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0148p+17,                0x1.8p+1,   0x1.572f18279c69cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3a43a792p+35,                0x1.8p+0,   0x1.beecca3cfdd7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6308p+17,                0x1.8p+1,    0x1.8c884e4cdf89p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba0f8p+17,                0x1.8p+1,    0x1.4989b2b99e83p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0d78p+17,                0x1.8p+1,   0x1.d3dbc161aa508p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d84e69f2p+35,                0x1.8p+0,   0x1.34d66ef0da846p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5733be62p+35,                0x1.8p+0,   0x1.c1852c446236cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6605089a2p+35,                0x1.8p+0,   0x1.2b61bb0cb3bccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4788p+17,                0x1.8p+1,   0x1.615f1808a96e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc828p+17,                0x1.8p+1,   0x1.748b0d7d669bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d174d7de2p+35,                0x1.8p+0,   0x1.bbcbd227798e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5ceb47c72p+35,                0x1.8p+0,   0x1.200a1d82c66f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4b88p+17,                0x1.8p+1,   0x1.1c14a8bb6bfa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8067a2b62p+35,                0x1.8p+0,   0x1.4d146c60ca58cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.790e0db02p+35,                0x1.8p+0,    0x1.43929da297e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e91f8p+17,                0x1.8p+1,    0x1.be63d71f4236p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad858p+17,                0x1.8p+1,   0x1.2e48a1a9d871ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f12f8p+17,                0x1.8p+1,    0x1.d4d486e541d9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2258p+17,                0x1.8p+1,   0x1.38276e64b9dfap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c47b8p+17,                0x1.8p+1,   0x1.61661f7680414p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d6eef1b2p+35,                0x1.8p+0,   0x1.34ba982777bf2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c7108p+17,                0x1.8p+1,    0x1.677bbeb94db3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d049a4b82p+35,                0x1.8p+0,    0x1.ba202cd10d0bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7238p+17,                0x1.8p+1,   0x1.b8fa9f46de00cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e0e7ad972p+35,                0x1.8p+0,   0x1.d212b05fca8aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f0ff20a2p+35,                0x1.8p+0,   0x1.604f9590d0d6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0fa8p+17,                0x1.8p+1,   0x1.a875d86e80866p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a7c7e9c92p+35,                0x1.8p+0,   0x1.818bfb3433ee2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e415f552p+35,                0x1.8p+0,   0x1.21b2204633636p+53,          0x1p-1, INEXACT)
T(RN,       0x1.782d58d32p+35,                0x1.8p+0,   0x1.4271889ac9b62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce7b8p+17,                0x1.8p+1,   0x1.7959ea35d8214p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f6975ec2p+35,                0x1.8p+0,   0x1.0f7a13eb845b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6da8p+17,                0x1.8p+1,   0x1.66fbd4a037506p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc3f8p+17,                0x1.8p+1,    0x1.9c0f2d12134cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4461a7e42p+35,                0x1.8p+0,   0x1.02321bfeda018p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5385a0082p+35,                0x1.8p+0,    0x1.147b63c835cdp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0228p+17,                0x1.8p+1,   0x1.a63afe09f219ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f028dc0a2p+35,                0x1.8p+0,   0x1.e86c94f5e696cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47e921612p+35,                0x1.8p+0,   0x1.066bbca7c1732p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c3b8p+17,                0x1.8p+1,   0x1.0b3b15dbfef54p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a278p+17,                0x1.8p+1,   0x1.0735ae4cdd0f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7bfe2ed2p+35,                0x1.8p+0,   0x1.c4d3b347ab91ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5976df592p+35,                0x1.8p+0,   0x1.1bc5afbf14d3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc308p+17,                0x1.8p+1,    0x1.73c42e9875a9p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ced8p+17,                0x1.8p+1,   0x1.0c95d62935c12p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c13449d2p+35,                0x1.8p+0,   0x1.0b6f9b77c74bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aaaa8p+17,                0x1.8p+1,   0x1.284b812f712f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3c6ebff2p+35,                0x1.8p+0,   0x1.9208687868586p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dce38p+17,                0x1.8p+1,   0x1.9db96fe69fd4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b78b62d2p+35,                0x1.8p+0,   0x1.0ab4fc1aee69ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bce88p+17,                0x1.8p+1,   0x1.4ff28a814cc38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc908p+17,                0x1.8p+1,    0x1.f5c32a3531bbp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e0ddfc982p+35,                0x1.8p+0,    0x1.d20499ba8c69p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e60d5d1a2p+35,                0x1.8p+0,   0x1.d9935fc913134p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e758p+17,                0x1.8p+1,   0x1.0f95988028d6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba978p+17,                0x1.8p+1,   0x1.4aba360122a48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3708p+17,                0x1.8p+1,    0x1.3af3886a1c05p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fab68p+17,                0x1.8p+1,   0x1.f04d493499cdap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97c0567d2p+35,                0x1.8p+0,   0x1.6be141fee2106p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4758p+17,                0x1.8p+1,   0x1.1b8d060458f6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.da418p+17,                0x1.8p+1,   0x1.96e8eb5f524cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.af9b8p+17,                0x1.8p+1,   0x1.32b58d8b41b74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e49f7272p+35,                0x1.8p+0,   0x1.4a555f3f6f836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9fdf2f382p+35,                0x1.8p+0,    0x1.76cdd4ce28e5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7be8p+17,                0x1.8p+1,   0x1.907a98238a132p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2e78p+17,                0x1.8p+1,   0x1.39ca9fab89338p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9bc88p+17,                0x1.8p+1,   0x1.0a5bae8b4e4d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c40705522p+35,                0x1.8p+0,   0x1.a8bab1c79d99cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9768p+17,                0x1.8p+1,   0x1.4833feb7b331ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8776ac092p+35,                0x1.8p+0,   0x1.564bd1961b99ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb1d8p+17,                0x1.8p+1,   0x1.4be6f622ada22p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3608p+13,                  0x1p+2,    0x1.135779d30fd8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9fb8p+17,                0x1.8p+1,   0x1.6e716ca9abc94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4958p+17,                0x1.8p+1,   0x1.b213d53ab3ccap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2428p+17,                0x1.8p+1,   0x1.5c3774aebc8fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa508p+17,                0x1.8p+1,    0x1.ef21cf05f44fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cc0fae52p+35,                0x1.8p+0,   0x1.33de413430baap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c44b8p+17,                0x1.8p+1,   0x1.60f5b3c805084p+53,          0x1p-1, INEXACT)
T(RN,       0x1.43a2bc082p+35,                0x1.8p+0,    0x1.014e4a7704b3p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa278p+17,                0x1.8p+1,   0x1.273aea7e000f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3ae8p+17,                0x1.8p+1,   0x1.dbed499dcb182p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d043ee0e2p+35,                0x1.8p+0,   0x1.ba18039282d04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f126f6cf2p+35,                0x1.8p+0,   0x1.e9e3fbdcbe01ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc0101002p+35,                0x1.8p+0,     0x1.fa0480fedfap+53,          0x1p-1, INEXACT)
T(RN,       0x1.522cb17a2p+35,                0x1.8p+0,   0x1.12d67a19c24f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efa98p+17,                0x1.8p+1,   0x1.d088a1962cf46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a4d9bcc92p+35,                0x1.8p+0,   0x1.7d8e03234571ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc1e8p+17,                0x1.8p+1,   0x1.73989083c3f52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7de8p+17,                0x1.8p+1,   0x1.e7fe2430edc92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f47d4162p+35,                0x1.8p+0,   0x1.76014a357a0b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4b067ea82p+35,                0x1.8p+0,    0x1.0a2b2e25dfd1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca238p+17,                0x1.8p+1,   0x1.6ed178e1ab90cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0828p+17,                0x1.8p+1,   0x1.7e55e356f95bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f23b06192p+35,                0x1.8p+0,   0x1.eb7c3f083d6bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.4ef9cd532p+35,                0x1.8p+0,   0x1.0ef28f5b4cb9ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6a08p+17,                0x1.8p+1,    0x1.e4647a12f3bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bbc8p+17,                0x1.8p+1,   0x1.0a4465f05ce94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48412f372p+35,                0x1.8p+0,   0x1.06d57778ecbeap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0c68p+17,                0x1.8p+1,   0x1.7efde5384508ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd919b312p+35,                0x1.8p+0,   0x1.b63f699688d6ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef8388582p+35,                0x1.8p+0,    0x1.e778898a53d1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.640e52a42p+35,                0x1.8p+0,   0x1.28ec08af01768p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef194ecf2p+35,                0x1.8p+0,   0x1.e6dbd1ba96fe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6f714ba32p+35,                0x1.8p+0,   0x1.37474fa633302p+53,          0x1p-1, INEXACT)
T(RN,               0x1.e7p+8,                0x1.8p+2,   0x1.7b2948992cf28p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62568b882p+35,                0x1.8p+0,    0x1.26c696ce437dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9eb8p+17,                0x1.8p+1,   0x1.26be48daf5764p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3b385252p+35,                0x1.8p+0,   0x1.bf02b64b7b4d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bd3637382p+35,                0x1.8p+0,    0x1.9f28d59b6be5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a93f4dc2p+35,                0x1.8p+0,   0x1.5a639d8d6ade8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.93c7b2792p+35,                0x1.8p+0,   0x1.6693b110fb282p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2f38p+17,                0x1.8p+1,   0x1.d9d7bcf40aa7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8238p+17,                0x1.8p+1,   0x1.917c0936dc30cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.65b4c6422p+35,                0x1.8p+0,   0x1.2afd14ebd2c3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4d4793e2p+35,                0x1.8p+0,   0x1.937da6ea46724p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6c41d1c2p+35,                0x1.8p+0,   0x1.962d21939c768p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e72a8p+17,                0x1.8p+1,   0x1.b90da2233fc76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5168p+17,                0x1.8p+1,   0x1.dff4d7a0fa8fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd028p+17,                0x1.8p+1,   0x1.f714e2da31f3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0ed8p+17,                0x1.8p+1,   0x1.7f5e56d859812p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac47176f2p+35,                0x1.8p+0,   0x1.87b31e120195ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cd28p+17,                0x1.8p+1,   0x1.0c612a0d6ff2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5778p+17,                0x1.8p+1,   0x1.8ab4f7c0886e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef9d1ca32p+35,                0x1.8p+0,   0x1.e79e49089b502p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ae98p+17,                0x1.8p+1,   0x1.08abdc33a8706p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f834a6fd2p+35,                0x1.8p+0,   0x1.f45a65ff7c5fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.852872d02p+35,                0x1.8p+0,    0x1.5346d24eb632p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4c38p+17,                0x1.8p+1,   0x1.1c2af19b53aecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.da1799792p+35,                0x1.8p+0,   0x1.c834420573482p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f8a8p+17,                0x1.8p+1,   0x1.11b78d342dc96p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.60e3e5082p+35,                0x1.8p+0,    0x1.24f88af56013p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf1f8p+17,                0x1.8p+1,    0x1.7aebe815ad56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e22f78b12p+35,                0x1.8p+0,   0x1.d3ef880cc9f92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba6d8p+17,                0x1.8p+1,   0x1.4a5c1797f2092p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1438p+17,                0x1.8p+1,   0x1.80333bd6cc86cp+53,          0x1p-1, INEXACT)
T(RN,            0x1.46a8p+13,                  0x1p+2,   0x1.5352d3e79ff58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5db8p+17,                0x1.8p+1,   0x1.b582341f35a34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef3d8p+17,                0x1.8p+1,   0x1.cf593cc003782p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ebbd3262p+35,                0x1.8p+0,   0x1.224a1929df3ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f38e78d2p+35,                0x1.8p+0,   0x1.0f3f22a65a626p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d97bc3132p+35,                0x1.8p+0,   0x1.c75364ce407e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ccd906c2p+35,                0x1.8p+0,   0x1.1fe5524362948p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ae6c88a92p+35,                0x1.8p+0,   0x1.8aa5d5be374dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.adf08p+17,                0x1.8p+1,    0x1.2f2ac2d824fdp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afcf8p+17,                0x1.8p+1,    0x1.33247640a197p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d42d8p+17,                0x1.8p+1,   0x1.8776e728ddbd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72183c3b2p+35,                0x1.8p+0,   0x1.3aa79c5759a32p+53,          0x1p-1, INEXACT)
T(RN,     0x1.6800f01d884p+42,                0x1.4p+0,   0x1.1535b8e4bd8a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac45432a2p+35,                0x1.8p+0,   0x1.87b09ba8bda2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba8d8p+17,                0x1.8p+1,   0x1.4aa3cb9e8e9f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d04f8p+17,                0x1.8p+1,    0x1.7dd8023181afp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9468p+17,                0x1.8p+1,   0x1.becea6d4ad60ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f48d90a12p+35,                0x1.8p+0,   0x1.eeed0237244b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5227d12c2p+35,                0x1.8p+0,   0x1.12d0885b9c5c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e5fdc65e2p+35,                0x1.8p+0,   0x1.d97c97863e81cp+53,          0x1p-1, INEXACT)
T(RN,             0x1.93cp+10,                0x1.4p+2,   0x1.3841e92b762c8p+53,          0x1p-1, INEXACT)
T(RN,            0x1.66f8p+13,                  0x1p+2,    0x1.eeda81729f24p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be0aecb32p+35,                0x1.8p+0,   0x1.a0527fda178dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ad16aba2p+35,                0x1.8p+0,   0x1.5ab48f3263174p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d0acb3262p+35,                0x1.8p+0,   0x1.baadb2582b3ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.db598p+17,                0x1.8p+1,   0x1.99bb4cc3efad6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7ac8p+17,                0x1.8p+1,   0x1.443aa2f171f64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7a68p+17,                0x1.8p+1,   0x1.ba5ec1b16b62ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d71a8p+17,                0x1.8p+1,   0x1.8ed97c8af7fc6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb058p+17,                0x1.8p+1,   0x1.70f15fabcdb9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4cc6262f2p+35,                0x1.8p+0,   0x1.0c47d029266dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.86e592f12p+35,                0x1.8p+0,   0x1.558d93a8e2712p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4d88p+17,                0x1.8p+1,   0x1.1c557ff78cc08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad958p+17,                0x1.8p+1,   0x1.2e6a6ad477fcap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd618p+17,                0x1.8p+1,   0x1.f82ec5b57c12ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c46e66a22p+35,                0x1.8p+0,   0x1.a94c6eb2f1784p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8168p+17,                0x1.8p+1,   0x1.915ae034179fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.530843932p+35,                0x1.8p+0,   0x1.13e25146fc71ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e818272c2p+35,                0x1.8p+0,   0x1.dc903b1937638p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c648a8fc2p+35,                0x1.8p+0,   0x1.abe9d7baf3558p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdfd8p+17,                0x1.8p+1,   0x1.7825d2b8f59c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb5a8p+17,                0x1.8p+1,   0x1.f22fc9691a686p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f3598p+17,                0x1.8p+1,   0x1.dafa9251282d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a6fa66932p+35,                0x1.8p+0,   0x1.8073a862d9ee2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ca9094c2p+35,                0x1.8p+0,   0x1.72788a2289578p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dbb5ba4f2p+35,                0x1.8p+0,   0x1.ca8a85878471ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.97358p+17,                0x1.8p+1,   0x1.01947a9f9b5aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1068p+17,                0x1.8p+1,   0x1.a8959e4869f4ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c888p+17,                0x1.8p+1,   0x1.0bd0f0e968f18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac7b8p+17,                0x1.8p+1,   0x1.2c1861b613c14p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e6509752p+35,                0x1.8p+0,   0x1.0e3e24cce4f8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f5e1ebf2p+35,                0x1.8p+0,   0x1.2313ad9b06ffap+53,          0x1p-1, INEXACT)
T(RN,           0x1.acd98p+17,                0x1.8p+1,   0x1.2cde0dfeda356p+53,          0x1p-1, INEXACT)
T(RN,       0x1.acc382ed2p+35,                0x1.8p+0,   0x1.885ddb2e286e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0e2e7002p+35,                0x1.8p+0,     0x1.782d26a9d6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b67f8p+17,                0x1.8p+1,    0x1.41a283fe7a38p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc1b8p+17,                0x1.8p+1,   0x1.4e22fe61cb8f4p+53,          0x1p-1, INEXACT)
T(RN,            0x1.66c8p+13,                  0x1p+2,    0x1.edd2086a6507p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7182a8b72p+35,                0x1.8p+0,   0x1.39e8ee699feeap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb2a8p+17,                0x1.8p+1,   0x1.c401c04f6a876p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd548p+17,                0x1.8p+1,   0x1.50e76c697fa5cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fcf429d52p+35,                0x1.8p+0,   0x1.fb6ffc9c38336p+53,          0x1p-1, INEXACT)
T(RN,        0x1.3d4d7404p+30,                0x1.cp+0,    0x1.079005ddc1aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4809250b2p+35,                0x1.8p+0,   0x1.06922bd9dde2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4297d0542p+35,                0x1.8p+0,   0x1.001039aefa8b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2a68p+17,                0x1.8p+1,   0x1.ace6e8fff4f2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86db16cc2p+35,                0x1.8p+0,   0x1.557fd5c5e6b88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d4ed37032p+35,                0x1.8p+0,   0x1.c0c4bb7d78dc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f21f67862p+35,                0x1.8p+0,   0x1.eb536152bfbacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d257e0362p+35,                0x1.8p+0,   0x1.bd10ad436fc8cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ccce186f2p+35,                0x1.8p+0,   0x1.b5291437aa4a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1668p+17,                0x1.8p+1,   0x1.5a3a019d3756ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7358p+17,                0x1.8p+1,   0x1.4333a6e3f15aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef498p+17,                0x1.8p+1,   0x1.cf7aec16f5126p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbed8p+17,                0x1.8p+1,   0x1.9b3a799f41112p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c80c8p+17,                0x1.8p+1,   0x1.69d23fa8bf684p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adbc8p+17,                0x1.8p+1,   0x1.2ebccfb822494p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6e381c8a2p+35,                0x1.8p+0,   0x1.35b9ac211046cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4b18p+17,                0x1.8p+1,   0x1.61e4b5208009ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3908p+17,                0x1.8p+1,    0x1.db979614040bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4658p+17,                0x1.8p+1,   0x1.ddf8efc92cebap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f3a54b72p+35,                0x1.8p+0,   0x1.4b8d1c5a356eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eba58p+17,                0x1.8p+1,   0x1.c555aa0ca667ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5fb944b62p+35,                0x1.8p+0,   0x1.2384f81f7c674p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc3840122p+35,                0x1.8p+0,   0x1.b453e9809f1e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a008p+17,                0x1.8p+1,     0x1.06eaa03dccep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db998p+17,                0x1.8p+1,   0x1.9a60e2092f996p+53,          0x1p-1, INEXACT)
T(RN,       0x1.43f242232p+35,                0x1.8p+0,   0x1.01ad26ca02ffep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3fc2b402p+35,                0x1.8p+0,    0x1.bf6ae15a83c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5052b8a42p+35,                0x1.8p+0,   0x1.1095774977368p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d87bee32p+35,                0x1.8p+0,   0x1.0d320f8863182p+53,          0x1p-1, INEXACT)
T(RN,           0x1.de028p+17,                0x1.8p+1,   0x1.a0a6278040a3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dde1927f2p+35,                0x1.8p+0,   0x1.cdaf1d02c277ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a12a8p+17,                0x1.8p+1,   0x1.14f0d416d3a76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a78a0e9e2p+35,                0x1.8p+0,   0x1.8137948a08d64p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb798p+17,                0x1.8p+1,   0x1.72095bb428236p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c9db2ca2p+35,                0x1.8p+0,   0x1.1faa116678a14p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0216f802p+35,                0x1.8p+0,     0x1.a33fb7d8b9dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9bb3d412p+35,                0x1.8p+0,   0x1.c7aef85f77172p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a38a8bdc2p+35,                0x1.8p+0,   0x1.7bc686d4f97e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eb052d052p+35,                0x1.8p+0,   0x1.e0dadd56c716ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a17e299d2p+35,                0x1.8p+0,   0x1.78ff601d4fabap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c8ae06c2p+35,                0x1.8p+0,   0x1.48128b5fff6b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.50d4727c2p+35,                0x1.8p+0,   0x1.11333c7698c58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2798p+17,                0x1.8p+1,   0x1.5cb71f594af36p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97158p+17,                0x1.8p+1,   0x1.0157c5d95784ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8138p+17,                0x1.8p+1,   0x1.91533975d7bdcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dd26382a2p+35,                0x1.8p+0,   0x1.cc9fb68da882cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a25c8p+17,                0x1.8p+1,   0x1.1754007695474p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6868p+17,                0x1.8p+1,   0x1.41b1eb7e3f3cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d378p+17,                0x1.8p+1,   0x1.0d2655ee42628p+53,          0x1p-1, INEXACT)
T(RN,       0x1.820483592p+35,                0x1.8p+0,   0x1.4f2d9caf9d53ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b838p+17,                0x1.8p+1,   0x1.09d5df97ecb2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.649221352p+35,                0x1.8p+0,   0x1.2990f7d0e0c0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bf9e4582p+35,                0x1.8p+0,    0x1.32e2549d2651p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b37ef92e2p+35,                0x1.8p+0,   0x1.91a4dbbc15e3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9a88p+17,                0x1.8p+1,   0x1.ed359418bca78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.edc88p+17,                0x1.8p+1,   0x1.cb455fbac9ad8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee3c8p+17,                0x1.8p+1,   0x1.cc89591fb2e14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aed18p+17,                0x1.8p+1,   0x1.3107b41b011fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ace38p+17,                0x1.8p+1,   0x1.2cf31a8866d4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c07d23492p+35,                0x1.8p+0,   0x1.a3c06e9c12c1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2198p+17,                0x1.8p+1,   0x1.ab6f71d2c9916p+53,          0x1p-1, INEXACT)
T(RN,       0x1.87be62bf2p+35,                0x1.8p+0,   0x1.56a9e53580806p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1a48p+17,                0x1.8p+1,   0x1.37117fa7c344cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a1c49bc32p+35,                0x1.8p+0,   0x1.795ecf7e3ff42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c946c8532p+35,                0x1.8p+0,   0x1.b026195994a62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d32249db2p+35,                0x1.8p+0,   0x1.be3290b13a972p+53,          0x1p-1, INEXACT)
T(RN,       0x1.783958fa2p+35,                0x1.8p+0,   0x1.4280f6b5ef00cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f73e8p+17,                0x1.8p+1,   0x1.e62dd7922f3b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d7e25422p+35,                0x1.8p+0,   0x1.494d5494bf63cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4528p+17,                0x1.8p+1,   0x1.1b463c77051aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e04e8p+17,                0x1.8p+1,   0x1.a6af1d5b82662p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1fe8p+17,                0x1.8p+1,   0x1.37d356465c5f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5653b5cc2p+35,                0x1.8p+0,   0x1.17ea554e5fa78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0608p+17,                0x1.8p+1,    0x1.7e01f4d64492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74879aaa2p+35,                0x1.8p+0,   0x1.3dc3e65dc30d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.69d6a7922p+35,                0x1.8p+0,   0x1.302f3f8d67ce4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb458p+17,                0x1.8p+1,   0x1.c44c4f309b65ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d7fef8a2p+35,                0x1.8p+0,   0x1.20c244c67866cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a8970bc2p+35,                0x1.8p+0,   0x1.1d1840dd61128p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9388p+17,                0x1.8p+1,   0x1.94404cccb2d28p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76d513d22p+35,                0x1.8p+0,   0x1.40b749fccc89cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f67d8p+17,                0x1.8p+1,   0x1.e3ff5047fb742p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d01090c2p+35,                0x1.8p+0,   0x1.72ef114c72108p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e008df632p+35,                0x1.8p+0,   0x1.d0ceef5731d7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab828p+17,                0x1.8p+1,   0x1.2a0e64cbcbebep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eff48p+17,                0x1.8p+1,   0x1.d15ba0202b83cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca268p+17,                0x1.8p+1,   0x1.6ed8adac989aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8608p+17,                0x1.8p+1,    0x1.bc59b2dd0912p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4fc312a2p+35,                0x1.8p+0,   0x1.7dbcdf4bc0e2cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e6dfe362p+35,                0x1.8p+0,   0x1.74db2a048e88cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b11f1b7d2p+35,                0x1.8p+0,   0x1.8e5d152ba5b06p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9fdd61c82p+35,                0x1.8p+0,    0x1.76cb6500bc25p+53,          0x1p-1, INEXACT)
T(RN,       0x1.851dfca52p+35,                0x1.8p+0,   0x1.53392411c0bd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6848p+17,                0x1.8p+1,   0x1.e4138ab667cecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf3a8p+17,                0x1.8p+1,   0x1.553b25de50d26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8f58p+17,                0x1.8p+1,   0x1.9394b08ee60eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4969b4792p+35,                0x1.8p+0,   0x1.0839eacbc0e82p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5bb035d22p+35,                0x1.8p+0,   0x1.1e84508e08b64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be018p+17,                0x1.8p+1,   0x1.5270a82770a0ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e008p+17,                0x1.8p+1,     0x1.0eafd911cdap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c29c9d9e2p+35,                0x1.8p+0,   0x1.a6bc50cef289cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5de811662p+35,                0x1.8p+0,   0x1.21435bb82aa6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa2d8p+17,                0x1.8p+1,   0x1.274762fca0dd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f026e4062p+35,                0x1.8p+0,   0x1.e869acba168acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.704533af2p+35,                0x1.8p+0,   0x1.3854bcb799e26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed41bc772p+35,                0x1.8p+0,   0x1.e424e1d107996p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1b9b2bf2p+35,                0x1.8p+0,   0x1.a57d273956806p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fee128382p+35,                0x1.8p+0,    0x1.fe51f89d1a45p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.88bc36922p+35,                0x1.8p+0,   0x1.57f72544512e4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5b08p+17,                0x1.8p+1,    0x1.1e0c2ef17c71p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49298c552p+35,                0x1.8p+0,   0x1.07ecbd8a47fcap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97118p+17,                0x1.8p+1,   0x1.01502fec500bep+53,          0x1p-1, INEXACT)
T(RN,            0x1.55e8p+13,                  0x1p+2,   0x1.97441f76f2ba8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d00cb4c82p+35,                0x1.8p+0,    0x1.b9c924b8b905p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7bdf7772p+35,                0x1.8p+0,   0x1.c4d0efa947c6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1cc8p+17,                0x1.8p+1,   0x1.1633f484f2fc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d7b649a92p+35,                0x1.8p+0,   0x1.c4c5e14c846dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.aee5986e2p+35,                0x1.8p+0,   0x1.8b4c611f10ebcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0348p+17,                0x1.8p+1,   0x1.7d956903544fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc108p+17,                0x1.8p+1,    0x1.4e0a2ae827a3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b09d3d52p+35,                0x1.8p+0,   0x1.1db6bf03a48cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c446ec4d2p+35,                0x1.8p+0,   0x1.a914c58b1bc5ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdcd8p+17,                0x1.8p+1,   0x1.f96fbb4a70db2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4785ecc02p+35,                0x1.8p+0,    0x1.05f4aefc24c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0458p+17,                0x1.8p+1,   0x1.1329bb8025d5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2de8p+17,                0x1.8p+1,   0x1.5da1e1d88c592p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.78adf6b42p+35,                0x1.8p+0,   0x1.4316f4ca352f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb9a8p+17,                0x1.8p+1,   0x1.72591c25e7146p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6478p+13,                  0x1p+2,    0x1.e136223b279ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8c30fa562p+35,                0x1.8p+0,   0x1.5c840a8a585ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.91ae3d402p+35,                0x1.8p+0,    0x1.63c8b054fd08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3b48p+17,                0x1.8p+1,   0x1.afb848272277cp+53,         -0x1p-1, INEXACT)
T(RN,             0x1.a34p+10,                0x1.4p+2,   0x1.78fa41e2c096ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5ef915142p+35,                0x1.8p+0,   0x1.22962985f2d38p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0bdd92e2p+35,                0x1.8p+0,   0x1.bac633e75e1c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb078p+17,                0x1.8p+1,   0x1.70f6324444798p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2df8p+17,                0x1.8p+1,    0x1.39b94efa980ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3608p+17,                0x1.8p+1,    0x1.aed784800022p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cc68p+17,                0x1.8p+1,   0x1.0c49c3539548ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.987f8p+17,                0x1.8p+1,    0x1.0408b0173498p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e39b8p+17,                0x1.8p+1,   0x1.af755b17f7774p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a94a8p+17,                0x1.8p+1,   0x1.257088c629fd6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.910d191a2p+35,                0x1.8p+0,   0x1.62f2ade4a76ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f31229c12p+35,                0x1.8p+0,   0x1.ecbab86bcd072p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a10a8p+17,                0x1.8p+1,   0x1.14b11de691d16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4108p+17,                0x1.8p+1,    0x1.dd058684d223p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57e18e1f2p+35,                0x1.8p+0,   0x1.19d2da9e9b946p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55a9b6e02p+35,                0x1.8p+0,    0x1.1719ee19686cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c01c8p+17,                0x1.8p+1,   0x1.57417a2a2a9b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b7b769f2p+35,                0x1.8p+0,   0x1.32427d14b77bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c13d8p+17,                0x1.8p+1,   0x1.59db474e4bd82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cce2f7af2p+35,                0x1.8p+0,   0x1.b546c82c6e9dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.69105d372p+35,                0x1.8p+0,   0x1.2f3556b3627eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f01e40c2p+35,                0x1.8p+0,   0x1.0efc5fcb25cf8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9de548f42p+35,                0x1.8p+0,   0x1.7422bb7a8c788p+53,          0x1p-1, INEXACT)
T(RN,       0x1.935eef0e2p+35,                0x1.8p+0,   0x1.66082ca3f3cfcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0988p+17,                0x1.8p+1,   0x1.585ebd495b748p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1c58p+17,                0x1.8p+1,   0x1.8175a297e8ddap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb898p+17,                0x1.8p+1,   0x1.4cd9e0058c3e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1958p+17,                0x1.8p+1,   0x1.15c6244db7bcap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2f2861a2p+35,                0x1.8p+0,   0x1.7af82e0eaf4ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddf48p+17,                0x1.8p+1,   0x1.a0818cc6b223cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdb88p+17,                0x1.8p+1,   0x1.f93147fe86aa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.891591112p+35,                0x1.8p+0,   0x1.586c8edc248d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aad241552p+35,                0x1.8p+0,   0x1.85b40ffc25a36p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef858p+17,                0x1.8p+1,   0x1.d0237146f1d1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ecd68p+17,                0x1.8p+1,   0x1.c8a368931c23ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffbd8p+17,                0x1.8p+1,   0x1.ff3899e840d02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6978p+17,                0x1.8p+1,   0x1.e44a754bb5e48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d07b2a9d2p+35,                0x1.8p+0,   0x1.ba66ebcecf746p+53,          0x1p-1, INEXACT)
T(RN,       0x1.837188d62p+35,                0x1.8p+0,   0x1.510978be726ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c60a8p+17,                0x1.8p+1,   0x1.65103b0e25416p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd8e8p+17,                0x1.8p+1,   0x1.f8b470d5d0c22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.499ea7182p+35,                0x1.8p+0,    0x1.0879a1da89a7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2138p+17,                0x1.8p+1,   0x1.5bca748fd59dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9330c8a52p+35,                0x1.8p+0,   0x1.65cabcb17e3d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4ce8p+17,                0x1.8p+1,   0x1.890b4dc21cfe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5808p+17,                0x1.8p+1,    0x1.b48c8cdfb308p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da8178df2p+35,                0x1.8p+0,   0x1.c8cd1baf56c3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd4f8p+17,                0x1.8p+1,    0x1.9ed2c592d81fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.552a53692p+35,                0x1.8p+0,   0x1.167de4a5f665ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ae59b382p+35,                0x1.8p+0,    0x1.1d8a05150165p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca3b8p+17,                0x1.8p+1,   0x1.6f0b21dd99954p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d99a8p+17,                0x1.8p+1,   0x1.953ba779f4b46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a3f69c22p+35,                0x1.8p+0,   0x1.1cbceb62bf6c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb9aebac2p+35,                0x1.8p+0,   0x1.b3743e68534c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5ad8p+17,                0x1.8p+1,   0x1.1e0614191dc52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f85f8p+17,                0x1.8p+1,    0x1.e9755285f112p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2f0b6f62p+35,                0x1.8p+0,   0x1.7af5b9a44180cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3718p+17,                0x1.8p+1,   0x1.5ef84c10e0edep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cf9c64e22p+35,                0x1.8p+0,   0x1.b928cbbe6d9fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c82f370d2p+35,                0x1.8p+0,   0x1.ae9a073608d26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0488p+17,                0x1.8p+1,   0x1.d2483c3771258p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b189d2f62p+35,                0x1.8p+0,   0x1.8ef058dfcb00cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dcc28p+17,                0x1.8p+1,   0x1.9d6392ad88c7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97d08p+17,                0x1.8p+1,    0x1.02bb0d6083d7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b79747272p+35,                0x1.8p+0,   0x1.97527d16c5836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3509ecc2p+35,                0x1.8p+0,   0x1.7b77e24909b88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf478p+17,                0x1.8p+1,   0x1.5558e86ddec58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4c68p+17,                0x1.8p+1,   0x1.3ddbe9b60dc8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5a98p+17,                0x1.8p+1,   0x1.8b332234bd146p+53,          0x1p-1, INEXACT)
T(RN,            0x1.3e08p+13,                  0x1p+2,    0x1.30e1581fc7f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d05f7f62p+35,                0x1.8p+0,   0x1.5d9d3ac15bdf4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bdb8a912p+35,                0x1.8p+0,   0x1.32bbf2dbcfdd2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7e18p+17,                0x1.8p+1,   0x1.2287c48b6fcaep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a27d8p+17,                0x1.8p+1,   0x1.17961f27f1b42p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae7b8p+17,                0x1.8p+1,   0x1.30512ceff2214p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8b0b61e62p+35,                0x1.8p+0,   0x1.5b00ec4b1a094p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.83e7e04c2p+35,                0x1.8p+0,   0x1.51a3ef8dcab78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2ab81572p+35,                0x1.8p+0,   0x1.ec22b88700fd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.feb18p+17,                0x1.8p+1,   0x1.fc170f0c99e9ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c02e8p+17,                0x1.8p+1,   0x1.576ad91656302p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.655ddde02p+35,                0x1.8p+0,    0x1.2a9025151634p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cad18p+17,                0x1.8p+1,   0x1.70740aef605fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c82c8p+17,                0x1.8p+1,   0x1.6a1e6f2dd38e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.67fd20792p+35,                0x1.8p+0,   0x1.2ddae5406897ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.edd68p+17,                0x1.8p+1,   0x1.cb6c7157c7d3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9bec97212p+35,                0x1.8p+0,   0x1.717ae21da4fb2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e9e08092p+35,                0x1.8p+0,   0x1.22251cecd319ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1e38p+17,                0x1.8p+1,   0x1.3799270b2cc4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ee1fa88a2p+35,                0x1.8p+0,   0x1.e56bc24c77394p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9868p+17,                0x1.8p+1,   0x1.bf7e13788f4cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af6b8p+17,                0x1.8p+1,   0x1.324f449962fe4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ffa68p+17,                0x1.8p+1,   0x1.fef3aeeca3e2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.981d8p+17,                0x1.8p+1,   0x1.034db6d851922p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4a48p+17,                0x1.8p+1,   0x1.88a1b4051ed4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2558p+17,                0x1.8p+1,   0x1.388f0349c0c0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7168p+17,                0x1.8p+1,   0x1.20e722d64aefap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ac081ad2p+35,                0x1.8p+0,   0x1.31565216d479ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6418p+17,                0x1.8p+1,   0x1.411a2952d58cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc2d48262p+35,                0x1.8p+0,   0x1.cb376c43025ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d373e8c2p+35,                0x1.8p+0,   0x1.20683329b1208p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8848p+17,                0x1.8p+1,   0x1.9273aff5e02ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b2f85ce72p+35,                0x1.8p+0,   0x1.90eab1b72acb6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe1d8p+17,                0x1.8p+1,   0x1.fa5dd26cdfb22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b30acc422p+35,                0x1.8p+0,   0x1.91042ecedf03cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c80976172p+35,                0x1.8p+0,   0x1.ae6493e3e79aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5298p+17,                0x1.8p+1,   0x1.89f05bcccf3c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a115e082p+35,                0x1.8p+0,    0x1.1c8420c2668dp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd1a8p+17,                0x1.8p+1,   0x1.9e48a5b0501c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2558p+17,                0x1.8p+1,   0x1.5c638b886bc0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7de8p+17,                0x1.8p+1,   0x1.baf739bc52c92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc8d8p+17,                0x1.8p+1,   0x1.74a5c063eaff2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd888p+17,                0x1.8p+1,   0x1.7708533b88218p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6d1f38f2p+35,                0x1.8p+0,   0x1.c37d485063666p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f3d98p+17,                0x1.8p+1,   0x1.dc68323d0c056p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a6f321252p+35,                0x1.8p+0,   0x1.8069be9a42cd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df6f8p+17,                0x1.8p+1,    0x1.a46371275785p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd658p+17,                0x1.8p+1,   0x1.510e0318451bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8130c3142p+35,                0x1.8p+0,   0x1.4e19f72867ec8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f1955a232p+35,                0x1.8p+0,   0x1.ea872ec1b0002p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e8f172a2p+35,                0x1.8p+0,   0x1.5fa4ffce56dd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd248p+17,                0x1.8p+1,   0x1.f779b97939eccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0218p+17,                0x1.8p+1,   0x1.33d391ac7db6ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3078p+17,                0x1.8p+1,   0x1.da10ba48dbf98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5758p+17,                0x1.8p+1,   0x1.63b127a441a6ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc108p+17,                0x1.8p+1,    0x1.f448ac5b33a3p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47dc538d2p+35,                0x1.8p+0,   0x1.065c5e07041dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9aafaab2p+35,                0x1.8p+0,   0x1.b0b42a6352eeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af3f847a2p+35,                0x1.8p+0,   0x1.8bc824f2bdd0cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd628p+17,                0x1.8p+1,   0x1.9f04513b0935ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b85d8p+17,                0x1.8p+1,   0x1.45c2d4106cbe2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.61d326d02p+35,                0x1.8p+0,    0x1.2622b028ad4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ece773b62p+35,                0x1.8p+0,   0x1.e39ffb4439074p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b12d8p+17,                0x1.8p+1,   0x1.3611aef0b5ad2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0388p+17,                0x1.8p+1,   0x1.3404bb28e1228p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0338p+17,                0x1.8p+1,   0x1.33fa0abd4663cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c46c85572p+35,                0x1.8p+0,   0x1.a949c80ec07d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be0375312p+35,                0x1.8p+0,   0x1.a0480baef1e92p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7768p+17,                0x1.8p+1,   0x1.e6d0373a57d1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e899115d2p+35,                0x1.8p+0,   0x1.dd4d155d198c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbe48p+17,                0x1.8p+1,   0x1.9b2325b488f0cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c928p+17,                0x1.8p+1,   0x1.0be46b3b99c6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f94aa9932p+35,                0x1.8p+0,   0x1.f5f873324bb1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea4b2d9c2p+35,                0x1.8p+0,   0x1.dfc9bebb30598p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9108p+17,                0x1.8p+1,    0x1.6c3e7766e613p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b8a4eb22p+35,                0x1.8p+0,   0x1.1e5577dca0bdcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c617af0b2p+35,                0x1.8p+0,   0x1.aba4a664475d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da3f8p+17,                0x1.8p+1,    0x1.96e3c582f2ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2d58p+17,                0x1.8p+1,   0x1.ad644184bf18ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c0b36f92p+35,                0x1.8p+0,   0x1.0b65e10577e7ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.52c58cd52p+35,                0x1.8p+0,   0x1.1390e6ce55936p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d7e0f842p+35,                0x1.8p+0,   0x1.0d2655ee42628p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5ba8p+17,                0x1.8p+1,   0x1.e1ccb262154a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d7ab15b2p+35,                0x1.8p+0,   0x1.4948dc1f7d78ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a838p+17,                0x1.8p+1,   0x1.07e6f45a2382cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.69ff02c62p+35,                0x1.8p+0,   0x1.306224935b42cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.967668982p+35,                0x1.8p+0,    0x1.6a27f5dee4e9p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e77a8p+17,                0x1.8p+1,   0x1.b9e70e372bfe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fffb00032p+35,                0x1.8p+0,   0x1.fff880095ffc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9163d9c72p+35,                0x1.8p+0,   0x1.6365df9b4bd0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e57185022p+35,                0x1.8p+0,   0x1.d8afae0d0e744p+53,          0x1p-1, INEXACT)
T(RN,       0x1.78d8dae12p+35,                0x1.8p+0,   0x1.434e256a073cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd738p+17,                0x1.8p+1,   0x1.512dccb1551fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4faa39382p+35,                0x1.8p+0,    0x1.0fc8b839eb5bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fed72b122p+35,                0x1.8p+0,   0x1.fe430129e1fe4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e1f8p+17,                0x1.8p+1,    0x1.0eecac021c26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9fb68p+17,                0x1.8p+1,   0x1.120e89367a3dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4958p+17,                0x1.8p+1,   0x1.1bcdc89c07ccap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7cb8p+17,                0x1.8p+1,   0x1.909bb4cad3304p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ed9c0d7c2p+35,                0x1.8p+0,   0x1.e4a9e0b48f5a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70343d982p+35,                0x1.8p+0,    0x1.383f2928c8c9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f62d9322p+35,                0x1.8p+0,   0x1.7625cb3595d24p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5062ee812p+35,                0x1.8p+0,   0x1.10a92c9bdc50ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e81a8p+17,                0x1.8p+1,   0x1.bb9abca411ac6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6c9368422p+35,                0x1.8p+0,   0x1.33a49047627c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b63df742p+35,                0x1.8p+0,   0x1.3224acebb1088p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbf38p+17,                0x1.8p+1,   0x1.9b4a0763e357cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1c98p+17,                0x1.8p+1,   0x1.5b1f0487bd4a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.516002f32p+35,                0x1.8p+0,   0x1.11dd1aacf8ba2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb128p+17,                0x1.8p+1,   0x1.7110b94b21beep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5e88p+17,                0x1.8p+1,   0x1.1e7e340036738p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e65579802p+35,                0x1.8p+0,     0x1.d9fcc77fbd9p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bea98p+17,                0x1.8p+1,   0x1.53efaad330446p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce2e8p+17,                0x1.8p+1,   0x1.789d8f0285d02p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6cc7bb872p+35,                0x1.8p+0,   0x1.33e6cdce53f76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9349c3c2p+35,                0x1.8p+0,   0x1.c6ecc63004628p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76b9b30a2p+35,                0x1.8p+0,   0x1.4094274b7c36cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa038p+17,                0x1.8p+1,   0x1.ee400b70a8eacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c03d8p+17,                0x1.8p+1,   0x1.578d556517282p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a77d8p+17,                0x1.8p+1,   0x1.21ba55e249242p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b592d51e2p+35,                0x1.8p+0,   0x1.948582949639cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a8cbb2f2p+35,                0x1.8p+0,   0x1.1d1c507ea2f26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a27ec4fa2p+35,                0x1.8p+0,   0x1.7a5b28d11b80cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d72f8p+17,                0x1.8p+1,    0x1.8f0ed55764f9p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b39d8p+17,                0x1.8p+1,   0x1.3b553797767a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8398p+17,                0x1.8p+1,   0x1.bbef477fa1276p+53,          0x1p-1, INEXACT)
T(RN,           0x1.caeb8p+17,                0x1.8p+1,   0x1.70b2b1c0b6a64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4bd8p+17,                0x1.8p+1,   0x1.def54786dd402p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e94125c02p+35,                0x1.8p+0,    0x1.de4374d6c5d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b67b5202p+35,                0x1.8p+0,    0x1.1e2ab678e914p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7948p+17,                0x1.8p+1,   0x1.900faa7f6351cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1068p+17,                0x1.8p+1,   0x1.595c4f8c73f4ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddaa8p+17,                0x1.8p+1,   0x1.9fc0356a523f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdbf8p+17,                0x1.8p+1,    0x1.51da7f196d94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dab98p+17,                0x1.8p+1,   0x1.981e1a81655f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd0f8p+17,                0x1.8p+1,    0x1.504aead1db13p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bad08p+17,                0x1.8p+1,    0x1.4b3a0e253e67p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db0e10b92p+35,                0x1.8p+0,   0x1.c998302146202p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e327c382p+35,                0x1.8p+0,    0x1.219fa83829c5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2cd8p+17,                0x1.8p+1,   0x1.84068647cb4b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8108p+17,                0x1.8p+1,    0x1.45180ff6f6e3p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4618p+17,                0x1.8p+1,   0x1.3cff9b5448e2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3678p+17,                0x1.8p+1,   0x1.196c24348f4b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.639cf1ee2p+35,                0x1.8p+0,   0x1.285e4190f1dbcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a1cbd5c12p+35,                0x1.8p+0,   0x1.79689a2f9478ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fddd8p+17,                0x1.8p+1,   0x1.f99f538abe862p+53,          0x1p-1, INEXACT)
T(RN,       0x1.abd5b61c2p+35,                0x1.8p+0,   0x1.87179cd720298p+53,          0x1p-1, INEXACT)
T(RN,       0x1.89d129ad2p+35,                0x1.8p+0,   0x1.59633badd8866p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3718p+17,                0x1.8p+1,   0x1.198046012aedep+53,          0x1p-1, INEXACT)
T(RN,            0x1.49b8p+13,                  0x1p+2,    0x1.603a89494ce5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c7453d7b2p+35,                0x1.8p+0,   0x1.ad4ee9eb564b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0668p+17,                0x1.8p+1,   0x1.a6ee7d3a85a6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.abce8p+17,                0x1.8p+1,   0x1.2aad76bdebce2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f77c8p+17,                0x1.8p+1,   0x1.e6e19f0c69dd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c5d58f22p+35,                0x1.8p+0,   0x1.1f5a6eb77e55cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b338p+17,                0x1.8p+1,   0x1.093af3d7b973cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd9c8p+17,                0x1.8p+1,   0x1.f8de0b9a1ba34p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c63d8p+17,                0x1.8p+1,   0x1.65889ac413482p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4658p+17,                0x1.8p+1,   0x1.3d0852fd80ebap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8249fd352p+35,                0x1.8p+0,   0x1.4f881de28ebf6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6a1818c2p+35,                0x1.8p+0,   0x1.da6bf2b7cfbf8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0298p+17,                0x1.8p+1,   0x1.d1f0e0e6eacc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e82f964e2p+35,                0x1.8p+0,   0x1.dcb28d9edfd7cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cda498b22p+35,                0x1.8p+0,   0x1.b65a75ad0d824p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a3b8p+17,                0x1.8p+1,   0x1.075c3133c0954p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d7265a652p+35,                0x1.8p+0,   0x1.c3f6b552464aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6268p+17,                0x1.8p+1,   0x1.1efc93c843daap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.988db1362p+35,                0x1.8p+0,   0x1.6cf4484613974p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.566410892p+35,                0x1.8p+0,   0x1.17fe64b0aea9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8101ee062p+35,                0x1.8p+0,   0x1.4ddd0aa5ef354p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d2bef8652p+35,                0x1.8p+0,   0x1.bda44b6067756p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e8e92f4b2p+35,                0x1.8p+0,   0x1.ddc27fc23c1aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95a994a32p+35,                0x1.8p+0,   0x1.6916581aba502p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be048p+17,                0x1.8p+1,   0x1.52777c87f5b6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4be2f43c2p+35,                0x1.8p+0,   0x1.0b354053d5628p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8862e63c2p+35,                0x1.8p+0,   0x1.5781d65e84228p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7052b432p+35,                0x1.8p+0,   0x1.f296eadb52e42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e804a0532p+35,                0x1.8p+0,   0x1.dc73a2415fa62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eb51929b2p+35,                0x1.8p+0,   0x1.e14b1ac00f2f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ea958f8b2p+35,                0x1.8p+0,   0x1.e036f1c0246d2p+53,          0x1p-1, INEXACT)
T(RN,          0x1.5de248p+21,                0x1.4p+1,   0x1.8b4eb43cc8116p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9088p+17,                0x1.8p+1,   0x1.93c556047f498p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ceca8p+17,                0x1.8p+1,   0x1.7a1b6b15c6c56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4528p+17,                0x1.8p+1,   0x1.3cdeec06101aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96688p+17,                0x1.8p+1,   0x1.001039aefa8b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7498p+17,                0x1.8p+1,   0x1.6802e4ffe1926p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c577a40c2p+35,                0x1.8p+0,   0x1.aac2a57482308p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.faa38p+17,                0x1.8p+1,   0x1.f015771ba528cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.faf48p+17,                0x1.8p+1,   0x1.f1038d2cce93cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c944e4762p+35,                0x1.8p+0,   0x1.b0236b70d30f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e24b8p+17,                0x1.8p+1,   0x1.abf47d8584a84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3f88p+17,                0x1.8p+1,   0x1.dcc0db2865568p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1d38p+17,                0x1.8p+1,   0x1.819865b1ab51cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eedf8p+17,                0x1.8p+1,    0x1.ce5197b7434ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3e78p+17,                0x1.8p+1,   0x1.dc903b1937638p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dca28p+17,                0x1.8p+1,   0x1.9d105ae6b5b1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5da8p+17,                0x1.8p+1,   0x1.e228e81779a06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd0f8p+17,                0x1.8p+1,    0x1.9e2bfeb06113p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb4b8p+17,                0x1.8p+1,   0x1.c45ce1d4f1584p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a33e8p+17,                0x1.8p+1,   0x1.1919a3a9e17b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c90a4ea32p+35,                0x1.8p+0,   0x1.afd061bf7d902p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8060b4302p+35,                0x1.8p+0,    0x1.4d0b6a07c5aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.df258p+17,                0x1.8p+1,   0x1.a3a0e699becfap+53,          0x1p-1, INEXACT)
T(RN,       0x1.abd5b61c2p+35,                0x1.8p+0,   0x1.87179cd720298p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc408p+17,                0x1.8p+1,    0x1.f4d68536a54cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5888p+17,                0x1.8p+1,   0x1.b4a221bb9ca18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6368p+17,                0x1.8p+1,   0x1.1f1d36a85235ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffbd02312p+35,                0x1.8p+0,   0x1.ff9b86933b492p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e038p+17,                0x1.8p+1,   0x1.0eb5bb895baacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ccf48p+17,                0x1.8p+1,   0x1.759ffdd0fbf3cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5de31ba02p+35,                0x1.8p+0,    0x1.213d352f055cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd3798bb2p+35,                0x1.8p+0,   0x1.ccb8e086ea332p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d34a8p+17,                0x1.8p+1,   0x1.853e90e61add6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ad2f856a2p+35,                0x1.8p+0,   0x1.88f2276ff53acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef628p+17,                0x1.8p+1,   0x1.cfc11e9fad95ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ec9c7dd2p+35,                0x1.8p+0,   0x1.75570f99a623ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7dd8p+17,                0x1.8p+1,   0x1.90c990b5bc662p+53,          0x1p-1, INEXACT)
T(RN,       0x1.552a53692p+35,                0x1.8p+0,   0x1.167de4a5f665ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e27d4462p+35,                0x1.8p+0,   0x1.747c7de65ecd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6457b8f62p+35,                0x1.8p+0,   0x1.2947ddd656c0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad3d8p+17,                0x1.8p+1,   0x1.2db0b78dae182p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2898p+17,                0x1.8p+1,   0x1.17ae2ce7300e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4558p+17,                0x1.8p+1,   0x1.b167eee21720ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e51bd8d02p+35,                0x1.8p+0,    0x1.d83291d41ff2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce0e8p+17,                0x1.8p+1,   0x1.784f5a50169a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca18ad6e2p+35,                0x1.8p+0,   0x1.b14fc62203f44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ccbf8p+17,                0x1.8p+1,    0x1.751f2c326064p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0ef8p+17,                0x1.8p+1,    0x1.7f63496a7ecdp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f54195052p+35,                0x1.8p+0,   0x1.eff817af7de96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9cea8p+17,                0x1.8p+1,   0x1.0c8ffb96243b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.985c8p+17,                0x1.8p+1,   0x1.03c5df0e69674p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b53f06e2p+35,                0x1.8p+0,   0x1.1e1249e017ebcp+53,          0x1p-1, INEXACT)
T(RN,            0x1.3668p+13,                  0x1p+2,   0x1.14ad2111d8348p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6328p+17,                0x1.8p+1,   0x1.8c8d5db390e4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4558p+17,                0x1.8p+1,   0x1.b167eee21720ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.525f16af2p+35,                0x1.8p+0,   0x1.1313ebcba1826p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f12d8p+17,                0x1.8p+1,   0x1.d4cede84e1ad2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52c0ab6d2p+35,                0x1.8p+0,   0x1.138af2605701ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.975d8p+17,                0x1.8p+1,   0x1.01e06a035a0e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3f28p+17,                0x1.8p+1,   0x1.6025808f5458ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc858p+17,                0x1.8p+1,   0x1.7492556d57c1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.795d05292p+35,                0x1.8p+0,   0x1.43f8491072a22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5c96db82p+35,                0x1.8p+0,    0x1.c200ff839255p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8778p+17,                0x1.8p+1,   0x1.e9bb34cc30fe8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.da1799792p+35,                0x1.8p+0,   0x1.c834420573482p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8c38p+17,                0x1.8p+1,   0x1.bd682377846ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bcc28p+17,                0x1.8p+1,   0x1.4f9c7d32f2c7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eea15de32p+35,                0x1.8p+0,   0x1.e62af19ea8f82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b65a9b202p+35,                0x1.8p+0,    0x1.959aa8b2b2d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae248p+17,                0x1.8p+1,   0x1.2f98d094021ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6678f752p+35,                0x1.8p+0,   0x1.95aca3ae1238ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afa18p+17,                0x1.8p+1,   0x1.32c2584320deep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5858p+17,                0x1.8p+1,   0x1.8ad8489c63f1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c70b6c82p+35,                0x1.8p+0,    0x1.0be085e49fbbp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c90ff9e02p+35,                0x1.8p+0,    0x1.afd86a7aa0b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2788p+17,                0x1.8p+1,   0x1.ac6c52d85b0e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c00530d2p+35,                0x1.8p+0,   0x1.71956f8030526p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ace88p+17,                0x1.8p+1,   0x1.2cfda12b69c38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9fc8p+17,                0x1.8p+1,   0x1.495f36d15cd54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9f48p+17,                0x1.8p+1,   0x1.26d0f8768c63cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8af9d0bb2p+35,                0x1.8p+0,   0x1.5ae9c7241eccep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74ff0f812p+35,                0x1.8p+0,   0x1.3e5cca7b0170ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3818p+17,                0x1.8p+1,   0x1.af2fc80cf7e8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f453fb62p+35,                0x1.8p+0,   0x1.370f58be9e78cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.669d49c02p+35,                0x1.8p+0,    0x1.2c20c951b858p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbf28p+17,                0x1.8p+1,   0x1.f3f0126d3ad8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0548p+17,                0x1.8p+1,   0x1.13477b807b35cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e15c01292p+35,                0x1.8p+0,   0x1.d2bbd64518ddep+53,          0x1p-1, INEXACT)
T(RN,       0x1.65d98e372p+35,                0x1.8p+0,   0x1.2b2b33983f616p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f2f098eb2p+35,                0x1.8p+0,   0x1.ec8903c89d592p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6bb314d52p+35,                0x1.8p+0,   0x1.3288cad4a16cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5c28p+17,                0x1.8p+1,   0x1.4003535001f7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f3f35d782p+35,                0x1.8p+0,    0x1.ee0860c1a33dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8078p+17,                0x1.8p+1,   0x1.69c6593325e98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.694cd6452p+35,                0x1.8p+0,   0x1.2f818687b9d16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab528p+17,                0x1.8p+1,   0x1.29aa0acb79eaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95bef1cd2p+35,                0x1.8p+0,   0x1.6932dec7736a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fae68p+17,                0x1.8p+1,   0x1.f0da6127a95eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc5c8p+17,                0x1.8p+1,   0x1.4eb5ca92d4274p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa228p+17,                0x1.8p+1,   0x1.ee9ae7881bf9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.652f165a2p+35,                0x1.8p+0,   0x1.2a5587851824cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac93ee482p+35,                0x1.8p+0,    0x1.881c8d051175p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9153e9ee2p+35,                0x1.8p+0,   0x1.6350b542e3244p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6c68p+17,                0x1.8p+1,   0x1.20435fe77228ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0a3e5252p+35,                0x1.8p+0,   0x1.8db324a558b2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b46a8p+17,                0x1.8p+1,   0x1.3d1338ca8f636p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d11e8p+17,                0x1.8p+1,   0x1.7fd79a1644652p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d311188a2p+35,                0x1.8p+0,   0x1.be19eed662c6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f0f9a3d92p+35,                0x1.8p+0,   0x1.e9a0ff2a581c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3f1c4092p+35,                0x1.8p+0,   0x1.7c52b6d6f699ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cace5c1e2p+35,                0x1.8p+0,   0x1.b251a71b03664p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf818p+17,                0x1.8p+1,   0x1.7bdca7115628ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9084d8b42p+35,                0x1.8p+0,   0x1.623ddb393a108p+53,          0x1p-1, INEXACT)
T(RN,       0x1.826786172p+35,                0x1.8p+0,   0x1.4fae99b9d6656p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9288p+17,                0x1.8p+1,   0x1.ebbf670b5d8f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a42f8p+17,                0x1.8p+1,    0x1.1aff7eb2a769p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba768p+17,                0x1.8p+1,   0x1.4a70412d76e1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c154805a2p+35,                0x1.8p+0,   0x1.a4eeeb7a8de4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb768p+17,                0x1.8p+1,   0x1.f282496de691ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.47a8p+13,                  0x1p+2,   0x1.577f6e7f0c698p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9d188p+17,                0x1.8p+1,   0x1.0ce9c713b5cc8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4ebc57062p+35,                0x1.8p+0,   0x1.0ea800945b954p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0ae9aea2p+35,                0x1.8p+0,   0x1.bab06b5ca5cacp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9978p+17,                0x1.8p+1,   0x1.487d9e1304748p+53,          0x1p-1, INEXACT)
T(RN,       0x1.61086d652p+35,                0x1.8p+0,   0x1.25260ab0aaeaap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0718p+17,                0x1.8p+1,   0x1.138105d9d1ddep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c7252e662p+35,                0x1.8p+0,   0x1.ad21921e79394p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7ea8p+17,                0x1.8p+1,   0x1.e82102a280cb6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daaf8p+17,                0x1.8p+1,    0x1.9804509a8fa1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f7a1d32e2p+35,                0x1.8p+0,   0x1.f37fe700c5dc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af6f3f012p+35,                0x1.8p+0,   0x1.8c09db42991f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fc54b05d2p+35,                0x1.8p+0,   0x1.fa818f8a0e6c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dfa78p+17,                0x1.8p+1,   0x1.a4f6d18375178p+53,          0x1p-1, INEXACT)
T(RN,       0x1.904c3fc42p+35,                0x1.8p+0,   0x1.61f2c79efeca8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9598p+17,                0x1.8p+1,   0x1.6ced19d4854d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2698p+17,                0x1.8p+1,   0x1.830d5c6461186p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6457b8f62p+35,                0x1.8p+0,   0x1.2947ddd656c0cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e9c60582p+35,                0x1.8p+0,    0x1.22230f0104d1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f1a28cd2p+35,                0x1.8p+0,   0x1.0f19d286b4b5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b644bdb2p+35,                0x1.8p+0,   0x1.70c3911bf128ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4de8p+17,                0x1.8p+1,   0x1.df53ff4ef0b92p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4b48p+13,                  0x1p+2,    0x1.66f3f4df41d9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f2c723cc2p+35,                0x1.8p+0,   0x1.ec4ba1bac5988p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9fba9222p+35,                0x1.8p+0,   0x1.9aa6ca6188f7cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7a4f79e2p+35,                0x1.8p+0,   0x1.dbe792a909364p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a732c2c62p+35,                0x1.8p+0,   0x1.80c081fcccbd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e4f2f7d72p+35,                0x1.8p+0,   0x1.d7f6e36ace2d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a930f1a2p+35,                0x1.8p+0,   0x1.311cf23aaa534p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b42a8p+17,                0x1.8p+1,   0x1.3c87ce317eb76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b6b54d782p+35,                0x1.8p+0,    0x1.961890bb1d3dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c499a5732p+35,                0x1.8p+0,   0x1.a9896a7dbbf5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.84dd7c622p+35,                0x1.8p+0,   0x1.52e4cf0f7aefcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.affc8p+17,                0x1.8p+1,   0x1.3384866f80f54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0d38p+17,                0x1.8p+1,   0x1.d3d074ada421cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.493660a92p+35,                0x1.8p+0,   0x1.07fc2bc9d5b22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4566efde2p+35,                0x1.8p+0,   0x1.036a4f575a8e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbaa14902p+35,                0x1.8p+0,    0x1.b389ca065476p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6e3cf0d2p+35,                0x1.8p+0,   0x1.dacceb7f43d26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1c98p+17,                0x1.8p+1,   0x1.37612654824a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.67572d192p+35,                0x1.8p+0,   0x1.2d0a430ec2b42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb648p+17,                0x1.8p+1,   0x1.c4a1f3dd3858cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf248p+17,                0x1.8p+1,   0x1.5508ccdc3c4ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8338p+17,                0x1.8p+1,   0x1.bbdee9b868e3cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd348p+17,                0x1.8p+1,   0x1.763bb3597abfcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0f08p+17,                0x1.8p+1,    0x1.358ec389218dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a3bfd492p+35,                0x1.8p+0,   0x1.0937151ef001ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f02a8p+17,                0x1.8p+1,   0x1.d1f3b220fff76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7ba8p+17,                0x1.8p+1,   0x1.9070684e0caa6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c4a30c6c2p+35,                0x1.8p+0,   0x1.a996ad2156eb8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8776ac092p+35,                0x1.8p+0,   0x1.564bd1961b99ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd9b8p+17,                0x1.8p+1,   0x1.5188a9fc06574p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9648p+17,                0x1.8p+1,   0x1.ec6eb4907cf8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcf08p+17,                0x1.8p+1,    0x1.f6df85bd9fcdp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a482b8012p+35,                0x1.8p+0,   0x1.7d17b2230f00ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fedd8p+17,                0x1.8p+1,   0x1.fc9a6e1bdb362p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bb805ccf2p+35,                0x1.8p+0,   0x1.9cc4fa00c2c1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1d38p+17,                0x1.8p+1,   0x1.5b362c0cd851cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd37f83a2p+35,                0x1.8p+0,   0x1.fbd5680189874p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2c88p+17,                0x1.8p+1,   0x1.39878a8a3c9d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d92726c92p+35,                0x1.8p+0,   0x1.c6d95dce44b1ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb748p+17,                0x1.8p+1,   0x1.4caa9b0d2c2bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.908bec1a2p+35,                0x1.8p+0,   0x1.62473e6b88734p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8558p+17,                0x1.8p+1,   0x1.45b11359c0e0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fbed2ec2p+35,                0x1.8p+0,   0x1.61374507977b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a07a41752p+35,                0x1.8p+0,   0x1.779f8b55d5f8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c42e7cdd2p+35,                0x1.8p+0,   0x1.a8f253125b7c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9958p+17,                0x1.8p+1,   0x1.4879277f383cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9958p+17,                0x1.8p+1,   0x1.952ed1f68e3cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6eb8p+17,                0x1.8p+1,   0x1.b8629c0e2fe64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eba5d4fc2p+35,                0x1.8p+0,   0x1.e1c6ef6ab52a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5adbbaa72p+35,                0x1.8p+0,   0x1.1d7dd32eff136p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4268p+17,                0x1.8p+1,   0x1.dd447eb97b7aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8e38a4f72p+35,                0x1.8p+0,   0x1.5f329e224e896p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a8287822p+35,                0x1.8p+0,   0x1.6f942b6abbfbcp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5728p+13,                  0x1p+2,   0x1.9d4131822cbf8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.679a357d2p+35,                0x1.8p+0,   0x1.2d5e8358310fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6888p+17,                0x1.8p+1,   0x1.41b6524c29d18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d92dd002p+35,                0x1.8p+0,     0x1.4968282dd2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e2373c332p+35,                0x1.8p+0,   0x1.d3fad540e89dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb1f8p+17,                0x1.8p+1,    0x1.713014b10c96p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3e68p+17,                0x1.8p+1,   0x1.dc8d5ef6738eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6329f8d92p+35,                0x1.8p+0,   0x1.27ce92db9c7c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4435167e2p+35,                0x1.8p+0,   0x1.01fce7a146aa4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.855946ca2p+35,                0x1.8p+0,   0x1.5386aef2e5214p+53,          0x1p-1, INEXACT)
T(RN,           0x1.affb8p+17,                0x1.8p+1,   0x1.338263b9a0e94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed498p+17,                0x1.8p+1,   0x1.c9e35bf84db26p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d6fc26082p+35,                0x1.8p+0,    0x1.c3b9fc190473p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6338p+17,                0x1.8p+1,   0x1.40fb64826583cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5120b4ed2p+35,                0x1.8p+0,   0x1.119009781351ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e12f8p+17,                0x1.8p+1,    0x1.a90238e77ed9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.69fd54432p+35,                0x1.8p+0,   0x1.3060059619fbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a6b726bc2p+35,                0x1.8p+0,   0x1.8017fc63e1528p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70bdabc12p+35,                0x1.8p+0,   0x1.38ee0a8fe538ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ecf143912p+35,                0x1.8p+0,   0x1.e3ae6c30e842ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1af8p+17,                0x1.8p+1,    0x1.813f068391f1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc138p+17,                0x1.8p+1,   0x1.f451891ff27dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cabf36da2p+35,                0x1.8p+0,   0x1.b23c25c991d4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8ef8p+17,                0x1.8p+1,    0x1.bde078b3a34dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0d701112p+35,                0x1.8p+0,   0x1.a43e9e70f972ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a47f8p+17,                0x1.8p+1,    0x1.1ba141c4b6d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.edbf67172p+35,                0x1.8p+0,   0x1.e4ddf20732456p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.82273f7f2p+35,                0x1.8p+0,   0x1.4f5adb400417ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed328p+17,                0x1.8p+1,   0x1.c9a3528cc8b4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59a82a282p+35,                0x1.8p+0,    0x1.1c026df95d81p+53,          0x1p-1, INEXACT)
T(RN,       0x1.42c908dc2p+35,                0x1.8p+0,   0x1.004ad6baa5a18p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe8c8p+17,                0x1.8p+1,   0x1.fba8a7e6ca204p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.81f169552p+35,                0x1.8p+0,   0x1.4f14bc02bd5cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3168p+17,                0x1.8p+1,   0x1.18c935cd5c2fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7fc8p+17,                0x1.8p+1,   0x1.69ac2be85d754p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.488474f02p+35,                0x1.8p+0,    0x1.072647ca7b66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83e0e9b62p+35,                0x1.8p+0,   0x1.519ad8336cb8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3038p+17,                0x1.8p+1,   0x1.da05540d889acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9228p+17,                0x1.8p+1,   0x1.ebade194ff49ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90d4768a2p+35,                0x1.8p+0,   0x1.62a780bf4006cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.baa28p+17,                0x1.8p+1,   0x1.4ad2df65e651ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2658p+17,                0x1.8p+1,   0x1.176607ccb88bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdbb8p+17,                0x1.8p+1,   0x1.7784b4184ebd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3ac8p+17,                0x1.8p+1,   0x1.afa2dcd236364p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7fec4bf2p+35,                0x1.8p+0,   0x1.dc6b0e39bc406p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1a0b4e62p+35,                0x1.8p+0,   0x1.bc0a8f5b2fd6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d80e8p+17,                0x1.8p+1,   0x1.9146791abf7a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5597be622p+35,                0x1.8p+0,   0x1.1703e93d61afcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b218p+17,                0x1.8p+1,   0x1.091820b39246ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c1188dca2p+35,                0x1.8p+0,   0x1.a49ab1414a7ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a82d8p+17,                0x1.8p+1,   0x1.23242653ff7d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a796ca6e2p+35,                0x1.8p+0,   0x1.8148f3f67c2bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.66e1ed742p+35,                0x1.8p+0,   0x1.2c76f85978378p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d3c8dc92p+35,                0x1.8p+0,   0x1.48f86acbeb6e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6fb41dc2p+35,                0x1.8p+0,   0x1.f2882e59b9be8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a6bd3652p+35,                0x1.8p+0,   0x1.1cf3b5ee4c2aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba508p+17,                0x1.8p+1,    0x1.4a1b2566e84fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fadc8p+17,                0x1.8p+1,   0x1.f0bcf9f61e5f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57ba38c32p+35,                0x1.8p+0,   0x1.19a281aaa66bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3508p+17,                0x1.8p+1,    0x1.5eab5a43a5ffp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c3946ab42p+35,                0x1.8p+0,   0x1.a81935c0c7508p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4644b5c42p+35,                0x1.8p+0,   0x1.0473aff86e8a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.82a615192p+35,                0x1.8p+0,   0x1.500022291db42p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8862e63c2p+35,                0x1.8p+0,   0x1.5781d65e84228p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8fd8p+17,                0x1.8p+1,   0x1.93a92ba4c92c2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c34f8p+17,                0x1.8p+1,    0x1.5ea905896b3fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff9b04fb2p+35,                0x1.8p+0,   0x1.ff688ef0e23b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e85e8p+17,                0x1.8p+1,   0x1.bc543d5aafa12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fde58p+17,                0x1.8p+1,   0x1.f9b720c9b073ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ee3d5a62p+35,                0x1.8p+0,   0x1.4b1ce2ef3dcecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f31a0fc32p+35,                0x1.8p+0,   0x1.ecc66af0798bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cfcfaac2p+35,                0x1.8p+0,   0x1.0c8a2118d9138p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be578p+17,                0x1.8p+1,   0x1.533494bd05d88p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7ddbfbf2p+35,                0x1.8p+0,   0x1.81a9c80728e06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9eb28p+17,                0x1.8p+1,   0x1.100d94729ebcep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c018148a2p+35,                0x1.8p+0,   0x1.a33297010ab94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.94779b192p+35,                0x1.8p+0,   0x1.677e1d6b610bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.fddd92192p+35,                0x1.8p+0,   0x1.fccd35fd55142p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc9713f32p+35,                0x1.8p+0,   0x1.b4dacbdf30da2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.82e9e0672p+35,                0x1.8p+0,   0x1.505884dbcda4ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0c08p+17,                0x1.8p+1,    0x1.141dee058424p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dfb97c852p+35,                0x1.8p+0,   0x1.d05ba6bec9596p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2588p+17,                0x1.8p+1,   0x1.ac17199023488p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9618p+17,                0x1.8p+1,   0x1.ec65efb31552ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6368p+17,                0x1.8p+1,   0x1.1f1d36a85235ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddc28p+17,                0x1.8p+1,   0x1.9ffee3673d77ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6e48p+17,                0x1.8p+1,   0x1.8e5064e4d500cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3008p+17,                0x1.8p+1,     0x1.8485c237b79p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6ce5b212p+35,                0x1.8p+0,   0x1.daad8a81687b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f6e51272p+35,                0x1.8p+0,   0x1.0f7ff95104436p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5888p+17,                0x1.8p+1,   0x1.e13cb600ffa18p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a33e85892p+35,                0x1.8p+0,   0x1.7b5f511779b62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a65c8p+17,                0x1.8p+1,   0x1.1f6ac366da074p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.470dff172p+35,                0x1.8p+0,   0x1.0564dafc60baap+53,          0x1p-1, INEXACT)
T(RN,       0x1.58ba0bd12p+35,                0x1.8p+0,   0x1.1add26c6c0752p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9da0ce92p+35,                0x1.8p+0,   0x1.84605359c515ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ffc98p+17,                0x1.8p+1,   0x1.ff5c9166c1ea6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a3e7d092p+35,                0x1.8p+0,   0x1.6f38cbedd5462p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ec620c2c2p+35,                0x1.8p+0,   0x1.e2dbb1a0587c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc398p+17,                0x1.8p+1,   0x1.4e66b9bf6ee76p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9088p+17,                0x1.8p+1,   0x1.eb61f96345498p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b711e3532p+35,                0x1.8p+0,   0x1.9699256885f9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b26e26302p+35,                0x1.8p+0,    0x1.902ba9f1aaeep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7bc8p+17,                0x1.8p+1,   0x1.9075803344294p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6ae8p+17,                0x1.8p+1,   0x1.8dc76cac56282p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea338p+17,                0x1.8p+1,   0x1.c1592ae67343cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.77a5f6a92p+35,                0x1.8p+0,   0x1.41c386f394f22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9f778p+17,                0x1.8p+1,   0x1.1192032a5a4e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fc907afc2p+35,                0x1.8p+0,   0x1.fadaefae50958p+53,          0x1p-1, INEXACT)
T(RN,       0x1.616c19732p+35,                0x1.8p+0,   0x1.25a2392bf575ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1ed02922p+35,                0x1.8p+0,   0x1.bc77b9f690ae4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ef992d2a2p+35,                0x1.8p+0,   0x1.e7987a372c9d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.458ecd6f2p+35,                0x1.8p+0,   0x1.0399fcd6f055ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e64d8p+17,                0x1.8p+1,   0x1.b6b673e624b32p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dada0e3e2p+35,                0x1.8p+0,   0x1.c94d0c84dcadcp+53,          0x1p-1, INEXACT)
T(RN,   0x1.a553f8878fa04p+50,                0x1.1p+0,   0x1.d9fe779881944p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aa0d20db2p+35,                0x1.8p+0,   0x1.84a635507b772p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d6f698f2p+35,                0x1.8p+0,   0x1.20adcac35ca66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e64c8p+17,                0x1.8p+1,   0x1.b6b3bf0fce544p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4358p+17,                0x1.8p+1,   0x1.dd6f70f3554aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f25f8p+17,                0x1.8p+1,    0x1.d83291d41ff2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a1f1c73d2p+35,                0x1.8p+0,   0x1.799c0519f897ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.76bed51c2p+35,                0x1.8p+0,   0x1.409abd9aae898p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e2adc4c2p+35,                0x1.8p+0,   0x1.4a2d0f164bc88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f84c8p+17,                0x1.8p+1,   0x1.e93e041aebb44p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e18c7d772p+35,                0x1.8p+0,   0x1.d3025ccc57796p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e68c0f162p+35,                0x1.8p+0,   0x1.da4c95ffe72b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.445025432p+35,                0x1.8p+0,   0x1.021d3443fe242p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e561f0c62p+35,                0x1.8p+0,   0x1.d898ed184c02cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5c28p+17,                0x1.8p+1,   0x1.1e30d1d6b6f7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.efd68p+17,                0x1.8p+1,   0x1.d10732a65f33ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.baae1ed22p+35,                0x1.8p+0,   0x1.9b9f9a2015a9cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba428p+17,                0x1.8p+1,   0x1.49fbce03170fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f776308d2p+35,                0x1.8p+0,   0x1.f33efdf48d7dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf688p+17,                0x1.8p+1,   0x1.55a47b9f903b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eee68p+17,                0x1.8p+1,   0x1.ce653657cd1eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8638p+17,                0x1.8p+1,   0x1.23936575b97ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a37303122p+35,                0x1.8p+0,   0x1.7ba692acc8fe4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f30c3d4a2p+35,                0x1.8p+0,   0x1.ecb1f2a765314p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee3e8p+17,                0x1.8p+1,   0x1.cc8ef069d00b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5cb8p+17,                0x1.8p+1,   0x1.8b88fc812cd04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa685e602p+35,                0x1.8p+0,    0x1.85231486619cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9d08p+17,                0x1.8p+1,    0x1.48fce286c237p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b0d1ee42p+35,                0x1.8p+0,   0x1.1dbad02610a18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5928p+17,                0x1.8p+1,   0x1.3f9a1a606af6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf138p+17,                0x1.8p+1,   0x1.7ace746e710dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b9a82422p+35,                0x1.8p+0,   0x1.0addc789a2bc4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6fa0bde52p+35,                0x1.8p+0,   0x1.37839c20f0a56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ebb582e02p+35,                0x1.8p+0,    0x1.e1ddfb8ec414p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9df8ee82p+35,                0x1.8p+0,    0x1.df2bced8a147p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.caf255a02p+35,                0x1.8p+0,    0x1.b284bd14e4e4p+53,          0x1p-1, INEXACT)
T(RN,               0x1.cdp+8,                0x1.8p+2,   0x1.10cea1565b39cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec078p+17,                0x1.8p+1,   0x1.c664f71b14a98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.83ba9e9b2p+35,                0x1.8p+0,   0x1.5168daad28af2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5ef41d5f2p+35,                0x1.8p+0,   0x1.228ffe304153ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c9d0cce52p+35,                0x1.8p+0,   0x1.b0e9cea4007aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f7ddf2f2p+35,                0x1.8p+0,   0x1.764a4e95ae726p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50f684362p+35,                0x1.8p+0,   0x1.115cb0b341b74p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b8954ece2p+35,                0x1.8p+0,   0x1.98b3c2f70e27cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e14f8p+17,                0x1.8p+1,    0x1.a957095fe8dfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5329af32p+35,                0x1.8p+0,   0x1.7e06e468a445ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c60b8p+17,                0x1.8p+1,   0x1.65129706689c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4e38p+17,                0x1.8p+1,   0x1.894021b99654cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b87427e2p+35,                0x1.8p+0,   0x1.325165e3032a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79f0bd7a2p+35,                0x1.8p+0,   0x1.44b69626c630cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f46bf30b2p+35,                0x1.8p+0,   0x1.eebb27c9d7dd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1478p+17,                0x1.8p+1,   0x1.803d24af76258p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6860190e2p+35,                0x1.8p+0,   0x1.2e57695d35f04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf738p+17,                0x1.8p+1,   0x1.55bdaf2a7f7fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8b5be2d2p+35,                0x1.8p+0,   0x1.c635df601569ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b95a8p+17,                0x1.8p+1,   0x1.47f58fa671086p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d52c62d12p+35,                0x1.8p+0,   0x1.c11f6d7706952p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed168d822p+35,                0x1.8p+0,   0x1.e3e54f20483bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2c08p+17,                0x1.8p+1,    0x1.d9467ed53384p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1dc8p+17,                0x1.8p+1,   0x1.81aebfa5ddaf4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96ca8p+17,                0x1.8p+1,   0x1.00c9a38a30456p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8cb8p+17,                0x1.8p+1,   0x1.46b72f4f20604p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ecea0102p+35,                0x1.8p+0,    0x1.5ff918b0933ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.43c8p+13,                  0x1p+2,    0x1.4788ccfb03dbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4eb8p+17,                0x1.8p+1,   0x1.3e2cb805a0864p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0cb8p+17,                0x1.8p+1,   0x1.d3b9dbd152e04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c27b8p+17,                0x1.8p+1,   0x1.5cbbc465a1e14p+53,          0x1p-1, INEXACT)
T(RN,       0x1.60ef84942p+35,                0x1.8p+0,   0x1.2507048b4a5c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8ea8p+17,                0x1.8p+1,   0x1.46fc228f0f7b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5797cfeb2p+35,                0x1.8p+0,   0x1.1978385ea2392p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b229fecf2p+35,                0x1.8p+0,   0x1.8fcd8273c0fe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e8337e372p+35,                0x1.8p+0,   0x1.dcb846337e9eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac0d8p+17,                0x1.8p+1,   0x1.2b317df688a72p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6568p+17,                0x1.8p+1,   0x1.b6cecfef682bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a6ffdab02p+35,                0x1.8p+0,    0x1.807b17d5ecc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6c8816a2p+35,                0x1.8p+0,   0x1.daa4fbedf8454p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f34f61f32p+35,                0x1.8p+0,   0x1.ed1564c7ae9a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1a38p+17,                0x1.8p+1,   0x1.d61cfaa2ea78cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbc18p+17,                0x1.8p+1,   0x1.4d58032a3ed4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd198p+17,                0x1.8p+1,   0x1.75f9fd7e68216p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa1a8p+17,                0x1.8p+1,   0x1.271fe6a0030c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.805ef8912p+35,                0x1.8p+0,   0x1.4d092978041d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5665b33b2p+35,                0x1.8p+0,   0x1.18006648017cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9f12a652p+35,                0x1.8p+0,   0x1.df45a49983b56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fb8b8p+17,                0x1.8p+1,   0x1.f2c02f6b4b244p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc9a8p+17,                0x1.8p+1,   0x1.4f41f8560ac46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd2b15d22p+35,                0x1.8p+0,   0x1.b5ad6ebcd4b64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bfe88p+17,                0x1.8p+1,   0x1.56ca08d4c7538p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ee68p+17,                0x1.8p+1,   0x1.1073f86b661eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d350243f2p+35,                0x1.8p+0,   0x1.be7444bcf1afap+53,          0x1p-1, INEXACT)
T(RN,            0x1.4a28p+13,                  0x1p+2,   0x1.621a131b179b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb1c010e2p+35,                0x1.8p+0,   0x1.f8ae7f7bd4f04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc0c8p+17,                0x1.8p+1,   0x1.9b8ada4fe7284p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62ccb6cd2p+35,                0x1.8p+0,   0x1.275a186320f5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e35a8cdc2p+35,                0x1.8p+0,   0x1.d5a327cb53de8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4028p+17,                0x1.8p+1,   0x1.604ae86646c3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbc88p+17,                0x1.8p+1,   0x1.72c85a8c774d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4659776a2p+35,                0x1.8p+0,   0x1.048c8afea5facp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.999b8p+17,                0x1.8p+1,   0x1.06288316c3974p+53,          0x1p-1, INEXACT)
T(RN,       0x1.679a357d2p+35,                0x1.8p+0,   0x1.2d5e8358310fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8408p+17,                0x1.8p+1,    0x1.bc026014e18cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.72aa86b62p+35,                0x1.8p+0,   0x1.3b623f6840d8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5df8p+17,                0x1.8p+1,    0x1.4042f0e5c09ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7c107e902p+35,                0x1.8p+0,    0x1.4774550f2c36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcbb8p+17,                0x1.8p+1,   0x1.4f8ca4c5bc8d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7548p+17,                0x1.8p+1,   0x1.216637bc4985cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2a28p+17,                0x1.8p+1,   0x1.5d165f14cbd1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.985baca02p+35,                0x1.8p+0,    0x1.6cb145216bbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb098p+17,                0x1.8p+1,   0x1.4bba073742666p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0af8p+17,                0x1.8p+1,    0x1.a7af67c578c1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac2f503c2p+35,                0x1.8p+0,   0x1.87927f8f8fe28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3de8p+17,                0x1.8p+1,   0x1.3be274b75b092p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2b98p+17,                0x1.8p+1,   0x1.180e71aff6df6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7a08p+17,                0x1.8p+1,    0x1.442017813feep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0358p+17,                0x1.8p+1,   0x1.577af0ad498aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8d567712p+35,                0x1.8p+0,   0x1.af856a65989eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e28c5412p+35,                0x1.8p+0,   0x1.5f1d9e90c1e8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ebebd5d2p+35,                0x1.8p+0,   0x1.5fe411365cf3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8135f75f2p+35,                0x1.8p+0,   0x1.4e20bc8f8b6c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5096d0b12p+35,                0x1.8p+0,   0x1.10e84405b906ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7068d3582p+35,                0x1.8p+0,    0x1.38820f6c840fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b91e8p+17,                0x1.8p+1,   0x1.476fe0e2dbe52p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee058p+17,                0x1.8p+1,   0x1.cbefaa6447c9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b331842d2p+35,                0x1.8p+0,   0x1.9139b904cd566p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6b501492p+35,                0x1.8p+0,   0x1.da8876c0a481ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6cf040a32p+35,                0x1.8p+0,   0x1.341a1cbe082fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.73cf72582p+35,                0x1.8p+0,    0x1.3cd862d50c6fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.bff2a9ac2p+35,                0x1.8p+0,   0x1.a2fe165fe9738p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc57b7e52p+35,                0x1.8p+0,   0x1.cb74d0d57de56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.86abe9e32p+35,                0x1.8p+0,   0x1.554203d822782p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5818p+13,                  0x1p+2,   0x1.a1ca0b50c1228p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ab1ce6d2p+35,                0x1.8p+0,   0x1.5a8aecc6e25e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6424018a2p+35,                0x1.8p+0,   0x1.29072899b526cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cae6f9352p+35,                0x1.8p+0,   0x1.b2749ac3023f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.78f7be1e2p+35,                0x1.8p+0,   0x1.4375e5ea15d9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3d08p+17,                0x1.8p+1,    0x1.1a3fb6fdd617p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f5fbaaa42p+35,                0x1.8p+0,   0x1.f10c600bf0768p+53,          0x1p-1, INEXACT)
T(RN,       0x1.da13c01e2p+35,                0x1.8p+0,   0x1.c82eb3c46ce64p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb4dc4ff2p+35,                0x1.8p+0,   0x1.f8f8cbbb0ec7ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.992cc1d72p+35,                0x1.8p+0,   0x1.6dc97fa23b12ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.deb58p+17,                0x1.8p+1,   0x1.a27ae7fb5382ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5423ad282p+35,                0x1.8p+0,    0x1.153c8923279fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0799d382p+35,                0x1.8p+0,    0x1.8d78d96855dbp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd408p+17,                0x1.8p+1,    0x1.f7ccceb0357cp+53,         -0x1p-1, INEXACT)
T(RN,     0x1.c3a7538d1c4p+42,                0x1.4p+0,   0x1.70123c76df25ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6648p+17,                0x1.8p+1,   0x1.1f7b18b49868cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3e38p+17,                0x1.8p+1,   0x1.3bed53c76f24cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e76b4dd2p+35,                0x1.8p+0,   0x1.360918142a7c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e74364cf2p+35,                0x1.8p+0,   0x1.db58c39fbc3e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97e08p+17,                0x1.8p+1,    0x1.02d98279edfap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a048p+17,                0x1.8p+1,   0x1.06f25241d2f6cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96818p+17,                0x1.8p+1,   0x1.003f7dd435f8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.883aa2312p+35,                0x1.8p+0,   0x1.574cf7c118b6ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6b18p+17,                0x1.8p+1,   0x1.20186d65e569ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b491fa842p+35,                0x1.8p+0,   0x1.9321891c27bd8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7aaf919e2p+35,                0x1.8p+0,   0x1.45aca345e309cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab438p+17,                0x1.8p+1,   0x1.298ab34a8f66cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e96c29a72p+35,                0x1.8p+0,   0x1.de8289025eccap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1598p+17,                0x1.8p+1,   0x1.5a1bf69ec7cd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7dcd93532p+35,                0x1.8p+0,   0x1.49b43248eff9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f652d0f62p+35,                0x1.8p+0,   0x1.f18dd629b5c0cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b0e4404d2p+35,                0x1.8p+0,   0x1.8e0be4db1aba6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbcd8p+17,                0x1.8p+1,   0x1.9ae78c25e97b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0348p+17,                0x1.8p+1,   0x1.7d956903544fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6762e7b72p+35,                0x1.8p+0,   0x1.2d19005fafceap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfa28p+17,                0x1.8p+1,   0x1.7c2dcf48e0c1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d885b4532p+35,                0x1.8p+0,   0x1.c5f0a4457a262p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba7b8p+17,                0x1.8p+1,   0x1.4a7b751428614p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfde8p+17,                0x1.8p+1,   0x1.7cc17bd56a492p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2898p+17,                0x1.8p+1,   0x1.5cdc48e3a60e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bae08p+17,                0x1.8p+1,    0x1.4b5df6e90c8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7cdbeebd2p+35,                0x1.8p+0,   0x1.487b62c7d327ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ed3fc5ed2p+35,                0x1.8p+0,   0x1.e421fdefe5ce6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.df62627e2p+35,                0x1.8p+0,   0x1.cfdd34d24f2a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b40f8p+17,                0x1.8p+1,    0x1.3c4d097ce563p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5380bd3e2p+35,                0x1.8p+0,   0x1.14756bf9e3f24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecb08p+17,                0x1.8p+1,    0x1.c839d05205c1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.89e636672p+35,                0x1.8p+0,   0x1.597eed203864ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.bacf8p+17,                0x1.8p+1,    0x1.4b37cfaf0fa7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b67f8p+17,                0x1.8p+1,    0x1.41a283fe7a38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c11c4cd52p+35,                0x1.8p+0,   0x1.a49ff490926cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adc78p+17,                0x1.8p+1,   0x1.2ed40fb34c7d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad99c0812p+35,                0x1.8p+0,   0x1.898414a2f76f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9590a8a82p+35,                0x1.8p+0,    0x1.68f512373811p+53,          0x1p-1, INEXACT)
T(RN,       0x1.46497fef2p+35,                0x1.8p+0,   0x1.04796c38675a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a62b44522p+35,                0x1.8p+0,   0x1.7f59645119c64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2958p+17,                0x1.8p+1,   0x1.acb998863e6cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5588p+17,                0x1.8p+1,   0x1.b420af3ed9d88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c19c8p+17,                0x1.8p+1,   0x1.5ab6df6dd4634p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b81867b2p+35,                0x1.8p+0,   0x1.46bba1ce896b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e94e8p+17,                0x1.8p+1,   0x1.bee491e6dd962p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eee98p+17,                0x1.8p+1,   0x1.ce6d9f113e306p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8fd8p+17,                0x1.8p+1,   0x1.be06c6e9142c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e31c5fcc2p+35,                0x1.8p+0,   0x1.d5488ca534188p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb048p+17,                0x1.8p+1,   0x1.70eef6639b26cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f31030432p+35,                0x1.8p+0,   0x1.ecb7cbd209842p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6f7501e2p+35,                0x1.8p+0,   0x1.dae9736aad19cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8be1d2cd2p+35,                0x1.8p+0,   0x1.5c1b9e0ff975ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d43e8p+17,                0x1.8p+1,   0x1.87a18d6ac42b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8864a6752p+35,                0x1.8p+0,   0x1.578422f42da76p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5d48p+17,                0x1.8p+1,   0x1.8b9fb85eb9bdcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.caa0ed122p+35,                0x1.8p+0,   0x1.b2112547e4c1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d3a43a792p+35,                0x1.8p+0,   0x1.beecca3cfdd7ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e4242b72p+35,                0x1.8p+0,   0x1.35c68c47bcd16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed2f8p+17,                0x1.8p+1,    0x1.c99af8b7d119p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff9d8p+17,                0x1.8p+1,   0x1.fed8b8d5baba2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa478p+17,                0x1.8p+1,   0x1.277d713038d58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5e78p+17,                0x1.8p+1,   0x1.b5a29fd118c38p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed218p+17,                0x1.8p+1,   0x1.c97401832ca6ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.93560ed92p+35,                0x1.8p+0,   0x1.65fc5b7d3bbc2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49e210952p+35,                0x1.8p+0,   0x1.08cac830ff4b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f97e53662p+35,                0x1.8p+0,   0x1.f645718188194p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b834daa02p+35,                0x1.8p+0,    0x1.982d942b0304p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bade7a392p+35,                0x1.8p+0,   0x1.9be30e55b5702p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f41cdf0f2p+35,                0x1.8p+0,   0x1.ee45e7c15809ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.91142db42p+35,                0x1.8p+0,   0x1.62fc14487bcf8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb349e332p+35,                0x1.8p+0,   0x1.b2e2e293505dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7d88p+17,                0x1.8p+1,   0x1.6956893c29508p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea4164832p+35,                0x1.8p+0,   0x1.dfbb61ac0c73ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8060b4302p+35,                0x1.8p+0,    0x1.4d0b6a07c5aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e61a8p+17,                0x1.8p+1,   0x1.b62c7b63744c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a28600942p+35,                0x1.8p+0,   0x1.7a64f7df6c238p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe6950e22p+35,                0x1.8p+0,   0x1.fd9e72863a1fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97358p+17,                0x1.8p+1,   0x1.01947a9f9b5aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c15d8p+17,                0x1.8p+1,   0x1.5a2534e50eee2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ababaa782p+35,                0x1.8p+0,    0x1.86ddf75f641dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb27f26b2p+35,                0x1.8p+0,   0x1.f8c053ad9c76ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c31e1d6c2p+35,                0x1.8p+0,   0x1.a772994da1748p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9d08p+17,                0x1.8p+1,    0x1.48fce286c237p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc2a8p+17,                0x1.8p+1,   0x1.4e44daebd4376p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9547b7f2p+35,                0x1.8p+0,   0x1.99bde2c144686p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.841524a12p+35,                0x1.8p+0,   0x1.51df0b53a234ep+53,          0x1p-1, INEXACT)
T(RN,            0x1.4bb8p+13,                  0x1p+2,    0x1.68da5711e71dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9af48p+17,                0x1.8p+1,   0x1.08c11e2f9c93cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4318p+17,                0x1.8p+1,   0x1.8780efe1fc31ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dda98b642p+35,                0x1.8p+0,   0x1.cd5dedf104518p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bed78p+17,                0x1.8p+1,   0x1.5458bc5564f08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c5bb69062p+35,                0x1.8p+0,   0x1.ab2253d6cc554p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.728d996b2p+35,                0x1.8p+0,   0x1.3b3d54dca996ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c05d51902p+35,                0x1.8p+0,    0x1.a393c3bac356p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8f08p+17,                0x1.8p+1,    0x1.6bf1fba4060dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a71a8682p+35,                0x1.8p+0,    0x1.455cc8c4db29p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fad856a72p+35,                0x1.8p+0,   0x1.f8497fa52b936p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9f48p+17,                0x1.8p+1,   0x1.ee14188d8b63cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b74b9112p+35,                0x1.8p+0,   0x1.3239f8442872ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa338p+17,                0x1.8p+1,   0x1.eeccbfcac643cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d1983f52p+35,                0x1.8p+0,   0x1.20435fe77228ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e84b8p+17,                0x1.8p+1,   0x1.bc20633f37c84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8f1be582p+35,                0x1.8p+0,    0x1.afad92660011p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d25ac192p+35,                0x1.8p+0,   0x1.5dc71c0e7fd42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd7c8p+17,                0x1.8p+1,   0x1.9f482434bafd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0f138c82p+35,                0x1.8p+0,    0x1.a46371275785p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8318p+17,                0x1.8p+1,   0x1.bbd975378df1ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.89b197a42p+35,                0x1.8p+0,   0x1.5939b448a9968p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df4c8p+17,                0x1.8p+1,   0x1.a4076667aa044p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5791423d2p+35,                0x1.8p+0,   0x1.19702ae36bc86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b522137d2p+35,                0x1.8p+0,   0x1.93e930c0734fap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd7f0c9b2p+35,                0x1.8p+0,   0x1.cd205dd33d90ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ae508p+17,                0x1.8p+1,    0x1.2ff604af160fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.973a8p+17,                0x1.8p+1,   0x1.019df7bb45526p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c0a8p+17,                0x1.8p+1,   0x1.0adbd62314616p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2228p+17,                0x1.8p+1,   0x1.ab8762886b79ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b77411f42p+35,                0x1.8p+0,   0x1.97218eb513188p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac4e688d2p+35,                0x1.8p+0,   0x1.87bd27d281826p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efe08p+17,                0x1.8p+1,    0x1.d1235601be7ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4d4793e2p+35,                0x1.8p+0,   0x1.937da6ea46724p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d19ce4612p+35,                0x1.8p+0,   0x1.bc051a7ec9ecep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fddf8p+17,                0x1.8p+1,    0x1.f9a546c88e1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c6c32132p+35,                0x1.8p+0,   0x1.1f6cce07e85e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa978p+17,                0x1.8p+1,   0x1.eff237f0aea48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd788p+17,                0x1.8p+1,   0x1.f8731488ce1e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ca73da52p+35,                0x1.8p+0,   0x1.72761f265422ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ffc8p+17,                0x1.8p+1,   0x1.1299118eedf54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daaf8p+17,                0x1.8p+1,    0x1.9804509a8fa1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ac4e688d2p+35,                0x1.8p+0,   0x1.87bd27d281826p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc8c8p+17,                0x1.8p+1,   0x1.f5b753639fc04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.599e4e1d2p+35,                0x1.8p+0,   0x1.1bf6473c40646p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f35b8p+17,                0x1.8p+1,   0x1.db0047600eab4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9078p+17,                0x1.8p+1,   0x1.473cabcc4d198p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9fedc702p+35,                0x1.8p+0,    0x1.df59bd45a76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f84880102p+35,                0x1.8p+0,    0x1.f477f1aa20c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63dfa11a2p+35,                0x1.8p+0,   0x1.28b1a22a0d934p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0308p+17,                0x1.8p+1,    0x1.33f3a1018069p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb648p+17,                0x1.8p+1,   0x1.c4a1f3dd3858cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3ac8p+17,                0x1.8p+1,   0x1.5f81f96490364p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb478f3e2p+35,                0x1.8p+0,   0x1.b2fdcb36a4b24p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf038p+17,                0x1.8p+1,   0x1.54bd50a2aadacp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9e957072p+35,                0x1.8p+0,   0x1.df3a2909ff78ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.498830212p+35,                0x1.8p+0,   0x1.085e98c2b724ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2808p+17,                0x1.8p+1,    0x1.d89064ecb578p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5f68p+17,                0x1.8p+1,   0x1.b5cb28afff49ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ebd6d5392p+35,                0x1.8p+0,   0x1.e20ef7cc24efep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d4e7790f2p+35,                0x1.8p+0,   0x1.c0bc7d5eecb66p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4108p+13,                  0x1p+2,    0x1.3c8c3eea75c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9048c302p+35,                0x1.8p+0,    0x1.ddea9c026b52p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.720148p+21,                0x1.4p+1,   0x1.c69d84811940ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a89eba2a2p+35,                0x1.8p+0,   0x1.82b146acbf42cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4dc1de112p+35,                0x1.8p+0,   0x1.0d78704bda12ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.46b7b3802p+35,                0x1.8p+0,     0x1.04fd6d35ecbp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a70d8p+17,                0x1.8p+1,   0x1.20d4b369fd372p+53,          0x1p-1, INEXACT)
T(RN,       0x1.626a830a2p+35,                0x1.8p+0,   0x1.26df8197c5c94p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ed9c0d7c2p+35,                0x1.8p+0,   0x1.e4a9e0b48f5a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff268p+17,                0x1.8p+1,   0x1.fd749508200aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbf5e4c42p+35,                0x1.8p+0,   0x1.b3f58ec56d158p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f0113c1c2p+35,                0x1.8p+0,   0x1.e849b2eb0e168p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bb3055ff2p+35,                0x1.8p+0,   0x1.9c55463e63186p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.44cac1972p+35,                0x1.8p+0,   0x1.02afa214b2f56p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e228p+17,                0x1.8p+1,   0x1.0ef28f5b4cb9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d941c362p+35,                0x1.8p+0,   0x1.34e9b5d9ad48cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dbda5bec2p+35,                0x1.8p+0,   0x1.cabf7d4cbde48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.996f8p+17,                0x1.8p+1,    0x1.05d4107fc265p+53,          0x1p-1, INEXACT)
T(RN,       0x1.689271472p+35,                0x1.8p+0,   0x1.2e96c6ae513f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe1177a42p+35,                0x1.8p+0,   0x1.fd1ae6b28a698p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd268p+17,                0x1.8p+1,   0x1.76199ff1ffaaap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a72c8p+17,                0x1.8p+1,   0x1.21143681c05e4p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.49e8p+13,                  0x1p+2,   0x1.6107d1b357ca8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5cf8p+17,                0x1.8p+1,    0x1.401fd6b47ab7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6012cdeb2p+35,                0x1.8p+0,   0x1.23f44fe82206ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f942b7112p+35,                0x1.8p+0,   0x1.f5ec9b8a29cd2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9682e2042p+35,                0x1.8p+0,   0x1.6a38a1fbac728p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe038p+17,                0x1.8p+1,   0x1.fa10691ccdaacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2508p+17,                0x1.8p+1,    0x1.82cf229a8ccfp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f4ab4f22p+35,                0x1.8p+0,   0x1.0f54be6424d5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2a98p+17,                0x1.8p+1,   0x1.d905082410046p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1198p+17,                0x1.8p+1,   0x1.35e6be3810e16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7d48p+17,                0x1.8p+1,   0x1.badbfd29031dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b08a286c2p+35,                0x1.8p+0,   0x1.8d8fa841cb948p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fee48p+17,                0x1.8p+1,   0x1.fcaf56977480cp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5a98p+13,                  0x1p+2,   0x1.ae105d861c608p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48eb04d02p+35,                0x1.8p+0,    0x1.07a18cb0cf72p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3128p+17,                0x1.8p+1,   0x1.ae0714b9323eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a008p+17,                0x1.8p+1,     0x1.06eaa03dccep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91d371922p+35,                0x1.8p+0,   0x1.63fa1f8f79f1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb698p+17,                0x1.8p+1,   0x1.71e2b4f1bf486p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6b18p+17,                0x1.8p+1,   0x1.669aca1f9b69ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.a99fb0b92p+35,                0x1.8p+0,   0x1.84107ff00ddfep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba3721b22p+35,                0x1.8p+0,   0x1.9af9af247cddcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8ba8p+17,                0x1.8p+1,   0x1.6b710313a85a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fee5271b2p+35,                0x1.8p+0,   0x1.fe57f5469140ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfc38p+17,                0x1.8p+1,   0x1.a5408e9a61becp+53,          0x1p-1, INEXACT)
T(RN,       0x1.67f310a22p+35,                0x1.8p+0,   0x1.2dce3d878bb84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d6f84fe92p+35,                0x1.8p+0,   0x1.c3b4772a538a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de48003f2p+35,                0x1.8p+0,   0x1.ce43947702d06p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0f28p+17,                0x1.8p+1,   0x1.7f6ab55a2548ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c7c8p+17,                0x1.8p+1,   0x1.0bb99292a5cd4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9adf8p+17,                0x1.8p+1,    0x1.089889ee538ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ca2f614c2p+35,                0x1.8p+0,   0x1.b16ffcaa87a88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d88b8p+17,                0x1.8p+1,   0x1.928593103b944p+53,          0x1p-1, INEXACT)
T(RN,       0x1.658950bf2p+35,                0x1.8p+0,   0x1.2ac699b11ac06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ef0f79772p+35,                0x1.8p+0,   0x1.e6cd50a1a806ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddc38p+17,                0x1.8p+1,   0x1.a001801f6f5ecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad898p+17,                0x1.8p+1,   0x1.2e5113b8189e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dcc78p+17,                0x1.8p+1,   0x1.9d709466fb4d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d2a9f7492p+35,                0x1.8p+0,   0x1.bd8636beaebe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.feb98p+17,                0x1.8p+1,   0x1.fc2ef01a9a1f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3d68p+17,                0x1.8p+1,   0x1.b0135837d2f3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aef98p+17,                0x1.8p+1,   0x1.315cb284790b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5c28p+17,                0x1.8p+1,   0x1.1e30d1d6b6f7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6db0d7a22p+35,                0x1.8p+0,   0x1.350e2188cfe7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7c28p+17,                0x1.8p+1,   0x1.69223ab3f657ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3978p+17,                0x1.8p+1,   0x1.5f50f45272548p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa6a8p+17,                0x1.8p+1,   0x1.ef6e19ee1b836p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7e16206e2p+35,                0x1.8p+0,   0x1.4a1230cd6a144p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad1d8p+17,                0x1.8p+1,   0x1.2d6d4368fc022p+53,          0x1p-1, INEXACT)
T(RN,       0x1.590a7a582p+35,                0x1.8p+0,    0x1.1b402bbcc96fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.98d98p+17,                0x1.8p+1,   0x1.04b4b51100756p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db508p+17,                0x1.8p+1,    0x1.99a407594a7fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.44d917de2p+35,                0x1.8p+0,   0x1.02c0c326ae71cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5dbd15dd2p+35,                0x1.8p+0,   0x1.210e10a3b59c6p+53,          0x1p-1, INEXACT)
T(RN,            0x1.67b8p+13,                  0x1p+2,    0x1.f3008c72ac2dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e33b8p+17,                0x1.8p+1,   0x1.ae749c6c05454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc4c8p+17,                0x1.8p+1,   0x1.9c30ec58da744p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2c28p+17,                0x1.8p+1,   0x1.d94c30654fe7ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5d4cb7df2p+35,                0x1.8p+0,   0x1.2082cdb052a3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0778p+17,                0x1.8p+1,   0x1.138cee82907e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f990362f2p+35,                0x1.8p+0,   0x1.f6601a23a86dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.edabc3602p+35,                0x1.8p+0,    0x1.e4c104637444p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac4f8p+17,                0x1.8p+1,    0x1.2bbbf860eaefp+53,          0x1p-1, INEXACT)
T(RN,       0x1.84f7a1e62p+35,                0x1.8p+0,   0x1.5306fdad0df6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fff18p+17,                0x1.8p+1,   0x1.ffd4813b5d05ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fad28p+17,                0x1.8p+1,   0x1.f09f93ed9092ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4b28p+17,                0x1.8p+1,   0x1.61e70d8448dcep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a7f6a042p+35,                0x1.8p+0,   0x1.456e866b49728p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a6b3fec2p+35,                0x1.8p+0,   0x1.6f74e75c649b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7a690f872p+35,                0x1.8p+0,   0x1.4551b290a9776p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e00acf262p+35,                0x1.8p+0,   0x1.d0d1bf65f4becp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9be900a62p+35,                0x1.8p+0,   0x1.71760e5d41514p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c5a6b3692p+35,                0x1.8p+0,   0x1.ab0515ed6265ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e6bcd4c2p+35,                0x1.8p+0,   0x1.5f764d1af7d78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7b8f4d072p+35,                0x1.8p+0,   0x1.46cd6c337e38ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.45a8p+13,                  0x1p+2,   0x1.4f2ffe3309018p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bdfddb9a2p+35,                0x1.8p+0,   0x1.a04034abfc234p+53,          0x1p-1, INEXACT)
T(RN,       0x1.65f953b32p+35,                0x1.8p+0,   0x1.2b530c154f522p+53,          0x1p-1, INEXACT)
T(RN,       0x1.49701f3b2p+35,                0x1.8p+0,   0x1.0841a3593bfcep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f76e41bb2p+35,                0x1.8p+0,   0x1.f333314736acep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c76d8p+17,                0x1.8p+1,   0x1.685851fc3af92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aeb48p+17,                0x1.8p+1,   0x1.30ca1f1f6987cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bea22e2e2p+35,                0x1.8p+0,   0x1.a12655ed3503cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a898p+17,                0x1.8p+1,   0x1.07f286d0128e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53f468ae2p+35,                0x1.8p+0,   0x1.1502c1175893cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.dcbd8p+17,                0x1.8p+1,   0x1.9d569139ecc02p+53,          0x1p-1, INEXACT)
T(RN,       0x1.79a8956f2p+35,                0x1.8p+0,   0x1.44599cc936aa6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee1a8p+17,                0x1.8p+1,   0x1.cc2a541fe9cc6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e7ee8p+17,                0x1.8p+1,   0x1.bb22d02dd2442p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5b58p+17,                0x1.8p+1,   0x1.e1be4b0db152ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5709547d2p+35,                0x1.8p+0,   0x1.18c935cd5c2fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f85d8p+17,                0x1.8p+1,   0x1.e96f7ff798be2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f95f8p+17,                0x1.8p+1,    0x1.ec60172e4942p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f5946132p+35,                0x1.8p+0,   0x1.0f666d3702de2p+53,          0x1p-1, INEXACT)
T(RN,            0x1.6148p+13,                  0x1p+2,    0x1.d03aad651271p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c166c5d2p+35,                0x1.8p+0,   0x1.1f02b22209ec6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.493ccaeb2p+35,                0x1.8p+0,   0x1.0803e3235866ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0dc8p+17,                0x1.8p+1,   0x1.a82670bd1f7f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e50097f92p+35,                0x1.8p+0,   0x1.d80ac7a98107ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0478p+17,                0x1.8p+1,   0x1.57a4543738f58p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cbc98p+17,                0x1.8p+1,   0x1.72cac5e4422a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b938a1a22p+35,                0x1.8p+0,   0x1.99971a0dbe584p+53,          0x1p-1, INEXACT)
T(RN,       0x1.42e7359f2p+35,                0x1.8p+0,   0x1.006ec7ca1ca46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.67f310a22p+35,                0x1.8p+0,   0x1.2dce3d878bb84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7620abd2p+35,                0x1.8p+0,   0x1.8100fe526ba7ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9df78p+17,                0x1.8p+1,   0x1.0e9e322e21068p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be5f8p+17,                0x1.8p+1,    0x1.5346d24eb632p+53,          0x1p-1, INEXACT)
T(RN,       0x1.705cf3442p+35,                0x1.8p+0,   0x1.3872f35e31858p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eaef8p+17,                0x1.8p+1,    0x1.c35ef0763badp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b4d18p+17,                0x1.8p+1,   0x1.3df3ee44033fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.600dd4382p+35,                0x1.8p+0,    0x1.23ee1f9eb53bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8248p+17,                0x1.8p+1,   0x1.e8c9a28755fccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.43566d702p+35,                0x1.8p+0,    0x1.00f34f6d65cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1468p+17,                0x1.8p+1,   0x1.15289b8643e0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.adcd0ddf2p+35,                0x1.8p+0,   0x1.89ca9411da9c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd088p+17,                0x1.8p+1,   0x1.f726ad651e098p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.42afa0e42p+35,                0x1.8p+0,   0x1.002c9512b29e8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbbc8p+17,                0x1.8p+1,   0x1.4d4cbebb82e94p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd038p+17,                0x1.8p+1,   0x1.75c4787c2b7acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e41531f2p+35,                0x1.8p+0,   0x1.4a4a2c35190bap+53,          0x1p-1, INEXACT)
T(RN,            0x1.6348p+13,                  0x1p+2,    0x1.dad4ca7bcf39p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6618p+17,                0x1.8p+1,   0x1.65dda3501742ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed078p+17,                0x1.8p+1,   0x1.c92ba9ffded98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53d713b12p+35,                0x1.8p+0,   0x1.14dee7dc4c66ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbf88p+17,                0x1.8p+1,   0x1.9b56fdd470d68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e60e8p+17,                0x1.8p+1,   0x1.b60c08e2df1a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aed08p+17,                0x1.8p+1,    0x1.31059458ec27p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd688p+17,                0x1.8p+1,   0x1.f8438f221fdb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba748p+17,                0x1.8p+1,   0x1.4a6bc61688fbcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c5e0d3b2p+35,                0x1.8p+0,   0x1.47d895a1edc32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6d18p+17,                0x1.8p+1,   0x1.2059e0a2539fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c3f0ae52p+35,                0x1.8p+0,   0x1.3339cd73c1456p+53,          0x1p-1, INEXACT)
T(RN,           0x1.96768p+17,                0x1.8p+1,   0x1.002ab10c7221ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8438p+17,                0x1.8p+1,   0x1.e923d2f0c2d6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c70a8p+17,                0x1.8p+1,   0x1.676d86c4d7f16p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbaa8p+17,                0x1.8p+1,   0x1.727fcb2751df6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9b9be1192p+35,                0x1.8p+0,   0x1.710e4fdff7cbep+53,          0x1p-1, INEXACT)
T(RN,       0x1.56b5dc162p+35,                0x1.8p+0,   0x1.1862bffc9af4cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6418p+17,                0x1.8p+1,   0x1.e35204d7418cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f1b2edae2p+35,                0x1.8p+0,   0x1.eab2ebaed64c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cec58p+17,                0x1.8p+1,   0x1.7a0f29e174cdap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6bb8p+17,                0x1.8p+1,   0x1.202ce0584e6d4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6b08p+17,                0x1.8p+1,    0x1.420e62d123a1p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b7a8p+17,                0x1.8p+1,   0x1.09c46edcefbe6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c428d9652p+35,                0x1.8p+0,   0x1.a8ea604dd96aap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3cb8p+17,                0x1.8p+1,   0x1.3bb9275a20704p+53,          0x1p-1, INEXACT)
T(RN,       0x1.da73feb12p+35,                0x1.8p+0,   0x1.c8b9a5a6a3392p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4971b9ee2p+35,                0x1.8p+0,   0x1.084391829edbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1bf8p+17,                0x1.8p+1,    0x1.aa803be03454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8a78p+17,                0x1.8p+1,   0x1.241fa45d0cc78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.474abfda2p+35,                0x1.8p+0,   0x1.05adb3dd87cb4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf378p+17,                0x1.8p+1,   0x1.7b26d3f877c28p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d35a8p+17,                0x1.8p+1,   0x1.85668def4ee86p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bf58p+17,                0x1.8p+1,   0x1.0ab30ae7121eap+53,          0x1p-1, INEXACT)
T(RN,            0x1.5c88p+13,                  0x1p+2,    0x1.b7c2e44cb0a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba13d1a12p+35,                0x1.8p+0,   0x1.9ac875f874d4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4108p+17,                0x1.8p+1,    0x1.1ac0e0750323p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.de158p+17,                0x1.8p+1,   0x1.a0d7d857de54ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.6012cdeb2p+35,                0x1.8p+0,   0x1.23f44fe82206ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b040a3b82p+35,                0x1.8p+0,    0x1.8d2a507dfe95p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb578p+17,                0x1.8p+1,   0x1.4c695b8bdb488p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b8c8p+17,                0x1.8p+1,   0x1.09e7511638904p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6278p+17,                0x1.8p+1,   0x1.6554aa65fd4f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.47df86fc2p+35,                0x1.8p+0,   0x1.066035a0cbea8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d161c6532p+35,                0x1.8p+0,   0x1.bbb08cddd799ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9bb0b702p+35,                0x1.8p+0,    0x1.8435e9acd10ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59110b9e2p+35,                0x1.8p+0,   0x1.1b48420f5b49cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc838p+17,                0x1.8p+1,   0x1.f59cb0ba67e2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cccc32b52p+35,                0x1.8p+0,   0x1.b5266103f1ef6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce918p+17,                0x1.8p+1,   0x1.798fc6a683b3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2858p+17,                0x1.8p+1,   0x1.17a6282adee1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4248p+17,                0x1.8p+1,   0x1.609a6dda603ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.64a7d41e2p+35,                0x1.8p+0,   0x1.29ac21c5f799cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5178p+17,                0x1.8p+1,   0x1.3e8ce1c7b49c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6fc8p+17,                0x1.8p+1,   0x1.20b1e3168e454p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9298p+17,                0x1.8p+1,   0x1.be7f38b4b8fc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ec408e52p+35,                0x1.8p+0,   0x1.5feb139c9b056p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd778p+17,                0x1.8p+1,   0x1.5136e21673ee8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c09a8p+17,                0x1.8p+1,   0x1.5863586fc5846p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4098p+17,                0x1.8p+1,   0x1.871ca05dbe966p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aaa98p+17,                0x1.8p+1,   0x1.28496bdbc6846p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1528p+17,                0x1.8p+1,   0x1.d53790da4a0aep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5f50ddb32p+35,                0x1.8p+0,   0x1.230335811c922p+53,          0x1p-1, INEXACT)
T(RN,       0x1.72a8d3132p+35,                0x1.8p+0,   0x1.3b601369bd81ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdae8p+17,                0x1.8p+1,   0x1.51b3d8d077f82p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.947245e92p+35,                0x1.8p+0,   0x1.6777015d26ca2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d709fa92p+35,                0x1.8p+0,   0x1.34bcbc4f22d22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5116f8382p+35,                0x1.8p+0,    0x1.11842f7d8845p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8688p+17,                0x1.8p+1,   0x1.bc6f8958e5eb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd6a8p+17,                0x1.8p+1,   0x1.51195d267f936p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b95dc4502p+35,                0x1.8p+0,    0x1.99cad0ddb3a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc688p+17,                0x1.8p+1,   0x1.f54cce66c1ab8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc851c192p+35,                0x1.8p+0,   0x1.9e31343a1e2bep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5858p+17,                0x1.8p+1,   0x1.8ad8489c63f1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8018p+17,                0x1.8p+1,   0x1.44f6d2cae680ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6998p+17,                0x1.8p+1,   0x1.b784441ae4296p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e08e881c2p+35,                0x1.8p+0,   0x1.d1911df1bd698p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7ce8p+17,                0x1.8p+1,   0x1.2260b4db350e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8778p+17,                0x1.8p+1,   0x1.bc987d6ecdfe8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a58610c82p+35,                0x1.8p+0,    0x1.7e78764b997bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5bf3cbd22p+35,                0x1.8p+0,   0x1.1ed7df811989cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.da92cd192p+35,                0x1.8p+0,   0x1.c8e621f82eb42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f5fa8p+17,                0x1.8p+1,   0x1.e285298ffcf66p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a28b73f2p+35,                0x1.8p+0,   0x1.091fdd94980fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9018p+17,                0x1.8p+1,   0x1.eb4d8afa7430ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf638p+17,                0x1.8p+1,   0x1.5599078374cccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d51e8p+17,                0x1.8p+1,   0x1.89d4a6f62b252p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.def7f8172p+35,                0x1.8p+0,   0x1.cf42c8c387daap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd510d002p+35,                0x1.8p+0,     0x1.b5e37c02db2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c6598a52p+35,                0x1.8p+0,   0x1.1f64a392883d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d87f8p+17,                0x1.8p+1,    0x1.9266e97f4098p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd358p+17,                0x1.8p+1,   0x1.f7ac29d5ed7aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a701ac112p+35,                0x1.8p+0,   0x1.807d925711d2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.dad634192p+35,                0x1.8p+0,   0x1.c9477bfc792bep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf7f8p+17,                0x1.8p+1,    0x1.55d92ea03be8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f83ef042p+35,                0x1.8p+0,   0x1.375eff0d566d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8c06c2222p+35,                0x1.8p+0,   0x1.5c4c569f1ea84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb488p+17,                0x1.8p+1,   0x1.4c479f26a9358p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f3598p+17,                0x1.8p+1,   0x1.dafa9251282d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b648p+17,                0x1.8p+1,   0x1.0999d049f958cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dacb8p+17,                0x1.8p+1,   0x1.984c88aaacc04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7e18p+17,                0x1.8p+1,   0x1.e806dba576caep+53,          0x1p-1, INEXACT)
T(RN,       0x1.aadf09c02p+35,                0x1.8p+0,    0x1.85c591deefa8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0298p+17,                0x1.8p+1,   0x1.a64d75f62fcc6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a22e8p+17,                0x1.8p+1,   0x1.16f7e713cb902p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea9f8p+17,                0x1.8p+1,    0x1.c2826be2a67ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1f28p+17,                0x1.8p+1,   0x1.ab07be68d8f8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c9dd81b2p+35,                0x1.8p+0,   0x1.482b12eff120ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2728p+17,                0x1.8p+1,   0x1.38cda302b450ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee448p+17,                0x1.8p+1,   0x1.cc9fb68da882cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4aafad552p+35,                0x1.8p+0,   0x1.09c27ed437236p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd928p+17,                0x1.8p+1,   0x1.9f818db98676ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c80e8p+17,                0x1.8p+1,   0x1.69d70250e47a2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8ff8p+17,                0x1.8p+1,     0x1.472add5df2bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d3236a42p+35,                0x1.8p+0,   0x1.0cca8928cc098p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1218p+17,                0x1.8p+1,   0x1.7fdf07861d66ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.79ddd6e52p+35,                0x1.8p+0,   0x1.449e3abe7ec56p+53,          0x1p-1, INEXACT)
T(RN,       0x1.65d636242p+35,                0x1.8p+0,   0x1.2b27021098d98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.be7eb1102p+35,                0x1.8p+0,    0x1.a0f49ed8cb26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f40e8p+17,                0x1.8p+1,   0x1.dcffcd51feba2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9febcd642p+35,                0x1.8p+0,   0x1.76dee3b7d6ee8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa038p+17,                0x1.8p+1,   0x1.26f01ee5c9eacp+53,          0x1p-1, INEXACT)
T(RN,            0x1.3918p+13,                  0x1p+2,   0x1.1e62207bdece8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dba58p+17,                0x1.8p+1,   0x1.9a7ff2fcbb67ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b7bc58412p+35,                0x1.8p+0,   0x1.978602fd18b72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7438p+17,                0x1.8p+1,   0x1.e63c558009a6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1f18p+17,                0x1.8p+1,   0x1.81e2ea3b8765ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7908p+17,                0x1.8p+1,    0x1.21e156a5e5cbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cea38p+17,                0x1.8p+1,   0x1.79bbdbe9b0e8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9c88p+17,                0x1.8p+1,   0x1.c0332b92b0ed8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4901766b2p+35,                0x1.8p+0,   0x1.07bc88e3dc092p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4c38p+17,                0x1.8p+1,   0x1.b28f7ed99faecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f56929cb2p+35,                0x1.8p+0,   0x1.f032d7b0a8352p+53,          0x1p-1, INEXACT)
T(RN,       0x1.de11e1e12p+35,                0x1.8p+0,   0x1.cdf5211780e32p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b88fbdf82p+35,                0x1.8p+0,    0x1.98ac0463b16dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2868p+17,                0x1.8p+1,   0x1.d8a1755e2c7cap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8c48p+17,                0x1.8p+1,   0x1.bd6adf5864facp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a57a8p+17,                0x1.8p+1,   0x1.1d9e5904929e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfd48p+17,                0x1.8p+1,   0x1.7ca8dc6bf69dcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c778p+17,                0x1.8p+1,   0x1.0bafd65537be8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.58352afb2p+35,                0x1.8p+0,   0x1.1a39aa0382fb2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd4d8p+17,                0x1.8p+1,   0x1.50d7899350832p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3608p+17,                0x1.8p+1,    0x1.85758d877d22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d49f8p+17,                0x1.8p+1,    0x1.889522fa725ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.70191b102p+35,                0x1.8p+0,    0x1.381ca588a2e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e8084342p+35,                0x1.8p+0,   0x1.0e5f753bb0c08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d17c8p+17,                0x1.8p+1,   0x1.80c081fcccbd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5c767a22p+35,                0x1.8p+0,   0x1.7ed1677735e7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3768p+17,                0x1.8p+1,   0x1.5f03f5901811ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4398p+17,                0x1.8p+1,   0x1.dd7ae52ddd676p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d0d1be92p+35,                0x1.8p+0,   0x1.0c9da46481f5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad348p+17,                0x1.8p+1,   0x1.2d9dbddf14bfcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f78b8p+17,                0x1.8p+1,   0x1.e70d246a3e644p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f81cd6372p+35,                0x1.8p+0,   0x1.f436f32216616p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cf6cd1fa2p+35,                0x1.8p+0,   0x1.b8e4e5d1b09f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbb58p+17,                0x1.8p+1,   0x1.f33c0ac4c172ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.91857fd42p+35,                0x1.8p+0,   0x1.63929118855b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e1c4becc2p+35,                0x1.8p+0,   0x1.d35434f32a478p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7ec8p+17,                0x1.8p+1,   0x1.90efcaa5c9424p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d446c0a52p+35,                0x1.8p+0,   0x1.bfd5daffdac2ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb188p+17,                0x1.8p+1,   0x1.711f32069a6c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b35b8p+17,                0x1.8p+1,   0x1.3ac5f94e42ab4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.deee8p+17,                0x1.8p+1,   0x1.a31076189f142p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce498p+17,                0x1.8p+1,   0x1.78df93e60b626p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b15f7fce2p+35,                0x1.8p+0,   0x1.8eb5eea6fd384p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab978p+17,                0x1.8p+1,   0x1.2a3a53429dd48p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d368fb7b2p+35,                0x1.8p+0,   0x1.be97de49e5f4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb6b8p+17,                0x1.8p+1,   0x1.c4b54c17c23e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.493b30592p+35,                0x1.8p+0,   0x1.0801f5495bf3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0db8p+17,                0x1.8p+1,   0x1.7f31d19f5eb34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3a88p+17,                0x1.8p+1,   0x1.dbdc24e2a7878p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6a08p+17,                0x1.8p+1,    0x1.b7973c3370bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bef9fdf32p+35,                0x1.8p+0,   0x1.a1a161ae15e5ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2278p+17,                0x1.8p+1,   0x1.5bf8d3dfb48f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe728p+17,                0x1.8p+1,   0x1.fb5b1ce1c890ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db548p+17,                0x1.8p+1,   0x1.99ae5efb0f45cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.faf037ed2p+35,                0x1.8p+0,   0x1.f86d23b22df1ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b4eff582p+35,                0x1.8p+0,    0x1.1e0c2ef17c71p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9c68p+17,                0x1.8p+1,   0x1.95aca3ae1238ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.72a71f712p+35,                0x1.8p+0,   0x1.3b5de76dc79eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.f3967ea12p+35,                0x1.8p+0,   0x1.ed7ebf064774ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.700eee5f2p+35,                0x1.8p+0,   0x1.380fb4d4788c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96688p+17,                0x1.8p+1,   0x1.001039aefa8b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8648p+17,                0x1.8p+1,   0x1.9221f1aa9fc8cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc0b8p+17,                0x1.8p+1,   0x1.736a89cc3bbc4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b8d9f6ac2p+35,                0x1.8p+0,   0x1.99134ec6bd6c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddeb8p+17,                0x1.8p+1,   0x1.a06a05defb364p+53,          0x1p-1, INEXACT)
T(RN,       0x1.75094d9c2p+35,                0x1.8p+0,   0x1.3e69e7a0a4598p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c0fd0a32p+35,                0x1.8p+0,   0x1.32fe0efbc9d02p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5390cd92p+35,                0x1.8p+0,   0x1.d85d360f35fc2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6598p+17,                0x1.8p+1,   0x1.414eed02033d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.af4c5dd22p+35,                0x1.8p+0,   0x1.8bd9d55121b64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b6998p+17,                0x1.8p+1,   0x1.41dbbdc173296p+53,          0x1p-1, INEXACT)
T(RN,           0x1.99cf8p+17,                0x1.8p+1,    0x1.068c67bb8577p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f12a8p+17,                0x1.8p+1,   0x1.d4c6620a2aa76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9f0364ad2p+35,                0x1.8p+0,   0x1.75a4dad5c319ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0178p+17,                0x1.8p+1,   0x1.d1be2cc289ac8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.acfb8p+17,                0x1.8p+1,   0x1.2d25a30713594p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae7a8p+17,                0x1.8p+1,   0x1.304f0e06dece6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc678p+17,                0x1.8p+1,   0x1.9c770958cbfb8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2414ce32p+35,                0x1.8p+0,   0x1.7a07cfaf6727ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca424cf32p+35,                0x1.8p+0,   0x1.b18ad5ff2205ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.981274942p+35,                0x1.8p+0,   0x1.6c4f33e7105c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c80b8p+17,                0x1.8p+1,   0x1.69cfde58aefc4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca5b8p+17,                0x1.8p+1,   0x1.6f580c9347fb4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c542f1e62p+35,                0x1.8p+0,   0x1.aa78442640094p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.561736432p+35,                0x1.8p+0,   0x1.17a024b761bbep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.810a9a012p+35,                0x1.8p+0,   0x1.4de85254ed40ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae2a873b2p+35,                0x1.8p+0,   0x1.8a4b11cfa1032p+53,          0x1p-1, INEXACT)
T(RN,       0x1.95196e7e2p+35,                0x1.8p+0,   0x1.6855f254bfaa4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6ad8p+17,                0x1.8p+1,   0x1.4207c76bb9752p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6768p+17,                0x1.8p+1,   0x1.8d3982f55e21ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdb18p+17,                0x1.8p+1,   0x1.776c4e9f5b39ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bbcf8p+17,                0x1.8p+1,    0x1.4d7790ed53d7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.56e6f4812p+35,                0x1.8p+0,   0x1.189f0244e310ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9958p+17,                0x1.8p+1,   0x1.952ed1f68e3cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b64f80b52p+35,                0x1.8p+0,   0x1.958b3fb535af6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9f18p+17,                0x1.8p+1,   0x1.49469fe8bee5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba7f8p+17,                0x1.8p+1,    0x1.4a846b94faf8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.81edf04a2p+35,                0x1.8p+0,   0x1.4f103633b6eecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5883e6032p+35,                0x1.8p+0,   0x1.1a9a8409b0bc2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7083f8d02p+35,                0x1.8p+0,    0x1.38a49a8613f2p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4808p+13,                  0x1p+2,     0x1.5912b05b352p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f43a85d22p+35,                0x1.8p+0,   0x1.ee71dd988549cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df7f8p+17,                0x1.8p+1,    0x1.a48d892c41e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.beece95a2p+35,                0x1.8p+0,   0x1.a18f0cb1d7bb4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af058p+17,                0x1.8p+1,   0x1.3176351e5279ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0dc15d02p+35,                0x1.8p+0,    0x1.e9755285f112p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6651fb4b2p+35,                0x1.8p+0,   0x1.2bc244c68a9aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.af858p+17,                0x1.8p+1,   0x1.3286a94945d1ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fdea2d52p+35,                0x1.8p+0,   0x1.61616fd54a536p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cff68p+17,                0x1.8p+1,   0x1.7cfc985aae29ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b69e8p+17,                0x1.8p+1,   0x1.41e6bfcba3ad2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adfe8p+17,                0x1.8p+1,   0x1.2f486176559f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca4f8p+17,                0x1.8p+1,    0x1.6f3b334ce88fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a125afbf2p+35,                0x1.8p+0,   0x1.78878f18151fap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1508p+17,                0x1.8p+1,    0x1.a959b012339fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5c95726d2p+35,                0x1.8p+0,   0x1.1f9fdae6ad21ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.45041c992p+35,                0x1.8p+0,   0x1.02f42ae60b442p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e41a8p+17,                0x1.8p+1,   0x1.b0c99ec1d6ec6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8ea8p+17,                0x1.8p+1,   0x1.bdd2cb04107b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aafc8p+17,                0x1.8p+1,   0x1.28f67739b3054p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6f354022p+35,                0x1.8p+0,   0x1.f27c648df82bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2f58p+17,                0x1.8p+1,   0x1.1886e6b874eeap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d6af6e942p+35,                0x1.8p+0,   0x1.c34ba1fdb9638p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.712c06e32p+35,                0x1.8p+0,   0x1.397a8fd023e7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1db8p+17,                0x1.8p+1,   0x1.1651ec81cce34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.de4e8p+17,                0x1.8p+1,   0x1.a16d0292e7062p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d084b0f92p+35,                0x1.8p+0,   0x1.ba74878e46d82p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1398p+17,                0x1.8p+1,   0x1.362b747a02576p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bef48p+17,                0x1.8p+1,   0x1.549b04948f53cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aebb66562p+35,                0x1.8p+0,   0x1.8b125205ec234p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.765f09982p+35,                0x1.8p+0,    0x1.401fd6b47ab7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b9a27bca2p+35,                0x1.8p+0,   0x1.9a2a88248dbecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3e58p+17,                0x1.8p+1,   0x1.b03b8905b293ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cdfa8p+17,                0x1.8p+1,   0x1.781e7ee071766p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9fd2913d2p+35,                0x1.8p+0,   0x1.76bcc668f6a86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b8bc45a42p+35,                0x1.8p+0,   0x1.98e9fbbbeba98p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d509ed4e2p+35,                0x1.8p+0,   0x1.c0edf399cfc84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddaf8p+17,                0x1.8p+1,    0x1.9fcd43cf6431p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aec48p+17,                0x1.8p+1,   0x1.30ec1804d41acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8ce8p+17,                0x1.8p+1,   0x1.bd8636beaebe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bbdf8p+17,                0x1.8p+1,    0x1.4d9ba317d1bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb158p+17,                0x1.8p+1,   0x1.c3c7c8a01944ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8698p+17,                0x1.8p+1,   0x1.6aafc761cc386p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff508p+17,                0x1.8p+1,    0x1.fdf23463c13fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a5eaa512p+35,                0x1.8p+0,   0x1.1ce3792f5a252p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdb98p+17,                0x1.8p+1,   0x1.51ccdaa97e6f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c26e8p+17,                0x1.8p+1,   0x1.5c9d945224fc2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1368p+17,                0x1.8p+1,   0x1.1508baee2fc5ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6368p+13,                  0x1p+2,   0x1.db7ff3d532b88p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.466b08182p+35,                0x1.8p+0,    0x1.04a19453c147p+53,          0x1p-1, INEXACT)
T(RN,       0x1.584f68532p+35,                0x1.8p+0,   0x1.1a59f03a68a62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8258p+17,                0x1.8p+1,   0x1.45469c9cf1ffap+53,          0x1p-1, INEXACT)
T(RN,       0x1.bd6e2c292p+35,                0x1.8p+0,   0x1.9f771d0e1ac22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a058p+17,                0x1.8p+1,   0x1.06f43ec8d609ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f24ec0fa2p+35,                0x1.8p+0,   0x1.eb99711191ff4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9fff8p+17,                0x1.8p+1,      0x1.129f02804ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce4613402p+35,                0x1.8p+0,    0x1.b740895c3338p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac90456b2p+35,                0x1.8p+0,   0x1.8817874ec3e92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb0f8p+17,                0x1.8p+1,    0x1.c3b739a03bb3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0498p+17,                0x1.8p+1,   0x1.342914d6bcc26p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af888p+17,                0x1.8p+1,   0x1.328d0df2ee818p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7dba94142p+35,                0x1.8p+0,   0x1.499b9725ab8c8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e83b4e152p+35,                0x1.8p+0,   0x1.dcc3b77fe37b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a4108f632p+35,                0x1.8p+0,   0x1.7c7c8cf49bd7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4fe8p+17,                0x1.8p+1,   0x1.898414a2f76f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0aa8p+17,                0x1.8p+1,   0x1.34f8b4aaf14f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dae789df2p+35,                0x1.8p+0,   0x1.c96086bd3b1c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d81f8p+17,                0x1.8p+1,    0x1.9171d5043706p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eabac2a02p+35,                0x1.8p+0,    0x1.e06d9178b3fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.559ca5042p+35,                0x1.8p+0,   0x1.1709ea7341528p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8168p+17,                0x1.8p+1,   0x1.22f4ccece69fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8428p+17,                0x1.8p+1,   0x1.6a52d60cf8afep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a67ed2c52p+35,                0x1.8p+0,   0x1.7fcb393d06e16p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8fb8p+17,                0x1.8p+1,   0x1.be014de3a2994p+53,          0x1p-1, INEXACT)
T(RN,       0x1.684bf6c02p+35,                0x1.8p+0,    0x1.2e3e1350a888p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cf6903c52p+35,                0x1.8p+0,   0x1.b8df7790f0016p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fab48p+17,                0x1.8p+1,   0x1.f04768c99bc7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e698p+17,                0x1.8p+1,   0x1.0f7e022cc1586p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ec508p+17,                0x1.8p+1,    0x1.c72f54d4a9afp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.36d8p+13,                  0x1p+2,   0x1.163d4af1ff678p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6a88p+17,                0x1.8p+1,   0x1.41fcc4a0c6178p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f55f8p+17,                0x1.8p+1,    0x1.e0c6b9e86882p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aed98p+17,                0x1.8p+1,   0x1.3118b28689956p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c90a8p+17,                0x1.8p+1,   0x1.6c301f617d516p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d33f8p+17,                0x1.8p+1,    0x1.85231486619cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dfda66472p+35,                0x1.8p+0,   0x1.d08b715c529f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d0ed8p+17,                0x1.8p+1,   0x1.7f5e56d859812p+53,          0x1p-1, INEXACT)
T(RN,          0x1.581f08p+21,                0x1.4p+1,   0x1.7b3b19ebc0b68p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f10c8p+17,                0x1.8p+1,   0x1.d4718ae0e4184p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.806b19ff2p+35,                0x1.8p+0,   0x1.4d18ed9ce567ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5558p+17,                0x1.8p+1,   0x1.b41898f0a1d0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7253c2382p+35,                0x1.8p+0,    0x1.3af3886a1c05p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.deea6db92p+35,                0x1.8p+0,   0x1.cf2f23def1802p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8ee8p+17,                0x1.8p+1,   0x1.eb161901f2f42p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d95e8p+17,                0x1.8p+1,   0x1.94a1b7331e512p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f62541ce2p+35,                0x1.8p+0,   0x1.f14a271277f84p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.adef8p+17,                0x1.8p+1,    0x1.2f28a54d743dp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd95bb172p+35,                0x1.8p+0,   0x1.fc61b0d447c56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bbc185742p+35,                0x1.8p+0,   0x1.9d1ff48221378p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db7a8p+17,                0x1.8p+1,   0x1.9a10a82a9bbe6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4dd8p+17,                0x1.8p+1,   0x1.1c5fa27d05562p+53,          0x1p-1, INEXACT)
T(RN,       0x1.99a1012d2p+35,                0x1.8p+0,   0x1.6e656c509809ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a3f8p+17,                0x1.8p+1,    0x1.0763e56ee6ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8fc96d6b2p+35,                0x1.8p+0,   0x1.614552ecb8e92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.92f6393c2p+35,                0x1.8p+0,   0x1.657ccc6c21428p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdb88p+17,                0x1.8p+1,   0x1.51ca949ffaaa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.47192fa62p+35,                0x1.8p+0,   0x1.0572454a15f14p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7a9c2682p+35,                0x1.8p+0,    0x1.f38bb4e38697p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b08f8p+17,                0x1.8p+1,    0x1.34bee07956bbp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a0d0db2d2p+35,                0x1.8p+0,   0x1.7814b9e5a6c9ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f475d5fb2p+35,                0x1.8p+0,   0x1.eec9d11889a4ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e11fe54b2p+35,                0x1.8p+0,   0x1.d2646c84795aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b99a8p+17,                0x1.8p+1,   0x1.488450041eb46p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99a98p+17,                0x1.8p+1,   0x1.064365897fd46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.967e8p+17,                0x1.8p+1,   0x1.0039d18125f72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bce58p+17,                0x1.8p+1,   0x1.4febbed095c3ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec40b51c2p+35,                0x1.8p+0,   0x1.e2aaa7853a898p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e93e8p+17,                0x1.8p+1,   0x1.beb8bc79f79b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1a334c92p+35,                0x1.8p+0,   0x1.a55d88f5338e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1518p+17,                0x1.8p+1,   0x1.5a097a909a57ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.97088p+17,                0x1.8p+1,   0x1.013f1f2286e98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6238p+17,                0x1.8p+1,   0x1.e2fb6ea41fd0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6c68p+17,                0x1.8p+1,   0x1.e4d25fa25928ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c12a8p+17,                0x1.8p+1,   0x1.59af673829a76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a16fb7092p+35,                0x1.8p+0,   0x1.78ebce8a0c062p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c66126f22p+35,                0x1.8p+0,   0x1.ac0c73329d95cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96c78p+17,                0x1.8p+1,   0x1.00c3f52d522d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4c507c462p+35,                0x1.8p+0,   0x1.0bb99292a5cd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57c26a5c2p+35,                0x1.8p+0,   0x1.19ac93be0a118p+53,          0x1p-1, INEXACT)
T(RN,       0x1.acc72c022p+35,                0x1.8p+0,   0x1.8862e17e2ed44p+53,          0x1p-1, INEXACT)
T(RN,       0x1.99ba0d0a2p+35,                0x1.8p+0,   0x1.6e87078cabf6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a135ef392p+35,                0x1.8p+0,   0x1.789d8f0285d02p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4388p+13,                  0x1p+2,    0x1.4686220f543ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0acb3262p+35,                0x1.8p+0,   0x1.baadb2582b3ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8fb30d72p+35,                0x1.8p+0,   0x1.afbaf59e80f2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.cace8p+17,                0x1.8p+1,   0x1.706cd0c2541e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cdd047a32p+35,                0x1.8p+0,   0x1.b698af4d254fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5fd07a272p+35,                0x1.8p+0,   0x1.23a1d345cf236p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ad8138a2p+35,                0x1.8p+0,   0x1.317414d8f1e6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6f7501e2p+35,                0x1.8p+0,   0x1.dae9736aad19cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b3cdbf62p+35,                0x1.8p+0,   0x1.708e8bb8e55f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb2c8p+17,                0x1.8p+1,   0x1.f1a85400141e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6fe8p+17,                0x1.8p+1,   0x1.e57471e830cf2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5404b4e32p+35,                0x1.8p+0,   0x1.1516ace3b5d82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e76fd742p+35,                0x1.8p+0,   0x1.74e74e5f3e378p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96ec8p+17,                0x1.8p+1,   0x1.010a0c2cc0124p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a5df01212p+35,                0x1.8p+0,   0x1.7ef1890db244ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4b88p+17,                0x1.8p+1,   0x1.61f52012b1fa8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad468p+17,                0x1.8p+1,   0x1.2dc3b2080020ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3e176f42p+35,                0x1.8p+0,   0x1.7c3c920528c78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4358p+17,                0x1.8p+1,   0x1.3c9fc19aa94aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d64411d82p+35,                0x1.8p+0,    0x1.c2b1420afd61p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6b7de1d2p+35,                0x1.8p+0,   0x1.f22401021d9bap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f99232f52p+35,                0x1.8p+0,   0x1.f663107d7748ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3b430b82p+35,                0x1.8p+0,    0x1.7bff13cf288bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb65a9092p+35,                0x1.8p+0,   0x1.f91c7809ec39ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce278p+17,                0x1.8p+1,   0x1.788c728e8ecf8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a59c8p+17,                0x1.8p+1,   0x1.1de37d9db3234p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e8db81222p+35,                0x1.8p+0,   0x1.ddae72799e084p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d43c8p+17,                0x1.8p+1,   0x1.879c88c164014p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.83592dc72p+35,                0x1.8p+0,   0x1.50e9b16df650ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6028p+17,                0x1.8p+1,   0x1.e29c3bc4b123ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2fa8p+17,                0x1.8p+1,   0x1.8476c8c842e66p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f720ec822p+35,                0x1.8p+0,   0x1.f2c02f6b4b244p+53,          0x1p-1, INEXACT)
T(RN,       0x1.97873b4d2p+35,                0x1.8p+0,   0x1.6b94d349471a6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3c98p+17,                0x1.8p+1,   0x1.3bb4ce9369aa6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dbf58p+17,                0x1.8p+1,   0x1.9b4f36bbbe1eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee8e8p+17,                0x1.8p+1,   0x1.cd6eb91b13722p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0298p+17,                0x1.8p+1,   0x1.a64d75f62fcc6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.97c943192p+35,                0x1.8p+0,   0x1.6bed3442e1f42p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c495de12p+35,                0x1.8p+0,   0x1.47bdd7bf2a9cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4ee8p+17,                0x1.8p+1,   0x1.df81f04d5c342p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1eb8p+17,                0x1.8p+1,   0x1.5b6dc24c81f64p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e391a022p+35,                0x1.8p+0,   0x1.21a7dd7aec6bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3628p+17,                0x1.8p+1,   0x1.5ed5511fff55ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ce68p+17,                0x1.8p+1,   0x1.0c882d9e96beap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c02b5ac2p+35,                0x1.8p+0,   0x1.4762849bf30c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b6308p+17,                0x1.8p+1,    0x1.40f4cce05989p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.560f09c32p+35,                0x1.8p+0,   0x1.17961f27f1b42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d67f7f182p+35,                0x1.8p+0,    0x1.c306b2cdd8a7p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5547b7062p+35,                0x1.8p+0,   0x1.16a1e1a9806acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1ab8p+17,                0x1.8p+1,   0x1.15f20db8372a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9fca8p+17,                0x1.8p+1,   0x1.1236191fc8756p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e87a8p+17,                0x1.8p+1,   0x1.bca0ae8d42ae6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aba78p+17,                0x1.8p+1,   0x1.2a5bcee443578p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fae28p+17,                0x1.8p+1,   0x1.f0ce9e23677dep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c71c8p+17,                0x1.8p+1,   0x1.67982fc232eb4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e7ffccb2p+35,                0x1.8p+0,   0x1.74f372fd68952p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1d78p+17,                0x1.8p+1,   0x1.aabffd4275808p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6f58p+17,                0x1.8p+1,   0x1.e55a636496aeap+53,          0x1p-1, INEXACT)
T(RN,       0x1.caae2d3a2p+35,                0x1.8p+0,   0x1.b223f5272ea74p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c20d8p+17,                0x1.8p+1,   0x1.5bbc8bf8c7c72p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5898p+17,                0x1.8p+1,   0x1.63e03a0f711e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4a1bde332p+35,                0x1.8p+0,   0x1.091063f917a22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e3835c9b2p+35,                0x1.8p+0,   0x1.d5dea3f26c6f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e2c4c462p+35,                0x1.8p+0,   0x1.5f2249105c32cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c89b8p+17,                0x1.8p+1,   0x1.6b2706e5a5674p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e62a8p+17,                0x1.8p+1,   0x1.b657c13795176p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8598p+17,                0x1.8p+1,   0x1.237ec968f79d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9a612e82p+35,                0x1.8p+0,    0x1.f680b0a382c7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5be4f5422p+35,                0x1.8p+0,   0x1.1ec5868a029c4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed348p+17,                0x1.8p+1,   0x1.c9a8e3d3e0bfcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.af297e0c2p+35,                0x1.8p+0,   0x1.8ba9d341a7f08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.71fb54a62p+35,                0x1.8p+0,   0x1.3a82c05de4d14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc648p+17,                0x1.8p+1,   0x1.f540f971e288cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdff8p+17,                0x1.8p+1,     0x1.fa0480fedfap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f31030432p+35,                0x1.8p+0,   0x1.ecb7cbd209842p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ca677642p+35,                0x1.8p+0,   0x1.483639b01b2e8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8607c2902p+35,                0x1.8p+0,    0x1.546b045eba4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.973e16502p+35,                0x1.8p+0,    0x1.6b32f515db1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2e08p+17,                0x1.8p+1,    0x1.ad819b1f540ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6f68p+17,                0x1.8p+1,   0x1.b880755ba2f9ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a1ee2a122p+35,                0x1.8p+0,   0x1.79971f4a0ea1cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7ed8p+17,                0x1.8p+1,   0x1.22a071f11d512p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a50f8p+17,                0x1.8p+1,    0x1.1cc508f2f693p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbab8p+17,                0x1.8p+1,   0x1.f31e8b8a660a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bd0d8p+17,                0x1.8p+1,   0x1.50466238bc572p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9ce8p+17,                0x1.8p+1,   0x1.95c130e1a16e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd66b5f72p+35,                0x1.8p+0,   0x1.9f6cac8f74696p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.54f95ade2p+35,                0x1.8p+0,   0x1.1641f0833251cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0f38p+17,                0x1.8p+1,   0x1.148358fd8147cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f4b912f22p+35,                0x1.8p+0,   0x1.ef2d8b44aa15cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d76d59a22p+35,                0x1.8p+0,   0x1.c45ce1d4f1584p+53,          0x1p-1, INEXACT)
T(RN,            0x1.5498p+13,                  0x1p+2,   0x1.910c64fef2588p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fce98p+17,                0x1.8p+1,   0x1.f6cac61b01d06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ebb28p+17,                0x1.8p+1,   0x1.c579a0fdabacep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ce6d8p+17,                0x1.8p+1,   0x1.7937a66a7fc92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6d98p+17,                0x1.8p+1,   0x1.8e347ba23d156p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5c78p+17,                0x1.8p+1,   0x1.b54c2edb06fd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d1fa5d9b2p+35,                0x1.8p+0,   0x1.bc8ad6754970ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.caba8p+17,                0x1.8p+1,   0x1.703ca4aaf5ba6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a52d29d02p+35,                0x1.8p+0,    0x1.7dff7d112992p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d18601972p+35,                0x1.8p+0,   0x1.bbe45e44b50aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0578p+17,                0x1.8p+1,   0x1.d27285180b388p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2208p+17,                0x1.8p+1,    0x1.5be8987225e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a1a982d92p+35,                0x1.8p+0,   0x1.793a18e7693c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e6a64f12p+35,                0x1.8p+0,   0x1.74d64ebff9ceep+53,          0x1p-1, INEXACT)
T(RN,       0x1.50f684362p+35,                0x1.8p+0,   0x1.115cb0b341b74p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3568p+17,                0x1.8p+1,   0x1.5eb956d88f1bap+53,         -0x1p-1, INEXACT)
T(RN,     0x1.aa3ad0b7c44p+42,                0x1.4p+0,   0x1.565b7de59b01ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eba18p+17,                0x1.8p+1,   0x1.c54a9986e61eep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8599d1502p+35,                0x1.8p+0,    0x1.53db1ecca93ep+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3608p+13,                  0x1p+2,    0x1.135779d30fd8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc4f8p+17,                0x1.8p+1,    0x1.740f551170efp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b8a8p+17,                0x1.8p+1,   0x1.09e370b063096p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cfd1b0282p+35,                0x1.8p+0,    0x1.b974dfc61cbfp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.832f6ee32p+35,                0x1.8p+0,   0x1.50b33bd2f9182p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c72168ef2p+35,                0x1.8p+0,   0x1.ad1c3cb4963a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7f28p+17,                0x1.8p+1,   0x1.44d597e2ec18ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e9a98p+17,                0x1.8p+1,   0x1.bfde164b26d46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae6708592p+35,                0x1.8p+0,   0x1.8a9e44e2310c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aecb8p+17,                0x1.8p+1,   0x1.30faf5b460804p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e1888p+17,                0x1.8p+1,   0x1.a9ee38a843e18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd5f8p+17,                0x1.8p+1,    0x1.76a46999a102p+53,          0x1p-1, INEXACT)
T(RN,       0x1.89b197a42p+35,                0x1.8p+0,   0x1.5939b448a9968p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc2d8p+17,                0x1.8p+1,   0x1.4e4ba0e74d3d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a5ccd9c42p+35,                0x1.8p+0,   0x1.7ed8d184c90a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.daf318902p+35,                0x1.8p+0,    0x1.c971391515f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b1776bc52p+35,                0x1.8p+0,   0x1.8ed6f25675016p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5f68p+17,                0x1.8p+1,   0x1.1e9ab9ff1349ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db68a0932p+35,                0x1.8p+0,   0x1.ca1b0ff8fd2e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9d728p+17,                0x1.8p+1,   0x1.0d99b0797de0ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd318p+17,                0x1.8p+1,   0x1.509803390161ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea728p+17,                0x1.8p+1,   0x1.c20680e59ad0ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f53e8p+17,                0x1.8p+1,   0x1.e067d14e4bdb2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.909689512p+35,                0x1.8p+0,   0x1.6255538698baep+53,          0x1p-1, INEXACT)
T(RN,       0x1.9e5866d42p+35,                0x1.8p+0,   0x1.74be070b02048p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1608p+17,                0x1.8p+1,    0x1.155c6db463c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df138p+17,                0x1.8p+1,   0x1.a3719d8c440dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d57ccf442p+35,                0x1.8p+0,   0x1.c192ed488c058p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.59f220f62p+35,                0x1.8p+0,   0x1.1c5d9b90983f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.735312152p+35,                0x1.8p+0,   0x1.3c397433f804ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab8b8p+17,                0x1.8p+1,   0x1.2a21382e4c244p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7d01e29e2p+35,                0x1.8p+0,   0x1.48ac7d93cc564p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9fc8p+17,                0x1.8p+1,   0x1.6e73d329efd54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a358b8f2p+35,                0x1.8p+0,   0x1.1cb0bf546f99ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2774b862p+35,                0x1.8p+0,   0x1.d4581920763acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.944964a42p+35,                0x1.8p+0,   0x1.674082b7eeb68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d06fbcb62p+35,                0x1.8p+0,   0x1.ba5697adbe98cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbf38p+17,                0x1.8p+1,   0x1.f3f306528957cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8c65c3c12p+35,                0x1.8p+0,   0x1.5cc9b3ca0038ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2ea8p+17,                0x1.8p+1,   0x1.39d11e17ef5b6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eba38p+17,                0x1.8p+1,   0x1.c55021c40358cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.97570f792p+35,                0x1.8p+0,   0x1.6b545e33e6882p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcaa8p+17,                0x1.8p+1,   0x1.9d2527cc478f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eeffbdeb2p+35,                0x1.8p+0,   0x1.e6b61c465bf92p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e339846c2p+35,                0x1.8p+0,   0x1.d57303eb79eb8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4e0dc7482p+35,                0x1.8p+0,    0x1.0dd464a32bebp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e0f53f262p+35,                0x1.8p+0,   0x1.d2266a27a5414p+53,         -0x1p-1, INEXACT)
T(RN,        0x1.94e0c8c4p+30,                0x1.cp+0,   0x1.93c25cb739082p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfcb8p+17,                0x1.8p+1,   0x1.7c92b44239b04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7fa072182p+35,                0x1.8p+0,    0x1.4c11a9aaae79p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d7dac3ca2p+35,                0x1.8p+0,   0x1.c4fa671f80becp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48bfbe2a2p+35,                0x1.8p+0,   0x1.076d86eeecc2cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be698p+17,                0x1.8p+1,   0x1.535da03037586p+53,          0x1p-1, INEXACT)
T(RN,           0x1.99fc8p+17,                0x1.8p+1,   0x1.06e2ee6036d54p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd738p+17,                0x1.8p+1,   0x1.9f30a91bfb1fcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.49dba4b72p+35,                0x1.8p+0,   0x1.08c30cf7df6eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce36df5c2p+35,                0x1.8p+0,   0x1.b72ade6e83ce8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7308p+17,                0x1.8p+1,    0x1.211c6921dab9p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fec48p+17,                0x1.8p+1,   0x1.fc4fc6c6931acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5588p+17,                0x1.8p+1,   0x1.b420af3ed9d88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96f28p+17,                0x1.8p+1,   0x1.01156b0d2d68ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5508p+17,                0x1.8p+1,    0x1.b40b1ea7245fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2918p+17,                0x1.8p+1,   0x1.5ceedea63f73ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8524f6132p+35,                0x1.8p+0,   0x1.534242da98de2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8228p+17,                0x1.8p+1,   0x1.6a069f2e4199ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7da8p+17,                0x1.8p+1,   0x1.90c1ebd061006p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b3b8p+17,                0x1.8p+1,   0x1.094a6f1b3fc54p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bf98e2c42p+35,                0x1.8p+0,   0x1.a28026c05faa8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f678754d2p+35,                0x1.8p+0,   0x1.f1c5c47a5ba5ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a1190cd12p+35,                0x1.8p+0,   0x1.7876734eb7552p+53,         -0x1p-1, INEXACT)
T(RN,          0x1.272b48p+21,                0x1.4p+1,   0x1.0267deca2e322p+53,          0x1p-1, INEXACT)
T(RN,       0x1.802e74c32p+35,                0x1.8p+0,   0x1.4cca1dde16ebep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a260085e2p+35,                0x1.8p+0,   0x1.7a317ab863c1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.649c24ee2p+35,                0x1.8p+0,   0x1.299d81211c444p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4248p+17,                0x1.8p+1,   0x1.1ae9457d7a3ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb9f67c92p+35,                0x1.8p+0,   0x1.f972b4b80e2e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b0638ec62p+35,                0x1.8p+0,   0x1.8d5a71a1cac2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.579cba382p+35,                0x1.8p+0,    0x1.197e4294d905p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aec492712p+35,                0x1.8p+0,   0x1.8b1ef0a5d0feep+53,          0x1p-1, INEXACT)
T(RN,            0x1.4038p+13,                  0x1p+2,    0x1.395af972b34bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cf746e702p+35,                0x1.8p+0,    0x1.b8efc27571d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac288p+17,                0x1.8p+1,   0x1.2b6a1f3ef91f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eca8aa262p+35,                0x1.8p+0,   0x1.e34395c17c614p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9698p+17,                0x1.8p+1,   0x1.94bded2142e86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d577106f2p+35,                0x1.8p+0,   0x1.c18aaca3d4b5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6848p+17,                0x1.8p+1,   0x1.e4138ab667cecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6439b1192p+35,                0x1.8p+0,   0x1.29224a2b41cbep+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb1286e82p+35,                0x1.8p+0,    0x1.b2b275d2de47p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e676c482p+35,                0x1.8p+0,    0x1.21e156a5e5cbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7cf8p+17,                0x1.8p+1,    0x1.2262c3118017p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c0058p+17,                0x1.8p+1,   0x1.570ca227b429ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c20a500f2p+35,                0x1.8p+0,   0x1.a5ee80aa8a29ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dda78p+17,                0x1.8p+1,   0x1.9fb8601c10b78p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb7b8p+17,                0x1.8p+1,   0x1.c4e1858ad0914p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa2a8p+17,                0x1.8p+1,   0x1.274126b213d76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdc68p+17,                0x1.8p+1,   0x1.f95ae99ec6f8ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f10b5fe42p+35,                0x1.8p+0,   0x1.e9bb34cc30fe8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.586e92782p+35,                0x1.8p+0,    0x1.1a8046cd9b1dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa8f8p+17,                0x1.8p+1,    0x1.281344c9dd9bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e43b8p+17,                0x1.8p+1,   0x1.b1222646c4754p+53,          0x1p-1, INEXACT)
T(RN,       0x1.844cded12p+35,                0x1.8p+0,   0x1.5227d483e4eaep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3dc8p+17,                0x1.8p+1,   0x1.1a57ebc4870f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6748p+17,                0x1.8p+1,   0x1.1f9bc52b493bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d15e8p+17,                0x1.8p+1,   0x1.807622dbd0d12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9e228p+17,                0x1.8p+1,   0x1.0ef28f5b4cb9ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a9805402p+35,                0x1.8p+0,    0x1.6fb10959adf8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.973c4db02p+35,                0x1.8p+0,    0x1.6b30923a101ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.606ab9bc2p+35,                0x1.8p+0,   0x1.2461b365a98d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4eac2b5b2p+35,                0x1.8p+0,   0x1.0e9464048a38ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ce8e4d252p+35,                0x1.8p+0,   0x1.b7a77f00d3b2ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9d440022p+35,                0x1.8p+0,   0x1.c7d30f167b544p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4eb77d152p+35,                0x1.8p+0,   0x1.0ea21e4fbe5b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.947cf0522p+35,                0x1.8p+0,   0x1.678539919ab9cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63d09f8b2p+35,                0x1.8p+0,   0x1.289ede445992ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.50034ff52p+35,                0x1.8p+0,   0x1.1034f2eff4a8ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3f38p+17,                0x1.8p+1,   0x1.86e57bf039d7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.99aa8p+17,                0x1.8p+1,   0x1.06455135fb7f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f23f8p+17,                0x1.8p+1,    0x1.d7d7a272776cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2c98p+17,                0x1.8p+1,   0x1.182e8d859afa6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f6cdab112p+35,                0x1.8p+0,   0x1.f244688fc8b2ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.df2f8p+17,                0x1.8p+1,    0x1.a3bb2d2a4679p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8b183292p+35,                0x1.8p+0,   0x1.af5290a30ce22p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2d38p+17,                0x1.8p+1,   0x1.d97c97863e81cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e948p+17,                0x1.8p+1,   0x1.0fd28dd4f5a1cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.df73cd772p+35,                0x1.8p+0,   0x1.cff67cf81286ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.790730362p+35,                0x1.8p+0,   0x1.4389c762de374p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.53e8p+13,                  0x1p+2,   0x1.8dd1f14b7c928p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5efbf4a2p+35,                0x1.8p+0,   0x1.c2380f5d318ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aad28p+17,                0x1.8p+1,   0x1.289ede445992ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3dfa74c2p+35,                0x1.8p+0,   0x1.7c3a1c3452178p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c50266e2p+35,                0x1.8p+0,   0x1.1f4a1aa682544p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dadde8672p+35,                0x1.8p+0,   0x1.c9529d18cea4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.8c2d75912p+35,                0x1.8p+0,   0x1.5c7f65fcb082ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b7d296772p+35,                0x1.8p+0,   0x1.97a4ef037c596p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.940cfa072p+35,                0x1.8p+0,   0x1.66effe1d93d8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc51ee5d2p+35,                0x1.8p+0,   0x1.cb6c7157c7d3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe678p+17,                0x1.8p+1,   0x1.fb3a50c0565b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7126eea02p+35,                0x1.8p+0,    0x1.397412957b84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.556d465f2p+35,                0x1.8p+0,   0x1.16cfe25b8d8c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.daf08p+17,                0x1.8p+1,    0x1.98ac0463b16dp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aed18p+17,                0x1.8p+1,   0x1.3107b41b011fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.8248407c2p+35,                0x1.8p+0,   0x1.4f85da74e07a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc72ba2c2p+35,                0x1.8p+0,   0x1.cb9be5232a438p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c1c8b1b32p+35,                0x1.8p+0,   0x1.a5923c47b0edep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c3488p+17,                0x1.8p+1,   0x1.5e98b4bbdab58p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2a98p+17,                0x1.8p+1,   0x1.17ee584e69046p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7d0fb0222p+35,                0x1.8p+0,   0x1.48be59fd3c97cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ebb98p+17,                0x1.8p+1,   0x1.c58cff5cd00f6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ae75b3ed2p+35,                0x1.8p+0,   0x1.8ab2720e9a71ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc1c8p+17,                0x1.8p+1,   0x1.7393b80cb8db4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aa07a7b72p+35,                0x1.8p+0,   0x1.849eb821b8316p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1758p+17,                0x1.8p+1,   0x1.80af26aaa1e6ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d2bc28a2p+35,                0x1.8p+0,   0x1.0cc2ba0ee086cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc638p+17,                0x1.8p+1,   0x1.743fd65be43ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d15fde312p+35,                0x1.8p+0,   0x1.bbadd2cc9c36ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.645e658c2p+35,                0x1.8p+0,   0x1.295037f8b23f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1c2e2232p+35,                0x1.8p+0,   0x1.8f3f1d972effep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1b58p+17,                0x1.8p+1,   0x1.814deac05092ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9678p+17,                0x1.8p+1,   0x1.ec7779888b6b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f1b2edae2p+35,                0x1.8p+0,   0x1.eab2ebaed64c4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d1f68cb82p+35,                0x1.8p+0,    0x1.bc85608be9f5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ead04ca22p+35,                0x1.8p+0,   0x1.e08d3333f1384p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa608p+17,                0x1.8p+1,    0x1.27b1715f0d72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d7a98p+17,                0x1.8p+1,   0x1.90451ef014746p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f39a8p+17,                0x1.8p+1,   0x1.dbb4261d32946p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc161f252p+35,                0x1.8p+0,   0x1.b423615e9c8d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0d88p+17,                0x1.8p+1,   0x1.d3de9495f3008p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e55b8p+17,                0x1.8p+1,   0x1.b428c5a6aa0b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6737581a2p+35,                0x1.8p+0,   0x1.2ce2439fdbf34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.71e53ae82p+35,                0x1.8p+0,    0x1.3a6692906e39p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9525e28e2p+35,                0x1.8p+0,   0x1.6866902128ffcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a00f8p+17,                0x1.8p+1,    0x1.12beb3a4d1a3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5cf8p+17,                0x1.8p+1,    0x1.401fd6b47ab7p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c41d8p+17,                0x1.8p+1,   0x1.608a0da27fd22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.979027492p+35,                0x1.8p+0,   0x1.6ba0c3e0f8be2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.61e21d9d2p+35,                0x1.8p+0,   0x1.263559303ad46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7068p+17,                0x1.8p+1,   0x1.42cbeff13714ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b30e7c2d2p+35,                0x1.8p+0,   0x1.910947f4cba9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5b88p+17,                0x1.8p+1,   0x1.644ee8e3cc2a8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5079a0f82p+35,                0x1.8p+0,    0x1.10c4c5a7bd73p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b88de3082p+35,                0x1.8p+0,    0x1.98a96f8d78adp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdbd8p+17,                0x1.8p+1,   0x1.f9402606d7702p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f23d8p+17,                0x1.8p+1,   0x1.d7d1f3dfa1882p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ea338p+17,                0x1.8p+1,   0x1.c1592ae67343cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.99138p+17,                0x1.8p+1,   0x1.0523b89c48edcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.70c2c34a2p+35,                0x1.8p+0,   0x1.38f485f0df0ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9da41b22p+35,                0x1.8p+0,   0x1.b0f7386577224p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf8c8p+17,                0x1.8p+1,   0x1.55f6fa5f33504p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e57f26eb2p+35,                0x1.8p+0,   0x1.d8c3977c94e6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d5c59432p+35,                0x1.8p+0,   0x1.34a30b1a635bep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fbf08p+17,                0x1.8p+1,    0x1.f3ea2aab8b9dp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6aec48082p+35,                0x1.8p+0,    0x1.318d98c02933p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c8934ac12p+35,                0x1.8p+0,   0x1.af27c16967e72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca068p+17,                0x1.8p+1,   0x1.6e8bd4c03124ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.31b8p+13,                  0x1p+2,    0x1.0456a85e2645p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e643eea42p+35,                0x1.8p+0,   0x1.d9e322743ef68p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9d9b92392p+35,                0x1.8p+0,   0x1.73bf55c05a702p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.988d8p+17,                0x1.8p+1,   0x1.04236d4fa73f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dba28p+17,                0x1.8p+1,   0x1.9a782e9a3901ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c0b18e3b2p+35,                0x1.8p+0,   0x1.a40a077097e32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4318p+17,                0x1.8p+1,   0x1.8780efe1fc31ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.98408p+17,                0x1.8p+1,    0x1.03907345d28cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0738p+17,                0x1.8p+1,   0x1.3482ef99a1afcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6715d7bc2p+35,                0x1.8p+0,   0x1.2cb82d1a124d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf1c8p+17,                0x1.8p+1,   0x1.54f67f2d296b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.aab336d42p+35,                0x1.8p+0,   0x1.85898d966bfb8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5a28p+17,                0x1.8p+1,   0x1.3fbd2aca76e1ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.875c71132p+35,                0x1.8p+0,   0x1.56296acf15c1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f8858p+17,                0x1.8p+1,   0x1.e9e3fbdcbe01ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4765ef7e2p+35,                0x1.8p+0,   0x1.05ce4f2a410a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eb378p+17,                0x1.8p+1,   0x1.c425a54425028p+53,          0x1p-1, INEXACT)
T(RN,       0x1.472792ef2p+35,                0x1.8p+0,   0x1.0583857f3705ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f76652f92p+35,                0x1.8p+0,   0x1.f32764c978982p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e50c8p+17,                0x1.8p+1,   0x1.b353ee5065d84p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d89ad7142p+35,                0x1.8p+0,   0x1.c60f1991f7938p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.79a8956f2p+35,                0x1.8p+0,   0x1.44599cc936aa6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff548p+17,                0x1.8p+1,   0x1.fdfe2c432205cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f76d8p+17,                0x1.8p+1,   0x1.e6b61c465bf92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3568p+17,                0x1.8p+1,   0x1.1949ecf3191bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0ed8p+17,                0x1.8p+1,   0x1.1477693c38812p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2e18p+17,                0x1.8p+1,   0x1.39bda3178a5aep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8538p+17,                0x1.8p+1,   0x1.6a7b578cb609cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7035efc92p+35,                0x1.8p+0,   0x1.384151786ad1ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.525bd63c2p+35,                0x1.8p+0,   0x1.130ff4b33e228p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7d48p+17,                0x1.8p+1,   0x1.694d06379d1dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8e21b7432p+35,                0x1.8p+0,   0x1.5f1449b14c642p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a2e8p+17,                0x1.8p+1,   0x1.0743287d1e102p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2b18p+17,                0x1.8p+1,   0x1.17fe64b0aea9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.48b955202p+35,                0x1.8p+0,    0x1.0765d283b2ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cbaa8p+17,                0x1.8p+1,   0x1.727fcb2751df6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91340b2f2p+35,                0x1.8p+0,   0x1.6326631778f26p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab478p+17,                0x1.8p+1,   0x1.29930ead53058p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7a98p+17,                0x1.8p+1,   0x1.90451ef014746p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8058p+17,                0x1.8p+1,   0x1.bb617d733fa9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.968d93632p+35,                0x1.8p+0,   0x1.6a46ecc5bca82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8968p+17,                0x1.8p+1,   0x1.23fc906cdc77ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8818p+17,                0x1.8p+1,   0x1.6ae901544a58ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.97938p+17,                0x1.8p+1,   0x1.024704daa525cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbf98p+17,                0x1.8p+1,   0x1.f404bdf0e0fb6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9aad838e2p+35,                0x1.8p+0,   0x1.6fcde8cb7c604p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bba3bb6c2p+35,                0x1.8p+0,   0x1.9cf65bc318b48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aec98p+17,                0x1.8p+1,   0x1.30f6b651073a6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec525b882p+35,                0x1.8p+0,    0x1.e2c49d65ea83p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e048c9962p+35,                0x1.8p+0,   0x1.d12bc73c3664cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.ab88f0532p+35,                0x1.8p+0,   0x1.86ae5cb1c9a62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ed8a61282p+35,                0x1.8p+0,    0x1.e48fd97124e1p+53,          0x1p-1, INEXACT)
T(RN,       0x1.65d1320f2p+35,                0x1.8p+0,   0x1.2b20b7d7ee69ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f3bffc5d2p+35,                0x1.8p+0,   0x1.edbc3a985413ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.614fda792p+35,                0x1.8p+0,   0x1.257f064f91d7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c0c8p+17,                0x1.8p+1,   0x1.0adfb8f29b284p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef3a8p+17,                0x1.8p+1,   0x1.cf50d12b91d26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b68352872p+35,                0x1.8p+0,   0x1.95d32d007ee8ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4ab8p+17,                0x1.8p+1,   0x1.88b34c5431ba4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f92b8p+17,                0x1.8p+1,   0x1.ebc829ee82124p+53,          0x1p-1, INEXACT)
T(RN,     0x1.60c104cc204p+42,                0x1.4p+0,    0x1.0e3fdfcce235p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6bdee9d02p+35,                0x1.8p+0,    0x1.32c036737e6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a369f6052p+35,                0x1.8p+0,   0x1.7b9a48f022f6ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f45b8p+17,                0x1.8p+1,   0x1.dddc4884f5db4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1a68p+17,                0x1.8p+1,   0x1.8128b0e0a242ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c9a1865b2p+35,                0x1.8p+0,   0x1.b0a6c2046f272p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e229a61a2p+35,                0x1.8p+0,   0x1.d3e70e4444b34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2378p+17,                0x1.8p+1,   0x1.d7c0e86d30528p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2698p+17,                0x1.8p+1,   0x1.830d5c6461186p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd538p+17,                0x1.8p+1,   0x1.9edd337d4af9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca518p+17,                0x1.8p+1,   0x1.6f4002131d87ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.96908p+17,                0x1.8p+1,    0x1.005bdcb5169bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a86264d2p+35,                0x1.8p+0,   0x1.1d143145fe85ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a57de102p+35,                0x1.8p+0,    0x1.453b86e9b406p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9dc8p+17,                0x1.8p+1,   0x1.6e270854542f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe3b8p+17,                0x1.8p+1,   0x1.fab72e5cef554p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c67d6a562p+35,                0x1.8p+0,   0x1.ac3463fa7e5ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb558p+17,                0x1.8p+1,   0x1.4c64dbe520f0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad41d5492p+35,                0x1.8p+0,   0x1.890b4dc21cfe2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99bb8p+17,                0x1.8p+1,   0x1.0665f91978fd4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bcfe8p+17,                0x1.8p+1,   0x1.50246308ceef2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.65c57e012p+35,                0x1.8p+0,   0x1.2b120b00d23f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df988p+17,                0x1.8p+1,   0x1.a4cf5453df448p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4d28p+17,                0x1.8p+1,   0x1.1c4956dbf572ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4613396c2p+35,                0x1.8p+0,   0x1.043870fc03f48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e9761ef2p+35,                0x1.8p+0,   0x1.751306a1431a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8418p+17,                0x1.8p+1,   0x1.4584b46378ecep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e94d8p+17,                0x1.8p+1,   0x1.bee1d47a8ec32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed748p+17,                0x1.8p+1,   0x1.ca5b248f4b8bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0b98p+17,                0x1.8p+1,   0x1.14100469d77f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9daf8p+17,                0x1.8p+1,    0x1.0e1116b05831p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab488p+17,                0x1.8p+1,   0x1.2995258c46358p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f4c53472p+35,                0x1.8p+0,   0x1.0f56b5556b00ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8afbbf22p+35,                0x1.8p+0,   0x1.f511a77b0075cp+53,         -0x1p-1, INEXACT)
T(RN,          0x1.68b688p+21,                0x1.4p+1,   0x1.aa9bcb6f0b98cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9548p+17,                0x1.8p+1,   0x1.47e82fbcd2e5cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f42d8p+17,                0x1.8p+1,   0x1.dd58890af3bd2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.44df77342p+35,                0x1.8p+0,   0x1.02c860505ba08p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ba428p+17,                0x1.8p+1,   0x1.49fbce03170fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97228p+17,                0x1.8p+1,   0x1.01706e2343e9ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2af8p+17,                0x1.8p+1,    0x1.acfee7b87121p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3df8p+17,                0x1.8p+1,    0x1.5ff918b0933ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.3de8p+13,                  0x1p+2,   0x1.3066b5a354da8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a13d3e82p+35,                0x1.8p+0,    0x1.59baf2abf8d9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d95cfdbb2p+35,                0x1.8p+0,   0x1.c72702a538d32p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da958p+17,                0x1.8p+1,   0x1.97c148be68ecap+53,          0x1p-1, INEXACT)
T(RN,       0x1.9031b9742p+35,                0x1.8p+0,   0x1.61cf9a15ccb78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9d0d9c102p+35,                0x1.8p+0,    0x1.7300021954bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f287fabc2p+35,                0x1.8p+0,   0x1.ebee224ff8d28p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.837a3bd42p+35,                0x1.8p+0,   0x1.5114d2b293db8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6478p+17,                0x1.8p+1,   0x1.e36357527f158p+53,          0x1p-1, INEXACT)
T(RN,       0x1.af643b1c2p+35,                0x1.8p+0,   0x1.8bfab08af3b68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.901e46732p+35,                0x1.8p+0,   0x1.61b5cf81ce2a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bb7178c32p+35,                0x1.8p+0,   0x1.9cb03055c1942p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e7e562fb2p+35,                0x1.8p+0,   0x1.dc45e34939fb2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d0048p+17,                0x1.8p+1,   0x1.7d1f167b8716cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bd178p+17,                0x1.8p+1,   0x1.505d0d9ea61c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c9e8p+17,                0x1.8p+1,   0x1.0bfbcc1087cd2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6efc6cdc2p+35,                0x1.8p+0,   0x1.36b2d8f8c7de8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cd6ba15b2p+35,                0x1.8p+0,   0x1.b60954c000872p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e32beab02p+35,                0x1.8p+0,    0x1.d55f3256f2c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58c72ce52p+35,                0x1.8p+0,   0x1.1aed4fce147aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bf755bda2p+35,                0x1.8p+0,   0x1.a24e543566b4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5038p+17,                0x1.8p+1,   0x1.62a52781e1facp+53,          0x1p-1, INEXACT)
T(RN,       0x1.89f43f332p+35,                0x1.8p+0,   0x1.5991643ef9c22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f18d77352p+35,                0x1.8p+0,   0x1.ea7b85593bff6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.af348p+17,                0x1.8p+1,   0x1.31da2cfc3b1fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ecc48p+17,                0x1.8p+1,   0x1.c87161cae1bacp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad4c8p+17,                0x1.8p+1,   0x1.2dd0597566a44p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa598p+17,                0x1.8p+1,   0x1.ef3c36d5cdfd6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.479f85482p+35,                0x1.8p+0,    0x1.061364bd7b2bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.68f222962p+35,                0x1.8p+0,   0x1.2f0f4391a804cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b71e8p+17,                0x1.8p+1,   0x1.4300e31968852p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4908p+17,                0x1.8p+1,    0x1.1bc3a98e013bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c5bc8p+17,                0x1.8p+1,   0x1.6458556c7ec94p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98018p+17,                0x1.8p+1,   0x1.03185b8ab080ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c558p+17,                0x1.8p+1,   0x1.0b6da95c15a0ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a26ae1652p+35,                0x1.8p+0,   0x1.7a4030497f956p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c12a8p+17,                0x1.8p+1,   0x1.59af673829a76p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ceb68p+17,                0x1.8p+1,   0x1.79ea67db378dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6fa785532p+35,                0x1.8p+0,   0x1.378c39f9ba462p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7528p+17,                0x1.8p+1,   0x1.8f67c93dd82aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdc78p+17,                0x1.8p+1,   0x1.51ecb040ef7d8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.96d14f562p+35,                0x1.8p+0,   0x1.6aa179d5df7ccp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6b0a97d32p+35,                0x1.8p+0,   0x1.31b3e144f469ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1f010242p+35,                0x1.8p+0,   0x1.a5c996e599668p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f37b2ba2p+35,                0x1.8p+0,   0x1.36fe21d0f0174p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f7fd160f2p+35,                0x1.8p+0,   0x1.f407b1eb05166p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2578p+17,                0x1.8p+1,   0x1.ac146ff484988p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef978p+17,                0x1.8p+1,   0x1.d056079822948p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6608p+17,                0x1.8p+1,    0x1.65db4672f2b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c7234baa2p+35,                0x1.8p+0,   0x1.ad1ee7681dad4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.58d2aa0b2p+35,                0x1.8p+0,   0x1.1afb7435bcbd2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ec078p+17,                0x1.8p+1,   0x1.c664f71b14a98p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b71771bf2p+35,                0x1.8p+0,   0x1.96a0dd45855fap+53,          0x1p-1, INEXACT)
T(RN,            0x1.4708p+13,                  0x1p+2,    0x1.54e267fb39dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a5f547c2p+35,                0x1.8p+0,   0x1.0961a921b0058p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ce58p+17,                0x1.8p+1,   0x1.0c863a26bfc3ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.da708p+17,                0x1.8p+1,    0x1.9761f19a4f55p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bdfddb9a2p+35,                0x1.8p+0,   0x1.a04034abfc234p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9ca58p+17,                0x1.8p+1,   0x1.0c096fd82e17ap+53,          0x1p-1, INEXACT)
T(RN,            0x1.4898p+13,                  0x1p+2,   0x1.5b722c6010488p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc408p+17,                0x1.8p+1,    0x1.9c11c5909f4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd8d8p+17,                0x1.8p+1,   0x1.f8b1782754af2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e77f81f2p+35,                0x1.8p+0,   0x1.21f5df3156546p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.faf82dcf2p+35,                0x1.8p+0,   0x1.f879056b5f1e6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4dda17382p+35,                0x1.8p+0,    0x1.0d95c6e65fe5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e8818p+17,                0x1.8p+1,   0x1.bcb3cc388058ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.491e52c02p+35,                0x1.8p+0,    0x1.07df3d90f4f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf918p+17,                0x1.8p+1,   0x1.56027094ce63ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c8fef8442p+35,                0x1.8p+0,   0x1.afc05095be9a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4da4cdd82p+35,                0x1.8p+0,    0x1.0d553e61cc1fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4f48p+17,                0x1.8p+1,   0x1.df932b6e7b73cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4928p+17,                0x1.8p+1,   0x1.1bc7b5f29f46ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e15f8p+17,                0x1.8p+1,    0x1.a98175d704c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a7fcafd22p+35,                0x1.8p+0,   0x1.81d4022834f64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e7b58p+17,                0x1.8p+1,   0x1.ba8795458bb2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99cb8p+17,                0x1.8p+1,   0x1.0684b7b4ad904p+53,          0x1p-1, INEXACT)
T(RN,       0x1.be1264452p+35,                0x1.8p+0,   0x1.a05cf4320a6eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a1a43162p+35,                0x1.8p+0,   0x1.090e74d07eab4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f85c8p+17,                0x1.8p+1,   0x1.e96c96b4db674p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a11570962p+35,                0x1.8p+0,   0x1.78719008fb3b4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e0178p+17,                0x1.8p+1,   0x1.a61df988a6ac8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.62e75ab52p+35,                0x1.8p+0,   0x1.277b5cd3f110ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c2d8p+17,                0x1.8p+1,   0x1.0b1fdcc5373d2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3768p+17,                0x1.8p+1,   0x1.af125adc8e11ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fbdc8p+17,                0x1.8p+1,   0x1.f3af1fa96f8f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a16e8p+17,                0x1.8p+1,   0x1.157857b5094c2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9a256d202p+35,                0x1.8p+0,    0x1.6f1725d4bbecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fb98p+17,                0x1.8p+1,   0x1.1214782827cf6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.993cd9612p+35,                0x1.8p+0,   0x1.6ddf13eb12732p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.671e37ae2p+35,                0x1.8p+0,   0x1.2cc2b25d4c0c4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.caa28p+17,                0x1.8p+1,   0x1.7002dbb3b151ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ab30a192p+35,                0x1.8p+0,   0x1.314551618e142p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d02efb412p+35,                0x1.8p+0,   0x1.b9fa17de7ea8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c168fa12p+35,                0x1.8p+0,   0x1.3306976eea94ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6208p+17,                0x1.8p+1,    0x1.e2f2c6970fa6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.476c55382p+35,                0x1.8p+0,    0x1.05d5fba10f25p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3562p+15,                0x1.cp+1,   0x1.5f411e120fd1cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2cb8p+17,                0x1.8p+1,   0x1.d965cffe79404p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0f28p+17,                0x1.8p+1,   0x1.d4280be33b48ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2ca8p+17,                0x1.8p+1,   0x1.398bde31fb856p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f29e8p+17,                0x1.8p+1,   0x1.d8e5bb3fa8ed2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d975fdff2p+35,                0x1.8p+0,   0x1.c74b122e4e186p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a35908b2p+35,                0x1.8p+0,   0x1.092f57ca468d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d5b96192p+35,                0x1.8p+0,   0x1.209539a060942p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.710a10792p+35,                0x1.8p+0,   0x1.394f4ea4c9682p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5691dd7b2p+35,                0x1.8p+0,   0x1.183694dd2a4b2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c48e8p+17,                0x1.8p+1,   0x1.6192a602f4922p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7778p+17,                0x1.8p+1,   0x1.43c570b06ece8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b97f31a92p+35,                0x1.8p+0,   0x1.99f95f84a96dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b900f08b2p+35,                0x1.8p+0,   0x1.99498ffe728d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.871bc1432p+35,                0x1.8p+0,   0x1.55d49947b9a42p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ace81e732p+35,                0x1.8p+0,   0x1.88901c3c992a2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a6ed4bd2p+35,                0x1.8p+0,   0x1.6f79b6a383986p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4b5a23962p+35,                0x1.8p+0,   0x1.0a9016de52a4cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.9fef68552p+35,                0x1.8p+0,   0x1.76e3c380a7836p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45b04bff2p+35,                0x1.8p+0,   0x1.03c20df8bc586p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7838p+17,                0x1.8p+1,   0x1.e6f5ee07b9f2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3a28p+17,                0x1.8p+1,   0x1.af8817a71e81ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3458p+17,                0x1.8p+1,   0x1.ae8f563165e5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dea38p+17,                0x1.8p+1,   0x1.a24bb506c3e8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a21a8p+17,                0x1.8p+1,   0x1.16cfe25b8d8c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc0a8p+17,                0x1.8p+1,   0x1.73681dc295616p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e33b8p+17,                0x1.8p+1,   0x1.ae749c6c05454p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cac38p+17,                0x1.8p+1,   0x1.70525196d0cecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6d3a8fd92p+35,                0x1.8p+0,   0x1.34783c42be9c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd008p+17,                0x1.8p+1,     0x1.75bd2c8fb67p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e0a9a8e72p+35,                0x1.8p+0,   0x1.d1b88abfbeb4ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a52efa302p+35,                0x1.8p+0,    0x1.7e01f4d64492p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.de99338a2p+35,                0x1.8p+0,   0x1.ceb9522cbde6cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba9f3e4e2p+35,                0x1.8p+0,   0x1.9b8ada4fe7284p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.93b262932p+35,                0x1.8p+0,   0x1.66774dc63e91ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8dfe723d2p+35,                0x1.8p+0,   0x1.5ee5a3cee1c86p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cc628p+17,                0x1.8p+1,   0x1.743d6964f185ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b4ec7d952p+35,                0x1.8p+0,   0x1.939eee03abeb6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5e88p+17,                0x1.8p+1,   0x1.8bd24085df738p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6538p+17,                0x1.8p+1,   0x1.b6c6b12801a9cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca0d8p+17,                0x1.8p+1,   0x1.6e9ca3490d472p+53,          0x1p-1, INEXACT)
T(RN,       0x1.42ff091d2p+35,                0x1.8p+0,   0x1.008b2a285cc46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7318p+17,                0x1.8p+1,   0x1.211e75d01441ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.e24c8p+17,                0x1.8p+1,   0x1.abf726ff39944p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2278p+17,                0x1.8p+1,   0x1.ab94afc1fa8f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e2f38p+17,                0x1.8p+1,   0x1.adb45050b7a7cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.48679f5b2p+35,                0x1.8p+0,   0x1.0703a3576c472p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97468p+17,                0x1.8p+1,   0x1.01b4be8aa700ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.6398p+13,                  0x1p+2,   0x1.dc81089972ac8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.451d9c012p+35,                0x1.8p+0,   0x1.0312a47ab07f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2f68p+17,                0x1.8p+1,   0x1.1888e8f6a839ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7c0d0c512p+35,                0x1.8p+0,   0x1.476fe0e2dbe52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a531d572p+35,                0x1.8p+0,   0x1.30cc3e9ad282ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5748p+17,                0x1.8p+1,   0x1.63aecd3acc0bcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6d5c59432p+35,                0x1.8p+0,   0x1.34a30b1a635bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5348e902p+35,                0x1.8p+0,    0x1.9402ce4a3236p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f96f8p+17,                0x1.8p+1,    0x1.ec8edca05465p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6538p+17,                0x1.8p+1,   0x1.8ce0e2092ea9cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ab38ff72p+35,                0x1.8p+0,   0x1.5a8d3cd2e9296p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf4b8p+17,                0x1.8p+1,   0x1.556210f325184p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9468p+17,                0x1.8p+1,   0x1.6cbfa08ab760ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1328p+17,                0x1.8p+1,   0x1.59c1e0110a74ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b06a8p+17,                0x1.8p+1,   0x1.346facf7a4a36p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2088p+17,                0x1.8p+1,   0x1.ab423bcf86f98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6988p+17,                0x1.8p+1,   0x1.8d8fa841cb948p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.be078p+17,                0x1.8p+1,   0x1.527e510000098p+53,          0x1p-1, INEXACT)
T(RN,           0x1.be8a8p+17,                0x1.8p+1,   0x1.53a8e871f1196p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5908p+17,                0x1.8p+1,    0x1.b4b7b74d996bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99b18p+17,                0x1.8p+1,   0x1.0652c3309379ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e4b2be5d2p+35,                0x1.8p+0,   0x1.d79924a5822c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c2438p+17,                0x1.8p+1,   0x1.5c39c6a272b6cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce688p+17,                0x1.8p+1,   0x1.792b6a22950b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2ba8p+17,                0x1.8p+1,   0x1.39694211553a6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91cc5b482p+35,                0x1.8p+0,    0x1.63f0b4b0136bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc161f252p+35,                0x1.8p+0,   0x1.b423615e9c8d6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3368p+17,                0x1.8p+1,   0x1.5e6ec2b50d25ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6198p+17,                0x1.8p+1,   0x1.1ee211447c516p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1858p+17,                0x1.8p+1,   0x1.5a81acb11e31ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dae78p+17,                0x1.8p+1,   0x1.9894c93fe0b38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e4078f392p+35,                0x1.8p+0,   0x1.d69f649ece2fep+53,          0x1p-1, INEXACT)
T(RN,       0x1.991caa9e2p+35,                0x1.8p+0,   0x1.6db3ec329f564p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcf38p+17,                0x1.8p+1,   0x1.9de315bdf887cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3038p+17,                0x1.8p+1,   0x1.da05540d889acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.8424d0972p+35,                0x1.8p+0,   0x1.51f382dad9156p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2be8p+17,                0x1.8p+1,   0x1.d940cd50c7a32p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b27a8p+17,                0x1.8p+1,   0x1.38deeb06b98e6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e34b8p+17,                0x1.8p+1,   0x1.ae9f5fc957d84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0758p+17,                0x1.8p+1,   0x1.d2c71e846536ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4128p+17,                0x1.8p+1,   0x1.b0b42a6352eeep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4caf93c42p+35,                0x1.8p+0,   0x1.0c2c84d5074a8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.881960692p+35,                0x1.8p+0,   0x1.57214f13f6fa2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d6ce1d9c2p+35,                0x1.8p+0,   0x1.c377c3e049a68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f11f8p+17,                0x1.8p+1,    0x1.d4a7452883b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7818p+17,                0x1.8p+1,   0x1.21c28ba612a8ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b468p+17,                0x1.8p+1,   0x1.095fb993e5c0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ae8a1cb2p+35,                0x1.8p+0,   0x1.701d570f87352p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45d1cc482p+35,                0x1.8p+0,    0x1.03ea2339b635p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a41740d2p+35,                0x1.8p+0,   0x1.59f6ff2aeb726p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5f1d84012p+35,                0x1.8p+0,   0x1.22c369facb7f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9408p+17,                0x1.8p+1,    0x1.255bd64365bcp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3e88p+13,                  0x1p+2,    0x1.32cd54c288aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7fd7da282p+35,                0x1.8p+0,    0x1.4c599cf1c47fp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb788p+17,                0x1.8p+1,   0x1.4cb39ba72dbe8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.96062c692p+35,                0x1.8p+0,   0x1.6991ffe0de85ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.aa9b7ada2p+35,                0x1.8p+0,   0x1.85690dd728ab4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d541725d2p+35,                0x1.8p+0,   0x1.c13dab8124ac6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e74364cf2p+35,                0x1.8p+0,   0x1.db58c39fbc3e6p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4498p+13,                  0x1p+2,   0x1.4ad59e441f988p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dbdd8p+17,                0x1.8p+1,   0x1.9b11017daf262p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2908p+17,                0x1.8p+1,    0x1.d8bde704f7dbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2e28p+17,                0x1.8p+1,   0x1.1860bded0afdep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c1e6b05b2p+35,                0x1.8p+0,   0x1.a5bc68804798ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c56c8p+17,                0x1.8p+1,   0x1.639bfa4ec54a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9aa8p+17,                0x1.8p+1,   0x1.6daf20e1fc7f6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a4a188ab2p+35,                0x1.8p+0,   0x1.7d4196b1452eep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5cb58292p+35,                0x1.8p+0,   0x1.c203c03326bdep+53,          0x1p-1, INEXACT)
T(RN,       0x1.de8d99812p+35,                0x1.8p+0,   0x1.cea87efe234f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8833a1b32p+35,                0x1.8p+0,   0x1.5743c6764d122p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9c4819a92p+35,                0x1.8p+0,   0x1.71f607fcce6dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8ac8p+17,                0x1.8p+1,   0x1.467245c13f264p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d0d1be92p+35,                0x1.8p+0,   0x1.0c9da46481f5ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2ba8p+17,                0x1.8p+1,   0x1.1810735aea3a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9888p+17,                0x1.8p+1,   0x1.ecd7f71058618p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfe98p+17,                0x1.8p+1,   0x1.7cdc92d023e06p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3668p+17,                0x1.8p+1,   0x1.db1fac0337b6ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.46b94c802p+35,                0x1.8p+0,     0x1.04ff574aacbp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2d88p+17,                0x1.8p+1,   0x1.5d93ecb2ae608p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4218p+17,                0x1.8p+1,   0x1.dd362e8e1076ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f7948p+17,                0x1.8p+1,   0x1.e727427ac951cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a54b8p+17,                0x1.8p+1,   0x1.1d3ed6e7f2384p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e9888p+17,                0x1.8p+1,   0x1.bf838f9af5618p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab788p+17,                0x1.8p+1,   0x1.29f97ada8abe8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f83e937a2p+35,                0x1.8p+0,   0x1.f4692baf978f4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb768p+17,                0x1.8p+1,   0x1.72021c3b3591ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.56f269a42p+35,                0x1.8p+0,   0x1.18ad12fa11298p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e756e7ca2p+35,                0x1.8p+0,   0x1.db755124fa3ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6587a4e52p+35,                0x1.8p+0,   0x1.2ac4816462856p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a3300b352p+35,                0x1.8p+0,   0x1.7b4baa801580ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f1839ba22p+35,                0x1.8p+0,   0x1.ea6cf1d93567cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.91da87ec2p+35,                0x1.8p+0,   0x1.64038a9966648p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9e48p+17,                0x1.8p+1,   0x1.4929920cb490cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1b78p+17,                0x1.8p+1,   0x1.aa6afcd3723a8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd508p+17,                0x1.8p+1,    0x1.9ed5610942dfp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4ca8p+17,                0x1.8p+1,   0x1.df1a96316ce56p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bbdb970d2p+35,                0x1.8p+0,   0x1.9d445c73cb2dap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bc278p+17,                0x1.8p+1,   0x1.4e3e1507c76f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.88cf7b6d2p+35,                0x1.8p+0,   0x1.58107604cd01ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b05f8p+17,                0x1.8p+1,    0x1.345823ba2392p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c244729a2p+35,                0x1.8p+0,   0x1.a64044d1a97ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b525c5ac2p+35,                0x1.8p+0,   0x1.93ee502c390c8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.90f9a0c52p+35,                0x1.8p+0,   0x1.62d8d52d2aa16p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cd07060c2p+35,                0x1.8p+0,   0x1.b57a1972caf08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0b48p+17,                0x1.8p+1,   0x1.140614b19ce7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bea8p+17,                0x1.8p+1,   0x1.0a9dae4be98b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a9a6fc072p+35,                0x1.8p+0,   0x1.841a79c41418ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.44a7b7222p+35,                0x1.8p+0,   0x1.0285c633f037cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a1a8p+17,                0x1.8p+1,   0x1.071ca807180c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ad378p+17,                0x1.8p+1,   0x1.2da41102a5628p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4fe14a892p+35,                0x1.8p+0,   0x1.100b9c9f77e9ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.838827382p+35,                0x1.8p+0,    0x1.5126fcc0e5e5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc8f8p+17,                0x1.8p+1,    0x1.74aa9b3c8bfbp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e3ee8p+17,                0x1.8p+1,   0x1.b053a7803b842p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.493660a92p+35,                0x1.8p+0,   0x1.07fc2bc9d5b22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.826cbc7b2p+35,                0x1.8p+0,   0x1.4fb564976c2b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.75e5a6e42p+35,                0x1.8p+0,   0x1.3f84316b73a18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ddd28p+17,                0x1.8p+1,   0x1.a028b03a4ca2ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8f53de42p+35,                0x1.8p+0,   0x1.f5792ea589be8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2bd328c2p+35,                0x1.8p+0,   0x1.d4bde5a9ab5f8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d13a8p+17,                0x1.8p+1,   0x1.801cf08ec9326p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f30d02a2p+35,                0x1.8p+0,   0x1.0f355099e982cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4618p+17,                0x1.8p+1,   0x1.dded798ab4e2ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.adafbcb72p+35,                0x1.8p+0,   0x1.89a24a385d916p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.97c0567d2p+35,                0x1.8p+0,   0x1.6be141fee2106p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfa98p+17,                0x1.8p+1,   0x1.7c3f07d8b6f46p+53,          0x1p-1, INEXACT)
T(RN,       0x1.67eaae352p+35,                0x1.8p+0,   0x1.2dc3b2080020ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcf88p+17,                0x1.8p+1,   0x1.f6f73ce141068p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f8b7ad4c2p+35,                0x1.8p+0,   0x1.f51d7bb13c288p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e60591b42p+35,                0x1.8p+0,   0x1.d987fb9046b08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9eb9947b2p+35,                0x1.8p+0,   0x1.75413062f72b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fef123dc2p+35,                0x1.8p+0,   0x1.fe69eb8ae27e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.51baf3872p+35,                0x1.8p+0,   0x1.124bdd191308ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5768p+17,                0x1.8p+1,   0x1.3f5cc3d22471ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bec28p+17,                0x1.8p+1,   0x1.5428c25a1c27ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ba2667622p+35,                0x1.8p+0,   0x1.9ae25dad1ff04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.57a348022p+35,                0x1.8p+0,   0x1.19865054dfabcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dec48p+17,                0x1.8p+1,   0x1.a2a23fd2ad1acp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff4111d02p+35,                0x1.8p+0,    0x1.fee1b56d0d6ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1038p+17,                0x1.8p+1,   0x1.59556382bd3acp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb3a4cdf2p+35,                0x1.8p+0,   0x1.b2eaf50ce143ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.55f827482p+35,                0x1.8p+0,    0x1.177a10dc7015p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c24c8p+17,                0x1.8p+1,   0x1.5c4ea8aa93944p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cc06f4792p+35,                0x1.8p+0,   0x1.b40dd0b02717ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4918p+17,                0x1.8p+1,   0x1.8871f4b025d3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f45a8p+17,                0x1.8p+1,   0x1.ddd96b0e43986p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd4e8p+17,                0x1.8p+1,   0x1.767b01725e562p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3be8p+17,                0x1.8p+1,   0x1.8660b97743532p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fe3566df2p+35,                0x1.8p+0,   0x1.fd50b46f437c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bb9d8p+17,                0x1.8p+1,   0x1.4d06e8eadbfa2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.457a123c2p+35,                0x1.8p+0,   0x1.038131406ca28p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b3908p+17,                0x1.8p+1,    0x1.3b38fd38f80bp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.736782ab2p+35,                0x1.8p+0,   0x1.3c5390c331eeep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa7e8p+17,                0x1.8p+1,   0x1.27efe00ac7b72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6928p+17,                0x1.8p+1,   0x1.1fd90f35e0a6ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c32780732p+35,                0x1.8p+0,   0x1.a77fd0d2b16a2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3c98p+17,                0x1.8p+1,   0x1.dc3a740055aa6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f78e8p+17,                0x1.8p+1,   0x1.e715d8ffdea22p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e9761ef2p+35,                0x1.8p+0,   0x1.751306a1431a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eecd8p+17,                0x1.8p+1,   0x1.ce1f26effe8b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.575160232p+35,                0x1.8p+0,   0x1.1921af7e7b3fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ffd98p+17,                0x1.8p+1,   0x1.ff8c88af28456p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fff98p+17,                0x1.8p+1,   0x1.ffec803f5fbb6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9da65b622p+35,                0x1.8p+0,   0x1.73cde069078fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6347f5402p+35,                0x1.8p+0,    0x1.27f409dda7f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b7810a712p+35,                0x1.8p+0,   0x1.9733953be8012p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.66504ef92p+35,                0x1.8p+0,   0x1.2bc02b4cd2e7ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ee3b2aad2p+35,                0x1.8p+0,   0x1.e5944c061fa66p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ffc08p+17,                0x1.8p+1,    0x1.ff41979f65f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dd65f11f2p+35,                0x1.8p+0,   0x1.ccfbff9a94cbap+53,          0x1p-1, INEXACT)
T(RN,       0x1.637d47502p+35,                0x1.8p+0,    0x1.2836ac5b457ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca798p+17,                0x1.8p+1,   0x1.6fa0325f48736p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8eb8p+17,                0x1.8p+1,   0x1.937b17acf3464p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8e58p+17,                0x1.8p+1,   0x1.bdc51d9c1c03ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3738p+17,                0x1.8p+1,   0x1.3afa0aee813fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0a78p+17,                0x1.8p+1,   0x1.a79a40b007478p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b958p+17,                0x1.8p+1,   0x1.09f8c357d79cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8768p+17,                0x1.8p+1,   0x1.45fa5273af81ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9df8p+17,                0x1.8p+1,    0x1.95ecdf3d275ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0a28p+17,                0x1.8p+1,   0x1.a78d089e2871ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a518p+17,                0x1.8p+1,   0x1.078692550c87ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c3eb8p+17,                0x1.8p+1,   0x1.601523f678564p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c18178e62p+35,                0x1.8p+0,   0x1.a52e1e860da94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7a9935b52p+35,                0x1.8p+0,   0x1.458fcbc04cb0ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4ea8p+13,                  0x1p+2,   0x1.75ce3f87dd958p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ff058p+17,                0x1.8p+1,   0x1.fd11ef716979ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3098p+17,                0x1.8p+1,   0x1.18af1566e9e66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.519598612p+35,                0x1.8p+0,   0x1.121e5bebab932p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.510edb122p+35,                0x1.8p+0,   0x1.117a4f6faffe4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b1c48p+17,                0x1.8p+1,   0x1.3756620a11aacp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ea594b02p+35,                0x1.8p+0,    0x1.4acc25711d7ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.d3afb2742p+35,                0x1.8p+0,   0x1.befd3b36a7e88p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b9668p+17,                0x1.8p+1,   0x1.48105090f9d6ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e0bb19d12p+35,                0x1.8p+0,   0x1.d1d1e427e0b52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a3e8b59e2p+35,                0x1.8p+0,   0x1.7c466963ae764p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e9b485ef2p+35,                0x1.8p+0,   0x1.deecabcd4e9a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6298p+17,                0x1.8p+1,   0x1.e30cbf0db0ec6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5fe8p+17,                0x1.8p+1,   0x1.64f3ec3a7e1f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bae5eafb2p+35,                0x1.8p+0,   0x1.9bed6fa2e504ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c8d92eb62p+35,                0x1.8p+0,   0x1.af8ac4eb79d8cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b34a8p+17,                0x1.8p+1,   0x1.3aa11af5c4dd6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5cb674772p+35,                0x1.8p+0,   0x1.1fc8b65930996p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.53e8p+13,                  0x1p+2,   0x1.8dd1f14b7c928p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b25f69542p+35,                0x1.8p+0,   0x1.90174d204e148p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eafb8p+17,                0x1.8p+1,   0x1.c3800a8cc0f94p+53,          0x1p-1, INEXACT)
T(RN,           0x1.df628p+17,                0x1.8p+1,   0x1.a4413fb4e295ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8a58p+17,                0x1.8p+1,   0x1.241b83c11e57ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc1db4932p+35,                0x1.8p+0,   0x1.b42e29fa17ae2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b008p+17,                0x1.8p+1,     0x1.08d85031ad1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9236b02e2p+35,                0x1.8p+0,   0x1.647e0938adbc4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc02b2e22p+35,                0x1.8p+0,   0x1.9d7afc60d3204p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cebd8p+17,                0x1.8p+1,   0x1.79fb8ee78b202p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca418p+17,                0x1.8p+1,   0x1.6f198d0e374cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe5e8p+17,                0x1.8p+1,   0x1.fb1f7c3dc4c12p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cf4ea332p+35,                0x1.8p+0,   0x1.0c805fcdbeddep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd7e8p+17,                0x1.8p+1,   0x1.9f4d5c201dc72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d3658p+17,                0x1.8p+1,   0x1.85820d7c483bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e0748p+17,                0x1.8p+1,   0x1.a7137814021bcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7198p+17,                0x1.8p+1,   0x1.42f5daa17f016p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b49f8p+17,                0x1.8p+1,    0x1.3d86cc096c5ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.68d3e9392p+35,                0x1.8p+0,   0x1.2ee933a00b6fep+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f528p+17,                0x1.8p+1,   0x1.1148f2bb31aaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a60a94652p+35,                0x1.8p+0,   0x1.7f2cdf7a2ef56p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc428p+17,                0x1.8p+1,   0x1.f4dc6ed4ac6fep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9334555a2p+35,                0x1.8p+0,   0x1.65cf76492b3b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.99198p+17,                0x1.8p+1,   0x1.052f365c58616p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef278p+17,                0x1.8p+1,   0x1.cf1b7f8886ff8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7ac95ef32p+35,                0x1.8p+0,   0x1.45cdecd673c5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b5718de12p+35,                0x1.8p+0,   0x1.94575dd9609cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.da358p+17,                0x1.8p+1,   0x1.96ca08dbcf6aap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ccf88p+17,                0x1.8p+1,   0x1.75a9b7e558068p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d2468p+17,                0x1.8p+1,   0x1.82b6408e6490ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f9f9908f2p+35,                0x1.8p+0,   0x1.f6fd2ac7fbc66p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb418p+17,                0x1.8p+1,   0x1.71821fd268fcep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad258p+17,                0x1.8p+1,   0x1.2d7e1f80c06fap+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9f5141a2p+35,                0x1.8p+0,   0x1.df4b6272e1734p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f1a8p+17,                0x1.8p+1,   0x1.10da7611c17c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.799c8f6e2p+35,                0x1.8p+0,   0x1.444a1f9e354bcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ddf68p+17,                0x1.8p+1,   0x1.a086c751e1c9ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.2912p+15,                0x1.cp+1,   0x1.30b6cbc24b5e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b40b8p+17,                0x1.8p+1,   0x1.3c445542ef3c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ed494f62p+35,                0x1.8p+0,   0x1.7565a4e247bf4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9ac8p+17,                0x1.8p+1,   0x1.ed41488f18564p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4678p+17,                0x1.8p+1,   0x1.b1984313dd7b8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.714fb1b42p+35,                0x1.8p+0,   0x1.39a7feecbab08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cc0144892p+35,                0x1.8p+0,   0x1.b405ba9da6d62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b44f8p+17,                0x1.8p+1,    0x1.3cd862d50c6fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dd18b4632p+35,                0x1.8p+0,   0x1.cc8c24c34ec82p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e140db562p+35,                0x1.8p+0,   0x1.d2945ad60efccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ef4a8p+17,                0x1.8p+1,   0x1.cf7dbac6661d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6e0c23672p+35,                0x1.8p+0,   0x1.3581e4ee39fb6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6825613d2p+35,                0x1.8p+0,   0x1.2e0d87ad80a86p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f518074a2p+35,                0x1.8p+0,   0x1.efba6cac248ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7248p+17,                0x1.8p+1,   0x1.67ab269d75cccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.83007ad32p+35,                0x1.8p+0,   0x1.5075fe88c609ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba708p+17,                0x1.8p+1,    0x1.4a62d007c955p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.87716cf92p+35,                0x1.8p+0,   0x1.5644f00be3582p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc138p+17,                0x1.8p+1,   0x1.737dea7a797dcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.4fd9311e2p+35,                0x1.8p+0,   0x1.1001c5a428464p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a8096d5b2p+35,                0x1.8p+0,   0x1.81e566484df8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b62a8p+17,                0x1.8p+1,   0x1.40e79de194176p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.acad8cc32p+35,                0x1.8p+0,   0x1.883fb6349c142p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f2d102932p+35,                0x1.8p+0,   0x1.ec5a3eb5556e2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b1700292p+35,                0x1.8p+0,   0x1.1dc703c89c422p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba4d8p+17,                0x1.8p+1,   0x1.4a146defe6732p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b60a8p+17,                0x1.8p+1,   0x1.40a15400fa416p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d0c578682p+35,                0x1.8p+0,    0x1.bad1187152d7p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e092682d2p+35,                0x1.8p+0,   0x1.d196bfa325d66p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6787c5c22p+35,                0x1.8p+0,   0x1.2d47567fd8ec4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ce208p+17,                0x1.8p+1,    0x1.787b569f4826p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db780b9f2p+35,                0x1.8p+0,   0x1.ca31593d061bap+53,          0x1p-1, INEXACT)
T(RN,       0x1.9adc17252p+35,                0x1.8p+0,   0x1.700c7cc6bc72ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6bbd4cc2p+35,                0x1.8p+0,   0x1.f229e52fa9f88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4dc8p+17,                0x1.8p+1,   0x1.b2d2bdece43f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c61a8p+17,                0x1.8p+1,   0x1.6535fbd19e4c6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b218p+17,                0x1.8p+1,   0x1.091820b39246ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7da0ad242p+35,                0x1.8p+0,   0x1.497a0b630f798p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6d68p+17,                0x1.8p+1,   0x1.8e2cdf271b03ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6e48p+17,                0x1.8p+1,   0x1.6713826d6200cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.49f5548f2p+35,                0x1.8p+0,   0x1.08e1fac38cb9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d23585592p+35,                0x1.8p+0,   0x1.bcdf7fce9793ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad008p+17,                0x1.8p+1,     0x1.2d302ad7b07p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f38c9de62p+35,                0x1.8p+0,   0x1.ed701c429c894p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca1a8p+17,                0x1.8p+1,   0x1.6ebbdb11d90c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d8149f52p+35,                0x1.8p+0,   0x1.0d2a3e6d48976p+53,          0x1p-1, INEXACT)
T(RN,       0x1.772219612p+35,                0x1.8p+0,   0x1.411a2952d58cep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fa018p+17,                0x1.8p+1,   0x1.ee3a2f2bd5e0ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad568p+17,                0x1.8p+1,   0x1.2de5714a4dfbap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa788p+17,                0x1.8p+1,   0x1.27e362ce208e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.71e387b92p+35,                0x1.8p+0,   0x1.3a6467b9dc402p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a95f63d2p+35,                0x1.8p+0,   0x1.09a37f908e486p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd2ffdd42p+35,                0x1.8p+0,   0x1.fbc978c9a7648p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c67f8p+17,                0x1.8p+1,    0x1.66248a107d38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6310fcd02p+35,                0x1.8p+0,    0x1.27af5cc45272p+53,          0x1p-1, INEXACT)
T(RN,       0x1.bfbe49e22p+35,                0x1.8p+0,   0x1.a2b49cdbf9804p+53,          0x1p-1, INEXACT)
T(RN,       0x1.96c30c5a2p+35,                0x1.8p+0,   0x1.6a8e685bb99b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9abf8p+17,                0x1.8p+1,    0x1.085abc2ef704p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2a18p+17,                0x1.8p+1,   0x1.d8ee447229eeep+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb688p+17,                0x1.8p+1,   0x1.4c8f9a38977b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ed848p+17,                0x1.8p+1,   0x1.ca87bbf85f1ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.894a25662p+35,                0x1.8p+0,   0x1.58b1ac45a0d94p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b875c5332p+35,                0x1.8p+0,   0x1.9887e1a9d17dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.99d14f992p+35,                0x1.8p+0,   0x1.6ea63e1b721bep+53,          0x1p-1, INEXACT)
T(RN,       0x1.918e5aeb2p+35,                0x1.8p+0,   0x1.639e54a2f9992p+53,          0x1p-1, INEXACT)
T(RN,       0x1.989bfc3a2p+35,                0x1.8p+0,   0x1.6d076f4023f8cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a648538a2p+35,                0x1.8p+0,   0x1.7f80f9bc36194p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f99b74b2p+35,                0x1.8p+0,   0x1.610617551b1aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d36c8p+17,                0x1.8p+1,   0x1.85938ddf9dea4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df598p+17,                0x1.8p+1,   0x1.a42994b6ce6d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.844963102p+35,                0x1.8p+0,    0x1.522347a2821ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7231be362p+35,                0x1.8p+0,   0x1.3ac8249799774p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7398p+17,                0x1.8p+1,   0x1.212edb9b25776p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f0aad5b52p+35,                0x1.8p+0,   0x1.e92c8de438b0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.98649aef2p+35,                0x1.8p+0,   0x1.6cbd3bf27805ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5058p+17,                0x1.8p+1,   0x1.8995b3b4b099ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f77239222p+35,                0x1.8p+0,   0x1.f3391797eef7cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da1c8p+17,                0x1.8p+1,   0x1.9689b5f9897b4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db8d3f382p+35,                0x1.8p+0,    0x1.ca4fff28aee5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c18c8p+17,                0x1.8p+1,   0x1.5a91dcf2ddb04p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.eacb8p+17,                0x1.8p+1,   0x1.c2fbabe7dfc04p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf218p+17,                0x1.8p+1,   0x1.7af0d0d78a06ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f00d8p+17,                0x1.8p+1,   0x1.d1a20328d7672p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6cbbea762p+35,                0x1.8p+0,   0x1.33d7d7db2cb0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9d88p+17,                0x1.8p+1,   0x1.95dae25bf0b08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1af8p+17,                0x1.8p+1,    0x1.aa55be7b54f1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3388p+17,                0x1.8p+1,   0x1.da9c6d74dbb28p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd309eeb2p+35,                0x1.8p+0,   0x1.9f2102340a192p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a07873af2p+35,                0x1.8p+0,   0x1.779d1a9fce1dap+53,          0x1p-1, INEXACT)
T(RN,       0x1.a2d9327d2p+35,                0x1.8p+0,   0x1.7ad5d1339e6fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9278p+17,                0x1.8p+1,   0x1.4783ebfbb0df8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a29bb3c22p+35,                0x1.8p+0,   0x1.7a82660ec253cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9ef08p+17,                0x1.8p+1,    0x1.1087ac20762dp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5a28p+13,                  0x1p+2,   0x1.abe5866f66db8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bea88p+17,                0x1.8p+1,   0x1.53ed625637978p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.544acdd42p+35,                0x1.8p+0,   0x1.156c60e7c69b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ab1ce6d2p+35,                0x1.8p+0,   0x1.5a8aecc6e25e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdb18p+17,                0x1.8p+1,   0x1.f91c7809ec39ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d6c48p+17,                0x1.8p+1,   0x1.8dff364db39acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.db4e8p+17,                0x1.8p+1,   0x1.999edb991df62p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a0d58p+17,                0x1.8p+1,   0x1.1447ada67db8ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.4d94a8ef2p+35,                0x1.8p+0,   0x1.0d41b232d1c5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac568p+17,                0x1.8p+1,   0x1.2bcaaac6824bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9cc78p+17,                0x1.8p+1,   0x1.0c4bb6806f4d8p+53,          0x1p-1, INEXACT)
T(RN,            0x1.4848p+13,                  0x1p+2,    0x1.5a204be8c8edp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e55e0bc12p+35,                0x1.8p+0,   0x1.d8933cf85138ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b77411f42p+35,                0x1.8p+0,   0x1.97218eb513188p+53,          0x1p-1, INEXACT)
T(RN,       0x1.52b6e8b82p+35,                0x1.8p+0,    0x1.137f09c63c75p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1da8p+17,                0x1.8p+1,   0x1.81a9c80728e06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9ed661d32p+35,                0x1.8p+0,   0x1.7568132280d62p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db898p+17,                0x1.8p+1,   0x1.9a37788a023e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.867e7ef62p+35,                0x1.8p+0,   0x1.5506831d2e80cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.eaba8p+17,                0x1.8p+1,   0x1.c2ccd097cbba6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e99a8p+17,                0x1.8p+1,   0x1.bfb4eed4dfb46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d778dd792p+35,                0x1.8p+0,   0x1.c46d74e0e937ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ae5d8p+17,                0x1.8p+1,   0x1.301191e8cdde2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.50a8a75e2p+35,                0x1.8p+0,   0x1.10fdf65156de4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8e79eaa82p+35,                0x1.8p+0,    0x1.5f88fa7d4751p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e17d8p+17,                0x1.8p+1,   0x1.a9d108d099042p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cfad85e32p+35,                0x1.8p+0,   0x1.b9413ef15df82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd4f8p+17,                0x1.8p+1,    0x1.f7f954ab5e1fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f0e78p+17,                0x1.8p+1,   0x1.d408f60390d38p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1bb8p+17,                0x1.8p+1,   0x1.5afe9bbb587d4p+53,          0x1p-1, INEXACT)
T(RN,     0x1.0c9eef43582p+43,                0x1.4p+0,   0x1.c93b87c2e1408p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fff18p+17,                0x1.8p+1,   0x1.ffd4813b5d05ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d14e8p+17,                0x1.8p+1,   0x1.804e7c9395162p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a590f43d2p+35,                0x1.8p+0,   0x1.7e8748332ff7ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f80f8p+17,                0x1.8p+1,    0x1.e88c904ac223p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab888p+17,                0x1.8p+1,   0x1.2a1af1a195c18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd588p+17,                0x1.8p+1,   0x1.9eea3d2148588p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4cfcfaac2p+35,                0x1.8p+0,   0x1.0c8a2118d9138p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c5fd50f02p+35,                0x1.8p+0,    0x1.ab7f6787c8e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d6d5c9862p+35,                0x1.8p+0,   0x1.c382cccbff054p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe818p+17,                0x1.8p+1,   0x1.fb87d86de578ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f2060c52p+35,                0x1.8p+0,   0x1.4b6b6eddbd5eap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6fa4219a2p+35,                0x1.8p+0,   0x1.3787eb083fe34p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f96a743b2p+35,                0x1.8p+0,   0x1.f627d3afaf5cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4613396c2p+35,                0x1.8p+0,   0x1.043870fc03f48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cffb92052p+35,                0x1.8p+0,   0x1.b9b0ac80db76ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.934b68542p+35,                0x1.8p+0,   0x1.65ee2da6a38b8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e7f119de2p+35,                0x1.8p+0,   0x1.dc570a8e6bb1cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e99c8p+17,                0x1.8p+1,   0x1.bfba6b6a03e34p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a33f55e2p+35,                0x1.8p+0,   0x1.092d687b221e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ec198p+17,                0x1.8p+1,   0x1.c696d78b56716p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a9470412p+35,                0x1.8p+0,   0x1.6fac3996fdb72p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdf98p+17,                0x1.8p+1,   0x1.f9f2a52ba05b6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b0e28p+17,                0x1.8p+1,   0x1.3570bcadbc9dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a8ab7a222p+35,                0x1.8p+0,   0x1.82c2b17251a84p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a9beb1332p+35,                0x1.8p+0,   0x1.843ae6e36bfdep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f74b8p+17,                0x1.8p+1,   0x1.e65385fc57984p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe3765fa2p+35,                0x1.8p+0,   0x1.fd53b1c0dd1f4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5c498d442p+35,                0x1.8p+0,   0x1.1f41f0d967458p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d95173fc2p+35,                0x1.8p+0,   0x1.c7165e9439358p+53,          0x1p-1, INEXACT)
T(RN,       0x1.67a94b702p+35,                0x1.8p+0,    0x1.2d717a5fd6f6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6218p+17,                0x1.8p+1,   0x1.b63f699688d6ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.b5ed72ca2p+35,                0x1.8p+0,   0x1.9503313eaf5ecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dc1dda2a2p+35,                0x1.8p+0,   0x1.cb211a8034bd4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff9705622p+35,                0x1.8p+0,   0x1.ff629025d2b04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b80c0f1d2p+35,                0x1.8p+0,   0x1.97f4d7fbf7846p+53,          0x1p-1, INEXACT)
T(RN,           0x1.97788p+17,                0x1.8p+1,   0x1.0213b408befe8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9a548p+17,                0x1.8p+1,   0x1.078c5a1c7815cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d5a1335a2p+35,                0x1.8p+0,   0x1.c1c733b42dfb4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ddb522a92p+35,                0x1.8p+0,   0x1.cd6eb91b13722p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5028p+13,                  0x1p+2,   0x1.7c8d814f50538p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2188p+17,                0x1.8p+1,   0x1.16cbe218a0bc8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.96618p+17,                0x1.8p+1,   0x1.0002feaf4642ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.ff358p+17,                0x1.8p+1,   0x1.fda17025b2daap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b90f8p+17,                0x1.8p+1,    0x1.474e7ae00a53p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b100da62p+35,                0x1.8p+0,   0x1.70525196d0cecp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d3d38p+17,                0x1.8p+1,   0x1.86955034c5b1cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.927a0f5b2p+35,                0x1.8p+0,   0x1.64d79ee5e5b8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.80564e852p+35,                0x1.8p+0,   0x1.4cfde6d039996p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f4dc10c2p+35,                0x1.8p+0,   0x1.60a172ac58ef8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5f28p+17,                0x1.8p+1,   0x1.8beb863670b8ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.94907e702p+35,                0x1.8p+0,    0x1.679f4c406bd6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d8518p+17,                0x1.8p+1,   0x1.91f16deb0d27ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f6f48p+17,                0x1.8p+1,   0x1.e5577e4841d3cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5ba8p+17,                0x1.8p+1,   0x1.1e20890dfe4a6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.abf88p+17,                0x1.8p+1,   0x1.2b05773c87d68p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b35c8p+17,                0x1.8p+1,   0x1.3ac8249799774p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2168p+17,                0x1.8p+1,   0x1.d76330ce277fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab078p+17,                0x1.8p+1,   0x1.290d6b46fe798p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f3d8p+17,                0x1.8p+1,   0x1.111f807d8c782p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a93f4dc2p+35,                0x1.8p+0,   0x1.5a639d8d6ade8p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.4e48p+13,                  0x1p+2,    0x1.74220bf72045p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eb6b0b1f2p+35,                0x1.8p+0,   0x1.e170886f0ff46p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3e98p+13,                  0x1p+2,   0x1.330afe1a2b908p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dc1d8p+17,                0x1.8p+1,   0x1.9bb6f2bfb0522p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e5b3bdcb2p+35,                0x1.8p+0,   0x1.d9106a4322b52p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6e7866072p+35,                0x1.8p+0,   0x1.360b3dc77ea76p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f2a9880d2p+35,                0x1.8p+0,   0x1.ec1fcc8739f26p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8a27212f2p+35,                0x1.8p+0,   0x1.59d459925e326p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e2cf8p+17,                0x1.8p+1,    0x1.ad543fc0b727p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c4fb8p+17,                0x1.8p+1,   0x1.62925df67fd94p+53,          0x1p-1, INEXACT)
T(RN,            0x1.40c8p+13,                  0x1p+2,    0x1.3b901d9d5cafp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d07bad32p+35,                0x1.8p+0,   0x1.5d9f8e4ba1f62p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d4ed37032p+35,                0x1.8p+0,   0x1.c0c4bb7d78dc2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da1f8p+17,                0x1.8p+1,    0x1.96916da48766p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a91e8p+17,                0x1.8p+1,   0x1.25157e9b40e52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.58593f962p+35,                0x1.8p+0,   0x1.1a660b315c24cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f8e55a482p+35,                0x1.8p+0,    0x1.f5618385f8f5p+53,          0x1p-1, INEXACT)
T(RN,           0x1.efe88p+17,                0x1.8p+1,   0x1.d139d98270538p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.71ca08702p+35,                0x1.8p+0,    0x1.3a43e6594816p+53,          0x1p-1, INEXACT)
T(RN,       0x1.92d8100c2p+35,                0x1.8p+0,   0x1.6554aa65fd4f8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5a969aa02p+35,                0x1.8p+0,    0x1.1d287f9da4fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99938p+17,                0x1.8p+1,   0x1.061927161f85cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c178p+17,                0x1.8p+1,   0x1.0af51914a1ec8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ca138p+17,                0x1.8p+1,   0x1.6eab0b94bf1dcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.c9988p+17,                0x1.8p+1,   0x1.6d83fceeef248p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.877a2b6e2p+35,                0x1.8p+0,   0x1.565067ff5ecbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3228p+17,                0x1.8p+1,   0x1.3a4a6671e729ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dec3bedf2p+35,                0x1.8p+0,   0x1.cef706aa587c6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ef092a92p+35,                0x1.8p+0,   0x1.36a3cbdc8a8dep+53,          0x1p-1, INEXACT)
T(RN,           0x1.d61c8p+17,                0x1.8p+1,   0x1.8c55b6a804bb4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.649c24ee2p+35,                0x1.8p+0,   0x1.299d81211c444p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bf4e19382p+35,                0x1.8p+0,    0x1.a21747aef75bp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d7518p+17,                0x1.8p+1,   0x1.8f653e6eb777ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f71f8p+17,                0x1.8p+1,    0x1.e5d4046ff4d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.655f89a12p+35,                0x1.8p+0,   0x1.2a923d2323d4ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c93d8p+17,                0x1.8p+1,   0x1.6caa1790f1582p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f23321db2p+35,                0x1.8p+0,   0x1.eb7091bdc5972p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e03b8p+17,                0x1.8p+1,   0x1.a67cf5f347b54p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7bf4ed082p+35,                0x1.8p+0,    0x1.4750b4ce2313p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bba78p+17,                0x1.8p+1,   0x1.4d1d6ee366578p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fbee8p+17,                0x1.8p+1,   0x1.f3e442f5c4042p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6b3b70602p+35,                0x1.8p+0,    0x1.31f195b81adcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.dc427fc92p+35,                0x1.8p+0,   0x1.cb561ddd332e2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c6818p+17,                0x1.8p+1,   0x1.6629447286f8ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.ec40b51c2p+35,                0x1.8p+0,   0x1.e2aaa7853a898p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8ce807e22p+35,                0x1.8p+0,   0x1.5d75b026e0404p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9ba142522p+35,                0x1.8p+0,   0x1.71158c298779cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.fb8b7dea2p+35,                0x1.8p+0,   0x1.f954f6f653eacp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2528p+17,                0x1.8p+1,   0x1.3888894faebaep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.459065b52p+35,                0x1.8p+0,   0x1.039be52e56b0ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.63589e772p+35,                0x1.8p+0,   0x1.2808db91fb596p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa9a8p+17,                0x1.8p+1,   0x1.effb079359646p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa1d8p+17,                0x1.8p+1,   0x1.27262272b5f22p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fe978p+17,                0x1.8p+1,   0x1.fbc978c9a7648p+53,          0x1p-1, INEXACT)
T(RN,       0x1.469627672p+35,                0x1.8p+0,   0x1.04d53babb97b6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.81ec33c62p+35,                0x1.8p+0,   0x1.4f0df3501be2cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ab098p+17,                0x1.8p+1,   0x1.291197c707666p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f9bbf01a2p+35,                0x1.8p+0,   0x1.f6a1488c1af34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f0d8p+17,                0x1.8p+1,   0x1.10c0d43fb7b72p+53,          0x1p-1, INEXACT)
T(RN,       0x1.827e1cb42p+35,                0x1.8p+0,   0x1.4fcc0978c8908p+53,          0x1p-1, INEXACT)
T(RN,       0x1.62fd009e2p+35,                0x1.8p+0,   0x1.279666466a69cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7c78p+17,                0x1.8p+1,   0x1.447661fa525d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3638p+17,                0x1.8p+1,   0x1.196416f4538ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e53d8p+17,                0x1.8p+1,   0x1.b3d7ea1834982p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dd6f8p+17,                0x1.8p+1,    0x1.9f2639cb7f25p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dcf2185d2p+35,                0x1.8p+0,   0x1.cc543e21536c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b6e571372p+35,                0x1.8p+0,   0x1.965b6a049b016p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4c08p+17,                0x1.8p+1,    0x1.3dced076c7e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1b08p+17,                0x1.8p+1,    0x1.814181dc34b1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d33d08fa2p+35,                0x1.8p+0,   0x1.be58e39a1eff4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c2de4b6d2p+35,                0x1.8p+0,   0x1.a718c0a94301ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b14f8p+17,                0x1.8p+1,    0x1.365ab7ab1fdfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.92a665422p+35,                0x1.8p+0,   0x1.65129706689c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5cdac5502p+35,                0x1.8p+0,    0x1.1ff5ac3564bep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.763cd62a2p+35,                0x1.8p+0,   0x1.3ff3f992623d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.eed47b742p+35,                0x1.8p+0,   0x1.e6765018ae888p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e88845a2p+35,                0x1.8p+0,   0x1.220a68b4fb64cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2ad8p+17,                0x1.8p+1,   0x1.d9106a4322b52p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4b58p+17,                0x1.8p+1,   0x1.dede53280ea2ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.f21f67862p+35,                0x1.8p+0,   0x1.eb536152bfbacp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad8c8p+17,                0x1.8p+1,   0x1.2e57695d35f04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a796ca6e2p+35,                0x1.8p+0,   0x1.8148f3f67c2bcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.99568p+17,                0x1.8p+1,   0x1.05a41d4ae43bap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6ef8p+17,                0x1.8p+1,    0x1.b86d768e0aedp+53,          0x1p-1, INEXACT)
T(RN,           0x1.97be8p+17,                0x1.8p+1,   0x1.0298cc7f1e132p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.761e0f9d2p+35,                0x1.8p+0,   0x1.3fcc82c747146p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a3468p+17,                0x1.8p+1,   0x1.1929bb7a6340ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aa908p+17,                0x1.8p+1,    0x1.281559dc8a5bp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4648p+17,                0x1.8p+1,   0x1.b19034cbb608cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9abc56d2p+35,                0x1.8p+0,   0x1.9a37788a023e6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f4008p+17,                0x1.8p+1,     0x1.dcd7be365dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.533ab9212p+35,                0x1.8p+0,   0x1.141feadc6144ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd378p+17,                0x1.8p+1,   0x1.f7b2192894628p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b54357b42p+35,                0x1.8p+0,   0x1.94174d19978f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2c78p+17,                0x1.8p+1,   0x1.5d6c62cbd26d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4008p+17,                0x1.8p+1,     0x1.870610d657cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dd8a8p+17,                0x1.8p+1,   0x1.9f6cac8f74696p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.42e0db3d2p+35,                0x1.8p+0,   0x1.00673671ea17ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dcac9d0f2p+35,                0x1.8p+0,   0x1.cbefaa6447c9ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.663085a12p+35,                0x1.8p+0,   0x1.2b98492100ab2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4baa9ae72p+35,                0x1.8p+0,   0x1.0af1360ffcf4ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1638p+17,                0x1.8p+1,   0x1.5a33129d772ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a4628p+17,                0x1.8p+1,   0x1.1b669723f605ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e5afd8722p+35,                0x1.8p+0,   0x1.d90ab92dc15a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d1c38p+17,                0x1.8p+1,   0x1.8170ab76c11ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.48d15f582p+35,                0x1.8p+0,    0x1.0782b7dc1f8fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e428p+17,                0x1.8p+1,   0x1.0f31630c53cfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e624bfac2p+35,                0x1.8p+0,   0x1.d9b58d8c15338p+53,          0x1p-1, INEXACT)
T(RN,       0x1.5e130f932p+35,                0x1.8p+0,   0x1.2178ad59250e2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8f48p+17,                0x1.8p+1,   0x1.eb279add0833cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca5354922p+35,                0x1.8p+0,   0x1.b1a300f123ee4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a18f8p+17,                0x1.8p+1,    0x1.15ba2b4407ebp+53,          0x1p-1, INEXACT)
T(RN,           0x1.ac348p+17,                0x1.8p+1,   0x1.2b834cc6a18fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.507801e92p+35,                0x1.8p+0,   0x1.10c2ccf2834a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ff610c582p+35,                0x1.8p+0,    0x1.ff11a5067551p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.aca98p+17,                0x1.8p+1,   0x1.2c7912ad9de46p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5048p+17,                0x1.8p+1,   0x1.1caeb8055a06cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.42dc177e2p+35,                0x1.8p+0,   0x1.00618988c7f5cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.a17185582p+35,                0x1.8p+0,    0x1.78ee40b2f94fp+53,          0x1p-1, INEXACT)
T(RN,       0x1.7971a01f2p+35,                0x1.8p+0,   0x1.4412d25441546p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e82bae692p+35,                0x1.8p+0,   0x1.dcacd515f8c5ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6190e512p+35,                0x1.8p+0,   0x1.d9a47675f65aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.831fc7e22p+35,                0x1.8p+0,   0x1.509ed13c47bfcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd468p+17,                0x1.8p+1,   0x1.76678631f620ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.65c57e012p+35,                0x1.8p+0,   0x1.2b120b00d23f2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cb7e8p+17,                0x1.8p+1,   0x1.7215705e3f672p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1ec8p+17,                0x1.8p+1,   0x1.81d67e249a224p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5b7ec5fb2p+35,                0x1.8p+0,   0x1.1e4736ecf45b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.687ffb302p+35,                0x1.8p+0,    0x1.2e7f89d6530ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.89ac54c22p+35,                0x1.8p+0,   0x1.5932c8b555b3cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c44a8p+17,                0x1.8p+1,   0x1.60f35c75528d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4f45d9f92p+35,                0x1.8p+0,   0x1.0f4ed99ee347ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c44a8p+17,                0x1.8p+1,   0x1.60f35c75528d6p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7126eea02p+35,                0x1.8p+0,    0x1.397412957b84p+53,          0x1p-1, INEXACT)
T(RN,           0x1.aa0f8p+17,                0x1.8p+1,    0x1.27090c065b83p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e82bae692p+35,                0x1.8p+0,   0x1.dcacd515f8c5ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.69ff02c62p+35,                0x1.8p+0,   0x1.306224935b42cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b5718de12p+35,                0x1.8p+0,   0x1.94575dd9609cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.bcc29d7b2p+35,                0x1.8p+0,   0x1.9e872de93db4ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bf168p+17,                0x1.8p+1,   0x1.54e8c557e36fap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da878p+17,                0x1.8p+1,   0x1.979d33dc5a618p+53,          0x1p-1, INEXACT)
T(RN,       0x1.737a3fb32p+35,                0x1.8p+0,   0x1.3c6b8189b4d22p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8f5695de2p+35,                0x1.8p+0,   0x1.60ad25949ece4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e85f8p+17,                0x1.8p+1,    0x1.bc56f81a6e12p+53,          0x1p-1, INEXACT)
T(RN,           0x1.baad8p+17,                0x1.8p+1,   0x1.4aeb8a047c352p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5fe8p+17,                0x1.8p+1,   0x1.8c09db42991f2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.43894b802p+35,                0x1.8p+0,     0x1.012ff466ac5p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6a8e028c2p+35,                0x1.8p+0,   0x1.311692b042a08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9bf3c4232p+35,                0x1.8p+0,   0x1.718489beb6bfep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f680622f2p+35,                0x1.8p+0,   0x1.f1d18b64e2126p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5178p+17,                0x1.8p+1,   0x1.89c306037a9c8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a97e8p+17,                0x1.8p+1,   0x1.25dc38b946072p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4328p+17,                0x1.8p+1,   0x1.1b058e807e84ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.985650e32p+35,                0x1.8p+0,   0x1.6caa1790f1582p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c6e08p+17,                0x1.8p+1,    0x1.670a0994eecap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55feb10e2p+35,                0x1.8p+0,   0x1.178214c0f90fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.e03e8p+17,                0x1.8p+1,   0x1.a684e0f6186b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8758f1d02p+35,                0x1.8p+0,    0x1.5624d4bf016ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b3865a042p+35,                0x1.8p+0,   0x1.91af10cc0f728p+53,          0x1p-1, INEXACT)
T(RN,           0x1.db978p+17,                0x1.8p+1,   0x1.9a5bb4b246d48p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8f48p+17,                0x1.8p+1,   0x1.bdee26aad533cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd7c8p+17,                0x1.8p+1,   0x1.f87ef659e0fd4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b84f8182p+35,                0x1.8p+0,    0x1.46c014584747p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5bf8p+17,                0x1.8p+1,    0x1.1e2ab678e914p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7982cc5a2p+35,                0x1.8p+0,   0x1.4428f07d6e64cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.86d5d8c72p+35,                0x1.8p+0,   0x1.5578f6f7cbb0ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a2ce8p+17,                0x1.8p+1,   0x1.183896b9309e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.eafd57732p+35,                0x1.8p+0,   0x1.e0cf5b4f39b5ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.db0c238b2p+35,                0x1.8p+0,   0x1.c995678d9eed2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9c978p+17,                0x1.8p+1,   0x1.0bee28bf59048p+53,          0x1p-1, INEXACT)
T(RN,     0x1.6f5d5163b04p+42,                0x1.4p+0,   0x1.1c50189d46c78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fa6b8p+17,                0x1.8p+1,   0x1.ef7109467a0e4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d595b5472p+35,                0x1.8p+0,   0x1.c1b6b13d1740ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.99ab8p+17,                0x1.8p+1,   0x1.06473ce4ddaa4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.69120b2d2p+35,                0x1.8p+0,   0x1.2f37744d30c9ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f70922402p+35,                0x1.8p+0,    0x1.f29ccff0c728p+53,          0x1p-1, INEXACT)
T(RN,       0x1.cde8f9582p+35,                0x1.8p+0,    0x1.b6bbdd9b5dcfp+53,          0x1p-1, INEXACT)
T(RN,       0x1.edf278fa2p+35,                0x1.8p+0,   0x1.e5292e13bb00cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.727e496d2p+35,                0x1.8p+0,   0x1.3b29cacc6ebe6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fafa2b4a2p+35,                0x1.8p+0,   0x1.f87bfde121f14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f84a8p+17,                0x1.8p+1,   0x1.e93831fcde4d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b9a88p+17,                0x1.8p+1,   0x1.48a38f9d30a78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e6238p+17,                0x1.8p+1,   0x1.b644d2510cd0cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.98b68p+17,                0x1.8p+1,   0x1.0471c692906dap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8d84d01a2p+35,                0x1.8p+0,   0x1.5e44d406d90ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a9d88p+17,                0x1.8p+1,   0x1.2696d8b887b08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.896470e22p+35,                0x1.8p+0,   0x1.58d43e71b9e04p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c9d6795d2p+35,                0x1.8p+0,   0x1.b0f1dadc5e8c6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.734726002p+35,                0x1.8p+0,     0x1.3c2a398a51cp+53,          0x1p-1, INEXACT)
T(RN,            0x1.6a08p+13,                  0x1p+2,    0x1.fff5408e70a8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b52b8p+17,                0x1.8p+1,   0x1.3eb89e1289524p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b4968162p+35,                0x1.8p+0,   0x1.709f69f9ca74cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.aeda8p+17,                0x1.8p+1,   0x1.311ad25f56d06p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a3f69c22p+35,                0x1.8p+0,   0x1.1cbceb62bf6c4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f07f80982p+35,                0x1.8p+0,    0x1.e8ec8aa9ade9p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7b5d5e7c2p+35,                0x1.8p+0,   0x1.468cf197f7ba8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ef288p+17,                0x1.8p+1,   0x1.cf1e4dd54faf8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.afbb8p+17,                0x1.8p+1,   0x1.32f9cad1671d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.82c8d8832p+35,                0x1.8p+0,   0x1.502d73a905f3ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74c352b12p+35,                0x1.8p+0,   0x1.3e10524c84b92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d881dc9a2p+35,                0x1.8p+0,   0x1.c5eb1aba20c34p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad108p+17,                0x1.8p+1,    0x1.2d51df1990d3p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.beb58p+17,                0x1.8p+1,   0x1.540b117afd82ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed078p+17,                0x1.8p+1,   0x1.c92ba9ffded98p+53,          0x1p-1, INEXACT)
T(RN,            0x1.30e8p+13,                  0x1p+2,   0x1.0194fa399e168p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.62941dd22p+35,                0x1.8p+0,   0x1.27136f3e0649cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1cc8p+17,                0x1.8p+1,   0x1.818703e1ebfc4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a3428p+17,                0x1.8p+1,   0x1.1921af7e7b3fep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fe3e8p+17,                0x1.8p+1,   0x1.fac01e88eb0b2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da538p+17,                0x1.8p+1,   0x1.97174212e369cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9e8c8p+17,                0x1.8p+1,   0x1.0fc2d1c6d8204p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf848p+17,                0x1.8p+1,   0x1.7be40756577ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdad8p+17,                0x1.8p+1,   0x1.77628cbab9452p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b96531d62p+35,                0x1.8p+0,   0x1.99d52926960ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.9b538p+17,                0x1.8p+1,   0x1.0978e4832499cp+53,          0x1p-1, INEXACT)
T(RN,            0x1.61d8p+13,                  0x1p+2,   0x1.d331613537ab8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4e7059fb2p+35,                0x1.8p+0,   0x1.0e4bdc2d2edb2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e6ed8f892p+35,                0x1.8p+0,   0x1.dadb2f5066762p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.89f982902p+35,                0x1.8p+0,    0x1.59985115edb6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b358p+17,                0x1.8p+1,   0x1.093ed29a261aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.67d83c6a2p+35,                0x1.8p+0,   0x1.2dac7ffff1254p+53,          0x1p-1, INEXACT)
T(RN,       0x1.84347cde2p+35,                0x1.8p+0,   0x1.5207fb35a391cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc028p+17,                0x1.8p+1,   0x1.4dea93e62143ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4648p+17,                0x1.8p+1,   0x1.ddf612352908cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fc768p+17,                0x1.8p+1,   0x1.f57639372a41ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d5778p+17,                0x1.8p+1,   0x1.8ab4f7c0886e8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d24d8p+17,                0x1.8p+1,   0x1.82c7ab7a36f32p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff2317d92p+35,                0x1.8p+0,   0x1.feb4c7863a63ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.c94e8p+17,                0x1.8p+1,   0x1.6cd2c5ad27962p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7219ef892p+35,                0x1.8p+0,   0x1.3aa9c77cfa762p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a26ae1652p+35,                0x1.8p+0,   0x1.7a4030497f956p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cd858p+17,                0x1.8p+1,   0x1.77010318ae71ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.c0f318382p+35,                0x1.8p+0,    0x1.a46612929445p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ca9f087e2p+35,                0x1.8p+0,   0x1.b20e7557ec95cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3c78p+17,                0x1.8p+1,   0x1.3bb075d6e99d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c10f8p+17,                0x1.8p+1,    0x1.59711437abd3p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a106ffd22p+35,                0x1.8p+0,   0x1.785e035e5909cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9fa28p+17,                0x1.8p+1,   0x1.11e6fd1b7fc1ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b17b8p+17,                0x1.8p+1,   0x1.36b94c741fb14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cb148p+17,                0x1.8p+1,   0x1.71158c298779cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7aa8b0582p+35,                0x1.8p+0,    0x1.45a3c33d1d2fp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f9e38p+17,                0x1.8p+1,   0x1.ede24cb28244cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8c48p+17,                0x1.8p+1,   0x1.245b819098facp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f2158p+17,                0x1.8p+1,   0x1.d76059faf414ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ba20d4042p+35,                0x1.8p+0,   0x1.9ada980cda4d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cfe08p+17,                0x1.8p+1,    0x1.7cc668a4b87ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7d9651032p+35,                0x1.8p+0,   0x1.496ca0eb97e3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d6aa8p+17,                0x1.8p+1,   0x1.8dbd4892c76f6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.98888p+17,                0x1.8p+1,   0x1.0419e06110318p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4298p+17,                0x1.8p+1,   0x1.60a6209ae88c6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e8768p+17,                0x1.8p+1,   0x1.bc95c26a6081ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fb368p+17,                0x1.8p+1,   0x1.f1c5c47a5ba5ap+53,         -0x1p-1, INEXACT)
T(RN,            0x1.42b8p+13,                  0x1p+2,    0x1.43419844b461p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cbb573652p+35,                0x1.8p+0,   0x1.b399f334382aap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.88896c092p+35,                0x1.8p+0,   0x1.57b46d99cc662p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f6488p+17,                0x1.8p+1,   0x1.e3663a7156458p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9d723b142p+35,                0x1.8p+0,   0x1.73879b124aec8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9eb4bdd2p+35,                0x1.8p+0,   0x1.df3d07e979a3ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a1938p+17,                0x1.8p+1,   0x1.15c226960905cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6bd4cc1f2p+35,                0x1.8p+0,   0x1.32b36bcacbd46p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b9af7c822p+35,                0x1.8p+0,   0x1.9a3ca592e5244p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc6c8p+17,                0x1.8p+1,   0x1.9c84061ba49a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8b4e26b32p+35,                0x1.8p+0,   0x1.5b58e942b44dep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d62192112p+35,                0x1.8p+0,   0x1.c27faaaedb6d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bcb08p+17,                0x1.8p+1,    0x1.4f73bf653cc1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.914e9a0d2p+35,                0x1.8p+0,   0x1.6349a7553a326p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9f368p+17,                0x1.8p+1,   0x1.1111b0acc865ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7c88p+17,                0x1.8p+1,   0x1.e7be3b5b878d8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cc2d8p+17,                0x1.8p+1,   0x1.73bce958583d2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.6c19ef262p+35,                0x1.8p+0,   0x1.330adbb7a8becp+53,          0x1p-1, INEXACT)
T(RN,           0x1.fc1e8p+17,                0x1.8p+1,   0x1.f47208d694f52p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.dae976fa2p+35,                0x1.8p+0,   0x1.c9634f19fbbf4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.53f609e22p+35,                0x1.8p+0,   0x1.1504bf072e7fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc709c952p+35,                0x1.8p+0,   0x1.9e148e4eeb34ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd988p+17,                0x1.8p+1,   0x1.772f559077e48p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.740967292p+35,                0x1.8p+0,   0x1.3d227aeea39dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.734572012p+35,                0x1.8p+0,   0x1.3c280ca0dfbf2p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3f98p+13,                  0x1p+2,   0x1.36ea85e11a7c8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da338p+17,                0x1.8p+1,   0x1.96c4e3422043cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.92abb7692p+35,                0x1.8p+0,   0x1.6519aaff291a2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d355dfb42p+35,                0x1.8p+0,   0x1.be7c7bb27a8f8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e92ba4822p+35,                0x1.8p+0,   0x1.de23ecd541dbcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0058p+17,                0x1.8p+1,   0x1.d18b7c4bf529ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1918p+17,                0x1.8p+1,   0x1.d5e9f91deac3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.fdeb8p+17,                0x1.8p+1,   0x1.f9c8fb3661364p+53,          0x1p-1, INEXACT)
T(RN,       0x1.45886c612p+35,                0x1.8p+0,   0x1.03925b9142ecep+53,          0x1p-1, INEXACT)
T(RN,       0x1.e2ccbbe82p+35,                0x1.8p+0,    0x1.d4d486e541d9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.796c79542p+35,                0x1.8p+0,   0x1.440c2fe088148p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9a8f10ca2p+35,                0x1.8p+0,   0x1.6fa502071b614p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3284c0a2p+35,                0x1.8p+0,   0x1.912cf9340096cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.97f88p+17,                0x1.8p+1,   0x1.0307369b3c168p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e5544f462p+35,                0x1.8p+0,   0x1.d88504db7bed4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ac0f8p+17,                0x1.8p+1,    0x1.2b35af9743e3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b3458p+17,                0x1.8p+1,   0x1.3a96438624e5ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc8f8p+17,                0x1.8p+1,    0x1.9cdef711cefbp+53,          0x1p-1, INEXACT)
T(RN,       0x1.cb78d0952p+35,                0x1.8p+0,   0x1.b343c6dde8b4ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5a42b3db2p+35,                0x1.8p+0,   0x1.1cc0fa25ebd72p+53,          0x1p-1, INEXACT)
T(RN,           0x1.faaf8p+17,                0x1.8p+1,    0x1.f038b7f215a1p+53,          0x1p-1, INEXACT)
T(RN,           0x1.98d58p+17,                0x1.8p+1,   0x1.04ad0e422838ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.b1e405722p+35,                0x1.8p+0,   0x1.8f6cdee46285cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f47a8p+17,                0x1.8p+1,   0x1.de351f92d2ee6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cd8c8p+17,                0x1.8p+1,   0x1.7712138fdbf04p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ea85e63f2p+35,                0x1.8p+0,   0x1.e01ff31b61efap+53,          0x1p-1, INEXACT)
T(RN,           0x1.e6958p+17,                0x1.8p+1,   0x1.b7796d70292cap+53,          0x1p-1, INEXACT)
T(RN,       0x1.d9c6c84a2p+35,                0x1.8p+0,   0x1.c7bfa0288feecp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.441542cc2p+35,                0x1.8p+0,   0x1.01d6eb460f388p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f35355302p+35,                0x1.8p+0,    0x1.ed1b3ebbc14ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c51024712p+35,                0x1.8p+0,   0x1.aa309313c53eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a5a08p+17,                0x1.8p+1,    0x1.1deba0c5cc8ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9b508p+17,                0x1.8p+1,    0x1.0973158a3e7fp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d82b6af92p+35,                0x1.8p+0,   0x1.c56e8fe21d982p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee3c8p+17,                0x1.8p+1,   0x1.cc89591fb2e14p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9fdf2f382p+35,                0x1.8p+0,    0x1.76cdd4ce28e5p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e3398p+17,                0x1.8p+1,   0x1.ae6f443352b76p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ce405fc32p+35,                0x1.8p+0,   0x1.b738692db0742p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb6d8p+17,                0x1.8p+1,   0x1.4c9ada63b2b92p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e73d8p+17,                0x1.8p+1,   0x1.b9413ef15df82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd4a8p+17,                0x1.8p+1,   0x1.f7ea7d0d0bbd6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b8928p+17,                0x1.8p+1,   0x1.463881162d06ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.70e9ce3a2p+35,                0x1.8p+0,   0x1.39263ad1a7474p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e80a7bf02p+35,                0x1.8p+0,    0x1.dc7c36635f3ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e2607ca2p+35,                0x1.8p+0,   0x1.747a10abf9c14p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bb868p+17,                0x1.8p+1,   0x1.4cd31f099dacap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a88ab1752p+35,                0x1.8p+0,   0x1.8295e91708076p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f7a3cefb2p+35,                0x1.8p+0,   0x1.f382da74ff7b2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e07938062p+35,                0x1.8p+0,   0x1.d1722571ccf54p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.57962c7e2p+35,                0x1.8p+0,   0x1.197634fc24ea4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.baa88p+17,                0x1.8p+1,   0x1.4ae053957ed78p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c1118p+17,                0x1.8p+1,   0x1.5975b1cffeebep+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb9e8p+17,                0x1.8p+1,   0x1.c5424d40d51d2p+53,         -0x1p-1, INEXACT)
T(RN,               0x1.e5p+8,                0x1.8p+2,   0x1.71e9f401b46a4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.937d1d4a2p+35,                0x1.8p+0,   0x1.66305c198ececp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bc38b7942p+35,                0x1.8p+0,   0x1.9dc6736d12c38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba248p+17,                0x1.8p+1,   0x1.49b8abb6d85ccp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c2448p+17,                0x1.8p+1,   0x1.5c3c1898cc42cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e4be6b682p+35,                0x1.8p+0,    0x1.d7aa2f22be09p+53,          0x1p-1, INEXACT)
T(RN,       0x1.776bb9fe2p+35,                0x1.8p+0,   0x1.4178b6b08f7a4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7a68p+17,                0x1.8p+1,   0x1.e75b8168e662ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e0147e042p+35,                0x1.8p+0,   0x1.d0dfcfdb560d8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f10d585c2p+35,                0x1.8p+0,   0x1.e9be1e5ebb2e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab85489a2p+35,                0x1.8p+0,   0x1.86a95a1c74434p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fb1dfe9b2p+35,                0x1.8p+0,   0x1.f8b1782754af2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d63d8p+17,                0x1.8p+1,   0x1.8ca9332d5e482p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ff670b6e2p+35,                0x1.8p+0,   0x1.ff1aa248aacbcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1eb8p+17,                0x1.8p+1,   0x1.1671e6551bf64p+53,          0x1p-1, INEXACT)
T(RN,           0x1.cfeb8p+17,                0x1.8p+1,   0x1.7ce17fdb3e964p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7e86761b2p+35,                0x1.8p+0,   0x1.4aa3cb9e8e9f2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.d8d856242p+35,                0x1.8p+0,   0x1.c667bc5e24d98p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f0518p+17,                0x1.8p+1,   0x1.d2619ad615a7ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f28e8p+17,                0x1.8p+1,   0x1.d8b836990a322p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dcb28p+17,                0x1.8p+1,   0x1.9d39f564995cep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f11a8p+17,                0x1.8p+1,   0x1.d499213675dc6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fcc78p+17,                0x1.8p+1,   0x1.f66606da414d8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2658p+17,                0x1.8p+1,   0x1.38b18f57a38bap+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4008p+17,                0x1.8p+1,     0x1.870610d657cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d50bd75b2p+35,                0x1.8p+0,   0x1.c0f0b32a23472p+53,          0x1p-1, INEXACT)
T(RN,       0x1.ca3329ff2p+35,                0x1.8p+0,   0x1.b1755b3e58986p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7648p+17,                0x1.8p+1,   0x1.6842f578f598cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cf718p+17,                0x1.8p+1,   0x1.7bb551e8c52dep+53,          0x1p-1, INEXACT)
T(RN,       0x1.58c240762p+35,                0x1.8p+0,   0x1.1ae74058de70cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.66c7236c2p+35,                0x1.8p+0,   0x1.2c55546cafb48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c98f8p+17,                0x1.8p+1,    0x1.6d6e6c3b2f6bp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6a2e1ab02p+35,                0x1.8p+0,    0x1.309d8c46bb3ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.aaa58p+17,                0x1.8p+1,   0x1.284116a61bb7ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a1fa8p+17,                0x1.8p+1,   0x1.168fe2c48b366p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ab8374bf2p+35,                0x1.8p+0,   0x1.86a6d8d5e6406p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7508p+17,                0x1.8p+1,    0x1.6813803e96bfp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a25b8p+17,                0x1.8p+1,   0x1.1751ffb2287b4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ed298p+17,                0x1.8p+1,   0x1.c98a455be7bc6p+53,          0x1p-1, INEXACT)
T(RN,           0x1.b7d78p+17,                0x1.8p+1,   0x1.4499cd2a21a08p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b25f69542p+35,                0x1.8p+0,   0x1.90174d204e148p+53,          0x1p-1, INEXACT)
T(RN,       0x1.43618dac2p+35,                0x1.8p+0,   0x1.010092b34bf38p+53,          0x1p-1, INEXACT)
T(RN,       0x1.954b3fe42p+35,                0x1.8p+0,   0x1.68986c9703018p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4208p+17,                0x1.8p+1,    0x1.6091123cd646p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cfd94d722p+35,                0x1.8p+0,   0x1.b97fbec71585cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.74cd8ffa2p+35,                0x1.8p+0,   0x1.3e1d6d5880a0cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.cb478f3e2p+35,                0x1.8p+0,   0x1.b2fdcb36a4b24p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f45a279a2p+35,                0x1.8p+0,   0x1.eea0c490a45ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f7c38c532p+35,                0x1.8p+0,   0x1.f3b2134d45262p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a166af8d2p+35,                0x1.8p+0,   0x1.78df93e60b626p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a203d9502p+35,                0x1.8p+0,    0x1.79b482cc2c3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4c48p+17,                0x1.8p+1,   0x1.b2922f51e83acp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a8a18p+17,                0x1.8p+1,   0x1.241342a71d0eep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a9c28p+17,                0x1.8p+1,   0x1.266932db09b7ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b19e8p+17,                0x1.8p+1,   0x1.37049657033d2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8129d2be2p+35,                0x1.8p+0,   0x1.4e10f018a67dcp+53,          0x1p-1, INEXACT)
T(RN,          0x1.297388p+21,                0x1.4p+1,   0x1.076dffc06b07cp+53,         -0x1p-1, INEXACT)
T(RN,            0x1.3728p+13,                  0x1p+2,   0x1.175c29071e3f8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdb48p+17,                0x1.8p+1,   0x1.7773a0273c57cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c7e68p+17,                0x1.8p+1,   0x1.6977d51ca14eap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a6228p+17,                0x1.8p+1,   0x1.1ef46b733239ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95241b1b2p+35,                0x1.8p+0,   0x1.68643069aac0ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b98fe8cf2p+35,                0x1.8p+0,   0x1.9a10a82a9bbe6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7f88p+17,                0x1.8p+1,   0x1.e849b2eb0e168p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b1438p+17,                0x1.8p+1,   0x1.3640ef83a686cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b53a8p+17,                0x1.8p+1,   0x1.3ed96deb0df26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ab00ce42p+35,                0x1.8p+0,   0x1.5a889cbd7de18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4838p+17,                0x1.8p+1,   0x1.884ec87ff862cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.d5c598d92p+35,                0x1.8p+0,   0x1.c1fb7e2d087c2p+53,         -0x1p-1, INEXACT)
T(RN,             0x1.bb4p+10,                0x1.4p+2,   0x1.f1f596972c55ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.bd5b84ca2p+35,                0x1.8p+0,   0x1.9f5d04256c1ecp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e1638p+17,                0x1.8p+1,   0x1.a98c11659d2ccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b17e8p+17,                0x1.8p+1,   0x1.36bfc00653872p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b2708p+17,                0x1.8p+1,    0x1.38c9511b27d5p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5ae8p+13,                  0x1p+2,   0x1.af9df7e0365e8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4927f1cf2p+35,                0x1.8p+0,   0x1.07eacfcd2961ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ea184c2b2p+35,                0x1.8p+0,   0x1.df7f112772412p+53,          0x1p-1, INEXACT)
T(RN,           0x1.fd3d8p+17,                0x1.8p+1,   0x1.f7c3e76825182p+53,          0x1p-1, INEXACT)
T(RN,       0x1.f5be488c2p+35,                0x1.8p+0,   0x1.f0b13768a8e08p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.dfcf8p+17,                0x1.8p+1,    0x1.a5602b6b6a97p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e4e98p+17,                0x1.8p+1,   0x1.b2f5b88169506p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9eb08p+17,                0x1.8p+1,    0x1.1009a4cebf21p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b7b58p+17,                0x1.8p+1,   0x1.444e8c790ab2ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.ad6c8p+17,                0x1.8p+1,   0x1.2e13dc6108ca4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d9d066ed2p+35,                0x1.8p+0,   0x1.c7cd819f80ee6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e6bcd4c2p+35,                0x1.8p+0,   0x1.5f764d1af7d78p+53,          0x1p-1, INEXACT)
T(RN,       0x1.749022602p+35,                0x1.8p+0,    0x1.3dced076c7e4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c0398p+17,                0x1.8p+1,   0x1.578422f42da76p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fa29492b2p+35,                0x1.8p+0,   0x1.f744553b441eep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bdf48p+17,                0x1.8p+1,   0x1.525310ea4c23cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b4238p+17,                0x1.8p+1,   0x1.3c789103f170cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.44b474e62p+35,                0x1.8p+0,   0x1.0294fe5cf8294p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.bef58p+17,                0x1.8p+1,   0x1.549d4dd8802eap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f2778p+17,                0x1.8p+1,   0x1.d876cd07abde8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.99888p+17,                0x1.8p+1,   0x1.0604099006618p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.a55c54d52p+35,                0x1.8p+0,   0x1.7e3faa8a46936p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a0f88p+17,                0x1.8p+1,   0x1.148d4bb717c68p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c5bc3c62p+35,                0x1.8p+0,   0x1.0bc7341af5e2cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6f9692de2p+35,                0x1.8p+0,   0x1.3776afa80551cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.5b74e33c2p+35,                0x1.8p+0,   0x1.1e3affa47afd8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b50a0dad2p+35,                0x1.8p+0,   0x1.93c7e59231066p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f8808p+17,                0x1.8p+1,    0x1.e9d56b5d7698p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6ec12bc72p+35,                0x1.8p+0,   0x1.36679c47f610ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.973f8p+17,                0x1.8p+1,    0x1.01a77512965cp+53,          0x1p-1, INEXACT)
T(RN,     0x1.78b941cb5c4p+42,                0x1.4p+0,   0x1.2565479dc0f86p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f1588p+17,                0x1.8p+1,   0x1.d5488ca534188p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffd900be2p+35,                0x1.8p+0,   0x1.ffc5823a58c24p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.616573f12p+35,                0x1.8p+0,   0x1.2599f0b74d512p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a4fd8p+17,                0x1.8p+1,   0x1.1ca08520d56c2p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3720fde2p+35,                0x1.8p+0,   0x1.9192ff4aa68e4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6411a8952p+35,                0x1.8p+0,   0x1.28f034defa4b6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.4f3a85d72p+35,                0x1.8p+0,   0x1.0f41197cec6d6p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cef38p+17,                0x1.8p+1,   0x1.7a7ff2268fe7cp+53,          0x1p-1, INEXACT)
T(RN,           0x1.d9d28p+17,                0x1.8p+1,   0x1.95cb77be09e2ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9678p+17,                0x1.8p+1,   0x1.6d0e9e0a226b8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.da9b8p+17,                0x1.8p+1,   0x1.97d0c00f46c74p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b2f4ad142p+35,                0x1.8p+0,   0x1.90e598d39bd38p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d9868p+17,                0x1.8p+1,   0x1.9508530c944cap+53,         -0x1p-1, INEXACT)
T(RN,                0x1.2p+3,                0x1.1p+4,   0x1.d9fe779881944p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.f6b9d9742p+35,                0x1.8p+0,   0x1.f226f31767488p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e5f78p+17,                0x1.8p+1,   0x1.b5cddc915e868p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c1888p+17,                0x1.8p+1,   0x1.5a889cbd7de18p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f7938p+17,                0x1.8p+1,   0x1.e7245b899725cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.b3198c062p+35,                0x1.8p+0,   0x1.911893a8f0754p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5c78p+17,                0x1.8p+1,   0x1.400e4a921dfd8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d5f68p+17,                0x1.8p+1,   0x1.8bf5a263c449ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.647e1a2f2p+35,                0x1.8p+0,   0x1.2977e63ecb126p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.48d62e4b2p+35,                0x1.8p+0,   0x1.07887f951e3aep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a2a88p+17,                0x1.8p+1,   0x1.17ec56cd2a578p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.753ad11a2p+35,                0x1.8p+0,   0x1.3ea94eea346ccp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d11954062p+35,                0x1.8p+0,   0x1.bb48f62983754p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.df8d8p+17,                0x1.8p+1,   0x1.a4b2607e900f2p+53,          0x1p-1, INEXACT)
T(RN,           0x1.dc388p+17,                0x1.8p+1,   0x1.9bfd01ea61628p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ccbeeabb2p+35,                0x1.8p+0,   0x1.b5137ae9978cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ae988c6d2p+35,                0x1.8p+0,   0x1.8ae26019ac1e6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.7041cf3c2p+35,                0x1.8p+0,   0x1.38506bed15828p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ea018p+17,                0x1.8p+1,   0x1.c0cfb923bae0ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6878p+17,                0x1.8p+1,   0x1.1fc2952f48a18p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a73a08c02p+35,                0x1.8p+0,    0x1.80ca6d432f48p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b0b28p+17,                0x1.8p+1,   0x1.3509d87b5b1cep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.98ac10eb2p+35,                0x1.8p+0,   0x1.6d1cfbe67c592p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eaa88p+17,                0x1.8p+1,   0x1.c29b373627d78p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d7379ee82p+35,                0x1.8p+0,    0x1.c40f8e4c98b9p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a80225992p+35,                0x1.8p+0,   0x1.81db762595242p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ba468p+17,                0x1.8p+1,   0x1.4a04c234ec10ap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.55a4d0262p+35,                0x1.8p+0,   0x1.1713eca8b8a14p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c8328p+17,                0x1.8p+1,   0x1.6a2cb9477744ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9c464e382p+35,                0x1.8p+0,    0x1.71f39d920085p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4b88p+17,                0x1.8p+1,   0x1.b271ea69f7fa8p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.b7b1395c2p+35,                0x1.8p+0,   0x1.97768d90098e8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.cdd38p+17,                0x1.8p+1,   0x1.77bf458a7691cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.fe4f5b8c2p+35,                0x1.8p+0,   0x1.fd77927da9ff8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.652510912p+35,                0x1.8p+0,   0x1.2a48f90a691d2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e5858p+17,                0x1.8p+1,   0x1.b49a09d3cef1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f43d8p+17,                0x1.8p+1,   0x1.dd8659974ae82p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a8e18p+17,                0x1.8p+1,   0x1.249766f1497aep+53,          0x1p-1, INEXACT)
T(RN,       0x1.c593e02c2p+35,                0x1.8p+0,   0x1.aaea81b610038p+53,          0x1p-1, INEXACT)
T(RN,       0x1.e53527fe2p+35,                0x1.8p+0,   0x1.d8578669e6ba4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4c9c3b722p+35,                0x1.8p+0,   0x1.0c15212abf3a4p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d4428p+17,                0x1.8p+1,   0x1.87ab96de70efep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.9e42d0022p+35,                0x1.8p+0,   0x1.74a0e59615544p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c8e48p+17,                0x1.8p+1,   0x1.6bd54ffdd060cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.5e88845a2p+35,                0x1.8p+0,   0x1.220a68b4fb64cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4dc8p+17,                0x1.8p+1,   0x1.b2d2bdece43f4p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ac8c9c922p+35,                0x1.8p+0,   0x1.881281a370ee4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.69120b2d2p+35,                0x1.8p+0,   0x1.2f37744d30c9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f4588p+17,                0x1.8p+1,   0x1.ddd3b029aaa88p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.b5ad8p+17,                0x1.8p+1,   0x1.3fd5479028c52p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b843b0bc2p+35,                0x1.8p+0,   0x1.984236fe46ed8p+53,          0x1p-1, INEXACT)
T(RN,           0x1.9a028p+17,                0x1.8p+1,   0x1.06ee793b01e3ep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d1de8p+17,                0x1.8p+1,   0x1.81b3b74f7da92p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.95b443262p+35,                0x1.8p+0,   0x1.69249b41053ecp+53,          0x1p-1, INEXACT)
T(RN,       0x1.6df1153f2p+35,                0x1.8p+0,   0x1.355f950f94306p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9c5b8p+17,                0x1.8p+1,   0x1.0b7956267d5b4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.dffb512a2p+35,                0x1.8p+0,   0x1.d0bb3f41331d4p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b78a4e562p+35,                0x1.8p+0,   0x1.974075a674dccp+53,          0x1p-1, INEXACT)
T(RN,           0x1.a7358p+17,                0x1.8p+1,   0x1.2126a8a1c65aap+53,          0x1p-1, INEXACT)
T(RN,       0x1.7f2e38192p+35,                0x1.8p+0,   0x1.4b7d64b552542p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fd4e8p+17,                0x1.8p+1,   0x1.f7f65cb8ef562p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.abed7ad22p+35,                0x1.8p+0,   0x1.873834863c29cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ab478p+17,                0x1.8p+1,   0x1.29930ead53058p+53,          0x1p-1, INEXACT)
T(RN,       0x1.92f0e6972p+35,                0x1.8p+0,   0x1.6575b72419aaap+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6e08p+17,                0x1.8p+1,    0x1.2078920fe8cap+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8ccf61232p+35,                0x1.8p+0,   0x1.5d55222112e02p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bf4c8p+17,                0x1.8p+1,   0x1.55645b1b04044p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c4518p+17,                0x1.8p+1,   0x1.6103bfefdb67ep+53,          0x1p-1, INEXACT)
T(RN,           0x1.f5398p+17,                0x1.8p+1,   0x1.e0597117ad176p+53,          0x1p-1, INEXACT)
T(RN,       0x1.c93f38e52p+35,                0x1.8p+0,   0x1.b01b61c791056p+53,          0x1p-1, INEXACT)
T(RN,           0x1.d2d48p+17,                0x1.8p+1,   0x1.8417fb4af82dcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.8a5a06742p+35,                0x1.8p+0,   0x1.5a17578b70688p+53,          0x1p-1, INEXACT)
T(RN,       0x1.a99ddde82p+35,                0x1.8p+0,    0x1.840e0181e2e7p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d4808p+17,                0x1.8p+1,    0x1.88473f4defd8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a5e78p+17,                0x1.8p+1,   0x1.1e7c2a808cc38p+53,          0x1p-1, INEXACT)
T(RN,           0x1.f3b68p+17,                0x1.8p+1,   0x1.dc0425e5effdap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ca6a8p+17,                0x1.8p+1,   0x1.6f7c1e4b1a836p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da198p+17,                0x1.8p+1,   0x1.9681fe678c116p+53,          0x1p-1, INEXACT)
T(RN,           0x1.a6618p+17,                0x1.8p+1,   0x1.1f74f8a4e142ep+53,          0x1p-1, INEXACT)
T(RN,       0x1.868ab9072p+35,                0x1.8p+0,   0x1.5516878d94476p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.a7ed8p+17,                0x1.8p+1,   0x1.22a071f11d512p+53,          0x1p-1, INEXACT)
T(RN,       0x1.9b35b08c2p+35,                0x1.8p+0,   0x1.7084e8613fe08p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e1f15ee12p+35,                0x1.8p+0,   0x1.d39524f8a4432p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d8eb8p+17,                0x1.8p+1,   0x1.937b17acf3464p+53,          0x1p-1, INEXACT)
T(RN,           0x1.e56e8p+17,                0x1.8p+1,   0x1.b45c008a8c0c2p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.da3c8p+17,                0x1.8p+1,   0x1.96dc0ccd3b214p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.deb38p+17,                0x1.8p+1,   0x1.a275a9417f9bcp+53,          0x1p-1, INEXACT)
T(RN,       0x1.e9f708f62p+35,                0x1.8p+0,   0x1.df4e4163f73f4p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.9bf58p+17,                0x1.8p+1,   0x1.0ab30ae7121eap+53,          0x1p-1, INEXACT)
T(RN,       0x1.ad315a2f2p+35,                0x1.8p+0,   0x1.88f4ab389cedap+53,          0x1p-1, INEXACT)
T(RN,           0x1.f22f8p+17,                0x1.8p+1,    0x1.d7aa2f22be09p+53,          0x1p-1, INEXACT)
T(RN,           0x1.c5548p+17,                0x1.8p+1,   0x1.63638586d925cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.c6e6f63a2p+35,                0x1.8p+0,   0x1.acc9967200474p+53,          0x1p-1, INEXACT)
T(RN,       0x1.b7333a622p+35,                0x1.8p+0,   0x1.96c7760d942fcp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.ffbd02312p+35,                0x1.8p+0,   0x1.ff9b86933b492p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.99608p+17,                0x1.8p+1,    0x1.05b74aac2242p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4d2bc28a2p+35,                0x1.8p+0,   0x1.0cc2ba0ee086cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.f9438p+17,                0x1.8p+1,   0x1.ec0e44c6bc06cp+53,          0x1p-1, INEXACT)
T(RN,       0x1.f91ef48e2p+35,                0x1.8p+0,   0x1.f5b753639fc04p+53,         -0x1p-1, INEXACT)
T(RN,            0x1.5948p+13,                  0x1p+2,    0x1.a79623861b51p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c9738p+17,                0x1.8p+1,   0x1.6d2b5a23535fcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.f48e8p+17,                0x1.8p+1,   0x1.de6e765a85922p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d56f67612p+35,                0x1.8p+0,   0x1.c17fabf06d4cep+53,          0x1p-1, INEXACT)
T(RN,       0x1.790e0db02p+35,                0x1.8p+0,    0x1.43929da297e2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.e6ce5b212p+35,                0x1.8p+0,   0x1.daad8a81687b2p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d98efeec2p+35,                0x1.8p+0,   0x1.c76f239eeefb8p+53,          0x1p-1, INEXACT)
T(RN,       0x1.8e4c0c272p+35,                0x1.8p+0,   0x1.5f4c4969031cap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b5df8p+17,                0x1.8p+1,    0x1.4042f0e5c09ap+53,          0x1p-1, INEXACT)
T(RN,       0x1.5d84e49c2p+35,                0x1.8p+0,   0x1.20c8699155b98p+53,          0x1p-1, INEXACT)
T(RN,           0x1.ee208p+17,                0x1.8p+1,    0x1.cc3b17d24e26p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.4a8ded3a2p+35,                0x1.8p+0,   0x1.0999d049f958cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.85e4d9e22p+35,                0x1.8p+0,   0x1.543d518193804p+53,          0x1p-1, INEXACT)
T(RN,       0x1.fd49ebda2p+35,                0x1.8p+0,   0x1.fbf042ee4cb4cp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.c70f8p+17,                0x1.8p+1,    0x1.67796009e4f3p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eaf68p+17,                0x1.8p+1,   0x1.c3723f7bb1b9ap+53,         -0x1p-1, INEXACT)
T(RN,           0x1.d55e8p+17,                0x1.8p+1,   0x1.8a75ec9977912p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7ac27d712p+35,                0x1.8p+0,   0x1.45c50c32dea12p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4688p+17,                0x1.8p+1,   0x1.b19af286ed2b8p+53,         -0x1p-1, INEXACT)
T(RN,           0x1.ee3f8p+17,                0x1.8p+1,    0x1.cc91bc1336acp+53,          0x1p-1, INEXACT)
T(RN,           0x1.b8598p+17,                0x1.8p+1,   0x1.45b9f3a0729d6p+53,          0x1p-1, INEXACT)
T(RN,       0x1.85b3fd282p+35,                0x1.8p+0,    0x1.53fd5df7fa61p+53,          0x1p-1, INEXACT)
T(RN,           0x1.eb828p+17,                0x1.8p+1,   0x1.c4f4df94f7ebep+53,         -0x1p-1, INEXACT)
T(RN,           0x1.e4dd8p+17,                0x1.8p+1,   0x1.b2d56eac31562p+53,          0x1p-1, INEXACT)
T(RN,           0x1.bc348p+17,                0x1.8p+1,   0x1.4e5b6f37d48fcp+53,         -0x1p-1, INEXACT)
T(RN,           0x1.fdb08p+17,                0x1.8p+1,    0x1.f9197ef2ecf1p+53,         -0x1p-1, INEXACT)
T(RN,       0x1.d2766aee2p+35,                0x1.8p+0,   0x1.bd3c66eef37bcp+53,          0x1p-1, INEXACT)
T(RN,           0x1.cf858p+17,                0x1.8p+1,   0x1.7be67cc81bd1ap+53,          0x1p-1, INEXACT)
T(RN,           0x1.b2408p+17,                0x1.8p+1,    0x1.3861af54376cp+53,         -0x1p-1, INEXACT)
T(RN,       0x1.6511056b2p+35,                0x1.8p+0,   0x1.2a2fdd23a416ep+53,         -0x1p-1, INEXACT)
T(RN,       0x1.7cbe9c4f2p+35,                0x1.8p+0,   0x1.4855745568b1ap+53,          0x1p-1, INEXACT)
T(RN,       0