// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file module_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__MODULE_STRUCT_HPP
#define FAST_DDS_GENERATED__MODULE_STRUCT_HPP

#include <cstdint>
#include <functional>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MODULE_STRUCT_SOURCE)
#define MODULE_STRUCT_DllAPI __declspec( dllexport )
#else
#define MODULE_STRUCT_DllAPI __declspec( dllimport )
#endif // MODULE_STRUCT_SOURCE
#else
#define MODULE_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MODULE_STRUCT_DllAPI
#endif // _WIN32

namespace TrialModule {

namespace AliasModule {

typedef int32_t AliasType;


} // namespace AliasModule

} // namespace TrialModule
namespace TrialModule {

namespace BitsetModule {

/*!
 * @brief This structure represents the bitset BitsetType defined by the user in the IDL file.
 * @ingroup module_struct
 */
struct BitsetType
{
        uint8_t flag1 : 3;

        uint16_t flag2 : 10;

        int32_t flag3 : 12;


    /*!
     * @brief Comparison operator.
     * @param x BitsetType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitsetType& x) const
    {
        return (flag1 == x.flag1 &&
           flag2 == x.flag2 &&
           flag3 == x.flag3);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitsetType& x) const
    {
        return !(*this == x);
    }
};

} // namespace BitsetModule

} // namespace TrialModule
namespace TrialModule {

namespace BitmaskModule {

/*!
 * @brief This enumeration represents the BitmaskType bitflags defined by the user in the IDL file.
 * @ingroup module_struct
 */
enum BitmaskTypeBits : uint8_t
{
    FLAG_ONE = 0x01ull << 0,
    FLAG_TWO = 0x01ull << 1,
    FLAG_THREE = 0x01ull << 2
};
typedef uint8_t BitmaskType;

} // namespace BitmaskModule

} // namespace TrialModule
namespace TrialModule {

namespace EnumModule {

/*!
 * @brief This class represents the enumeration EnumType defined by the user in the IDL file.
 * @ingroup module_struct
 */
enum class EnumType : int32_t
{
    VALUE_ONE,
    VALUE_TWO,
    VALUE_THREE
};

} // namespace EnumModule

} // namespace TrialModule
namespace TrialModule {

namespace StructModule {

/*!
 * @brief This class represents the structure StructType defined by the user in the IDL file.
 * @ingroup module_struct
 */
class StructType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructType that will be copied.
     */
    eProsima_user_DllExport StructType(
            const StructType& x)
    {
                    m_struct_data = x.m_struct_data;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructType that will be copied.
     */
    eProsima_user_DllExport StructType(
            StructType&& x) noexcept
    {
        m_struct_data = std::move(x.m_struct_data);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructType that will be copied.
     */
    eProsima_user_DllExport StructType& operator =(
            const StructType& x)
    {

                    m_struct_data = x.m_struct_data;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructType that will be copied.
     */
    eProsima_user_DllExport StructType& operator =(
            StructType&& x) noexcept
    {

        m_struct_data = std::move(x.m_struct_data);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructType& x) const
    {
        return (m_struct_data == x.m_struct_data);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member struct_data
     * @param _struct_data New value to be copied in member struct_data
     */
    eProsima_user_DllExport void struct_data(
            const std::string& _struct_data)
    {
        m_struct_data = _struct_data;
    }

    /*!
     * @brief This function moves the value in member struct_data
     * @param _struct_data New value to be moved in member struct_data
     */
    eProsima_user_DllExport void struct_data(
            std::string&& _struct_data)
    {
        m_struct_data = std::move(_struct_data);
    }

    /*!
     * @brief This function returns a constant reference to member struct_data
     * @return Constant reference to member struct_data
     */
    eProsima_user_DllExport const std::string& struct_data() const
    {
        return m_struct_data;
    }

    /*!
     * @brief This function returns a reference to member struct_data
     * @return Reference to member struct_data
     */
    eProsima_user_DllExport std::string& struct_data()
    {
        return m_struct_data;
    }



private:

    std::string m_struct_data;

};

} // namespace StructModule

} // namespace TrialModule
namespace TrialModule {

namespace UnionModule {

/*!
 * @brief This class represents the union UnionType defined by the user in the IDL file.
 * @ingroup module_struct
 */
class UnionType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionType()
    {
        selected_member_ = 0x00000003;
        member_destructor_ = [&]()
        {
            m_case_string.~basic_string();
        };
        new(&m_case_string) std::string();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionType()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionType that will be copied.
     */
    eProsima_user_DllExport UnionType(
            const UnionType& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_long_() = x.m_case_long;
                            break;

                        case 0x00000002:
                            case_float_() = x.m_case_float;
                            break;

                        case 0x00000003:
                            case_string_() = x.m_case_string;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionType that will be copied.
     */
    eProsima_user_DllExport UnionType(
            UnionType&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_long_() = std::move(x.m_case_long);
                            break;

                        case 0x00000002:
                            case_float_() = std::move(x.m_case_float);
                            break;

                        case 0x00000003:
                            case_string_() = std::move(x.m_case_string);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionType that will be copied.
     */
    eProsima_user_DllExport UnionType& operator =(
            const UnionType& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_long_() = x.m_case_long;
                            break;

                        case 0x00000002:
                            case_float_() = x.m_case_float;
                            break;

                        case 0x00000003:
                            case_string_() = x.m_case_string;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionType that will be copied.
     */
    eProsima_user_DllExport UnionType& operator =(
            UnionType&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_long_() = std::move(x.m_case_long);
                            break;

                        case 0x00000002:
                            case_float_() = std::move(x.m_case_float);
                            break;

                        case 0x00000003:
                            case_string_() = std::move(x.m_case_string);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionType& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_case_long == m_case_long);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_case_float == m_case_float);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_case_string == m_case_string);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member case_long
     * @param _case_long New value for member case_long
     */
    eProsima_user_DllExport void case_long(
            int32_t _case_long)
    {
        case_long_() = _case_long;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member case_long
     * @return Value of member case_long
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t case_long() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_long;
    }

    /*!
     * @brief This function returns a reference to member case_long
     * @return Reference to member case_long
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& case_long()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_long;
    }


    /*!
     * @brief This function sets a value in member case_float
     * @param _case_float New value for member case_float
     */
    eProsima_user_DllExport void case_float(
            float _case_float)
    {
        case_float_() = _case_float;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member case_float
     * @return Value of member case_float
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float case_float() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_float;
    }

    /*!
     * @brief This function returns a reference to member case_float
     * @return Reference to member case_float
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float& case_float()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_float;
    }


    /*!
     * @brief This function copies the value in member case_string
     * @param _case_string New value to be copied in member case_string
     */
    eProsima_user_DllExport void case_string(
            const std::string& _case_string)
    {
        case_string_() = _case_string;
        m__d = 2147483647;
    }

    /*!
     * @brief This function moves the value in member case_string
     * @param _case_string New value to be moved in member case_string
     */
    eProsima_user_DllExport void case_string(
            std::string&& _case_string)
    {
        case_string_() = _case_string;
        m__d = 2147483647;
    }

    /*!
     * @brief This function returns a constant reference to member case_string
     * @return Constant reference to member case_string
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::string& case_string() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_string;
    }

    /*!
     * @brief This function returns a reference to member case_string
     * @return Reference to member case_string
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::string& case_string()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_string;
    }



private:

            int32_t& case_long_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_case_long = {0};

                }

                return m_case_long;
            }

            float& case_float_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_case_float = {0.0};

                }

                return m_case_float;
            }

            std::string& case_string_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_case_string.~basic_string();
                    };
                    new(&m_case_string) std::string();

                }

                return m_case_string;
            }


    int32_t m__d {2147483647};

    union
    {
        int32_t m_case_long;
        float m_case_float;
        std::string m_case_string;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};

} // namespace UnionModule

} // namespace TrialModule
/*!
 * @brief This class represents the structure ModuleStruct defined by the user in the IDL file.
 * @ingroup module_struct
 */
class ModuleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuleStruct that will be copied.
     */
    eProsima_user_DllExport ModuleStruct(
            const ModuleStruct& x)
    {
                    m_alias_member = x.m_alias_member;

                    m_bitset_member = x.m_bitset_member;

                    m_bitmask_member = x.m_bitmask_member;

                    m_enum_member = x.m_enum_member;

                    m_struct_member = x.m_struct_member;

                    m_union_member = x.m_union_member;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuleStruct that will be copied.
     */
    eProsima_user_DllExport ModuleStruct(
            ModuleStruct&& x) noexcept
    {
        m_alias_member = x.m_alias_member;
        m_bitset_member = std::move(x.m_bitset_member);
        m_bitmask_member = std::move(x.m_bitmask_member);
        m_enum_member = x.m_enum_member;
        m_struct_member = std::move(x.m_struct_member);
        m_union_member = std::move(x.m_union_member);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuleStruct that will be copied.
     */
    eProsima_user_DllExport ModuleStruct& operator =(
            const ModuleStruct& x)
    {

                    m_alias_member = x.m_alias_member;

                    m_bitset_member = x.m_bitset_member;

                    m_bitmask_member = x.m_bitmask_member;

                    m_enum_member = x.m_enum_member;

                    m_struct_member = x.m_struct_member;

                    m_union_member = x.m_union_member;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuleStruct that will be copied.
     */
    eProsima_user_DllExport ModuleStruct& operator =(
            ModuleStruct&& x) noexcept
    {

        m_alias_member = x.m_alias_member;
        m_bitset_member = std::move(x.m_bitset_member);
        m_bitmask_member = std::move(x.m_bitmask_member);
        m_enum_member = x.m_enum_member;
        m_struct_member = std::move(x.m_struct_member);
        m_union_member = std::move(x.m_union_member);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuleStruct& x) const
    {
        return (m_alias_member == x.m_alias_member &&
           m_bitset_member == x.m_bitset_member &&
           m_bitmask_member == x.m_bitmask_member &&
           m_enum_member == x.m_enum_member &&
           m_struct_member == x.m_struct_member &&
           m_union_member == x.m_union_member);
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member alias_member
     * @param _alias_member New value for member alias_member
     */
    eProsima_user_DllExport void alias_member(
            TrialModule::AliasModule::AliasType _alias_member)
    {
        m_alias_member = _alias_member;
    }

    /*!
     * @brief This function returns the value of member alias_member
     * @return Value of member alias_member
     */
    eProsima_user_DllExport TrialModule::AliasModule::AliasType alias_member() const
    {
        return m_alias_member;
    }

    /*!
     * @brief This function returns a reference to member alias_member
     * @return Reference to member alias_member
     */
    eProsima_user_DllExport TrialModule::AliasModule::AliasType& alias_member()
    {
        return m_alias_member;
    }


    /*!
     * @brief This function copies the value in member bitset_member
     * @param _bitset_member New value to be copied in member bitset_member
     */
    eProsima_user_DllExport void bitset_member(
            const TrialModule::BitsetModule::BitsetType& _bitset_member)
    {
        m_bitset_member = _bitset_member;
    }

    /*!
     * @brief This function moves the value in member bitset_member
     * @param _bitset_member New value to be moved in member bitset_member
     */
    eProsima_user_DllExport void bitset_member(
            TrialModule::BitsetModule::BitsetType&& _bitset_member)
    {
        m_bitset_member = std::move(_bitset_member);
    }

    /*!
     * @brief This function returns a constant reference to member bitset_member
     * @return Constant reference to member bitset_member
     */
    eProsima_user_DllExport const TrialModule::BitsetModule::BitsetType& bitset_member() const
    {
        return m_bitset_member;
    }

    /*!
     * @brief This function returns a reference to member bitset_member
     * @return Reference to member bitset_member
     */
    eProsima_user_DllExport TrialModule::BitsetModule::BitsetType& bitset_member()
    {
        return m_bitset_member;
    }


    /*!
     * @brief This function copies the value in member bitmask_member
     * @param _bitmask_member New value to be copied in member bitmask_member
     */
    eProsima_user_DllExport void bitmask_member(
            const TrialModule::BitmaskModule::BitmaskType& _bitmask_member)
    {
        m_bitmask_member = _bitmask_member;
    }

    /*!
     * @brief This function moves the value in member bitmask_member
     * @param _bitmask_member New value to be moved in member bitmask_member
     */
    eProsima_user_DllExport void bitmask_member(
            TrialModule::BitmaskModule::BitmaskType&& _bitmask_member)
    {
        m_bitmask_member = std::move(_bitmask_member);
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_member
     * @return Constant reference to member bitmask_member
     */
    eProsima_user_DllExport const TrialModule::BitmaskModule::BitmaskType& bitmask_member() const
    {
        return m_bitmask_member;
    }

    /*!
     * @brief This function returns a reference to member bitmask_member
     * @return Reference to member bitmask_member
     */
    eProsima_user_DllExport TrialModule::BitmaskModule::BitmaskType& bitmask_member()
    {
        return m_bitmask_member;
    }


    /*!
     * @brief This function sets a value in member enum_member
     * @param _enum_member New value for member enum_member
     */
    eProsima_user_DllExport void enum_member(
            TrialModule::EnumModule::EnumType _enum_member)
    {
        m_enum_member = _enum_member;
    }

    /*!
     * @brief This function returns the value of member enum_member
     * @return Value of member enum_member
     */
    eProsima_user_DllExport TrialModule::EnumModule::EnumType enum_member() const
    {
        return m_enum_member;
    }

    /*!
     * @brief This function returns a reference to member enum_member
     * @return Reference to member enum_member
     */
    eProsima_user_DllExport TrialModule::EnumModule::EnumType& enum_member()
    {
        return m_enum_member;
    }


    /*!
     * @brief This function copies the value in member struct_member
     * @param _struct_member New value to be copied in member struct_member
     */
    eProsima_user_DllExport void struct_member(
            const TrialModule::StructModule::StructType& _struct_member)
    {
        m_struct_member = _struct_member;
    }

    /*!
     * @brief This function moves the value in member struct_member
     * @param _struct_member New value to be moved in member struct_member
     */
    eProsima_user_DllExport void struct_member(
            TrialModule::StructModule::StructType&& _struct_member)
    {
        m_struct_member = std::move(_struct_member);
    }

    /*!
     * @brief This function returns a constant reference to member struct_member
     * @return Constant reference to member struct_member
     */
    eProsima_user_DllExport const TrialModule::StructModule::StructType& struct_member() const
    {
        return m_struct_member;
    }

    /*!
     * @brief This function returns a reference to member struct_member
     * @return Reference to member struct_member
     */
    eProsima_user_DllExport TrialModule::StructModule::StructType& struct_member()
    {
        return m_struct_member;
    }


    /*!
     * @brief This function copies the value in member union_member
     * @param _union_member New value to be copied in member union_member
     */
    eProsima_user_DllExport void union_member(
            const TrialModule::UnionModule::UnionType& _union_member)
    {
        m_union_member = _union_member;
    }

    /*!
     * @brief This function moves the value in member union_member
     * @param _union_member New value to be moved in member union_member
     */
    eProsima_user_DllExport void union_member(
            TrialModule::UnionModule::UnionType&& _union_member)
    {
        m_union_member = std::move(_union_member);
    }

    /*!
     * @brief This function returns a constant reference to member union_member
     * @return Constant reference to member union_member
     */
    eProsima_user_DllExport const TrialModule::UnionModule::UnionType& union_member() const
    {
        return m_union_member;
    }

    /*!
     * @brief This function returns a reference to member union_member
     * @return Reference to member union_member
     */
    eProsima_user_DllExport TrialModule::UnionModule::UnionType& union_member()
    {
        return m_union_member;
    }



private:

    TrialModule::AliasModule::AliasType m_alias_member{0};
    TrialModule::BitsetModule::BitsetType m_bitset_member{};
    TrialModule::BitmaskModule::BitmaskType m_bitmask_member{0};
    TrialModule::EnumModule::EnumType m_enum_member{TrialModule::EnumModule::EnumType::VALUE_ONE};
    TrialModule::StructModule::StructType m_struct_member;
    TrialModule::UnionModule::UnionType m_union_member;

};

#endif // _FAST_DDS_GENERATED_MODULE_STRUCT_HPP_


