#ifndef BUILDING_BUILDING_STATE_H
#define BUILDING_BUILDING_STATE_H

#include "building/building.h"
#include "core/buffer.h"
#include "game/resource.h"

#define BUILDING_STATE_NONSTATIC_RESOURCE_SIZE (RESOURCE_MAX * 3)

#define BUILDING_STATE_ORIGINAL_BUFFER_SIZE 128
#define BUILDING_STATE_TOURISM_BUFFER_SIZE (BUILDING_STATE_ORIGINAL_BUFFER_SIZE + 6) // 134
#define BUILDING_STATE_VARIANTS_AND_UPGRADES (BUILDING_STATE_TOURISM_BUFFER_SIZE + 2) // 136
#define BUILDING_STATE_STRIKES (BUILDING_STATE_VARIANTS_AND_UPGRADES + 1) // 137
#define BUILDING_STATE_SICKNESS (BUILDING_STATE_STRIKES + 5) // 142
#define BUILDING_STATE_WITHOUT_RESOURCES (BUILDING_STATE_SICKNESS - RESOURCE_MAX_LEGACY) // 126 (plus variable resource size)
#define BUILDING_STATE_DYNAMIC_RESOURCES (BUILDING_STATE_WITHOUT_RESOURCES + BUILDING_STATE_NONSTATIC_RESOURCE_SIZE)
#define BUILDING_STATE_CURRENT_BUFFER_SIZE (BUILDING_STATE_DYNAMIC_RESOURCES + 8)

void building_state_save_to_buffer(buffer *buf, const building *b);

void building_state_load_from_buffer(buffer *buf, building *b, int building_buf_size, int save_version, int for_preview);

#endif // BUILDING_BUILDING_STATE_H
