// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, CicpRange, ColorState};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GdkCicpParams")]
    pub struct CicpParams(Object<ffi::GdkCicpParams, ffi::GdkCicpParamsClass>);

    match fn {
        type_ => || ffi::gdk_cicp_params_get_type(),
    }
}

impl CicpParams {
    #[doc(alias = "gdk_cicp_params_new")]
    pub fn new() -> CicpParams {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gdk_cicp_params_new()) }
    }

    #[doc(alias = "gdk_cicp_params_build_color_state")]
    pub fn build_color_state(&self) -> Result<ColorState, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gdk_cicp_params_build_color_state(self.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gdk_cicp_params_get_color_primaries")]
    #[doc(alias = "get_color_primaries")]
    #[doc(alias = "color-primaries")]
    pub fn color_primaries(&self) -> u32 {
        unsafe { ffi::gdk_cicp_params_get_color_primaries(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cicp_params_get_matrix_coefficients")]
    #[doc(alias = "get_matrix_coefficients")]
    #[doc(alias = "matrix-coefficients")]
    pub fn matrix_coefficients(&self) -> u32 {
        unsafe { ffi::gdk_cicp_params_get_matrix_coefficients(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cicp_params_get_range")]
    #[doc(alias = "get_range")]
    pub fn range(&self) -> CicpRange {
        unsafe { from_glib(ffi::gdk_cicp_params_get_range(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cicp_params_get_transfer_function")]
    #[doc(alias = "get_transfer_function")]
    #[doc(alias = "transfer-function")]
    pub fn transfer_function(&self) -> u32 {
        unsafe { ffi::gdk_cicp_params_get_transfer_function(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cicp_params_set_color_primaries")]
    #[doc(alias = "color-primaries")]
    pub fn set_color_primaries(&self, color_primaries: u32) {
        unsafe {
            ffi::gdk_cicp_params_set_color_primaries(self.to_glib_none().0, color_primaries);
        }
    }

    #[doc(alias = "gdk_cicp_params_set_matrix_coefficients")]
    #[doc(alias = "matrix-coefficients")]
    pub fn set_matrix_coefficients(&self, matrix_coefficients: u32) {
        unsafe {
            ffi::gdk_cicp_params_set_matrix_coefficients(
                self.to_glib_none().0,
                matrix_coefficients,
            );
        }
    }

    #[doc(alias = "gdk_cicp_params_set_range")]
    #[doc(alias = "range")]
    pub fn set_range(&self, range: CicpRange) {
        unsafe {
            ffi::gdk_cicp_params_set_range(self.to_glib_none().0, range.into_glib());
        }
    }

    #[doc(alias = "gdk_cicp_params_set_transfer_function")]
    #[doc(alias = "transfer-function")]
    pub fn set_transfer_function(&self, transfer_function: u32) {
        unsafe {
            ffi::gdk_cicp_params_set_transfer_function(self.to_glib_none().0, transfer_function);
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "color-primaries")]
    pub fn connect_color_primaries_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_color_primaries_trampoline<F: Fn(&CicpParams) + 'static>(
            this: *mut ffi::GdkCicpParams,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::color-primaries".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_color_primaries_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "matrix-coefficients")]
    pub fn connect_matrix_coefficients_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_matrix_coefficients_trampoline<F: Fn(&CicpParams) + 'static>(
            this: *mut ffi::GdkCicpParams,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::matrix-coefficients".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_matrix_coefficients_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "range")]
    pub fn connect_range_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_range_trampoline<F: Fn(&CicpParams) + 'static>(
            this: *mut ffi::GdkCicpParams,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::range".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_range_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
    #[doc(alias = "transfer-function")]
    pub fn connect_transfer_function_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_transfer_function_trampoline<F: Fn(&CicpParams) + 'static>(
            this: *mut ffi::GdkCicpParams,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::transfer-function".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_transfer_function_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v4_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_16")))]
impl Default for CicpParams {
    fn default() -> Self {
        Self::new()
    }
}
