<?php
/**
 * Show and modify photos
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jason Geiger
 * @author Jeroen Roos
 */

use conf\conf;
use geo\map;
use photo\controller;
use web\request;

require_once "include.inc.php";

$request = request::create();
$controller = new controller($request);
$photo=$controller->getObject();
switch ($controller->getView()) {
case "confirm":
    $view=new photo\view\confirm($request, $photo);
    $title=translate("delete photo");
    break;
case "display":
    $view=new photo\view\display($request, $photo);
    $view->photocount=$controller->photocount;
    $view->offset=$controller->offset;
    $view->setLinks();
    $title = $photo->get("name");
    break;
case "update":
    $view=new photo\view\update($request, $photo);
    $title = $photo->get("name");
    break;
case "redirect":
    $view=new photo\view\redirect($request, $photo);
    $view->setRedirect($controller->redirect);
    $title = translate("Redirect");
    echo $view->view();
    end;
    break;
case "notfound":
    $view=new photo\view\notfound($request);
    $title = translate("Photo not found");
    break;
}
require_once "header.inc.php";
echo $view->view();
require_once "footer.inc.php";
