package ONVIF::PTZ::Types::BackupFile;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %Data_of :ATTR(:get<Data>);

__PACKAGE__->_factory(
    [ qw(        Name
        Data

    ) ],
    {
        'Name' => \%Name_of,
        'Data' => \%Data_of,
    },
    {
        'Name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Data' => 'ONVIF::PTZ::Types::AttachmentData',
    },
    {

        'Name' => 'Name',
        'Data' => 'Data',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::BackupFile

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BackupFile from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Name


=item * Data




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::BackupFile
   Name =>  $some_value, # string
   Data =>  { # ONVIF::PTZ::Types::AttachmentData
     Include =>  { # ONVIF::PTZ::Types::Include
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

