/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LocatorPrxHelper;
import Ice.LoggerI;
import Ice.RouterPrxHelper;
import Ice.StringHolder;
import Ice.StringSeqHolder;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactory;
import IceInternal.LocatorManager;
import IceInternal.ObjectAdapterFactory;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProxyFactory;
import IceInternal.ReferenceFactory;
import IceInternal.RouterManager;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class Instance {
    private int _state = 0;
    private final InitializationData _initData;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ObjectAdapterFactory _objectAdapterFactory;
    private final int _threadPerConnectionStackSize;
    private EndpointFactory _endpointFactory;
    private static boolean _oneOffDone = false;

    public InitializationData initializationData() {
        return this._initData;
    }

    public TraceLevels traceLevels() {
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._referenceFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._outgoingConnectionFactory;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._objectAdapterFactory;
    }

    public synchronized EndpointFactory endpointFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._endpointFactory;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ObjectAdapterFactory objectAdapterFactory;
        OutgoingConnectionFactory outgoingConnectionFactory;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            outgoingConnectionFactory = this._outgoingConnectionFactory;
            objectAdapterFactory = this._objectAdapterFactory;
        }
        outgoingConnectionFactory.flushBatchRequests();
        objectAdapterFactory.flushBatchRequests();
    }

    public Identity stringToIdentity(String string) {
        Identity identity = new Identity();
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(47, n2)) != -1) {
            if (n2 == 0 || string.charAt(n2 - 1) != '\\') {
                if (n == -1) {
                    n = n2;
                } else {
                    IdentityParseException identityParseException = new IdentityParseException();
                    identityParseException.str = string;
                    throw identityParseException;
                }
            }
            ++n2;
        }
        if (n == -1) {
            StringHolder stringHolder = new StringHolder();
            if (!StringUtil.unescapeString(string, 0, string.length(), stringHolder)) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = string;
                throw identityParseException;
            }
            identity.category = "";
            identity.name = stringHolder.value;
        } else {
            StringHolder stringHolder = new StringHolder();
            if (!StringUtil.unescapeString(string, 0, n, stringHolder)) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = string;
                throw identityParseException;
            }
            identity.category = stringHolder.value;
            if (n + 1 < string.length()) {
                if (!StringUtil.unescapeString(string, n + 1, string.length(), stringHolder)) {
                    IdentityParseException identityParseException = new IdentityParseException();
                    identityParseException.str = string;
                    throw identityParseException;
                }
                identity.name = stringHolder.value;
            } else {
                identity.name = "";
            }
        }
        return identity;
    }

    public String identityToString(Identity identity) {
        if (identity.category.length() == 0) {
            return StringUtil.escapeString(identity.name, "/");
        }
        return StringUtil.escapeString(identity.category, "/") + '/' + StringUtil.escapeString(identity.name, "/");
    }

    public Instance(Communicator communicator, InitializationData initializationData) {
        this._initData = initializationData;
        try {
            if (this._initData.logger == null) {
                this._initData.logger = new LoggerI(this._initData.properties.getProperty("Ice.ProgramName"));
            }
            this.validatePackages();
            this._traceLevels = new TraceLevels(this._initData.properties);
            this._defaultsAndOverrides = new DefaultsAndOverrides(this._initData.properties);
            int n = this._initData.properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
            this._messageSizeMax = n < 1 ? 0x100000 : (n > 0x1FFFFF ? Integer.MAX_VALUE : n * 1024);
            int n2 = this._initData.properties.getPropertyAsInt("Ice.ThreadPerConnection.StackSize");
            if (n2 < 0) {
                n2 = 0;
            }
            this._threadPerConnectionStackSize = n2;
            this._routerManager = new RouterManager();
            this._locatorManager = new LocatorManager();
            this._referenceFactory = new ReferenceFactory(this, communicator);
            this._proxyFactory = new ProxyFactory(this);
            this._endpointFactory = new EndpointFactory(this);
            this._outgoingConnectionFactory = new OutgoingConnectionFactory(this);
            this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
        }
        catch (LocalException localException) {
            this.destroy();
            throw localException;
        }
    }

    public void finishSetup(StringSeqHolder stringSeqHolder) {
        if (this._defaultsAndOverrides.defaultRouter.length() > 0) {
            this._referenceFactory.setDefaultRouter(RouterPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultRouter)));
        }
        if (this._defaultsAndOverrides.defaultLocator.length() > 0) {
            this._referenceFactory.setDefaultLocator(LocatorPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultLocator)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Instance instance = this;
        synchronized (instance) {
            if (this._state != 0) {
                return;
            }
            this._state = 1;
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.shutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.destroy();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.destroy();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.waitUntilFinished();
        }
        instance = this;
        synchronized (instance) {
            this._objectAdapterFactory = null;
            this._outgoingConnectionFactory = null;
            if (this._referenceFactory != null) {
                this._referenceFactory.destroy();
                this._referenceFactory = null;
            }
            this._proxyFactory = null;
            if (this._routerManager != null) {
                this._routerManager.destroy();
                this._routerManager = null;
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
                this._locatorManager = null;
            }
            if (this._endpointFactory != null) {
                this._endpointFactory.destroy();
                this._endpointFactory = null;
            }
            this._state = 2;
        }
    }

    private void validatePackages() {
        Hashtable hashtable = this._initData.properties.getPropertiesForPrefix("Ice.Package.");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string.length() == "Ice.Package.".length()) {
                this._initData.logger.warning("ignoring invalid property: " + string + "=" + string2);
            }
            String string3 = string.substring("Ice.Package.".length());
            String string4 = string2 + "." + string3 + "._Marker";
            try {
                Class.forName(string4);
            }
            catch (Exception exception) {
                this._initData.logger.warning("unable to validate package: " + string + "=" + string2);
            }
        }
    }
}

