/*! \file html.c
    \brief HTML output for xlhtml
*/

/*
   Copyright 2002  Charles N Wyble  <jackshck@thewybles.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include "xlhtml.h"
#include "support.h"
#include <stdio.h>



/* prototypes for functions in this file */
void output_header(void);
void output_footer(void);


void OutputTableHTML(void)
{
	int i, j, k;

	output_header();
	if (center_tables)
	{
		printf("<CENTER>");
		do_cr();
	}

	SetupExtraction();

	/* Here's where we dump the Html Page out */
	for (i=first_sheet; i<=last_sheet; i++)	/* For each worksheet */
	{
		update_default_font(i);
		if (ws_array[i] == 0)
			continue;
		if ((ws_array[i]->biggest_row == -1)||(ws_array[i]->biggest_col == -1))
			continue;
		if (ws_array[i]->c_array == 0)
			continue;
		trim_sheet_edges(i);

		/* Print its name */
		if (next_ws_title > 0)
		{
			if (ws_array[i]->ws_title.str)
			{
				printf("<CENTER><H1>");
				OutputString(&ws_array[i]->ws_title);
				printf("</H1></CENTER><br>");
				do_cr();
			}
			else
			{
				printf("<H1><CENTER>(Unknown Page)</CENTER></H1><br>");
				do_cr();
			}
		}

		/* Now dump the table */
		printf("<FONT FACE=\"");
		OutputString(&default_font);
		if (default_fontsize != 3)
			printf("\" SIZE=\"%d", default_fontsize);
		printf("\">");
		do_cr();
		printf("<TABLE BORDER=\"1\" CELLSPACING=\"2\">");
		do_cr();
		for (j=ws_array[i]->first_row; j<=ws_array[i]->biggest_row; j++)
		{
			update_default_alignment(i, j);
			printf("<TR");
			if (null_string((U8 *)default_alignment))
				printf(">");
			else
			{
				if (strcmp(default_alignment, "left") != 0)
					printf(" ALIGN=\"%s\"", default_alignment);
				if (!aggressive)
					printf(" VALIGN=\"bottom\">\n");
				else
					printf(">");
			}
			for (k=ws_array[i]->first_col; k<=ws_array[i]->biggest_col; k++)
			{
				output_cell(ws_array[i]->c_array[(j*ws_array[i]->max_cols)+k],0); /* This stuff happens for each cell... */
				if (ws_array[i]->c_array[(j*ws_array[i]->max_cols)+k])
				{
					if (ws_array[i]->c_array[(j*ws_array[i]->max_cols)+k]->colspan != 0)
						 k += ws_array[i]->c_array[(j*ws_array[i]->max_cols)+k]->colspan-1;
				}
			}

			if (!aggressive)
				printf("</TR>\n");
		}
		printf("</TABLE></FONT><HR>");
		do_cr();
	}

	if (center_tables)
	{
		printf("</CENTER>");
		do_cr();
	}

	/* Print the author's name in itallics... */
	if (author.str)
	{
		printf("<FONT SIZE=\"-1\"><I>Spreadsheet's Author:&nbsp;");
		OutputString(&author);
		printf("</I></FONT><br>");
		do_cr();
	}

	/* Print when & how the file was last updated. */
	printf("<FONT SIZE=\"-1\"><I>Last Updated ");
	if (lastUpdated)
		printf("%s&nbsp; ", lastUpdated);
	switch (file_version)
	{
		case EXCEL95:
			printf("with Excel 5.0 or 95");
			break;
		case EXCEL97:
			printf("with Excel 97");
			break;
		default:
			printf("with Excel ????");
			break;
	}
	printf("</I></FONT><br>");
	do_cr();

	/* Next print Disclaimers... */
	if (NoFormat)
	{
		printf("<br>* This cell's format is not supported.<br>");
		do_cr();
	}
	if ((notAccurate)&&(formula_warnings))
	{
		printf("<br>** This cell's data may not be accurate.<br>");
		do_cr();
	}
	if (NotImplemented)
	{
		printf("<br>*** This cell's data type will be supported in the future.<br>");
		do_cr();
	}
	if (Unsupported)
	{
		printf("<br>**** This cell's type is unsupported.<br>");
		do_cr();
	}

	/* Now out exceeded capacity warnings... */
	if (MaxWorksheetsExceeded || MaxRowExceeded || MaxColExceeded || MaxStringsExceeded ||
		MaxFontsExceeded || MaxPalExceeded || MaxXFExceeded || MaxFormatsExceeded )
		printf("<FONT COLOR=\"%s\">", colorTab[0x0A]);
	if (MaxWorksheetsExceeded)
	{
		printf("The Maximum Number of Worksheets was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxRowExceeded)
	{
		printf("The Maximum Number of Rows was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxColExceeded)
	{
		printf("The Maximum Number of Columns was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxStringsExceeded)
	{
		printf("The Maximum Number of Strings was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxFontsExceeded)
	{
		printf("The Maximum Number of Fonts was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxPalExceeded)
	{
		printf("The Maximum Number of Color Palettes was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxXFExceeded)
	{
		printf("The Maximum Number of Extended Formats was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxFormatsExceeded)
	{
		printf("The Maximum Number of Formats was exceeded, you might want to increase it.<br>");
		do_cr();
	}
	if (MaxWorksheetsExceeded || MaxRowExceeded || MaxColExceeded || MaxStringsExceeded ||
		MaxFontsExceeded || MaxPalExceeded || MaxXFExceeded || MaxFormatsExceeded )
		printf("</FONT>");

	printf("&nbsp;<br>");
	do_cr();

	/* Output Credit */
	printf("<hr><FONT SIZE=\"-1\">Created with <a href=\"http://chicago.sf.net/xlhtml\">xlhtml %s</a></FONT><br>", VERSION);
	do_cr();

	/* Output Tail */
	output_footer();
}

void output_header(void)
{	/* Ouput Header */
	if (NoHeaders)
		return;
	if (!aggressive)
	{
		printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML Transitional//EN\"");
		do_cr();
		printf("\"http://www.w3.org/TR/REC-html40/loose.dtd\">");
		do_cr();
	}
	printf("<HTML>\n");
	printf("<HEAD>\n");
	do_cr();
	printf("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
	if ((UnicodeStrings <= 1)&&CodePage&&(CodePage != 1252))
		printf("windows-%d\">", CodePage);
	else
	{
		switch (UnicodeStrings)
		{
			case 0:
				printf("iso-8859-1\">");		/* Latin-1 */
				break;
			case 1:
				printf("windows-1252\">");	/* Microsoft */
				break;
			default:
				printf("utf-8\">");			/* Unicode */
				break;
		}
	}
	do_cr();

	if (!aggressive)
	{
		printf("<meta name=\"GENERATOR\" content=\"xlhtml\">");
		do_cr();
	}
	printf("<TITLE>");
	if (title)
		printf("%s", title);
	else
		printf("%s", filename);
	printf("</TITLE>");
	do_cr();
	printf("</HEAD>");
	do_cr();
	do_cr();
	printf("<BODY TEXT=\"#%s\" BGCOLOR=\"#%s\"",
				default_text_color, default_background_color);
	if (default_image)
		printf("BACKGROUND=\"%s\"", default_image);
	printf("><br>");
	do_cr();
}

void output_footer(void)
{
	if (NoHeaders)
		return;
	printf("</BODY></HTML>");
	do_cr();
	fflush(stdout);
}

void output_start_html_attr(html_attr *h, unsigned int fnt_idx, int do_underlines)
{
	if (fnt_idx < next_font)
	{
		if (((font_array[fnt_idx]->underline&0x0023) > 0)&&(do_underlines))
		{
			printf("<U>");
			h->uflag = 1;
		}
		if (font_array[fnt_idx]->bold >= 0x02BC)
		{
			h->bflag = 1;
			printf("<B>");
		}
		if (font_array[fnt_idx]->attr & 0x0002)
		{
			h->iflag = 1;
			printf("<I>");
		}
		if (font_array[fnt_idx]->attr & 0x0008)
		{
			h->sflag = 1;
			printf("<S>");
		}
		if ((font_array[fnt_idx]->super & 0x0003) == 0x0001)
		{
			h->spflag = 1;
			printf("<SUP>");
		}
		else if ((font_array[fnt_idx]->super & 0x0003) == 0x0002)
		{
			h->sbflag = 1;
			printf("<SUB>");
		}
	}
}

void output_end_html_attr(html_attr *h)
{
	if (h->sbflag)
	{
		printf("</SUB>");
		h->sbflag = 0;
	}
	else if (h->spflag)
	{
		printf("</SUP>");
		h->spflag = 0;
	}
	if (h->sflag)
	{
		printf("</S>");
		h->sflag = 0;
	}
	if (h->iflag)
	{
		printf("</I>");
		h->iflag = 0;
	}
	if (h->bflag)
	{
		printf("</B>");
		h->bflag = 0;
	}
	if (h->uflag)
	{
		if (h->uflag == 1)
			printf("</U>");
		else
			printf("</A>");
		h->uflag = 0;
	}
	if (h->fflag)
	{
		printf("</FONT>");
		h->fflag = 0;
	}
}
