;;; synfl-trace.el --- a program-tracing facility for synfl

;; Copyright (C) 2004 Stephen J. Turnbull

;; Author: Stephen J. Turnbull <stephen@xemacs.org>
;; Created: 7 May 2004
;; Keywords: debug

;; This file is part of synfl.
;; This file is not part of XEmacs.

;; synfl is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License, version 2, as
;; published by the Free Software Foundation.

;; synfl is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Emacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in GNU Emacs
 
;;; Commentary:

;; This is actually a fairly generic facility, as of 2004-05-07 lightly
;; tied to the synfl LR-parser-based font-locker in development.

(defvar synfl-trace nil
  "Features of synfl to trace.

May be a list of symbols, nil to suppress tracing, or t to trace everything.
Use `synfl-trace-p' to check features.")


;;; Utility functions:

(defun synfl-trace-p (features)
  "Return non-nil if the intersection of FEATURES and `synfl-trace' is non-nil.
`t' is an abbreviation for the set of all features."
  (and synfl-trace
       features
       (or (eq features t)
	   (eq synfl-trace t)
	   (catch 'true
	     (mapc (lambda (x) (when (memq x synfl-trace) (throw 'true t)))
		   features)
	     nil))))


;;; Tracing

(put 'synfl-trace 'lisp-indent-function 1)

(defun synfl-trace (features spec &rest args)
  "Print a trace for FEATURES formatted from SPEC and ARGS using `princ'.

FEATURES is a list of symbols, and if any appears in `synfl-trace' the message
will be printed.  As a special case, `t' is treated as all symbols.  \(Ie, it
will force tracing unless `synfl-trace' is null.)
SPEC and ARGS will be passed to `format' verbatim.
Do not use this function for ordinary messages, as it may be disabled at
compile time for efficiency."
  (when (synfl-trace-p features)
    (princ (apply #'format spec args))))


(provide 'synfl-trace)
