# Coding Conventions

* Use 4 spaces for indentation.
* Code conforms to PEP8. Use pep8 or pycodestyle with their default settings to check for compliance. Consider using a pre-commit hook to prevent non-conforming code from entering the repo.
* Avoid inline comments, prefer (short) block comments.
* Add documentation strings to function if required.
* If you want, add yourself to the AUTHORS file.

# Commit Conventions

* Follow [conventional commit](https://www.conventionalcommits.org) message guidelines.
* Scopes for commit messages are `etc`, `src` and file names from the root directory. Take a look at git log to get an impression.
* You can ignore the 50 chars limit for the first line of a commit message and obey to a hard limit of 72 chars.
