/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Animator;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ExpressionInput;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Crosshair;
import edu.hws.jcm.draw.ParametricCurve;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Parametric
extends GenericGraphApplet {
    private Function xFunc;
    private Function yFunc;
    private ParametricCurve graph;
    private Animator tracer;
    private Crosshair crosshair;
    private VariableInput tMin;
    private VariableInput tMax;
    private VariableInput tIntervals;
    private ExpressionInput functionInput2;

    protected void setUpParameterDefaults() {
        this.parameterDefaults = new Hashtable();
        this.parameterDefaults.put("TwoLimitsColumns", "yes");
        this.parameterDefaults.put("Variable", "t");
        this.parameterDefaults.put("XName", "x");
        this.parameterDefaults.put("FunctionLabel", "  " + this.getParameter("XName") + "(" + this.getParameter("Variable") + ") = ");
        this.parameterDefaults.put("FunctionLabel2", "  " + this.getParameter("YName", "y") + "(" + this.getParameter("Variable") + ") = ");
    }

    protected void setUpCanvas() {
        Object object;
        Object object2;
        super.setUpCanvas();
        if (this.functionInput != null) {
            this.xFunc = this.functionInput.getFunction(this.xVar);
            this.yFunc = this.functionInput2.getFunction(this.xVar);
        } else {
            object2 = " cos(" + this.xVar.getName() + ") + cos(3*" + this.xVar.getName() + ")";
            object = " sin(4*" + this.xVar.getName() + ") - sin(2*" + this.xVar.getName() + ")";
            object2 = this.getParameter("Function", (String)object2);
            object = this.getParameter("Function2", (String)object);
            SimpleFunction simpleFunction = new SimpleFunction((Expression)this.parser.parse((String)object2), this.xVar);
            this.xFunc = new WrapperFunction(simpleFunction);
            simpleFunction = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
            this.yFunc = new WrapperFunction(simpleFunction);
        }
        this.graph = new ParametricCurve(this.xFunc, this.yFunc);
        object2 = this.getColorParam("CurveColor");
        if (object2 != null) {
            this.graph.setColor((Color)object2);
        }
        if ("no".equalsIgnoreCase(this.getParameter("UseParamInputs", "yes"))) {
            this.tMin = new VariableInput(this.xVar.getName() + "Start", this.getParameter("ParameterMin", "-2"));
            this.tMax = new VariableInput(this.xVar.getName() + "End", this.getParameter("ParameterMax", "2"));
            this.tIntervals = new VariableInput("Intervals", this.getParameter("Intervals", "200"));
            this.tIntervals.setInputStyle(2);
            this.tIntervals.setMin(1.0);
            this.tIntervals.setMax(5000.0);
            this.tMin.setOnUserAction(this.mainController);
            this.tMax.setOnUserAction(this.mainController);
            this.tIntervals.setOnUserAction(this.mainController);
            this.graph.setTMin(this.tMin);
            this.graph.setTMax(this.tMax);
            this.graph.setIntervals(this.tIntervals);
            if (this.limitsPanel != null) {
                this.mainController.add(this.tMin);
                this.mainController.add(this.tMax);
                this.mainController.add(this.tIntervals);
            } else {
                object = new JCMPanel(9, 0);
                ((Component)object).setBackground(this.getColorParam("PanelBackground", Color.lightGray));
                ((Container)object).add(new Label(this.tMin.getName()));
                ((Container)object).add(this.tMin);
                ((Container)object).add(new Label());
                ((Container)object).add(new Label(this.tMax.getName()));
                ((Container)object).add(this.tMax);
                ((Container)object).add(new Label());
                ((Container)object).add(new Label(this.tIntervals.getName()));
                ((Container)object).add(this.tIntervals);
                ((Container)object).add(new Label());
                this.mainPanel.add((Component)object, "East");
            }
        } else {
            try {
                this.graph.setTMin(new Constant(new Double(this.getParameter("ParameterMin", "-2"))));
                this.graph.setTMax(new Constant(new Double(this.getParameter("ParameterMax", "2"))));
                this.graph.setIntervals(new Constant(new Double(this.getParameter("Intervals", "25"))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseTracer", "yes"))) {
            this.tracer = new Animator();
            this.tracer.setMin(this.graph.getTMin());
            this.tracer.setMax(this.graph.getTMax());
            this.tracer.setUndefinedWhenNotRunning(true);
            this.tracer.setStartButtonName("Trace Curve!");
            object = this.getNumericParam("TracerIntervals");
            int n = object == null || ((Object)object).length != 1 ? 100 : (int)Math.round((double)object[0]);
            if (n <= 0) {
                this.tracer.setIntervals(this.graph.getIntervals());
            } else {
                this.tracer.setIntervals(n);
            }
            Variable variable = this.tracer.getValueAsVariable();
            this.crosshair = new Crosshair((Value)new ValueMath(this.xFunc, variable), new ValueMath(this.yFunc, variable));
            this.crosshair.setLineWidth(3);
            this.crosshair.setColor(this.getColorParam("CrosshairColor", Color.gray));
            this.canvas.add(this.crosshair);
            if (this.inputPanel != null) {
                this.inputPanel.add((Component)this.tracer, "West");
            } else if (this.limitsPanel == null) {
                Panel panel = new Panel();
                panel.add(this.tracer);
                this.mainPanel.add((Component)panel, "South");
            }
        }
        this.canvas.add(this.graph);
    }

    protected void setUpLimitsPanel() {
        super.setUpLimitsPanel();
        if (this.limitsPanel != null && this.tMin != null) {
            this.limitsPanel.addComponentPair(this.tMin, this.tMax);
            this.limitsPanel.addComponent(this.tIntervals);
        }
        if (this.inputPanel == null && this.tracer != null && this.limitsPanel != null) {
            this.limitsPanel.addComponent(this.tracer);
        }
    }

    protected void setUpBottomPanel() {
        if (!"no".equalsIgnoreCase(this.getParameter("UseFunctionInput", "yes"))) {
            JCMPanel jCMPanel;
            String string;
            this.inputPanel = new JCMPanel();
            this.inputPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
            JCMPanel jCMPanel2 = new JCMPanel(2, 1);
            this.inputPanel.add((Component)jCMPanel2, "Center");
            if (!"no".equalsIgnoreCase(this.getParameter("UseComputeButton", "yes"))) {
                string = this.getParameter("ComputeButtonName", "New Functions");
                this.computeButton = new Button(string);
                this.inputPanel.add((Component)this.computeButton, "East");
                this.computeButton.addActionListener(this);
            }
            string = this.getParameter("Variable");
            String string2 = this.getParameter("Function");
            if (string2 == null) {
                string2 = "cos(" + string + ") + cos(3*" + string + ")";
            }
            this.functionInput = new ExpressionInput(string2, this.parser);
            String string3 = this.getParameter("FunctionLabel");
            if ("none".equalsIgnoreCase(string3)) {
                jCMPanel2.add(this.functionInput);
            } else {
                jCMPanel = new JCMPanel();
                jCMPanel.add((Component)this.functionInput, "Center");
                jCMPanel.add((Component)new Label(string3), "West");
                jCMPanel2.add(jCMPanel);
            }
            string2 = this.getParameter("Function2");
            if (string2 == null) {
                string2 = "sin(4*" + string + ") - sin(2*" + string + ")";
            }
            this.functionInput2 = new ExpressionInput(string2, this.parser);
            string3 = this.getParameter("FunctionLabel2");
            if ("none".equalsIgnoreCase(string3)) {
                jCMPanel2.add(this.functionInput2);
            } else {
                jCMPanel = new JCMPanel();
                jCMPanel.add((Component)this.functionInput2, "Center");
                jCMPanel.add((Component)new Label(string3), "West");
                jCMPanel2.add(jCMPanel);
            }
            this.mainPanel.add((Component)this.inputPanel, "South");
            this.functionInput.setOnUserAction(this.mainController);
            this.functionInput2.setOnUserAction(this.mainController);
        }
    }

    protected void setUpMainPanel() {
        super.setUpMainPanel();
        if (this.tracer == null) {
            return;
        }
        Controller controller = new Controller();
        controller.add(this.tracer);
        controller.add(this.crosshair);
        this.tracer.setOnChange(controller);
    }

    protected void doLoadExample(String string) {
        Object object;
        Object object2;
        int n;
        if (this.tracer != null) {
            this.tracer.stop();
        }
        if ((n = string.indexOf(";")) == -1) {
            return;
        }
        String string2 = string.substring(n + 1);
        string = string.substring(0, n);
        n = string2.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            int n2;
            object2 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
            object = new StringTokenizer((String)object2, " ,");
            if (((StringTokenizer)object).countTokens() >= 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    try {
                        Double d = new Double(((StringTokenizer)object).nextToken());
                        dArray[n2] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    double d = new Double(((StringTokenizer)object).nextToken());
                    if (this.tMin == null) {
                        this.graph.setTMin(new Constant(d));
                        if (this.tracer != null) {
                            this.tracer.setMin(d);
                        }
                    } else {
                        this.tMin.setVal(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    double d = new Double(((StringTokenizer)object).nextToken());
                    if (this.tMax == null) {
                        this.graph.setTMax(new Constant(d));
                        if (this.tracer != null) {
                            this.tracer.setMax(d);
                        }
                    } else {
                        this.tMax.setVal(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    n2 = (int)Math.round(new Double(((StringTokenizer)object).nextToken()));
                    if (this.tIntervals == null) {
                        if (this.tracer != null && this.tracer.getIntervals() == this.graph.getIntervals()) {
                            this.tracer.setIntervals(n2);
                        }
                        this.graph.setIntervals(new Constant(n2));
                    } else {
                        this.tIntervals.setVal(n2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
            this.functionInput2.setText(string2);
        } else {
            try {
                object2 = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.xFunc).setFunction((Function)object2);
                object = new SimpleFunction((Expression)this.parser.parse(string2), this.xVar);
                ((WrapperFunction)this.yFunc).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object2 = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object2).setLimits(dArray);
        ((CoordinateRect)object2).setRestoreBuffer();
        this.mainController.compute();
    }

    public void stop() {
        if (this.tracer != null) {
            this.tracer.stop();
        }
        super.stop();
    }
}

