/**
 * GraphImg.java
 *
 * Created on Jul 3, 2006
 */
package graphe;

import java.awt.image.BufferedImage;

import maths.CoordSyst;
import maths.Fonction;

/**
 * Cette interface represente le graphe d'une fonction qui produit
 * physiquement une image. Un tel objet a besoin d'une {@link maths.Fonction fonction},
 * d'un {@link maths.CoordSyst systeme de coordonees} et {@link graphe.GraphCol palette de couleurs}.
 *
 * @author Nicolae
 */
public interface GraphImg {
	
	/**
	 * Etablit la fonction a utiliser.
	 *
	 * @param f la fonction.
	 */
	public void setFonction(Fonction f);
		
	/**
	 * Etablit le systeme de coordonees.
	 *
	 * @param coo le systeme de coordonees.
	 */
	public void setCoords(CoordSyst coo);
		
	/**
	 * Renvoie le systeme de coordonees.
	 *
	 * @return systeme de coordonees.
	 */
	public CoordSyst getCoords();
	
	/**
	 * Etablit la palette de couleurs.
	 *
	 * @param col la palette de couleurs.
	 */
	public void setColors(GraphCol col);
		
	/**
	 * Renvoie le graphe de la fonction sous la forme d'une image.
	 *
	 * @return le graphe, <code>null</code> s'il n'as pas tous les elements pour le calculer.
	 */
	public BufferedImage getImage();
}
