/* Webcamoid, webcam capture application.
 * Copyright (C) 2017  Gonzalo Exequiel Pedone
 *
 * Webcamoid is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Webcamoid is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webcamoid. If not, see <http://www.gnu.org/licenses/>.
 *
 * Web-Site: http://webcamoid.github.io/
 */

#include "desktopcaptureelementsettings.h"
#include "desktopcaptureglobals.h"

Q_GLOBAL_STATIC(DesktopCaptureGlobals, globalDesktopCapture)

DesktopCaptureElementSettings::DesktopCaptureElementSettings(QObject *parent):
    QObject(parent)
{
    QObject::connect(globalDesktopCapture,
                     &DesktopCaptureGlobals::captureLibChanged,
                     this,
                     &DesktopCaptureElementSettings::captureLibChanged);
}

QString DesktopCaptureElementSettings::captureLib() const
{
    return globalDesktopCapture->captureLib();
}

QStringList DesktopCaptureElementSettings::subModules() const
{
    return globalDesktopCapture->subModules();
}

void DesktopCaptureElementSettings::setCaptureLib(const QString &captueLib)
{
    globalDesktopCapture->setCaptureLib(captueLib);
}

void DesktopCaptureElementSettings::resetCaptureLib()
{
    globalDesktopCapture->resetCaptureLib();
}

#include "moc_desktopcaptureelementsettings.cpp"
