/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.EmptyStackException;

public class BooleanStack {
    private static final int STACK_START_SIZE = 20;
    private static final int STACK_INCREMENT = 5;
    private boolean[] stackContents;
    private int topOfStack;

    public BooleanStack() {
        this(20);
    }

    public BooleanStack(int n) {
        this.stackContents = new boolean[n];
        this.topOfStack = -1;
    }

    public int size() {
        return this.topOfStack + 1;
    }

    public boolean isEmpty() {
        return this.topOfStack == -1;
    }

    public void push(boolean bl) {
        this.resizeStack();
        this.stackContents[++this.topOfStack] = bl;
    }

    public boolean peek() throws EmptyStackException {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        return this.stackContents[this.topOfStack];
    }

    public boolean pop() {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        boolean bl = this.stackContents[this.topOfStack];
        --this.topOfStack;
        return bl;
    }

    public void clear() {
        this.topOfStack = -1;
    }

    private final void resizeStack() {
        int n = this.stackContents.length;
        if (this.topOfStack + 1 == n) {
            int n2 = n + 5;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.stackContents, 0, blArray, 0, n);
            this.stackContents = blArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BooleanStack: size: ");
        stringBuffer.append(this.topOfStack + 1);
        stringBuffer.append(" vals: ");
        for (int i = 0; i <= this.topOfStack; ++i) {
            stringBuffer.append(this.stackContents[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

