/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import org.ietf.uri.ContentHandler;
import org.ietf.uri.ResourceManager;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.ietf.uri.event.ProgressListenerMulticaster;

public abstract class ResourceConnection {
    private static final byte[] EMPTY_HEADER = new byte[0];
    protected URI uri;
    protected boolean connected = false;
    private String name_string = null;
    private ProgressListener progress_listener = null;
    private static ProgressListener global_listener = null;
    private ContentHandler last_content_handler = null;

    protected ResourceConnection(URI uRI) {
        this.uri = uRI;
    }

    protected void notifyConnectionEstablished(String string) {
        if (this.progress_listener != null || global_listener != null) {
            ProgressEvent progressEvent = new ProgressEvent(this, 1, string, -1);
            if (this.progress_listener != null) {
                this.progress_listener.connectionEstablished(progressEvent);
            }
            if (global_listener != null) {
                global_listener.connectionEstablished(progressEvent);
            }
        }
    }

    protected void notifyHandshakeInProgress(String string) {
        if (this.progress_listener != null || global_listener != null) {
            ProgressEvent progressEvent = new ProgressEvent(this, 2, string, -1);
            if (this.progress_listener != null) {
                this.progress_listener.handshakeInProgress(progressEvent);
            }
            if (global_listener != null) {
                global_listener.handshakeInProgress(progressEvent);
            }
        }
    }

    void sendStartEvent(ProgressEvent progressEvent) {
        if (this.progress_listener != null) {
            this.progress_listener.downloadStarted(progressEvent);
        }
        if (global_listener != null) {
            global_listener.downloadStarted(progressEvent);
        }
    }

    void sendUpdateEvent(ProgressEvent progressEvent) {
        if (this.progress_listener != null) {
            this.progress_listener.downloadUpdate(progressEvent);
        }
        if (global_listener != null) {
            global_listener.downloadUpdate(progressEvent);
        }
    }

    void sendErrorEvent(ProgressEvent progressEvent) {
        if (this.progress_listener != null) {
            this.progress_listener.downloadError(progressEvent);
        }
        if (global_listener != null) {
            global_listener.downloadError(progressEvent);
        }
    }

    void sendFinishEvent(ProgressEvent progressEvent) {
        if (this.progress_listener != null) {
            this.progress_listener.downloadEnded(progressEvent);
        }
        if (global_listener != null) {
            global_listener.downloadEnded(progressEvent);
        }
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support input");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support output");
    }

    public Object getContent() throws IOException {
        InputStream inputStream = this.getInputStream();
        String string = this.getContentType();
        ContentHandler contentHandler = this.getContentHandler(string);
        Object object = null;
        if (contentHandler != null) {
            object = contentHandler.getContent(this);
        }
        return object;
    }

    public Object getContent(Class[] classArray) throws IOException {
        InputStream inputStream = this.getInputStream();
        String string = this.getContentType();
        ContentHandler contentHandler = this.getContentHandler(string, classArray);
        Object object = null;
        if (contentHandler != null) {
            object = contentHandler.getContent(this, classArray);
        }
        return object;
    }

    public String getContentType() {
        return "unknown/unknown";
    }

    public abstract void connect() throws IOException;

    public int getContentLength() {
        return -1;
    }

    public String getContentEncoding() {
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderField(String string) {
        return null;
    }

    public byte[] getRawHeaderField(int n) {
        return EMPTY_HEADER;
    }

    public byte[] getRawHeaderField(String string) {
        return EMPTY_HEADER;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public long getLastModified() {
        return 0L;
    }

    protected static void addContentTypeToDefaultMap(String string, String string2) {
        ResourceManager.addContentTypeToDefaultMap(string, string2);
    }

    public static String findContentType(String string) {
        return ResourceManager.getMIMEType(string);
    }

    public static String findFileExtension(String string) {
        return ResourceManager.getFileExtension(string);
    }

    protected ContentHandler getContentHandler(String string) {
        this.last_content_handler = ResourceManager.getContentHandler(string);
        return this.last_content_handler;
    }

    protected ContentHandler getContentHandler(String string, Class[] classArray) {
        this.last_content_handler = ResourceManager.getContentHandler(string, classArray);
        return this.last_content_handler;
    }

    public void close() {
        if (!this.connected) {
            return;
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progress_listener = ProgressListenerMulticaster.add(this.progress_listener, progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progress_listener = ProgressListenerMulticaster.remove(this.progress_listener, progressListener);
    }

    public static void addGlobalProgressListener(ProgressListener progressListener) {
        global_listener = ProgressListenerMulticaster.add(global_listener, progressListener);
    }

    public static void removeGlobalProgressListener(ProgressListener progressListener) {
        global_listener = ProgressListenerMulticaster.remove(global_listener, progressListener);
    }

    public String toString() {
        if (this.name_string == null) {
            StringBuffer stringBuffer = new StringBuffer("Resource Connection: [ ");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" ]");
            this.name_string = stringBuffer.toString();
        }
        return this.name_string;
    }

    public void finalize() {
        if (!this.connected) {
            return;
        }
        if (this.last_content_handler == null || !this.last_content_handler.requiresStreamAfterClose()) {
            this.close();
        }
    }
}

