// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_PMULL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_PMULL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_pmull2_8H[] = {
  0x4005, 0x4444, 0x5050, 0x5540, 0x5551, 0x5554, 0x5555, 0x0000,
  0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000,
  0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000,
  0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000,
  0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000,
  0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000,
  0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000,
  0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000,
  0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000,
  0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000,
  0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000,
  0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000,
  0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000,
  0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000,
  0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000,
  0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000,
  0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000,
  0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000,
  0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000,
  0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000,
  0x4444, 0x5050, 0x5540, 0x5551, 0x5554, 0x5555, 0x0000, 0x0001,
  0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002,
  0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008,
  0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033,
  0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055,
  0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d,
  0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e,
  0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f,
  0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080,
  0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081,
  0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082,
  0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083,
  0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa,
  0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc,
  0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8,
  0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd,
  0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe,
  0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff,
  0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000,
  0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002,
  0x5050, 0x5540, 0x5551, 0x5554, 0x5555, 0x0000, 0x0001, 0x0004,
  0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010,
  0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066,
  0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa,
  0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa,
  0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc,
  0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe,
  0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100,
  0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102,
  0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104,
  0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106,
  0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154,
  0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198,
  0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0,
  0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa,
  0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc,
  0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe,
  0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000,
  0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008,
  0x4620, 0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010,
  0x5540, 0x5551, 0x5554, 0x5555, 0x0000, 0x0001, 0x0004, 0x0040,
  0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400,
  0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408,
  0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410,
  0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418,
  0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550,
  0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660,
  0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0,
  0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8,
  0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0,
  0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8,
  0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000,
  0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033,
  0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066,
  0x5658, 0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0x5551, 0x5554, 0x5555, 0x0000, 0x0001, 0x0004, 0x0040, 0x0505,
  0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f,
  0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7,
  0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2,
  0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891,
  0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980,
  0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3,
  0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6,
  0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5,
  0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e,
  0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414,
  0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188,
  0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177,
  0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122,
  0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111,
  0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000,
  0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055,
  0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa,
  0x5750, 0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0x5456, 0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f,
  0x5554, 0x5555, 0x0000, 0x0001, 0x0004, 0x0040, 0x0505, 0x1111,
  0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919,
  0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6,
  0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3,
  0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80,
  0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5,
  0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a,
  0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f,
  0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222,
  0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c,
  0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298,
  0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399,
  0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366,
  0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333,
  0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000,
  0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d,
  0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa,
  0x57a8, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0x54ab, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7,
  0x55aa, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919,
  0x5555, 0x0000, 0x0001, 0x0004, 0x0040, 0x0505, 0x1111, 0x1551,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6,
  0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab,
  0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80,
  0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd,
  0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a,
  0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07,
  0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232,
  0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc,
  0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58,
  0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1,
  0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56,
  0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b,
  0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000,
  0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e,
  0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc,
  0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2,
  0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6,
  0x0000, 0x0001, 0x0004, 0x0040, 0x0505, 0x1111, 0x1551, 0x1554,
  0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82,
  0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc,
  0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288,
  0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50,
  0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6,
  0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54,
  0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a,
  0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000,
  0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f,
  0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe,
  0x00f8, 0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891,
  0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3,
  0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab,
  0x0000, 0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a,
  0x0001, 0x0004, 0x0040, 0x0505, 0x1111, 0x1551, 0x1554, 0x1555,
  0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80,
  0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff,
  0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e,
  0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01,
  0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366,
  0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244,
  0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8,
  0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b,
  0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa,
  0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5,
  0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000,
  0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080,
  0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100,
  0x01f0, 0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400,
  0x01fa, 0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980,
  0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80,
  0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00,
  0x0002, 0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80,
  0x0004, 0x0040, 0x0505, 0x1111, 0x1551, 0x1554, 0x1555, 0x4000,
  0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080,
  0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100,
  0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180,
  0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500,
  0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600,
  0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00,
  0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80,
  0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00,
  0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80,
  0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000,
  0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081,
  0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102,
  0x07c0, 0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408,
  0x07e8, 0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3,
  0x07f0, 0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5,
  0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e,
  0x0008, 0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff,
  0x0010, 0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080,
  0x0040, 0x0505, 0x1111, 0x1551, 0x1554, 0x1555, 0x4000, 0x4001,
  0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182,
  0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103,
  0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa,
  0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc,
  0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8,
  0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d,
  0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe,
  0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f,
  0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000,
  0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082,
  0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104,
  0x1188, 0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410,
  0x1177, 0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6,
  0x1122, 0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a,
  0x1111, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc,
  0x0033, 0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e,
  0x0066, 0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100,
  0x0198, 0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182,
  0x0505, 0x1111, 0x1551, 0x1554, 0x1555, 0x4000, 0x4001, 0x4004,
  0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086,
  0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454,
  0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798,
  0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0,
  0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a,
  0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc,
  0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e,
  0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000,
  0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083,
  0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106,
  0x3298, 0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418,
  0x3399, 0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5,
  0x3366, 0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f,
  0x3333, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82,
  0x0055, 0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01,
  0x00aa, 0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180,
  0x02a8, 0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103,
  0x0f0f, 0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086,
  0x1111, 0x1551, 0x1554, 0x1555, 0x4000, 0x4001, 0x4004, 0x4005,
  0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe,
  0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754,
  0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08,
  0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87,
  0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02,
  0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81,
  0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000,
  0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa,
  0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154,
  0x2a58, 0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550,
  0x2bd1, 0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e,
  0x2b56, 0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222,
  0x2b2b, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232,
  0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc,
  0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366,
  0x00fa, 0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500,
  0x03e8, 0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa,
  0x08f7, 0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454,
  0x1919, 0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe,
  0x1551, 0x1554, 0x1555, 0x4000, 0x4001, 0x4004, 0x4005, 0x4444,
  0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878,
  0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530,
  0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732,
  0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc,
  0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666,
  0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000,
  0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc,
  0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198,
  0x2b50, 0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660,
  0x2ad6, 0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414,
  0x2a54, 0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c,
  0x2a2a, 0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc,
  0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288,
  0x007e, 0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244,
  0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600,
  0x03f0, 0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc,
  0x08a2, 0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798,
  0x19e6, 0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754,
  0x15d6, 0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878,
  0x1554, 0x1555, 0x4000, 0x4001, 0x4004, 0x4005, 0x4444, 0x5050,
  0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620,
  0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc,
  0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488,
  0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444,
  0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000,
  0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8,
  0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0,
  0x2ba8, 0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0,
  0x2a2b, 0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188,
  0x2aaa, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298,
  0x2ad5, 0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58,
  0x0000, 0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50,
  0x007f, 0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8,
  0x00fe, 0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00,
  0x03f8, 0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8,
  0x0891, 0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0,
  0x19b3, 0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08,
  0x15ab, 0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530,
  0x152a, 0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620,
  0x1555, 0x4000, 0x4001, 0x4004, 0x4005, 0x4444, 0x5050, 0x5540,
  0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658,
  0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750,
  0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8,
  0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000,
  0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd,
  0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa,
  0x7c00, 0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8,
  0x7e80, 0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177,
  0x7f00, 0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399,
  0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1,
  0x0000, 0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6,
  0x0080, 0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b,
  0x0100, 0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80,
  0x0400, 0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d,
  0x1980, 0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a,
  0x2a80, 0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87,
  0x3e80, 0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732,
  0x3f00, 0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc,
  0x3f80, 0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658,
  0x4000, 0x4001, 0x4004, 0x4005, 0x4444, 0x5050, 0x5540, 0x5551,
  0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456,
  0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab,
  0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000,
  0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe,
  0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc,
  0x7cf8, 0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0,
  0x7e7d, 0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122,
  0x7ffe, 0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366,
  0x7f7f, 0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56,
  0x0000, 0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54,
  0x0081, 0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa,
  0x0102, 0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00,
  0x0408, 0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe,
  0x19b3, 0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc,
  0x2ad5, 0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02,
  0x3efd, 0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc,
  0x3f7e, 0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488,
  0x3fff, 0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750,
  0x4080, 0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456,
  0x4001, 0x4004, 0x4005, 0x4444, 0x5050, 0x5540, 0x5551, 0x5554,
  0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa,
  0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa, 0x0000,
  0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab, 0x0000, 0x00ff,
  0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8, 0x0000, 0x00fe, 0x01fe,
  0x7df0, 0x7f87, 0x66cc, 0x4444, 0x0000, 0x00fd, 0x01fc, 0x07f8,
  0x7f7a, 0x7e02, 0x6666, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x1111,
  0x7efc, 0x7e81, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x1122, 0x3333,
  0x7e7e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x1177, 0x3366, 0x2b2b,
  0x0000, 0x0083, 0x0154, 0x0660, 0x1188, 0x3399, 0x2b56, 0x2a2a,
  0x0082, 0x0106, 0x0550, 0x1414, 0x3298, 0x2bd1, 0x2a54, 0x2ad5,
  0x0104, 0x0418, 0x1e1e, 0x3c3c, 0x2a58, 0x2ad6, 0x2aaa, 0x7f80,
  0x0410, 0x19d5, 0x2222, 0x23dc, 0x2b50, 0x2a2b, 0x7f00, 0x7f7f,
  0x19e6, 0x2a7f, 0x3232, 0x2288, 0x2ba8, 0x7e80, 0x7ffe, 0x7e7e,
  0x2a2a, 0x3e07, 0x33cc, 0x2244, 0x7c00, 0x7e7d, 0x7efc, 0x7e81,
  0x3e7a, 0x3f82, 0x3366, 0x6600, 0x7cf8, 0x7f7a, 0x7e02, 0x6666,
  0x3ffc, 0x3f01, 0x5500, 0x66cc, 0x7df0, 0x7f87, 0x66cc, 0x4444,
  0x3f7e, 0x4180, 0x55aa, 0x6798, 0x7d08, 0x6732, 0x4488, 0x57a8,
  0x4100, 0x4103, 0x5454, 0x6754, 0x6530, 0x45dc, 0x5750, 0x54ab,
  0x4182, 0x4086, 0x54fe, 0x7878, 0x4620, 0x5658, 0x5456, 0x55aa,
  0x4004, 0x4005, 0x4444, 0x5050, 0x5540, 0x5551, 0x5554, 0x5555,
};
const unsigned kExpectedCount_NEON_pmull2_8H = 361;

#endif  // VIXL_SIM_PMULL2_8H_TRACE_AARCH64_H_
