/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class StringUtil {
    public static final char QUOTE_CHAR = '\"';
    public static final String QUOTE = "\"";
    public static final String LS = System.getProperty("line.separator", "\n");
    private static String NEWLINE_STR = null;
    private static final String NANOS_FORMAT = "%l ns";
    private static final String MICROS_FORMAT = "%.1f micros";
    private static final String MILLIS_FORMAT = "%.1f ms";
    private static final String SECONDS_FORMAT = "%.3f sec";

    private StringUtil() {
    }

    public static String quote(Object o) {
        return StringUtil.quote(o, '\"');
    }

    public static String quote(Object o, char leftHandChar) {
        String s = o == null ? "null" : SmartStringifier.toString(o);
        char leftChar = leftHandChar;
        char rightChar = leftHandChar;
        if (leftHandChar == '(') {
            rightChar = ')';
        } else if (leftHandChar == '{') {
            rightChar = '}';
        } else if (leftHandChar == '[') {
            rightChar = ']';
        } else if (leftHandChar == '<') {
            rightChar = '>';
        }
        String out = leftChar + s + rightChar;
        return out;
    }

    public static String toHexString(byte theByte) {
        String result = Integer.toHexString(theByte & 0xFF);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, null);
    }

    public static String toHexString(byte[] bytes, String delim) {
        StringBuffer buf = new StringBuffer();
        if (bytes.length != 0) {
            if (delim == null || delim.length() == 0) {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i]));
                }
            } else {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i]) + delim);
                }
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    public static String stripSuffix(String s, String suffix) {
        String result = s;
        if (s.endsWith(suffix)) {
            result = s.substring(0, s.length() - suffix.length());
        }
        return result;
    }

    public static String replaceSuffix(String s, String fromSuffix, String toSuffix) {
        if (!s.endsWith(fromSuffix)) {
            throw new IllegalArgumentException(fromSuffix);
        }
        return StringUtil.stripSuffix(s, fromSuffix) + toSuffix;
    }

    public static String stripPrefix(String s, String prefix) {
        String result = s;
        if (s.startsWith(prefix)) {
            result = s.substring(prefix.length(), s.length());
        }
        return result;
    }

    public static String stripPrefixAndSuffix(String s, String prefix, String suffix) {
        return StringUtil.stripPrefix(StringUtil.stripSuffix(s, suffix), prefix);
    }

    public static String upperCaseFirstLetter(String s) {
        String result = s;
        if (s.length() >= 1) {
            result = s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
        }
        return result;
    }

    public static String toString(Object o) {
        String s = null;
        if (o instanceof String) {
            s = (String)o;
        } else if (o instanceof Throwable) {
            s = ExceptionUtil.toString((Throwable)o);
        } else if (o instanceof ObjectName) {
            s = JMXUtil.toString((ObjectName)o);
        } else if (o instanceof Attribute) {
            Attribute a = (Attribute)o;
            s = a.getName() + "=" + StringUtil.toString(a.getValue());
        } else if (o instanceof AttributeList) {
            Map<String, Object> items = JMXUtil.attributeListToValueMap((AttributeList)o);
            s = "{" + MapUtil.toString(items) + "}";
        } else if (o instanceof byte[]) {
            byte[] b = (byte[])byte[].class.cast(o);
            s = "byte[] of length " + b.length;
        } else {
            s = o == null ? "null" : (o instanceof Object[] ? StringUtil.toString(", ", (Object[])o) : "" + o);
        }
        return s;
    }

    public static String toString(String[] args) {
        return StringUtil.toString(", ", args);
    }

    public static String toString(String delim, String ... args) {
        return StringUtil.toString(delim, (Object[])args);
    }

    public static String toString(String delim, Object ... args) {
        String result = null;
        if (args == null) {
            result = "" + null;
        } else if (args.length == 0) {
            result = "";
        } else if (args.length == 1) {
            result = StringUtil.toString(args[0]);
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < args.length - 1; ++i) {
                builder.append(StringUtil.toString(args[i]));
                builder.append(delim);
            }
            builder.append(StringUtil.toString(args[args.length - 1]));
            result = builder.toString();
        }
        return result;
    }

    public static String getPrefix(Set<String> prefixes, String s) {
        String result = null;
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            result = prefix;
            break;
        }
        return result;
    }

    public static String findAndStripPrefix(Set<String> prefixes, String s) {
        String prefix = StringUtil.getPrefix(prefixes, s);
        if (prefix == null) {
            throw new IllegalArgumentException(s);
        }
        return StringUtil.stripPrefix(s, prefix);
    }

    public static String NEWLINE() {
        if (NEWLINE_STR == null) {
            NEWLINE_STR = System.getProperty("line.separator");
        }
        return NEWLINE_STR;
    }

    private static String zeroPad(long num) {
        String result = null;
        result = num >= 100L ? "" + num : (num >= 10L ? "0" + num : "00" + num);
        return result;
    }

    private static double micros(long nanos) {
        return (double)nanos / 1000.0;
    }

    private static double millis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    private static double seconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static String getSecondsString(long nanos) {
        return StringUtil.getTimingString(nanos, TimeUnit.SECONDS);
    }

    public static String getMillisString(long nanos) {
        return StringUtil.getTimingString(nanos, TimeUnit.MILLISECONDS);
    }

    public static String getTimingString(long nanos, TimeUnit timeUnit) {
        String result = null;
        if (timeUnit == TimeUnit.NANOSECONDS) {
            result = String.format(NANOS_FORMAT, nanos);
        } else if (timeUnit == TimeUnit.MICROSECONDS) {
            result = String.format(MICROS_FORMAT, StringUtil.micros(nanos));
        } else if (timeUnit == TimeUnit.MILLISECONDS) {
            result = String.format(MILLIS_FORMAT, StringUtil.millis(nanos));
        } else if (timeUnit == TimeUnit.SECONDS) {
            result = String.format(SECONDS_FORMAT, StringUtil.seconds(nanos));
        }
        return result;
    }

    public static String getTimingString(long nanos) {
        long seconds = nanos / 1000000000L;
        long millis = nanos % 1000000000L / 1000000L;
        long micros = nanos % 1000000L / 1000L;
        long nanosMod = nanos % 1000L;
        String runTimeString = null;
        long MICROSECOND = 1000L;
        long MILLISECOND = 1000000L;
        runTimeString = nanos < 10000L ? nanos + " nanoseconds" : (nanos < 10000000L ? nanos / 1000L + " microseconds" : nanos / 1000000L + " milliseconds");
        return runTimeString;
    }
}

