require 'spec_helper'
describe Vim::AddonManager::Addon::Legacy do

  it 'should have a :unavailable status if it misses files' do
    addon('missingfiles').status(target_dir.path).status.should == :unavailable
  end

  it 'should have a :broken status if files are removed in the target dir' do
    addon_manager.install addons('foo')
    target_dir.rm('syntax/foo.vim')
    addon('foo').status(target_dir.path).status.should == :broken
  end

  it 'should have a :not_installed status by default' do
    addon('foo').status(target_dir.path).status.should == :not_installed
  end

  it 'should have a :installed status after being installed' do
    addon_manager.install addons('foo')
    addon('foo').status(target_dir.path).status.should == :installed
  end

  it 'go back to :not_installed after being removed' do
    addon_manager.install addons('foo')
    addon_manager.remove addons('foo')
    addon('foo').status(target_dir.path).status.should == :not_installed
  end

end
