# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
#import subprocess
import Image
import StringIO
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from main_winDLG import *
from mplayer import *
from interface import *
from GlobalDefines import *

#------------------------------------------------------------------------------- 
# Transitions process
#------------------------------------------------------------------------------- 
def choiceTransition(widthpict,heightpict,lumask,transitype,previous,image,dissolve,optionTr):
  if int(transitype)==1 :   resu=PilToQImage(fadepil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve))
  elif int(transitype)==2 : resu=PilToQImage(appearpil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,int(optionTr)))
  elif int(transitype)==3 : resu=PilToQImage(disappearpil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,int(optionTr)))
  elif int(transitype)==4 : resu=PilToQImage(slidepil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,int(optionTr)))
  elif int(transitype)==5 : resu=PilToQImage(cubepil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,int(optionTr)))
  elif int(transitype)==6 : resu=PilToQImage(pushpil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,int(optionTr)))
  elif int(transitype)==7 : resu=PilToQImage(lumapil(widthpict,heightpict,QImageToPil(previous),QImageToPil(image),dissolve,unicode(lumask[int(optionTr)])))
  else :                    resu=image
  return resu

#------------------------------------------------------------------------------- Fade transition
def fadepil(widthpict,heightpict,previouspil,impil,dissolve) :
  percent=float(dissolve)/100
  imf=Image.blend(previouspil,impil,percent)
  return imf

#------------------------------------------------------------------------------- Slide transition
def slidepil(widthpict,heightpict,previouspil,impil,dissolve,opt=0) :
  if opt == 0 :   #Since left to right
    a = int(widthpict*(100.0-dissolve)/100.0)
    box1=(a,0,widthpict,heightpict)
    box2=(0,0,widthpict-a,heightpict)
  elif opt == 1 : #Since right to left
    a = int(dissolve*widthpict/100)
    box1=(0,0,a,heightpict)
    box2=(widthpict-a,0,widthpict,heightpict)
  elif opt == 2 : #Since up to down
    a = int(heightpict-dissolve*heightpict/100)
    box1=(0,a,widthpict,heightpict)
    box2=(0,0,widthpict,heightpict-a)
  elif opt == 3 : #Since down to up
    a = int(dissolve*heightpict/100)
    box1=(0,0,widthpict,a)
    box2=(0,heightpict-a,widthpict,heightpict)
  elif opt == 4 : #Since the upper left corner
    a = int(dissolve*widthpict/100)
    b = int(dissolve*heightpict/100)
    box1=(widthpict-a,heightpict-b,widthpict,heightpict)
    box2=(0,0,a,b)
  elif opt == 5 : #Since the upper right corner
    a = int(heightpict-dissolve*heightpict/100)
    b = int(dissolve*widthpict/100)
    box1=(0,a,b,heightpict)
    box2=(widthpict-b,0,widthpict,heightpict-a)
  elif opt == 6 : #Since the lower left corner
    a = int(widthpict-dissolve*widthpict/100)
    b = int(dissolve*heightpict/100)
    box1=(a,0,widthpict,b)
    box2=(0,heightpict-b,widthpict-a,heightpict)
  elif opt == 7 : #Since the lower right corner
    a = int(dissolve*widthpict/100)
    b = int(dissolve*heightpict/100)
    box1=(0,0,a,b)
    box2=(widthpict-a,heightpict-b,widthpict,heightpict)

  ima=impil.crop(box1)
  previouspil.paste(ima,box2)
  return previouspil

#------------------------------------------------------------------------------- Zoom In transition
def appearpil(widthpict,heightpict,previouspil,impil,dissolve,opt=0) :
  previouspil2 = previouspil.copy()
  wt = int(widthpict*dissolve/100)
  ht = int(heightpict*dissolve/100)
  
  #domledom : add new transition by moving position of the destination
  if (opt==1):  #Border Left Center
    box = (0,int((heightpict-ht)/2),wt,int((heightpict+ht)/2))
  elif (opt==2):  #Border Right Center
    box = (int(widthpict-wt),int((heightpict-ht)/2),int(widthpict),int((heightpict+ht)/2))
  elif (opt==3):  #Border Top Center
    box = (int((widthpict-wt)/2),0,int((widthpict+wt)/2),ht)
  elif (opt==4):  #Border Bottom Center
    box = (int((widthpict-wt)/2),int(heightpict-ht),int((widthpict+wt)/2),int(heightpict))
  elif (opt==5):  #Upper Left Corner
    box = (0,0,wt,ht)
  elif (opt==6):  #Upper Right Corner
    box = (int(widthpict-wt),0,int(widthpict),ht)
  elif (opt==7):  #Bottom Left Corner
    box = (0,int(heightpict-ht),wt,int(heightpict))
  elif (opt==8):  #Bottom Right Corner
    box = (int(widthpict-wt),int(heightpict-ht),int(widthpict),int(heightpict))
  else:
    box = (int((widthpict-wt)/2),int((heightpict-ht)/2),int((widthpict+wt)/2),int((heightpict+ht)/2))
    
  imz = impil.resize((wt,ht))
  previouspil2.paste(imz,box)
  return previouspil2

#------------------------------------------------------------------------------- Zoom Out transition
def disappearpil(widthpict,heightpict,previouspil,impil,dissolve,opt=0) :
  impil2=impil.copy()
  prce = 100-dissolve
  wt = int(widthpict*prce/100)
  ht = int(heightpict*prce/100)

  #domledom : add new transition by moving position of the destination
  if (opt==1):  #Border Left Center
    box = (0,int((heightpict-ht)/2),wt,int((heightpict+ht)/2))
  elif (opt==2):  #Border Right Center
    box = (int(widthpict-wt),int((heightpict-ht)/2),int(widthpict),int((heightpict+ht)/2))
  elif (opt==3):  #Border Top Center
    box = (int((widthpict-wt)/2),0,int((widthpict+wt)/2),ht)
  elif (opt==4):  #Border Bottom Center
    box = (int((widthpict-wt)/2),int(heightpict-ht),int((widthpict+wt)/2),int(heightpict))
  elif (opt==5):  #Upper Left Corner
    box = (0,0,wt,ht)
  elif (opt==6):  #Upper Right Corner
    box = (int(widthpict-wt),0,int(widthpict),ht)
  elif (opt==7):  #Bottom Left Corner
    box = (0,int(heightpict-ht),wt,int(heightpict))
  elif (opt==8):  #Bottom Right Corner
    box = (int(widthpict-wt),int(heightpict-ht),int(widthpict),int(heightpict))
  else:
    box = (int((widthpict-wt)/2),int((heightpict-ht)/2),int((widthpict+wt)/2),int((heightpict+ht)/2))
    
  imz = previouspil.resize((wt,ht))
  impil2.paste(imz,box)
  return impil2

#------------------------------------------------------------------------------- Cube transition
def cubepil(widthpict,heightpict,previouspil,impil,dissolve,opt=0) :
  base = Image.new("RGB",(widthpict,heightpict))
  if opt == 0 : #Left2Right
    w1=int(widthpict*dissolve/100)
    box1=(0,0,w1,heightpict)
    part1 = impil.resize((w1,heightpict))
    w2=widthpict-w1
    box2=(w1,0,widthpict,heightpict)
    part2 = previouspil.resize((w2,heightpict))
    base.paste(part1,box1)
    base.paste(part2,box2)
  elif opt == 1 : #Right2Left
    w1=int(widthpict*dissolve/100)
    part1 = impil.resize((w1,heightpict))
    w2=widthpict-w1
    box1=(w2,0,widthpict,heightpict)
    box2=(0,0,w2,heightpict)
    part2 = previouspil.resize((w2,heightpict))
    base.paste(part1,box1)
    base.paste(part2,box2)
  elif opt == 2 : #Top2Bottom
    h1=int(heightpict*dissolve/100)
    box1=(0,0,widthpict,h1)
    part1 = impil.resize((widthpict,h1))
    h2=heightpict-h1
    box2=(0,h1,widthpict,heightpict)
    part2 = previouspil.resize((widthpict,h2))
    base.paste(part1,box1)
    base.paste(part2,box2)
  elif opt == 3 : #Bottom2Top
    h1=int(heightpict*dissolve/100)
    part1 = impil.resize((widthpict,h1))
    h2=heightpict-h1
    box1=(0,h2,widthpict,heightpict)
    box2=(0,0,widthpict,h2)
    part2 = previouspil.resize((widthpict,h2))
    base.paste(part1,box1)
    base.paste(part2,box2)

  return base

#------------------------------------------------------------------------------- Push transition
def pushpil(widthpict,heightpict,previouspil,impil,dissolve,opt=0) :
  if opt == 0 :
    base = Image.new("RGB",(widthpict*2,heightpict))
    base.paste(impil,(0,0,widthpict,heightpict))
    base.paste(previouspil,(widthpict,0,widthpict*2,heightpict))
    imz=base.crop((int(widthpict-dissolve*widthpict/100),0,int(widthpict*2-(dissolve*widthpict/100)),heightpict))
  elif opt == 1 :
    base = Image.new("RGB",(widthpict*2,heightpict))
    base.paste(previouspil,(0,0,widthpict,heightpict))
    base.paste(impil,(widthpict,0,widthpict*2,heightpict))
    imz=base.crop((int(dissolve*widthpict/100),0,int(widthpict+(dissolve*widthpict/100)),heightpict))
  elif opt == 2 :
    base = Image.new("RGB",(widthpict,heightpict*2))
    base.paste(impil,(0,0,widthpict,heightpict))
    base.paste(previouspil,(0,heightpict,widthpict,heightpict*2))
    imz=base.crop((0,int(heightpict-dissolve*heightpict/100),widthpict,int(heightpict*2-(dissolve*heightpict/100))))
    #imz=base.crop((0,int(heightpict-dissolve*heightpict/100),widthpict,heightpict))
  elif opt == 3 :
    base = Image.new("RGB",(widthpict,heightpict*2))
    base.paste(previouspil,(0,0,widthpict,heightpict))
    base.paste(impil,(0,heightpict,widthpict,heightpict*2))
    imz=base.crop((0,int(dissolve*heightpict/100),widthpict,int(heightpict+(dissolve*heightpict/100))))

  return imz.resize((widthpict,heightpict))

#------------------------------------------------------------------------------- Luma transition
def map(i) :
  if i < limit :
    return 0
  return 255

def lumapil(widthpict,heightpict,previouspil,impil,dissolve,mask) :
  global limit
  limit   = int(dissolve*255/100)+1
  luma    = Image.open(mask)
  msk     = luma.point(lambda i : map(i),"1")
  mskl    = msk.resize((widthpict,heightpict))
  lumaout = Image.composite(previouspil,impil,mskl)
  return lumaout
