/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TListPanel.h"

TListPanel::TListPanel(QWidget* parent, Qt::WindowFlags)
: QGraphicsView(parent)
{
    QPixmap *brushPixmap = new QPixmap("TListPanel/brush.png", "PNG");
	QBrush *backgroundBrush = new QBrush();
	backgroundBrush->setTexture(*brushPixmap);
    this->setBackgroundBrush(*backgroundBrush);
	this->setCacheMode(QGraphicsView::CacheBackground);
	
    this->setAlignment(Qt::AlignLeft | Qt::AlignTop);
    this->setVisible(true);
    scene = new QGraphicsScene(this);
	this->setScene(scene);
    //infoText = new QGraphicsTextItem("");

	this->currentIndex = 0;
	
    countItems = 0;
    x = 0;
    y = 0;
    h = 60;
    otst = 10;
    inc = 0;
	
	listItems = new QList<frameStruct*>();
	frameItems = new QList<TFrameItem*>();
}

void TListPanel::setActions(QAction &delAct, QAction &saveAct)
{
	this->delAct = &delAct;
	this->saveAct = &saveAct;
}

void TListPanel::setList(QList<frameStruct*> *list)
{
	this->listItems = list;
}

void TListPanel::createItems()
{
	for(int i = 0; i < listItems->count(); i++)
	{
		TFrameItem *item = new TFrameItem(listItems->at(i)->img, h, *delAct, *saveAct);
		*frameItems << item;
		connect(frameItems->at(i), SIGNAL(onSelectItem(TFrameItem &)), this, SLOT(S_SelectItem(TFrameItem &)));
		scene->addItem(frameItems->at(i));
	}
	frameItems->at(0)->select();
	
}

void TListPanel::adjustItems()
{
    int inc = 0;
    for (int i = 0; i < frameItems->count(); i++) 
    {
		frameItems->at(i)->setPos(inc, 10);
		inc = inc + (int)(frameItems->at(i)->boundingRect().width() + 6);
    }

	scene->setSceneRect(scene->itemsBoundingRect());
    scene->advance();
	this->setScene(scene);
}

void TListPanel::deleteItem(int index)
{	
	if(frameItems->count() > 0)
	{
		scene->removeItem(frameItems->at(index));
		frameItems->removeAt(index);
		adjustItems();
	
		currentIndex = 0;
	}
}

int TListPanel::getCurrentIndex()
{
	return currentIndex;
}

TListPanel::~TListPanel(void)
{

}

void TListPanel::S_SelectItem(TFrameItem &currentItem)
{
	frameItems->at(currentIndex)->deSelect();
	
	/*QMessageBox msgBox;
	QPushButton *connectButton = msgBox.addButton(QString::number(currentIndex), QMessageBox::ActionRole);
	QPushButton *abortButton = msgBox.addButton(QMessageBox::Abort);
	msgBox.exec();*/
	
    currentIndex = frameItems->indexOf(&currentItem);
    emit changeItem(currentIndex);
}

void TListPanel::removeAll()
{
	qDeleteAll(*frameItems);
	frameItems->clear();
	
	frameItems = NULL;
	listItems = NULL;
	frameItems = new QList<TFrameItem*>();
	listItems = new QList<frameStruct*>();
	
	scene = NULL;
	scene = new QGraphicsScene(this);
}

void TListPanel::S_SaveItem(TFrameItem &currentItem)
{
    int currentIndex = frameItems->indexOf(&currentItem);
    emit onSave(currentIndex);
/*QMessageBox msgBox;
QPushButton *connectButton = msgBox.addButton(QString::number(5), QMessageBox::ActionRole);
QPushButton *abortButton = msgBox.addButton(QMessageBox::Abort);
msgBox.exec();*/
}

int TListPanel::count()
{
	return countItems;
}
