require 'spec_helper'

describe command('/usr/sbin/varnishd -C -f /etc/varnish/default.vcl') do
  its(:exit_status) { should eq 0 }
end

describe command('/usr/share/varnish/varnishreload') do
  its(:exit_status) { should eq 0 }
  its(:stdout) { should contain('compiled') }
  its(:stderr) { should eq '' }
end

describe command('systemctl is-enabled varnish') do
  its(:exit_status) { should eq 0 }
  its(:stderr) { should eq '' }
  its(:stdout) { should eq("enabled\n") }
end

describe command('systemctl is-active varnish') do
  its(:exit_status) { should eq 0 }
  its(:stderr) { should eq '' }
  its(:stdout) { should eq("active\n") }
end

describe command('systemctl reload varnish') do
  its(:exit_status) { should eq 0 }
  its(:stderr) { should eq('') }
  its(:stdout) { should eq('') }
end
