/***************************************************************************
                          dciconloader.h  -  description
                             -------------------
    begin                : Fri Jan 23 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* dnx274.dyndns.org */

#ifndef DCICONLOADER_H
#define DCICONLOADER_H

#include <qmap.h>
//Added by qt3to4:
#include <QPixmap>

/**
  *@author Mathias Küster
  */

enum eIcons {
    eiBACK=0,
    eiBALL_GREEN,
    eiBALL_RED,
    eiBALL_YELLOW,
    eiBOOKMARK_ADD,
    eiBOOKMARK_FOLDER,
    eiCHOOSE_LANGUAGE,
    eiCONFIGURE,
    eiCONFIGURE_32x32,
    eiCONNECT,
    eiCONNECT_CREATING,
    eiCONNECT_NO,
    eiCONNECTED,
    eiDOWN,
    eiDOWNLOAD,
    eiDOWNLOAD_AS,
    eiEDIT,
    eiEDITADD,
    eiEDITCOPY,
    eiEDITDELETE,
    eiEMOTICON,
    eiEXIT,
    eiFILECLOSE,
    eiFILEFIND,
    eiFILETYPE_APPLICATION,
    eiFILETYPE_ARCHIVE,
    eiFILETYPE_DOCUMENT,
    eiFILETYPE_MP3,
    eiFILETYPE_PICTURE,
    eiFILETYPE_UNKNOWN,
    eiFILETYPE_VIDEO,
    eiFIND,
    eiFIND_32x32,
    eiFLAG_BOSNIA,
    eiFLAG_BRAZIL,
    eiFLAG_BRITAIN,
    eiFLAG_CZECH,
    eiFLAG_DENMARK,
    eiFLAG_FINLAND,
    eiFLAG_FRANCE,
    eiFLAG_GERMANY,
    eiFLAG_GREECE,
    eiFLAG_HUNGARY,
    eiFLAG_ICELAND,
    eiFLAG_ITALY,
    eiFLAG_LATVIA,
    eiFLAG_NETHERLANDS,
    eiFLAG_NORWAY,
    eiFLAG_POLAND,
    eiFLAG_ROMANIA,
    eiFLAG_RUSSIA,
    eiFLAG_SERBIA,
    eiFLAG_SLOVAKIA,
    eiFLAG_SPAIN,
    eiFLAG_SWEDEN,
    eiFOLDER_BLUE,
    eiFOLDER_BLUE_OPEN,
    eiFOLDER_RED,
    eiGLOBE,
    eiGV,
    eiHELP,
    eiICON_22x22,
    eiINFO,
    eiMESSAGE,
    eiNEXT,
    eiNOTCONNECTED,
    eiOPEN,
    eiPLAYER_PAUSE,
    eiPLAYER_PLAY,
    eiRELOAD,
    eiRELOAD_32x32,
    eiSAVE,
    eiSERVER,
    eiSORT_DOWN_ARROW,
    eiSPLASH,
    eiSPY,
    eiSSL_NO,
    eiSSL_YES,
    eiTEXT_SELECT_ALL,
    eiTRANSFER,
    eiTRANSLATE,
    eiUP,
    eiUPDATE,
    eiUSERS,
    eiUSERS_32x32,
    eiVIEW_SIDETREE,
    eiZOOM_IN,
    eiZOOM_OUT
};

/** */
typedef QMap<enum eIcons, QPixmap> PixmapMap;

class DCIconLoader
{
public:
	/** construtor */
	DCIconLoader();
	/** destructor */
	virtual ~DCIconLoader();

	/** */
	bool Load();
	/** */
	QPixmap & GetPixmap( enum eIcons );
	
private:
	/** */
	QPixmap LoadPixmap( QString file );

	/** */
	PixmapMap m_PixmapMap;
	/** */
	bool m_bError;
};

extern DCIconLoader * g_pIconLoader;

#endif
