/* arm.v5a-linux.elf-entry.h
   created from arm.v5a-linux.elf-entry.bin, 13929 (0x3669) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2024 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2024 Laszlo Molnar
   Copyright (C) 2000-2024 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V5A_LINUX_ELF_ENTRY_SIZE    13929
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_ADLER32 0xd8ba6995
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_CRC32   0x52a72532

unsigned char stub_arm_v5a_linux_elf_entry[13929] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 160, 19,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,  0, 24,208, 77,226, 39,  0,  0,235,
/* 0x0040 */ 252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,
/* 0x0050 */  26,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,
/* 0x0060 */   0, 32,132,229,  0, 64,160,225,  3,  0,160,225,  2, 16,131,224,
/* 0x0070 */   0, 32,160,227,  7,192,160,225,  7,192,160,225,  2,112,160,227,
/* 0x0080 */  15,120,135,227,  0,  0,  0,239, 12,112,160,225, 12,112,160,225,
/* 0x0090 */   4,  0,160,225,240,128,189,232,  1, 64,208,228,  4, 64,164,224,
/* 0x00a0 */   4, 76,176,225, 14,240,160,225,  1, 48,208,228,  1, 48,194,228,
/* 0x00b0 */   4, 64,148,224, 20,  0,  0, 11, 24,  0,  0, 42,  1, 16,160,227,
/* 0x00c0 */  35,  0,  0,234,  1, 16, 65,226,  4, 64,148,224, 20,  0,  0, 11,
/* 0x00d0 */   1, 16,161,224,  4, 64,148,224, 20,  0,  0, 11,  1, 16,161,224,
/* 0x00e0 */   4, 64,148,224, 20,  0,  0, 11, 31,  0,  0, 58,  3, 48, 81,226,
/* 0x00f0 */   0, 16,160,227, 51,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,
/* 0x0100 */   5, 80,240,225,  3,  0,  0, 10,197, 80,176,225, 66,  0,  0, 42,
/* 0x0110 */  54,  0,  0,234,  4, 64,148,224, 20,  0,  0, 11, 66,  0,  0, 42,
/* 0x0120 */   1, 16,160,227,  4, 64,148,224, 20,  0,  0, 11, 66,  0,  0, 42,
/* 0x0130 */   4, 64,148,224, 20,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x0140 */  20,  0,  0, 11, 58,  0,  0, 58,  4, 16,129,226, 70,  0,  0,234,
/* 0x0150 */   4, 64,148,224, 20,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,
/* 0x0160 */   5, 12,117,227,  1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,
/* 0x0170 */   5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 74,  0,  0, 26,
/* 0x0180 */  26,  0,  0,234,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0190 */   2, 65,160,227, 26,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x01a0 */   3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,
/* 0x01b0 */   2, 16,131,224,  0, 32,160,227,  7,192,160,225,  7,192,160,225,
/* 0x01c0 */   2,112,160,227, 15,120,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x01d0 */  12,112,160,225,  4,  0,160,225,240,128,189,232,  1, 64,208,228,
/* 0x01e0 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 48,208,228,
/* 0x01f0 */   1, 48,194,228,  4, 64,148,224, 20,  0,  0, 11, 24,  0,  0, 42,
/* 0x0200 */   1, 16,160,227, 35,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,
/* 0x0210 */  20,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 20,  0,  0, 11,
/* 0x0220 */   1, 16,177,224,  4, 64,148,224, 20,  0,  0, 11, 31,  0,  0, 58,
/* 0x0230 */   3, 48, 81,226,  0, 16,160,227, 50,  0,  0, 58,  1, 80,208,228,
/* 0x0240 */   3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,197, 80,176,225,
/* 0x0250 */  52,  0,  0,234,  4, 64,148,224, 20,  0,  0, 11,  1, 16,177,224,
/* 0x0260 */   4, 64,148,224, 20,  0,  0, 11,  1, 16,177,224, 65,  0,  0, 26,
/* 0x0270 */   1, 16,160,227,  4, 64,148,224, 20,  0,  0, 11,  1, 16,177,224,
/* 0x0280 */   4, 64,148,224, 20,  0,  0, 11, 58,  0,  0, 58,  2, 16,129,226,
/* 0x0290 */   1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,  0, 48,210,229,
/* 0x02a0 */   5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 69,  0,  0, 26,
/* 0x02b0 */  26,  0,  0,234,  0, 16,129,224, 62, 64, 45,233,  0, 80,224,227,
/* 0x02c0 */   2, 65,160,227, 35,  0,  0,234, 26,  0,189,232,  1,  0, 64,224,
/* 0x02d0 */   3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,
/* 0x02e0 */   2, 16,131,224,  0, 32,160,227,  7,192,160,225,  7,192,160,225,
/* 0x02f0 */   2,112,160,227, 15,120,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0300 */  12,112,160,225,  4,  0,160,225, 48,128,189,232,  4, 64,148,224,
/* 0x0310 */  14,240,160, 17,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0320 */  14,240,160,225,  1, 16,160,227, 14,192,160,225, 20,  0,  0,235,
/* 0x0330 */   1, 16,177,224, 20,  0,  0,235, 28,  0,  0, 58, 12,240,160,225,
/* 0x0340 */   1, 48,208,228,  1, 48,194,228, 20,  0,  0,235, 33,  0,  0, 42,
/* 0x0350 */  26,  0,  0,235,  3, 48, 81,226,  0, 16,160,227, 45,  0,  0, 58,
/* 0x0360 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,
/* 0x0370 */  20,  0,  0,235,  1, 16,177,224, 20,  0,  0,235,  1, 16,177,224,
/* 0x0380 */  52,  0,  0, 26, 26,  0,  0,235,  2, 16,129,226, 13, 12,117,227,
/* 0x0390 */   1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,  1, 48,194,228,
/* 0x03a0 */  54,  0,  0, 42, 35,  0,  0,234,  0,192,157,229, 14,  0, 92,227,
/* 0x03b0 */  46,  0,  0, 26, 12, 72, 45,233,  0,176,208,229,  6,204,160,227,
/* 0x03c0 */ 171,177,160,225, 28,203,160,225, 13,176,160,225, 58,205,140,226,
/* 0x03d0 */  12,208, 77,224,  0,192,147,229,  8, 48,141,229,  4,192,141,229,
/* 0x03e0 */   0, 32,141,229, 12, 48,141,226,  0,192,160,227,  4,192,131,228,
/* 0x03f0 */  11,  0, 83,225, 15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,
/* 0x0400 */   0, 16,160,225,  1,192,209,228,  7,192, 12,226, 18,192,205,229,
/* 0x0410 */   1,192,209,228, 44,  2,160,225, 17,  0,205,229, 15,192, 12,226,
/* 0x0420 */  16,192,205,229, 16,  0,141,226, 47,  0,  0,235, 11,208,160,225,
/* 0x0430 */   0, 48,160,225,  3,  0,189,232,  0, 16,145,229,  0, 16,129,224,
/* 0x0440 */   0, 32,160,227,  7,192,160,225,  7,192,160,225,  2,112,160,227,
/* 0x0450 */  15,120,135,227,  0,  0,  0,239, 12,112,160,225, 12,112,160,225,
/* 0x0460 */   3,  0,160,225,  0,136,189,232, 46,  0,  0,234,240, 79, 45,233,
/* 0x0470 */  48,208, 77,226,  0, 48,141,229,  0, 48,208,229,  2, 80,208,229,
/* 0x0480 */   1,224,208,229,  0,192,157,229, 20, 48,141,229, 92, 48,157,229,
/* 0x0490 */   0, 64,160,227,  0, 64,140,229,  0, 64,131,229, 20,192,157,229,
/* 0x04a0 */   1, 48,208,229,  3, 48,140,224,  3,204,160,227, 28,195,160,225,
/* 0x04b0 */   1, 48,160,227, 19,238,160,225, 19, 53,160,225,115,206,140,226,
/* 0x04c0 */   1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,  6,192,140,226,
/* 0x04d0 */   4, 16,141,229, 12, 48,141,229, 16,224,141,229,  8,  0,141,229,
/* 0x04e0 */  31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,176, 16,131,225,
/* 0x04f0 */  12,  0, 84,225,132, 48,160,225,  1, 64,132,226, 28,  0,  0, 26,
/* 0x0500 */   4, 48,157,229,  0, 96,160,227,  2,144,131,224,  3,224,160,225,
/* 0x0510 */   6, 32,160,225,  4, 80,157,229,  9, 48,101,224,  3,  0, 82,225,
/* 0x0520 */   1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,  1, 32,130,226,
/* 0x0530 */   5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,  0,176,160,227,
/* 0x0540 */   1,192,160,227, 11,112,160,225,  0,  0,224,227, 44,192,141,229,
/* 0x0550 */  24,176,141,229, 28,192,141,229, 32,192,141,229, 36,192,141,229,
/* 0x0560 */  57,  2,  0,234,255,132,224,227,  8,  0, 80,225, 68,  0,  0,138,
/* 0x0570 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  0,  4,160,225,
/* 0x0580 */   6,100,131,225, 12, 16,157,229, 24, 32,157,229,  1,160, 11,224,
/* 0x0590 */   2, 18,160,225,  1, 48,138,224,131, 80,160,225,  8, 48,157,229,
/* 0x05a0 */ 181,192,147,225,160, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x05b0 */ 185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226, 87, 51,160,225,
/* 0x05c0 */  16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,  8,  0,157,229,
/* 0x05d0 */   6, 44,160,227,147,  2, 34,224, 24, 16,157,229,  2, 59,108,226,
/* 0x05e0 */   6,  0, 81,227,195, 50,140,224,230,142,130,226,181, 48,128,225,
/* 0x05f0 */  12,128,136,226,  4,  0,160,209,  1, 16,160,211,164,  0,  0,218,
/* 0x0600 */  44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,  3,112,213,231,
/* 0x0610 */   4,  0,160,225,  1, 16,160,227,135,112,160,225,  1, 92,  7,226,
/* 0x0620 */ 129,160,160,225,133, 48,136,224, 10, 48,131,224,  1,  4, 80,227,
/* 0x0630 */   2, 76,131,226,  1,192,129,226,119,  0,  0, 42,  9,  0, 94,225,
/* 0x0640 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0650 */ 176, 48,212,225,160, 37,160,225, 12, 16,129,224,147,  2, 12,224,
/* 0x0660 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x0670 */ 135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,176, 32,196,225,
/* 0x0680 */  10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,164,  0,  0,234,
/* 0x0690 */   0,  0, 85,227,176, 48,196,225,  6, 96,108,224,  0,  0,108,224,
/* 0x06a0 */ 164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,105,  0,  0,234,
/* 0x06b0 */   1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,  9,  0, 94,225,
/* 0x06c0 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x06d0 */ 180, 48,152,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x06e0 */  12,  0, 86,225,163, 82, 67,224,194, 50,131,224,180, 48,136, 49,
/* 0x06f0 */ 180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,
/* 0x0700 */   6, 96,108, 32,255,  0, 81,227,129, 64,160,225,  1, 48,129,226,
/* 0x0710 */ 143,  0,  0,218, 24,192,157,229,255,112,  1,226,  3,  0, 92,227,
/* 0x0720 */  84, 16,157,229,  0, 32,160,211, 11,112,193,231,  1,176,139,226,
/* 0x0730 */  24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,  9,  0, 83,227,
/* 0x0740 */  24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194, 24, 48,141,213,
/* 0x0750 */  24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,  0, 32,100,224,
/* 0x0760 */   8,192,157,229,  8,  0, 82,225,181, 48,140,225,  6, 96,100,224,
/* 0x0770 */ 197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0780 */   2, 36,160,225,  6,100,131,225,  8,  0,157,229, 24, 48,157,229,
/* 0x0790 */ 131,112,128,224,  6, 13,135,226,176,192,208,225,162, 53,160,225,
/* 0x07a0 */ 156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42, 24, 32,157,229,
/* 0x07b0 */   8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,102, 30,133,226,
/* 0x07c0 */   3, 32,160,195, 32, 80,157,229,  0, 32,160,211,195, 50,140,224,
/* 0x07d0 */  24, 32,141,229, 28,192,157,229, 44, 32,157,229, 36, 80,141,229,
/* 0x07e0 */   4, 16,129,226,  4, 80,160,225, 32,192,141,229, 28, 32,141,229,
/* 0x07f0 */ 176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,172, 50, 76,224,
/* 0x0800 */   8,  0, 82,225,176, 48,192,225,  6, 96,100,224,236,  0,  0,138,
/* 0x0810 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x0820 */   6,100,131,225,102, 95,135,226,176,192,213,225,162, 53,160,225,
/* 0x0830 */ 156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,  2, 59,108,226,
/* 0x0840 */ 195, 50,140,224,  8,  0, 84,225,176, 48,197,225,252,  0,  0,138,
/* 0x0850 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  4, 68,160,225,
/* 0x0860 */   6,100,131,225,  8, 80,157,229,129, 48,133,224,138, 48,131,224,
/* 0x0870 */  30, 30,131,226,176,192,209,225,164, 53,160,225,156,  3,  2,224,
/* 0x0880 */   2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,  4, 80, 98, 32,
/* 0x0890 */  50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  0,  0, 91,227,
/* 0x08a0 */ 176, 48,193,225, 73,  2,  0, 10, 44,192,157,229, 24, 16,157,229,
/* 0x08b0 */  84,  0,157,229, 11, 48,108,224,  3,112,208,231,  6,  0, 81,227,
/* 0x08c0 */  11, 16,160,195,  9, 16,160,211, 24, 16,141,229, 11,112,192,231,
/* 0x08d0 */   2,  0,160,225,  1,176,139,226, 57,  2,  0,234,  2, 32,100,224,
/* 0x08e0 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,  6, 96,100,224,
/* 0x08f0 */  37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0900 */   2, 36,160,225,  6,100,131,225, 27, 30,135,226,176,192,209,225,
/* 0x0910 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 52,  1,  0, 42,
/* 0x0920 */  44, 80,157,229,  2, 59,108,226, 28, 32,157,229,195, 50,140,224,
/* 0x0930 */  28, 80,141,229,  4, 80,160,225, 44, 32,141,229,176, 48,193,225,
/* 0x0940 */  90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,
/* 0x0950 */ 176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,  9,  0, 94,225,
/* 0x0960 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0970 */ 114, 31,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x0980 */   4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226, 32, 32,157,229,
/* 0x0990 */ 195, 50,140,224, 44,  0,157,229, 28,192,157,229,  4, 80,160,225,
/* 0x09a0 */  32,192,141,229, 28,  0,141,229, 49,  1,  0,234,172, 50, 76,224,
/* 0x09b0 */ 176, 48,193,225, 44,192,157,229, 32, 16,141,226, 10,  0,145,232,
/* 0x09c0 */   2, 80,100,224, 28, 32,157,229, 36, 16,141,229, 32, 32,141,229,
/* 0x09d0 */  28,192,141,229, 44, 48,141,229,  6, 96,100,224, 24, 32,157,229,
/* 0x09e0 */   8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,  8, 32,160,211,
/* 0x09f0 */ 166, 30,128,226, 24, 32,141,229,  8, 16,129,226,255,116,224,227,
/* 0x0a00 */   7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0a10 */   1, 48,222,228,  5, 84,160,225,  6,100,131,225,176,192,209,225,
/* 0x0a20 */ 165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,120,  1,  0, 42,
/* 0x0a30 */  10, 34,129,224,  2, 59,108,226,195, 50,140,224,  4, 80,130,226,
/* 0x0a40 */   4,  0,160,225,  3,160,160,227,  0,128,160,227,176, 48,193,225,
/* 0x0a50 */ 152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,  7,  0, 82,225,
/* 0x0a60 */   6, 96,100,224,176, 48,193,225,131,  1,  0,138,  9,  0, 94,225,
/* 0x0a70 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0a80 */ 178,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0a90 */ 145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,
/* 0x0aa0 */  65, 95,130,226,  4,  0,160,225,  3,160,160,227,  8,128,160,227,
/* 0x0ab0 */ 178, 48,193,225,152,  1,  0,234,172, 50, 76,224,178, 48,193,225,
/* 0x0ac0 */   6, 96,100,224,  2,  0,100,224,129, 95,129,226,  8,160,160,227,
/* 0x0ad0 */  16,128,160,227, 10,112,160,225,  1, 16,160,227,  1, 48,129,226,
/* 0x0ae0 */   1,  4, 80,227,129, 64,160,225,  3, 16,129,224,164,  1,  0, 42,
/* 0x0af0 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0b00 */   6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,
/* 0x0b10 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x0b20 */   0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,180, 32,133, 49,
/* 0x0b30 */   6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,154,  1,  0, 26,
/* 0x0b40 */   1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,  8, 48,131,224,
/* 0x0b50 */   3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,  8,192,157,229,
/* 0x0b60 */   3,  0, 83,227,  3, 48,160,163,131, 51,140,224, 54, 94,131,226,
/* 0x0b70 */   2,112,160,225,  6,128,160,227,  1, 48,135,226,  1,  4, 80,227,
/* 0x0b80 */ 135, 64,160,225,  3,112,135,224,203,  1,  0, 42,  9,  0, 94,225,
/* 0x0b90 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0ba0 */ 180, 48,149,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,
/* 0x0bb0 */  12,  0, 86,225,194, 34,131,224,163, 50, 67,224,  0,  0,108,224,
/* 0x0bc0 */   4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,
/* 0x0bd0 */ 180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26, 64, 32, 71,226,
/* 0x0be0 */   3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,194, 64,160,225,
/* 0x0bf0 */  13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,  2,192,131,227,
/* 0x0c00 */   5, 64, 68,194,  8, 32,160,193,237,  1,  0,202, 28, 87,160,225,
/* 0x0c10 */   8, 16,157,229,133, 48,129,224,130, 48, 67,224, 85, 78,131,226,
/* 0x0c20 */  14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,  1, 32,130,226,
/* 0x0c30 */ 245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0c40 */   1, 48,222,228,  6,100,131,225,160,  0,160,225,  0,  0, 86,225,
/* 0x0c50 */ 140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,  4,  0, 82,225,
/* 0x0c60 */ 237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,  4, 64,132,226,
/* 0x0c70 */  12, 82,160,225,  4,112,160,227,  1,160,160,227, 10,128,160,225,
/* 0x0c80 */   1,  4, 80,227,136, 16,160,225,  1,192,136,226, 12,  2,  0, 42,
/* 0x0c90 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0ca0 */   6,100,131,225,177, 48,148,225,160, 37,160,225, 12,128,136,224,
/* 0x0cb0 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x0cc0 */ 163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49, 12,  0,160, 49,
/* 0x0cd0 */ 177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,  0,  0,108, 32,
/* 0x0ce0 */   1,112, 87,226,138,160,160,225,  3,  2,  0, 26,  1, 80,149,226,
/* 0x0cf0 */  44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,  7, 48,131,226,
/* 0x0d00 */  24, 48,141,229, 44, 80,157,229, 11,  0, 85,225, 73,  2,  0,138,
/* 0x0d10 */  40,192,157,229, 84, 16,157,229, 11, 48,101,224,  2, 32,140,226,
/* 0x0d20 */   3, 64,129,224, 11,192,129,224,  1, 32, 82,226, 88, 80,157,229,
/* 0x0d30 */   0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,  5,  0, 91,225,
/* 0x0d40 */   0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,  0,  0, 83,227,
/* 0x0d50 */   1,112,204,228, 45,  2,  0, 26, 88,192,157,229, 12,  0, 91,225,
/* 0x0d60 */  60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,  9,  0, 94,225,
/* 0x0d70 */  73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,  0, 16,157,229,
/* 0x0d80 */  92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,  0, 48,129,229,
/* 0x0d90 */   0,176,130,229, 74,  2,  0,234,  1,  0,160,227, 48,208,141,226,
/* 0x0da0 */ 240,143,189,232,248, 79, 45,233,  1,192,130,224, 40,144,157,229,
/* 0x0db0 */  44,112,157,229,  1,128,160,225,  9,160,135,224,  4,176,128,226,
/* 0x0dc0 */   0, 96,208,229,  1, 80,208,229,  2, 64,208,229,  6,224,133,224,
/* 0x0dd0 */   0,112,224,227, 23, 85,224,225, 23, 68,224,225,  1, 48,160,227,
/* 0x0de0 */   1, 32,160,227,  1, 16,160,227,  1,  0,160,227,255, 95, 45,233,
/* 0x0df0 */   0, 96,160,227, 28, 96,141,229,  3, 44,160,227, 18, 46,160,225,
/* 0x0e00 */  54, 32,130,226,  7, 44,130,226, 11, 16,160,225,  1, 11,160,227,
/* 0x0e10 */   1,  3,128,227,  4,  0,129,228,  2, 32, 82,226, 26,  0,  0,202,
/* 0x0e20 */   5,  0,136,226,  5,  1,  0,235,  8,  0, 80,225, 30,  0,  0, 26,
/* 0x0e30 */  36, 48,157,229, 16, 32,157,229,  3, 64, 73,224,  2,  0,  4,224,
/* 0x0e40 */  44,  0,141,229,  6,  2,128,224,  0, 16,139,226,  9,  1,  0,235,
/* 0x0e50 */  80,  0,  0, 26, 20, 48,157,229, 24, 32,157,229,  4, 48,  3,224,
/* 0x0e60 */  28,  0,221,229, 19, 50,160,225,  8, 32, 98,226, 48, 50,131,224,
/* 0x0e70 */ 108,160,139,226,131, 48,131,224, 14,172,138,226,  1,  0,160,227,
/* 0x0e80 */ 131,164,138,224,  7,  0, 86,227, 69,  0,  0, 58,  0, 16,157,229,
/* 0x0e90 */   1, 80, 89,231,133, 80,160,225,  2, 28,138,226,  1, 76,  5,226,
/* 0x0ea0 */ 132, 16,129,224, 11,  1,  0,235,  1, 48,  0,226, 36,  4, 83,225,
/* 0x0eb0 */  71,  0,  0, 26,  1, 12, 80,227, 58,  0,  0, 58, 73,  0,  0,234,
/* 0x0ec0 */  10, 16,160,225, 11,  1,  0,235,  1, 12, 80,227, 69,  0,  0, 58,
/* 0x0ed0 */   6, 48,160,227, 10,  0, 86,227,  3, 48,160, 51,  4,  0, 86,227,
/* 0x0ee0 */   6, 48,160, 49,  3, 96, 70,224,112,  0,  0,234,  6, 29,139,226,
/* 0x0ef0 */   8,  1,  0,235, 95,  0,  0, 26,  8, 48,157,229,  4, 32,157,229,
/* 0x0f00 */   0, 16,157,229, 12, 48,141,229,  8, 32,141,229,  4, 16,141,229,
/* 0x0f10 */   7,  0, 86,227,  3, 96,160,227,  0, 96,160, 51,100,160,139,226,
/* 0x0f20 */   6,172,138,226,135,  0,  0,234,102, 31,139,226,  8,  1,  0,235,
/* 0x0f30 */ 114,  0,  0, 26, 44, 48,157,229, 30, 30,139,226,  6,  2,131,224,
/* 0x0f40 */   9,  1,  0,235,130,  0,  0, 26,  7,  0, 86,227, 11, 96,160,227,
/* 0x0f50 */   9, 96,160, 51, 36, 48,157,229,  0, 16,157,229,  3, 64, 73,224,
/* 0x0f60 */   1,  0, 84,225,253,  0,  0, 58,  1,  0, 89,231,  1,  0,201,228,
/* 0x0f70 */ 237,  0,  0,234, 27, 30,139,226,  8,  1,  0,235,  4, 64,157,229,
/* 0x0f80 */ 127,  0,  0, 10,114, 31,139,226,  8,  1,  0,235,  8, 64,157,229,
/* 0x0f90 */ 125,  0,  0, 10,  8, 48,157,229, 12, 64,157,229, 12, 48,141,229,
/* 0x0fa0 */   4, 48,157,229,  8, 48,141,229,  0, 16,157,229,  0, 64,141,229,
/* 0x0fb0 */   4, 16,141,229,  7,  0, 86,227, 11, 96,160,227,  8, 96,160, 51,
/* 0x0fc0 */ 104,160,139,226, 10,172,138,226,  0, 16,138,226, 10,  1,  0,235,
/* 0x0fd0 */ 144,  0,  0, 26, 44, 48,157,229,  4, 80,138,226,  0, 32,160,227,
/* 0x0fe0 */   3, 82,133,224,  8, 64,160,227,156,  0,  0,234,  2, 16,138,226,
/* 0x0ff0 */  10,  1,  0,235,153,  0,  0, 26, 44, 48,157,229, 65, 95,138,226,
/* 0x1000 */   8, 32,160,227,  3, 82,133,224,  8, 64,160,227,156,  0,  0,234,
/* 0x1010 */ 129, 95,138,226, 16, 32,160,227,  1, 76,160,227, 52, 32,141,229,
/* 0x1020 */   1,  0,160,227,  5, 16,160,225, 11,  1,  0,235,  4, 48, 80,224,
/* 0x1030 */ 158,  0,  0, 58, 52, 80,157,229,  3, 80,133,224, 52, 80,141,229,
/* 0x1040 */   0, 16,157,229,  4,  0, 86,227,225,  0,  0, 42,  7, 96,134,226,
/* 0x1050 */   4,  0, 85,227,  3, 80,160, 35,133, 83,139,224, 54, 94,133,226,
/* 0x1060 */   1,  0,160,227, 64, 64,160,227,  5, 16,160,225, 11,  1,  0,235,
/* 0x1070 */   4, 48, 80,224,175,  0,  0, 58, 44, 48,141,229,  4,  0, 83,227,
/* 0x1080 */ 221,  0,  0, 58,163, 64,160,225,  1, 64, 68,226,  1, 16,  3,226,
/* 0x1090 */   2, 16,129,227, 14,  0, 83,227,194,  0,  0, 42, 17, 20,160,225,
/* 0x10a0 */  94,160,139,226,  3, 48, 65,224,  5,172,138,226,131,160,138,224,
/* 0x10b0 */ 206,  0,  0,234,  4, 64, 68,226,255,  0,  0,235,167,112,160,225,
/* 0x10c0 */   7,  0, 92,225,  7,192, 76, 32,  1, 16,161,224,  1, 64, 84,226,
/* 0x10d0 */ 195,  0,  0, 26, 68,160,139,226,  6,172,138,226,  1, 18,160,225,
/* 0x10e0 */   4, 64,160,227,  0, 16,141,229,  1, 80,160,227,  1,  0,160,227,
/* 0x10f0 */  10, 16,160,225, 11,  1,  0,235,  1,  0, 16,227,216,  0,  0, 10,
/* 0x1100 */   0, 16,157,229,  5, 16,129,225,  0, 16,141,229,133, 80,160,225,
/* 0x1110 */   1, 64, 84,226,209,  0,  0, 26,  0, 16,157,229,222,  0,  0,234,
/* 0x1120 */  44, 16,157,229,  1, 16,145,226,  0, 16,141,229, 52, 80,157,229,
/* 0x1130 */  36, 48,157,229,  2, 80,133,226,  3, 48, 73,224,  3,  0, 81,225,
/* 0x1140 */ 253,  0,  0,138, 40, 32,157,229,  1,  0, 89,231,  1,  0,201,228,
/* 0x1150 */   2,  0, 89,225,241,  0,  0, 42,  1, 80, 85,226,231,  0,  0, 26,
/* 0x1160 */  28,  0,205,229, 40, 32,157,229,  2,  0, 89,225, 33,  0,  0, 58,
/* 0x1170 */ 255,  0,  0,235,  0,  0,160,227, 32, 32,157,229,  2, 48, 72,224,
/* 0x1180 */  56, 32,157,229,  0, 48,130,229, 36, 32,157,229,  2, 48, 73,224,
/* 0x1190 */ 104, 32,157,229,  0, 48,130,229, 60,208,141,226,240,143,189,232,
/* 0x11a0 */   1,  0,160,227,243,  0,  0,234,  1,  4, 87,227, 14,240,160, 33,
/* 0x11b0 */  48, 48,157,229,  7,116,160,225,  8,  0, 83,225,253,  0,  0, 10,
/* 0x11c0 */   1, 48,216,228, 12,196,131,225, 14,240,160,225,  6,  0,160,225,
/* 0x11d0 */ 128, 16,129,224,  0,  0,160,227,128, 16,129,224,  1,  4, 87,227,
/* 0x11e0 */  14, 32,160,225,  1,  1,  0, 59,176, 48,209,225,167,229,160,225,
/* 0x11f0 */ 147, 14, 14,224, 14,  0, 92,225, 14,112,160, 49, 14,112, 71, 32,
/* 0x1200 */   2,235, 99, 50, 14,192, 76, 32,174, 50,131, 48,163, 50, 67, 32,
/* 0x1210 */   0,  0,176,224,176, 48,193,225,  2,240,160,225, 20, 48,141,229,
/* 0x1220 */   4, 96,142,226,  0, 80,160,227,  0, 64,224,227,  7, 32,160,227,
/* 0x1230 */   0, 16,150,229,  0,  0,160,227, 12, 16,141,229,192,112,160,227,
/* 0x1240 */   0,  0,  0,239,  8,  0,141,229,  0, 48,150,229,  4, 48, 45,229,
/* 0x1250 */  13, 48,160,225,  0, 32,160,225,  8,  0,214,229,  4,  0, 45,229,
/* 0x1260 */   4, 16,150,229, 12,  0,134,226,  2,160,160,225, 15,224,160,225,
/* 0x1270 */  24,240,157,229,  4,208,141,226,  4, 48,157,228, 20, 16,157,229,
/* 0x1280 */   4, 16,138,228,  5, 32,160,227, 12, 16,157,229,  8,  0,157,229,
/* 0x1290 */ 125,112,160,227,  0,  0,  0,239,  0,  0,157,229,  4, 16, 22,229,
/* 0x12a0 */   1, 80,128,224,  1, 64, 73,224,  0,224,143,226, 10,240,160,225,
/* 0x12b0 */  47,112,114,111, 99, 47,115,101,108,102, 47,101,120,101,  0,  0,
/* 0x12c0 */  16,  0, 30,229, 16, 96, 78,226, 16,224,141,229,  0, 96, 70,224,
/* 0x12d0 */   0, 96,141,229,  0,144,160,225, 48,  0, 79,226,  0, 16,160,227,
/* 0x12e0 */   5,112,160,227,  0,  0,  0,239,  4,  0,141,229, 12, 48, 30,229,
/* 0x12f0 */ 254,255,255,235,  0,  0,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x1300 */ 109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101,
/* 0x1310 */  97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x1320 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1330 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1340 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1350 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1360 */ 108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1370 */  88, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x1380 */  32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1390 */  69, 78, 84, 83, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x13a0 */  68, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x13b0 */  48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x13c0 */  78, 84, 83, 10, 32, 32, 50, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x13d0 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x13e0 */  52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x13f0 */  84, 83, 10, 32, 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32,
/* 0x1400 */  32, 32, 32, 32, 32, 48, 49, 52, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x1410 */  32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1420 */  69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 68, 32, 32,
/* 0x1430 */  32, 32, 32, 32, 32, 32, 32, 48, 49, 51, 48, 32, 32, 48, 32, 32,
/* 0x1440 */  48, 32, 32, 48, 49, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1450 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50,
/* 0x1460 */  66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,102, 52, 32, 32, 48,
/* 0x1470 */  32, 32, 48, 32, 32, 48, 50, 98, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1480 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 90,
/* 0x1490 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 99, 52, 32,
/* 0x14a0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 97, 56, 32, 32, 50, 42, 42,
/* 0x14b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,
/* 0x14c0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 57,
/* 0x14d0 */  51, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 54, 99, 32, 32,
/* 0x14e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x14f0 */  32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32,
/* 0x1500 */  32, 48, 52, 55, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 97,
/* 0x1510 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1520 */  83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x1530 */  32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50,
/* 0x1540 */  49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1550 */  84, 83, 10, 32, 49, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32,
/* 0x1560 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1570 */  50, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1580 */  78, 84, 83, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1590 */  32, 32, 32, 32, 32, 32, 48,100, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x15a0 */  32, 48, 49, 50, 49, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79,
/* 0x15b0 */  78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65,
/* 0x15c0 */  66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x15d0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82,
/* 0x15e0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x15f0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86,
/* 0x1600 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1610 */  32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50,
/* 0x1620 */  66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1630 */ 100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32,
/* 0x1640 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x1650 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1660 */  95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1670 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1680 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x1690 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x16a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76,
/* 0x16b0 */  70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x16c0 */  90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x16d0 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 69, 76,
/* 0x16e0 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x16f0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,
/* 0x1700 */  32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48,
/* 0x1710 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x1720 */  95, 84, 65, 73, 76, 32, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x1730 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1740 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76,
/* 0x1750 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1760 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x1770 */  73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48,
/* 0x1780 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1790 */  42, 85, 78, 68, 42, 32, 48, 32, 77, 70, 76, 71, 10, 48, 48, 48,
/* 0x17a0 */  48, 48, 48, 48, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x17b0 */  70, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,114,116, 10,
/* 0x17c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x17d0 */  32, 78, 82, 86, 50, 69, 32, 48, 49, 52, 52, 32,117, 99,108, 95,
/* 0x17e0 */ 110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x17f0 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1800 */  32, 32, 70, 32, 78, 82, 86, 50, 68, 32, 48, 49, 51, 48, 32,117,
/* 0x1810 */  99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,
/* 0x1820 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x1830 */  32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66, 32, 48,102, 52,
/* 0x1840 */  32,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,
/* 0x1850 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1860 */  32,103, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1870 */  67, 49, 48, 32, 48, 32, 76,122,109, 97, 68,101, 99,111,100,101,
/* 0x1880 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1890 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32,101,110,100,
/* 0x18a0 */  95,100,101, 99,111,109,112,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x18b0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x18c0 */  68, 42, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79, 10, 48, 48, 48,
/* 0x18d0 */  48, 48, 48,100, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x18e0 */  70, 77, 65, 73, 78, 90, 32, 48, 32, 99,112,114, 48, 10, 10, 82,
/* 0x18f0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x1900 */  83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93,
/* 0x1910 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1920 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1930 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82,
/* 0x1940 */  77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 70,
/* 0x1950 */  76, 71, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82,
/* 0x1960 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1970 */  70, 77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1980 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1990 */  78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x19a0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x19b0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x19c0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x19d0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x19e0 */  55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x19f0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1a10 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1a20 */  48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1a30 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1a40 */  48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1a50 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1a60 */  48, 48, 48, 48, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1a70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1a90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1ab0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1ac0 */  10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x1ad0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1ae0 */  69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77,
/* 0x1af0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1b00 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82,
/* 0x1b10 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1b20 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65,
/* 0x1b30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1b40 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95,
/* 0x1b50 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b60 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82,
/* 0x1b70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b80 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101, 56, 32,
/* 0x1b90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1ba0 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101, 99,
/* 0x1bb0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1bc0 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,102,
/* 0x1bd0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1be0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49,
/* 0x1bf0 */  48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1c00 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1c10 */  49, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1c20 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1c30 */  48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1c40 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1c50 */  48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1c60 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1c70 */  48, 48, 48, 49, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1c80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1c90 */  48, 48, 48, 48, 49, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1ca0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1cb0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1cc0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58,
/* 0x1cd0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x1ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x1cf0 */  69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77,
/* 0x1d00 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1d10 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82,
/* 0x1d20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1d30 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x1d40 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1d50 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95,
/* 0x1d60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d70 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,
/* 0x1d80 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d90 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 56, 32,
/* 0x1da0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1db0 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97, 52,
/* 0x1dc0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1dd0 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x1de0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1df0 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1e00 */  98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1e10 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1e30 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1e50 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x1e60 */  48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1e70 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x1e80 */  48, 48, 48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1e90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x1ea0 */  48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1eb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x1ec0 */  48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1ed0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x1ee0 */  10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1ef0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1f00 */  68, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x1f10 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1f20 */  50, 68, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82,
/* 0x1f30 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1f40 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 50, 99, 32, 82, 95, 65,
/* 0x1f50 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1f60 */  82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1f70 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x1f80 */  86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1f90 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1fa0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,
/* 0x1fb0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1fc0 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 55, 56,
/* 0x1fd0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1fe0 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x1ff0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2000 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2020 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x2030 */  48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2040 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x2050 */  48, 48, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2060 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2070 */  48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2080 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x2090 */  48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x20a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x20c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x20e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x20f0 */  10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2100 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2110 */  66, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x2120 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2130 */  50, 66, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82,
/* 0x2140 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2150 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65,
/* 0x2160 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2170 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,102, 48, 32, 82, 95,
/* 0x2180 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2190 */  78, 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x21a0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x21b0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x21c0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x21d0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x21e0 */  48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x21f0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x2200 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65, 82,
/* 0x2210 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2220 */  77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x2230 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2240 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x2250 */  48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2260 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x2270 */  76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x2280 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x2290 */  77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x22a0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22b0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x22c0 */  48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x22d0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x22e0 */  48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77,
/* 0x22f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2300 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x2310 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2320 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2330 */  48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2340 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2350 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65,
/* 0x2360 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2370 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x2380 */  48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x23a0 */  48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x23b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x23c0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82,
/* 0x23d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x23f0 */  48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2400 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2410 */  48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x2420 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2430 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56,
/* 0x2440 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2450 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2460 */  48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2470 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2480 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65,
/* 0x2490 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x24a0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x24b0 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x24c0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x24d0 */  48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x24e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x24f0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82,
/* 0x2500 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2510 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2520 */  48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2530 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2540 */  48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x2550 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2560 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56,
/* 0x2570 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2590 */  48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x25a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x25b0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65,
/* 0x25c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x25d0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x25e0 */ 101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x25f0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2600 */  48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2610 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2620 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82,
/* 0x2630 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2640 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2650 */  48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2660 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2670 */  48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77,
/* 0x2680 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2690 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48,
/* 0x26a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x26b0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x26c0 */  48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x26d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x26e0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65,
/* 0x26f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2700 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x2710 */ 101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2720 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2730 */  48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2740 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2750 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82,
/* 0x2760 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2770 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2780 */  48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2790 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x27a0 */  48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77,
/* 0x27b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x27c0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52,
/* 0x27d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x27e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x27f0 */  48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2800 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2810 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65,
/* 0x2820 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2830 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x2840 */ 100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2850 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2860 */  48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2870 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2880 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82,
/* 0x2890 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x28a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x28b0 */  48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x28c0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x28d0 */  48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77,
/* 0x28e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x28f0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56,
/* 0x2900 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2910 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2920 */  48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2930 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2940 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65,
/* 0x2950 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2960 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x2970 */ 101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2980 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2990 */  48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x29a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x29b0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82,
/* 0x29c0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x29d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x29e0 */  48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x29f0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2a00 */  48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77,
/* 0x2a10 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2a20 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48,
/* 0x2a30 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2a40 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2a50 */  48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2a70 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65,
/* 0x2a80 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2a90 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x2aa0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ab0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2ac0 */  48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ad0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2ae0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82,
/* 0x2af0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b00 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2b10 */  48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2b20 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2b30 */  48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2b40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2b50 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99,
/* 0x2b60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b70 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2b80 */  48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2ba0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65,
/* 0x2bb0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2bc0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x2bd0 */ 100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2be0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2bf0 */  48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2c00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2c10 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82,
/* 0x2c20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c30 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2c40 */  48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2c50 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2c60 */  48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2c70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2c80 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56,
/* 0x2c90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ca0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2cb0 */  48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2cc0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2cd0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65,
/* 0x2ce0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2cf0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x2d00 */ 102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2d10 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2d20 */  48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2d30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2d40 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82,
/* 0x2d50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d60 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2d70 */  48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d80 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2d90 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2da0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95,
/* 0x2db0 */  68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2dc0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2dd0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x2de0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2df0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x2e00 */  48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2e10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2e20 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95,
/* 0x2e30 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e40 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x2e50 */  48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2e60 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x2e70 */  10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e80 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2e90 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,101, 52, 32,
/* 0x2ea0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2eb0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x2ec0 */  48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2ed0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2ee0 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82,
/* 0x2ef0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2f00 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49,
/* 0x2f10 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2f20 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x2f30 */  48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2f40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2f50 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95,
/* 0x2f60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f70 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x2f80 */  49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2f90 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x2fa0 */  10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2fb0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2fc0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32,
/* 0x2fd0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2fe0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x2ff0 */  48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3000 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3010 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 48, 32, 82, 95, 65, 82,
/* 0x3020 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3030 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56,
/* 0x3040 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3050 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3060 */  48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3070 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3080 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95,
/* 0x3090 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x30a0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x30b0 */  49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x30c0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x30d0 */  10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x30e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x30f0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32,
/* 0x3100 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3110 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3120 */  48, 48, 49,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3130 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3140 */  49, 48, 10, 48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82,
/* 0x3150 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3160 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101,
/* 0x3170 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3180 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3190 */  48, 48, 48, 48, 49,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x31a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x31b0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95,
/* 0x31c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x31d0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x31e0 */  50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x31f0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3200 */  10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3210 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3220 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32,
/* 0x3230 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3240 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3250 */  48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3260 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3270 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 54, 56, 32, 82, 95, 65, 82,
/* 0x3280 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3290 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56,
/* 0x32a0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x32b0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x32c0 */  48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x32d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x32e0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95,
/* 0x32f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3300 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3310 */  50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3320 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3330 */  10, 48, 48, 48, 48, 48, 50,100, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3340 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3350 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100, 99, 32,
/* 0x3360 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3370 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3380 */  48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3390 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x33a0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82,
/* 0x33b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x33c0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 49,
/* 0x33d0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x33e0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x33f0 */  48, 48, 48, 48, 51, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3400 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3410 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95,
/* 0x3420 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3430 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3440 */  51, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3450 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3460 */  10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3470 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3480 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55, 56, 32,
/* 0x3490 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x34a0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x34b0 */  48, 48, 51, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x34c0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x34d0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 48, 32, 82, 95, 65, 82,
/* 0x34e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x34f0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98,
/* 0x3500 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3510 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3520 */  48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3530 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3540 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95,
/* 0x3550 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3560 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3570 */  52, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3580 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3590 */  10, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x35a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x35b0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32,
/* 0x35c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x35d0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x35e0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x35f0 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58,
/* 0x3600 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3610 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3620 */  69, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77,
/* 0x3630 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3640 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x3650 */  95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x3660 */  32, 79, 95, 66, 73, 78, 70, 79, 10
};
