/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INITIALSURFACEPLACEMENTSTRATEGY_H
#define INITIALSURFACEPLACEMENTSTRATEGY_H

#include <memory>

#include "mirserver/mir/shell/placement_strategy.h"
#include "mirserver/mir/shell/display_layout.h"
#include "mir/shell/session.h"
#include "mir/scene/depth_id.h"

#include <QObject>
#include <QMutex>

class InitialSurfacePlacementStrategy : public QObject, public mir::shell::PlacementStrategy
{
    Q_OBJECT

public:
    InitialSurfacePlacementStrategy(const std::shared_ptr<mir::shell::DisplayLayout> &displayLayout,
                                    QObject *parent = 0);
    ~InitialSurfacePlacementStrategy();

    mir::shell::SurfaceCreationParameters place(const mir::shell::Session &session,
                                                const mir::shell::SurfaceCreationParameters &requestParameters) override;

Q_SIGNALS:
    void requestPlacementForSession(const mir::shell::Session *session, uint32_t &x, uint32_t &y);
        
private:
    const std::shared_ptr<mir::shell::DisplayLayout> m_displayLayout;
    QMutex m_mutex;
    bool m_mainShellSurfaceFound;
};

#endif // INITIALSURFACEPLACEMENTSTRATEGY_H
