/*
 * Copyright 2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef FAKESSOSERVICE_H
#define FAKESSOSERVICE_H

#include <QObject>
#include <token.h>

using namespace UbuntuOne;

namespace UbuntuPurchases {

class FakeSsoService : public QObject
{
    Q_OBJECT
public:
    explicit FakeSsoService(QObject *parent = 0);
    void getCredentials();

    bool valid;

signals:
    void credentialsFound(const Token&);
    void credentialsNotFound();

};

}

#endif // FAKESSOSERVICE_H
