/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.event;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.activities.PActivity;
import org.piccolo2d.activities.PTransformActivity;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PAffineTransform;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDimension;

public class PNavigationEventHandler
extends PBasicInputEventHandler {
    private static final double SCALING_THRESHOLD = 1.0E-4;
    private static final int NAVIGATION_DURATION = 500;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int IN = 4;
    public static final int OUT = 5;
    private static Hashtable NODE_TO_GLOBAL_NODE_CENTER_MAPPING = new Hashtable();
    private PNode focusNode;
    private PTransformActivity navigationActivity;

    public PNavigationEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void keyPressed(PInputEvent event) {
        PNode oldLocation = this.focusNode;
        switch (event.getKeyCode()) {
            case 37: {
                this.moveFocusLeft(event);
                break;
            }
            case 39: {
                this.moveFocusRight(event);
                break;
            }
            case 33: 
            case 38: {
                if (event.isAltDown()) {
                    this.moveFocusOut(event);
                    break;
                }
                this.moveFocusUp(event);
                break;
            }
            case 34: 
            case 40: {
                if (event.isAltDown()) {
                    this.moveFocusIn(event);
                    break;
                }
                this.moveFocusDown(event);
                break;
            }
        }
        if (this.focusNode != null && oldLocation != this.focusNode) {
            this.directCameraViewToFocus(event.getCamera(), this.focusNode, 500);
        }
    }

    public void mousePressed(PInputEvent event) {
        this.moveFocusToMouseOver(event);
        if (this.focusNode != null) {
            this.directCameraViewToFocus(event.getCamera(), this.focusNode, 500);
            event.getInputManager().setKeyboardFocus((PInputEventListener)event.getPath());
        }
    }

    public void moveFocusDown(PInputEvent event) {
        this.moveFocusInDirection(1);
    }

    public void moveFocusIn(PInputEvent event) {
        this.moveFocusInDirection(4);
    }

    public void moveFocusLeft(PInputEvent event) {
        this.moveFocusInDirection(3);
    }

    public void moveFocusOut(PInputEvent event) {
        this.moveFocusInDirection(5);
    }

    public void moveFocusRight(PInputEvent event) {
        this.moveFocusInDirection(2);
    }

    public void moveFocusUp(PInputEvent event) {
        this.moveFocusInDirection(0);
    }

    private void moveFocusInDirection(int direction) {
        PNode n = this.getNeighborInDirection(direction);
        if (n != null) {
            this.focusNode = n;
        }
    }

    public void moveFocusToMouseOver(PInputEvent event) {
        PNode focus = event.getPickedNode();
        if (!(focus instanceof PCamera)) {
            this.focusNode = focus;
        }
    }

    public PNode getNeighborInDirection(int direction) {
        if (this.focusNode == null) {
            return null;
        }
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.clear();
        Point2D highlightCenter = this.focusNode.getGlobalFullBounds().getCenter2D();
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(this.focusNode, highlightCenter);
        List l = this.getNeighbors();
        this.sortNodesByDistanceFromPoint(l, highlightCenter);
        for (PNode each : l) {
            if (!this.nodeIsNeighborInDirection(each, direction)) continue;
            return each;
        }
        return null;
    }

    public List getNeighbors() {
        ArrayList<PNode> result = new ArrayList<PNode>();
        if (this.focusNode == null || this.focusNode.getParent() == null) {
            return result;
        }
        PNode focusParent = this.focusNode.getParent();
        ListIterator i = focusParent.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (each == this.focusNode || !each.getPickable()) continue;
            result.add(each);
        }
        result.add(focusParent);
        result.addAll(this.focusNode.getChildrenReference());
        return result;
    }

    public boolean nodeIsNeighborInDirection(PNode node, int direction) {
        switch (direction) {
            case 4: {
                return node.isDescendentOf(this.focusNode);
            }
            case 5: {
                return node.isAncestorOf(this.focusNode);
            }
        }
        if (node.isAncestorOf(this.focusNode) || node.isDescendentOf(this.focusNode)) {
            return false;
        }
        Point2D highlightCenter = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(this.focusNode);
        Point2D nodeCenter = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(node);
        double ytest1 = nodeCenter.getX() - highlightCenter.getX() + highlightCenter.getY();
        double ytest2 = -nodeCenter.getX() + highlightCenter.getX() + highlightCenter.getY();
        switch (direction) {
            case 0: {
                return nodeCenter.getY() < highlightCenter.getY() && nodeCenter.getY() < ytest1 && nodeCenter.getY() < ytest2;
            }
            case 2: {
                return nodeCenter.getX() > highlightCenter.getX() && nodeCenter.getY() < ytest1 && nodeCenter.getY() > ytest2;
            }
            case 1: {
                return nodeCenter.getY() > highlightCenter.getY() && nodeCenter.getY() > ytest1 && nodeCenter.getY() > ytest2;
            }
            case 3: {
                return nodeCenter.getX() < highlightCenter.getX() && nodeCenter.getY() > ytest1 && nodeCenter.getY() < ytest2;
            }
        }
        return false;
    }

    public void sortNodesByDistanceFromPoint(List nodes, final Point2D point) {
        Collections.sort(nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.compare((PNode)o1, (PNode)o2);
            }

            private int compare(PNode each1, PNode each2) {
                Point2D center1 = each1.getGlobalFullBounds().getCenter2D();
                Point2D center2 = each2.getGlobalFullBounds().getCenter2D();
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(each1, center1);
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(each2, center2);
                return Double.compare(point.distance(center1), point.distance(center2));
            }
        });
    }

    protected PActivity animateCameraViewTransformTo(PCamera camera, AffineTransform targetTransform, int duration) {
        boolean wasOldAnimation = false;
        if (this.navigationActivity != null) {
            this.navigationActivity.terminate();
            wasOldAnimation = true;
        }
        if (duration == 0) {
            camera.setViewTransform(targetTransform);
            return null;
        }
        PAffineTransform source = camera.getViewTransformReference();
        if (source.equals(targetTransform)) {
            return null;
        }
        this.navigationActivity = camera.animateViewToTransform(targetTransform, (long)duration);
        this.navigationActivity.setSlowInSlowOut(!wasOldAnimation);
        return this.navigationActivity;
    }

    public PActivity directCameraViewToFocus(PCamera camera, PNode newFocus, int duration) {
        this.focusNode = newFocus;
        PAffineTransform originalViewTransform = camera.getViewTransform();
        PDimension d = new PDimension(1.0, 0.0);
        this.focusNode.globalToLocal((Dimension2D)d);
        double scaleFactor = d.getWidth() / camera.getViewScale();
        Point2D scalePoint = this.focusNode.getGlobalFullBounds().getCenter2D();
        if (Math.abs(1.0 - scaleFactor) < 1.0E-4) {
            camera.scaleViewAboutPoint(scaleFactor, scalePoint.getX(), scalePoint.getY());
        }
        camera.animateViewToPanToBounds((Rectangle2D)this.focusNode.getGlobalFullBounds(), 0L);
        PAffineTransform resultingTransform = camera.getViewTransform();
        camera.setViewTransform((AffineTransform)originalViewTransform);
        return this.animateCameraViewTransformTo(camera, (AffineTransform)resultingTransform, duration);
    }

    protected void fillViewWhiteSpace(PCamera camera) {
        PBounds rootBounds = camera.getRoot().getFullBoundsReference();
        if (rootBounds.contains((Rectangle2D)camera.getViewBounds())) {
            return;
        }
        camera.animateViewToPanToBounds((Rectangle2D)rootBounds, 0L);
        camera.animateViewToPanToBounds((Rectangle2D)this.focusNode.getGlobalFullBounds(), 0L);
        double dx = 0.0;
        double dy = 0.0;
        PBounds viewBounds = camera.getViewBounds();
        if (viewBounds.getWidth() > rootBounds.getWidth()) {
            dx = rootBounds.getCenterX() - viewBounds.getCenterX();
        }
        if (viewBounds.getHeight() > rootBounds.getHeight()) {
            dy = rootBounds.getCenterX() - viewBounds.getCenterX();
        }
        camera.translateView(dx, dy);
    }
}

