
[//000000001]: # (doctools::idx::export::html \- Documentation tools)
[//000000002]: # (Generated from file 'plugin\.inc' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2009\-2019 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>)
[//000000004]: # (doctools::idx::export::html\(n\) 0\.3 tcllib "Documentation tools")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

doctools::idx::export::html \- HTML export plugin

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Configuration](#section3)

  - [Keyword index serialization format](#section4)

  - [Bugs, Ideas, Feedback](#section5)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require doctools::idx::export::html ?0\.3?  
package require doctools::text  
package require doctools::html  
package require doctools::html::cssdefaults  

[__[export](\.\./\.\./\.\./\.\./index\.md\#export)__ *serial* *configuration*](#1)  

# <a name='description'></a>DESCRIPTION

This package implements the doctools keyword index export plugin for the
generation of HTML markup\.

This is an internal package of doctools, for use by the higher level management
packages handling keyword indices, especially
__[doctools::idx::export](idx\_export\.md)__, the export manager\.

Using it from a regular interpreter is possible, however only with contortions,
and is not recommended\. The proper way to use this functionality is through the
package __[doctools::idx::export](idx\_export\.md)__ and the export
manager objects it provides\.

# <a name='section2'></a>API

The API provided by this package satisfies the specification of the docidx
export plugin API version 2\.

  - <a name='1'></a>__[export](\.\./\.\./\.\./\.\./index\.md\#export)__ *serial* *configuration*

    This command takes the canonical serialization of a keyword index, as
    specified in section [Keyword index serialization format](#section4),
    and contained in *serial*, the *configuration*, a dictionary, and
    generates HTML markup encoding the index\. The created string is then
    returned as the result of the command\.

# <a name='section3'></a>Configuration

The html export plugin recognizes the following configuration variables and
changes its behaviour as they specify\.

  - string *user*

    This standard configuration variable contains the name of the user running
    the process which invoked the export plugin\. The plugin puts this
    information into the provenance comment at the beginning of the generated
    document\.

  - string *file*

    This standard configuration variable contains the name of the file the index
    came from\. This variable may not be set or contain the empty string\. The
    plugin puts this information, if defined, i\.e\. set and not the empty string,
    into the provenance comment at the beginning of the generated document\.

  - dictionary *map*

    This standard configuration variable contains a dictionary mapping from the
    symbolic files names in manpage references to the actual filenames and/or
    urls to be used in the output\.

    Url references and symbolic file names without a mapping are used unchanged\.

  - boolean *newlines*

    If this flag is set the plugin will break the generated html code across
    lines, with each markup command on a separate line\.

    If this flag is not set \(the default\), the whole document will be written on
    a single line, with minimum spacing between all elements\.

  - boolean *indented*

    If this flag is set the plugin will indent the markup commands according to
    the structure of indices\. To make this work this also implies that
    __newlines__ is set\.

    If this flag is not set \(the default\), the output is formatted as per the
    value of __newlines__, and no indenting is done\.

  - string *meta*

    This variable is meant to hold a fragment of HTML \(default: empty\)\. The
    fragment it contains will be inserted into the generated output in the
    <head> section of the document, just after the <title> tag\.

  - string *header*

    This variable is meant to hold a fragment of HTML \(default: empty\)\. The
    fragment it contains will be inserted into the generated output just after
    the <h1> title tag in the body of the document, in the class\.header
    <div>'ision\.

  - string *footer*

    This variable is meant to hold a fragment of HTML \(default: empty\)\. The
    fragment it contains will be inserted into the generated output just before
    the </body> tag, in the class\.footer <div>'ision\.

  - dictionary *kwid*

    The value of this variable \(default: empty\) maps keywords to the identifiers
    to use as their anchor names\. Each keyword __FOO__ not found in the
    dictionary uses __KW\-____FOO__ as anchor, i\.e\. itself prefixed with
    the string __KW\-__\.

  - string *sepline*

    The value of this variable is the string to use for the separator comments
    inserted into the output when the outpout is broken across lines and/or
    indented\. The default string consists of 60 dashes\.

  - integer *kwidth*

    This variable holds the size of the keyword column in the main table
    generated by the plugin, in percent of the total width of the table\. This is
    an integer number in the range of 1 to 99\. Choosing a value outside of that
    range causes the generator to switch back to the defauly setting, 35
    percent\.

  - string *dot*

    This variable contains a HTML fragment inserted between the entries of the
    navigation bar, and the references associated with each keyword\. The default
    is the HTML entity &\#183; i\.e\. the bullet character, also known as the
    "Greek middle dot", i\.e\. the unicode character 00B7\.

  - string *class\.main*

    This variable contains the class name for the main <div>'ivision of the
    generated document\. The default is __doctools__\.

  - string *class\.header*

    This variable contains the class name for the header <div>'ision of the
    generated document\. The default is __idx\-header__\. This division
    contains the document title, the user specified __header__, if any, a
    visible separator line, and the navigation bar for quick access to each
    keyword section\.

  - string *class\.title*

    This variable contains the class name for the <h1> tag enclosing the
    document title\. The default is __idx\-title__\.

  - string *class\.navsep*

    This variable contains the class name for the <hr> separators in the header
    and footer sections of the generated document\. The default is
    __idx\-navsep__\.

  - string *class\.navbar*

    This variable contains the class name for the navigation <div>'ision
    enclosing the navigation bar of the generated document\. The default is
    __idx\-kwnav__\.

  - string *class\.contents*

    This variable contains the class name for the <table> holding the keywords
    and their references in the generated document\. The default is
    __idx\-contents__\.

  - string *class\.leader*

    This variable contains the class name for the anchor names the plugin
    inserts into the keyword table when switching from one section to the next
    \(Each section holds all keywords with a particular first character\)\. The
    default is __idx\-leader__\.

  - string *class\.row0*

    This variable contains the class name used to label the even rows \(<tr>\) of
    the keyword table\. The default is __idx\-even__\.

  - string *class\.row1*

    This variable contains the class name used to label the odd rows \(<tr>\) of
    the keyword table\. The default is __idx\-odd__\.

  - string *class\.keyword*

    This variable contains the class name used to label the keyword cells/column
    \(<td>\) in the keyword table of the document\. The default is
    __idx\-keyword__\.

  - string *class\.refs*

    This variable contains the class name used to label the reference
    cells/column \(<td>\) in the keyword table of the document\. The default is
    __idx\-refs__\.

  - string *class\.footer*

    This variable contains the class name for the footer <div>'ision of the
    generated document\. The default is __idx\-footer__\. This division
    contains a browser\-visible separator line and the user specified
    __footer__, if any\.

*Note* that this plugin ignores the standard configuration variable
__format__, and its value\.

# <a name='section4'></a>Keyword index serialization format

Here we specify the format used by the doctools v2 packages to serialize keyword
indices as immutable values for transport, comparison, etc\.

We distinguish between *regular* and *canonical* serializations\. While a
keyword index may have more than one regular serialization only exactly one of
them will be *canonical*\.

  - regular serialization

      1. An index serialization is a nested Tcl dictionary\.

      1. This dictionary holds a single key, __doctools::idx__, and its
         value\. This value holds the contents of the index\.

      1. The contents of the index are a Tcl dictionary holding the title of the
         index, a label, and the keywords and references\. The relevant keys and
         their values are

           * __title__

             The value is a string containing the title of the index\.

           * __label__

             The value is a string containing a label for the index\.

           * __keywords__

             The value is a Tcl dictionary, using the keywords known to the
             index as keys\. The associated values are lists containing the
             identifiers of the references associated with that particular
             keyword\.

             Any reference identifier used in these lists has to exist as a key
             in the __references__ dictionary, see the next item for its
             definition\.

           * __references__

             The value is a Tcl dictionary, using the identifiers for the
             references known to the index as keys\. The associated values are
             2\-element lists containing the type and label of the reference, in
             this order\.

             Any key here has to be associated with at least one keyword, i\.e\.
             occur in at least one of the reference lists which are the values
             in the __keywords__ dictionary, see previous item for its
             definition\.

      1. The *[type](\.\./\.\./\.\./\.\./index\.md\#type)* of a reference can be one
         of two values,

           * __manpage__

             The identifier of the reference is interpreted as symbolic file
             name, referring to one of the documents the index was made for\.

           * __url__

             The identifier of the reference is interpreted as an url, referring
             to some external location, like a website, etc\.

  - canonical serialization

    The canonical serialization of a keyword index has the format as specified
    in the previous item, and then additionally satisfies the constraints below,
    which make it unique among all the possible serializations of the keyword
    index\.

      1. The keys found in all the nested Tcl dictionaries are sorted in
         ascending dictionary order, as generated by Tcl's builtin command
         __lsort \-increasing \-dict__\.

      1. The references listed for each keyword of the index, if any, are listed
         in ascending dictionary order of their *labels*, as generated by
         Tcl's builtin command __lsort \-increasing \-dict__\.

# <a name='section5'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *doctools* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[HTML](\.\./\.\./\.\./\.\./index\.md\#html),
[doctools](\.\./\.\./\.\./\.\./index\.md\#doctools),
[export](\.\./\.\./\.\./\.\./index\.md\#export),
[index](\.\./\.\./\.\./\.\./index\.md\#index),
[serialization](\.\./\.\./\.\./\.\./index\.md\#serialization)

# <a name='category'></a>CATEGORY

Text formatter plugin

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2009\-2019 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>
