/*----- PROTECTED REGION ID(AccessControl.h) ENABLED START -----*/
//=============================================================================
//
// file :        AccessControl.h
//
// description : Include for the AccessControl class.
//
// project :     Access Control abstract class.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
//
// $Author: taurel $
//
// $Revision: 19207 $
// $Date: 2012-02-07 18:20:25 +0100 (Tue, 07 Feb 2012) $
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source$
// $Log$
// Revision 1.5  2011/02/11 14:20:27  pascal_verdier
// GetAccessForMutiIP  command added.
//
// Revision 1.4  2011/02/11 13:43:12  pascal_verdier
// Pogo-7 compatibility.
//
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef ACCESSCONTROL_H
#define ACCESSCONTROL_H


#include <tango.h>

#ifndef TANGO_UNUSED
	#ifdef _TG_WINDOWS_
		#define TANGO_UNUSED(var) var
	#else
		#if __GNUC__ == 3 && __GNUC_MINOR__ >= 4
			#define TANGO_UNUSED(var) var __attribute__ ((unused))
		#elif __GNUC__ > 3
			#define TANGO_UNUSED(var) var __attribute__ ((unused))
		#else
			#define TANGO_UNUSED(var) var
		#endif
	#endif
#endif

/*----- PROTECTED REGION END -----*/


/**
 *	AccessControl class Description:
 *	This class defines how to manage the TANGO access control.
 *	It interfaces commands for tool to defines access for users, devices and IP addresses.
 *	It interfaces also commands used by client API to check access for specified user, device and address.
 *	And it insterfaces to register and unregister it as TANGO service.
 */

namespace AccessControl_ns
{
	/*----- PROTECTED REGION ID(AccessControl::Additional Class Declarations) ENABLED START -----*/

		//		Additional Class Declarations

	/*----- PROTECTED REGION END -----*/	//	AccessControl::Additional Class Declarations


class AccessControl : public Tango::Device_4Impl
{


	/*----- PROTECTED REGION ID(AccessControl::Data Members) ENABLED START -----*/

	//		Add your own data members

	/*----- PROTECTED REGION END -----*/	//	AccessControl::Data Members


//	Device property data members
public:	

//	Attribute data members
public:



//	Constructors and destructors
public:
	/**
	 * Constructs a newly allocated Command object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	AccessControl(Tango::DeviceClass *cl,string &s);
	/**
	 * Constructs a newly allocated Command object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	AccessControl(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly allocated Command object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	AccessControl(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The object destructor.
	 */	
	~AccessControl() {delete_device();};



//	Miscellaneous methods
public:
	/**
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/**
	 *	Initialize the device
	 */
	virtual void init_device();
	/**
	 *	Read the device properties from database
	 */
	 void get_device_property();
	/**
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();



//	Command related methods
public: 


	/**
	 *	Command AddAddressForUser related methods.
	 */
	virtual void add_address_for_user(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_AddAddressForUser_allowed(const CORBA::Any &any);

	/**
	 *	Command AddDeviceForUser related methods.
	 */
	virtual void add_device_for_user(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_AddDeviceForUser_allowed(const CORBA::Any &any);

	/**
	 *	Command CloneUser related methods.
	 */
	virtual void clone_user(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_CloneUser_allowed(const CORBA::Any &any);

	/**
	 *	Command GetAccess related methods.
	 */
	virtual Tango::DevString get_access(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_GetAccess_allowed(const CORBA::Any &any);

	/**
	 *	Command GetAccessForMultiIP related methods.
	 */
	virtual Tango::DevString get_access_for_multi_ip(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_GetAccessForMultiIP_allowed(const CORBA::Any &any);

	/**
	 *	Command GetAddressByUser related methods.
	 */
	virtual Tango::DevVarStringArray *get_address_by_user(Tango::DevString argin)=0;
	virtual bool is_GetAddressByUser_allowed(const CORBA::Any &any);

	/**
	 *	Command GetAllowedCommands related methods.
	 */
	virtual Tango::DevVarStringArray *get_allowed_commands(Tango::DevString argin)=0;
	virtual bool is_GetAllowedCommands_allowed(const CORBA::Any &any);

	/**
	 *	Command GetDeviceByUser related methods.
	 */
	virtual Tango::DevVarStringArray *get_device_by_user(Tango::DevString argin)=0;
	virtual bool is_GetDeviceByUser_allowed(const CORBA::Any &any);

	/**
	 *	Command GetDeviceClass related methods.
	 */
	virtual Tango::DevString get_device_class(Tango::DevString argin)=0;
	virtual bool is_GetDeviceClass_allowed(const CORBA::Any &any);

	/**
	 *	Command GetUsers related methods.
	 */
	virtual Tango::DevVarStringArray *get_users()=0;
	virtual bool is_GetUsers_allowed(const CORBA::Any &any);

	/**
	 *	Command RegisterService related methods.
	 */
	virtual void register_service()=0;
	virtual bool is_RegisterService_allowed(const CORBA::Any &any);

	/**
	 *	Command RemoveAddressForUser related methods.
	 */
	virtual void remove_address_for_user(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_RemoveAddressForUser_allowed(const CORBA::Any &any);

	/**
	 *	Command RemoveDeviceForUser related methods.
	 */
	virtual void remove_device_for_user(const Tango::DevVarStringArray *argin)=0;
	virtual bool is_RemoveDeviceForUser_allowed(const CORBA::Any &any);

	/**
	 *	Command RemoveUser related methods.
	 */
	virtual void remove_user(Tango::DevString argin)=0;
	virtual bool is_RemoveUser_allowed(const CORBA::Any &any);

	/**
	 *	Command UnregisterService related methods.
	 */
	virtual void unregister_service()=0;
	virtual bool is_UnregisterService_allowed(const CORBA::Any &any);



	/*----- PROTECTED REGION ID(AccessControl::Additional Method prototypes) ENABLED START -----*/

	//	Additional Method prototypes

	/*----- PROTECTED REGION END -----*/	//	AccessControl::Additional Method prototypes

};

	/*----- PROTECTED REGION ID(AccessControl::Additional Classes Definitions) ENABLED START -----*/

	//	Additional Classes definitions

	/*----- PROTECTED REGION END -----*/	//	AccessControl::Additional Classes Definitions

} //	namespace

#endif	//	ACCESSCONTROL_H
