#!/usr/bin/env python
"""
Change import statements from absolute_import syntax to the old way.

NB! The variable "root" must hold the name of the root package.
"""

from glob import glob
import re
import os
import os.path as op
import sys

root = "newsfc"

files = glob("*.py")

for fn in files:
    
    print "========== Reading file", fn
    
    # Read contents
    f = open(fn)
    lines = list(f.readlines())
    f.close()

    # Parse filename
    fullpath, filename = op.split(op.abspath(fn))
    dirs = fullpath.split(op.sep)
    i = list(dirs).index(root)
    assert i >= 0
    path = dirs[i:]
    assert path[0] == root
    
    modulename = ".".join(path)

    # Print filename parsing result
    print 
    print "fn = ", fn
    print "path = ", path
    print "modulename = ", modulename
    print
    replace_dots = {}
    replace_dots["."]   = ".".join(path) + "."
    if len(path) > 1:
        replace_dots[".."]  = ".".join(path[:-1]) + "." 
    if len(path) > 2:
        replace_dots["..."] = ".".join(path[:-2]) + "."

    # Define line transformation
    regexp1 = re.compile(r"from.*__future__.*import.*absolute_import")
    regexp2 = re.compile(r"(.*)from (\.+)(.*) import (.*)$")
    def transform(line):
        if regexp1.search(line):
            line = ""
        else:
            match = regexp2.search(line)
            if match:
                g = match.groups()
                prefix, dots, modulename, content = g
                dotsreplacement = replace_dots[dots]
                line = "%sfrom %s%s import %s\n" % (prefix, dotsreplacement, modulename, content)
        return line
    
    # Apply transformation to all lines
    newlines = []
    updated = False
    for l in lines:
        l2 = transform(l)
        if l != l2:
            updated = True
            print "Changing lines:"
            print "FROM:", l.strip("\n")
            print "TO:  ", l2.strip("\n")
        newlines.append(l2)

    # Write file
    if updated:
        f = open(fn, "w")
        f.writelines(newlines)
        f.close()

