/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;
import org.apache.derby.jdbc.ReferenceableDataSource;

public class EmbeddedDataSource
extends ReferenceableDataSource
implements DataSource {
    private static final long serialVersionUID = -4945135214995641181L;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private boolean attributesAsPassword;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    transient InternalDriver driver;
    private transient String jdbcurl;

    public boolean equals(Object object) {
        if (object instanceof EmbeddedDataSource) {
            EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)object;
            boolean bl = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(embeddedDataSource.databaseName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.databaseName != null) {
                bl = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(embeddedDataSource.dataSourceName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.dataSourceName != null) {
                bl = false;
            }
            if (this.description != null) {
                if (!this.description.equals(embeddedDataSource.description)) {
                    bl = false;
                }
            } else if (embeddedDataSource.description != null) {
                bl = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(embeddedDataSource.createDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.createDatabase != null) {
                bl = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(embeddedDataSource.shutdownDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.shutdownDatabase != null) {
                bl = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(embeddedDataSource.connectionAttributes)) {
                    bl = false;
                }
            } else if (embeddedDataSource.connectionAttributes != null) {
                bl = false;
            }
            if (this.loginTimeout != embeddedDataSource.loginTimeout) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public final void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.toLowerCase(Locale.ENGLISH).equals("create") ? string : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown") ? string : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public final void setAttributesAsPassword(boolean bl) {
        this.attributesAsPassword = bl;
        this.update();
    }

    public final boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnection(string, string2, true);
    }

    final Connection getConnection(String string, String string2, boolean bl) throws SQLException {
        Object object;
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (!(bl && this.attributesAsPassword || string2 == null)) {
            properties.put("password", string2);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        String string3 = this.jdbcurl;
        if (this.attributesAsPassword && bl && string2 != null) {
            object = new StringBuffer(string3.length() + string2.length() + 1);
            ((StringBuffer)object).append(string3);
            ((StringBuffer)object).append(';');
            ((StringBuffer)object).append(string2);
            string3 = ((StringBuffer)object).toString();
        }
        if ((object = this.findDriver().connect(string3, properties)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String string = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(string)) {
            EmbeddedDataSource embeddedDataSource = this;
            synchronized (embeddedDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(string)) {
                    new EmbeddedDriver();
                    AutoloadedDriver autoloadedDriver = (AutoloadedDriver)DriverManager.getDriver(string);
                    this.driver = (InternalDriver)((Object)autoloadedDriver.getDriverModule());
                }
            }
        }
        return this.driver;
    }

    void update() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby:");
        String string = this.getDatabaseName();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            string = " ";
        }
        stringBuffer.append(string);
        String string2 = this.getConnectionAttributes();
        if (string2 != null && (string2 = string2.trim()).length() != 0) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuffer.toString();
    }
}

