/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.Resetable;

public class PositionedStoreStream
extends InputStream
implements Resetable {
    private final InputStream stream;
    private final Resetable resettable;
    private long pos = 0L;

    public PositionedStoreStream(InputStream inputStream) {
        this.stream = inputStream;
        this.resettable = (Resetable)((Object)inputStream);
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.stream.read(byArray);
        this.pos += (long)n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.stream.read(byArray, n, n2);
        this.pos += (long)n3;
        return n3;
    }

    public int read() throws IOException {
        int n = this.stream.read();
        if (n > -1) {
            ++this.pos;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = this.stream.skip(l);
        this.pos += l2;
        return l2;
    }

    public void resetStream() throws IOException, StandardException {
        this.resettable.resetStream();
        this.pos = 0L;
    }

    public void initStream() throws StandardException {
        this.resettable.initStream();
        this.pos = 0L;
    }

    public void closeStream() {
        this.resettable.closeStream();
    }

    public void reposition(long l) throws IOException, StandardException {
        if (this.pos < l) {
            this.skipFully(l - this.pos);
            this.pos = l;
        } else if (this.pos > l) {
            this.resettable.resetStream();
            this.skipFully(l);
            this.pos = l;
        }
    }

    public long getPosition() {
        return this.pos;
    }

    private void skipFully(long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = this.stream.skip(i);
            if (l2 != 0L) continue;
            if (this.stream.read() == -1) {
                throw new EOFException("Reached end-of-stream prematurely, with " + i + " byte(s) to go");
            }
            l2 = 1L;
        }
    }
}

