/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "WcViewModelMoveTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/ConfigManager.h"
#include "subcommander/WcViewModel.h"
#include "subcommander/WcSelection.h"
#include "subcommander/ScModel.h"
#include "subcommander/commands/MoveCmd.h"
#include "subcommander/commands/MoveParam.h"
#include "sublib/TargetRepository.h"
#include "svn/WcStatus.h"

// qt
#include <QtGui/QApplication>


class WcViewModelMoveTest::TestWcStatus : public svn::WcStatus
{
public:
  TestWcStatus( const sc::String& name )
  {
    _name = name;
  }
};


class WcViewModelMoveTest::TestScModel : public ScModel
{
public:
  TestScModel( ConfigManager* cm ) : ScModel(cm)
  {
  }

  void runAsync( ScCmd* cmd, CmdProgressCallback* pcb )
  {
    p = dynamic_cast<MoveCmd*>(cmd)->getParam();
  }

  MoveParam* p;
};


void WcViewModelMoveTest::setUp()
{
  TargetRepository::setup();

  _cm = new ConfigManager();
  _sc = new TestScModel(_cm);

  _viewModel = new WcViewModel( NULL, _sc );
}

void WcViewModelMoveTest::tearDown()
{
  delete _viewModel;
  delete _sc;
  delete _cm;

  TargetRepository::teardown();
}

void WcViewModelMoveTest::moveMultipleItems()
{
  svn::WcStatuss statuss;
  statuss.push_back( svn::WcStatusPtr(new TestWcStatus(sc::String("source/moveitem-first")) ) );
  statuss.push_back( svn::WcStatusPtr(new TestWcStatus(sc::String("source/moveitem-second")) ) );

  WcSelection sel(statuss);
  _viewModel->setSelection(sel);

  _viewModel->move( sc::String("destination"), false );

  const svn::Paths& paths = _sc->p->getDstPathsOrUrls();

  CPPUNIT_ASSERT_EQUAL( (size_t)2, paths.size() );
  CPPUNIT_ASSERT_EQUAL( sc::String("destination/moveitem-first"), paths[0] );
  CPPUNIT_ASSERT_EQUAL( sc::String("destination/moveitem-second"), paths[1] );
}
