module(..., package.seeall)

NODE = {
   title="S9 Demo",
   templates="_templates_for_s9"
}
NODE.actions = [[
slides = "s9.slides"
]]
NODE.permissions = [[
allow(all_users, "slides")
]]

NODE.content = [========[
<span class="teaser">
  This node can be viewed as a wiki page or as a full screen slideshow.
</span>

To see this as a slideshow:

- On Firefox install [FullerScreen](https://addons.mozilla.org/en-US/firefox/addon/4650)
    - Supposedly it works in Opera out-of-the-box
- Go to [[S9_Demo.slides|S9_Demo.slides]]
- Press F11

Once you are in the slideshow, it will look like this:

<a href="http://media.freewisdom.org/etc/slideshow_demo.png">
 <img src="http://media.freewisdom.org/etc/slideshow_demo_small.png"/>
</a>

Use "Page Up" and "Page Down" to navigate.

S9-Style Slideshow in Sputnik
-----------------------------

### S9 is a tool written in Ruby

- Converts Markdown into a web presentation
- Requires FullerScreen
  - https://addons.mozilla.org/en-US/firefox/addon/4650
- See http://slideshow.rubyforge.org/


We Likes It
-----------

...but not so excited about Ruby

### Let's do the same in Sputnik

(But kudos to S9 for showing us the way!)

Make the Template
-----------------

1. Look at the HTML generated by S9
2. Turn it into a Cosmo template
3. Save it to http://sputnik.freewisdom.org/en/\_templates\_for\_s9
    - set "prototype" to "@Lua_Config"

The only complicated part is the `$do_slides`:

    $do_slides[=[
     <div class='slide'>
      <h1>$heading</h1>
      $content
     </div>
    ]=]


Write an Action
---------------

We'll also need an "action".

It's simple: most of the work is done by markdown

    module(..., package.seeall)

    actions = {}
    actions.slides = function(node, request, sputnik)
       require"markdown"
       local delim = "@@@@@@@@@@"
       local html = ("\n"..node.markup.transform(node.content).."<h2>"):gsub("<h2>", "\n"..delim.."\n<h2>").."\n"..delim
       return cosmo.f(node.templates.SLIDESHOW){
          title = node.title,
          do_slides = function()
                         for heading, content in html:gmatch("\n<h2>(.-)</h2>(.-)\n"..delim) do
                            cosmo.yield{heading=heading, content=content}
                         end
                      end
       }
    end

Save this to `~/sputnik/share/lua/5.1/sputnik/actions/s9.lua`

Make a Slide Node
-----------------

### Let's make a node "Slideshow_Demo".  (Yes, this one.)

1. Put the markdown-formatted presentation in the body.
    - Use H2 (`##`) as slide titles
2. Set `templates` to `_templates_for_s9`
3. Set `actions` to `slides="s9.slides"`

Save.

### Check that Slideshow\_Demo displays fine.  Then try "Slideshow\_Demo.slides".

(Remember that you need "FullerScreen" - https://addons.mozilla.org/en-US/firefox/addon/4650)

It's Still a Wiki
-----------------

### Note that it's still a wiki

Wikilinks work as long as we append ".slides to them"

For example: [[Slideshow Demo 2.slides]]

To do: no way to link to specific slides

Things to Try Next
------------------

### We can also create a prototype

(Handy if we'll be making many slideshows).

1. Create a node "@Slideshow"
2. Set `templates` to `_templates_for_s9`
3. Set `actions` to `slides="s9.slides"`

Then create new slideshow nodes by just setting `prototype` to `@Slideshow'
]========]
