/*
 * Copyright(c) 1997 by Jun-ichiro Itoh. All rights reserved.
 * Freely redistributable.  Absolutely no warranty.
 *
 * author contact: Jun-ichiro itojun Itoh <itojun@mt.cs.keio.ac.jp>
 * $Id: scrn.c,v 1.2 1998/08/12 14:32:02 itojun Exp $
 */
#include "common.h"

/*
 * PUBLIC: extern int scrn_cols;
 * PUBLIC: extern int scrn_rows;
 * PUBLIC: extern int scrn_needrepaint;
 */
int scrn_cols;
int scrn_rows;
int scrn_needrepaint;

static void
hdl_sigwinch(sig)
	int sig;
{
	size_t rows;
	size_t cols;
	int step;

	rows = cols = 0;
	step = 0;
	while (rows == 0 && cols == 0) {
		switch (step) {
		case 0:
		    {
#ifdef TIOCGWINSZ
			struct winsize win;

			if (ioctl(STDERR_FILENO, TIOCGWINSZ, &win) == -1) {
				rows = win.ws_row;
				cols = win.ws_col;
			}
#endif
			break;
		    }
		case 1:
		    {
			char *p;
			int rval;

			if ((p = getenv("TERM")) == NULL)
				break;
#ifdef HAVE_CURSES_TIGETSTR
			if (0 <= (rval = tigetnum("lines")))
				rows = rval;
			if (0 <= (rval = tigetnum("cols")))
				cols = rval;
#else
			if (0 <= (rval = tgetnum("li")))
				rows = rval;
			if (0 <= (rval = tgetnum("co")))
				cols = rval;
#endif /*HAVE_CURSES_TIGETSTR*/
			break;
		    }
		case 2:
			return;	/*failure*/
		}

		step++;
	}

	scrn_cols = cols;
	scrn_rows = rows;
}

/*
 * PUBLIC: void scrn_init __P((void));
 */
void
scrn_init()
{
	initscr();
	noecho();
	nonl();
	raw();
	hdl_sigwinch(0);
	signal(SIGWINCH, hdl_sigwinch);
}

/*
 * PUBLIC: void scrn_end __P((void));
 */
void
scrn_end()
{
	endwin();
}

/*
 * PUBLIC: void scrn_beep __P((void));
 */
void
scrn_beep()
{
	write(1, "\007", 1);
}
