/* x.hpp: initializes x11
 *
 * Copyright (C) 2014: Dalton Nell, Slop Contributors (https://github.com/naelstrof/slop/graphs/contributors).
 *
 * This file is part of Slop.
 *
 * Slop is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Slop is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Slop.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef N_X_H_
#define N_X_H_

#include <iostream>
#include <X11/Xlib.h>
#include <string>
#include <sstream>
#include <stdexcept>
#include <X11/Xatom.h>
#include <glm/glm.hpp>

namespace slop {

glm::vec4 getWindowGeometry( Window win, bool removeDecoration );

class X11 {
public:
    bool hasCompositor();
    X11( std::string displayName );
    ~X11();
    Display* display;
    Visual* visual;
    Screen* screen;
    Window root;
};

extern X11* x11;

}

#endif
