inline Group::Group(Series series)
:
    d_series(series)
{}

    // by probgroup.f (begin())
inline double Group::begin() const
{
    return d_begin;
}

    // by probgroup.f (end())
inline double Group::end() const
{
    return d_end;
}

template <HasGroup Type>
bool Group::nextRange(std::vector<Type> const &vect) const
{
    return  vect.empty()                    // no Type elements yet
            or
            connects(vect.back().group());
}

inline std::istream &operator>>(std::istream &in, Group &group)
{
    return group.extract(in);
}

inline bool operator!=(Group const &lhs, Group const &rhs)
{
    return not (lhs == rhs);
}
