/************************************************************************
 *
 * Copyright (C) 2009-2015 IRCAD France
 * Copyright (C) 2012-2015 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#include "fwDataTools/TransferFunction.hpp"

#include <boost/assign/list_of.hpp>
#include <map>

namespace fwDataTools
{

//------------------------------------------------------------------------------

void TransferFunction::generateDrawingTF(::fwData::TransferFunction::sptr tf)
{
    tf->setTFData(TransferFunction::getDrawingTFColors());
    tf->setWLMinMax(::fwData::TransferFunction::TFValuePairType(0, 255));
    tf->setInterpolationMode(::fwData::TransferFunction::NEAREST);
    tf->setName("Drawing");
}

//------------------------------------------------------------------------------

::fwData::TransferFunction::TFDataType TransferFunction::getDrawingTFColors()
{
    typedef ::fwData::TransferFunction::TFColor TFColorType;
    static const ::fwData::TransferFunction::TFDataType dataType =
        ::boost::assign::map_list_of
            (0.0, TFColorType(0/255.0f, 0/255.0f, 0/255.0f, 0/255.0f))
            (1.0, TFColorType(255/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (2.0, TFColorType(0/255.0f, 0/255.0f, 150/255.0f, 255/255.0f))
            (3.0, TFColorType(255/255.0f, 100/255.0f, 0/255.0f, 255/255.0f))
            (4.0, TFColorType(0/255.0f, 255/255.0f, 0/255.0f, 255/255.0f))
            (5.0, TFColorType(255/255.0f, 255/255.0f, 0/255.0f, 255/255.0f))
            (6.0, TFColorType(150/255.0f, 0/255.0f, 150/255.0f, 255/255.0f))
            (7.0, TFColorType(0/255.0f, 255/255.0f, 255/255.0f, 255/255.0f))
            (8.0, TFColorType(150/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (9.0, TFColorType(0/255.0f, 150/255.0f, 0/255.0f, 255/255.0f))
            (10.0, TFColorType(255/255.0f, 177/255.0f, 177/255.0f, 255/255.0f))
            (11.0, TFColorType(0/255.0f, 150/255.0f, 150/255.0f, 255/255.0f))
            (12.0, TFColorType(255/255.0f, 0/255.0f, 255/255.0f, 255/255.0f))
            (13.0, TFColorType(150/255.0f, 150/255.0f, 0/255.0f, 255/255.0f))
            (14.0, TFColorType(135/255.0f, 135/255.0f, 81/255.0f, 255/255.0f))
            (15.0, TFColorType(255/255.0f, 255/255.0f, 177/255.0f, 255/255.0f))
            (16.0, TFColorType(177/255.0f, 177/255.0f, 255/255.0f, 255/255.0f))
            (17.0, TFColorType(255/255.0f, 200/255.0f, 50/255.0f, 255/255.0f))
            (18.0, TFColorType(255/255.0f, 177/255.0f, 255/255.0f, 255/255.0f))
            (19.0, TFColorType(177/255.0f, 255/255.0f, 255/255.0f, 255/255.0f))
            (20.0, TFColorType(255/255.0f, 50/255.0f, 50/255.0f, 255/255.0f))
            (21.0, TFColorType(245/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (22.0, TFColorType(0/255.0f, 0/255.0f, 142/255.0f, 255/255.0f))
            (23.0, TFColorType(245/255.0f, 95/255.0f, 0/255.0f, 255/255.0f))
            (24.0, TFColorType(0/255.0f, 245/255.0f, 0/255.0f, 255/255.0f))
            (25.0, TFColorType(245/255.0f, 245/255.0f, 0/255.0f, 255/255.0f))
            (26.0, TFColorType(142/255.0f, 0/255.0f, 142/255.0f, 255/255.0f))
            (27.0, TFColorType(0/255.0f, 245/255.0f, 245/255.0f, 255/255.0f))
            (28.0, TFColorType(142/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (29.0, TFColorType(0/255.0f, 142/255.0f, 0/255.0f, 255/255.0f))
            (30.0, TFColorType(245/255.0f, 169/255.0f, 169/255.0f, 255/255.0f))
            (31.0, TFColorType(0/255.0f, 142/255.0f, 142/255.0f, 255/255.0f))
            (32.0, TFColorType(245/255.0f, 0/255.0f, 245/255.0f, 255/255.0f))
            (33.0, TFColorType(142/255.0f, 142/255.0f, 0/255.0f, 255/255.0f))
            (34.0, TFColorType(169/255.0f, 245/255.0f, 169/255.0f, 255/255.0f))
            (35.0, TFColorType(245/255.0f, 245/255.0f, 169/255.0f, 255/255.0f))
            (36.0, TFColorType(169/255.0f, 169/255.0f, 245/255.0f, 255/255.0f))
            (37.0, TFColorType(245/255.0f, 192/255.0f, 46/255.0f, 255/255.0f))
            (38.0, TFColorType(245/255.0f, 169/255.0f, 245/255.0f, 255/255.0f))
            (39.0, TFColorType(169/255.0f, 245/255.0f, 245/255.0f, 255/255.0f))
            (40.0, TFColorType(245/255.0f, 46/255.0f, 46/255.0f, 255/255.0f))
            (41.0, TFColorType(235/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (42.0, TFColorType(0/255.0f, 0/255.0f, 134/255.0f, 255/255.0f))
            (43.0, TFColorType(235/255.0f, 90/255.0f, 0/255.0f, 255/255.0f))
            (44.0, TFColorType(0/255.0f, 235/255.0f, 0/255.0f, 255/255.0f))
            (45.0, TFColorType(235/255.0f, 235/255.0f, 0/255.0f, 255/255.0f))
            (46.0, TFColorType(134/255.0f, 0/255.0f, 134/255.0f, 255/255.0f))
            (47.0, TFColorType(0/255.0f, 235/255.0f, 235/255.0f, 255/255.0f))
            (48.0, TFColorType(134/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (49.0, TFColorType(0/255.0f, 134/255.0f, 0/255.0f, 255/255.0f))
            (50.0, TFColorType(235/255.0f, 161/255.0f, 161/255.0f, 255/255.0f))
            (51.0, TFColorType(0/255.0f, 134/255.0f, 134/255.0f, 255/255.0f))
            (52.0, TFColorType(235/255.0f, 0/255.0f, 235/255.0f, 255/255.0f))
            (53.0, TFColorType(134/255.0f, 134/255.0f, 0/255.0f, 255/255.0f))
            (54.0, TFColorType(161/255.0f, 235/255.0f, 161/255.0f, 255/255.0f))
            (55.0, TFColorType(235/255.0f, 235/255.0f, 161/255.0f, 255/255.0f))
            (56.0, TFColorType(161/255.0f, 161/255.0f, 235/255.0f, 255/255.0f))
            (57.0, TFColorType(235/255.0f, 184/255.0f, 42/255.0f, 255/255.0f))
            (58.0, TFColorType(235/255.0f, 161/255.0f, 235/255.0f, 255/255.0f))
            (59.0, TFColorType(161/255.0f, 235/255.0f, 235/255.0f, 255/255.0f))
            (60.0, TFColorType(235/255.0f, 42/255.0f, 42/255.0f, 255/255.0f))
            (61.0, TFColorType(225/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (62.0, TFColorType(0/255.0f, 0/255.0f, 126/255.0f, 255/255.0f))
            (63.0, TFColorType(225/255.0f, 85/255.0f, 0/255.0f, 255/255.0f))
            (64.0, TFColorType(0/255.0f, 225/255.0f, 0/255.0f, 255/255.0f))
            (65.0, TFColorType(225/255.0f, 225/255.0f, 0/255.0f, 255/255.0f))
            (66.0, TFColorType(126/255.0f, 0/255.0f, 126/255.0f, 255/255.0f))
            (67.0, TFColorType(0/255.0f, 225/255.0f, 225/255.0f, 255/255.0f))
            (68.0, TFColorType(126/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (69.0, TFColorType(0/255.0f, 126/255.0f, 0/255.0f, 255/255.0f))
            (70.0, TFColorType(225/255.0f, 153/255.0f, 153/255.0f, 255/255.0f))
            (71.0, TFColorType(0/255.0f, 126/255.0f, 126/255.0f, 255/255.0f))
            (72.0, TFColorType(225/255.0f, 0/255.0f, 225/255.0f, 255/255.0f))
            (73.0, TFColorType(126/255.0f, 126/255.0f, 0/255.0f, 255/255.0f))
            (74.0, TFColorType(153/255.0f, 225/255.0f, 153/255.0f, 255/255.0f))
            (75.0, TFColorType(225/255.0f, 225/255.0f, 153/255.0f, 255/255.0f))
            (76.0, TFColorType(153/255.0f, 153/255.0f, 225/255.0f, 255/255.0f))
            (77.0, TFColorType(225/255.0f, 176/255.0f, 38/255.0f, 255/255.0f))
            (78.0, TFColorType(225/255.0f, 153/255.0f, 225/255.0f, 255/255.0f))
            (79.0, TFColorType(153/255.0f, 225/255.0f, 225/255.0f, 255/255.0f))
            (80.0, TFColorType(225/255.0f, 38/255.0f, 38/255.0f, 255/255.0f))
            (81.0, TFColorType(215/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (82.0, TFColorType(0/255.0f, 0/255.0f, 118/255.0f, 255/255.0f))
            (83.0, TFColorType(215/255.0f, 80/255.0f, 0/255.0f, 255/255.0f))
            (84.0, TFColorType(0/255.0f, 215/255.0f, 0/255.0f, 255/255.0f))
            (85.0, TFColorType(215/255.0f, 215/255.0f, 0/255.0f, 255/255.0f))
            (86.0, TFColorType(118/255.0f, 0/255.0f, 118/255.0f, 255/255.0f))
            (87.0, TFColorType(0/255.0f, 215/255.0f, 215/255.0f, 255/255.0f))
            (88.0, TFColorType(118/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (89.0, TFColorType(0/255.0f, 118/255.0f, 0/255.0f, 255/255.0f))
            (90.0, TFColorType(215/255.0f, 145/255.0f, 145/255.0f, 255/255.0f))
            (91.0, TFColorType(0/255.0f, 118/255.0f, 118/255.0f, 255/255.0f))
            (92.0, TFColorType(215/255.0f, 0/255.0f, 215/255.0f, 255/255.0f))
            (93.0, TFColorType(118/255.0f, 118/255.0f, 0/255.0f, 255/255.0f))
            (94.0, TFColorType(145/255.0f, 215/255.0f, 145/255.0f, 255/255.0f))
            (95.0, TFColorType(215/255.0f, 215/255.0f, 145/255.0f, 255/255.0f))
            (96.0, TFColorType(145/255.0f, 145/255.0f, 215/255.0f, 255/255.0f))
            (97.0, TFColorType(215/255.0f, 168/255.0f, 34/255.0f, 255/255.0f))
            (98.0, TFColorType(215/255.0f, 145/255.0f, 215/255.0f, 255/255.0f))
            (99.0, TFColorType(145/255.0f, 215/255.0f, 215/255.0f, 255/255.0f))
            (100.0, TFColorType(215/255.0f, 34/255.0f, 34/255.0f, 255/255.0f))
            (101.0, TFColorType(205/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (102.0, TFColorType(0/255.0f, 0/255.0f, 110/255.0f, 255/255.0f))
            (103.0, TFColorType(205/255.0f, 75/255.0f, 0/255.0f, 255/255.0f))
            (104.0, TFColorType(0/255.0f, 205/255.0f, 0/255.0f, 255/255.0f))
            (105.0, TFColorType(205/255.0f, 205/255.0f, 0/255.0f, 255/255.0f))
            (106.0, TFColorType(110/255.0f, 0/255.0f, 110/255.0f, 255/255.0f))
            (107.0, TFColorType(0/255.0f, 205/255.0f, 205/255.0f, 255/255.0f))
            (108.0, TFColorType(110/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (109.0, TFColorType(0/255.0f, 110/255.0f, 0/255.0f, 255/255.0f))
            (110.0, TFColorType(205/255.0f, 137/255.0f, 137/255.0f, 255/255.0f))
            (111.0, TFColorType(0/255.0f, 110/255.0f, 110/255.0f, 255/255.0f))
            (112.0, TFColorType(205/255.0f, 0/255.0f, 205/255.0f, 255/255.0f))
            (113.0, TFColorType(110/255.0f, 110/255.0f, 0/255.0f, 255/255.0f))
            (114.0, TFColorType(137/255.0f, 205/255.0f, 137/255.0f, 255/255.0f))
            (115.0, TFColorType(205/255.0f, 205/255.0f, 137/255.0f, 255/255.0f))
            (116.0, TFColorType(137/255.0f, 137/255.0f, 205/255.0f, 255/255.0f))
            (117.0, TFColorType(205/255.0f, 160/255.0f, 30/255.0f, 255/255.0f))
            (118.0, TFColorType(205/255.0f, 137/255.0f, 205/255.0f, 255/255.0f))
            (119.0, TFColorType(137/255.0f, 205/255.0f, 205/255.0f, 255/255.0f))
            (120.0, TFColorType(205/255.0f, 30/255.0f, 30/255.0f, 255/255.0f))
            (121.0, TFColorType(195/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (122.0, TFColorType(0/255.0f, 0/255.0f, 102/255.0f, 255/255.0f))
            (123.0, TFColorType(195/255.0f, 70/255.0f, 0/255.0f, 255/255.0f))
            (124.0, TFColorType(0/255.0f, 195/255.0f, 0/255.0f, 255/255.0f))
            (125.0, TFColorType(195/255.0f, 195/255.0f, 0/255.0f, 255/255.0f))
            (126.0, TFColorType(102/255.0f, 0/255.0f, 102/255.0f, 255/255.0f))
            (127.0, TFColorType(0/255.0f, 195/255.0f, 195/255.0f, 255/255.0f))
            (128.0, TFColorType(102/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (129.0, TFColorType(0/255.0f, 102/255.0f, 0/255.0f, 255/255.0f))
            (130.0, TFColorType(195/255.0f, 129/255.0f, 129/255.0f, 255/255.0f))
            (131.0, TFColorType(0/255.0f, 102/255.0f, 102/255.0f, 255/255.0f))
            (132.0, TFColorType(195/255.0f, 0/255.0f, 195/255.0f, 255/255.0f))
            (133.0, TFColorType(102/255.0f, 102/255.0f, 0/255.0f, 255/255.0f))
            (134.0, TFColorType(129/255.0f, 195/255.0f, 129/255.0f, 255/255.0f))
            (135.0, TFColorType(195/255.0f, 195/255.0f, 129/255.0f, 255/255.0f))
            (136.0, TFColorType(129/255.0f, 129/255.0f, 195/255.0f, 255/255.0f))
            (137.0, TFColorType(195/255.0f, 152/255.0f, 26/255.0f, 255/255.0f))
            (138.0, TFColorType(195/255.0f, 129/255.0f, 195/255.0f, 255/255.0f))
            (139.0, TFColorType(129/255.0f, 195/255.0f, 195/255.0f, 255/255.0f))
            (140.0, TFColorType(195/255.0f, 26/255.0f, 26/255.0f, 255/255.0f))
            (141.0, TFColorType(185/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (142.0, TFColorType(0/255.0f, 0/255.0f, 94/255.0f, 255/255.0f))
            (143.0, TFColorType(185/255.0f, 65/255.0f, 0/255.0f, 255/255.0f))
            (144.0, TFColorType(0/255.0f, 185/255.0f, 0/255.0f, 255/255.0f))
            (145.0, TFColorType(185/255.0f, 185/255.0f, 0/255.0f, 255/255.0f))
            (146.0, TFColorType(94/255.0f, 0/255.0f, 94/255.0f, 255/255.0f))
            (147.0, TFColorType(0/255.0f, 185/255.0f, 185/255.0f, 255/255.0f))
            (148.0, TFColorType(94/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (149.0, TFColorType(0/255.0f, 94/255.0f, 0/255.0f, 255/255.0f))
            (150.0, TFColorType(185/255.0f, 121/255.0f, 121/255.0f, 255/255.0f))
            (151.0, TFColorType(0/255.0f, 94/255.0f, 94/255.0f, 255/255.0f))
            (152.0, TFColorType(185/255.0f, 0/255.0f, 185/255.0f, 255/255.0f))
            (153.0, TFColorType(94/255.0f, 94/255.0f, 0/255.0f, 255/255.0f))
            (154.0, TFColorType(121/255.0f, 185/255.0f, 121/255.0f, 255/255.0f))
            (155.0, TFColorType(185/255.0f, 185/255.0f, 121/255.0f, 255/255.0f))
            (156.0, TFColorType(121/255.0f, 121/255.0f, 185/255.0f, 255/255.0f))
            (157.0, TFColorType(185/255.0f, 144/255.0f, 22/255.0f, 255/255.0f))
            (158.0, TFColorType(185/255.0f, 121/255.0f, 185/255.0f, 255/255.0f))
            (159.0, TFColorType(121/255.0f, 185/255.0f, 185/255.0f, 255/255.0f))
            (160.0, TFColorType(185/255.0f, 22/255.0f, 22/255.0f, 255/255.0f))
            (161.0, TFColorType(175/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (162.0, TFColorType(0/255.0f, 0/255.0f, 86/255.0f, 255/255.0f))
            (163.0, TFColorType(175/255.0f, 60/255.0f, 0/255.0f, 255/255.0f))
            (164.0, TFColorType(0/255.0f, 175/255.0f, 0/255.0f, 255/255.0f))
            (165.0, TFColorType(175/255.0f, 175/255.0f, 0/255.0f, 255/255.0f))
            (166.0, TFColorType(86/255.0f, 0/255.0f, 86/255.0f, 255/255.0f))
            (167.0, TFColorType(0/255.0f, 175/255.0f, 175/255.0f, 255/255.0f))
            (168.0, TFColorType(86/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (169.0, TFColorType(0/255.0f, 86/255.0f, 0/255.0f, 255/255.0f))
            (170.0, TFColorType(175/255.0f, 113/255.0f, 113/255.0f, 255/255.0f))
            (171.0, TFColorType(0/255.0f, 86/255.0f, 86/255.0f, 255/255.0f))
            (172.0, TFColorType(175/255.0f, 0/255.0f, 175/255.0f, 255/255.0f))
            (173.0, TFColorType(86/255.0f, 86/255.0f, 0/255.0f, 255/255.0f))
            (174.0, TFColorType(113/255.0f, 175/255.0f, 113/255.0f, 255/255.0f))
            (175.0, TFColorType(175/255.0f, 175/255.0f, 113/255.0f, 255/255.0f))
            (176.0, TFColorType(113/255.0f, 113/255.0f, 175/255.0f, 255/255.0f))
            (177.0, TFColorType(175/255.0f, 136/255.0f, 18/255.0f, 255/255.0f))
            (178.0, TFColorType(175/255.0f, 113/255.0f, 175/255.0f, 255/255.0f))
            (179.0, TFColorType(113/255.0f, 175/255.0f, 175/255.0f, 255/255.0f))
            (180.0, TFColorType(175/255.0f, 18/255.0f, 18/255.0f, 255/255.0f))
            (181.0, TFColorType(165/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (182.0, TFColorType(0/255.0f, 0/255.0f, 78/255.0f, 255/255.0f))
            (183.0, TFColorType(165/255.0f, 55/255.0f, 0/255.0f, 255/255.0f))
            (184.0, TFColorType(0/255.0f, 165/255.0f, 0/255.0f, 255/255.0f))
            (185.0, TFColorType(165/255.0f, 165/255.0f, 0/255.0f, 255/255.0f))
            (186.0, TFColorType(78/255.0f, 0/255.0f, 78/255.0f, 255/255.0f))
            (187.0, TFColorType(0/255.0f, 165/255.0f, 165/255.0f, 255/255.0f))
            (188.0, TFColorType(78/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (189.0, TFColorType(0/255.0f, 78/255.0f, 0/255.0f, 255/255.0f))
            (190.0, TFColorType(165/255.0f, 105/255.0f, 105/255.0f, 255/255.0f))
            (191.0, TFColorType(0/255.0f, 78/255.0f, 78/255.0f, 255/255.0f))
            (192.0, TFColorType(165/255.0f, 0/255.0f, 165/255.0f, 255/255.0f))
            (193.0, TFColorType(78/255.0f, 78/255.0f, 0/255.0f, 255/255.0f))
            (194.0, TFColorType(105/255.0f, 165/255.0f, 105/255.0f, 255/255.0f))
            (195.0, TFColorType(165/255.0f, 165/255.0f, 105/255.0f, 255/255.0f))
            (196.0, TFColorType(105/255.0f, 105/255.0f, 165/255.0f, 255/255.0f))
            (197.0, TFColorType(165/255.0f, 128/255.0f, 14/255.0f, 255/255.0f))
            (198.0, TFColorType(165/255.0f, 105/255.0f, 165/255.0f, 255/255.0f))
            (199.0, TFColorType(105/255.0f, 165/255.0f, 165/255.0f, 255/255.0f))
            (200.0, TFColorType(165/255.0f, 14/255.0f, 14/255.0f, 255/255.0f))
            (201.0, TFColorType(155/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (202.0, TFColorType(0/255.0f, 0/255.0f, 70/255.0f, 255/255.0f))
            (203.0, TFColorType(155/255.0f, 50/255.0f, 0/255.0f, 255/255.0f))
            (204.0, TFColorType(0/255.0f, 155/255.0f, 0/255.0f, 255/255.0f))
            (205.0, TFColorType(155/255.0f, 155/255.0f, 0/255.0f, 255/255.0f))
            (206.0, TFColorType(70/255.0f, 0/255.0f, 70/255.0f, 255/255.0f))
            (207.0, TFColorType(0/255.0f, 155/255.0f, 155/255.0f, 255/255.0f))
            (208.0, TFColorType(70/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (209.0, TFColorType(0/255.0f, 70/255.0f, 0/255.0f, 255/255.0f))
            (210.0, TFColorType(155/255.0f, 97/255.0f, 97/255.0f, 255/255.0f))
            (211.0, TFColorType(0/255.0f, 70/255.0f, 70/255.0f, 255/255.0f))
            (212.0, TFColorType(155/255.0f, 0/255.0f, 155/255.0f, 255/255.0f))
            (213.0, TFColorType(70/255.0f, 70/255.0f, 0/255.0f, 255/255.0f))
            (214.0, TFColorType(97/255.0f, 155/255.0f, 97/255.0f, 255/255.0f))
            (215.0, TFColorType(155/255.0f, 155/255.0f, 97/255.0f, 255/255.0f))
            (216.0, TFColorType(97/255.0f, 97/255.0f, 155/255.0f, 255/255.0f))
            (217.0, TFColorType(155/255.0f, 120/255.0f, 10/255.0f, 255/255.0f))
            (218.0, TFColorType(155/255.0f, 97/255.0f, 155/255.0f, 255/255.0f))
            (219.0, TFColorType(97/255.0f, 155/255.0f, 155/255.0f, 255/255.0f))
            (220.0, TFColorType(155/255.0f, 10/255.0f, 10/255.0f, 255/255.0f))
            (221.0, TFColorType(145/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (222.0, TFColorType(0/255.0f, 0/255.0f, 62/255.0f, 255/255.0f))
            (223.0, TFColorType(145/255.0f, 45/255.0f, 0/255.0f, 255/255.0f))
            (224.0, TFColorType(0/255.0f, 145/255.0f, 0/255.0f, 255/255.0f))
            (225.0, TFColorType(145/255.0f, 145/255.0f, 0/255.0f, 255/255.0f))
            (226.0, TFColorType(62/255.0f, 0/255.0f, 62/255.0f, 255/255.0f))
            (227.0, TFColorType(0/255.0f, 145/255.0f, 145/255.0f, 255/255.0f))
            (228.0, TFColorType(62/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (229.0, TFColorType(0/255.0f, 62/255.0f, 0/255.0f, 255/255.0f))
            (230.0, TFColorType(145/255.0f, 89/255.0f, 89/255.0f, 255/255.0f))
            (231.0, TFColorType(0/255.0f, 62/255.0f, 62/255.0f, 255/255.0f))
            (232.0, TFColorType(145/255.0f, 0/255.0f, 145/255.0f, 255/255.0f))
            (233.0, TFColorType(62/255.0f, 62/255.0f, 0/255.0f, 255/255.0f))
            (234.0, TFColorType(89/255.0f, 145/255.0f, 89/255.0f, 255/255.0f))
            (235.0, TFColorType(145/255.0f, 145/255.0f, 89/255.0f, 255/255.0f))
            (236.0, TFColorType(89/255.0f, 89/255.0f, 145/255.0f, 255/255.0f))
            (237.0, TFColorType(145/255.0f, 112/255.0f, 6/255.0f, 255/255.0f))
            (238.0, TFColorType(145/255.0f, 89/255.0f, 145/255.0f, 255/255.0f))
            (239.0, TFColorType(89/255.0f, 145/255.0f, 145/255.0f, 255/255.0f))
            (240.0, TFColorType(145/255.0f, 6/255.0f, 6/255.0f, 255/255.0f))
            (241.0, TFColorType(135/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (242.0, TFColorType(0/255.0f, 0/255.0f, 54/255.0f, 255/255.0f))
            (243.0, TFColorType(135/255.0f, 40/255.0f, 0/255.0f, 255/255.0f))
            (244.0, TFColorType(0/255.0f, 135/255.0f, 0/255.0f, 255/255.0f))
            (245.0, TFColorType(135/255.0f, 135/255.0f, 0/255.0f, 255/255.0f))
            (246.0, TFColorType(54/255.0f, 0/255.0f, 54/255.0f, 255/255.0f))
            (247.0, TFColorType(0/255.0f, 135/255.0f, 135/255.0f, 255/255.0f))
            (248.0, TFColorType(54/255.0f, 0/255.0f, 0/255.0f, 255/255.0f))
            (249.0, TFColorType(0/255.0f, 54/255.0f, 0/255.0f, 255/255.0f))
            (250.0, TFColorType(135/255.0f, 81/255.0f, 81/255.0f, 255/255.0f))
            (251.0, TFColorType(0/255.0f, 54/255.0f, 54/255.0f, 255/255.0f))
            (252.0, TFColorType(135/255.0f, 0/255.0f, 135/255.0f, 255/255.0f))
            (253.0, TFColorType(54/255.0f, 54/255.0f, 0/255.0f, 255/255.0f))
            (254.0, TFColorType(81/255.0f, 135/255.0f, 81/255.0f, 255/255.0f))
            (255.0, TFColorType(177/255.0f, 255/255.0f, 177/255.0f, 255/255.0f));
    return dataType;
}

} // namespace fwDataTools
