
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#include "window.h"
#include <QApplication>
//öß
#if (QT_VERSION >= 0x050000)
void mh(QtMsgType type, const QMessageLogContext &context, const QString &msg) {
    printf("mh  %X\n",QT_VERSION);
  QByteArray localMsg = msg.toLocal8Bit();
    QString pth=QDir::homePath()+"/ShelXle_qt6_message.txt";
    FILE *er=fopen(pth.toStdString().c_str(),"at");
    fprintf(er,"======%s\n%s\n======\n",
        QDateTime::currentDateTime().toString().toStdString().c_str(),
        localMsg.constData());
    fclose(er);
    if (strstr(localMsg.constData(),"QOpenGLShader::link:")!=NULL) {
      printf("%s\n",localMsg.constData());fflush(stdout);
      return; // ignore useless error messages with shitty intel graphic cards reporting \"No error."
    }
  if (strstr(localMsg.constData(),"QAccessibleWidget")!=NULL) {
    printf("%s\n",localMsg.constData());fflush(stdout);
    return; // ignore useless error messages on win with touch screens
  }
  if (strstr(localMsg.constData(),"setGeometry")!=NULL) {
    printf("%s\n",localMsg.constData());fflush(stdout);
    return; // ignore useless error messages
  }
  if (strstr(localMsg.constData(),"QOpenGLShader::link:")!=NULL) {
    printf("%s\n",localMsg.constData());fflush(stdout);
    return; // ignore useless error messages
  }
  if (strstr(localMsg.constData(),"WM_DESTROY")!=NULL) {
      printf("ignore %s\n",localMsg.constData());fflush(stdout);
      return; // ignore useless error messages
    }


  switch (type) {
    case QtDebugMsg:
      fprintf(stderr, "Debug: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
// Q_WS_* was droppen in QT5 in favor of Q_OS_*
#if defined Q_WS_WIN  ||  defined Q_OS_WIN 
    //QMessageBox::information(0,"information",msg);
#endif
      break;
    case QtInfoMsg:
      fprintf(stderr, "Info: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  ||  defined Q_OS_WIN 
    //QMessageBox::information(0,"information",msg);
#endif
      break;
    case QtWarningMsg:
      fprintf(stderr, "Warning: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  ||  defined Q_OS_WIN 
    //QMessageBox::warning(0,"warning",msg);
#endif
      break;
    case QtCriticalMsg:
      fprintf(stderr, "Critical: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  || defined Q_OS_WIN 
    //QMessageBox::critical(0,"critical",msg);
#endif
      break;
    case QtFatalMsg:
      fprintf(stderr, "Fatal: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  || defined Q_OS_WIN 
    QMessageBox::critical(0,"fatal",msg);
#endif
      abort();
  }
}
#else
void mh(QtMsgType type, const char *msg){
    QString pth=QDir::homePath()+"/ShelXle_message.txt";
    FILE *er=fopen(pth.toStdString().c_str(),"wt");
    fprintf(er,"======\n%s\n======\n",msg);
    fclose(er);
    if (strstr(msg,"QOpenGLShader::link:")!=NULL) {
      printf("%s\n",msg);fflush(stdout);
      return; // ignore useless error messages with shitty intel graphic cards reporting \"No error."
    }
  if (strstr(msg,"QAccessibleWidget")!=NULL) {
    printf("%s\n",msg);fflush(stdout);
    return; // ignore useless error messages on win with touch screens
  }

  if (strstr(msg,"setGeometry")!=NULL) {
    printf("%s\n",msg);fflush(stdout);
    return; // ignore useless error messages
  }
  if (strstr(msg,"QOpenGLShader::link:")!=NULL) {
    printf("%s\n",msg);fflush(stdout);
    return; // ignore useless error messages
  }
  if (strstr(msg,"Warning: External WM_DESTROY received for")!=NULL) {
      printf("%s\n",msg);fflush(stdout);
      return; // ignore useless error messages
    }


  switch (type){
  case QtDebugMsg:

    printf("%s\n",msg);fflush(stdout);

#if defined Q_WS_WIN  
    QMessageBox::information(0,"information",msg);
#endif
    break;
  case QtWarningMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  
    QMessageBox::warning(0,"warning",msg);
#endif
    break;
  case QtCriticalMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  
    QMessageBox::critical(0,"critical",msg);
#endif
    break;
  case QtFatalMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  
    QMessageBox::critical(0,"fatal",msg);
#endif
    abort();
  }
}

#endif

/*
void printicon(){
#if defined Q_WS_WIN  ||   defined Q_OS_WIN
#define DEFINE_CONSOLEV2_PROPERTIES
#endif
  QImage II=QImage(":xle-icons/SHELxLE.png" );
//  QImage II=QPixmap(":xle-icons/cbh.png" ).toImage();
  int r, g, b, c216,gray,k=0;
  double alpha;
  char x[9]="@ShelXle";
  for (int j=0; j<II.height(); j++){
  for (int i=0; i<II.width(); i++){
    //printf("%2x",qGray(II.pixel(i,j)));a
    alpha=qAlpha(II.pixel(i,j))/256.0;
    r=(int) (qRed(II.pixel(i,j))/48.0*alpha);
    g=(int) (qGreen(II.pixel(i,j))/48.0*alpha);
    b=(int) (qBlue(II.pixel(i,j))/48.0*alpha);
    c216 = 16 + 36 * r + 6 * g + b;
    gray =qGray(II.pixel(i,j))/11+232;
    gray= (int)(alpha*gray +(235*(1.0-alpha)));
#if defined Q_WS_WIN  ||   defined Q_OS_WIN
    wprintf(L"\x1b[48;5;%dm\x1b[38;5;%dm%c",c216,gray,x[k%8]);
#else
    printf("\e[48;5;%dm\e[38;5;%dm%c",c216,gray,x[k%8]);
#endif
    //printf("\e[48;5;%dm\e[38;5;%dm%c",gray,c216,x[k%8]);
    k++;
  }
#if defined Q_WS_WIN  ||   defined Q_OS_WIN
  wprintf(L"\x1b[0;0;0m\n");j++;
#else
  printf("\e[0;0;0m\n");j++;
#endif
  }


}
*/
int main(int argv, char *args[]){    
  char *ENUS=setlocale(LC_ALL,"C");
  if (!ENUS)ENUS=setlocale(LC_ALL,"en_US.UTF-8");
  //printf("%s\n",ENUS);
#if (QT_VERSION >= 0x050000)
  QCoreApplication::setAttribute(Qt::AA_UseDesktopOpenGL);
  //printf("AA_UseDesktopOpenGL %d \n",QCoreApplication::testAttribute(Qt::AA_UseDesktopOpenGL));
  printf("Qt::AA_ShareOpenGLContexts %d\n",QCoreApplication::testAttribute(Qt::AA_ShareOpenGLContexts));
  QApplication app(argv, args);
  QSurfaceFormat f = QSurfaceFormat::defaultFormat();
  //printf("??\n");
  //f.setSampleBuffers(true);
  f.setSwapInterval(0);
  QSurfaceFormat::setDefaultFormat(f);
#else
    QApplication app(argv, args);
#endif

  app.setOrganizationName("shelxle");
  app.setWindowIcon(QIcon(":xle-icons/SHELxLE.png"));
  //printicon();
#if (QT_VERSION >= 0x050000)
  qInstallMessageHandler(mh);
#else
  qInstallMsgHandler(mh);
#endif 
  //printf("??1\n");
  //ChGL *chgl = new ChGL(0);
  //PlayOpenGL *chgl = new PlayOpenGL();
  //printf("??2 %p\n",chgl);
  Window *window = new Window();
  //printf("??2.5 %p\n",window->chgl);
  window->chgl->setMainWindow(window);
  //printf("??3\n");
  window->show();
  int istat = app.exec();
  //printf("delete the main window now...\n");
  delete window;
  //printf("%d bye bye! Thanks for using!\n",istat);
  return istat;
}
