# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

"""Tests for the Share app"""

from __future__ import absolute_import

from autopilot.matchers import Eventually
from testtools.matchers import Equals

from share_app.tests import ShareAppTestCase

class TestShare(ShareAppTestCase):
    """Tests the main buttons"""

    """ This is needed to wait for the application to start.
        In the testfarm, the application may take some time to show up."""
    def setUp(self):
        super(TestShare, self).setUp()
        self.assertThat(self.main_window.get_qml_view().visible, Eventually(Equals(True)))

    def tearDown(self):
        super(TestShare, self).tearDown()

    def test_cancel(self):
        """Tests the cancel button"""
        cancelButton = self.main_window.get_cancel_button()
        self.assertThat(True, Equals(True))
        self.pointing_device.move_to_object(cancelButton)
        self.pointing_device.click()

    def test_message_area_typing(self):
        """Tests typing in the message area."""
        # TODO Use OSK inputting text through evdev doesn't work
        # as maliit takes the focus
        #message_area = self.main_window.get_message_area()
        pass




