// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_STORE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_STORE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AlignIntervalsStoreElement

template <typename TInterval , typename TSpec > struct AlignIntervalsStoreElement;       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(72)

//____________________________________________________________________________
// AlignQualityStoreElement

template <typename TScore, typename TSpec > struct AlignQualityStoreElement;       	// "seqan-1.3.1/seqan/store/store_align.h"(215)

//____________________________________________________________________________
// AlignedReadLayout

struct AlignedReadLayout;       	// "seqan-1.3.1/seqan/store/store_all.h"(1406)

//____________________________________________________________________________
// AlignedReadStoreElement

template <typename TPos_, typename TGapAnchor_, typename TSpec_ > struct AlignedReadStoreElement;       	// "seqan-1.3.1/seqan/store/store_align.h"(120)

//____________________________________________________________________________
// AnchorGaps

template <typename TGapAnchors > struct AnchorGaps;       	// "seqan-1.3.1/seqan/store/store_align.h"(1166)

//____________________________________________________________________________
// AnnotationStoreElement

template <typename TPos_, typename TSpec > struct AnnotationStoreElement;       	// "seqan-1.3.1/seqan/store/store_annotation.h"(47)

//____________________________________________________________________________
// AnnotationTree

template <typename TSpec > struct AnnotationTree;       	// "seqan-1.3.1/seqan/store/store_annotation.h"(87)

//____________________________________________________________________________
// CigarElement

template <typename TOperation_ , typename TCount_ > struct CigarElement;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(67)

//____________________________________________________________________________
// ContigFile

template <typename TSpec_ > struct ContigFile;       	// "seqan-1.3.1/seqan/store/store_contig.h"(178)

//____________________________________________________________________________
// ContigStoreElement

template <typename TContigSeq_, typename TGapAnchor_, typename TSpec_ > struct ContigStoreElement;       	// "seqan-1.3.1/seqan/store/store_contig.h"(110)

//____________________________________________________________________________
// FragmentStore

template <typename TSpec , typename TConfig > class FragmentStore;       	// "seqan-1.3.1/seqan/store/store_all.h"(415)

//____________________________________________________________________________
// FragmentStoreConfig

template <typename TSpec > struct FragmentStoreConfig;       	// "seqan-1.3.1/seqan/store/store_all.h"(262)

//____________________________________________________________________________
// FromBam_

struct FromBam_;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(61)

//____________________________________________________________________________
// GapAnchor

template <typename TPos> struct GapAnchor;       	// "seqan-1.3.1/seqan/store/store_base.h"(75)

//____________________________________________________________________________
// IOContextGff_

template <typename TFragmentStore, typename TSpec > struct IOContextGff_;       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(154)

//____________________________________________________________________________
// IOContextUcsc_

template <typename TFragmentStore, typename TSpec > struct IOContextUcsc_;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(95)

//____________________________________________________________________________
// Interval

template <typename TValue > struct Interval;       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(47)

//____________________________________________________________________________
// LibraryStoreElement

template <typename TMean , typename TStd , typename TSpec > struct LibraryStoreElement;       	// "seqan-1.3.1/seqan/store/store_library.h"(77)

//____________________________________________________________________________
// MatchMateInfoLess_

struct MatchMateInfoLess_;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(512)

//____________________________________________________________________________
// MatchMateInfo_

template <typename TPos, typename TId> struct MatchMateInfo_;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(504)

//____________________________________________________________________________
// MatePairStoreElement

template <typename TSpec > struct MatePairStoreElement;       	// "seqan-1.3.1/seqan/store/store_matepair.h"(80)

//____________________________________________________________________________
// NameStoreCache

template <typename TNameStore, typename TName > struct NameStoreCache;       	// "seqan-1.3.1/seqan/store/store_all.h"(103)

//____________________________________________________________________________
// NameStoreLess

template <typename TNameStore, typename TName> struct NameStoreLess;       	// "seqan-1.3.1/seqan/store/store_all.h"(49)

//____________________________________________________________________________
// ReadStoreElement

template <typename TSpec > struct ReadStoreElement;       	// "seqan-1.3.1/seqan/store/store_read.h"(74)

//____________________________________________________________________________
// Sam_

struct Sam_;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(52)

//____________________________________________________________________________
// SortBeginPos_

struct SortBeginPos_;       	// "seqan-1.3.1/seqan/store/store_align.h"(272)

//____________________________________________________________________________
// SortContigId_

struct SortContigId_;       	// "seqan-1.3.1/seqan/store/store_align.h"(266)

//____________________________________________________________________________
// SortEndPos_

struct SortEndPos_;       	// "seqan-1.3.1/seqan/store/store_align.h"(275)

//____________________________________________________________________________
// SortGapPos_

struct SortGapPos_;       	// "seqan-1.3.1/seqan/store/store_base.h"(174)

//____________________________________________________________________________
// SortId_

struct SortId_;       	// "seqan-1.3.1/seqan/store/store_align.h"(269)

//____________________________________________________________________________
// SortPairMatchId_

struct SortPairMatchId_;       	// "seqan-1.3.1/seqan/store/store_align.h"(278)

//____________________________________________________________________________
// SortReadId_

struct SortReadId_;       	// "seqan-1.3.1/seqan/store/store_align.h"(281)

//____________________________________________________________________________
// SortSeqPos_

struct SortSeqPos_;       	// "seqan-1.3.1/seqan/store/store_base.h"(171)

//____________________________________________________________________________
// TagAmos_

struct TagAmos_;       	// "seqan-1.3.1/seqan/store/store_io.h"(54)

//____________________________________________________________________________
// TagGff_

struct TagGff_;       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(46)

//____________________________________________________________________________
// TagGtf_

struct TagGtf_;       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(54)

//____________________________________________________________________________
// UcscKnownGene_

struct UcscKnownGene_;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(50)

//____________________________________________________________________________
// UcscKnownIsoforms_

struct UcscKnownIsoforms_;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(58)

//____________________________________________________________________________
// Ucsc_

template <typename TSpec> struct Ucsc_;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(42)

//____________________________________________________________________________
// _LessAlignedRead

template <typename TAlignedRead, typename TTag> struct _LessAlignedRead;       	// "seqan-1.3.1/seqan/store/store_align.h"(293)

//____________________________________________________________________________
// _LessGapAnchor

template <typename TGapAnchor, typename TTag> struct _LessGapAnchor;       	// "seqan-1.3.1/seqan/store/store_base.h"(180)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// Bam_

struct Bam_;       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(54)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Amos

typedef Tag<TagAmos_> const Amos;       	// "seqan-1.3.1/seqan/store/store_io.h"(55)

//____________________________________________________________________________
// FromBam

typedef Tag<FromBam_> FromBam;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(62)

//____________________________________________________________________________
// Gff

typedef Tag<TagGff_> const Gff;       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(47)

//____________________________________________________________________________
// Gtf

typedef Tag<TagGtf_> const Gtf;       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(55)

//____________________________________________________________________________
// Sam

typedef Tag<Sam_> const Sam;       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(53)

//____________________________________________________________________________
// SortBeginPos

typedef Tag<SortBeginPos_> const SortBeginPos;       	// "seqan-1.3.1/seqan/store/store_align.h"(273)

//____________________________________________________________________________
// SortContigId

typedef Tag<SortContigId_> const SortContigId;       	// "seqan-1.3.1/seqan/store/store_align.h"(267)

//____________________________________________________________________________
// SortEndPos

typedef Tag<SortEndPos_> const SortEndPos;       	// "seqan-1.3.1/seqan/store/store_align.h"(276)

//____________________________________________________________________________
// SortGapPos

typedef Tag<SortGapPos_> const SortGapPos;       	// "seqan-1.3.1/seqan/store/store_base.h"(175)

//____________________________________________________________________________
// SortId

typedef Tag<SortId_> const SortId;       	// "seqan-1.3.1/seqan/store/store_align.h"(270)

//____________________________________________________________________________
// SortPairMatchId

typedef Tag<SortPairMatchId_> const SortPairMatchId;       	// "seqan-1.3.1/seqan/store/store_align.h"(279)

//____________________________________________________________________________
// SortReadId

typedef Tag<SortReadId_> const SortReadId;       	// "seqan-1.3.1/seqan/store/store_align.h"(282)

//____________________________________________________________________________
// SortSeqPos

typedef Tag<SortSeqPos_> const SortSeqPos;       	// "seqan-1.3.1/seqan/store/store_base.h"(172)

//____________________________________________________________________________
// Ucsc

typedef Tag<Ucsc_<UcscKnownGene_> > const Ucsc;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(51)

//____________________________________________________________________________
// UcscIsoforms

typedef Tag<Ucsc_<UcscKnownIsoforms_> > const UcscIsoforms;       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(59)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// Bam

typedef Tag<Bam_> Bam;       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(55)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _adjustParent

template <typename TAnnotation> inline void _adjustParent ( TAnnotation &parent, TAnnotation const &child);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(329)

//____________________________________________________________________________
// _assignSourceLength

template <typename TSize, typename TSource, typename TGapAnchors> inline void _assignSourceLength(TSize & size, Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1240)

//____________________________________________________________________________
// _cyclicListFrontInsert

template <typename TAnnotationStore, typename TId> inline TId _cyclicListFrontInsert(TAnnotationStore & annotationStore, TId newId, TId lastChildId);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(459)

//____________________________________________________________________________
// _cyclicListRemove

template <typename TAnnotationStore, typename TId> inline TId _cyclicListRemove(TAnnotationStore & annotationStore, TId id, TId lastChildId);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(510)

//____________________________________________________________________________
// _cyclicListSearchPrev

template <typename TAnnotationStore, typename TId> inline TId _cyclicListSearchPrev(TAnnotationStore & annotationStore, TId id, TId lastChildId);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(487)

//____________________________________________________________________________
// _dataAnchors

template <typename TSource, typename TGapAnchors> inline TGapAnchors & _dataAnchors(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1253)
template <typename TSource, typename TGapAnchors> inline TGapAnchors const & _dataAnchors(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1261)

//____________________________________________________________________________
// _dataSource

template <typename TSource, typename TGapAnchors> inline Holder<TSource> & _dataSource(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1223)
template <typename TSource, typename TGapAnchors> inline Holder<TSource> const & _dataSource(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1230)

//____________________________________________________________________________
// _generatePairMatchIds

template <typename TSpec, typename TConfig, typename TMatchMateInfos> inline void _generatePairMatchIds ( FragmentStore<TSpec, TConfig> & fragStore, TMatchMateInfos & matchMateInfos);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(526)

//____________________________________________________________________________
// _getAnchor

template <typename TAnchor, typename TSource, typename TGapAnchors, typename TIdx> inline void _getAnchor(TAnchor &anchor, Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TIdx idx);       	// "seqan-1.3.1/seqan/store/store_align.h"(1271)

//____________________________________________________________________________
// _getClippedLength

template <typename TCigarString, typename TNum> inline void _getClippedLength(TCigarString const & cigar, TNum & sum);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(264)

//____________________________________________________________________________
// _goNextGapAnchorIterator

template <typename T> inline void _goNextGapAnchorIterator(T & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1843)

//____________________________________________________________________________
// _goPreviousGapAnchorIterator

template <typename T> inline void _goPreviousGapAnchorIterator(T & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1860)

//____________________________________________________________________________
// _goToGapAnchorIterator

template <typename T, typename TPos> inline void _goToGapAnchorIterator(T & me, TPos pos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1877)

//____________________________________________________________________________
// _helperIsNegative

template <typename T> inline bool _helperIsNegative(T, False);       	// "seqan-1.3.1/seqan/store/store_align.h"(1424)
template <typename T> inline bool _helperIsNegative(T t, True);       	// "seqan-1.3.1/seqan/store/store_align.h"(1430)

//____________________________________________________________________________
// _parseIsDna

template <typename TChar> inline bool _parseIsDna(TChar const & c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(381)

//____________________________________________________________________________
// _parseIsPhredQual

template <typename TChar> inline bool _parseIsPhredQual(TChar c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(411)

//____________________________________________________________________________
// _parseReadCharsUntilEndOfLine

template <typename TFile, typename TChar> inline void _parseReadCharsUntilEndOfLine(TFile & file, String<char> & str, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(455)

//____________________________________________________________________________
// _parseReadCigar

template <typename TFile, typename TCigarString, typename TChar> inline void _parseReadCigar(TFile & file, TCigarString & cigar, TChar & c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(332)

//____________________________________________________________________________
// _parseReadDnaSeq

template <typename TFile, typename TString, typename TChar> inline void _parseReadDnaSeq(TFile & file, TString & str, TChar & c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(392)

//____________________________________________________________________________
// _parseReadGffIdentifier

template <typename TFile, typename TString, typename TChar> inline void _parseReadGffIdentifier(TFile & file, TString & str, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(63)

//____________________________________________________________________________
// _parseReadGffKeyValue

template <typename TFile, typename TKeyString, typename TValueString, typename TChar> inline bool _parseReadGffKeyValue(TFile & file, TKeyString & key, TValueString & value, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(94)

//____________________________________________________________________________
// _parseReadSamIdentifier

template <typename TFile, typename TString, typename TChar> inline void _parseReadSamIdentifier(TFile & file, TString & str, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(364)

//____________________________________________________________________________
// _parseReadSeqQual

template <typename TFile, typename TQualString, typename TChar> inline void _parseReadSeqQual(TFile & file, TQualString & str, TChar & c);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(422)

//____________________________________________________________________________
// _parseReadUcscIdentifier

template <typename TFile, typename TString, typename TChar> inline void _parseReadUcscIdentifier(TFile & file, TString & str, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(67)

//____________________________________________________________________________
// _parseSkipEntryUntilWhitespace

template <typename TFile, typename TChar> inline bool _parseSkipEntryUntilWhitespace(TFile& file, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(81)

//____________________________________________________________________________
// _parseSkipWhiteComma

template <typename TFile, typename TChar> inline void _parseSkipWhiteComma(TFile& file, TChar& c);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(81)

//____________________________________________________________________________
// _printContig

template <typename TStream, typename TFormatTag, typename TContigGaps, typename TContigName> inline void _printContig( TStream &stream, Tag<TFormatTag> const &format, AlignedReadLayout &, TContigGaps &contigGaps, TContigName const &);       	// "seqan-1.3.1/seqan/store/store_all.h"(1502)

//____________________________________________________________________________
// _printRead

template <typename TStream, typename TFormatTag, typename TContigGaps, typename TReadGaps, typename TAlignedRead, typename TLine> inline void _printRead( TStream &stream, Tag<TFormatTag> const &format, AlignedReadLayout &, TContigGaps &, TReadGaps &readGaps, TAlignedRead &, TLine);       	// "seqan-1.3.1/seqan/store/store_all.h"(1491)

//____________________________________________________________________________
// _readAlignments

template <typename TFile, typename TSpec, typename TConfig, typename TContigAnchorGaps, typename TMatchMateInfos, typename TChar> inline void _readAlignments ( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, TContigAnchorGaps & contigAnchorGaps, TMatchMateInfos & matchMateInfos, TChar & c, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(658)

//____________________________________________________________________________
// _readHeader

template <typename TFile, typename TSpec, typename TConfig, typename TChar> inline void _readHeader ( TFile & file, FragmentStore<TSpec, TConfig> &, TChar & c, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(638)

//____________________________________________________________________________
// _readOneAlignment

template <typename TFile, typename TSpec, typename TConfig, typename TContigAnchorGaps, typename TMatchMateInfos, typename TChar, typename TContextSAM> inline void _readOneAlignment ( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, TContigAnchorGaps & contigAnchorGaps, TMatchMateInfos & matchMateInfos, TChar & c, Sam, TContextSAM & contextSAM);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(702)

//____________________________________________________________________________
// _readOneAnnotation

template <typename TFile, typename TChar, typename TFragmentStore, typename TSpec> inline bool _readOneAnnotation ( TFile & file, TChar & c, IOContextGff_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(209)
template <typename TFile, typename TChar, typename TFragmentStore, typename TSpec> inline bool _readOneAnnotation ( TFile & file, TChar & c, IOContextUcsc_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(137)

//____________________________________________________________________________
// _retrieveOneAnnotation

template <typename TFragmentStore, typename TSpec, typename TAnnotation, typename TId> inline bool _retrieveOneAnnotation ( TFragmentStore & fragStore, IOContextUcsc_<TFragmentStore, TSpec> & ctx, TAnnotation &annotation, TId id, Ucsc);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(427)
template <typename TFragmentStore, typename TSpec, typename TAnnotation, typename TId> inline bool _retrieveOneAnnotation ( TFragmentStore & fragStore, IOContextUcsc_<TFragmentStore, TSpec> & ctx, TAnnotation &annotation, TId id, UcscIsoforms);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(471)

//____________________________________________________________________________
// _storeAppendAnnotationName

template <typename TSpec, typename TConfig, typename TId, typename TName> inline void _storeAppendAnnotationName ( FragmentStore<TSpec, TConfig> & fragStore, TId & annotationId, TName & annotationName);       	// "seqan-1.3.1/seqan/store/store_all.h"(781)

//____________________________________________________________________________
// _storeAppendContig

template <typename TSpec, typename TConfig, typename TId, typename TName> inline void _storeAppendContig ( FragmentStore<TSpec, TConfig> & fragStore, TId & contigId, TName & rName);       	// "seqan-1.3.1/seqan/store/store_all.h"(753)

//____________________________________________________________________________
// _storeAppendKey

template <typename TSpec, typename TConfig, typename TId, typename TName> inline void _storeAppendKey ( FragmentStore<TSpec, TConfig> & fragStore, TId & keyId, TName & annotationKey);       	// "seqan-1.3.1/seqan/store/store_all.h"(823)

//____________________________________________________________________________
// _storeAppendRead

template <typename TSpec, typename TConfig, typename TId, typename TName, typename TString, typename TFlag, typename TContext> inline void _storeAppendRead ( FragmentStore<TSpec, TConfig> & fragStore, TId & readId, TName & qname, TString & readSeq, TFlag & flag, TContext &);       	// "seqan-1.3.1/seqan/store/store_all.h"(682)

//____________________________________________________________________________
// _storeAppendType

template <typename TSpec, typename TConfig, typename TId, typename TName> inline void _storeAppendType ( FragmentStore<TSpec, TConfig> & fragStore, TId & typeId, TName & annotationType);       	// "seqan-1.3.1/seqan/store/store_all.h"(801)

//____________________________________________________________________________
// _storeClearAnnoBackLinks

template <typename TAnnotationStore> inline void _storeClearAnnoBackLinks(TAnnotationStore & me);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(653)

//____________________________________________________________________________
// _storeClearAnnotations

template <typename TConfig, typename TSpec > inline void _storeClearAnnotations(FragmentStore<TSpec, TConfig> & me);       	// "seqan-1.3.1/seqan/store/store_all.h"(589)

//____________________________________________________________________________
// _storeCreateAnnoBackLinks

template <typename TAnnotationStore> inline void _storeCreateAnnoBackLinks(TAnnotationStore & me);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(670)

//____________________________________________________________________________
// _storeOneAnnotation

template <typename TFragmentStore, typename TSpec> inline void _storeOneAnnotation ( TFragmentStore & fragStore, IOContextGff_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(367)
template <typename TFragmentStore, typename TSpec> inline void _storeOneAnnotation ( TFragmentStore & fragStore, IOContextUcsc_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(379)

//____________________________________________________________________________
// _storeOneAnnotationKnownGene

template <typename TFragmentStore, typename TSpec> inline void _storeOneAnnotationKnownGene ( TFragmentStore & fragStore, IOContextUcsc_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(275)

//____________________________________________________________________________
// _storeOneAnnotationKnownIsoforms

template <typename TFragmentStore, typename TSpec> inline void _storeOneAnnotationKnownIsoforms ( TFragmentStore & fragStore, IOContextUcsc_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(337)

//____________________________________________________________________________
// _storeRemoveTempAnnoNames

template <typename TConfig, typename TSpec > inline void _storeRemoveTempAnnoNames(FragmentStore<TSpec, TConfig> & me);       	// "seqan-1.3.1/seqan/store/store_all.h"(607)

//____________________________________________________________________________
// _unclippedLength

template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type _unclippedLength(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1315)

//____________________________________________________________________________
// _writeAlignments

template <typename TFile, typename TSpec, typename TConfig> inline void _writeAlignments(TFile & target, FragmentStore<TSpec, TConfig> & store, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(927)

//____________________________________________________________________________
// _writeGffGtf

template <typename TTargetStream, typename TSpec, typename TConfig, typename TFormat> inline void _writeGffGtf ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, TFormat format);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(698)

//____________________________________________________________________________
// _writeHeader

template <typename TFile, typename TSpec, typename TConfig> inline void _writeHeader(TFile & target, FragmentStore<TSpec, TConfig> & store, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(872)

//____________________________________________________________________________
// _writeOneAnnotation

template <typename TTargetStream, typename TSpec, typename TConfig, typename TAnnotation, typename TId> inline void _writeOneAnnotation ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, TAnnotation &annotation, TId id, Gff);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(477)
template <typename TTargetStream, typename TSpec, typename TConfig, typename TAnnotation, typename TId> inline void _writeOneAnnotation ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, TAnnotation &annotation, TId id, Gtf);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(581)
template <typename TTargetStream, typename TFragmentStore, typename TSpec> inline void _writeOneAnnotation ( TTargetStream & file, IOContextUcsc_<TFragmentStore, TSpec> & ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(486)

//____________________________________________________________________________
// annotationAssignValueByKey

template <typename TSpec, typename TConfig, typename TAnnotation, typename TKey, typename TValue> inline void annotationAssignValueByKey ( FragmentStore<TSpec, TConfig> & fragStore, TAnnotation & annotation, TKey const & key, TValue const & value);       	// "seqan-1.3.1/seqan/store/store_all.h"(848)

//____________________________________________________________________________
// annotationGetValueByKey

template <typename TSpec, typename TConfig, typename TAnnotation, typename TKey, typename TValue> inline bool annotationGetValueByKey ( FragmentStore<TSpec, TConfig> & fragStore, TAnnotation const & annotation, TKey const & key, TValue & value);       	// "seqan-1.3.1/seqan/store/store_all.h"(866)
template <typename TSpec, typename TConfig, typename TAnnotation, typename TKey> inline CharString annotationGetValueByKey ( FragmentStore<TSpec, TConfig> & fragStore, TAnnotation const & annotation, TKey const & key);       	// "seqan-1.3.1/seqan/store/store_all.h"(885)

//____________________________________________________________________________
// appendAlignedRead

template <typename TSpec, typename TConfig, typename TReadId, typename TContigId, typename TPos, typename TPairMatchId> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type appendAlignedRead( FragmentStore<TSpec, TConfig> & store, TReadId const & readId, TContigId const & contigId, TPos const & beginPos, TPos const & endPos, TPairMatchId const & pairMatchId);       	// "seqan-1.3.1/seqan/store/store_all.h"(1056)
template <typename TSpec, typename TConfig, typename TReadId, typename TContigId, typename TPos> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type appendAlignedRead( FragmentStore<TSpec, TConfig> & store, TReadId const & readId, TContigId const & contigId, TPos const & beginPos, TPos const & endPos);       	// "seqan-1.3.1/seqan/store/store_all.h"(1076)

//____________________________________________________________________________
// appendAlignment

template <typename TSpec, typename TConfig, typename TId, typename TPos, typename TGaps> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type appendAlignment( FragmentStore<TSpec, TConfig> & fragStore, TId readId, TId contigId, TPos beginPos, TPos endPos, TGaps const & gaps);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(481)

//____________________________________________________________________________
// appendMatePair

template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TMatePairStore>::Type appendMatePair( FragmentStore<TSpec, TConfig> &me, TRead const &read1, TRead const &read2);       	// "seqan-1.3.1/seqan/store/store_all.h"(1111)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TMatePairStore>::Type appendMatePair( FragmentStore<TSpec, TConfig> &me, TRead const &read1, TRead const &read2, CharString const &name1, CharString const &name2);       	// "seqan-1.3.1/seqan/store/store_all.h"(1138)

//____________________________________________________________________________
// appendName

template <typename TNameStore, typename TName> inline void appendName(TNameStore &store, TName &name);       	// "seqan-1.3.1/seqan/store/store_all.h"(236)
template <typename TNameStore, typename TName, typename TContext> inline void appendName(TNameStore &store, TName &name, TContext &);       	// "seqan-1.3.1/seqan/store/store_all.h"(243)
template <typename TNameStore, typename TName, typename TCNameStore, typename TCName> inline void appendName(TNameStore &store, TName &name, NameStoreCache<TCNameStore, TCName> &context);       	// "seqan-1.3.1/seqan/store/store_all.h"(250)

//____________________________________________________________________________
// appendRead

template <typename TSpec, typename TConfig, typename TRead, typename TId> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, TId matePairId);       	// "seqan-1.3.1/seqan/store/store_all.h"(947)
template <typename TSpec, typename TConfig, typename TRead, typename TId> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, CharString const &name, TId matePairId);       	// "seqan-1.3.1/seqan/store/store_all.h"(966)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read);       	// "seqan-1.3.1/seqan/store/store_all.h"(984)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, CharString const &name);       	// "seqan-1.3.1/seqan/store/store_all.h"(997)

//____________________________________________________________________________
// assignValueByKey

template <typename TFragmentStore, typename TSpec, typename TKey, typename TValue> inline void assignValueByKey( Iter<TFragmentStore, AnnotationTree<TSpec> > & it, TKey const & key, TValue const & value);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(248)

//____________________________________________________________________________
// atBegin

template <typename TFragmentStore, typename TSpec> inline bool atBegin(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(305)
template <typename TGaps, typename TGapAnchors> inline bool atBegin(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1673)
template <typename TGaps, typename TGapAnchors> inline bool atBegin(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1680)

//____________________________________________________________________________
// atEnd

template <typename TFragmentStore, typename TSpec> inline bool atEnd(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(312)
template <typename TGaps, typename TGapAnchors> inline bool atEnd(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1688)
template <typename TGaps, typename TGapAnchors> inline bool atEnd(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1695)

//____________________________________________________________________________
// begin

template <typename TConfig, typename TSpec, typename TIterSpec > inline typename Iterator<FragmentStore<TSpec, TConfig>, TIterSpec >::Type begin(FragmentStore<TSpec, TConfig> &store, TIterSpec const);       	// "seqan-1.3.1/seqan/store/store_all.h"(557)
template <typename TConfig, typename TSpec, typename TIterSpec > inline typename Iterator<FragmentStore<TSpec, TConfig> const, TIterSpec >::Type begin(FragmentStore<TSpec, TConfig> const &store, TIterSpec const);       	// "seqan-1.3.1/seqan/store/store_all.h"(564)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, Standard);       	// "seqan-1.3.1/seqan/store/store_align.h"(1351)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > const>::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, Standard);       	// "seqan-1.3.1/seqan/store/store_align.h"(1359)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, Rooted);       	// "seqan-1.3.1/seqan/store/store_align.h"(1369)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > const>::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, Rooted);       	// "seqan-1.3.1/seqan/store/store_align.h"(1377)

//____________________________________________________________________________
// beginPosition

template <typename TSource, typename TGapAnchors> inline typename Position< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type beginPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1387)

//____________________________________________________________________________
// buildAlignIntervalsStore

template <typename TAlignIntervalsStore, typename TSpec, typename TConfig > inline void buildAlignIntervalsStore(TAlignIntervalsStore & alignIntervalsStore, FragmentStore<TSpec, TConfig> & me, const unsigned & thresholdGaps);       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(85)

//____________________________________________________________________________
// calculateInsertSizes

template <typename TLibSizeString, typename TSpec, typename TConfig> inline void calculateInsertSizes(TLibSizeString &insertSizes, FragmentStore<TSpec, TConfig> &me);       	// "seqan-1.3.1/seqan/store/store_all.h"(1286)

//____________________________________________________________________________
// calculateMateIndices

template <typename TMateIndexString, typename TSpec, typename TConfig> inline void calculateMateIndices(TMateIndexString &mateIndices, FragmentStore<TSpec, TConfig> &me);       	// "seqan-1.3.1/seqan/store/store_all.h"(1367)

//____________________________________________________________________________
// cigarToGapAnchorContig

template <typename TCigarString, typename TGaps> inline void cigarToGapAnchorContig(TCigarString const & cigar, TGaps & gaps);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(301)

//____________________________________________________________________________
// cigarToGapAnchorRead

template <typename TCigarString, typename TGaps> inline void cigarToGapAnchorRead(TCigarString const & cigar, TGaps & gaps);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(281)

//____________________________________________________________________________
// clear

template <typename TFragmentStore, typename TSpec> inline void clear(IOContextGff_<TFragmentStore, TSpec> &ctx);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(179)
template <typename TFragmentStore, typename TSpec> inline void clear(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(293)
template <typename TFragmentStore, typename TSpec> inline void clear(IOContextUcsc_<TFragmentStore, TSpec> &ctx);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(114)

//____________________________________________________________________________
// clearReads

template <typename TSpec, typename TConfig> inline void clearReads(FragmentStore<TSpec, TConfig> &me);       	// "seqan-1.3.1/seqan/store/store_all.h"(915)

//____________________________________________________________________________
// clearValues

template <typename TFragmentStore, typename TSpec> inline void clearValues(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(238)

//____________________________________________________________________________
// compactAlignedReads

template <typename TSpec, typename TConfig> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type compactAlignedReads(FragmentStore<TSpec, TConfig> &me);       	// "seqan-1.3.1/seqan/store/store_all.h"(1183)

//____________________________________________________________________________
// compactPairMatchIds

template <typename TSpec, typename TConfig> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type compactPairMatchIds(FragmentStore<TSpec, TConfig> &me);       	// "seqan-1.3.1/seqan/store/store_all.h"(1239)

//____________________________________________________________________________
// container

template <typename TFragmentStore, typename TSpec> inline TFragmentStore & container(Iter< TFragmentStore, AnnotationTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(160)
template <typename TFragmentStore, typename TSpec> inline TFragmentStore & container(Iter< TFragmentStore, AnnotationTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(166)

//____________________________________________________________________________
// convertMatchesToGlobalAlignment

template <typename TSpec, typename TConfig, typename TScore, typename TShrinkMatches> void convertMatchesToGlobalAlignment(FragmentStore<TSpec, TConfig> &store, TScore const & score, TShrinkMatches const &);       	// "seqan-1.3.1/seqan/store/store_all.h"(1663)

//____________________________________________________________________________
// convertPairWiseToGlobalAlignment

template <typename TSpec, typename TConfig, typename TContigGapsString> void convertPairWiseToGlobalAlignment(FragmentStore<TSpec, TConfig> &store, TContigGapsString &gaps);       	// "seqan-1.3.1/seqan/store/store_all.h"(1868)

//____________________________________________________________________________
// countGaps

template <typename TGaps, typename TGapAnchors> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1658)

//____________________________________________________________________________
// createIntervalTreeStore

template <typename TSpec, typename TConfig> inline void createIntervalTreeStore(FragmentStore<TSpec, TConfig> & me, const bool &unknownO);       	// "seqan-1.3.1/seqan/store/store_intervaltree.h"(50)

//____________________________________________________________________________
// createLeftChild

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > createLeftChild(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(534)

//____________________________________________________________________________
// createRightChild

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > createRightChild(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(557)

//____________________________________________________________________________
// createSibling

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > createSibling(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(581)

//____________________________________________________________________________
// end

template <typename TConfig, typename TSpec, typename TIterSpec > inline typename Iterator<FragmentStore<TSpec, TConfig>, TIterSpec >::Type end(FragmentStore<TSpec, TConfig> &store, TIterSpec const);       	// "seqan-1.3.1/seqan/store/store_all.h"(573)
template <typename TConfig, typename TSpec, typename TIterSpec > inline typename Iterator<FragmentStore<TSpec, TConfig> const, TIterSpec >::Type end(FragmentStore<TSpec, TConfig> const &store, TIterSpec const);       	// "seqan-1.3.1/seqan/store/store_all.h"(580)

//____________________________________________________________________________
// endPosition

template <typename TSource, typename TGapAnchors> inline typename Position< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type endPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1395)

//____________________________________________________________________________
// extractAlignIntervals

template <typename TIntervals, typename TAlignedReadStoreElement, typename TSpec, typename TConfig> inline void extractAlignIntervals(TIntervals & contigIntervals, TAlignedReadStoreElement & align, FragmentStore<TSpec, TConfig> & me, const unsigned & thresholdGaps);       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(123)

//____________________________________________________________________________
// findIntervalsForInterval

template <typename TIntervalTree, typename TInterval, typename TCargo> inline void findIntervalsForInterval(String<TCargo> & result, TIntervalTree & intervalTree, TInterval & interval, const unsigned & offsetInterval);       	// "seqan-1.3.1/seqan/store/store_intervaltree.h"(179)

//____________________________________________________________________________
// getAnnoName

template <typename TSpec, typename TConfig, typename TId> inline typename GetValue<typename FragmentStore<TSpec, TConfig>::TAnnotationNameStore>::Type getAnnoName(FragmentStore<TSpec, TConfig> & store, TId id);       	// "seqan-1.3.1/seqan/store/store_all.h"(638)

//____________________________________________________________________________
// getAnnoType

template <typename TSpec, typename TConfig, typename TId> inline typename GetValue<typename FragmentStore<TSpec, TConfig>::TAnnotationTypeStore>::Type getAnnoType(FragmentStore<TSpec, TConfig> & store, TId id);       	// "seqan-1.3.1/seqan/store/store_all.h"(645)

//____________________________________________________________________________
// getAnnoUniqueName

template <typename TSpec, typename TConfig, typename TId> inline CharString getAnnoUniqueName(FragmentStore<TSpec, TConfig> & store, TId id);       	// "seqan-1.3.1/seqan/store/store_all.h"(652)

//____________________________________________________________________________
// getAnnotation

template <typename TFragmentStore, typename TSpec> inline typename Reference<typename TFragmentStore::TAnnotationStore>::Type getAnnotation(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(175)

//____________________________________________________________________________
// getCigarString

template <typename TCigar, typename TGaps1, typename TGaps2, typename TThresh> inline void getCigarString( TCigar &cigar, TGaps1 &gaps1, TGaps2 &gaps2, TThresh splicedGapThresh);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(121)
template <typename TCigar, typename TGaps1, typename TGaps2> inline void getCigarString( TCigar &cigar, TGaps1 &gaps1, TGaps2 &gaps2);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(191)
template <typename TOperation, typename TCount, typename TSpec, typename TGaps1, typename TGaps2, typename TThresh> inline void getCigarString( String<CigarElement<TOperation, TCount>, TSpec> &cigar, TGaps1 &gaps1, TGaps2 &gaps2, TThresh splicedGapThresh);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(208)

//____________________________________________________________________________
// getClrRange

template <typename TSpec, typename TConfig, typename TPos, typename TGapAnchor, typename TSpecAlign, typename TBeginClr, typename TEndClr> inline void getClrRange(FragmentStore<TSpec, TConfig> const& fragStore, AlignedReadStoreElement<TPos, TGapAnchor, TSpecAlign> const& alignEl, TBeginClr& begClr, TEndClr& endClr);       	// "seqan-1.3.1/seqan/store/store_io.h"(72)

//____________________________________________________________________________
// getIdByName

template <typename TNameStore, typename TName, typename TPos> inline bool getIdByName(TNameStore &store, TName &name, TPos &pos);       	// "seqan-1.3.1/seqan/store/store_all.h"(169)
template <typename TNameStore, typename TName, typename TPos, typename TContext> inline bool getIdByName(TNameStore &store, TName &name, TPos &pos, TContext &);       	// "seqan-1.3.1/seqan/store/store_all.h"(190)
template <typename TNameStore, typename TName, typename TPos, typename TCNameStore, typename TCName> inline bool getIdByName(TNameStore &, TName &name, TPos &pos, NameStoreCache<TCNameStore, TCName> &context);       	// "seqan-1.3.1/seqan/store/store_all.h"(197)

//____________________________________________________________________________
// getMateNo

template <typename TSpec, typename TConfig, typename TId> inline int getMateNo(FragmentStore<TSpec, TConfig> const &me, TId readId);       	// "seqan-1.3.1/seqan/store/store_all.h"(1329)

//____________________________________________________________________________
// getName

template <typename TFragmentStore, typename TSpec> inline typename GetValue<typename TFragmentStore::TAnnotationNameStore>::Type getName(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(182)

//____________________________________________________________________________
// getParentName

template <typename TFragmentStore, typename TSpec> inline typename GetValue<typename TFragmentStore::TAnnotationNameStore>::Type getParentName(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(198)

//____________________________________________________________________________
// getRead

template <typename TSpec, typename TConfig, typename TId> inline typename Value<typename FragmentStore<TSpec, TConfig>::TReadSeqStore>::Type getRead( FragmentStore<TSpec, TConfig> &me, TId id);       	// "seqan-1.3.1/seqan/store/store_all.h"(1021)

//____________________________________________________________________________
// getType

template <typename TFragmentStore, typename TSpec> inline typename GetValue<typename TFragmentStore::TAnnotationTypeStore>::Type getType(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(213)

//____________________________________________________________________________
// getUniqueName

template <typename TFragmentStore, typename TSpec> inline CharString getUniqueName(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(229)

//____________________________________________________________________________
// getValue

template <typename TGaps, typename TGapAnchors> inline typename GetValue< Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > >::Type getValue(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1610)
template <typename TGaps, typename TGapAnchors> inline typename GetValue< Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const>::Type getValue(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1620)

//____________________________________________________________________________
// getValueByKey

template <typename TFragmentStore, typename TSpec, typename TKey, typename TValue> inline bool getValueByKey( Iter<TFragmentStore, AnnotationTree<TSpec> > const & it, TKey const & key, TValue & value);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(258)
template <typename TFragmentStore, typename TSpec, typename TKey> inline CharString getValueByKey( Iter<TFragmentStore, AnnotationTree<TSpec> > const & it, TKey const & key);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(267)

//____________________________________________________________________________
// goBegin

template <typename TFragmentStore, typename TSpec> inline void goBegin(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(276)

//____________________________________________________________________________
// goDown

template <typename TFragmentStore, typename TSpec> inline bool goDown(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(388)

//____________________________________________________________________________
// goEnd

template <typename TFragmentStore, typename TSpec> inline void goEnd(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(283)

//____________________________________________________________________________
// goFurther

template <typename TGaps, typename TGapAnchors, typename TSize> inline void goFurther(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me, TSize steps);       	// "seqan-1.3.1/seqan/store/store_align.h"(1926)

//____________________________________________________________________________
// goNext

template <typename TFragmentStore, typename TSpec> inline void goNext(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(324)
template <typename TGaps, typename TGapAnchors> inline void goNext(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1912)

//____________________________________________________________________________
// goNextRight

template <typename TFragmentStore, typename TSpec> inline void goNextRight(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(337)

//____________________________________________________________________________
// goNextUp

template <typename TFragmentStore, typename TSpec> inline void goNextUp(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(350)

//____________________________________________________________________________
// goPrevious

template <typename TGaps, typename TGapAnchors> inline void goPrevious(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1919)

//____________________________________________________________________________
// goRight

template <typename TFragmentStore, typename TSpec> inline bool goRight(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(405)

//____________________________________________________________________________
// goRoot

template <typename TFragmentStore, typename TSpec> inline void goRoot(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(364)

//____________________________________________________________________________
// goUp

template <typename TFragmentStore, typename TSpec> inline bool goUp(Iter<TFragmentStore, AnnotationTree<TSpec> > & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(371)

//____________________________________________________________________________
// insertGaps

template <typename TGaps, typename TGapAnchors, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me, TCount size);       	// "seqan-1.3.1/seqan/store/store_align.h"(1744)

//____________________________________________________________________________
// isClipped

template <typename TGaps, typename TGapAnchors> inline bool isClipped(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1649)

//____________________________________________________________________________
// isGap

template <typename TGaps, typename TGapAnchors> inline bool isGap(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1633)

//____________________________________________________________________________
// isLastChild

template <typename TFragmentStore, typename TSpec> inline bool isLastChild(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(633)

//____________________________________________________________________________
// isLeaf

template <typename TFragmentStore, typename TSpec> inline bool isLeaf(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(622)

//____________________________________________________________________________
// isRoot

template <typename TFragmentStore, typename TSpec> inline bool isRoot(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(611)

//____________________________________________________________________________
// isUnknown

template <typename TGaps, typename TGapAnchors> inline bool isUnknown(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1640)

//____________________________________________________________________________
// layoutAlignment

template <typename TSpec, typename TConfig> void layoutAlignment(AlignedReadLayout &layout, FragmentStore<TSpec, TConfig> &store);       	// "seqan-1.3.1/seqan/store/store_all.h"(1431)

//____________________________________________________________________________
// length

template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type length(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1333)
template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type length(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1341)

//____________________________________________________________________________
// loadContig

template <typename TSpec, typename TConfig, typename TId> bool loadContig(FragmentStore<TSpec, TConfig> &store, TId id);       	// "seqan-1.3.1/seqan/store/store_io.h"(928)

//____________________________________________________________________________
// loadContigs

template <typename TFSSpec, typename TFSConfig> bool loadContigs(FragmentStore<TFSSpec, TFSConfig> &store, StringSet<CharString> const &fileNameList, bool loadSeqs);       	// "seqan-1.3.1/seqan/store/store_io.h"(853)
template <typename TFSSpec, typename TFSConfig> bool loadContigs(FragmentStore<TFSSpec, TFSConfig> &store, CharString const &fileName, bool loadSeqs);       	// "seqan-1.3.1/seqan/store/store_io.h"(898)
template <typename TFSSpec, typename TFSConfig, typename TFileNames> bool loadContigs(FragmentStore<TFSSpec, TFSConfig> &store, TFileNames const &fileNames);       	// "seqan-1.3.1/seqan/store/store_io.h"(908)

//____________________________________________________________________________
// loadReads

template <typename TFSSpec, typename TFSConfig, typename TFileName> bool loadReads(FragmentStore<TFSSpec, TFSConfig> &store, TFileName &fileName);       	// "seqan-1.3.1/seqan/store/store_io.h"(1114)
template <typename TFSSpec, typename TFSConfig, typename TFileName> bool loadReads(FragmentStore<TFSSpec, TFSConfig> & store, TFileName & fileNameL, TFileName & fileNameR);       	// "seqan-1.3.1/seqan/store/store_io.h"(1158)

//____________________________________________________________________________
// lockContig

template <typename TSpec, typename TConfig, typename TId> bool lockContig(FragmentStore<TSpec, TConfig> &store, TId id);       	// "seqan-1.3.1/seqan/store/store_io.h"(964)

//____________________________________________________________________________
// lockContigs

template <typename TSpec, typename TConfig> bool lockContigs(FragmentStore<TSpec, TConfig> &store);       	// "seqan-1.3.1/seqan/store/store_io.h"(1044)

//____________________________________________________________________________
// lowerBoundAlignedReads

template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(460)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(496)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(532)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(571)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(610)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(646)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(683)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(721)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(759)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(800)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(841)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> lowerBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(879)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(917)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(955)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(993)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1034)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(1075)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * lowerBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(1113)

//____________________________________________________________________________
// lowerBoundGapAnchor

template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type lowerBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortSeqPos);       	// "seqan-1.3.1/seqan/store/store_base.h"(215)
template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type lowerBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortGapPos);       	// "seqan-1.3.1/seqan/store/store_base.h"(251)

//____________________________________________________________________________
// mergeIntervals

template <typename TIntervals> inline void mergeIntervals(TIntervals & intervals, const unsigned & thresholdGaps);       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(328)

//____________________________________________________________________________
// nodeDown

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > nodeDown(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(438)

//____________________________________________________________________________
// nodeRight

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > nodeRight(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(447)

//____________________________________________________________________________
// nodeUp

template <typename TFragmentStore, typename TSpec> inline Iter<TFragmentStore, AnnotationTree<TSpec> > nodeUp(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(429)

//____________________________________________________________________________
// operator!=

template <typename TGaps, typename TGapAnchors> inline bool operator!= ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "seqan-1.3.1/seqan/store/store_align.h"(1716)

//____________________________________________________________________________
// operator<

template <typename TValue> inline bool operator< (Interval<TValue> const & interval1, Interval<TValue> const & interval2);       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(64)
template <typename TGaps, typename TGapAnchors> inline bool operator< ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "seqan-1.3.1/seqan/store/store_align.h"(1725)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TPos, typename TGapAnchor, typename TSpec> TStream & operator<<(TStream & stream, AlignedReadStoreElement<TPos, TGapAnchor, TSpec> const & e);       	// "seqan-1.3.1/seqan/store/store_align.h"(171)

//____________________________________________________________________________
// operator==

template <typename TValue> inline bool operator== (Interval<TValue> const & interval1, Interval<TValue> const & interval2);       	// "seqan-1.3.1/seqan/store/store_align_intervals.h"(57)
template <typename TGaps, typename TGapAnchors> inline bool operator== ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "seqan-1.3.1/seqan/store/store_align.h"(1707)

//____________________________________________________________________________
// operator>

template <typename TGaps, typename TGapAnchors> inline bool operator> ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "seqan-1.3.1/seqan/store/store_align.h"(1734)

//____________________________________________________________________________
// positionGapToSeq

template <typename TSource, typename TGapAnchors, typename TPosition> inline TPosition positionGapToSeq(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TPosition pos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1437)

//____________________________________________________________________________
// positionSeqToGap

template <typename TSource, typename TGapAnchors, typename TPosition> inline TPosition positionSeqToGap(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TPosition pos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1474)

//____________________________________________________________________________
// printAlignment

template <typename TStream, typename TFormatTag, typename TSpec, typename TConfig, typename TContigId, typename TPos, typename TNum> void printAlignment( TStream &stream, Tag<TFormatTag> const &format, AlignedReadLayout &layout, FragmentStore<TSpec, TConfig> &store, TContigId contigId, TPos posBegin, TPos posEnd, TNum lineBegin, TNum lineEnd);       	// "seqan-1.3.1/seqan/store/store_all.h"(1539)

//____________________________________________________________________________
// read

template <typename TFile, typename TSpec, typename TConfig> inline void read ( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, Gff);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(432)
template <typename TFile, typename TSpec, typename TConfig> inline void read ( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, Gtf);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(461)
template <typename TFile, typename TSpec, typename TConfig, typename TFormatSpec> inline void read ( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, Tag<Ucsc_<TFormatSpec> > const);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(392)
template <typename TFile, typename TSpec, typename TConfig> inline void read(TFile & file, FragmentStore<TSpec, TConfig>& fragStore, Amos);       	// "seqan-1.3.1/seqan/store/store_io.h"(130)
template <typename TFile, typename TSpec, typename TConfig> inline void read( TFile & file, FragmentStore<TSpec, TConfig> & fragStore, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(596)

//____________________________________________________________________________
// refresh

template <typename TNameStore, typename TName> inline void refresh(NameStoreCache<TNameStore, TName> &cache);       	// "seqan-1.3.1/seqan/store/store_all.h"(138)

//____________________________________________________________________________
// removeGaps

template <typename TGaps, typename TGapAnchors, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me, TCount size);       	// "seqan-1.3.1/seqan/store/store_align.h"(1797)

//____________________________________________________________________________
// setBeginPosition

template <typename TSource, typename TGapAnchors, typename TPosition> inline void setBeginPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, TPosition view_position);       	// "seqan-1.3.1/seqan/store/store_align.h"(1405)

//____________________________________________________________________________
// setEndPosition

template <typename TSource, typename TGapAnchors, typename TPosition> inline void setEndPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, TPosition view_position);       	// "seqan-1.3.1/seqan/store/store_align.h"(1413)

//____________________________________________________________________________
// setName

template <typename TFragmentStore, typename TSpec, typename TName> inline typename GetValue<typename TFragmentStore::TAnnotationNameStore>::Type setName(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it, TName & name);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(189)

//____________________________________________________________________________
// setType

template <typename TFragmentStore, typename TSpec, typename TTypeName> inline void setType(Iter<TFragmentStore, AnnotationTree<TSpec> > const & it, TTypeName & typeName);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(220)

//____________________________________________________________________________
// sortAlignedReads

template <typename TAlign, typename TSortSpec> inline void sortAlignedReads(TAlign& alignStore, Tag<TSortSpec> const &);       	// "seqan-1.3.1/seqan/store/store_align.h"(414)
template <typename TAlign, typename TSortSpec> inline void sortAlignedReads(TAlign const & alignStore, Tag<TSortSpec> const &);       	// "seqan-1.3.1/seqan/store/store_align.h"(426)
template <typename TAlign, typename TFunctorLess> inline void sortAlignedReads(TAlign & alignStore, TFunctorLess const &less);       	// "seqan-1.3.1/seqan/store/store_align.h"(436)
template <typename TAlign, typename TFunctorLess> inline void sortAlignedReads(TAlign const & alignStore, TFunctorLess const &less);       	// "seqan-1.3.1/seqan/store/store_align.h"(446)

//____________________________________________________________________________
// source

template <typename TGaps, typename TGapAnchors> inline typename Source<Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const>::Type source(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1595)
template <typename TGaps, typename TGapAnchors> inline typename Source<Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > >::Type source(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "seqan-1.3.1/seqan/store/store_align.h"(1601)

//____________________________________________________________________________
// toBamCigarElement

template <typename TOperation, typename TCount> __uint32 toBamCigarElement(CigarElement<TOperation, TCount> const & cigarElement);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(92)

//____________________________________________________________________________
// unlockAndFreeContig

template <typename TSpec, typename TConfig, typename TId> bool unlockAndFreeContig(FragmentStore<TSpec, TConfig> &store, TId id);       	// "seqan-1.3.1/seqan/store/store_io.h"(1014)

//____________________________________________________________________________
// unlockAndFreeContigs

template <typename TSpec, typename TConfig> bool unlockAndFreeContigs(FragmentStore<TSpec, TConfig> &store);       	// "seqan-1.3.1/seqan/store/store_io.h"(1086)

//____________________________________________________________________________
// unlockContig

template <typename TSpec, typename TConfig, typename TId> bool unlockContig(FragmentStore<TSpec, TConfig> &store, TId id);       	// "seqan-1.3.1/seqan/store/store_io.h"(993)

//____________________________________________________________________________
// unlockContigs

template <typename TSpec, typename TConfig> bool unlockContigs(FragmentStore<TSpec, TConfig> &store);       	// "seqan-1.3.1/seqan/store/store_io.h"(1065)

//____________________________________________________________________________
// upperBoundAlignedReads

template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(478)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(514)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(551)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(590)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(628)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(664)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(702)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(740)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(779)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(820)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(860)
template <typename T, typename TSpec, typename TSearchValue> inline Iter<T, TSpec> upperBoundAlignedReads(Iter<T, TSpec> const & alignedReadsItBegin, Iter<T, TSpec> const & alignedReadsItEnd, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(898)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortId);       	// "seqan-1.3.1/seqan/store/store_align.h"(936)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortContigId);       	// "seqan-1.3.1/seqan/store/store_align.h"(974)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortBeginPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1013)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortEndPos);       	// "seqan-1.3.1/seqan/store/store_align.h"(1054)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortPairMatchId);       	// "seqan-1.3.1/seqan/store/store_align.h"(1094)
template <typename TReadAlignElement, typename TSearchValue> inline TReadAlignElement * upperBoundAlignedReads(TReadAlignElement * const & alignedReadsItBegin, TReadAlignElement * const & alignedReadsItEnd, TSearchValue const val, SortReadId);       	// "seqan-1.3.1/seqan/store/store_align.h"(1132)

//____________________________________________________________________________
// upperBoundGapAnchor

template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type upperBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortSeqPos);       	// "seqan-1.3.1/seqan/store/store_base.h"(233)
template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type upperBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortGapPos);       	// "seqan-1.3.1/seqan/store/store_base.h"(269)

//____________________________________________________________________________
// value

template <typename TFragmentStore, typename TSpec> inline typename VertexDescriptor<TFragmentStore>::Type & value(Iter< TFragmentStore, AnnotationTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(146)
template <typename TFragmentStore, typename TSpec> inline typename VertexDescriptor<TFragmentStore>::Type const & value(Iter< TFragmentStore, AnnotationTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/store/store_annotation.h"(152)

//____________________________________________________________________________
// write

template <typename TTargetStream, typename TSpec, typename TConfig> inline void write ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, Gff format);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(718)
template <typename TTargetStream, typename TSpec, typename TConfig> inline void write ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, Gtf format);       	// "seqan-1.3.1/seqan/store/store_io_gff.h"(728)
template <typename TTargetStream, typename TSpec, typename TConfig, typename TFormatSpec> inline void write ( TTargetStream & target, FragmentStore<TSpec, TConfig> & store, Tag<Ucsc_<TFormatSpec> > const format);       	// "seqan-1.3.1/seqan/store/store_io_ucsc.h"(580)
template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & target, FragmentStore<TSpec, TConfig>& fragStore, Amos);       	// "seqan-1.3.1/seqan/store/store_io.h"(549)
template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & target, FragmentStore<TSpec, TConfig> & store, Sam);       	// "seqan-1.3.1/seqan/store/store_io_sam.h"(1123)

//____________________________________________________________________________
// writeContigs

template <typename TStream, typename TFSSpec, typename TFSConfig, typename TFormat> bool writeContigs(TStream & file, FragmentStore<TFSSpec, TFSConfig> & store, TFormat const &);       	// "seqan-1.3.1/seqan/store/store_io.h"(823)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _readAlignments

template <typename TSpec, typename TConfig, typename TContigAnchorGaps, typename TMatchMateInfos> inline void _readAlignments( samfile_t * file, FragmentStore<TSpec, TConfig> & fragStore, TContigAnchorGaps & contigAnchorGaps, TMatchMateInfos & matchMateInfos, Bam const &);       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(108)

//____________________________________________________________________________
// _readOneAlignment

template <typename TSpec, typename TConfig, typename TContigAnchorGaps, typename TMatchMateInfos, typename TContextBAM> inline void _readOneAlignment ( samfile_t * file, bam1_t * record, FragmentStore<TSpec, TConfig> & fragStore, TContigAnchorGaps & contigAnchorGaps, TMatchMateInfos & matchMateInfos, Bam const &, TContextBAM & contextBam);       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(153)

//____________________________________________________________________________
// _writeAlignments

template <typename TSpec, typename TConfig> inline void _writeAlignments(samfile_t * , FragmentStore<TSpec, TConfig> & store, Bam const &);       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(411)

//____________________________________________________________________________
// read

template <typename TSpec, typename TConfig> inline void read(samfile_t * file, FragmentStore<TSpec, TConfig> & fragStore, Bam const &);       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(73)

//____________________________________________________________________________
// write

template <typename TSpec, typename TConfig> inline void write(char const * fileName, FragmentStore<TSpec, TConfig> & fragStore, Bam const &);       	// "seqan-1.3.1/seqan/store/store_io_bam.h"(370)

} //namespace seqan

#endif

