#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#

my_module_version = "1.60"
my_module_name = "vqasTextResource"

# Timestamps and placeholder cells for all supported VQAs ((row 2 and below)
WSTLGO_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(204, 260, " ", "00:00:13.66", "00:00:17.34", "Text")
]
##
BRLOGO_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(0, 72, " ", "00:00:00.06", "00:00:04.81", "Text")
]
##
INTRO_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(16, 55, " ", "00:00:01.10", "00:00:03.68", "Text"),
	(55, 95, " ", "00:00:03.68", "00:00:06.34", "Text"),
	(95, 145, " ", "00:00:06.34", "00:00:09.68", "Text"),
	(145, 206, " ", "00:00:09.68", "00:00:13.76", "Text"),
	(206, 255, " ", "00:00:13.76", "00:00:17.06", "Text"),
	(255, 307, " ", "00:00:17.06", "00:00:20.48", "Text"),
	(307, 366, " ", "00:00:20.48", "00:00:24.40", "Text"),
	(366, 428, " ", "00:00:24.40", "00:00:28.54", "Text"),
	(428, 487, " ", "00:00:28.54", "00:00:32.48", "Text"),
	(487, 550, " ", "00:00:32.48", "00:00:36.72", "Text"),
	(550, 607, " ", "00:00:36.72", "00:00:40.48", "Text"),
	(607, 674, " ", "00:00:40.48", "00:00:44.96", "Text"),
	(674, 738, " ", "00:00:44.96", "00:00:49.22", "Text"),
	(752, 815, " ", "00:00:50.14", "00:00:54.34", "Text"),
	(1417, 1459, " ", "00:01:34.46", "00:01:37.28", "Lucy"),
	(1459, 1493, " ", "00:01:37.28", "00:01:39.56", "Runciter"),
	(1495, 1539, " ", "00:01:39.70", "00:01:42.64", "Lucy"),
	(1540, 1604, " ", "00:01:42.72", "00:01:46.96", "Lucy"),
	(1609, 1666, " ", "00:01:47.32", "00:01:51.06", "Runciter"),
	(1666, 1710, " ", "00:01:51.06", "00:01:54.02", "Runciter"),
	(1710, 1734, " ", "00:01:54.02", "00:01:55.64", "Lucy"),
	(1737, 1784, " ", "00:01:55.82", "00:01:58.94", "Runciter"),
	(1785, 1807, " ", "00:01:59.04", "00:02:00.46", "Lucy"),
	(1809, 1873, " ", "00:02:00.60", "00:02:04.88", "Runciter"),
	(1873, 1945, " ", "00:02:04.88", "00:02:09.66", "Runciter"),
	(1950, 1997, " ", "00:02:10.00", "00:02:13.14", "Runciter"),
	(2003, 2048, " ", "00:02:13.52", "00:02:16.56", "Runciter"),
	(2051, 2090, " ", "00:02:16.78", "00:02:19.34", "Runciter"),
	(2091, 2146, " ", "00:02:19.44", "00:02:23.10", "Clovis"),
	(2147, 2198, " ", "00:02:23.14", "00:02:26.52", "Runciter"),
	(2198, 2286, " ", "00:02:26.52", "00:02:32.44", "Runciter"),
	(2288, 2339, " ", "00:02:32.58", "00:02:35.98", "Clovis"),
	(2403, 2452, " ", "00:02:40.20", "00:02:43.48", "Clovis"),
	(2459, 2492, " ", "00:02:43.92", "00:02:46.14", "Runciter"),
	(2494, 2546, " ", "00:02:46.28", "00:02:49.72", "Clovis"),
	(2546, 2580, " ", "00:02:49.76", "00:02:52.04", "Clovis"),
	(2582, 2659, " ", "00:02:52.16", "00:02:57.30", "Runciter"),
	(2733, 2808, " ", "00:03:02.20", "00:03:07.24", "Clovis"),
	(2810, 2873, " ", "00:03:07.38", "00:03:11.54", "Runciter"),
	(2881, 2959, " ", "00:03:12.06", "00:03:17.26", "Clovis"),
	(2968, 3048, " ", "00:03:17.90", "00:03:23.18", "Dispatch"),
	(3049, 3106, " ", "00:03:23.30", "00:03:27.08", "McCoy (internal monologue)"),
	(3106, 3147, " ", "00:03:27.08", "00:03:29.84", "McCoy (internal monologue)"),
	(3147, 3184, " ", "00:03:29.84", "00:03:32.28", "McCoy (internal monologue)"),
	(3184, 3243, " ", "00:03:32.28", "00:03:36.24", "McCoy (internal monologue)"),
	(3480, 3554, " ", "00:03:52.02", "00:03:56.96", "Dispatch"),
	(3558, 3606, " ", "00:03:57.24", "00:04:00.38", "McCoy (internal monologue)"),
	(3606, 3676, " ", "00:04:00.38", "00:04:05.08", "McCoy (internal monologue)"),
	(3697, 3767, " ", "00:04:06.46", "00:04:11.12", "McCoy (internal monologue)"),
	(3767, 3812, " ", "00:04:11.12", "00:04:14.12", "McCoy, Guzza"),
	(3812, 3855, " ", "00:04:14.12", "00:04:16.98", "Guzza"),
	(3855, 3915, " ", "00:04:16.98", "00:04:21.04", "Guzza"),
	(3918, 3972, " ", "00:04:21.24", "00:04:24.84", "McCoy (internal monologue)"),
	(3974, 4001, " ", "00:04:24.92", "00:04:26.76", "McCoy (internal monologue)"),
	(4001, 4040, " ", "00:04:26.76", "00:04:29.34", "McCoy (internal monologue)"),
	(4042, 4078, " ", "00:04:29.44", "00:04:31.84", "Guzza"),
	(4078, 4123, " ", "00:04:31.84", "00:04:34.86", "Guzza"),
	(4127, 4161, " ", "00:04:35.14", "00:04:37.42", "McCoy, Guzza"),
	(4161, 4195, " ", "00:04:37.42", "00:04:39.70", "Guzza"),
	(4195, 4256, " ", "00:04:39.70", "00:04:43.76", "Guzza"),
	(4256, 4291, " ", "00:04:43.76", "00:04:46.08", "Guzza"),
	(4291, 4325, " ", "00:04:46.08", "00:04:48.34", "Guzza"),
	(4327, 4375, " ", "00:04:48.48", "00:04:51.70", "McCoy"),
	(4384, 4427, " ", "00:04:52.24", "00:04:55.14", "Guzza"),
	(4427, 4482, " ", "00:04:55.14", "00:04:58.82", "Guzza"),
	(4482, 4531, " ", "00:04:58.82", "00:05:02.04", "Guzza"),
	(4533, 4571, " ", "00:05:02.22", "00:05:04.74", "McCoy"),
	(4573, 4642, " ", "00:05:04.84", "00:05:09.50", "Guzza"),
	(4715, 4758, " ", "00:05:14.32", "00:05:17.22", "Steele"),
	(4762, 4799, " ", "00:05:17.50", "00:05:19.94", "McCoy"),
	(4801, 4846, " ", "00:05:20.08", "00:05:23.04", "Steele"),
	(4847, 4858, " ", "00:05:23.14", "00:05:23.84", "McCoy"),
	(4859, 4913, " ", "00:05:23.94", "00:05:27.54", "Steele"),
	(4913, 4950, " ", "00:05:27.54", "00:05:29.98", "Steele"),
	(4950, 4979, " ", "00:05:29.98", "00:05:31.96", "McCoy"),
	(4979, 5038, " ", "00:05:31.96", "00:05:35.88", "Steele"),
	(5038, 5068, " ", "00:05:35.88", "00:05:37.86", "Steele"),
	(5068, 5113, " ", "00:05:37.86", "00:05:40.84", "Steele"),
	(5114, 5135, " ", "00:05:40.94", "00:05:42.30", "McCoy"),
	(5135, 5181, " ", "00:05:42.34", "00:05:45.42", "Steele, McCoy"),
	(5183, 5224, " ", "00:05:45.50", "00:05:48.24", "Steele"),
	(5224, 5251, " ", "00:05:48.24", "00:05:50.04", "Steele"),
	(5251, 5281, " ", "00:05:50.04", "00:05:52.06", "Steele"),
	(5281, 5315, " ", "00:05:52.06", "00:05:54.34", "Steele"),
	(5315, 5357, " ", "00:05:54.34", "00:05:57.14", "Steele"),
	(5359, 5415, " ", "00:05:57.26", "00:06:01.00", "Steele, McCoy"),
	(5415, 5458, " ", "00:06:01.00", "00:06:03.84", "Steele"),
	(5465, 5494, " ", "00:06:04.30", "00:06:06.26", "Steele"),
	(5494, 5540, " ", "00:06:06.26", "00:06:09.36", "McCoy"),
	(5550, 5588, " ", "00:06:10.00", "00:06:12.56", "Steele")
]
##
MW_A_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(42, 98, " ", "00:00:02.86", "00:00:06.56", "Sadik, Eisenduller"),
	(98, 180, " ", "00:00:06.56", "00:00:12.00", "Sadik, Eisenduller"),
	(249, 294, " ", "00:00:16.62", "00:00:19.66", "Sadik"),
	(294, 366, " ", "00:00:19.66", "00:00:24.42", "Eisenduller"),
	(366, 392, " ", "00:00:24.42", "00:00:26.14", "Eisenduller"),
	(401, 463, " ", "00:00:26.76", "00:00:30.90", "Eisenduller"),
	(514, 564, " ", "00:00:34.28", "00:00:37.62", "Sadik"),
	(564, 623, " ", "00:00:37.62", "00:00:41.56", "Eisenduller"),
	(623, 658, " ", "00:00:41.56", "00:00:43.92", "Eisenduller"),
	(665, 737, " ", "00:00:44.34", "00:00:49.18", "Sadik, Eisenduller"),
	(737, 804, " ", "00:00:49.18", "00:00:53.64", "Eisenduller"),
	(804, 861, " ", "00:00:53.64", "00:00:57.42", "Sadik, Eisenduller"),
	(861, 889, " ", "00:00:57.42", "00:00:59.30", "Eisenduller"),
	(889, 962, " ", "00:00:59.32", "00:01:04.18", "Sadik"),
	(962, 1003, " ", "00:01:04.18", "00:01:06.90", "Eisenduller"),
	(1008, 1064, " ", "00:01:07.20", "00:01:10.94", "Sadik"),
	(1065, 1115, " ", "00:01:11.02", "00:01:14.34", "Sadik"),
	(1115, 1160, " ", "00:01:14.34", "00:01:17.38", "Sadik"),
	(1163, 1192, " ", "00:01:17.58", "00:01:19.48", "Eisenduller"),
	(1196, 1252, " ", "00:01:19.74", "00:01:23.46", "Eisenduller"),
	(1311, 1372, " ", "00:01:27.42", "00:01:31.50", "Sadik"),
	(1372, 1447, " ", "00:01:31.50", "00:01:36.50", "Sadik"),
	(1447, 1513, " ", "00:01:36.50", "00:01:40.90", "Eisenduller"),
	(1513, 1561, " ", "00:01:40.90", "00:01:44.08", "Sadik"),
	(1561, 1624, " ", "00:01:44.08", "00:01:48.28", "Eisenduller, Sadik"),
	(1624, 1674, " ", "00:01:48.28", "00:01:51.60", "Eisenduller"),
	(1674, 1725, " ", "00:01:51.60", "00:01:55.00", "Eisenduller"),
	(1725, 1747, " ", "00:01:55.00", "00:01:56.52", "Sadik"),
	(1747, 1837, " ", "00:01:56.52", "00:02:02.46", "Eisenduller"),
	(1861, 1963, " ", "00:02:04.06", "00:02:10.92", "Sadik, Eisenduller")
]
##
MW_B01_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(64, 110, " ", "00:00:04.00", "00:00:07.35", "Sadik, Clovis")
]
##
MW_B02_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(13, 98, " ", "00:00:01", "00:00:06.55", "Sadik"),
	(100, 153, " ", "00:00:07", "00:00:10.25", "Clovis"),
	(155, 239, " ", "00:00:10", "00:00:15.95", "Sadik")
]
##
MW_B03_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(1, 75, " ", "00:00:00", "00:00:05.00", "Sadik"),
	(76, 124, " ", "00:00:05", "00:00:08.30", "Clovis"),
	(127, 165, " ", "00:00:08", "00:00:11.04", "Sadik")
]
##
MW_B04_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(1, 75, " ", "00:00:00", "00:00:05.05", "Sadik"),
	(78, 145, " ", "00:00:05", "00:00:09.67", "Clovis"),
	(145, 221, " ", "00:00:10", "00:00:14.75", "Clovis"),
	(223, 269, " ", "00:00:15", "00:00:17.99", "Sadik")
]
##
MW_B05_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(8, 38, " ", "00:00:01", "00:00:02.54", "Clovis"),
	(39, 81, " ", "00:00:03", "00:00:05.44", "Sadik"),
	(83, 135, " ", "00:00:06", "00:00:09.02", "Clovis"),
	(135, 167, " ", "00:00:09", "00:00:11.14", "Sadik"),
	(168, 237, " ", "00:00:11", "00:00:15.84", "Clovis"),
	(241, 285, " ", "00:00:16", "00:00:19.04", "Sadik"),
	(287, 345, " ", "00:00:19", "00:00:23.02", "Clovis"),
	(345, 414, " ", "00:00:23", "00:00:27.60", "Clovis"),
	(610, 648, " ", "00:00:41", "00:00:43.22", "Lucy"),
	(802, 836, " ", "00:00:53", "00:00:55.74", "McCoy"),
	(838, 912, " ", "00:00:56", "00:01:00.80", "Lucy, McCoy"),
	(912, 954, " ", "00:01:01", "00:01:03.64", "McCoy"),
	(956, 1035, " ", "00:01:04", "00:01:09.00", "Lucy"),
	(1035, 1098, " ", "00:01:09", "00:01:13.24", "Lucy"),
	(1101, 1128, " ", "00:01:13", "00:01:15.24", "McCoy"),
	(1130, 1221, " ", "00:01:15", "00:01:21.44", "Lucy"),
	(1223, 1271, " ", "00:01:22", "00:01:24.74", "McCoy"),
	(1278, 1329, " ", "00:01:25", "00:01:28.64", "Lucy"),
	(1332, 1365, " ", "00:01:29", "00:01:31.04", "McCoy, Lucy"),
	(1365, 1392, " ", "00:01:31", "00:01:32.82", "Lucy"),
	(1392, 1428, " ", "00:01:33", "00:01:35.24", "McCoy"),
	(1431, 1475, " ", "00:01:35", "00:01:38.34", "Lucy"),
	(1476, 1528, " ", "00:01:38", "00:01:41.92", "McCoy"),
	(1566, 1604, " ", "00:01:44", "00:01:46.98", "Lucy")
]
##
INTRGT_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(130, 192, " ", "00:00:09", "00:00:12.85", "Mainframe"),
	(192, 248, " ", "00:00:13", "00:00:16.55", "Mainframe"),
	(248, 272, " ", "00:00:17", "00:00:18.19", "Mainframe"),
	(272, 324, " ", "00:00:18", "00:00:21.65", "Mainframe"),
	(324, 357, " ", "00:00:22", "00:00:23.85", "Mainframe"),
	(359, 397, " ", "00:00:24", "00:00:26.49", "Baker"),
	(397, 468, " ", "00:00:26", "00:00:31.25", "Baker"),
	(470, 512, " ", "00:00:31", "00:00:34.15", "McCoy"),
	(514, 551, " ", "00:00:34", "00:00:36.75", "Baker"),
	(553, 603, " ", "00:00:37", "00:00:40.25", "McCoy"),
	(606, 631, " ", "00:00:40", "00:00:42.11", "Baker"),
	(631, 684, " ", "00:00:42", "00:00:45.65", "Baker"),
	(686, 704, " ", "00:00:46", "00:00:46.95", "Holloway"),
	(706, 743, " ", "00:00:47", "00:00:49.55", "McCoy"),
	(744, 819, " ", "00:00:50", "00:00:54.61", "Baker"),
	(835, 869, " ", "00:00:56", "00:00:57.95", "McCoy"),
	(871, 916, " ", "00:00:58", "00:01:01.11", "Baker"),
	(918, 957, " ", "00:01:01", "00:01:03.85", "McCoy"),
	(960, 1042, " ", "00:01:04", "00:01:09.49", "Baker"),
	(1042, 1081, " ", "00:01:09", "00:01:12.11", "Baker"),
	(1081, 1108, " ", "00:01:12", "00:01:13.89", "Baker"),
	(1108, 1148, " ", "00:01:14", "00:01:16.55", "Baker"),
	(1149, 1191, " ", "00:01:17", "00:01:19.43", "McCoy"),
	(1192, 1233, " ", "00:01:19", "00:01:22.23", "Holloway"),
	(1233, 1276, " ", "00:01:22", "00:01:25.09", "Baker"),
	(1276, 1343, " ", "00:01:25", "00:01:29.55", "Baker"),
	(1343, 1385, " ", "00:01:30", "00:01:32.35", "Baker"),
	(1385, 1432, " ", "00:01:32", "00:01:35.47", "Baker"),
	(1432, 1465, " ", "00:01:35", "00:01:37.71", "Baker"),
	(1465, 1500, " ", "00:01:38", "00:01:40.05", "Baker"),
	(1503, 1554, " ", "00:01:40", "00:01:43.65", "McCoy"),
	(1557, 1638, " ", "00:01:44", "00:01:49.23", "Baker"),
	(1638, 1680, " ", "00:01:49", "00:01:52.05", "Baker"),
	(1680, 1727, " ", "00:01:52", "00:01:55.13", "Baker"),
	(1739, 1807, " ", "00:01:56", "00:02:00.49", "Baker"),
	(1807, 1836, " ", "00:02:00", "00:02:02.43", "Baker"),
	(1836, 1914, " ", "00:02:02", "00:02:07.63", "Baker"),
	(2003, 2060, " ", "00:02:14", "00:02:17.33", "Steele"),
	(2189, 2223, " ", "00:02:26", "00:02:28.25", "McCoy"),
	(2226, 2244, " ", "00:02:28", "00:02:29.61", "Steele"),
	(2244, 2302, " ", "00:02:30", "00:02:33.49", "Steele")
]
##
MW_C01_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(167, 201, " ", "00:00:11", "00:00:13.42", "Luther"),
	(201, 257, " ", "00:00:13", "00:00:17.18", "Lance"),
	(261, 316, " ", "00:00:17", "00:00:21.10", "Luther"),
	(338, 351, " ", "00:00:23", "00:00:23.40", "Lance"),
	(352, 364, " ", "00:00:24", "00:00:24.30", "Luther"),
	(366, 379, " ", "00:00:24", "00:00:25.30", "Lance"),
	(381, 402, " ", "00:00:25", "00:00:26.82", "Luther"),
	(427, 462, " ", "00:00:28", "00:00:30.84", "Answering Machine"),
	(478, 499, " ", "00:00:32", "00:00:33.30", "Lance"),
	(501, 547, " ", "00:00:33", "00:00:36.52", "Clovis"),
	(547, 582, " ", "00:00:37", "00:00:38.80", "Luther"),
	(583, 608, " ", "00:00:39", "00:00:40.56", "Clovis"),
	(617, 673, " ", "00:00:41", "00:00:44.90", "Lance"),
	(675, 709, " ", "00:00:45", "00:00:47.30", "Luther"),
	(709, 738, " ", "00:00:47", "00:00:49.26", "Luther"),
	(738, 762, " ", "00:00:49", "00:00:50.80", "Luther"),
	(764, 798, " ", "00:00:51", "00:00:53.22", "Lance"),
	(798, 846, " ", "00:00:53", "00:00:56.40", "Lance"),
	(903, 942, " ", "00:01:00", "00:01:02.86", "Sadik"),
	(942, 975, " ", "00:01:03", "00:01:05.04", "Lance, Luther"),
	(975, 1019, " ", "00:01:05", "00:01:07.98", "Lance, Luther"),
	(1074, 1098, " ", "00:01:12", "00:01:13.24", "Clovis"),
	(1098, 1132, " ", "00:01:13", "00:01:15.50", "Clovis"),
	(1134, 1178, " ", "00:01:16", "00:01:18.54", "Luther"),
	(1178, 1219, " ", "00:01:19", "00:01:21.30", "Luther"),
	(1222, 1256, " ", "00:01:22", "00:01:23.78", "Sadik"),
	(1258, 1277, " ", "00:01:24", "00:01:25.16", "Luther"),
	(1277, 1306, " ", "00:01:25", "00:01:27.08", "Lance"),
	(1397, 1462, " ", "00:01:33", "00:01:37.52", "Clovis"),
	(1496, 1523, " ", "00:01:40", "00:01:41.54", "Luther"),
	(1523, 1570, " ", "00:01:42", "00:01:44.72", "Luther"),
	(1570, 1583, " ", "00:01:45", "00:01:45.58", "Lance"),
	(1583, 1633, " ", "00:01:46", "00:01:48.90", "Luther"),
	(1635, 1677, " ", "00:01:49", "00:01:51.84", "Clovis"),
	(1677, 1693, " ", "00:01:52", "00:01:52.90", "Clovis"),
	(1695, 1743, " ", "00:01:53", "00:01:56.22", "Luther"),
	(1745, 1780, " ", "00:01:56", "00:01:58.70", "Clovis"),
	(1782, 1795, " ", "00:01:59", "00:01:59.68", "Lance"),
	(1795, 1822, " ", "00:02:00", "00:02:01.50", "Luther")
]
##
MW_C02_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(1, 26, " ", "00:00:00", "00:00:01.80", "Clovis"),
	(26, 72, " ", "00:00:02", "00:00:04.84", "Clovis"),
	(81, 122, " ", "00:00:05", "00:00:08.14", "Clovis"),
	(122, 186, " ", "00:00:08", "00:00:12.44", "Clovis"),
	(210, 267, " ", "00:00:14", "00:00:17.84", "Luther, Lance"),
	(278, 330, " ", "00:00:19", "00:00:22.02", "Clovis")
]
##
MW_C03_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(1, 26, " ", "00:00:00", "00:00:01.74", "Clovis"),
	(26, 72, " ", "00:00:02", "00:00:04.84", "Clovis"),
	(81, 122, " ", "00:00:05", "00:00:08.18", "Clovis"),
	(122, 186, " ", "00:00:08", "00:00:12.40", "Clovis"),
	(210, 267, " ", "00:00:14", "00:00:17.82", "Luther, Lance"),
	(278, 330, " ", "00:00:19", "00:00:22.01", "Clovis")
]
##
MW_D_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(21, 91, " ", "00:00:01", "00:00:06.13", "Governor Kolvig"),
	(91, 149, " ", "00:00:06", "00:00:09.99", "Eldon Tyrell"),
	(149, 192, " ", "00:00:10", "00:00:12.83", "Eldon Tyrell"),
	(192, 254, " ", "00:00:13", "00:00:16.99", "Eldon Tyrell"),
	(254, 283, " ", "00:00:17", "00:00:18.91", "Eldon Tyrell"),
	(285, 329, " ", "00:00:19", "00:00:21.99", "Governor Kolvig"),
	(329, 401, " ", "00:00:22", "00:00:26.75", "Eldon Tyrell"),
	(401, 422, " ", "00:00:27", "00:00:28.15", "Eldon Tyrell"),
	(424, 469, " ", "00:00:28", "00:00:31.31", "Governor Kolvig"),
	(471, 512, " ", "00:00:31", "00:00:34.13", "Eldon Tyrell"),
	(512, 586, " ", "00:00:34", "00:00:39.11", "Eldon Tyrell"),
	(586, 669, " ", "00:00:39", "00:00:44.61", "Eldon Tyrell"),
	(669, 694, " ", "00:00:45", "00:00:46.31", "Eldon Tyrell"),
	(697, 763, " ", "00:00:46", "00:00:50.91", "Governor Kolvig"),
	(766, 817, " ", "00:00:51", "00:00:54.51", "Eldon Tyrell"),
	(817, 876, " ", "00:00:55", "00:00:58.41", "Eldon Tyrell"),
	(878, 918, " ", "00:00:59", "00:01:01.21", "Clovis"),
	(920, 945, " ", "00:01:01", "00:01:03.01", "Governor Kolvig"),
	(947, 1005, " ", "00:01:03", "00:01:07.01", "Eldon Tyrell"),
	(1005, 1041, " ", "00:01:07", "00:01:09.41", "Eldon Tyrell"),
	(1042, 1057, " ", "00:01:10", "00:01:10.51", "Clovis"),
	(1058, 1080, " ", "00:01:11", "00:01:12.03", "Governor Kolvig"),
	(1090, 1112, " ", "00:01:13", "00:01:14.19", "Clovis"),
	(1114, 1135, " ", "00:01:14", "00:01:15.71", "Governor Kolvig"),
	(1137, 1186, " ", "00:01:16", "00:01:19.11", "Clovis"),
	(1188, 1220, " ", "00:01:19", "00:01:21.39", "Governor Kolvig"),
	(1227, 1255, " ", "00:01:22", "00:01:23.71", "Eldon Tyrell"),
	(1257, 1300, " ", "00:01:24", "00:01:26.67", "Clovis"),
	(1300, 1327, " ", "00:01:27", "00:01:28.51", "Clovis"),
	(1330, 1378, " ", "00:01:29", "00:01:31.91", "Eldon Tyrell"),
	(1381, 1405, " ", "00:01:32", "00:01:33.71", "Clovis"),
	(1408, 1446, " ", "00:01:34", "00:01:36.41", "Eldon Tyrell"),
	(1446, 1525, " ", "00:01:36", "00:01:41.71", "Eldon Tyrell"),
	(1527, 1632, " ", "00:01:42", "00:01:48.79", "Clovis"),
	(1632, 1672, " ", "00:01:49", "00:01:51.51", "Clovis"),
	(1674, 1752, " ", "00:01:52", "00:01:56.81", "Eldon Tyrell"),
	(1758, 1807, " ", "00:01:57", "00:02:00.47", "Clovis"),
	(1807, 1870, " ", "00:02:00", "00:02:04.67", "Clovis"),
	(1984, 2052, " ", "00:02:12", "00:02:16.83", "Eldon Tyrell"),
	(2190, 2251, " ", "00:02:26", "00:02:30.11", "Eldon Tyrell"),
	(2254, 2301, " ", "00:02:30", "00:02:33.41", "Security Guard"),
	(2303, 2342, " ", "00:02:34", "00:02:36.17", "Eldon Tyrell"),
	(2342, 2387, " ", "00:02:36", "00:02:39.17", "Eldon Tyrell")
]
##
END01A_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(30, 125, " ", "00:00:02", "00:00:08.37", "Mainframe"),
	(125, 223, " ", "00:00:08", "00:00:14.87", "Mainframe")
]
##
END01B_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(22, 85, " ", "00:00:01", "00:00:05.72", "Mainframe"),
	(85, 172, " ", "00:00:06", "00:00:11.52", "Mainframe"),
	(172, 211, " ", "00:00:12", "00:00:14.08", "Mainframe"),
	(211, 253, " ", "00:00:14", "00:00:16.92", "Mainframe"),
	(253, 328, " ", "00:00:17", "00:00:21.90", "Mainframe"),
	(328, 394, " ", "00:00:22", "00:00:26.32", "Mainframe"),
	(394, 468, " ", "00:00:26", "00:00:31.26", "Mainframe")
]
##
END01C_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(28, 89, " ", "00:00:02", "00:00:05.97", "Mainframe"),
	(89, 176, " ", "00:00:06", "00:00:11.79", "Mainframe"),
	(176, 232, " ", "00:00:12", "00:00:15.53", "Mainframe"),
	(232, 272, " ", "00:00:16", "00:00:18.19", "Mainframe"),
	(272, 332, " ", "00:00:18", "00:00:22.17", "Mainframe"),
	(332, 372, " ", "00:00:22", "00:00:24.85", "Mainframe"),
	(372, 456, " ", "00:00:25", "00:00:30.43", "Mainframe")
]
##
END01D_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(30, 125, " ", "00:00:02", "00:00:08.35", "Mainframe"),
	(125, 222, " ", "00:00:08", "00:00:14.83", "Mainframe")
]
##
END01E_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(21, 84, " ", "00:00:01", "00:00:05.64", "Mainframe"),
	(84, 171, " ", "00:00:06", "00:00:11.42", "Mainframe"),
	(171, 209, " ", "00:00:11", "00:00:13.94", "Mainframe"),
	(209, 252, " ", "00:00:14", "00:00:16.82", "Mainframe"),
	(252, 327, " ", "00:00:17", "00:00:21.84", "Mainframe"),
	(327, 394, " ", "00:00:22", "00:00:26.28", "Mainframe"),
	(394, 460, " ", "00:00:26", "00:00:30.70", "Mainframe")
]
##
END01F_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(28, 92, " ", "00:00:02", "00:00:06.16", "Mainframe"),
	(92, 178, " ", "00:00:06", "00:00:11.90", "Mainframe"),
	(178, 233, " ", "00:00:12", "00:00:15.58", "Mainframe"),
	(233, 273, " ", "00:00:16", "00:00:18.22", "Mainframe"),
	(273, 333, " ", "00:00:18", "00:00:22.20", "Mainframe"),
	(333, 376, " ", "00:00:22", "00:00:25.08", "Mainframe"),
	(376, 465, " ", "00:00:25", "00:00:31.02", "Mainframe")
]
##
END03_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(8, 53, " ", "00:00:01", "00:00:03.55", "Mainframe"),
	(53, 82, " ", "00:00:04", "00:00:05.51", "Mainframe"),
	(82, 124, " ", "00:00:06", "00:00:08.29", "Mainframe"),
	(124, 147, " ", "00:00:08", "00:00:09.85", "Mainframe"),
	(147, 176, " ", "00:00:10", "00:00:11.77", "Mainframe"),
	(176, 211, " ", "00:00:12", "00:00:14.11", "Mainframe"),
	(211, 242, " ", "00:00:14", "00:00:16.17", "Mainframe"),
	(242, 308, " ", "00:00:16", "00:00:20.55", "Mainframe"),
	(308, 396, " ", "00:00:21", "00:00:26.45", "Mainframe")
]
##
END04A_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(6, 31, " ", "00:00:00", "00:00:02.13", "McCoy"),
	(40, 72, " ", "00:00:03", "00:00:04.81", "Clovis"),
	(72, 116, " ", "00:00:05", "00:00:07.79", "Clovis")
]
##
END04B_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(28, 97, " ", "00:00:02", "00:00:06.48", "Lucy")
]
##
END04C_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(27, 115, " ", "00:00:02", "00:00:07.68", "Dektora")
]
##
END06_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(5, 30, " ", "00:00:00", "00:00:02.00", "Steele, McCoy"),
	(32, 75, " ", "00:00:02", "00:00:05.06", "Steele"),
	(76, 109, " ", "00:00:05", "00:00:07.30", "McCoy"),
	(111, 142, " ", "00:00:07", "00:00:09.50", "Steele"),
	(146, 174, " ", "00:00:10", "00:00:11.60", "McCoy"),
	(175, 226, " ", "00:00:12", "00:00:15.10", "Steele")
]
##
TB_FLY_VQA_TEXT_RESOURCE_TUPLE_LIST = [
	(11, 50, " ", "00:00:01", "00:00:03.37", "Blimp Guy")
]
##
##
##
ALL_VQA_TEXT_RESOURCES_LISTS = [
	("WSTLGO_", WSTLGO_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("BRLOGO_", BRLOGO_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("INTRO_",  INTRO_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_A_",   MW_A_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_B01_", MW_B01_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_B02_", MW_B02_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_B03_", MW_B03_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_B04_", MW_B04_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_B05_", MW_B05_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("INTRGT_", INTRGT_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_C01_", MW_C01_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_C02_", MW_C02_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_C03_", MW_C03_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("MW_D_",   MW_D_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01A_", END01A_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01B_", END01B_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01C_", END01C_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01D_", END01D_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01E_", END01E_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END01F_", END01F_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END03_",  END03_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END04A_", END04A_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END04B_", END04B_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END04C_", END04C_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("END06_",  END06_VQA_TEXT_RESOURCE_TUPLE_LIST),
	("TB_FLY_", TB_FLY_VQA_TEXT_RESOURCE_TUPLE_LIST)
]
#
#
#
class vqasTextResource(object):
	m_traceModeEnabled = True
	# traceModeEnabled is bool to enable more printed debug messages
	def __init__(self, traceModeEnabled = True):
		self.m_traceModeEnabled = traceModeEnabled
		return

	def printAllVqasTextResource(self):
		if self.m_traceModeEnabled:
			print "[Trace] printing all VQAs Text"
		for (vqaKeyStr, vqaTreList) in ALL_VQA_TEXT_RESOURCES_LISTS:
			print "VQA prefix: %s" % (vqaKeyStr)
			for (startFrameTre, endFrameTre, textTre, timeStartTre, timeEndTre, byActorTre) in vqaTreList:
				print "%s\t%s\t%s\t%s\t%s\t%s" % (startFrameTre, endFrameTre, textTre, timeStartTre, timeEndTre, byActorTre)
		return

	def getVqaEntriesList(self, sVQASheetPrefix):
		if self.m_traceModeEnabled:
			print "[Trace] getVqaEntriesList()"
		for (vqaKeyStr, vqaTreList) in ALL_VQA_TEXT_RESOURCES_LISTS:
			if (vqaKeyStr == sVQASheetPrefix.upper()):
				return vqaTreList
		return None
#
#
#
if __name__ == '__main__':
	# main()
	print "[Debug] Running %s as main module" % (my_module_name)
	traceModeEnabled = False
	vqaTRInstance = vqasTextResource(traceModeEnabled)
	vqaTRInstance.printAllVqasTextResource()
else:
	#debug
	#print "[Debug] Running	 %s imported from another module" % (my_module_name)
	pass
